/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.json;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.json.JsonOutputWriter;
import org.apache.spark.sql.execution.datasources.v2.FileWriteBuilder;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Q4Aa\u0002\u0005\u00013!Aa\u0004\u0001B\u0001B\u0003%q\u0004\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011!a\u0004A!A!\u0002\u0013!\u0004\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u000b-\u0003A\u0011\u0001'\t\u000bM\u0003A\u0011\t+\u0003!)\u001bxN\\,sSR,')^5mI\u0016\u0014(BA\u0005\u000b\u0003\u0011Q7o\u001c8\u000b\u0005-a\u0011A\u0001<3\u0015\tia\"A\u0006eCR\f7o\\;sG\u0016\u001c(BA\b\u0011\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0012%\u0005\u00191/\u001d7\u000b\u0005M!\u0012!B:qCJ\\'BA\u000b\u0017\u0003\u0019\t\u0007/Y2iK*\tq#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00015A\u00111\u0004H\u0007\u0002\u0015%\u0011QD\u0003\u0002\u0011\r&dWm\u0016:ji\u0016\u0014U/\u001b7eKJ\fqa\u001c9uS>t7\u000f\u0005\u0002!G5\t\u0011E\u0003\u0002#!\u0005!Q\u000f^5m\u0013\t!\u0013E\u0001\rDCN,\u0017J\\:f]NLG/\u001b<f'R\u0014\u0018N\\4NCB\fQ\u0001]1uQN\u00042aJ\u00195\u001d\tAcF\u0004\u0002*Y5\t!F\u0003\u0002,1\u00051AH]8pizJ\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_A\nq\u0001]1dW\u0006<WMC\u0001.\u0013\t\u00114GA\u0002TKFT!a\f\u0019\u0011\u0005UJdB\u0001\u001c8!\tI\u0003'\u0003\u00029a\u00051\u0001K]3eK\u001aL!AO\u001e\u0003\rM#(/\u001b8h\u0015\tA\u0004'\u0001\u0006g_Jl\u0017\r\u001e(b[\u0016\f\u0001c];qa>\u0014Ho\u001d#bi\u0006$\u0016\u0010]3\u0011\t}\u0002%\tS\u0007\u0002a%\u0011\u0011\t\r\u0002\n\rVt7\r^5p]F\u0002\"a\u0011$\u000e\u0003\u0011S!!\u0012\t\u0002\u000bQL\b/Z:\n\u0005\u001d#%\u0001\u0003#bi\u0006$\u0016\u0010]3\u0011\u0005}J\u0015B\u0001&1\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtD#B'P!F\u0013\u0006C\u0001(\u0001\u001b\u0005A\u0001\"\u0002\u0010\u0006\u0001\u0004y\u0002\"B\u0013\u0006\u0001\u00041\u0003\"\u0002\u001f\u0006\u0001\u0004!\u0004\"B\u001f\u0006\u0001\u0004q\u0014\u0001\u00049sKB\f'/Z,sSR,G#B+ZC.|\u0007C\u0001,X\u001b\u0005a\u0011B\u0001-\r\u0005MyU\u000f\u001e9vi^\u0013\u0018\u000e^3s\r\u0006\u001cGo\u001c:z\u0011\u0015Qf\u00011\u0001\\\u0003\u001d\u0019\u0018\u000f\\\"p]\u001a\u0004\"\u0001X0\u000e\u0003uS!A\u0018\t\u0002\u0011%tG/\u001a:oC2L!\u0001Y/\u0003\u000fM\u000bFjQ8oM\")!M\u0002a\u0001G\u0006\u0019!n\u001c2\u0011\u0005\u0011LW\"A3\u000b\u0005\u0019<\u0017!C7baJ,G-^2f\u0015\tAG#\u0001\u0004iC\u0012|w\u000e]\u0005\u0003U\u0016\u00141AS8c\u0011\u0015qb\u00011\u0001m!\u0011)T\u000e\u000e\u001b\n\u00059\\$aA'ba\")\u0001O\u0002a\u0001c\u0006QA-\u0019;b'\u000eDW-\\1\u0011\u0005\r\u0013\u0018BA:E\u0005)\u0019FO];diRK\b/\u001a")
public class JsonWriteBuilder
extends FileWriteBuilder {
    @Override
    public OutputWriterFactory prepareWrite(SQLConf sqlConf, Job job, Map<String, String> options, StructType dataSchema) {
        Configuration conf = job.getConfiguration();
        JSONOptions parsedOptions = new JSONOptions(options, sqlConf.sessionLocalTimeZone(), sqlConf.columnNameOfCorruptRecord());
        parsedOptions.compressionCodec().foreach((Function1 & Serializable & scala.Serializable)codec -> {
            CompressionCodecs$.MODULE$.setCodecConfiguration(conf, codec);
            return BoxedUnit.UNIT;
        });
        return new OutputWriterFactory(null, parsedOptions){
            private final JSONOptions parsedOptions$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new JsonOutputWriter(path, this.parsedOptions$1, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(5).append(".json").append(CodecStreams$.MODULE$.getCompressionExtension((JobContext)context)).toString();
            }
            {
                this.parsedOptions$1 = parsedOptions$1;
            }
        };
    }

    public JsonWriteBuilder(CaseInsensitiveStringMap options, Seq<String> paths, String formatName, Function1<DataType, Object> supportsDataType) {
        super(options, paths, formatName, supportsDataType);
    }
}

