/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.FileCommitProtocol$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.connector.write.streaming.StreamingWrite;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker$;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.WriteJobDescription;
import org.apache.spark.sql.execution.datasources.WriteJobStatsTracker;
import org.apache.spark.sql.execution.datasources.v2.FileBatchWrite;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.sql.util.SchemaUtils$;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf!B\f\u0019\u0003\u00039\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u0011}\u0002!\u0011!Q\u0001\n\u0001C\u0001B\u0016\u0001\u0003\u0002\u0003\u0006IA\u0014\u0005\t/\u0002\u0011\t\u0011)A\u00051\")Q\r\u0001C\u0001M\"IQ\u000e\u0001a\u0001\u0002\u0004%IA\u001c\u0005\ne\u0002\u0001\r\u00111A\u0005\nMD\u0011\"\u001f\u0001A\u0002\u0003\u0005\u000b\u0015B8\t\u0013i\u0004\u0001\u0019!a\u0001\n\u0013Y\b\"\u0003?\u0001\u0001\u0004\u0005\r\u0011\"\u0003~\u0011%y\b\u00011A\u0001B\u0003&a\nC\u0006\u0002\u0002\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0001bCA\u0007\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001fA1\"a\u0005\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0006!9\u0011Q\u0003\u0001\u0005B\u0005]\u0001bBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003\u0003\u0001A\u0011AA\u0011\u0011\u001d\t)\u0003\u0001C!\u0003OAq!a\f\u0001\r\u0003\t\t\u0004C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005M\u0004\u0001\"\u0003\u0002v!9\u0011q\u0013\u0001\u0005\n\u0005e%\u0001\u0005$jY\u0016<&/\u001b;f\u0005VLG\u000eZ3s\u0015\tI\"$\u0001\u0002we)\u00111\u0004H\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u001e=\u0005IQ\r_3dkRLwN\u001c\u0006\u0003?\u0001\n1a]9m\u0015\t\t#%A\u0003ta\u0006\u00148N\u0003\u0002$I\u00051\u0011\r]1dQ\u0016T\u0011!J\u0001\u0004_J<7\u0001A\n\u0004\u0001!\u0002\u0004CA\u0015/\u001b\u0005Q#BA\u0016-\u0003\u0011a\u0017M\\4\u000b\u00035\nAA[1wC&\u0011qF\u000b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014!B<sSR,'BA\u001b\u001f\u0003%\u0019wN\u001c8fGR|'/\u0003\u00028e\taqK]5uK\n+\u0018\u000e\u001c3fe\u00069q\u000e\u001d;j_:\u001c\bC\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u001f\u0003\u0011)H/\u001b7\n\u0005yZ$\u0001G\"bg\u0016Len]3og&$\u0018N^3TiJLgnZ'ba\u0006)\u0001/\u0019;igB\u0019\u0011i\u0013(\u000f\u0005\tCeBA\"G\u001b\u0005!%BA#'\u0003\u0019a$o\\8u}%\tq)A\u0003tG\u0006d\u0017-\u0003\u0002J\u0015\u00069\u0001/Y2lC\u001e,'\"A$\n\u00051k%aA*fc*\u0011\u0011J\u0013\t\u0003\u001fNs!\u0001U)\u0011\u0005\rS\u0015B\u0001*K\u0003\u0019\u0001&/\u001a3fM&\u0011A+\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005IS\u0015A\u00034pe6\fGOT1nK\u0006\u00012/\u001e9q_J$8\u000fR1uCRK\b/\u001a\t\u00053jc&-D\u0001K\u0013\tY&JA\u0005Gk:\u001cG/[8ocA\u0011Q\fY\u0007\u0002=*\u0011qLH\u0001\u0006if\u0004Xm]\u0005\u0003Cz\u0013\u0001\u0002R1uCRK\b/\u001a\t\u00033\u000eL!\u0001\u001a&\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"RaZ5kW2\u0004\"\u0001\u001b\u0001\u000e\u0003aAQ\u0001O\u0003A\u0002eBQaP\u0003A\u0002\u0001CQAV\u0003A\u00029CQaV\u0003A\u0002a\u000baa]2iK6\fW#A8\u0011\u0005u\u0003\u0018BA9_\u0005)\u0019FO];diRK\b/Z\u0001\u000bg\u000eDW-\\1`I\u0015\fHC\u0001;x!\tIV/\u0003\u0002w\u0015\n!QK\\5u\u0011\u001dAx!!AA\u0002=\f1\u0001\u001f\u00132\u0003\u001d\u00198\r[3nC\u0002\nq!];fefLE-F\u0001O\u0003-\tX/\u001a:z\u0013\u0012|F%Z9\u0015\u0005Qt\bb\u0002=\u000b\u0003\u0003\u0005\rAT\u0001\tcV,'/_%eA\u0005!Qn\u001c3f+\t\t)\u0001\u0005\u0003\u0002\b\u0005%Q\"\u0001\u0010\n\u0007\u0005-aD\u0001\u0005TCZ,Wj\u001c3f\u0003!iw\u000eZ3`I\u0015\fHc\u0001;\u0002\u0012!A\u00010DA\u0001\u0002\u0004\t)!A\u0003n_\u0012,\u0007%A\nxSRD\u0017J\u001c9vi\u0012\u000bG/Y*dQ\u0016l\u0017\rF\u00021\u00033AQ!\\\bA\u0002=\f1b^5uQF+XM]=JIR\u0019\u0001'a\b\t\u000bi\u0004\u0002\u0019\u0001(\u0015\u0007A\n\u0019\u0003C\u0004\u0002\u0002E\u0001\r!!\u0002\u0002\u001b\t,\u0018\u000e\u001c3G_J\u0014\u0015\r^2i)\t\tI\u0003E\u00022\u0003WI1!!\f3\u0005)\u0011\u0015\r^2i/JLG/Z\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\u000b\u0003g\tY$a\u0013\u0002`\u0005\u001d\u0004\u0003BA\u001b\u0003oi\u0011AG\u0005\u0004\u0003sQ\"aE(viB,Ho\u0016:ji\u0016\u0014h)Y2u_JL\bbBA\u001f'\u0001\u0007\u0011qH\u0001\bgFd7i\u001c8g!\u0011\t\t%a\u0012\u000e\u0005\u0005\r#bAA#=\u0005A\u0011N\u001c;fe:\fG.\u0003\u0003\u0002J\u0005\r#aB*R\u0019\u000e{gN\u001a\u0005\b\u0003\u001b\u001a\u0002\u0019AA(\u0003\rQwN\u0019\t\u0005\u0003#\nY&\u0004\u0002\u0002T)!\u0011QKA,\u0003%i\u0017\r\u001d:fIV\u001cWMC\u0002\u0002Z\t\na\u0001[1e_>\u0004\u0018\u0002BA/\u0003'\u00121AS8c\u0011\u0019A4\u00031\u0001\u0002bA)q*a\u0019O\u001d&\u0019\u0011QM+\u0003\u00075\u000b\u0007\u000f\u0003\u0004\u0002jM\u0001\ra\\\u0001\u000bI\u0006$\u0018mU2iK6\f\u0017A\u0004<bY&$\u0017\r^3J]B,Ho\u001d\u000b\u0004i\u0006=\u0004BBA9)\u0001\u0007!-A\u000bdCN,7+\u001a8tSRLg/Z!oC2L8/[:\u0002\u001d\u001d,GOS8c\u0013:\u001cH/\u00198dKR1\u0011qJA<\u0003\u000fCq!!\u001f\u0016\u0001\u0004\tY(\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004B!! \u0002\u00046\u0011\u0011q\u0010\u0006\u0005\u0003\u0003\u000b9&\u0001\u0003d_:4\u0017\u0002BAC\u0003\u007f\u0012QbQ8oM&<WO]1uS>t\u0007bBAE+\u0001\u0007\u00111R\u0001\u0005a\u0006$\b\u000e\u0005\u0003\u0002\u000e\u0006MUBAAH\u0015\u0011\t\t*a\u0016\u0002\u0005\u0019\u001c\u0018\u0002BAK\u0003\u001f\u0013A\u0001U1uQ\u0006I2M]3bi\u0016<&/\u001b;f\u0015>\u0014G)Z:de&\u0004H/[8o)1\tY*!)\u0002,\u00065\u0016qVAZ!\u0011\t)$!(\n\u0007\u0005}%DA\nXe&$XMS8c\t\u0016\u001c8M]5qi&|g\u000eC\u0004\u0002$Z\u0001\r!!*\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\t\u0005\u001d\u0011qU\u0005\u0004\u0003Ss\"\u0001D*qCJ\\7+Z:tS>t\u0007bBA=-\u0001\u0007\u00111\u0010\u0005\b\u0003\u001b2\u0002\u0019AA(\u0011\u0019\t\tL\u0006a\u0001\u001d\u0006A\u0001/\u0019;i\u001d\u0006lW\r\u0003\u00049-\u0001\u0007\u0011\u0011\r")
public abstract class FileWriteBuilder
implements WriteBuilder {
    private final CaseInsensitiveStringMap options;
    private final Seq<String> paths;
    private final String formatName;
    private final Function1<DataType, Object> supportsDataType;
    private StructType schema;
    private String queryId;
    private SaveMode mode;

    public StreamingWrite buildForStreaming() {
        return super.buildForStreaming();
    }

    private StructType schema() {
        return this.schema;
    }

    private void schema_$eq(StructType x$1) {
        this.schema = x$1;
    }

    private String queryId() {
        return this.queryId;
    }

    private void queryId_$eq(String x$1) {
        this.queryId = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private void mode_$eq(SaveMode x$1) {
        this.mode = x$1;
    }

    public WriteBuilder withInputDataSchema(StructType schema) {
        this.schema_$eq(schema);
        return this;
    }

    public WriteBuilder withQueryId(String queryId) {
        this.queryId_$eq(queryId);
        return this;
    }

    public WriteBuilder mode(SaveMode mode) {
        this.mode_$eq(mode);
        return this;
    }

    public BatchWrite buildForBatch() {
        FileBatchWrite fileBatchWrite;
        LazyRef description$lzy = new LazyRef();
        SparkSession sparkSession = SparkSession$.MODULE$.active();
        this.validateInputs(sparkSession.sessionState().conf().caseSensitiveAnalysis());
        Path path = new Path((String)this.paths.head());
        scala.collection.immutable.Map caseSensitiveMap = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.options.asCaseSensitiveMap()).asScala()).toMap(Predef$.MODULE$.$conforms());
        Configuration hadoopConf = sparkSession.sessionState().newHadoopConfWithOptions((scala.collection.immutable.Map<String, String>)caseSensitiveMap);
        Job job = this.getJobInstance(hadoopConf, path);
        FileCommitProtocol committer = FileCommitProtocol$.MODULE$.instantiate(sparkSession.sessionState().conf().fileCommitProtocolClass(), UUID.randomUUID().toString(), (String)this.paths.head(), FileCommitProtocol$.MODULE$.instantiate$default$4());
        FileSystem fs = path.getFileSystem(hadoopConf);
        SaveMode saveMode = this.mode();
        if (((Object)((Object)SaveMode.ErrorIfExists)).equals((Object)saveMode) && fs.exists(path)) {
            Path qualifiedOutputPath = path.makeQualified(fs.getUri(), fs.getWorkingDirectory());
            throw new AnalysisException(new StringBuilder(21).append("path ").append(qualifiedOutputPath).append(" already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (((Object)((Object)SaveMode.Ignore)).equals((Object)saveMode) && fs.exists(path)) {
            fileBatchWrite = null;
        } else if (((Object)((Object)SaveMode.Overwrite)).equals((Object)saveMode)) {
            if (fs.exists(path) && !committer.deleteWithJob(fs, path, true)) {
                throw new IOException(new StringBuilder(49).append("Unable to clear directory ").append(path).append(" prior to writing to it").toString());
            }
            committer.setupJob((JobContext)job);
            fileBatchWrite = new FileBatchWrite(job, this.description$1(description$lzy, sparkSession, hadoopConf, job), committer);
        } else {
            committer.setupJob((JobContext)job);
            fileBatchWrite = new FileBatchWrite(job, this.description$1(description$lzy, sparkSession, hadoopConf, job), committer);
        }
        return fileBatchWrite;
    }

    public abstract OutputWriterFactory prepareWrite(SQLConf var1, Job var2, scala.collection.immutable.Map<String, String> var3, StructType var4);

    private void validateInputs(boolean caseSensitiveAnalysis) {
        Predef$.MODULE$.assert(this.schema() != null, (Function0 & Serializable & scala.Serializable)() -> "Missing input data schema");
        Predef$.MODULE$.assert(this.queryId() != null, (Function0 & Serializable & scala.Serializable)() -> "Missing query ID");
        Predef$.MODULE$.assert(this.mode() != null, (Function0 & Serializable & scala.Serializable)() -> "Missing save mode");
        if (this.paths.length() != 1) {
            throw new IllegalArgumentException(new StringBuilder(52).append("Expected exactly one path to be specified, but ").append("got: ").append(this.paths.mkString(", ")).toString());
        }
        String pathName = (String)this.paths.head();
        SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.schema().fields())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), new StringBuilder(20).append("when inserting into ").append(pathName).toString(), caseSensitiveAnalysis);
        DataSource$.MODULE$.validateSchema(this.schema());
        this.schema().foreach((Function1 & Serializable & scala.Serializable)field -> {
            FileWriteBuilder.$anonfun$validateInputs$5(this, field);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Job getJobInstance(Configuration hadoopConf, Path path) {
        void var3_3;
        Job job = Job.getInstance((Configuration)hadoopConf);
        job.setOutputKeyClass(Void.class);
        job.setOutputValueClass(InternalRow.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)path);
        return var3_3;
    }

    private WriteJobDescription createWriteJobDescription(SparkSession sparkSession, Configuration hadoopConf, Job job, String pathName, scala.collection.immutable.Map<String, String> options) {
        CaseInsensitiveMap caseInsensitiveOptions = CaseInsensitiveMap$.MODULE$.apply(options);
        OutputWriterFactory outputWriterFactory = this.prepareWrite(sparkSession.sessionState().conf(), job, (scala.collection.immutable.Map<String, String>)caseInsensitiveOptions, this.schema());
        Seq allColumns = this.schema().toAttributes();
        scala.collection.immutable.Map<String, SQLMetric> metrics = BasicWriteJobStatsTracker$.MODULE$.metrics();
        SerializableConfiguration serializableHadoopConf = new SerializableConfiguration(hadoopConf);
        BasicWriteJobStatsTracker statsTracker = new BasicWriteJobStatsTracker(serializableHadoopConf, metrics);
        return new WriteJobDescription(UUID.randomUUID().toString(), new SerializableConfiguration(job.getConfiguration()), outputWriterFactory, (Seq<Attribute>)allColumns, (Seq<Attribute>)allColumns, (Seq<Attribute>)((Seq)Seq$.MODULE$.empty()), (Option<Expression>)None$.MODULE$, pathName, (scala.collection.immutable.Map<scala.collection.immutable.Map<String, String>, String>)Predef$.MODULE$.Map().empty(), BoxesRunTime.unboxToLong((Object)caseInsensitiveOptions.get("maxRecordsPerFile").map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)FileWriteBuilder.$anonfun$createWriteJobDescription$1(x$2))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> sparkSession.sessionState().conf().maxRecordsPerFile())), (String)caseInsensitiveOptions.get(DateTimeUtils$.MODULE$.TIMEZONE_OPTION()).getOrElse((Function0 & Serializable & scala.Serializable)() -> sparkSession.sessionState().conf().sessionLocalTimeZone()), (Seq<WriteJobStatsTracker>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BasicWriteJobStatsTracker[]{statsTracker}))));
    }

    private final /* synthetic */ WriteJobDescription description$lzycompute$1(LazyRef description$lzy$1, SparkSession sparkSession$1, Configuration hadoopConf$1, Job job$1) {
        WriteJobDescription writeJobDescription;
        LazyRef lazyRef = description$lzy$1;
        synchronized (lazyRef) {
            writeJobDescription = description$lzy$1.initialized() ? (WriteJobDescription)description$lzy$1.value() : (WriteJobDescription)description$lzy$1.initialize((Object)this.createWriteJobDescription(sparkSession$1, hadoopConf$1, job$1, (String)this.paths.head(), (scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.options).asScala()).toMap(Predef$.MODULE$.$conforms())));
        }
        return writeJobDescription;
    }

    private final WriteJobDescription description$1(LazyRef description$lzy$1, SparkSession sparkSession$1, Configuration hadoopConf$1, Job job$1) {
        return description$lzy$1.initialized() ? (WriteJobDescription)description$lzy$1.value() : this.description$lzycompute$1(description$lzy$1, sparkSession$1, hadoopConf$1, job$1);
    }

    public static final /* synthetic */ void $anonfun$validateInputs$5(FileWriteBuilder $this, StructField field) {
        if (!BoxesRunTime.unboxToBoolean((Object)$this.supportsDataType.apply((Object)field.dataType()))) {
            throw new AnalysisException(new StringBuilder(41).append($this.formatName).append(" data source does not support ").append(field.dataType().catalogString()).append(" data type.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public static final /* synthetic */ long $anonfun$createWriteJobDescription$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
    }

    public FileWriteBuilder(CaseInsensitiveStringMap options, Seq<String> paths, String formatName, Function1<DataType, Object> supportsDataType) {
        this.options = options;
        this.paths = paths;
        this.formatName = formatName;
        this.supportsDataType = supportsDataType;
    }
}

