/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptionsInRead$;
import org.apache.spark.sql.catalyst.json.JacksonGenerator;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001y4A!\u0004\b\u0001;!A\u0001\u0006\u0001B\u0001B\u0003%\u0011\u0006\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011!q\u0004A!A!\u0002\u0013y\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u000b9\u0003A\u0011A(\t\u000fY\u0003!\u0019!C\u0005/\"1!\r\u0001Q\u0001\naCqa\u0019\u0001A\u0002\u0013%A\rC\u0004m\u0001\u0001\u0007I\u0011B7\t\rM\u0004\u0001\u0015)\u0003f\u0011\u0015!\b\u0001\"\u0011v\u0011\u0015a\b\u0001\"\u0011~\u0005AQ5o\u001c8PkR\u0004X\u000f^,sSR,'O\u0003\u0002\u0010!\u0005!!n]8o\u0015\t\t\"#A\u0006eCR\f7o\\;sG\u0016\u001c(BA\n\u0015\u0003%)\u00070Z2vi&|gN\u0003\u0002\u0016-\u0005\u00191/\u001d7\u000b\u0005]A\u0012!B:qCJ\\'BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001=\t\u0002\"a\b\u0011\u000e\u0003AI!!\t\t\u0003\u0019=+H\u000f];u/JLG/\u001a:\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u00152\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u001d\"#a\u0002'pO\u001eLgnZ\u0001\u0005a\u0006$\b\u000e\u0005\u0002+g9\u00111&\r\t\u0003Y=j\u0011!\f\u0006\u0003]q\ta\u0001\u0010:p_Rt$\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz\u0013A\u0002)sK\u0012,g-\u0003\u00025k\t11\u000b\u001e:j]\u001eT!AM\u0018\u0002\u000f=\u0004H/[8ogB\u0011\u0001\bP\u0007\u0002s)\u0011qB\u000f\u0006\u0003wQ\t\u0001bY1uC2L8\u000f^\u0005\u0003{e\u00121BS*P\u001d>\u0003H/[8og\u0006QA-\u0019;b'\u000eDW-\\1\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\t#\u0012!\u0002;za\u0016\u001c\u0018B\u0001#B\u0005)\u0019FO];diRK\b/Z\u0001\bG>tG/\u001a=u!\t9E*D\u0001I\u0015\tI%*A\u0005nCB\u0014X\rZ;dK*\u00111\nG\u0001\u0007Q\u0006$wn\u001c9\n\u00055C%A\u0005+bg.\fE\u000f^3naR\u001cuN\u001c;fqR\fa\u0001P5oSRtD#\u0002)S'R+\u0006CA)\u0001\u001b\u0005q\u0001\"\u0002\u0015\u0006\u0001\u0004I\u0003\"\u0002\u001c\u0006\u0001\u00049\u0004\"\u0002 \u0006\u0001\u0004y\u0004\"B#\u0006\u0001\u00041\u0015\u0001C3oG>$\u0017N\\4\u0016\u0003a\u0003\"!\u00171\u000e\u0003iS!a\u0017/\u0002\u000f\rD\u0017M]:fi*\u0011QLX\u0001\u0004]&|'\"A0\u0002\t)\fg/Y\u0005\u0003Cj\u0013qa\u00115beN,G/A\u0005f]\u000e|G-\u001b8hA\u0005\u0001\".Y2lg>tw)\u001a8fe\u0006$xN]\u000b\u0002KB\u0019amZ5\u000e\u0003=J!\u0001[\u0018\u0003\r=\u0003H/[8o!\tA$.\u0003\u0002ls\t\u0001\"*Y2lg>tw)\u001a8fe\u0006$xN]\u0001\u0015U\u0006\u001c7n]8o\u000f\u0016tWM]1u_J|F%Z9\u0015\u00059\f\bC\u00014p\u0013\t\u0001xF\u0001\u0003V]&$\bb\u0002:\n\u0003\u0003\u0005\r!Z\u0001\u0004q\u0012\n\u0014!\u00056bG.\u001cxN\\$f]\u0016\u0014\u0018\r^8sA\u0005)qO]5uKR\u0011aN\u001e\u0005\u0006o.\u0001\r\u0001_\u0001\u0004e><\bCA={\u001b\u0005Q\u0014BA>;\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u000b\rdwn]3\u0015\u00039\u0004")
public class JsonOutputWriter
extends OutputWriter
implements Logging {
    private final String path;
    private final JSONOptions options;
    private final StructType dataSchema;
    private final TaskAttemptContext context;
    private final Charset encoding;
    private Option<JacksonGenerator> jacksonGenerator;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Charset encoding() {
        return this.encoding;
    }

    private Option<JacksonGenerator> jacksonGenerator() {
        return this.jacksonGenerator;
    }

    private void jacksonGenerator_$eq(Option<JacksonGenerator> x$1) {
        this.jacksonGenerator = x$1;
    }

    @Override
    public void write(InternalRow row) {
        JacksonGenerator gen = (JacksonGenerator)this.jacksonGenerator().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            void var2_2;
            OutputStreamWriter os = CodecStreams$.MODULE$.createOutputStreamWriter((JobContext)$this.context, new Path($this.path), this.encoding());
            JacksonGenerator newGen = new JacksonGenerator((DataType)$this.dataSchema, (Writer)os, $this.options);
            this.jacksonGenerator_$eq((Option<JacksonGenerator>)new Some((Object)newGen));
            return var2_2;
        });
        gen.write(row);
        gen.writeLineEnding();
    }

    @Override
    public void close() {
        this.jacksonGenerator().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
    }

    public JsonOutputWriter(String path, JSONOptions options, StructType dataSchema, TaskAttemptContext context) {
        Charset charset;
        this.path = path;
        this.options = options;
        this.dataSchema = dataSchema;
        this.context = context;
        Logging.$init$((Logging)this);
        Option option = options.encoding();
        if (option instanceof Some) {
            Some some = (Some)option;
            String charsetName = (String)some.value();
            charset = Charset.forName(charsetName);
        } else if (None$.MODULE$.equals(option)) {
            charset = StandardCharsets.UTF_8;
        } else {
            throw new MatchError((Object)option);
        }
        this.encoding = charset;
        if (JSONOptionsInRead$.MODULE$.blacklist().contains((Object)this.encoding())) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(107).append("The JSON file (").append($this.path).append(") was written in the encoding ").append(this.encoding().displayName()).append(" which can be read back by Spark only if multiLine is enabled.").toString());
        }
        this.jacksonGenerator = None$.MODULE$;
    }
}

