/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.FilePartition;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class FilePartition$
implements Logging,
scala.Serializable {
    public static FilePartition$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new FilePartition$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Seq<FilePartition> getFilePartitions(SparkSession sparkSession, Seq<PartitionedFile> partitionedFiles, long maxSplitBytes) {
        ArrayBuffer partitions = new ArrayBuffer();
        ArrayBuffer currentFiles = new ArrayBuffer();
        LongRef currentSize = LongRef.create((long)0L);
        long openCostInBytes = sparkSession.sessionState().conf().filesOpenCostInBytes();
        partitionedFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
            if (currentSize$1.elem + file.length() > maxSplitBytes) {
                FilePartition$.closePartition$1(currentFiles, partitions, currentSize);
            }
            currentSize$1.elem += file.length() + openCostInBytes;
            return currentFiles.$plus$eq(file);
        });
        FilePartition$.closePartition$1(currentFiles, partitions, currentSize);
        return partitions;
    }

    public long maxSplitBytes(SparkSession sparkSession, Seq<PartitionDirectory> selectedPartitions) {
        long defaultMaxSplitBytes = sparkSession.sessionState().conf().filesMaxPartitionBytes();
        long openCostInBytes = sparkSession.sessionState().conf().filesOpenCostInBytes();
        int defaultParallelism = sparkSession.sparkContext().defaultParallelism();
        long totalBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)selectedPartitions.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> (Seq)x$2.files().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)FilePartition$.$anonfun$maxSplitBytes$2(openCostInBytes, x$3)), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long bytesPerCore = totalBytes / (long)defaultParallelism;
        return Math.min(defaultMaxSplitBytes, Math.max(openCostInBytes, bytesPerCore));
    }

    public FilePartition apply(int index, PartitionedFile[] files) {
        return new FilePartition(index, files);
    }

    public Option<Tuple2<Object, PartitionedFile[]>> unapply(FilePartition x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)x$0.index()), (Object)x$0.files()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final void closePartition$1(ArrayBuffer currentFiles$1, ArrayBuffer partitions$1, LongRef currentSize$1) {
        BoxedUnit boxedUnit;
        if (currentFiles$1.nonEmpty()) {
            FilePartition newPartition = new FilePartition(partitions$1.size(), (PartitionedFile[])currentFiles$1.toArray(ClassTag$.MODULE$.apply(PartitionedFile.class)));
            boxedUnit = partitions$1.$plus$eq((Object)newPartition);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        currentFiles$1.clear();
        currentSize$1.elem = 0L;
    }

    public static final /* synthetic */ long $anonfun$maxSplitBytes$2(long openCostInBytes$2, FileStatus x$3) {
        return x$3.getLen() + openCostInBytes$2;
    }

    private FilePartition$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

