/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.util.SchemaUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ViewHelper$ {
    public static ViewHelper$ MODULE$;

    static {
        new ViewHelper$();
    }

    private Map<String, String> generateViewDefaultDatabase(String databaseName) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)CatalogTable$.MODULE$.VIEW_DEFAULT_DATABASE()), (Object)databaseName)}));
    }

    private Map<String, String> generateQueryColumnNames(Seq<String> columns) {
        HashMap props;
        block0: {
            props = new HashMap();
            if (!columns.nonEmpty()) break block0;
            props.put((Object)CatalogTable$.MODULE$.VIEW_QUERY_OUTPUT_NUM_COLUMNS(), (Object)((Object)BoxesRunTime.boxToInteger((int)columns.length())).toString());
            ((IterableLike)columns.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String colName = (String)tuple2._1();
                int index = tuple2._2$mcI$sp();
                Option option = props.put((Object)new StringBuilder(0).append(CatalogTable$.MODULE$.VIEW_QUERY_OUTPUT_COLUMN_NAME_PREFIX()).append(index).toString(), (Object)colName);
                return option;
            });
        }
        return props.toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, String> removeQueryColumnNames(Map<String, String> properties) {
        return (Map)properties.filterNot((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ViewHelper$.$anonfun$removeQueryColumnNames$1(x0$1)));
    }

    public Map<String, String> generateViewProperties(Map<String, String> properties, SparkSession session, LogicalPlan analyzedPlan, String[] fieldNames) {
        String[] queryOutput = analyzedPlan.schema().fieldNames();
        SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)Predef$.MODULE$.wrapRefArray((Object[])fieldNames), "in the view definition", session.sessionState().conf().resolver());
        String viewDefaultDatabase = session.sessionState().catalog().getCurrentDatabase();
        return this.removeQueryColumnNames(properties).$plus$plus(this.generateViewDefaultDatabase(viewDefaultDatabase)).$plus$plus(this.generateQueryColumnNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])queryOutput)));
    }

    public void checkCyclicViewReference(LogicalPlan plan, Seq<TableIdentifier> path, TableIdentifier viewIdent) {
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof View) {
            View view = (View)logicalPlan2;
            TableIdentifier ident = view.desc().identifier();
            Seq newPath = (Seq)path.$colon$plus((Object)ident, Seq$.MODULE$.canBuildFrom());
            TableIdentifier tableIdentifier = ident;
            TableIdentifier tableIdentifier2 = viewIdent;
            if (!(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null)) {
                throw new AnalysisException(new StringBuilder(34).append("Recursive view ").append(viewIdent).append(" detected ").append("(cycle: ").append(newPath.mkString(" -> ")).append(")").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            view.children().foreach((Function1 & Serializable & scala.Serializable)child -> {
                ViewHelper$.MODULE$.checkCyclicViewReference(child, (Seq<TableIdentifier>)newPath, viewIdent);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            plan.children().foreach((Function1 & Serializable & scala.Serializable)child -> {
                ViewHelper$.MODULE$.checkCyclicViewReference(child, (Seq<TableIdentifier>)path, viewIdent);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        plan.expressions().foreach((Function1 & Serializable & scala.Serializable)expr -> {
            ViewHelper$.$anonfun$checkCyclicViewReference$3(path, viewIdent, expr);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$removeQueryColumnNames$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith(CatalogTable$.MODULE$.VIEW_QUERY_OUTPUT_PREFIX());
        return bl;
    }

    public static final /* synthetic */ void $anonfun$checkCyclicViewReference$3(Seq path$1, TableIdentifier viewIdent$1, Expression expr) {
        Expression expression = expr;
        if (expression instanceof SubqueryExpression) {
            SubqueryExpression subqueryExpression = (SubqueryExpression)expression;
            MODULE$.checkCyclicViewReference((LogicalPlan)subqueryExpression.plan(), (Seq<TableIdentifier>)path$1, viewIdent$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private ViewHelper$() {
        MODULE$ = this;
    }
}

