/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchPartitionException;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.TruncateTableCommand$;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\f\u0019\u0001\u0016B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u007f!AA\t\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005b\u0001\tE\t\u0015!\u0003G\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u00159\u0007\u0001\"\u0011i\u0011\u001dQ\b!!A\u0005\u0002mDqA \u0001\u0012\u0002\u0013\u0005q\u0010C\u0005\u0002\u0016\u0001\t\n\u0011\"\u0001\u0002\u0018!I\u00111\u0004\u0001\u0002\u0002\u0013\u0005\u0013Q\u0004\u0005\n\u0003_\u0001\u0011\u0011!C\u0001\u0003cA\u0011\"!\u000f\u0001\u0003\u0003%\t!a\u000f\t\u0013\u0005\u001d\u0003!!A\u0005B\u0005%\u0003\"CA,\u0001\u0005\u0005I\u0011AA-\u0011%\t\u0019\u0007AA\u0001\n\u0003\n)gB\u0005\u0002ja\t\t\u0011#\u0001\u0002l\u0019Aq\u0003GA\u0001\u0012\u0003\ti\u0007\u0003\u0004c#\u0011\u0005\u00111\u0010\u0005\n\u0003{\n\u0012\u0011!C#\u0003\u007fB\u0011\"!!\u0012\u0003\u0003%\t)a!\t\u0013\u0005%\u0015#!A\u0005\u0002\u0006-\u0005\"CAM#\u0005\u0005I\u0011BAN\u0005Q!&/\u001e8dCR,G+\u00192mK\u000e{W.\\1oI*\u0011\u0011DG\u0001\bG>lW.\u00198e\u0015\tYB$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QDH\u0001\u0004gFd'BA\u0010!\u0003\u0015\u0019\b/\u0019:l\u0015\t\t#%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0005\u0019qN]4\u0004\u0001M)\u0001A\n\u00195uA\u0011qEL\u0007\u0002Q)\u0011\u0011FK\u0001\bY><\u0017nY1m\u0015\tYC&A\u0003qY\u0006t7O\u0003\u0002.9\u0005A1-\u0019;bYf\u001cH/\u0003\u00020Q\tYAj\\4jG\u0006d\u0007\u000b\\1o!\t\t$'D\u0001\u0019\u0013\t\u0019\u0004DA\bSk:t\u0017M\u00197f\u0007>lW.\u00198e!\t)\u0004(D\u00017\u0015\u00059\u0014!B:dC2\f\u0017BA\u001d7\u0005\u001d\u0001&o\u001c3vGR\u0004\"!N\u001e\n\u0005q2$\u0001D*fe&\fG.\u001b>bE2,\u0017!\u0003;bE2,g*Y7f+\u0005y\u0004C\u0001!B\u001b\u0005a\u0013B\u0001\"-\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018A\u0003;bE2,g*Y7fA\u0005i\u0001/\u0019:uSRLwN\\*qK\u000e,\u0012A\u0012\t\u0004k\u001dK\u0015B\u0001%7\u0005\u0019y\u0005\u000f^5p]B\u0011!J\u0018\b\u0003\u0017ns!\u0001T-\u000f\u00055CfB\u0001(X\u001d\tyeK\u0004\u0002Q+:\u0011\u0011\u000bV\u0007\u0002%*\u00111\u000bJ\u0001\u0007yI|w\u000e\u001e \n\u0003\rJ!!\t\u0012\n\u0005}\u0001\u0013BA\u000f\u001f\u0013\tiC$\u0003\u0002[Y\u000591-\u0019;bY><\u0017B\u0001/^\u00031\u0019\u0015\r^1m_\u001e$\u0016\u0010]3t\u0015\tQF&\u0003\u0002`A\n\u0011B+\u00192mKB\u000b'\u000f^5uS>t7\u000b]3d\u0015\taV,\u0001\bqCJ$\u0018\u000e^5p]N\u0003Xm\u0019\u0011\u0002\rqJg.\u001b;?)\r!WM\u001a\t\u0003c\u0001AQ!P\u0003A\u0002}BQ\u0001R\u0003A\u0002\u0019\u000b1A];o)\tIg\u000fE\u0002k_Jt!a[7\u000f\u0005Ec\u0017\"A\u001c\n\u000594\u0014a\u00029bG.\fw-Z\u0005\u0003aF\u00141aU3r\u0015\tqg\u0007\u0005\u0002ti6\tA$\u0003\u0002v9\t\u0019!k\\<\t\u000b}1\u0001\u0019A<\u0011\u0005MD\u0018BA=\u001d\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0011\u0019w\u000e]=\u0015\u0007\u0011dX\u0010C\u0004>\u000fA\u0005\t\u0019A \t\u000f\u0011;\u0001\u0013!a\u0001\r\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0001U\ry\u00141A\u0016\u0003\u0003\u000b\u0001B!a\u0002\u0002\u00125\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0002\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0014\u0005%!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\rU\r1\u00151A\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005}\u0001\u0003BA\u0011\u0003Wi!!a\t\u000b\t\u0005\u0015\u0012qE\u0001\u0005Y\u0006twM\u0003\u0002\u0002*\u0005!!.\u0019<b\u0013\u0011\ti#a\t\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\u0019\u0004E\u00026\u0003kI1!a\u000e7\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ti$a\u0011\u0011\u0007U\ny$C\u0002\u0002BY\u00121!\u00118z\u0011%\t)\u0005DA\u0001\u0002\u0004\t\u0019$A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0017\u0002b!!\u0014\u0002T\u0005uRBAA(\u0015\r\t\tFN\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA+\u0003\u001f\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u00111LA1!\r)\u0014QL\u0005\u0004\u0003?2$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u000br\u0011\u0011!a\u0001\u0003{\ta!Z9vC2\u001cH\u0003BA.\u0003OB\u0011\"!\u0012\u0010\u0003\u0003\u0005\r!!\u0010\u0002)Q\u0013XO\\2bi\u0016$\u0016M\u00197f\u0007>lW.\u00198e!\t\t\u0014c\u0005\u0003\u0012\u0003_R\u0004cBA9\u0003ozd\tZ\u0007\u0003\u0003gR1!!\u001e7\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\u001f\u0002t\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\u0005-\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0011!B1qa2LH#\u00023\u0002\u0006\u0006\u001d\u0005\"B\u001f\u0015\u0001\u0004y\u0004\"\u0002#\u0015\u0001\u00041\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u001b\u000b)\n\u0005\u00036\u000f\u0006=\u0005#B\u001b\u0002\u0012~2\u0015bAAJm\t1A+\u001e9mKJB\u0001\"a&\u0016\u0003\u0003\u0005\r\u0001Z\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!(\u0011\t\u0005\u0005\u0012qT\u0005\u0005\u0003C\u000b\u0019C\u0001\u0004PE*,7\r\u001e")
public class TruncateTableCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final TableIdentifier tableName;
    private final Option<Map<String, String>> partitionSpec;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<TableIdentifier, Option<Map<String, String>>>> unapply(TruncateTableCommand truncateTableCommand) {
        return TruncateTableCommand$.MODULE$.unapply(truncateTableCommand);
    }

    public static Function1<Tuple2<TableIdentifier, Option<Map<String, String>>>, TruncateTableCommand> tupled() {
        return TruncateTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Option<Map<String, String>>, TruncateTableCommand>> curried() {
        return TruncateTableCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        TruncateTableCommand truncateTableCommand = this;
        synchronized (truncateTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public Option<Map<String, String>> partitionSpec() {
        return this.partitionSpec;
    }

    @Override
    public Seq<Row> run(SparkSession spark) {
        block9: {
            Seq seq;
            Seq partCols;
            SessionCatalog catalog = spark.sessionState().catalog();
            CatalogTable table = catalog.getTableMetadata(this.tableName());
            String tableIdentWithDB = table.identifier().quotedString();
            CatalogTableType catalogTableType = table.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.EXTERNAL();
            if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
                throw new AnalysisException(new StringBuilder(58).append("Operation not allowed: TRUNCATE TABLE on external tables: ").append(tableIdentWithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            CatalogTableType catalogTableType3 = table.tableType();
            CatalogTableType catalogTableType4 = CatalogTableType$.MODULE$.VIEW();
            if (!(catalogTableType3 != null ? !catalogTableType3.equals(catalogTableType4) : catalogTableType4 != null)) {
                throw new AnalysisException(new StringBuilder(48).append("Operation not allowed: TRUNCATE TABLE on views: ").append(tableIdentWithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            if (table.partitionColumnNames().isEmpty() && this.partitionSpec().isDefined()) {
                throw new AnalysisException(new StringBuilder(106).append("Operation not allowed: TRUNCATE TABLE ... PARTITION is not supported ").append("for tables that are not partitioned: ").append(tableIdentWithDB).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            if (this.partitionSpec().isDefined()) {
                DDLUtils$.MODULE$.verifyPartitionProviderIsHive(spark, table, "TRUNCATE TABLE ... PARTITION");
            }
            if ((partCols = table.partitionColumnNames()).isEmpty()) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{table.storage().locationUri()}));
            } else {
                Option normalizedSpec = this.partitionSpec().map((Function1 & Serializable & scala.Serializable)spec -> PartitioningUtils$.MODULE$.normalizePartitionSpec(spec, (Seq<String>)partCols, table.identifier().quotedString(), (Function2<String, String, Object>)spark.sessionState().conf().resolver()));
                Seq partLocations = (Seq)catalog.listPartitions(table.identifier(), normalizedSpec).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.storage().locationUri(), Seq$.MODULE$.canBuildFrom());
                this.partitionSpec().withFilter((Function1 & Serializable & scala.Serializable)spec -> BoxesRunTime.boxToBoolean((boolean)TruncateTableCommand.$anonfun$run$9(partLocations, partCols, spec))).foreach((Function1 & Serializable & scala.Serializable)spec -> {
                    throw new NoSuchPartitionException(table.database(), table.identifier().table(), spec);
                });
                seq = partLocations;
            }
            Seq locations = seq;
            Configuration hadoopConf = spark.sessionState().newHadoopConf();
            locations.foreach((Function1 & Serializable & scala.Serializable)location -> {
                Object object;
                if (location.isDefined()) {
                    Path path = new Path((URI)location.get());
                    try {
                        FileSystem fs = path.getFileSystem(hadoopConf);
                        fs.delete(path, true);
                        object = BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(path));
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            throw new AnalysisException(new StringBuilder(70).append("Failed to truncate table ").append(tableIdentWithDB).append(" when removing data of the path: ").append(path).append(" ").append("because of ").append(e.toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                        }
                        throw throwable;
                    }
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            });
            spark.sessionState().refreshTable(this.tableName().unquotedString());
            try {
                spark.sharedState().cacheManager().uncacheQuery(spark.table(table.identifier()), true);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.log().warn(new StringBuilder(43).append("Exception when attempting to uncache table ").append(tableIdentWithDB).toString(), e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            if (!table.stats().nonEmpty()) break block9;
            CatalogStatistics newStats = new CatalogStatistics(BigInt$.MODULE$.int2bigInt(0), (Option)new Some((Object)BigInt$.MODULE$.int2bigInt(0)), CatalogStatistics$.MODULE$.apply$default$3());
            catalog.alterTableStats(this.tableName(), (Option)new Some((Object)newStats));
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public TruncateTableCommand copy(TableIdentifier tableName, Option<Map<String, String>> partitionSpec) {
        return new TruncateTableCommand(tableName, partitionSpec);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public Option<Map<String, String>> copy$default$2() {
        return this.partitionSpec();
    }

    public String productPrefix() {
        return "TruncateTableCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Map<String, String>> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.tableName();
                break;
            }
            case 1: {
                option = this.partitionSpec();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncateTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncateTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncateTableCommand truncateTableCommand = (TruncateTableCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = truncateTableCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Option<Map<String, String>> option = this.partitionSpec();
        Option<Map<String, String>> option2 = truncateTableCommand.partitionSpec();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!truncateTableCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$run$9(Seq partLocations$1, Seq partCols$1, Map spec) {
        return partLocations$1.isEmpty() && spec.size() == partCols$1.length();
    }

    public TruncateTableCommand(TableIdentifier tableName, Option<Map<String, String>> partitionSpec) {
        this.tableName = tableName;
        this.partitionSpec = partitionSpec;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

