/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.RichLong$;

public final class PartitionedFileUtil$ {
    public static PartitionedFileUtil$ MODULE$;

    static {
        new PartitionedFileUtil$();
    }

    public Seq<PartitionedFile> splitFiles(SparkSession sparkSession, FileStatus file, Path filePath, boolean isSplitable, long maxSplitBytes, InternalRow partitionValues) {
        return isSplitable ? (Seq)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)file.getLen())).by((Object)BoxesRunTime.boxToLong((long)maxSplitBytes)).map((Function1 & Serializable & scala.Serializable)offset -> PartitionedFileUtil$.$anonfun$splitFiles$1(file, maxSplitBytes, partitionValues, filePath, BoxesRunTime.unboxToLong((Object)offset)), IndexedSeq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionedFile[]{this.getPartitionedFile(file, filePath, partitionValues)}));
    }

    public PartitionedFile getPartitionedFile(FileStatus file, Path filePath, InternalRow partitionValues) {
        String[] hosts = this.getBlockHosts(this.getBlockLocations(file), 0L, file.getLen());
        return new PartitionedFile(partitionValues, filePath.toUri().toString(), 0L, file.getLen(), hosts);
    }

    private BlockLocation[] getBlockLocations(FileStatus file) {
        BlockLocation[] blockLocationArray;
        FileStatus fileStatus = file;
        if (fileStatus instanceof LocatedFileStatus) {
            LocatedFileStatus locatedFileStatus = (LocatedFileStatus)fileStatus;
            blockLocationArray = locatedFileStatus.getBlockLocations();
        } else {
            blockLocationArray = (BlockLocation[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(BlockLocation.class));
        }
        return blockLocationArray;
    }

    private String[] getBlockHosts(BlockLocation[] blockLocations, long offset, long length) {
        String[] stringArray;
        Tuple2[] candidates = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blockLocations)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BlockLocation blockLocation = x0$1;
            Tuple2 tuple2 = blockLocation.getOffset() <= offset && offset < blockLocation.getOffset() + blockLocation.getLength() ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)blockLocation.getHosts()), (Object)BoxesRunTime.boxToLong((long)RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(blockLocation.getOffset() + blockLocation.getLength() - offset), length))) : (offset <= blockLocation.getOffset() && offset + length < blockLocation.getLength() ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)blockLocation.getHosts()), (Object)BoxesRunTime.boxToLong((long)RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(offset + length - blockLocation.getOffset()), length))) : (offset <= blockLocation.getOffset() && blockLocation.getOffset() + blockLocation.getLength() <= offset + length ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)blockLocation.getHosts()), (Object)BoxesRunTime.boxToLong((long)blockLocation.getLength())) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)blockLocation.getHosts()), (Object)BoxesRunTime.boxToLong((long)0L))));
            return tuple2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)PartitionedFileUtil$.$anonfun$getBlockHosts$2(x0$2)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])candidates)).isEmpty()) {
            stringArray = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        } else {
            String[] hosts;
            Tuple2 tuple2 = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])candidates)).maxBy((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToLong((long)PartitionedFileUtil$.$anonfun$getBlockHosts$3(x0$3)), (Ordering)Ordering.Long$.MODULE$);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String[] stringArray2 = hosts = (String[])tuple2._1();
            String[] hosts2 = stringArray2;
            stringArray = hosts2;
        }
        return stringArray;
    }

    public static final /* synthetic */ PartitionedFile $anonfun$splitFiles$1(FileStatus file$1, long maxSplitBytes$1, InternalRow partitionValues$1, Path filePath$1, long offset) {
        long remaining = file$1.getLen() - offset;
        long size = remaining > maxSplitBytes$1 ? maxSplitBytes$1 : remaining;
        String[] hosts = MODULE$.getBlockHosts(MODULE$.getBlockLocations(file$1), offset, size);
        return new PartitionedFile(partitionValues$1, filePath$1.toUri().toString(), offset, size, hosts);
    }

    public static final /* synthetic */ boolean $anonfun$getBlockHosts$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long size = tuple2._2$mcJ$sp();
        boolean bl = size > 0L;
        return bl;
    }

    public static final /* synthetic */ long $anonfun$getBlockHosts$3(Tuple2 x0$3) {
        long size;
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long l = size = tuple2._2$mcJ$sp();
        return l;
    }

    private PartitionedFileUtil$() {
        MODULE$ = this;
    }
}

