/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.ZoneId;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.command.DescribeCommandBase;
import org.apache.spark.sql.execution.command.ExecutedCommandExec;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.ShowTablesCommand;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;

public final class HiveResult$ {
    public static HiveResult$ MODULE$;
    private ZoneId zoneId;
    private DateFormatter dateFormatter;
    private TimestampFormatter timestampFormatter;
    private final Seq<AtomicType> primitiveTypes;
    private volatile byte bitmap$0;

    static {
        new HiveResult$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<String> hiveResultString(SparkPlan executedPlan) {
        ShowTablesCommand showTablesCommand;
        RunnableCommand s;
        boolean bl = false;
        ExecutedCommandExec executedCommandExec = null;
        SparkPlan sparkPlan = executedPlan;
        if (sparkPlan instanceof ExecutedCommandExec) {
            bl = true;
            executedCommandExec = (ExecutedCommandExec)sparkPlan;
            if (executedCommandExec.cmd() instanceof DescribeCommandBase) {
                return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])executedPlan.executeCollectPublic())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    String string;
                    Object comment;
                    Object dataType;
                    block3: {
                        Row row;
                        block2: {
                            row = x0$1;
                            Some some = Row$.MODULE$.unapplySeq(row);
                            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block2;
                            Object name = ((SeqLike)some.get()).apply(0);
                            dataType = ((SeqLike)some.get()).apply(1);
                            comment = ((SeqLike)some.get()).apply(2);
                            if (!(name instanceof String)) break block2;
                            string = (String)name;
                            if (dataType instanceof String) break block3;
                        }
                        throw new MatchError((Object)row);
                    }
                    String string2 = (String)dataType;
                    String string3 = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{string, string2, (String)Option$.MODULE$.apply((Object)((String)comment)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")}))).map((Function1 & Serializable & scala.Serializable)s -> String.format("%-20s", s), Seq$.MODULE$.canBuildFrom())).mkString("\t");
                    return string3;
                }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            }
        }
        if (bl && (s = executedCommandExec.cmd()) instanceof ShowTablesCommand && !(showTablesCommand = (ShowTablesCommand)s).isExtended()) {
            return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])executedCommandExec.executeCollect())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getString(1), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        Seq result = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkPlan.executeCollectPublic())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toSeq(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class))))).toSeq();
        Seq types = (Seq)executedPlan.output().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.dataType(), Seq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)result.map((Function1 & Serializable & scala.Serializable)x$4 -> (Seq)((TraversableLike)x$4.zip((GenIterable)types, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)a -> MODULE$.toHiveString((Tuple2<Object, DataType>)a), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.mkString("\t"), Seq$.MODULE$.canBuildFrom());
    }

    private String formatDecimal(BigDecimal d) {
        return d.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO.toPlainString() : d.stripTrailingZeros().toPlainString();
    }

    private Seq<AtomicType> primitiveTypes() {
        return this.primitiveTypes;
    }

    private ZoneId zoneId$lzycompute() {
        HiveResult$ hiveResult$ = this;
        synchronized (hiveResult$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.zoneId = DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.zoneId;
    }

    private ZoneId zoneId() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    private DateFormatter dateFormatter$lzycompute() {
        HiveResult$ hiveResult$ = this;
        synchronized (hiveResult$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dateFormatter = DateFormatter$.MODULE$.apply(this.zoneId());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dateFormatter;
    }

    private DateFormatter dateFormatter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dateFormatter$lzycompute() : this.dateFormatter;
    }

    private TimestampFormatter timestampFormatter$lzycompute() {
        HiveResult$ hiveResult$ = this;
        synchronized (hiveResult$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.timestampFormatter = TimestampFormatter$.MODULE$.getFractionFormatter(this.zoneId());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampFormatter() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.timestampFormatter$lzycompute() : this.timestampFormatter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String toHiveStructString(Tuple2<Object, DataType> a2) {
        Object object;
        Tuple2<Object, DataType> tuple2 = a2;
        if (tuple2 != null) {
            Object struct = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (struct instanceof Row) {
                Row row = (Row)struct;
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    StructField[] fields = structType.fields();
                    return ((TraversableOnce)((TraversableLike)row.toSeq().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fields), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object v = tuple2._1();
                        StructField t = (StructField)tuple2._2();
                        String string = new StringBuilder(3).append("\"").append(t.name()).append("\":").append(MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(v, (Object)t.dataType()))).toString();
                        return string;
                    }, Seq$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null) {
            Object seq = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (seq instanceof Seq) {
                Seq seq2 = (Seq)seq;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType typ = arrayType.elementType();
                    return ((TraversableOnce)((TraversableLike)seq2.map((Function1 & Serializable & scala.Serializable)v -> new Tuple2(v, (Object)typ), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)a -> MODULE$.toHiveStructString((Tuple2<Object, DataType>)a), Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
                }
            }
        }
        if (tuple2 != null) {
            Object map = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (map instanceof Map) {
                Map map2 = (Map)map;
                if (dataType instanceof MapType) {
                    MapType mapType = (MapType)dataType;
                    DataType kType = mapType.keyType();
                    DataType vType = mapType.valueType();
                    return ((TraversableOnce)((TraversableOnce)map2.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object key = tuple2._1();
                        Object value = tuple2._2();
                        String string = new StringBuilder(1).append(MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(key, (Object)kType))).append(":").append(MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(value, (Object)vType))).toString();
                        return string;
                    }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null && (object = tuple2._1()) == null) {
            return "null";
        }
        if (tuple2 != null) {
            Object s = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (s instanceof String) {
                String string = (String)s;
                if (StringType$.MODULE$.equals(dataType)) {
                    return new StringBuilder(2).append("\"").append(string).append("\"").toString();
                }
            }
        }
        if (tuple2 != null) {
            Object decimal = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (DecimalType$.MODULE$.unapply(dataType)) {
                return decimal.toString();
            }
        }
        if (tuple2 != null) {
            Object interval = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (CalendarIntervalType$.MODULE$.equals(dataType)) {
                return interval.toString();
            }
        }
        if (tuple2 == null) throw new MatchError(tuple2);
        Object other = tuple2._1();
        DataType tpe = (DataType)tuple2._2();
        if (!this.primitiveTypes().contains((Object)tpe)) throw new MatchError(tuple2);
        return other.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toHiveString(Tuple2<Object, DataType> a2) {
        Object object;
        Tuple2<Object, DataType> tuple2 = a2;
        if (tuple2 != null) {
            Object struct = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (struct instanceof Row) {
                Row row = (Row)struct;
                if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    StructField[] fields = structType.fields();
                    return ((TraversableOnce)((TraversableLike)row.toSeq().zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])fields), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object v = tuple2._1();
                        StructField t = (StructField)tuple2._2();
                        String string = new StringBuilder(3).append("\"").append(t.name()).append("\":").append(MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(v, (Object)t.dataType()))).toString();
                        return string;
                    }, Seq$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null) {
            Object seq = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (seq instanceof Seq) {
                Seq seq2 = (Seq)seq;
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType typ = arrayType.elementType();
                    return ((TraversableOnce)((TraversableLike)seq2.map((Function1 & Serializable & scala.Serializable)v -> new Tuple2(v, (Object)typ), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)a -> MODULE$.toHiveStructString((Tuple2<Object, DataType>)a), Seq$.MODULE$.canBuildFrom())).mkString("[", ",", "]");
                }
            }
        }
        if (tuple2 != null) {
            Object map = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (map instanceof Map) {
                Map map2 = (Map)map;
                if (dataType instanceof MapType) {
                    MapType mapType = (MapType)dataType;
                    DataType kType = mapType.keyType();
                    DataType vType = mapType.valueType();
                    return ((TraversableOnce)((TraversableOnce)map2.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object key = tuple2._1();
                        Object value = tuple2._2();
                        String string = new StringBuilder(1).append(MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(key, (Object)kType))).append(":").append(MODULE$.toHiveStructString((Tuple2<Object, DataType>)new Tuple2(value, (Object)vType))).toString();
                        return string;
                    }, Iterable$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString("{", ",", "}");
                }
            }
        }
        if (tuple2 != null && (object = tuple2._1()) == null) {
            return "NULL";
        }
        if (tuple2 != null) {
            Object d = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (d instanceof Date) {
                Date date = (Date)d;
                if (DateType$.MODULE$.equals(dataType)) {
                    return this.dateFormatter().format(DateTimeUtils$.MODULE$.fromJavaDate(date));
                }
            }
        }
        if (tuple2 != null) {
            Object t = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (t instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)t;
                if (TimestampType$.MODULE$.equals(dataType)) {
                    return DateTimeUtils$.MODULE$.timestampToString(this.timestampFormatter(), DateTimeUtils$.MODULE$.fromJavaTimestamp(timestamp));
                }
            }
        }
        if (tuple2 != null) {
            Object bin = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (bin instanceof byte[]) {
                byte[] byArray = (byte[])bin;
                if (BinaryType$.MODULE$.equals(dataType)) {
                    return new String(byArray, StandardCharsets.UTF_8);
                }
            }
        }
        if (tuple2 != null) {
            Object decimal = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (decimal instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)decimal;
                if (DecimalType$.MODULE$.unapply(dataType)) {
                    return this.formatDecimal(bigDecimal);
                }
            }
        }
        if (tuple2 != null) {
            Object interval = tuple2._1();
            DataType dataType = (DataType)tuple2._2();
            if (CalendarIntervalType$.MODULE$.equals(dataType)) {
                return interval.toString();
            }
        }
        if (tuple2 != null) {
            Object other = tuple2._1();
            if (tuple2._2() instanceof UserDefinedType) {
                return other.toString();
            }
        }
        if (tuple2 == null) throw new MatchError(tuple2);
        Object other = tuple2._1();
        DataType tpe = (DataType)tuple2._2();
        if (!this.primitiveTypes().contains((Object)tpe)) throw new MatchError(tuple2);
        return other.toString();
    }

    private HiveResult$() {
        MODULE$ = this;
        this.primitiveTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, IntegerType$.MODULE$, LongType$.MODULE$, DoubleType$.MODULE$, FloatType$.MODULE$, BooleanType$.MODULE$, ByteType$.MODULE$, ShortType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$, BinaryType$.MODULE$}));
    }
}

