/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.annotation.Stable;
import org.apache.spark.api.python.PythonEvalType$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.RelationalGroupedDataset$;
import org.apache.spark.sql.RelationalGroupedDataset$CubeType$;
import org.apache.spark.sql.RelationalGroupedDataset$GroupByType$;
import org.apache.spark.sql.RelationalGroupedDataset$RollupType$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.TypedColumn;
import org.apache.spark.sql.catalyst.analysis.Star;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cube;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PythonUDF;
import org.apache.spark.sql.catalyst.expressions.Rollup;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.FlatMapCoGroupsInPandas;
import org.apache.spark.sql.catalyst.plans.logical.FlatMapGroupsInPandas;
import org.apache.spark.sql.catalyst.plans.logical.FlatMapGroupsInR$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Pivot;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.aggregate.TypedAggregateExpression;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Stable
@ScalaSignature(bytes="\u0006\u0001\r\u0005d\u0001\u0002$H\u0001AC\u0011b\u0016\u0001\u0003\u0006\u0004%\ta\u0012-\t\u0011\u0005\u0004!\u0011!Q\u0001\neC\u0011B\u0019\u0001\u0003\u0006\u0004%\taR2\t\u0011]\u0004!\u0011!Q\u0001\n\u0011D\u0001\u0002\u001f\u0001\u0003\u0002\u0003\u0006I!\u001f\u0005\b}\u0002!\tb\u0012B\u0012\u0011!\u0011Y\u0003\u0001Q\u0005\n\t5\u0002\u0002\u0003B\u001a\u0001\u0001&IA!\u000e\t\u0011\t\u0005\u0003\u0001)C\u0005\u0005\u0007B\u0001Ba\u001a\u0001A\u0013%!\u0011\u000e\u0005\b\u0005_\u0002A\u0011\u0001B9\u0011\u001d\u0011y\u0007\u0001C\u0001\u0005{BqAa\u001c\u0001\t\u0003\u0011I\tC\u0004\u0003p\u0001!\tAa&\t\u000f\t=\u0006\u0001\"\u0001\u00032\"9!1\u0017\u0001\u0005\u0002\tU\u0006b\u0002B^\u0001\u0011\u0005!Q\u0018\u0005\b\u0005\u0007\u0004A\u0011\u0001Bc\u0011\u001d\u0011Y\r\u0001C\u0001\u0005\u001bDqAa5\u0001\t\u0003\u0011)\u000eC\u0004\u0003\\\u0002!\tA!8\t\u000f\tm\u0007\u0001\"\u0001\u0003d\"9!1\u001c\u0001\u0005\u0002\t-\bb\u0002Bn\u0001\u0011\u0005!q\u001f\u0005\b\u00057\u0004A\u0011\u0001B~\u0011\u001d\u0011Y\u000e\u0001C\u0001\u0007\u0003A\u0001ba\u0002\u0001\t\u000395\u0011\u0002\u0005\t\u0007\u007f\u0001A\u0011A$\u0004B!A11\n\u0001\u0005\u0002\u001d\u001bi\u0005C\u0004\u0002 \u0001!\t%!\t\b\rm<\u0005\u0012A$}\r\u00191u\t#\u0001H{\")a\u0010\tC\u0001\u007f\"9\u0011\u0011\u0001\u0011\u0005\u0002\u0005\raACA\tAA\u0005\u0019\u0011A$\u0002\u0014!9\u0011QC\u0012\u0005\u0002\u0005]\u0001bBA\u0010G\u0011\u0005\u0013\u0011E\u0004\t\u0003g\u0001\u0003\u0012A$\u00026\u0019A\u0011q\u0007\u0011\t\u0002\u001d\u000bI\u0004\u0003\u0004\u007fO\u0011\u0005\u00111H\u0004\t\u0003{\u0001\u0003\u0012A$\u0002@\u0019A\u0011\u0011\t\u0011\t\u0002\u001d\u000b\u0019\u0005\u0003\u0004\u007fU\u0011\u0005\u0011QI\u0004\t\u0003\u000f\u0002\u0003\u0012A$\u0002J\u0019A\u00111\n\u0011\t\u0002\u001d\u000bi\u0005\u0003\u0004\u007f[\u0011\u0005\u0011q\n\u0004\b\u0003#\u0002\u0003iRA*\u0011)\t\tg\fBK\u0002\u0013\u0005\u00111\r\u0005\n\u0003Kz#\u0011#Q\u0001\n=D\u0011\"a\u001a0\u0005+\u0007I\u0011A2\t\u0013\u0005%tF!E!\u0002\u0013!\u0007B\u0002@0\t\u0003\tY\u0007C\u0005\u0002t=\n\t\u0011\"\u0001\u0002v!I\u00111P\u0018\u0012\u0002\u0013\u0005\u0011Q\u0010\u0005\n\u0003'{\u0013\u0013!C\u0001\u0003+C\u0011\"!'0\u0003\u0003%\t%a'\t\u0013\u0005-v&!A\u0005\u0002\u00055\u0006\"CA[_\u0005\u0005I\u0011AA\\\u0011%\t\u0019mLA\u0001\n\u0003\n)\rC\u0005\u0002T>\n\t\u0011\"\u0001\u0002V\"I\u0011q\\\u0018\u0002\u0002\u0013\u0005\u0013\u0011\u001d\u0005\n\u0003G|\u0013\u0011!C!\u0003K<!\"!;!\u0003\u0003E\taRAv\r)\t\t\u0006IA\u0001\u0012\u00039\u0015Q\u001e\u0005\u0007}\u0002#\t!a?\t\u0013\u0005}\u0001)!A\u0005F\u0005u\b\"CA\u0001\u0001\u0006\u0005I\u0011QA\u0000\u0011%\u0011)\u0001QA\u0001\n\u0003\u00139\u0001C\u0005\u0003\u001a\u0001\u000b\t\u0011\"\u0003\u0003\u001c\tA\"+\u001a7bi&|g.\u00197He>,\b/\u001a3ECR\f7/\u001a;\u000b\u0005!K\u0015aA:rY*\u0011!jS\u0001\u0006gB\f'o\u001b\u0006\u0003\u00196\u000ba!\u00199bG\",'\"\u0001(\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\t\u0006C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&AB!osJ+g-\u0001\u0002eMV\t\u0011\f\u0005\u0002[=:\u00111\fX\u0007\u0002\u000f&\u0011QlR\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0006MA\u0005ECR\fgI]1nK*\u0011QlR\u0001\u0004I\u001a\u0004\u0013!D4s_V\u0004\u0018N\\4FqB\u00148/F\u0001e!\r)Gn\u001c\b\u0003M.t!a\u001a6\u000e\u0003!T!![(\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0016BA/T\u0013\tigNA\u0002TKFT!!X*\u0011\u0005A,X\"A9\u000b\u0005I\u001c\u0018aC3yaJ,7o]5p]NT!\u0001^$\u0002\u0011\r\fG/\u00197zgRL!A^9\u0003\u0015\u0015C\bO]3tg&|g.\u0001\bhe>,\b/\u001b8h\u000bb\u0004(o\u001d\u0011\u0002\u0013\u001d\u0014x.\u001e9UsB,\u0007C\u0001>$\u001d\tYv$\u0001\rSK2\fG/[8oC2<%o\\;qK\u0012$\u0015\r^1tKR\u0004\"a\u0017\u0011\u0014\u0005\u0001\n\u0016A\u0002\u001fj]&$h\bF\u0001}\u0003\u0015\t\u0007\u000f\u001d7z)!\t)!a\u0002\u0002\n\u0005-\u0001CA.\u0001\u0011\u00159&\u00051\u0001Z\u0011\u0015\u0011'\u00051\u0001e\u0011\u0019A(\u00051\u0001\u0002\u000eA\u0019\u0011qB\u0012\u000e\u0003\u0001\u0012\u0011b\u0012:pkB$\u0016\u0010]3\u0014\u0005\r\n\u0016A\u0002\u0013j]&$H\u0005\u0006\u0002\u0002\u001aA\u0019!+a\u0007\n\u0007\u0005u1K\u0001\u0003V]&$\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\r\u0002\u0003BA\u0013\u0003[qA!a\n\u0002*A\u0011qmU\u0005\u0004\u0003W\u0019\u0016A\u0002)sK\u0012,g-\u0003\u0003\u00020\u0005E\"AB*ue&twMC\u0002\u0002,M\u000b1b\u0012:pkB\u0014\u0015\u0010V=qKB\u0019\u0011qB\u0014\u0003\u0017\u001d\u0013x.\u001e9CsRK\b/Z\n\u0005OE\u000bi\u0001\u0006\u0002\u00026\u0005A1)\u001e2f)f\u0004X\rE\u0002\u0002\u0010)\u0012\u0001bQ;cKRK\b/Z\n\u0005UE\u000bi\u0001\u0006\u0002\u0002@\u0005Q!k\u001c7mkB$\u0016\u0010]3\u0011\u0007\u0005=QF\u0001\u0006S_2dW\u000f\u001d+za\u0016\u001cB!L)\u0002\u000eQ\u0011\u0011\u0011\n\u0002\n!&4x\u000e\u001e+za\u0016\u001c\u0002bL)\u0002\u000e\u0005U\u00131\f\t\u0004%\u0006]\u0013bAA-'\n9\u0001K]8ek\u000e$\bc\u0001*\u0002^%\u0019\u0011qL*\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0011ALgo\u001c;D_2,\u0012a\\\u0001\na&4x\u000e^\"pY\u0002\naA^1mk\u0016\u001c\u0018a\u0002<bYV,7\u000f\t\u000b\u0007\u0003[\ny'!\u001d\u0011\u0007\u0005=q\u0006\u0003\u0004\u0002bQ\u0002\ra\u001c\u0005\u0007\u0003O\"\u0004\u0019\u00013\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003[\n9(!\u001f\t\u0011\u0005\u0005T\u0007%AA\u0002=D\u0001\"a\u001a6!\u0003\u0005\r\u0001Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyHK\u0002p\u0003\u0003[#!a!\u0011\t\u0005\u0015\u0015qR\u0007\u0003\u0003\u000fSA!!#\u0002\f\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001b\u001b\u0016AC1o]>$\u0018\r^5p]&!\u0011\u0011SAD\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t9JK\u0002e\u0003\u0003\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAO!\u0011\ty*!+\u000e\u0005\u0005\u0005&\u0002BAR\u0003K\u000bA\u0001\\1oO*\u0011\u0011qU\u0001\u0005U\u00064\u0018-\u0003\u0003\u00020\u0005\u0005\u0016\u0001\u00049s_\u0012,8\r^!sSRLXCAAX!\r\u0011\u0016\u0011W\u0005\u0004\u0003g\u001b&aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA]\u0003\u007f\u00032AUA^\u0013\r\til\u0015\u0002\u0004\u0003:L\b\"CAau\u0005\u0005\t\u0019AAX\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0019\t\u0007\u0003\u0013\fy-!/\u000e\u0005\u0005-'bAAg'\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005E\u00171\u001a\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002X\u0006u\u0007c\u0001*\u0002Z&\u0019\u00111\\*\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011\u0019\u001f\u0002\u0002\u0003\u0007\u0011\u0011X\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011qV\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005]\u0017q\u001d\u0005\n\u0003\u0003t\u0014\u0011!a\u0001\u0003s\u000b\u0011\u0002U5w_R$\u0016\u0010]3\u0011\u0007\u0005=\u0001iE\u0003A\u0003_\fY\u0006\u0005\u0005\u0002r\u0006]x\u000eZA7\u001b\t\t\u0019PC\u0002\u0002vN\u000bqA];oi&lW-\u0003\u0003\u0002z\u0006M(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u00111\u001e\u000b\u0003\u0003;#b!!\u001c\u0003\u0002\t\r\u0001BBA1\u0007\u0002\u0007q\u000e\u0003\u0004\u0002h\r\u0003\r\u0001Z\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011IA!\u0006\u0011\u000bI\u0013YAa\u0004\n\u0007\t51K\u0001\u0004PaRLwN\u001c\t\u0006%\nEq\u000eZ\u0005\u0004\u0005'\u0019&A\u0002+va2,'\u0007C\u0005\u0003\u0018\u0011\u000b\t\u00111\u0001\u0002n\u0005\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005;\u0001B!a(\u0003 %!!\u0011EAQ\u0005\u0019y%M[3diRA\u0011Q\u0001B\u0013\u0005O\u0011I\u0003C\u0003X\r\u0001\u0007\u0011\fC\u0003c\r\u0001\u0007A\rC\u0003y\r\u0001\u0007\u00110\u0001\u0003u_\u00123EcA-\u00030!1!\u0011G\u0004A\u0002\u0011\f\u0001\"Y4h\u000bb\u0004(o]\u0001\u0006C2L\u0017m\u001d\u000b\u0005\u0005o\u0011i\u0004E\u0002q\u0005sI1Aa\u000fr\u0005=q\u0015-\\3e\u000bb\u0004(/Z:tS>t\u0007B\u0002B \u0011\u0001\u0007q.\u0001\u0003fqB\u0014\u0018aF1hOJ,w-\u0019;f\u001dVlWM]5d\u0007>dW/\u001c8t)\u0011\u0011)E!\u0018\u0015\u0007e\u00139\u0005C\u0004\u0003J%\u0001\rAa\u0013\u0002\u0003\u0019\u0004bA\u0015B'_\nE\u0013b\u0001B('\nIa)\u001e8di&|g.\r\t\u0005\u0005'\u0012I&\u0004\u0002\u0003V)\u0019!qK9\u0002\u0013\u0005<wM]3hCR,\u0017\u0002\u0002B.\u0005+\u0012\u0011#Q4he\u0016<\u0017\r^3Gk:\u001cG/[8o\u0011\u001d\u0011y&\u0003a\u0001\u0005C\n\u0001bY8m\u001d\u0006lWm\u001d\t\u0006%\n\r\u00141E\u0005\u0004\u0005K\u001a&A\u0003\u001fsKB,\u0017\r^3e}\u0005I1\u000f\u001e:U_\u0016C\bO\u001d\u000b\u0005\u0005W\u0012i\u0007E\u0003S\u0005\u001bzw\u000eC\u0004\u0003@)\u0001\r!a\t\u0002\u0007\u0005<w\rF\u0003Z\u0005g\u0012I\bC\u0004\u0003v-\u0001\rAa\u001e\u0002\u000f\u0005<w-\u0012=qeB9!K!\u0005\u0002$\u0005\r\u0002b\u0002B\u0019\u0017\u0001\u0007!1\u0010\t\u0006%\n\r$q\u000f\u000b\u00043\n}\u0004b\u0002BA\u0019\u0001\u0007!1Q\u0001\u0006Kb\u0004(o\u001d\t\t\u0003K\u0011))a\t\u0002$%!!qQA\u0019\u0005\ri\u0015\r\u001d\u000b\u00043\n-\u0005b\u0002BA\u001b\u0001\u0007!Q\u0012\t\t\u0005\u001f\u0013)*a\t\u0002$5\u0011!\u0011\u0013\u0006\u0005\u0005'\u000b)+\u0001\u0003vi&d\u0017\u0002\u0002BD\u0005##R!\u0017BM\u0005CCqAa\u0010\u000f\u0001\u0004\u0011Y\nE\u0002\\\u0005;K1Aa(H\u0005\u0019\u0019u\u000e\\;n]\"9!\u0011\u0011\bA\u0002\t\r\u0006#\u0002*\u0003d\tm\u0005f\u0001\b\u0003(B!!\u0011\u0016BV\u001b\t\tY)\u0003\u0003\u0003.\u0006-%a\u0002<be\u0006\u0014xm]\u0001\u0006G>,h\u000e\u001e\u000b\u00023\u0006!Q.Z1o)\rI&q\u0017\u0005\b\u0005?\u0002\u0002\u0019\u0001B1Q\r\u0001\"qU\u0001\u0004[\u0006DHcA-\u0003@\"9!qL\tA\u0002\t\u0005\u0004fA\t\u0003(\u0006\u0019\u0011M^4\u0015\u0007e\u00139\rC\u0004\u0003`I\u0001\rA!\u0019)\u0007I\u00119+A\u0002nS:$2!\u0017Bh\u0011\u001d\u0011yf\u0005a\u0001\u0005CB3a\u0005BT\u0003\r\u0019X/\u001c\u000b\u00043\n]\u0007b\u0002B0)\u0001\u0007!\u0011\r\u0015\u0004)\t\u001d\u0016!\u00029jm>$H\u0003BA\u0003\u0005?DqA!9\u0016\u0001\u0004\t\u0019#A\u0006qSZ|GoQ8mk6tGCBA\u0003\u0005K\u00149\u000fC\u0004\u0003bZ\u0001\r!a\t\t\u000f\u0005\u001dd\u00031\u0001\u0003jB!Q\r\\A])\u0019\t)A!<\u0003p\"9!\u0011]\fA\u0002\u0005\r\u0002bBA4/\u0001\u0007!\u0011\u001f\t\u0007\u0005\u001f\u0013\u00190!/\n\t\tU(\u0011\u0013\u0002\u0005\u0019&\u001cH\u000f\u0006\u0003\u0002\u0006\te\bb\u0002Bq1\u0001\u0007!1\u0014\u000b\u0007\u0003\u000b\u0011iPa@\t\u000f\t\u0005\u0018\u00041\u0001\u0003\u001c\"9\u0011qM\rA\u0002\t%HCBA\u0003\u0007\u0007\u0019)\u0001C\u0004\u0003bj\u0001\rAa'\t\u000f\u0005\u001d$\u00041\u0001\u0003r\u0006\u0001b\r\\1u\u001b\u0006\u0004xI]8vaNLeN\u0015\u000b\n3\u000e-1\u0011DB\u000f\u0007_AqA!\u0013\u001c\u0001\u0004\u0019i\u0001E\u0003S\u0007\u001f\u0019\u0019\"C\u0002\u0004\u0012M\u0013Q!\u0011:sCf\u00042AUB\u000b\u0013\r\u00199b\u0015\u0002\u0005\u0005f$X\rC\u0004\u0004\u001cm\u0001\ra!\u0004\u0002\u0019A\f7m[1hK:\u000bW.Z:\t\u000f\r}1\u00041\u0001\u0004\"\u0005i!M]8bI\u000e\f7\u000f\u001e,beN\u0004RAUB\b\u0007G\u0001ba!\n\u0004,\tuQBAB\u0014\u0015\r\u0019I#S\u0001\nEJ|\u0017\rZ2bgRLAa!\f\u0004(\tI!I]8bI\u000e\f7\u000f\u001e\u0005\b\u0007cY\u0002\u0019AB\u001a\u00031yW\u000f\u001e9viN\u001b\u0007.Z7b!\u0011\u0019)da\u000f\u000e\u0005\r]\"bAB\u001d\u000f\u0006)A/\u001f9fg&!1QHB\u001c\u0005)\u0019FO];diRK\b/Z\u0001\u0016M2\fG/T1q\u000fJ|W\u000f]:J]B\u000bg\u000eZ1t)\rI61\t\u0005\b\u0005\u007fa\u0002\u0019AB#!\r\u00018qI\u0005\u0004\u0007\u0013\n(!\u0003)zi\"|g.\u0016#G\u0003]1G.\u0019;NCB\u001cun\u0012:pkB\u001c\u0018J\u001c)b]\u0012\f7\u000fF\u0003Z\u0007\u001f\u001a\u0019\u0006C\u0004\u0004Ru\u0001\r!!\u0002\u0002\u0003IDqAa\u0010\u001e\u0001\u0004\u0019)\u0005K\u0002\u0001\u0007/\u0002Ba!\u0017\u0004^5\u001111\f\u0006\u0004\u0003\u001bK\u0015\u0002BB0\u00077\u0012aa\u0015;bE2,\u0007")
public class RelationalGroupedDataset {
    private final Dataset<Row> df;
    private final Seq<Expression> groupingExprs;
    private final GroupType groupType;

    public static RelationalGroupedDataset apply(Dataset<Row> dataset, Seq<Expression> seq, GroupType groupType) {
        return RelationalGroupedDataset$.MODULE$.apply(dataset, seq, groupType);
    }

    public Dataset<Row> agg(Column expr, Column ... exprs) {
        return this.agg(expr, (Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])exprs));
    }

    public Dataset<Row> mean(String ... colNames) {
        return this.mean((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> max(String ... colNames) {
        return this.max((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> avg(String ... colNames) {
        return this.avg((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> min(String ... colNames) {
        return this.min((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> sum(String ... colNames) {
        return this.sum((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> df() {
        return this.df;
    }

    public Seq<Expression> groupingExprs() {
        return this.groupingExprs;
    }

    private Dataset<Row> toDF(Seq<Expression> aggExprs) {
        Dataset<Row> dataset;
        Seq aggregates = this.df().sparkSession().sessionState().conf().dataFrameRetainGroupColumns() ? (Seq)this.groupingExprs().$plus$plus(aggExprs, Seq$.MODULE$.canBuildFrom()) : aggExprs;
        Seq aliasedAgg = (Seq)aggregates.map((Function1 & Serializable & scala.Serializable)expr -> this.alias((Expression)expr), Seq$.MODULE$.canBuildFrom());
        GroupType groupType = this.groupType;
        if (RelationalGroupedDataset$GroupByType$.MODULE$.equals(groupType)) {
            dataset = Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)new Aggregate(this.groupingExprs(), aliasedAgg, this.df().logicalPlan()));
        } else if (RelationalGroupedDataset$RollupType$.MODULE$.equals(groupType)) {
            dataset = Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)new Aggregate((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Rollup[]{new Rollup(this.groupingExprs())})), aliasedAgg, this.df().logicalPlan()));
        } else if (RelationalGroupedDataset$CubeType$.MODULE$.equals(groupType)) {
            dataset = Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)new Aggregate((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Cube[]{new Cube(this.groupingExprs())})), aliasedAgg, this.df().logicalPlan()));
        } else if (groupType instanceof PivotType) {
            PivotType pivotType = (PivotType)groupType;
            Expression pivotCol = pivotType.pivotCol();
            Seq<Expression> values = pivotType.values();
            Seq aliasedGrps = (Seq)this.groupingExprs().map((Function1 & Serializable & scala.Serializable)expr -> this.alias((Expression)expr), Seq$.MODULE$.canBuildFrom());
            dataset = Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)new Pivot((Option)new Some((Object)aliasedGrps), pivotCol, values, aggExprs, this.df().logicalPlan()));
        } else {
            throw new MatchError((Object)groupType);
        }
        return dataset;
    }

    private NamedExpression alias(Expression expr) {
        AggregateExpression aggregateExpression;
        NamedExpression namedExpression;
        Expression expression = expr;
        if (expression instanceof UnresolvedAttribute) {
            UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)expression;
            namedExpression = new UnresolvedAlias((Expression)unresolvedAttribute, UnresolvedAlias$.MODULE$.apply$default$2());
        } else if (expression instanceof NamedExpression) {
            NamedExpression namedExpression2;
            namedExpression = namedExpression2 = (NamedExpression)expression;
        } else if (expression instanceof AggregateExpression && (aggregateExpression = (AggregateExpression)expression).aggregateFunction() instanceof TypedAggregateExpression) {
            namedExpression = new UnresolvedAlias((Expression)aggregateExpression, (Option)new Some((Function1 & Serializable & scala.Serializable)e -> Column$.MODULE$.generateAlias((Expression)e)));
        } else if (expression != null) {
            Expression expression2;
            Expression x$1 = expression2 = expression;
            String x$2 = package$.MODULE$.toPrettySQL(expression2);
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
            namedExpression = new Alias(x$1, x$2, x$3, x$4, x$5);
        } else {
            throw new MatchError((Object)expression);
        }
        return namedExpression;
    }

    private Dataset<Row> aggregateNumericColumns(Seq<String> colNames, Function1<Expression, AggregateFunction> f) {
        Seq columnExprs = colNames.isEmpty() ? this.df().numericColumns() : (Seq)colNames.map((Function1 & Serializable & scala.Serializable)colName -> {
            void var2_2;
            NamedExpression namedExpr = this.df().resolve((String)colName);
            if (!(((Expression)namedExpr).dataType() instanceof NumericType)) {
                throw new AnalysisException(new java.lang.StringBuilder(89).append("\"").append((String)colName).append("\" is not a numeric column. ").append("Aggregation function can only be applied on a numeric column.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            return var2_2;
        }, Seq$.MODULE$.canBuildFrom());
        return this.toDF((Seq<Expression>)((Seq)columnExprs.map((Function1 & Serializable & scala.Serializable)expr -> ((AggregateFunction)f.apply(expr)).toAggregateExpression(), Seq$.MODULE$.canBuildFrom())));
    }

    private Function1<Expression, Expression> strToExpr(String expr) {
        Function1 & Serializable & scala.Serializable exprToFunc = (Function1 & Serializable & scala.Serializable)inputExpr -> {
            UnresolvedFunction unresolvedFunction;
            String string = expr.toLowerCase(Locale.ROOT);
            boolean bl = "avg".equals(string) ? true : ("average".equals(string) ? true : "mean".equals(string));
            if (bl) {
                Expression expression = inputExpr;
                unresolvedFunction = UnresolvedFunction$.MODULE$.apply("avg", (Seq)Nil$.MODULE$.$colon$colon((Object)expression), false);
            } else {
                boolean bl2 = "stddev".equals(string) ? true : "std".equals(string);
                if (bl2) {
                    Expression expression = inputExpr;
                    unresolvedFunction = UnresolvedFunction$.MODULE$.apply("stddev", (Seq)Nil$.MODULE$.$colon$colon((Object)expression), false);
                } else {
                    boolean bl3 = "count".equals(string) ? true : "size".equals(string);
                    if (bl3) {
                        Expression expression = inputExpr;
                        AggregateExpression aggregateExpression = expression instanceof Star ? Count$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).toAggregateExpression() : Count$.MODULE$.apply(inputExpr).toAggregateExpression();
                        unresolvedFunction = aggregateExpression;
                    } else {
                        Expression expression = inputExpr;
                        unresolvedFunction = UnresolvedFunction$.MODULE$.apply(string, (Seq)Nil$.MODULE$.$colon$colon((Object)expression), false);
                    }
                }
            }
            return unresolvedFunction;
        };
        return (Function1 & Serializable & scala.Serializable)inputExpr -> (Expression)exprToFunc.apply(inputExpr);
    }

    public Dataset<Row> agg(Tuple2<String, String> aggExpr, Seq<Tuple2<String, String>> aggExprs) {
        Tuple2<String, String> tuple2 = aggExpr;
        return this.toDF((Seq<Expression>)((Seq)((TraversableLike)aggExprs.$plus$colon(tuple2, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String colName = (String)tuple2._1();
            String expr = (String)tuple2._2();
            Expression expression = (Expression)this.strToExpr(expr).apply((Object)this.df().apply(colName).expr());
            return expression;
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public Dataset<Row> agg(scala.collection.immutable.Map<String, String> exprs) {
        return this.toDF((Seq<Expression>)((TraversableOnce)exprs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String colName = (String)tuple2._1();
            String expr = (String)tuple2._2();
            Expression expression = (Expression)this.strToExpr(expr).apply((Object)this.df().apply(colName).expr());
            return expression;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq());
    }

    public Dataset<Row> agg(Map<String, String> exprs) {
        return this.agg((scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(exprs).asScala()).toMap(Predef$.MODULE$.$conforms()));
    }

    public Dataset<Row> agg(Column expr, Seq<Column> exprs) {
        Column column = expr;
        return this.toDF((Seq<Expression>)((Seq)((TraversableLike)exprs.$plus$colon((Object)column, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Expression expression;
            Column column = x0$1;
            if (column instanceof TypedColumn) {
                TypedColumn typedColumn = (TypedColumn)column;
                expression = typedColumn.withInputType(this.df().exprEnc(), (Seq<Attribute>)this.df().logicalPlan().output()).expr();
            } else {
                expression = column.expr();
            }
            return expression;
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public Dataset<Row> count() {
        Alias[] aliasArray = new Alias[1];
        AggregateExpression x$1 = Count$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).toAggregateExpression();
        String x$2 = "count";
        ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
        Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
        Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
        aliasArray[0] = new Alias((Expression)x$1, x$2, x$3, x$4, x$5);
        return this.toDF((Seq<Expression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])aliasArray))));
    }

    public Dataset<Row> mean(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)Average$.MODULE$);
    }

    public Dataset<Row> max(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)Max$.MODULE$);
    }

    public Dataset<Row> avg(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)Average$.MODULE$);
    }

    public Dataset<Row> min(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)Min$.MODULE$);
    }

    public Dataset<Row> sum(Seq<String> colNames) {
        return this.aggregateNumericColumns(colNames, (Function1<Expression, AggregateFunction>)Sum$.MODULE$);
    }

    public RelationalGroupedDataset pivot(String pivotColumn) {
        return this.pivot(Column$.MODULE$.apply(pivotColumn));
    }

    public RelationalGroupedDataset pivot(String pivotColumn, Seq<Object> values) {
        return this.pivot(Column$.MODULE$.apply(pivotColumn), values);
    }

    public RelationalGroupedDataset pivot(String pivotColumn, List<Object> values) {
        return this.pivot(Column$.MODULE$.apply(pivotColumn), values);
    }

    public RelationalGroupedDataset pivot(Column pivotColumn) {
        int maxValues = this.df().sparkSession().sessionState().conf().dataFramePivotMaxValues();
        Seq values = Predef$.MODULE$.genericArrayOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.df().select((Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{pivotColumn})).distinct().limit(maxValues + 1).sort((Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{pivotColumn})).collect())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.get(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toSeq();
        if (values.length() > maxValues) {
            throw new AnalysisException(new java.lang.StringBuilder(169).append("The pivot column ").append(pivotColumn).append(" has more than ").append(maxValues).append(" distinct values, ").append("this could indicate an error. ").append("If this was intended, set ").append(SQLConf$.MODULE$.DATAFRAME_PIVOT_MAX_VALUES().key()).append(" ").append("to at least the number of distinct values of the pivot column.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.pivot(pivotColumn, (Seq<Object>)values);
    }

    public RelationalGroupedDataset pivot(Column pivotColumn, Seq<Object> values) {
        GroupType groupType = this.groupType;
        if (!RelationalGroupedDataset$GroupByType$.MODULE$.equals(groupType)) {
            if (groupType instanceof PivotType) {
                throw new UnsupportedOperationException("repeated pivots are not supported");
            }
            throw new UnsupportedOperationException("pivot is only supported after a groupBy");
        }
        Seq valueExprs = (Seq)values.map((Function1 & Serializable & scala.Serializable)x$7 -> {
            Literal literal;
            Object object = x$7;
            if (object instanceof Column) {
                Column column = (Column)object;
                literal = column.expr();
            } else {
                literal = Literal$.MODULE$.apply(object);
            }
            return literal;
        }, Seq$.MODULE$.canBuildFrom());
        RelationalGroupedDataset relationalGroupedDataset = new RelationalGroupedDataset(this.df(), this.groupingExprs(), new PivotType(pivotColumn.expr(), (Seq<Expression>)valueExprs));
        return relationalGroupedDataset;
    }

    public RelationalGroupedDataset pivot(Column pivotColumn, List<Object> values) {
        return this.pivot(pivotColumn, (Seq<Object>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(values).asScala()));
    }

    public Dataset<Row> flatMapGroupsInR(byte[] f, byte[] packageNames, Broadcast<Object>[] broadcastVars, StructType outputSchema) {
        Seq groupingNamedExpressions = (Seq)this.groupingExprs().map((Function1 & Serializable & scala.Serializable)expr -> this.alias((Expression)expr), Seq$.MODULE$.canBuildFrom());
        Seq groupingCols = (Seq)groupingNamedExpressions.map((Function1 & Serializable & scala.Serializable)x$8 -> Column$.MODULE$.apply((Expression)x$8), Seq$.MODULE$.canBuildFrom());
        Dataset<Row> groupingDataFrame = this.df().select((Seq<Column>)groupingCols);
        Seq groupingAttributes = (Seq)groupingNamedExpressions.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toAttribute(), Seq$.MODULE$.canBuildFrom());
        return Dataset$.MODULE$.ofRows(this.df().sparkSession(), FlatMapGroupsInR$.MODULE$.apply(f, packageNames, broadcastVars, outputSchema, groupingDataFrame.exprEnc().deserializer(), this.df().exprEnc().deserializer(), this.df().exprEnc().schema(), groupingAttributes, this.df().logicalPlan().output(), this.df().logicalPlan()));
    }

    public Dataset<Row> flatMapGroupsInPandas(PythonUDF expr) {
        Predef$.MODULE$.require(expr.evalType() == PythonEvalType$.MODULE$.SQL_GROUPED_MAP_PANDAS_UDF(), (Function0 & Serializable & scala.Serializable)() -> "Must pass a grouped map udf");
        Predef$.MODULE$.require(expr.dataType() instanceof StructType, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(36).append("The returnType of the udf must be a ").append(StructType$.MODULE$.simpleString()).toString());
        Seq groupingNamedExpressions = (Seq)this.groupingExprs().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            NamedExpression namedExpression;
            Expression expression = x0$1;
            if (expression instanceof NamedExpression) {
                NamedExpression namedExpression2;
                namedExpression = namedExpression2 = (NamedExpression)expression;
            } else {
                Expression x$1 = expression;
                String x$2 = expression.toString();
                ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
                Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
                Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
                namedExpression = new Alias(x$1, x$2, x$3, x$4, x$5);
            }
            return namedExpression;
        }, Seq$.MODULE$.canBuildFrom());
        Seq groupingAttributes = (Seq)groupingNamedExpressions.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toAttribute(), Seq$.MODULE$.canBuildFrom());
        LogicalPlan child = this.df().logicalPlan();
        Project project = new Project((Seq)groupingNamedExpressions.$plus$plus((GenTraversableOnce)child.output(), Seq$.MODULE$.canBuildFrom()), child);
        Seq output = ((StructType)expr.dataType()).toAttributes();
        FlatMapGroupsInPandas plan = new FlatMapGroupsInPandas(groupingAttributes, (Expression)expr, output, (LogicalPlan)project);
        return Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)plan);
    }

    public Dataset<Row> flatMapCoGroupsInPandas(RelationalGroupedDataset r, PythonUDF expr) {
        Predef$.MODULE$.require(expr.evalType() == PythonEvalType$.MODULE$.SQL_COGROUPED_MAP_PANDAS_UDF(), (Function0 & Serializable & scala.Serializable)() -> "Must pass a cogrouped map udf");
        Predef$.MODULE$.require(expr.dataType() instanceof StructType, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(36).append("The returnType of the udf must be a ").append(StructType$.MODULE$.simpleString()).toString());
        Seq leftGroupingNamedExpressions = (Seq)this.groupingExprs().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            NamedExpression namedExpression;
            Expression expression = x0$1;
            if (expression instanceof NamedExpression) {
                NamedExpression namedExpression2;
                namedExpression = namedExpression2 = (NamedExpression)expression;
            } else {
                Expression x$1 = expression;
                String x$2 = expression.toString();
                ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
                Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
                Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
                namedExpression = new Alias(x$1, x$2, x$3, x$4, x$5);
            }
            return namedExpression;
        }, Seq$.MODULE$.canBuildFrom());
        Seq rightGroupingNamedExpressions = (Seq)r.groupingExprs().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            NamedExpression namedExpression;
            Expression expression = x0$2;
            if (expression instanceof NamedExpression) {
                NamedExpression namedExpression2;
                namedExpression = namedExpression2 = (NamedExpression)expression;
            } else {
                Expression x$6 = expression;
                String x$7 = expression.toString();
                ExprId x$8 = Alias$.MODULE$.apply$default$3(x$6, x$7);
                Seq x$9 = Alias$.MODULE$.apply$default$4(x$6, x$7);
                Option x$10 = Alias$.MODULE$.apply$default$5(x$6, x$7);
                namedExpression = new Alias(x$6, x$7, x$8, x$9, x$10);
            }
            return namedExpression;
        }, Seq$.MODULE$.canBuildFrom());
        Seq leftAttributes = (Seq)leftGroupingNamedExpressions.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toAttribute(), Seq$.MODULE$.canBuildFrom());
        Seq rightAttributes = (Seq)rightGroupingNamedExpressions.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.toAttribute(), Seq$.MODULE$.canBuildFrom());
        LogicalPlan leftChild = this.df().logicalPlan();
        LogicalPlan rightChild = r.df().logicalPlan();
        Project left = new Project((Seq)leftGroupingNamedExpressions.$plus$plus((GenTraversableOnce)leftChild.output(), Seq$.MODULE$.canBuildFrom()), leftChild);
        Project right = new Project((Seq)rightGroupingNamedExpressions.$plus$plus((GenTraversableOnce)rightChild.output(), Seq$.MODULE$.canBuildFrom()), rightChild);
        Seq output = ((StructType)expr.dataType()).toAttributes();
        FlatMapCoGroupsInPandas plan = new FlatMapCoGroupsInPandas(leftAttributes, rightAttributes, (Expression)expr, output, (LogicalPlan)left, (LogicalPlan)right);
        return Dataset$.MODULE$.ofRows(this.df().sparkSession(), (LogicalPlan)plan);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RelationalGroupedDataset: [grouping expressions: [");
        Seq kFields = (Seq)this.groupingExprs().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                String string;
                boolean bl = false;
                NamedExpression namedExpression = null;
                A1 A1 = x1;
                if (A1 instanceof NamedExpression) {
                    bl = true;
                    namedExpression = (NamedExpression)A1;
                    if (((Expression)namedExpression).resolved()) {
                        string = new java.lang.StringBuilder(2).append(namedExpression.name()).append(": ").append(((Expression)namedExpression).dataType().simpleString(2)).toString();
                        return (B1)string;
                    }
                }
                if (bl) {
                    string = namedExpression.name();
                    return (B1)string;
                }
                string = A1.toString();
                return (B1)string;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Expression x1) {
                boolean bl = false;
                NamedExpression namedExpression = null;
                Expression expression = x1;
                if (expression instanceof NamedExpression) {
                    bl = true;
                    namedExpression = (NamedExpression)expression;
                    if (((Expression)namedExpression).resolved()) {
                        return true;
                    }
                }
                if (!bl) return true;
                return true;
            }
        }, Seq$.MODULE$.canBuildFrom());
        builder.append(((TraversableOnce)kFields.take(2)).mkString(", "));
        Object object = kFields.length() > 2 ? builder.append(new java.lang.StringBuilder(19).append(" ... ").append(kFields.length() - 2).append(" more field(s)").toString()) : BoxedUnit.UNIT;
        return builder.append(new java.lang.StringBuilder(19).append("], value: ").append(this.df().toString()).append(", type: ").append(this.groupType).append("]").toString()).toString();
    }

    public RelationalGroupedDataset(Dataset<Row> df, Seq<Expression> groupingExprs, GroupType groupType) {
        this.df = df;
        this.groupingExprs = groupingExprs;
        this.groupType = groupType;
    }

    public static interface GroupType {
        default public String toString() {
            return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(this.getClass().getSimpleName())).stripSuffix("$"))).stripSuffix("Type");
        }

        public static void $init$(GroupType $this) {
        }
    }

    public static class PivotType
    implements GroupType,
    Product,
    scala.Serializable {
        private final Expression pivotCol;
        private final Seq<Expression> values;

        @Override
        public String toString() {
            return ((GroupType)this).toString();
        }

        public Expression pivotCol() {
            return this.pivotCol;
        }

        public Seq<Expression> values() {
            return this.values;
        }

        public PivotType copy(Expression pivotCol, Seq<Expression> values) {
            return new PivotType(pivotCol, values);
        }

        public Expression copy$default$1() {
            return this.pivotCol();
        }

        public Seq<Expression> copy$default$2() {
            return this.values();
        }

        public String productPrefix() {
            return "PivotType";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Seq<Expression> seq;
            int n = x$1;
            switch (n) {
                case 0: {
                    seq = this.pivotCol();
                    break;
                }
                case 1: {
                    seq = this.values();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return seq;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PivotType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PivotType)) return false;
            boolean bl = true;
            if (!bl) return false;
            PivotType pivotType = (PivotType)x$1;
            Expression expression = this.pivotCol();
            Expression expression2 = pivotType.pivotCol();
            if (expression == null) {
                if (expression2 != null) {
                    return false;
                }
            } else if (!expression.equals(expression2)) return false;
            Seq<Expression> seq = this.values();
            Seq<Expression> seq2 = pivotType.values();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!pivotType.canEqual(this)) return false;
            return true;
        }

        public PivotType(Expression pivotCol, Seq<Expression> values) {
            this.pivotCol = pivotCol;
            this.values = values;
            GroupType.$init$(this);
            Product.$init$((Product)this);
        }
    }
}

