/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import java.util.Properties;
import org.apache.spark.annotation.Stable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.analysis.NamedRelation;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.AppendData$;
import org.apache.spark.sql.catalyst.plans.logical.CreateTableAsSelect;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OverwriteByExpression$;
import org.apache.spark.sql.catalyst.plans.logical.OverwritePartitionsDynamic$;
import org.apache.spark.sql.catalyst.plans.logical.ReplaceTableAsSelect;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.expressions.BucketTransform;
import org.apache.spark.sql.connector.expressions.FieldReference$;
import org.apache.spark.sql.connector.expressions.IdentityTransform;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.LiteralValue;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.FileDataSourceV2;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

@Stable
@ScalaSignature(bytes="\u0006\u0001\t]h\u0001\u0002\u001e<\u0005\u0011C\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006I!\u0014\u0005\u00079\u0002!\taO/\t\u000f\u0001\u0004!\u0019!C\u0005C\"1\u0011\u000e\u0001Q\u0001\n\tDQA\u001b\u0001\u0005\u0002-DQA\u001b\u0001\u0005\u0002EDQA \u0001\u0005\u0002}Dq!!\u0002\u0001\t\u0003\t9\u0001C\u0004\u0002\u0006\u0001!\t!!\u0005\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\u001e!9\u0011Q\u0001\u0001\u0005\u0002\u0005%\u0002bBA\u001b\u0001\u0011\u0005\u0011q\u0007\u0005\b\u0003k\u0001A\u0011AA$\u0011\u001d\tI\u0006\u0001C\u0001\u00037Bq!!\u001e\u0001\t\u0003\t9\bC\u0004\u0002\f\u0002!\t!!$\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\"9\u0011Q\u0013\u0001\u0005\u0002\u0005\r\u0006bBAS\u0001\u0011%\u00111\u0015\u0005\b\u0003O\u0003A\u0011AAU\u0011\u001d\t9\u000b\u0001C\u0005\u0003_Cq!a*\u0001\t\u0013\ti\rC\u0004\u0002`\u0002!I!!9\t\u000f\u0005M\b\u0001\"\u0003\u0002v\"9\u00111 \u0001\u0005\n\u0005u\bb\u0002B\u0001\u0001\u0011\u0005!1\u0001\u0005\b\u0005\u0003\u0001A\u0011\u0002B\u0004\u0011\u001d\u0011\t\u0001\u0001C\u0005\u0005'AqAa\u0006\u0001\t\u0013\u0011I\u0002C\u0004\u0003\u001e\u0001!\tAa\b\t\u000f\tM\u0002\u0001\"\u0001\u00036!9!\u0011\b\u0001\u0005\u0002\tm\u0002b\u0002B \u0001\u0011\u0005!\u0011\t\u0005\b\u0005\u000b\u0002A\u0011\u0001B$\u0011\u001d\u0011Y\u0005\u0001C\u0001\u0005\u001bBqA!\u0015\u0001\t\u0013\u0011\u0019\u0006C\u0004\u0003z\u0001!IAa\u001f\t\u0013\u0005\r\u0001\u00011A\u0005\n\t\u0015\u0005\"\u0003BD\u0001\u0001\u0007I\u0011\u0002BE\u0011\u001d\u0011y\t\u0001Q!\nMD\u0001B\u001b\u0001A\u0002\u0013%!\u0011\u0013\u0005\n\u0005'\u0003\u0001\u0019!C\u0005\u0005+CqA!'\u0001A\u0003&a\u000eC\u0005\u0003\u001c\u0002\u0011\r\u0011\"\u0003\u0003\u001e\"A!1\u0016\u0001!\u0002\u0013\u0011y\nC\u0005\u0003.\u0002\u0001\r\u0011\"\u0003\u00030\"I!1\u0019\u0001A\u0002\u0013%!Q\u0019\u0005\t\u0005\u0013\u0004\u0001\u0015)\u0003\u00032\"I!1\u001a\u0001A\u0002\u0013%!q\u0016\u0005\n\u0005\u001b\u0004\u0001\u0019!C\u0005\u0005\u001fD\u0001Ba5\u0001A\u0003&!\u0011\u0017\u0005\n\u0003w\u0002\u0001\u0019!C\u0005\u0005+D\u0011B!7\u0001\u0001\u0004%IAa7\t\u0011\t}\u0007\u0001)Q\u0005\u0005/D\u0011B!9\u0001\u0001\u0004%IAa,\t\u0013\t\r\b\u00011A\u0005\n\t\u0015\b\u0002\u0003Bu\u0001\u0001\u0006KA!-\u0003\u001f\u0011\u000bG/\u0019$sC6,wK]5uKJT!\u0001P\u001f\u0002\u0007M\fHN\u0003\u0002?\u007f\u0005)1\u000f]1sW*\u0011\u0001)Q\u0001\u0007CB\f7\r[3\u000b\u0003\t\u000b1a\u001c:h\u0007\u0001)\"!R*\u0014\u0005\u00011\u0005CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%AB!osJ+g-\u0001\u0002egB\u0019ajT)\u000e\u0003mJ!\u0001U\u001e\u0003\u000f\u0011\u000bG/Y:fiB\u0011!k\u0015\u0007\u0001\t\u0015!\u0006A1\u0001V\u0005\u0005!\u0016C\u0001,Z!\t9u+\u0003\u0002Y\u0011\n9aj\u001c;iS:<\u0007CA$[\u0013\tY\u0006JA\u0002B]f\fa\u0001P5oSRtDC\u00010`!\rq\u0005!\u0015\u0005\u0006\u0019\n\u0001\r!T\u0001\u0003I\u001a,\u0012A\u0019\t\u0003G\u001at!A\u00143\n\u0005\u0015\\\u0014a\u00029bG.\fw-Z\u0005\u0003O\"\u0014\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005\u0015\\\u0014a\u00013gA\u0005!Qn\u001c3f)\tqF\u000eC\u0003n\u000b\u0001\u0007a.\u0001\u0005tCZ,Wj\u001c3f!\tqu.\u0003\u0002qw\tA1+\u0019<f\u001b>$W\r\u0006\u0002_e\")QN\u0002a\u0001gB\u0011Ao\u001f\b\u0003kf\u0004\"A\u001e%\u000e\u0003]T!\u0001_\"\u0002\rq\u0012xn\u001c;?\u0013\tQ\b*\u0001\u0004Qe\u0016$WMZ\u0005\u0003yv\u0014aa\u0015;sS:<'B\u0001>I\u0003\u00191wN]7biR\u0019a,!\u0001\t\r\u0005\rq\u00011\u0001t\u0003\u0019\u0019x.\u001e:dK\u00061q\u000e\u001d;j_:$RAXA\u0005\u0003\u001bAa!a\u0003\t\u0001\u0004\u0019\u0018aA6fs\"1\u0011q\u0002\u0005A\u0002M\fQA^1mk\u0016$RAXA\n\u0003+Aa!a\u0003\n\u0001\u0004\u0019\bbBA\b\u0013\u0001\u0007\u0011q\u0003\t\u0004\u000f\u0006e\u0011bAA\u000e\u0011\n9!i\\8mK\u0006tG#\u00020\u0002 \u0005\u0005\u0002BBA\u0006\u0015\u0001\u00071\u000fC\u0004\u0002\u0010)\u0001\r!a\t\u0011\u0007\u001d\u000b)#C\u0002\u0002(!\u0013A\u0001T8oOR)a,a\u000b\u0002.!1\u00111B\u0006A\u0002MDq!a\u0004\f\u0001\u0004\ty\u0003E\u0002H\u0003cI1!a\rI\u0005\u0019!u.\u001e2mK\u00069q\u000e\u001d;j_:\u001cHc\u00010\u0002:!9\u0011Q\u0007\u0007A\u0002\u0005m\u0002CBA\u001f\u0003\u0007\u001a8/\u0004\u0002\u0002@)\u0019\u0011\u0011\t%\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002F\u0005}\"aA'baR\u0019a,!\u0013\t\u000f\u0005UR\u00021\u0001\u0002LA1\u0011QJA,gNl!!a\u0014\u000b\t\u0005E\u00131K\u0001\u0005kRLGN\u0003\u0002\u0002V\u0005!!.\u0019<b\u0013\u0011\t)%a\u0014\u0002\u0017A\f'\u000f^5uS>t')\u001f\u000b\u0004=\u0006u\u0003bBA0\u001d\u0001\u0007\u0011\u0011M\u0001\tG>dg*Y7fgB!q)a\u0019t\u0013\r\t)\u0007\u0013\u0002\u000byI,\u0007/Z1uK\u0012t\u0004f\u0001\b\u0002jA!\u00111NA9\u001b\t\tiGC\u0002\u0002p!\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019(!\u001c\u0003\u000fY\f'/\u0019:hg\u0006A!-^2lKR\u0014\u0015\u0010F\u0004_\u0003s\n\u0019)a\"\t\u000f\u0005mt\u00021\u0001\u0002~\u0005Qa.^7Ck\u000e\\W\r^:\u0011\u0007\u001d\u000by(C\u0002\u0002\u0002\"\u00131!\u00138u\u0011\u0019\t)i\u0004a\u0001g\u000691m\u001c7OC6,\u0007bBA0\u001f\u0001\u0007\u0011\u0011\r\u0015\u0004\u001f\u0005%\u0014AB:peR\u0014\u0015\u0010F\u0003_\u0003\u001f\u000b\t\n\u0003\u0004\u0002\u0006B\u0001\ra\u001d\u0005\b\u0003?\u0002\u0002\u0019AA1Q\r\u0001\u0012\u0011N\u0001\u0005g\u00064X\r\u0006\u0003\u0002\u001a\u0006}\u0005cA$\u0002\u001c&\u0019\u0011Q\u0014%\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003C\u000b\u0002\u0019A:\u0002\tA\fG\u000f\u001b\u000b\u0003\u00033\u000bab]1wKR{g+M*pkJ\u001cW-\u0001\u0006j]N,'\u000f^%oi>$B!!'\u0002,\"1\u0011Q\u0016\u000bA\u0002M\f\u0011\u0002^1cY\u0016t\u0015-\\3\u0015\r\u0005e\u0015\u0011WAb\u0011\u001d\t\u0019,\u0006a\u0001\u0003k\u000bqaY1uC2|w\r\u0005\u0003\u00028\u0006}VBAA]\u0015\u0011\t\u0019,a/\u000b\u0007\u0005u6(A\u0005d_:tWm\u0019;pe&!\u0011\u0011YA]\u00055\u0019\u0015\r^1m_\u001e\u0004F.^4j]\"9\u0011QY\u000bA\u0002\u0005\u001d\u0017!B5eK:$\b\u0003BA\\\u0003\u0013LA!a3\u0002:\nQ\u0011\nZ3oi&4\u0017.\u001a:\u0015\t\u0005e\u0015q\u001a\u0005\b\u0003#4\u0002\u0019AAj\u0003)!\u0018M\u00197f\u0013\u0012,g\u000e\u001e\t\u0005\u0003+\fY.\u0004\u0002\u0002X*\u0019\u0011\u0011\\\u001e\u0002\u0011\r\fG/\u00197zgRLA!!8\u0002X\nyA+\u00192mK&#WM\u001c;jM&,'/A\u0007hKR\u0014UoY6fiN\u0003XmY\u000b\u0003\u0003G\u0004RaRAs\u0003SL1!a:I\u0005\u0019y\u0005\u000f^5p]B!\u00111^Ax\u001b\t\tiO\u0003\u0003\u00024\u0006]\u0017\u0002BAy\u0003[\u0014!BQ;dW\u0016$8\u000b]3d\u0003E\t7o]3si:{GOQ;dW\u0016$X\r\u001a\u000b\u0005\u00033\u000b9\u0010\u0003\u0004\u0002zb\u0001\ra]\u0001\n_B,'/\u0019;j_:\fA#Y:tKJ$hj\u001c;QCJ$\u0018\u000e^5p]\u0016$G\u0003BAM\u0003\u007fDa!!?\u001a\u0001\u0004\u0019\u0018aC:bm\u0016\f5\u000fV1cY\u0016$B!!'\u0003\u0006!1\u0011Q\u0016\u000eA\u0002M$b!!'\u0003\n\tE\u0001bBAZ7\u0001\u0007!1\u0002\t\u0005\u0003o\u0013i!\u0003\u0003\u0003\u0010\u0005e&\u0001\u0004+bE2,7)\u0019;bY><\u0007bBAc7\u0001\u0007\u0011q\u0019\u000b\u0005\u00033\u0013)\u0002C\u0004\u0002Rr\u0001\r!a5\u0002\u0017\r\u0014X-\u0019;f)\u0006\u0014G.\u001a\u000b\u0005\u00033\u0013Y\u0002C\u0004\u0002Rv\u0001\r!a5\u0002\t)$'m\u0019\u000b\t\u00033\u0013\tC!\n\u0003*!1!1\u0005\u0010A\u0002M\f1!\u001e:m\u0011\u0019\u00119C\ba\u0001g\u0006)A/\u00192mK\"9!1\u0006\u0010A\u0002\t5\u0012\u0001F2p]:,7\r^5p]B\u0013x\u000e]3si&,7\u000f\u0005\u0003\u0002N\t=\u0012\u0002\u0002B\u0019\u0003\u001f\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0003\u0011Q7o\u001c8\u0015\t\u0005e%q\u0007\u0005\u0007\u0003C{\u0002\u0019A:\u0002\u000fA\f'/];fiR!\u0011\u0011\u0014B\u001f\u0011\u0019\t\t\u000b\ta\u0001g\u0006\u0019qN]2\u0015\t\u0005e%1\t\u0005\u0007\u0003C\u000b\u0003\u0019A:\u0002\tQ,\u0007\u0010\u001e\u000b\u0005\u00033\u0013I\u0005\u0003\u0004\u0002\"\n\u0002\ra]\u0001\u0004GN4H\u0003BAM\u0005\u001fBa!!)$\u0001\u0004\u0019\u0018A\u0003:v]\u000e{W.\\1oIR1!Q\u000bB6\u0005k\"B!!'\u0003X!9!\u0011\f\u0013A\u0002\tm\u0013aB2p[6\fg\u000e\u001a\t\u0005\u0005;\u00129'\u0004\u0002\u0003`)!!\u0011\rB2\u0003\u001dawnZ5dC2TAA!\u001a\u0002X\u0006)\u0001\u000f\\1og&!!\u0011\u000eB0\u0005-aunZ5dC2\u0004F.\u00198\t\u000f\t5D\u00051\u0001\u0003p\u000591/Z:tS>t\u0007c\u0001(\u0003r%\u0019!1O\u001e\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\r\t]D\u00051\u0001t\u0003\u0011q\u0017-\\3\u0002!1|wn[;q-J\u0002&o\u001c<jI\u0016\u0014HC\u0001B?!\u00159\u0015Q\u001dB@!\u0011\t9L!!\n\t\t\r\u0015\u0011\u0018\u0002\u000e)\u0006\u0014G.\u001a)s_ZLG-\u001a:\u0016\u0003M\f!b]8ve\u000e,w\fJ3r)\u0011\tIJa#\t\u0011\t5u%!AA\u0002M\f1\u0001\u001f\u00132\u0003\u001d\u0019x.\u001e:dK\u0002*\u0012A\\\u0001\t[>$Wm\u0018\u0013fcR!\u0011\u0011\u0014BL\u0011!\u0011iIKA\u0001\u0002\u0004q\u0017!B7pI\u0016\u0004\u0013\u0001D3yiJ\fw\n\u001d;j_:\u001cXC\u0001BP!\u0019\u0011\tKa*tg6\u0011!1\u0015\u0006\u0005\u0005K\u000by$A\u0004nkR\f'\r\\3\n\t\t%&1\u0015\u0002\b\u0011\u0006\u001c\b.T1q\u00035)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8tA\u0005\u0019\u0002/\u0019:uSRLwN\\5oO\u000e{G.^7ogV\u0011!\u0011\u0017\t\u0006\u000f\u0006\u0015(1\u0017\t\u0006\u0005k\u0013il\u001d\b\u0005\u0005o\u0013YLD\u0002w\u0005sK\u0011!S\u0005\u0003K\"KAAa0\u0003B\n\u00191+Z9\u000b\u0005\u0015D\u0015a\u00069beRLG/[8oS:<7i\u001c7v[:\u001cx\fJ3r)\u0011\tIJa2\t\u0013\t5u&!AA\u0002\tE\u0016\u0001\u00069beRLG/[8oS:<7i\u001c7v[:\u001c\b%A\tck\u000e\\W\r^\"pYVlgNT1nKN\fQCY;dW\u0016$8i\u001c7v[:t\u0015-\\3t?\u0012*\u0017\u000f\u0006\u0003\u0002\u001a\nE\u0007\"\u0003BGe\u0005\u0005\t\u0019\u0001BY\u0003I\u0011WoY6fi\u000e{G.^7o\u001d\u0006lWm\u001d\u0011\u0016\u0005\t]\u0007#B$\u0002f\u0006u\u0014A\u00048v[\n+8m[3ug~#S-\u001d\u000b\u0005\u00033\u0013i\u000eC\u0005\u0003\u000eV\n\t\u00111\u0001\u0003X\u0006Ya.^7Ck\u000e\\W\r^:!\u0003=\u0019xN\u001d;D_2,XN\u001c(b[\u0016\u001c\u0018aE:peR\u001cu\u000e\\;n]:\u000bW.Z:`I\u0015\fH\u0003BAM\u0005OD\u0011B!$9\u0003\u0003\u0005\rA!-\u0002!M|'\u000f^\"pYVlgNT1nKN\u0004\u0003f\u0001\u0001\u0003nB!!q\u001eBz\u001b\t\u0011\tPC\u0002\u0002puJAA!>\u0003r\n11\u000b^1cY\u0016\u0004")
public final class DataFrameWriter<T> {
    private final Dataset<Row> df;
    private String source;
    private SaveMode mode;
    private final HashMap<String, String> extraOptions;
    private Option<Seq<String>> partitioningColumns;
    private Option<Seq<String>> bucketColumnNames;
    private Option<Object> numBuckets;
    private Option<Seq<String>> sortColumnNames;

    public DataFrameWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, String ... colNames) {
        return this.bucketBy(numBuckets, colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> sortBy(String colName, String ... colNames) {
        return this.sortBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    public DataFrameWriter<T> mode(SaveMode saveMode) {
        this.mode_$eq(saveMode);
        return this;
    }

    public DataFrameWriter<T> mode(String saveMode) {
        DataFrameWriter<T> dataFrameWriter;
        String string = saveMode.toLowerCase(Locale.ROOT);
        if ("overwrite".equals(string)) {
            dataFrameWriter = this.mode(SaveMode.Overwrite);
        } else if ("append".equals(string)) {
            dataFrameWriter = this.mode(SaveMode.Append);
        } else if ("ignore".equals(string)) {
            dataFrameWriter = this.mode(SaveMode.Ignore);
        } else {
            boolean bl = "error".equals(string) ? true : ("errorifexists".equals(string) ? true : "default".equals(string));
            if (bl) {
                dataFrameWriter = this.mode(SaveMode.ErrorIfExists);
            } else {
                throw new IllegalArgumentException(new StringBuilder(114).append("Unknown save mode: ").append(saveMode).append(". Accepted ").append("save modes are 'overwrite', 'append', 'ignore', 'error', 'errorifexists', 'default'.").toString());
            }
        }
        return dataFrameWriter;
    }

    public DataFrameWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameWriter<T> option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameWriter<T> option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameWriter<T> option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameWriter<T> option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameWriter<T> options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataFrameWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public DataFrameWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, Seq<String> colNames) {
        this.numBuckets_$eq((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numBuckets)));
        String string = colName;
        this.bucketColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public DataFrameWriter<T> sortBy(String colName, Seq<String> colNames) {
        String string = colName;
        this.sortColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public void save(String path) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path));
        this.save();
    }

    public void save() {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException("Hive data source can only be used with tables, you can not write files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        this.assertNotBucketed("save");
        Option<TableProvider> maybeV2Provider = this.lookupV2Provider();
        if (maybeV2Provider.isDefined()) {
            SupportsWrite supportsWrite;
            scala.collection.immutable.Map<String, String> sessionOptions;
            scala.collection.immutable.Map options;
            CaseInsensitiveStringMap dsOptions;
            TableProvider provider = (TableProvider)maybeV2Provider.get();
            Table table = provider.getTable(dsOptions = new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)(options = (sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(provider, this.df().sparkSession().sessionState().conf())).$plus$plus(this.extraOptions()))).asJava()));
            if (table instanceof SupportsWrite && DataSourceV2Implicits$.MODULE$.TableHelper((Table)(supportsWrite = (SupportsWrite)table)).supports(TableCapability.BATCH_WRITE)) {
                LazyRef relation$lzy = new LazyRef();
                if (this.partitioningColumns().nonEmpty()) {
                    throw new AnalysisException("Cannot write data to TableProvider implementation if partition columns are specified.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                SaveMode saveMode = this.mode();
                if (((Object)((Object)SaveMode.Append)).equals((Object)saveMode)) {
                    this.runCommand(this.df().sparkSession(), "save", (LogicalPlan)AppendData$.MODULE$.byName((NamedRelation)DataFrameWriter.relation$1(relation$lzy, supportsWrite, dsOptions), this.df().logicalPlan(), this.extraOptions().toMap(Predef$.MODULE$.$conforms())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (((Object)((Object)SaveMode.Overwrite)).equals((Object)saveMode) && DataSourceV2Implicits$.MODULE$.TableHelper((Table)supportsWrite).supportsAny((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableCapability[]{TableCapability.TRUNCATE, TableCapability.OVERWRITE_BY_FILTER}))) {
                    this.runCommand(this.df().sparkSession(), "save", (LogicalPlan)OverwriteByExpression$.MODULE$.byName((NamedRelation)DataFrameWriter.relation$1(relation$lzy, supportsWrite, dsOptions), this.df().logicalPlan(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.extraOptions().toMap(Predef$.MODULE$.$conforms())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new AnalysisException(new StringBuilder(105).append("TableProvider implementation ").append(this.source()).append(" cannot be ").append("written with ").append((Object)saveMode).append(" mode, please use Append or Overwrite ").append("modes instead.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.saveToV1Source();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            this.saveToV1Source();
        }
    }

    private void saveToV1Source() {
        this.partitioningColumns().foreach((Function1 & Serializable & scala.Serializable)columns -> this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.PARTITIONING_COLUMNS_KEY()), (Object)DataSourceUtils$.MODULE$.encodePartitioningColumns((Seq<String>)columns))));
        SparkSession x$1 = this.df().sparkSession();
        String x$2 = this.source();
        Seq x$3 = (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        scala.collection.immutable.Map x$4 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$6 = DataSource$.MODULE$.apply$default$4();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        this.runCommand(this.df().sparkSession(), "save", new DataSource(x$1, x$2, x$5, x$6, (Seq<String>)x$3, x$7, (scala.collection.immutable.Map<String, String>)x$4, x$8).planForWriting(this.mode(), this.df().logicalPlan()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void insertInto(String tableName) {
        Option option;
        Some some;
        this.assertNotBucketed("insertInto");
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException("insertInto() can't be used together with partitionBy(). Partition columns have already been defined for the table. It is not necessary to use partitionBy().", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        SparkSession session = this.df().sparkSession();
        boolean canUseV2 = this.lookupV2Provider().isDefined();
        Seq seq = session.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        Some some2 = this.df().sparkSession().sessionState().analyzer().CatalogObjectIdentifier().unapply(seq);
        if (!some2.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)some2.get())._1();
            Identifier ident = (Identifier)((Tuple2)some2.get())._2();
            if (!CatalogV2Util$.MODULE$.isSessionCatalog(catalog)) {
                this.insertInto(catalog, ident);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (!(some = this.df().sparkSession().sessionState().analyzer().CatalogObjectIdentifier().unapply(seq)).isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)some.get())._1();
            Identifier ident = (Identifier)((Tuple2)some.get())._2();
            if (CatalogV2Util$.MODULE$.isSessionCatalog(catalog) && canUseV2 && ident.namespace().length <= 1) {
                this.insertInto(catalog, ident);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if ((option = this.df().sparkSession().sessionState().analyzer().AsTableIdentifier().unapply(seq)).isEmpty()) throw new AnalysisException(new StringBuilder(50).append("Couldn't find a catalog to handle the identifier ").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(seq).quoted()).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        TableIdentifier tableIdentifier = (TableIdentifier)option.get();
        this.insertInto(tableIdentifier);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Unable to fully structure code
     */
    private void insertInto(CatalogPlugin catalog, Identifier ident) {
        block4: {
            block5: {
                block3: {
                    var7_3 = CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog().loadTable(ident);
                    if (var7_3 instanceof V1Table) {
                        this.insertInto(new TableIdentifier(ident.name(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).headOption()));
                        return;
                    }
                    table = var5_4 = DataSourceV2Relation$.MODULE$.create(var7_3);
                    var9_6 = this.mode();
                    var4_7 = SaveMode.Append.equals((Object)var9_6) != false ? true : (SaveMode.ErrorIfExists.equals((Object)var9_6) != false ? true : SaveMode.Ignore.equals((Object)var9_6) != false);
                    if (!var4_7) break block3;
                    var3_8 = AppendData$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), this.extraOptions().toMap(Predef$.MODULE$.$conforms()));
                    break block4;
                }
                if (!SaveMode.Overwrite.equals((Object)var9_6)) break block5;
                conf = this.df().sparkSession().sessionState().conf();
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.table().partitioning())).size() <= 0) ** GOTO lbl-1000
                v0 = conf.partitionOverwriteMode();
                var12_10 = SQLConf.PartitionOverwriteMode$.MODULE$.DYNAMIC();
                if (!(v0 != null ? v0.equals(var12_10) == false : var12_10 != null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                dynamicPartitionOverwrite = v1;
                var3_8 = dynamicPartitionOverwrite != false ? OverwritePartitionsDynamic$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), this.extraOptions().toMap(Predef$.MODULE$.$conforms())) : OverwriteByExpression$.MODULE$.byPosition((NamedRelation)table, this.df().logicalPlan(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)), this.extraOptions().toMap(Predef$.MODULE$.$conforms()));
                break block4;
            }
            throw new MatchError((Object)var9_6);
        }
        command = var3_8;
        this.runCommand(this.df().sparkSession(), "insertInto", (LogicalPlan)command);
    }

    private void insertInto(TableIdentifier tableIdent) {
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = SaveMode.Overwrite;
        this.runCommand(this.df().sparkSession(), "insertInto", (LogicalPlan)new InsertIntoStatement((LogicalPlan)UnresolvedRelation$.MODULE$.apply(tableIdent), Predef$.MODULE$.Map().empty(), this.df().logicalPlan(), !(saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode2) : saveMode2 != null), false));
    }

    private Option<BucketSpec> getBucketSpec() {
        if (this.sortColumnNames().isDefined() && this.numBuckets().isEmpty()) {
            throw new AnalysisException("sortBy must be used together with bucketBy", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.numBuckets().map((Function1 & Serializable & scala.Serializable)n -> DataFrameWriter.$anonfun$getBucketSpec$1(this, BoxesRunTime.unboxToInt((Object)n)));
    }

    private void assertNotBucketed(String operation) {
        if (this.getBucketSpec().isDefined()) {
            if (this.sortColumnNames().isEmpty()) {
                throw new AnalysisException(new StringBuilder(38).append("'").append(operation).append("' does not support bucketBy right now").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            throw new AnalysisException(new StringBuilder(49).append("'").append(operation).append("' does not support bucketBy and sortBy right now").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException(new StringBuilder(32).append("'").append(operation).append("' does not support partitioning").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void saveAsTable(String tableName) {
        Option option;
        Some some;
        SparkSession session = this.df().sparkSession();
        boolean canUseV2 = this.lookupV2Provider().isDefined();
        Seq seq = session.sessionState().sqlParser().parseMultipartIdentifier(tableName);
        Some some2 = this.df().sparkSession().sessionState().analyzer().CatalogObjectIdentifier().unapply(seq);
        if (!some2.isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)some2.get())._1();
            Identifier ident = (Identifier)((Tuple2)some2.get())._2();
            if (!CatalogV2Util$.MODULE$.isSessionCatalog(catalog)) {
                this.saveAsTable(CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog(), ident);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (!(some = this.df().sparkSession().sessionState().analyzer().CatalogObjectIdentifier().unapply(seq)).isEmpty()) {
            CatalogPlugin catalog = (CatalogPlugin)((Tuple2)some.get())._1();
            Identifier ident = (Identifier)((Tuple2)some.get())._2();
            if (CatalogV2Util$.MODULE$.isSessionCatalog(catalog) && canUseV2 && ident.namespace().length <= 1) {
                this.saveAsTable(CatalogV2Implicits$.MODULE$.CatalogHelper(catalog).asTableCatalog(), ident);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if ((option = this.df().sparkSession().sessionState().analyzer().AsTableIdentifier().unapply(seq)).isEmpty()) throw new AnalysisException(new StringBuilder(50).append("Couldn't find a catalog to handle the identifier ").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(seq).quoted()).append(".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        TableIdentifier tableIdentifier = (TableIdentifier)option.get();
        this.saveAsTable(tableIdentifier);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Unable to fully structure code
     */
    private void saveAsTable(TableCatalog catalog, Identifier ident) {
        partitioning = (Seq)this.partitioningColumns().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$saveAsTable$1(scala.collection.Seq ), (Lscala/collection/Seq;)Lscala/collection/Seq;)()).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$saveAsTable$3(), ()Lscala/collection/Seq;)());
        bucketing = (Seq)this.bucketColumnNames().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$saveAsTable$4(org.apache.spark.sql.DataFrameWriter scala.collection.Seq ), (Lscala/collection/Seq;)Lscala/collection/Seq;)((DataFrameWriter)this)).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$saveAsTable$6(), ()Lscala/collection/Seq;)());
        partitionTransforms = (Seq)partitioning.$plus$plus((GenTraversableOnce)bucketing, Seq$.MODULE$.canBuildFrom());
        try {
            v0 = Option$.MODULE$.apply((Object)catalog.loadTable(ident));
        }
        catch (NoSuchTableException v1) {
            v0 = None$.MODULE$;
        }
        tableOpt = v0;
        var9_7 = new Tuple2((Object)this.mode(), (Object)tableOpt);
        if (var9_7 != null && (var10_8 = (Option)var9_7._2()) instanceof Some && (table = (Table)(var11_9 = (Some)var10_8).value()) instanceof V1Table) {
            this.saveAsTable(new TableIdentifier(ident.name(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).headOption()));
            return;
        }
        if (var9_7 == null) ** GOTO lbl-1000
        var13_11 = (SaveMode)var9_7._1();
        var14_12 = (Option)var9_7._2();
        if (SaveMode.Append.equals((Object)var13_11) && var14_12 instanceof Some) {
            var15_13 = (Some)var14_12;
            table = (Table)var15_13.value();
            var3_15 = AppendData$.MODULE$.byName((NamedRelation)DataSourceV2Relation$.MODULE$.create(table), this.df().logicalPlan(), AppendData$.MODULE$.byName$default$3());
        } else if (var9_7 != null && SaveMode.Overwrite.equals((Object)(var17_16 = (SaveMode)var9_7._1()))) {
            var3_15 = new ReplaceTableAsSelect(catalog, ident, partitionTransforms, this.df().queryExecution().analyzed(), ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)this.source())}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.getLocationIfExists$1())), this.extraOptions().toMap(Predef$.MODULE$.$conforms()), true);
        } else if (var9_7 != null) {
            other = (SaveMode)var9_7._1();
            v2 = other;
            var19_18 = SaveMode.Ignore;
            var3_15 = new CreateTableAsSelect(catalog, ident, partitionTransforms, this.df().queryExecution().analyzed(), ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"provider"), (Object)this.source())}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.getLocationIfExists$1())), this.extraOptions().toMap(Predef$.MODULE$.$conforms()), !(v2 != null ? v2.equals((Object)var19_18) == false : var19_18 != null));
        } else {
            throw new MatchError((Object)var9_7);
        }
        command = var3_15;
        this.runCommand(this.df().sparkSession(), "saveAsTable", (LogicalPlan)command);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void saveAsTable(TableIdentifier tableIdent) {
        SessionCatalog catalog = this.df().sparkSession().sessionState().catalog();
        boolean tableExists = catalog.tableExists(tableIdent);
        String db = (String)tableIdent.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> catalog.getCurrentDatabase());
        Some x$1 = new Some((Object)db);
        String x$2 = tableIdent.copy$default$1();
        TableIdentifier tableIdentWithDB = tableIdent.copy(x$2, (Option)x$1);
        String tableName = tableIdentWithDB.unquotedString();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)tableExists), (Object)this.mode());
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Ignore)).equals((Object)saveMode)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.ErrorIfExists)).equals((Object)saveMode)) {
                throw new AnalysisException(new StringBuilder(22).append("Table ").append(tableIdent).append(" already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Overwrite)).equals((Object)saveMode)) {
                HiveTableRelation hiveTableRelation;
                BaseRelation baseRelation;
                LogicalRelation logicalRelation;
                BaseRelation dest;
                Seq srcRelations = this.df().logicalPlan().collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        A1 A1 = x1;
                        if (A1 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)A1).relation()) != null) {
                            BaseRelation baseRelation = src;
                            object = baseRelation;
                        } else if (A1 instanceof HiveTableRelation) {
                            HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                            object = hiveTableRelation.tableMeta().identifier();
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        LogicalPlan logicalPlan2 = x1;
                        boolean bl = logicalPlan2 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null ? true : logicalPlan2 instanceof HiveTableRelation;
                        return bl;
                    }
                });
                LogicalPlan tableRelation = this.df().sparkSession().table(tableIdentWithDB).queryExecution().analyzed();
                LogicalPlan logicalPlan2 = EliminateSubqueryAliases$.MODULE$.apply(tableRelation);
                if (logicalPlan2 instanceof LogicalRelation && (dest = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null && srcRelations.contains((Object)(baseRelation = dest))) {
                    throw new AnalysisException(new StringBuilder(52).append("Cannot overwrite table ").append(tableName).append(" that is also being read from").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                if (logicalPlan2 instanceof HiveTableRelation && srcRelations.contains((Object)(hiveTableRelation = (HiveTableRelation)logicalPlan2).tableMeta().identifier())) {
                    throw new AnalysisException(new StringBuilder(52).append("Cannot overwrite table ").append(tableName).append(" that is also being read from").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                catalog.dropTable(tableIdentWithDB, true, false);
                this.createTable(tableIdentWithDB);
                catalog.refreshTable(tableIdentWithDB);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
        }
        this.createTable(tableIdent);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void createTable(TableIdentifier tableIdent) {
        CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.$conforms()));
        CatalogTableType tableType = storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        CatalogTable tableDesc = new CatalogTable(tableIdent, tableType, storage, new StructType(), (Option)new Some((Object)this.source()), (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), this.getBucketSpec(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
        this.runCommand(this.df().sparkSession(), "saveAsTable", new CreateTable(tableDesc, this.mode(), (Option<LogicalPlan>)new Some((Object)this.df().logicalPlan())));
    }

    public void jdbc(String url, String table, Properties connectionProperties) {
        this.assertNotPartitioned("jdbc");
        this.assertNotBucketed("jdbc");
        this.extraOptions().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala());
        this.extraOptions().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)url), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)table), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.format("jdbc").save();
    }

    public void json(String path) {
        this.format("json").save(path);
    }

    public void parquet(String path) {
        this.format("parquet").save(path);
    }

    public void orc(String path) {
        this.format("orc").save(path);
    }

    public void text(String path) {
        this.format("text").save(path);
    }

    public void csv(String path) {
        this.format("csv").save(path);
    }

    private void runCommand(SparkSession session, String name, LogicalPlan command) {
        QueryExecution qe = session.sessionState().executePlan(command);
        SQLExecution$.MODULE$.withNewExecutionId(session, qe, (Option<String>)new Some((Object)name), (Function0 & Serializable & scala.Serializable)() -> qe.toRdd());
    }

    private Option<TableProvider> lookupV2Provider() {
        Some some;
        None$ none$ = DataSource$.MODULE$.lookupDataSourceV2(this.source(), this.df().sparkSession().sessionState().conf());
        None$ none$2 = none$ instanceof Some && (some = (Some)none$).value() instanceof FileDataSourceV2 ? None$.MODULE$ : none$;
        return none$2;
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private void mode_$eq(SaveMode x$1) {
        this.mode = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private Option<Seq<String>> bucketColumnNames() {
        return this.bucketColumnNames;
    }

    private void bucketColumnNames_$eq(Option<Seq<String>> x$1) {
        this.bucketColumnNames = x$1;
    }

    private Option<Object> numBuckets() {
        return this.numBuckets;
    }

    private void numBuckets_$eq(Option<Object> x$1) {
        this.numBuckets = x$1;
    }

    private Option<Seq<String>> sortColumnNames() {
        return this.sortColumnNames;
    }

    private void sortColumnNames_$eq(Option<Seq<String>> x$1) {
        this.sortColumnNames = x$1;
    }

    private static final /* synthetic */ DataSourceV2Relation relation$lzycompute$1(LazyRef relation$lzy$1, SupportsWrite x2$1, CaseInsensitiveStringMap dsOptions$1) {
        DataSourceV2Relation dataSourceV2Relation;
        LazyRef lazyRef = relation$lzy$1;
        synchronized (lazyRef) {
            dataSourceV2Relation = relation$lzy$1.initialized() ? (DataSourceV2Relation)relation$lzy$1.value() : (DataSourceV2Relation)relation$lzy$1.initialize((Object)DataSourceV2Relation$.MODULE$.create((Table)x2$1, dsOptions$1));
        }
        return dataSourceV2Relation;
    }

    private static final DataSourceV2Relation relation$1(LazyRef relation$lzy$1, SupportsWrite x2$1, CaseInsensitiveStringMap dsOptions$1) {
        return relation$lzy$1.initialized() ? (DataSourceV2Relation)relation$lzy$1.value() : DataFrameWriter.relation$lzycompute$1(relation$lzy$1, x2$1, dsOptions$1);
    }

    public static final /* synthetic */ BucketSpec $anonfun$getBucketSpec$1(DataFrameWriter $this, int n) {
        return new BucketSpec(n, (Seq)$this.bucketColumnNames().get(), (Seq)$this.sortColumnNames().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
    }

    public static final /* synthetic */ Seq $anonfun$saveAsTable$1(Seq colNames) {
        return (Seq)colNames.map((Function1 & Serializable & scala.Serializable)name -> new IdentityTransform(FieldReference$.MODULE$.apply(name)), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Seq $anonfun$saveAsTable$3() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public static final /* synthetic */ Seq $anonfun$saveAsTable$4(DataFrameWriter $this, Seq cols) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BucketTransform[]{new BucketTransform((Literal)new LiteralValue($this.numBuckets().get(), (DataType)IntegerType$.MODULE$), (Seq)cols.map((Function1 & Serializable & scala.Serializable)x$3 -> FieldReference$.MODULE$.apply(x$3), Seq$.MODULE$.canBuildFrom()))}));
    }

    public static final /* synthetic */ Seq $anonfun$saveAsTable$6() {
        return (Seq)Seq$.MODULE$.empty();
    }

    private final Option getLocationIfExists$1() {
        CaseInsensitiveMap opts = CaseInsensitiveMap$.MODULE$.apply(this.extraOptions().toMap(Predef$.MODULE$.$conforms()));
        return opts.get("path").map((Function1 & Serializable & scala.Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"location"), x$4));
    }

    public DataFrameWriter(Dataset<T> ds) {
        this.df = ds.toDF();
        this.source = this.df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.mode = SaveMode.ErrorIfExists;
        this.extraOptions = new HashMap();
        this.partitioningColumns = None$.MODULE$;
        this.bucketColumnNames = None$.MODULE$;
        this.numBuckets = None$.MODULE$;
        this.sortColumnNames = None$.MODULE$;
    }
}

