/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.WriteToDataSourceV2;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.WriteSupport;
import org.apache.spark.sql.sources.v2.writer.DataSourceWriter;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@InterfaceStability.Stable
@ScalaSignature(bytes="\u0006\u0001\t\u0015g\u0001B\u001c9\u0005\u0005C\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\u00073\u0002!\t\u0001\u000f.\t\u000fu\u0003!\u0019!C\u0005=\"1a\r\u0001Q\u0001\n}CQa\u001a\u0001\u0005\u0002!DQa\u001a\u0001\u0005\u00029DQa\u001f\u0001\u0005\u0002qDaa \u0001\u0005\u0002\u0005\u0005\u0001BB@\u0001\t\u0003\tY\u0001\u0003\u0004\u0000\u0001\u0011\u0005\u0011q\u0003\u0005\u0007\u007f\u0002!\t!a\t\t\u000f\u0005=\u0002\u0001\"\u0001\u00022!9\u0011q\u0006\u0001\u0005\u0002\u0005\u0005\u0003bBA*\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0003_\u0002A\u0011AA9\u0011\u001d\t)\t\u0001C\u0001\u0003\u000fCq!a$\u0001\t\u0003\t\t\nC\u0004\u0002\u0010\u0002!\t!!(\t\u000f\u0005}\u0005\u0001\"\u0003\u0002\u001e\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0006bBAQ\u0001\u0011%\u0011\u0011\u0016\u0005\b\u0003w\u0003A\u0011BA_\u0011\u001d\t\t\u000e\u0001C\u0005\u0003'Dq!!7\u0001\t\u0013\tY\u000eC\u0004\u0002`\u0002!\t!!9\t\u000f\u0005}\u0007\u0001\"\u0003\u0002f\"9\u0011\u0011\u001e\u0001\u0005\n\u0005-\bbBAx\u0001\u0011\u0005\u0011\u0011\u001f\u0005\b\u0005\u000b\u0001A\u0011\u0001B\u0004\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0005\u001bAqA!\u0005\u0001\t\u0003\u0011\u0019\u0002C\u0004\u0003\u0018\u0001!\tA!\u0007\t\u000f\tu\u0001\u0001\"\u0001\u0003 !9!1\u0005\u0001\u0005\n\t\u0015\u0002\u0002\u0003@\u0001\u0001\u0004%IAa\u0013\t\u0013\t5\u0003\u00011A\u0005\n\t=\u0003b\u0002B+\u0001\u0001\u0006K\u0001\u001d\u0005\tO\u0002\u0001\r\u0011\"\u0003\u0003X!I!\u0011\f\u0001A\u0002\u0013%!1\f\u0005\b\u0005?\u0002\u0001\u0015)\u0003l\u0011%\u0011\t\u0007\u0001b\u0001\n\u0013\u0011\u0019\u0007\u0003\u0005\u0003r\u0001\u0001\u000b\u0011\u0002B3\u0011%\u0011\u0019\b\u0001a\u0001\n\u0013\u0011)\bC\u0005\u0003\n\u0002\u0001\r\u0011\"\u0003\u0003\f\"A!q\u0012\u0001!B\u0013\u00119\bC\u0005\u0003\u0012\u0002\u0001\r\u0011\"\u0003\u0003v!I!1\u0013\u0001A\u0002\u0013%!Q\u0013\u0005\t\u00053\u0003\u0001\u0015)\u0003\u0003x!I\u0011Q\u000f\u0001A\u0002\u0013%!1\u0014\u0005\n\u0005?\u0003\u0001\u0019!C\u0005\u0005CC\u0001B!*\u0001A\u0003&!Q\u0014\u0005\n\u0005O\u0003\u0001\u0019!C\u0005\u0005kB\u0011B!+\u0001\u0001\u0004%IAa+\t\u0011\t=\u0006\u0001)Q\u0005\u0005o\u0012q\u0002R1uC\u001a\u0013\u0018-\\3Xe&$XM\u001d\u0006\u0003si\n1a]9m\u0015\tYD(A\u0003ta\u0006\u00148N\u0003\u0002>}\u00051\u0011\r]1dQ\u0016T\u0011aP\u0001\u0004_J<7\u0001A\u000b\u0003\u0005B\u001b\"\u0001A\"\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\r\u0005s\u0017PU3g\u0003\t!7\u000fE\u0002L\u0019:k\u0011\u0001O\u0005\u0003\u001bb\u0012q\u0001R1uCN,G\u000f\u0005\u0002P!2\u0001A!B)\u0001\u0005\u0004\u0011&!\u0001+\u0012\u0005M3\u0006C\u0001#U\u0013\t)VIA\u0004O_RD\u0017N\\4\u0011\u0005\u0011;\u0016B\u0001-F\u0005\r\te._\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005mc\u0006cA&\u0001\u001d\")\u0011J\u0001a\u0001\u0015\u0006\u0011AMZ\u000b\u0002?B\u0011\u0001m\u0019\b\u0003\u0017\u0006L!A\u0019\u001d\u0002\u000fA\f7m[1hK&\u0011A-\u001a\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T!A\u0019\u001d\u0002\u0007\u00114\u0007%\u0001\u0003n_\u0012,GCA.j\u0011\u0015QW\u00011\u0001l\u0003!\u0019\u0018M^3N_\u0012,\u0007CA&m\u0013\ti\u0007H\u0001\u0005TCZ,Wj\u001c3f)\tYv\u000eC\u0003k\r\u0001\u0007\u0001\u000f\u0005\u0002rq:\u0011!O\u001e\t\u0003g\u0016k\u0011\u0001\u001e\u0006\u0003k\u0002\u000ba\u0001\u0010:p_Rt\u0014BA<F\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011P\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005],\u0015A\u00024pe6\fG\u000f\u0006\u0002\\{\")ap\u0002a\u0001a\u000611o\\;sG\u0016\faa\u001c9uS>tG#B.\u0002\u0004\u0005\u001d\u0001BBA\u0003\u0011\u0001\u0007\u0001/A\u0002lKfDa!!\u0003\t\u0001\u0004\u0001\u0018!\u0002<bYV,G#B.\u0002\u000e\u0005=\u0001BBA\u0003\u0013\u0001\u0007\u0001\u000fC\u0004\u0002\n%\u0001\r!!\u0005\u0011\u0007\u0011\u000b\u0019\"C\u0002\u0002\u0016\u0015\u0013qAQ8pY\u0016\fg\u000eF\u0003\\\u00033\tY\u0002\u0003\u0004\u0002\u0006)\u0001\r\u0001\u001d\u0005\b\u0003\u0013Q\u0001\u0019AA\u000f!\r!\u0015qD\u0005\u0004\u0003C)%\u0001\u0002'p]\u001e$RaWA\u0013\u0003OAa!!\u0002\f\u0001\u0004\u0001\bbBA\u0005\u0017\u0001\u0007\u0011\u0011\u0006\t\u0004\t\u0006-\u0012bAA\u0017\u000b\n1Ai\\;cY\u0016\fqa\u001c9uS>t7\u000fF\u0002\\\u0003gAq!a\f\r\u0001\u0004\t)\u0004\u0005\u0004\u00028\u0005u\u0002\u000f]\u0007\u0003\u0003sQ1!a\u000fF\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u007f\tIDA\u0002NCB$2aWA\"\u0011\u001d\ty#\u0004a\u0001\u0003\u000b\u0002b!a\u0012\u0002RA\u0004XBAA%\u0015\u0011\tY%!\u0014\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u001f\nAA[1wC&!\u0011qHA%\u0003-\u0001\u0018M\u001d;ji&|gNQ=\u0015\u0007m\u000b9\u0006C\u0004\u0002Z9\u0001\r!a\u0017\u0002\u0011\r|GNT1nKN\u0004B\u0001RA/a&\u0019\u0011qL#\u0003\u0015q\u0012X\r]3bi\u0016$g\bK\u0002\u000f\u0003G\u0002B!!\u001a\u0002l5\u0011\u0011q\r\u0006\u0004\u0003S*\u0015AC1o]>$\u0018\r^5p]&!\u0011QNA4\u0005\u001d1\u0018M]1sON\f\u0001BY;dW\u0016$()\u001f\u000b\b7\u0006M\u0014QPAA\u0011\u001d\t)h\u0004a\u0001\u0003o\n!B\\;n\u0005V\u001c7.\u001a;t!\r!\u0015\u0011P\u0005\u0004\u0003w*%aA%oi\"1\u0011qP\bA\u0002A\fqaY8m\u001d\u0006lW\rC\u0004\u0002Z=\u0001\r!a\u0017)\u0007=\t\u0019'\u0001\u0004t_J$()\u001f\u000b\u00067\u0006%\u00151\u0012\u0005\u0007\u0003\u007f\u0002\u0002\u0019\u00019\t\u000f\u0005e\u0003\u00031\u0001\u0002\\!\u001a\u0001#a\u0019\u0002\tM\fg/\u001a\u000b\u0005\u0003'\u000bI\nE\u0002E\u0003+K1!a&F\u0005\u0011)f.\u001b;\t\r\u0005m\u0015\u00031\u0001q\u0003\u0011\u0001\u0018\r\u001e5\u0015\u0005\u0005M\u0015AD:bm\u0016$vNV\u0019T_V\u00148-Z\u0001\u000bS:\u001cXM\u001d;J]R|G\u0003BAJ\u0003KCa!a*\u0015\u0001\u0004\u0001\u0018!\u0003;bE2,g*Y7f)\u0011\t\u0019*a+\t\u000f\u00055V\u00031\u0001\u00020\u0006QA/\u00192mK&#WM\u001c;\u0011\t\u0005E\u0016qW\u0007\u0003\u0003gS1!!.9\u0003!\u0019\u0017\r^1msN$\u0018\u0002BA]\u0003g\u0013q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM]\u0001\u000eO\u0016$()^2lKR\u001c\u0006/Z2\u0016\u0005\u0005}\u0006#\u0002#\u0002B\u0006\u0015\u0017bAAb\u000b\n1q\n\u001d;j_:\u0004B!a2\u0002N6\u0011\u0011\u0011\u001a\u0006\u0005\u0003\u0017\f\u0019,A\u0004dCR\fGn\\4\n\t\u0005=\u0017\u0011\u001a\u0002\u000b\u0005V\u001c7.\u001a;Ta\u0016\u001c\u0017!E1tg\u0016\u0014HOT8u\u0005V\u001c7.\u001a;fIR!\u00111SAk\u0011\u0019\t9n\u0006a\u0001a\u0006Iq\u000e]3sCRLwN\\\u0001\u0015CN\u001cXM\u001d;O_R\u0004\u0016M\u001d;ji&|g.\u001a3\u0015\t\u0005M\u0015Q\u001c\u0005\u0007\u0003/D\u0002\u0019\u00019\u0002\u0017M\fg/Z!t)\u0006\u0014G.\u001a\u000b\u0005\u0003'\u000b\u0019\u000f\u0003\u0004\u0002(f\u0001\r\u0001\u001d\u000b\u0005\u0003'\u000b9\u000fC\u0004\u0002.j\u0001\r!a,\u0002\u0017\r\u0014X-\u0019;f)\u0006\u0014G.\u001a\u000b\u0005\u0003'\u000bi\u000fC\u0004\u0002.n\u0001\r!a,\u0002\t)$'m\u0019\u000b\t\u0003'\u000b\u00190a>\u0002|\"1\u0011Q\u001f\u000fA\u0002A\f1!\u001e:m\u0011\u0019\tI\u0010\ba\u0001a\u0006)A/\u00192mK\"9\u0011Q \u000fA\u0002\u0005}\u0018\u0001F2p]:,7\r^5p]B\u0013x\u000e]3si&,7\u000f\u0005\u0003\u0002H\t\u0005\u0011\u0002\u0002B\u0002\u0003\u0013\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0003\u0011Q7o\u001c8\u0015\t\u0005M%\u0011\u0002\u0005\u0007\u00037k\u0002\u0019\u00019\u0002\u000fA\f'/];fiR!\u00111\u0013B\b\u0011\u0019\tYJ\ba\u0001a\u0006\u0019qN]2\u0015\t\u0005M%Q\u0003\u0005\u0007\u00037{\u0002\u0019\u00019\u0002\tQ,\u0007\u0010\u001e\u000b\u0005\u0003'\u0013Y\u0002\u0003\u0004\u0002\u001c\u0002\u0002\r\u0001]\u0001\u0004GN4H\u0003BAJ\u0005CAa!a'\"\u0001\u0004\u0001\u0018A\u0003:v]\u000e{W.\\1oIR1!q\u0005B\u001f\u0005\u000f\"B!a%\u0003*!9!1\u0006\u0012A\u0002\t5\u0012aB2p[6\fg\u000e\u001a\t\u0005\u0005_\u0011I$\u0004\u0002\u00032)!!1\u0007B\u001b\u0003\u001dawnZ5dC2TAAa\u000e\u00024\u0006)\u0001\u000f\\1og&!!1\bB\u0019\u0005-aunZ5dC2\u0004F.\u00198\t\u000f\t}\"\u00051\u0001\u0003B\u000591/Z:tS>t\u0007cA&\u0003D%\u0019!Q\t\u001d\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\r\t%#\u00051\u0001q\u0003\u0011q\u0017-\\3\u0016\u0003A\f!b]8ve\u000e,w\fJ3r)\u0011\t\u0019J!\u0015\t\u0011\tMC%!AA\u0002A\f1\u0001\u001f\u00132\u0003\u001d\u0019x.\u001e:dK\u0002*\u0012a[\u0001\t[>$Wm\u0018\u0013fcR!\u00111\u0013B/\u0011!\u0011\u0019fJA\u0001\u0002\u0004Y\u0017!B7pI\u0016\u0004\u0013\u0001D3yiJ\fw\n\u001d;j_:\u001cXC\u0001B3!\u0019\u00119G!\u001cqa6\u0011!\u0011\u000e\u0006\u0005\u0005W\nI$A\u0004nkR\f'\r\\3\n\t\t=$\u0011\u000e\u0002\b\u0011\u0006\u001c\b.T1q\u00035)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8tA\u0005\u0019\u0002/\u0019:uSRLwN\\5oO\u000e{G.^7ogV\u0011!q\u000f\t\u0006\t\u0006\u0005'\u0011\u0010\t\u0006\u0005w\u0012\u0019\t\u001d\b\u0005\u0005{\u0012\tID\u0002t\u0005\u007fJ\u0011AR\u0005\u0003E\u0016KAA!\"\u0003\b\n\u00191+Z9\u000b\u0005\t,\u0015a\u00069beRLG/[8oS:<7i\u001c7v[:\u001cx\fJ3r)\u0011\t\u0019J!$\t\u0013\tMC&!AA\u0002\t]\u0014\u0001\u00069beRLG/[8oS:<7i\u001c7v[:\u001c\b%A\tck\u000e\\W\r^\"pYVlgNT1nKN\fQCY;dW\u0016$8i\u001c7v[:t\u0015-\\3t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\n]\u0005\"\u0003B*_\u0005\u0005\t\u0019\u0001B<\u0003I\u0011WoY6fi\u000e{G.^7o\u001d\u0006lWm\u001d\u0011\u0016\u0005\tu\u0005#\u0002#\u0002B\u0006]\u0014A\u00048v[\n+8m[3ug~#S-\u001d\u000b\u0005\u0003'\u0013\u0019\u000bC\u0005\u0003TI\n\t\u00111\u0001\u0003\u001e\u0006Ya.^7Ck\u000e\\W\r^:!\u0003=\u0019xN\u001d;D_2,XN\u001c(b[\u0016\u001c\u0018aE:peR\u001cu\u000e\\;n]:\u000bW.Z:`I\u0015\fH\u0003BAJ\u0005[C\u0011Ba\u00156\u0003\u0003\u0005\rAa\u001e\u0002!M|'\u000f^\"pYVlgNT1nKN\u0004\u0003f\u0001\u0001\u00034B!!Q\u0017B`\u001d\u0011\u00119La/\u000e\u0005\te&bAA5u%!!Q\u0018B]\u0003IIe\u000e^3sM\u0006\u001cWm\u0015;bE&d\u0017\u000e^=\n\t\t\u0005'1\u0019\u0002\u0007'R\f'\r\\3\u000b\t\tu&\u0011\u0018")
public final class DataFrameWriter<T> {
    private final Dataset<Row> df;
    private String source;
    private SaveMode mode;
    private final HashMap<String, String> extraOptions;
    private Option<Seq<String>> partitioningColumns;
    private Option<Seq<String>> bucketColumnNames;
    private Option<Object> numBuckets;
    private Option<Seq<String>> sortColumnNames;

    public DataFrameWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, String ... colNames) {
        return this.bucketBy(numBuckets, colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> sortBy(String colName, String ... colNames) {
        return this.sortBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    public DataFrameWriter<T> mode(SaveMode saveMode) {
        this.mode_$eq(saveMode);
        return this;
    }

    public DataFrameWriter<T> mode(String saveMode) {
        SaveMode saveMode2;
        String string = saveMode.toLowerCase(Locale.ROOT);
        if ("overwrite".equals(string)) {
            saveMode2 = SaveMode.Overwrite;
        } else if ("append".equals(string)) {
            saveMode2 = SaveMode.Append;
        } else if ("ignore".equals(string)) {
            saveMode2 = SaveMode.Ignore;
        } else {
            boolean bl = "error".equals(string) ? true : ("errorifexists".equals(string) ? true : "default".equals(string));
            if (bl) {
                saveMode2 = SaveMode.ErrorIfExists;
            } else {
                throw new IllegalArgumentException(new StringBuilder(103).append("Unknown save mode: ").append(saveMode).append(". ").append("Accepted save modes are 'overwrite', 'append', 'ignore', 'error', 'errorifexists'.").toString());
            }
        }
        this.mode_$eq(saveMode2);
        return this;
    }

    public DataFrameWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameWriter<T> option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameWriter<T> option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameWriter<T> option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameWriter<T> option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameWriter<T> options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataFrameWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public DataFrameWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, Seq<String> colNames) {
        this.numBuckets_$eq((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numBuckets)));
        String string = colName;
        this.bucketColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public DataFrameWriter<T> sortBy(String colName, Seq<String> colNames) {
        String string = colName;
        this.sortColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public void save(String path) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path));
        this.save();
    }

    public void save() {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException("Hive data source can only be used with tables, you can not write files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        this.assertNotBucketed("save");
        Class<?> cls = DataSource$.MODULE$.lookupDataSource(this.source(), this.df().sparkSession().sessionState().conf());
        if (DataSourceV2.class.isAssignableFrom(cls)) {
            DataSourceV2 source = (DataSourceV2)cls.newInstance();
            DataSourceV2 dataSourceV2 = source;
            if (dataSourceV2 instanceof WriteSupport) {
                BoxedUnit boxedUnit;
                WriteSupport writeSupport = (WriteSupport)dataSourceV2;
                scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(source, this.df().sparkSession().sessionState().conf());
                scala.collection.immutable.Map options = sessionOptions.$plus$plus(this.extraOptions());
                Optional<DataSourceWriter> writer = writeSupport.createWriter(UUID.randomUUID().toString(), package$.MODULE$.AttributeSeq(this.df().logicalPlan().output()).toStructType(), this.mode(), new DataSourceOptions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)options).asJava()));
                if (writer.isPresent()) {
                    this.runCommand(this.df().sparkSession(), "save", new WriteToDataSourceV2(writer.get(), this.df().logicalPlan()));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                this.saveToV1Source();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            this.saveToV1Source();
        }
    }

    private void saveToV1Source() {
        if (BoxesRunTime.unboxToBoolean((Object)SparkSession$.MODULE$.active().sessionState().conf().getConf(SQLConf$.MODULE$.LEGACY_PASS_PARTITION_BY_AS_OPTIONS()))) {
            this.partitioningColumns().foreach((Function1 & Serializable & scala.Serializable)columns -> this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.PARTITIONING_COLUMNS_KEY()), (Object)DataSourceUtils$.MODULE$.encodePartitioningColumns((Seq<String>)columns))));
        }
        SparkSession x$1 = this.df().sparkSession();
        String x$2 = this.source();
        Seq x$3 = (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        scala.collection.immutable.Map x$4 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$6 = DataSource$.MODULE$.apply$default$4();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        this.runCommand(this.df().sparkSession(), "save", new DataSource(x$1, x$2, x$5, x$6, (Seq<String>)x$3, x$7, (scala.collection.immutable.Map<String, String>)x$4, x$8).planForWriting(this.mode(), this.df().logicalPlan()));
    }

    public void insertInto(String tableName) {
        this.insertInto(this.df().sparkSession().sessionState().sqlParser().parseTableIdentifier(tableName));
    }

    private void insertInto(TableIdentifier tableIdent) {
        this.assertNotBucketed("insertInto");
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException("insertInto() can't be used together with partitionBy(). Partition columns have already been defined for the table. It is not necessary to use partitionBy().", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = SaveMode.Overwrite;
        this.runCommand(this.df().sparkSession(), "insertInto", (LogicalPlan)new InsertIntoTable((LogicalPlan)new UnresolvedRelation(tableIdent), Predef$.MODULE$.Map().empty(), this.df().logicalPlan(), !(saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode2) : saveMode2 != null), false));
    }

    private Option<BucketSpec> getBucketSpec() {
        if (this.sortColumnNames().isDefined() && this.numBuckets().isEmpty()) {
            throw new AnalysisException("sortBy must be used together with bucketBy", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.numBuckets().map((Function1 & Serializable & scala.Serializable)n -> DataFrameWriter.$anonfun$getBucketSpec$1(this, BoxesRunTime.unboxToInt((Object)n)));
    }

    private void assertNotBucketed(String operation) {
        if (this.getBucketSpec().isDefined()) {
            if (this.sortColumnNames().isEmpty()) {
                throw new AnalysisException(new StringBuilder(38).append("'").append(operation).append("' does not support bucketBy right now").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            throw new AnalysisException(new StringBuilder(49).append("'").append(operation).append("' does not support bucketBy and sortBy right now").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException(new StringBuilder(32).append("'").append(operation).append("' does not support partitioning").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public void saveAsTable(String tableName) {
        this.saveAsTable(this.df().sparkSession().sessionState().sqlParser().parseTableIdentifier(tableName));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void saveAsTable(TableIdentifier tableIdent) {
        SessionCatalog catalog = this.df().sparkSession().sessionState().catalog();
        boolean tableExists = catalog.tableExists(tableIdent);
        String db = (String)tableIdent.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> catalog.getCurrentDatabase());
        Some x$1 = new Some((Object)db);
        String x$2 = tableIdent.copy$default$1();
        TableIdentifier tableIdentWithDB = tableIdent.copy(x$2, (Option)x$1);
        String tableName = tableIdentWithDB.unquotedString();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)tableExists), (Object)this.mode());
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Ignore)).equals((Object)saveMode)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.ErrorIfExists)).equals((Object)saveMode)) {
                throw new AnalysisException(new StringBuilder(22).append("Table ").append(tableIdent).append(" already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Overwrite)).equals((Object)saveMode)) {
                HiveTableRelation hiveTableRelation;
                BaseRelation baseRelation;
                LogicalRelation logicalRelation;
                BaseRelation dest;
                Seq srcRelations = this.df().logicalPlan().collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        A1 A1 = x1;
                        if (A1 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)A1).relation()) != null) {
                            BaseRelation baseRelation = src;
                            object = baseRelation;
                        } else if (A1 instanceof HiveTableRelation) {
                            HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                            object = hiveTableRelation.tableMeta().identifier();
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        LogicalPlan logicalPlan2 = x1;
                        boolean bl = logicalPlan2 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null ? true : logicalPlan2 instanceof HiveTableRelation;
                        return bl;
                    }
                });
                LogicalPlan tableRelation = this.df().sparkSession().table(tableIdentWithDB).queryExecution().analyzed();
                LogicalPlan logicalPlan2 = EliminateSubqueryAliases$.MODULE$.apply(tableRelation);
                if (logicalPlan2 instanceof LogicalRelation && (dest = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null && srcRelations.contains((Object)(baseRelation = dest))) {
                    throw new AnalysisException(new StringBuilder(52).append("Cannot overwrite table ").append(tableName).append(" that is also being read from").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                if (logicalPlan2 instanceof HiveTableRelation && srcRelations.contains((Object)(hiveTableRelation = (HiveTableRelation)logicalPlan2).tableMeta().identifier())) {
                    throw new AnalysisException(new StringBuilder(52).append("Cannot overwrite table ").append(tableName).append(" that is also being read from").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                catalog.dropTable(tableIdentWithDB, true, false);
                this.createTable(tableIdentWithDB);
                catalog.refreshTable(tableIdentWithDB);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
        }
        this.createTable(tableIdent);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void createTable(TableIdentifier tableIdent) {
        CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.$conforms()));
        CatalogTableType tableType = storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        CatalogTable tableDesc = new CatalogTable(tableIdent, tableType, storage, new StructType(), (Option)new Some((Object)this.source()), (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), this.getBucketSpec(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19());
        this.runCommand(this.df().sparkSession(), "saveAsTable", new CreateTable(tableDesc, this.mode(), (Option<LogicalPlan>)new Some((Object)this.df().logicalPlan())));
    }

    public void jdbc(String url, String table, Properties connectionProperties) {
        this.assertNotPartitioned("jdbc");
        this.assertNotBucketed("jdbc");
        this.extraOptions().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala());
        this.extraOptions().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)url), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)table), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.format("jdbc").save();
    }

    public void json(String path) {
        this.format("json").save(path);
    }

    public void parquet(String path) {
        this.format("parquet").save(path);
    }

    public void orc(String path) {
        this.format("orc").save(path);
    }

    public void text(String path) {
        this.format("text").save(path);
    }

    public void csv(String path) {
        this.format("csv").save(path);
    }

    private void runCommand(SparkSession session, String name, LogicalPlan command) {
        QueryExecution qe = session.sessionState().executePlan(command);
        try {
            long start = System.nanoTime();
            SQLExecution$.MODULE$.withNewExecutionId(session, qe, (Function0 & Serializable & scala.Serializable)() -> qe.toRdd());
            long end = System.nanoTime();
            session.listenerManager().onSuccess(name, qe, end - start);
        }
        catch (Exception e) {
            session.listenerManager().onFailure(name, qe, e);
            throw e;
        }
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private void mode_$eq(SaveMode x$1) {
        this.mode = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private Option<Seq<String>> bucketColumnNames() {
        return this.bucketColumnNames;
    }

    private void bucketColumnNames_$eq(Option<Seq<String>> x$1) {
        this.bucketColumnNames = x$1;
    }

    private Option<Object> numBuckets() {
        return this.numBuckets;
    }

    private void numBuckets_$eq(Option<Object> x$1) {
        this.numBuckets = x$1;
    }

    private Option<Seq<String>> sortColumnNames() {
        return this.sortColumnNames;
    }

    private void sortColumnNames_$eq(Option<Seq<String>> x$1) {
        this.sortColumnNames = x$1;
    }

    public static final /* synthetic */ BucketSpec $anonfun$getBucketSpec$1(DataFrameWriter $this, int n) {
        return new BucketSpec(n, (Seq)$this.bucketColumnNames().get(), (Seq)$this.sortColumnNames().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
    }

    public DataFrameWriter(Dataset<T> ds) {
        this.df = ds.toDF();
        this.source = this.df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.mode = SaveMode.ErrorIfExists;
        this.extraOptions = new HashMap();
        this.partitioningColumns = None$.MODULE$;
        this.bucketColumnNames = None$.MODULE$;
        this.numBuckets = None$.MODULE$;
        this.sortColumnNames = None$.MODULE$;
    }
}

