/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.CommitDeniedException;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.OutputCommitCoordinator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution$;
import org.apache.spark.sql.sources.v2.writer.DataWriter;
import org.apache.spark.sql.sources.v2.writer.DataWriterFactory;
import org.apache.spark.sql.sources.v2.writer.WriterCommitMessage;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.runtime.java8.JFunction0;

public final class DataWritingSparkTask$
implements Logging {
    public static DataWritingSparkTask$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DataWritingSparkTask$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public WriterCommitMessage run(DataWriterFactory<InternalRow> writeTask, TaskContext context, Iterator<InternalRow> iter, boolean useCommitCoordinator) {
        int stageId = context.stageId();
        int stageAttempt = context.stageAttemptNumber();
        int partId = context.partitionId();
        long taskId = context.taskAttemptId();
        int attemptId = context.attemptNumber();
        String epochId = (String)Option$.MODULE$.apply((Object)context.getLocalProperty(MicroBatchExecution$.MODULE$.BATCH_ID_KEY())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "0");
        DataWriter<InternalRow> dataWriter = writeTask.createDataWriter(partId, taskId, new StringOps(Predef$.MODULE$.augmentString(epochId)).toLong());
        Function0 & Serializable & scala.Serializable x$1 = (Function0 & Serializable & scala.Serializable)() -> {
            WriterCommitMessage writerCommitMessage;
            while (iter.hasNext()) {
                dataWriter.write((InternalRow)iter.next());
            }
            if (useCommitCoordinator) {
                OutputCommitCoordinator coordinator = SparkEnv$.MODULE$.get().outputCommitCoordinator();
                boolean commitAuthorized = coordinator.canCommit(stageId, stageAttempt, partId, attemptId);
                if (!commitAuthorized) {
                    String message = new StringBuilder(47).append("Commit denied for partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append(new StringBuilder(8).append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString()).toString();
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                    throw new CommitDeniedException(message, stageId, partId, attemptId);
                }
                MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Commit authorized for partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append(new StringBuilder(8).append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString()).toString());
                writerCommitMessage = dataWriter.commit();
            } else {
                MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Writer for partition ").append(context.partitionId()).append(" is committing.").toString());
                writerCommitMessage = dataWriter.commit();
            }
            WriterCommitMessage msg = writerCommitMessage;
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Committed partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append(new StringBuilder(8).append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString()).toString());
            return msg;
        };
        JFunction0.mcV.sp & Serializable & scala.Serializable x$2 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Aborting commit for partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append(new StringBuilder(8).append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString()).toString());
            dataWriter.abort();
            MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Aborted commit for partition ").append(partId).append(" (task ").append(taskId).append(", attempt ").append(attemptId).append(", ").append(new StringBuilder(8).append("stage ").append(stageId).append(".").append(stageAttempt).append(")").toString()).toString());
        };
        JFunction0.mcV.sp & Serializable & scala.Serializable x$3 = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks$default$3(x$1);
        return (WriterCommitMessage)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks((Function0)x$1, (Function0)x$2, (Function0)x$3);
    }

    private DataWritingSparkTask$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

