/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\t\u0013\u0001\u0005B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\tY\u0001\u0011\t\u0011)A\u0005S!)Q\u0006\u0001C\u0001]!)Q\u0006\u0001C\u0001g!)Q\u0006\u0001C\u0001y!)Q\t\u0001C\u0001\r\")Q\t\u0001C\u0005-\")1\f\u0001C\u00019\")Q\r\u0001C\u0005M\")A\u000e\u0001C\u0005[\")q\u000e\u0001C\u0005a\u001eI\u0011\u0011\u0001\n\u0002\u0002#\u0005\u00111\u0001\u0004\t#I\t\t\u0011#\u0001\u0002\u0006!1Q&\u0004C\u0001\u0003\u000fA\u0011\"!\u0003\u000e#\u0003%\t!a\u0003\t\u0013\u0005\u0005R\"%A\u0005\u0002\u0005-!!\b)beF,X\r\u001e+p'B\f'o[*dQ\u0016l\u0017mQ8om\u0016\u0014H/\u001a:\u000b\u0005M!\u0012a\u00029beF,X\r\u001e\u0006\u0003+Y\t1\u0002Z1uCN|WO]2fg*\u0011q\u0003G\u0001\nKb,7-\u001e;j_:T!!\u0007\u000e\u0002\u0007M\fHN\u0003\u0002\u001c9\u0005)1\u000f]1sW*\u0011QDH\u0001\u0007CB\f7\r[3\u000b\u0003}\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g\u0003Q\t7o];nK\nKg.\u0019:z\u0013N\u001cFO]5oOB\u00111EK\u0005\u0003W\u0011\u0012qAQ8pY\u0016\fg.\u0001\fbgN,X.Z%oif2\u0014j\u001d+j[\u0016\u001cH/Y7q\u0003\u0019a\u0014N\\5u}Q\u0019q&\r\u001a\u0011\u0005A\u0002Q\"\u0001\n\t\u000f!\u001a\u0001\u0013!a\u0001S!9Af\u0001I\u0001\u0002\u0004ICCA\u00185\u0011\u0015)D\u00011\u00017\u0003\u0011\u0019wN\u001c4\u0011\u0005]RT\"\u0001\u001d\u000b\u0005eB\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005mB$aB*R\u0019\u000e{gN\u001a\u000b\u0003_uBQ!N\u0003A\u0002y\u0002\"aP\"\u000e\u0003\u0001S!!N!\u000b\u0005\tc\u0012A\u00025bI>|\u0007/\u0003\u0002E\u0001\ni1i\u001c8gS\u001e,(/\u0019;j_:\fqaY8om\u0016\u0014H\u000f\u0006\u0002H\u001bB\u0011\u0001jS\u0007\u0002\u0013*\u0011!\nG\u0001\u0006if\u0004Xm]\u0005\u0003\u0019&\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015qe\u00011\u0001P\u00035\u0001\u0018M]9vKR\u001c6\r[3nCB\u0011\u0001\u000bV\u0007\u0002#*\u0011!kU\u0001\u0007g\u000eDW-\\1\u000b\u0005Ma\u0012BA+R\u0005-iUm]:bO\u0016$\u0016\u0010]3\u0015\u0005\u001d;\u0006\"\u0002(\b\u0001\u0004A\u0006C\u0001)Z\u0013\tQ\u0016KA\u0005He>,\b\u000fV=qK\u0006a1m\u001c8wKJ$h)[3mIR\u0011Q\f\u0019\t\u0003\u0011zK!aX%\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQ!\u0019\u0005A\u0002\t\f1\u0002]1scV,G\u000fV=qKB\u0011\u0001kY\u0005\u0003IF\u0013A\u0001V=qK\u0006)2m\u001c8wKJ$\bK]5nSRLg/\u001a$jK2$GCA/h\u0011\u0015A\u0017\u00021\u0001j\u0003\u00151\u0017.\u001a7e!\t\u0001&.\u0003\u0002l#\ni\u0001K]5nSRLg/\u001a+za\u0016\f\u0011cY8om\u0016\u0014Ho\u0012:pkB4\u0015.\u001a7e)\tif\u000eC\u0003i\u0015\u0001\u0007\u0001,A\u0007jg\u0016cW-\\3oiRK\b/\u001a\u000b\u0004SE\u001c\b\"\u0002:\f\u0001\u0004\u0011\u0017\u0001\u0004:fa\u0016\fG/\u001a3UsB,\u0007\"\u0002;\f\u0001\u0004)\u0018A\u00039be\u0016tGOT1nKB\u0011a/ \b\u0003on\u0004\"\u0001\u001f\u0013\u000e\u0003eT!A\u001f\u0011\u0002\rq\u0012xn\u001c;?\u0013\taH%\u0001\u0004Qe\u0016$WMZ\u0005\u0003}~\u0014aa\u0015;sS:<'B\u0001?%\u0003u\u0001\u0016M]9vKR$vn\u00159be.\u001c6\r[3nC\u000e{gN^3si\u0016\u0014\bC\u0001\u0019\u000e'\ti!\u0005\u0006\u0002\u0002\u0004\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\"!!\u0004+\u0007%\nya\u000b\u0002\u0002\u0012A!\u00111CA\u000f\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011!C;oG\",7m[3e\u0015\r\tY\u0002J\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0010\u0003+\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0001")
public class ParquetToSparkSchemaConverter {
    private final boolean assumeBinaryIsString;
    private final boolean assumeInt96IsTimestamp;

    public static boolean $lessinit$greater$default$2() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$1() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public StructType convert(MessageType parquetSchema) {
        return this.convert(parquetSchema.asGroupType());
    }

    private StructType convert(GroupType parquetSchema) {
        Buffer fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetSchema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> {
            StructField structField;
            Type.Repetition repetition = field.getRepetition();
            if (Type.Repetition.OPTIONAL.equals(repetition)) {
                structField = new StructField(field.getName(), this.convertField((Type)field), true, StructField$.MODULE$.apply$default$4());
            } else if (Type.Repetition.REQUIRED.equals(repetition)) {
                structField = new StructField(field.getName(), this.convertField((Type)field), false, StructField$.MODULE$.apply$default$4());
            } else if (Type.Repetition.REPEATED.equals(repetition)) {
                ArrayType arrayType = new ArrayType(this.convertField((Type)field), false);
                structField = new StructField(field.getName(), (DataType)arrayType, false, StructField$.MODULE$.apply$default$4());
            } else {
                throw new MatchError((Object)repetition);
            }
            return structField;
        }, Buffer$.MODULE$.canBuildFrom());
        return StructType$.MODULE$.apply((Seq)fields);
    }

    public DataType convertField(Type parquetType) {
        DataType dataType;
        Type type = parquetType;
        if (type instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            dataType = this.convertPrimitiveField(primitiveType);
        } else if (type instanceof GroupType) {
            GroupType groupType = (GroupType)type;
            dataType = this.convertGroupField(groupType.asGroupType());
        } else {
            throw new MatchError((Object)type);
        }
        return dataType;
    }

    /*
     * Unable to fully structure code
     */
    private DataType convertPrimitiveField(PrimitiveType field) {
        block36: {
            block42: {
                block44: {
                    block43: {
                        block41: {
                            block40: {
                                block39: {
                                    block38: {
                                        block37: {
                                            block35: {
                                                typeName = field.getPrimitiveTypeName();
                                                originalType = field.getOriginalType();
                                                var12_4 = typeName;
                                                if (!PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(var12_4)) break block35;
                                                var2_5 = BooleanType$.MODULE$;
                                                break block36;
                                            }
                                            if (!PrimitiveType.PrimitiveTypeName.FLOAT.equals(var12_4)) break block37;
                                            var2_5 = FloatType$.MODULE$;
                                            break block36;
                                        }
                                        if (!PrimitiveType.PrimitiveTypeName.DOUBLE.equals(var12_4)) break block38;
                                        var2_5 = DoubleType$.MODULE$;
                                        break block36;
                                    }
                                    if (!PrimitiveType.PrimitiveTypeName.INT32.equals(var12_4)) break block39;
                                    var13_6 = originalType;
                                    if (OriginalType.INT_8.equals(var13_6)) {
                                        var8_7 = ByteType$.MODULE$;
                                    } else if (OriginalType.INT_16.equals(var13_6)) {
                                        var8_7 = ShortType$.MODULE$;
                                    } else {
                                        var9_8 = OriginalType.INT_32.equals(var13_6) != false ? true : var13_6 == null;
                                        if (var9_8) {
                                            var8_7 = IntegerType$.MODULE$;
                                        } else if (OriginalType.DATE.equals(var13_6)) {
                                            var8_7 = DateType$.MODULE$;
                                        } else if (OriginalType.DECIMAL.equals(var13_6)) {
                                            var8_7 = ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_INT_DIGITS(), field, typeName);
                                        } else {
                                            if (OriginalType.UINT_8.equals(var13_6)) {
                                                throw ParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                            }
                                            if (OriginalType.UINT_16.equals(var13_6)) {
                                                throw ParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                            }
                                            if (OriginalType.UINT_32.equals(var13_6)) {
                                                throw ParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                            }
                                            if (OriginalType.TIME_MILLIS.equals(var13_6)) {
                                                throw ParquetToSparkSchemaConverter.typeNotImplemented$1(originalType, typeName);
                                            }
                                            throw ParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                                        }
                                    }
                                    var2_5 = var8_7;
                                    break block36;
                                }
                                if (!PrimitiveType.PrimitiveTypeName.INT64.equals(var12_4)) break block40;
                                var14_9 = originalType;
                                var7_10 = OriginalType.INT_64.equals(var14_9) != false ? true : var14_9 == null;
                                if (var7_10) {
                                    var6_11 = LongType$.MODULE$;
                                } else if (OriginalType.DECIMAL.equals(var14_9)) {
                                    var6_11 = ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_LONG_DIGITS(), field, typeName);
                                } else {
                                    if (OriginalType.UINT_64.equals(var14_9)) {
                                        throw ParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
                                    }
                                    if (OriginalType.TIMESTAMP_MICROS.equals(var14_9)) {
                                        var6_11 = TimestampType$.MODULE$;
                                    } else if (OriginalType.TIMESTAMP_MILLIS.equals(var14_9)) {
                                        var6_11 = TimestampType$.MODULE$;
                                    } else {
                                        throw ParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                                    }
                                }
                                var2_5 = var6_11;
                                break block36;
                            }
                            if (!PrimitiveType.PrimitiveTypeName.INT96.equals(var12_4)) break block41;
                            ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$convertPrimitiveField$2(org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter ), ()Z)((ParquetToSparkSchemaConverter)this), new StringBuilder(61).append("INT96 is not supported unless it's interpreted as timestamp. ").append(new StringBuilder(27).append("Please try to set ").append(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()).append(" to true.").toString()).toString());
                            var2_5 = TimestampType$.MODULE$;
                            break block36;
                        }
                        if (!PrimitiveType.PrimitiveTypeName.BINARY.equals(var12_4)) break block42;
                        var15_12 = false;
                        var16_13 = null;
                        var17_14 = originalType;
                        var5_15 = OriginalType.UTF8.equals(var17_14) != false ? true : (OriginalType.ENUM.equals(var17_14) != false ? true : OriginalType.JSON.equals(var17_14) != false);
                        if (!var5_15) break block43;
                        var4_16 = StringType$.MODULE$;
                        break block44;
                    }
                    if (var17_14 != null) ** GOTO lbl-1000
                    var15_12 = true;
                    var16_13 = var17_14;
                    if (this.assumeBinaryIsString) {
                        var4_16 = StringType$.MODULE$;
                    } else if (var15_12) {
                        var4_16 = BinaryType$.MODULE$;
                    } else if (OriginalType.BSON.equals(var17_14)) {
                        var4_16 = BinaryType$.MODULE$;
                    } else if (OriginalType.DECIMAL.equals(var17_14)) {
                        var4_16 = ParquetToSparkSchemaConverter.makeDecimalType$1(ParquetToSparkSchemaConverter.makeDecimalType$default$1$1(), field, typeName);
                    } else {
                        throw ParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                    }
                }
                var2_5 = var4_16;
                break block36;
            }
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(var12_4)) {
                var18_17 = originalType;
                if (!OriginalType.DECIMAL.equals(var18_17)) {
                    if (OriginalType.INTERVAL.equals(var18_17)) {
                        throw ParquetToSparkSchemaConverter.typeNotImplemented$1(originalType, typeName);
                    }
                    throw ParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
                }
                var3_18 = ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.maxPrecisionForBytes(field.getTypeLength()), field, typeName);
                var2_5 = var3_18;
            } else {
                throw ParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
            }
        }
        return var2_5;
    }

    private DataType convertGroupField(GroupType field) {
        return (DataType)Option$.MODULE$.apply((Object)field.getOriginalType()).fold((Function0 & Serializable & scala.Serializable)() -> this.convert(field), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ArrayType arrayType;
            OriginalType originalType = x0$1;
            if (OriginalType.LIST.equals(originalType)) {
                ArrayType arrayType2;
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> field.getFieldCount() == 1, new StringBuilder(18).append("Invalid list type ").append(field).toString());
                Type repeatedType = field.getType(0);
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> repeatedType.isRepetition(Type.Repetition.REPEATED), new StringBuilder(18).append("Invalid list type ").append(field).toString());
                if (this.isElementType(repeatedType, field.getName())) {
                    arrayType2 = new ArrayType(this.convertField(repeatedType), false);
                } else {
                    Type elementType = repeatedType.asGroupType().getType(0);
                    boolean optional = elementType.isRepetition(Type.Repetition.OPTIONAL);
                    arrayType2 = new ArrayType(this.convertField(elementType), optional);
                }
                arrayType = arrayType2;
            } else {
                boolean bl = OriginalType.MAP.equals(originalType) ? true : OriginalType.MAP_KEY_VALUE.equals(originalType);
                if (bl) {
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> field.getFieldCount() == 1 && !field.getType(0).isPrimitive(), new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                    GroupType keyValueType = field.getType(0).asGroupType();
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> keyValueType.isRepetition(Type.Repetition.REPEATED) && keyValueType.getFieldCount() == 2, new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                    Type keyType = keyValueType.getType(0);
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> keyType.isPrimitive(), new StringBuilder(60).append("Map key type is expected to be a primitive type, but found: ").append(keyType).toString());
                    Type valueType = keyValueType.getType(1);
                    boolean valueOptional = valueType.isRepetition(Type.Repetition.OPTIONAL);
                    arrayType = new MapType(this.convertField(keyType), this.convertField(valueType), valueOptional);
                } else {
                    throw new AnalysisException(new StringBuilder(27).append("Unrecognized Parquet type: ").append(field).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
            }
            return arrayType;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isElementType(Type repeatedType, String parentName) {
        if (repeatedType.isPrimitive()) return true;
        if (repeatedType.asGroupType().getFieldCount() > 1) return true;
        String string = repeatedType.getName();
        String string2 = "array";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = repeatedType.getName();
        String string4 = new StringBuilder(6).append(parentName).append("_tuple").toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private static final String typeString$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        return originalType$1 == null ? String.valueOf(typeName$1) : new StringBuilder(3).append(typeName$1).append(" (").append(originalType$1).append(")").toString();
    }

    private static final Nothing$ typeNotSupported$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw new AnalysisException(new StringBuilder(28).append("Parquet type not supported: ").append(ParquetToSparkSchemaConverter.typeString$1(originalType$1, typeName$1)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private static final Nothing$ typeNotImplemented$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw new AnalysisException(new StringBuilder(32).append("Parquet type not yet supported: ").append(ParquetToSparkSchemaConverter.typeString$1(originalType$1, typeName$1)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private static final Nothing$ illegalType$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw new AnalysisException(new StringBuilder(22).append("Illegal Parquet type: ").append(ParquetToSparkSchemaConverter.typeString$1(originalType$1, typeName$1)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private static final DecimalType makeDecimalType$1(int maxPrecision, PrimitiveType field$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        int precision = field$1.getDecimalMetadata().getPrecision();
        int scale = field$1.getDecimalMetadata().getScale();
        ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> maxPrecision == -1 || 1 <= precision && precision <= maxPrecision, new StringBuilder(55).append("Invalid decimal precision: ").append(typeName$1).append(" cannot store ").append(precision).append(" digits (max ").append(maxPrecision).append(")").toString());
        return new DecimalType(precision, scale);
    }

    private static final int makeDecimalType$default$1$1() {
        return -1;
    }

    public static final /* synthetic */ boolean $anonfun$convertPrimitiveField$2(ParquetToSparkSchemaConverter $this) {
        return $this.assumeInt96IsTimestamp;
    }

    public ParquetToSparkSchemaConverter(boolean assumeBinaryIsString, boolean assumeInt96IsTimestamp) {
        this.assumeBinaryIsString = assumeBinaryIsString;
        this.assumeInt96IsTimestamp = assumeInt96IsTimestamp;
    }

    public ParquetToSparkSchemaConverter(SQLConf conf) {
        this(conf.isParquetBinaryAsString(), conf.isParquetINT96AsTimestamp());
    }

    public ParquetToSparkSchemaConverter(Configuration conf) {
        this(new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key()))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()))).toBoolean());
    }
}

