/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.util.Locale;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;

public final class ParquetReadSupport$ {
    public static ParquetReadSupport$ MODULE$;
    private final String SPARK_ROW_REQUESTED_SCHEMA;
    private final String SPARK_METADATA_KEY;

    static {
        new ParquetReadSupport$();
    }

    public String SPARK_ROW_REQUESTED_SCHEMA() {
        return this.SPARK_ROW_REQUESTED_SCHEMA;
    }

    public String SPARK_METADATA_KEY() {
        return this.SPARK_METADATA_KEY;
    }

    public MessageType clipParquetSchema(MessageType parquetSchema, StructType catalystSchema, boolean caseSensitive) {
        Seq<Type> clippedParquetFields = this.clipParquetGroupFields(parquetSchema.asGroupType(), catalystSchema, caseSensitive);
        return clippedParquetFields.isEmpty() ? ParquetSchemaConverter$.MODULE$.EMPTY_MESSAGE() : (MessageType)Types.buildMessage().addFields((Type[])clippedParquetFields.toArray(ClassTag$.MODULE$.apply(Type.class))).named(ParquetSchemaConverter$.MODULE$.SPARK_PARQUET_SCHEMA_NAME());
    }

    public boolean clipParquetSchema$default$3() {
        return true;
    }

    private Type clipParquetType(Type parquetType, DataType catalystType, boolean caseSensitive) {
        MapType mapType;
        Type type;
        ArrayType arrayType;
        DataType dataType = catalystType;
        if (dataType instanceof ArrayType && !this.isPrimitiveCatalystType((arrayType = (ArrayType)dataType).elementType())) {
            type = this.clipParquetListType(parquetType.asGroupType(), arrayType.elementType(), caseSensitive);
        } else if (!(!(dataType instanceof MapType) || this.isPrimitiveCatalystType((mapType = (MapType)dataType).keyType()) && this.isPrimitiveCatalystType(mapType.valueType()))) {
            type = this.clipParquetMapType(parquetType.asGroupType(), mapType.keyType(), mapType.valueType(), caseSensitive);
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            type = this.clipParquetGroup(parquetType.asGroupType(), structType, caseSensitive);
        } else {
            type = parquetType;
        }
        return type;
    }

    private boolean isPrimitiveCatalystType(DataType dataType) {
        DataType dataType2 = dataType;
        boolean bl = dataType2 instanceof ArrayType ? true : (dataType2 instanceof MapType ? true : dataType2 instanceof StructType);
        boolean bl2 = !bl;
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Type clipParquetListType(GroupType parquetList, DataType elementType, boolean caseSensitive) {
        GroupType repeatedGroup;
        Type type;
        block5: {
            block4: {
                Predef$.MODULE$.assert(!this.isPrimitiveCatalystType(elementType));
                if (parquetList.getOriginalType() == null && parquetList.isRepetition(Type.Repetition.REPEATED)) {
                    type = this.clipParquetType((Type)parquetList, elementType, caseSensitive);
                    return type;
                }
                OriginalType originalType = parquetList.getOriginalType();
                OriginalType originalType2 = OriginalType.LIST;
                Predef$.MODULE$.assert(!(originalType != null ? !originalType.equals(originalType2) : originalType2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Invalid Parquet schema. Original type of annotated Parquet lists must be LIST: ").append(parquetList.toString()).toString());
                Predef$.MODULE$.assert(parquetList.getFieldCount() == 1 && parquetList.getType(0).isRepetition(Type.Repetition.REPEATED), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Invalid Parquet schema. LIST-annotated group should only have exactly one repeated field: ").append(parquetList).toString());
                Predef$.MODULE$.assert(!parquetList.getType(0).isPrimitive());
                repeatedGroup = parquetList.getType(0).asGroupType();
                if (repeatedGroup.getFieldCount() > 1) break block4;
                String string = repeatedGroup.getName();
                String string2 = "array";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block4;
                String string3 = repeatedGroup.getName();
                String string4 = new StringBuilder(6).append(parquetList.getName()).append("_tuple").toString();
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block5;
            }
            type = (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetList.getRepetition()).as(OriginalType.LIST)).addField(this.clipParquetType((Type)repeatedGroup, elementType, caseSensitive)).named(parquetList.getName());
            return type;
        }
        type = (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetList.getRepetition()).as(OriginalType.LIST)).addField((Type)Types.repeatedGroup().addField(this.clipParquetType(repeatedGroup.getType(0), elementType, caseSensitive)).named(repeatedGroup.getName())).named(parquetList.getName());
        return type;
    }

    private GroupType clipParquetMapType(GroupType parquetMap, DataType keyType, DataType valueType, boolean caseSensitive) {
        Predef$.MODULE$.assert(!this.isPrimitiveCatalystType(keyType) || !this.isPrimitiveCatalystType(valueType));
        GroupType repeatedGroup = parquetMap.getType(0).asGroupType();
        Type parquetKeyType = repeatedGroup.getType(0);
        Type parquetValueType = repeatedGroup.getType(1);
        GroupType clippedRepeatedGroup = (GroupType)((Types.BaseGroupBuilder)Types.repeatedGroup().as(repeatedGroup.getOriginalType())).addField(this.clipParquetType(parquetKeyType, keyType, caseSensitive)).addField(this.clipParquetType(parquetValueType, valueType, caseSensitive)).named(repeatedGroup.getName());
        return (GroupType)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetMap.getRepetition()).as(parquetMap.getOriginalType())).addField((Type)clippedRepeatedGroup).named(parquetMap.getName());
    }

    private GroupType clipParquetGroup(GroupType parquetRecord, StructType structType, boolean caseSensitive) {
        Seq<Type> clippedParquetFields = this.clipParquetGroupFields(parquetRecord, structType, caseSensitive);
        return (GroupType)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetRecord.getRepetition()).as(parquetRecord.getOriginalType())).addFields((Type[])clippedParquetFields.toArray(ClassTag$.MODULE$.apply(Type.class))).named(parquetRecord.getName());
    }

    private Seq<Type> clipParquetGroupFields(GroupType parquetRecord, StructType structType, boolean caseSensitive) {
        Seq seq;
        SparkToParquetSchemaConverter toParquet = new SparkToParquetSchemaConverter(false, SparkToParquetSchemaConverter$.MODULE$.$lessinit$greater$default$2());
        if (caseSensitive) {
            Map caseSensitiveParquetFieldMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetRecord.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getName()), f), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            seq = (Seq)structType.map((Function1 & Serializable & scala.Serializable)f -> (Type)caseSensitiveParquetFieldMap.get((Object)f.name()).map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.clipParquetType((Type)x$1, f.dataType(), caseSensitive)).getOrElse((Function0 & Serializable & scala.Serializable)() -> toParquet.convertField((StructField)f)), Seq$.MODULE$.canBuildFrom());
        } else {
            Map caseInsensitiveParquetFieldMap = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetRecord.getFields()).asScala()).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getName().toLowerCase(Locale.ROOT));
            seq = (Seq)structType.map((Function1 & Serializable & scala.Serializable)f -> (Type)caseInsensitiveParquetFieldMap.get((Object)f.name().toLowerCase(Locale.ROOT)).map((Function1 & Serializable & scala.Serializable)parquetTypes -> {
                if (parquetTypes.size() > 1) {
                    String parquetTypesString = ((TraversableOnce)parquetTypes.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getName(), Buffer$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
                    throw new RuntimeException(new StringBuilder(29).append("Found duplicate field(s) \"").append(f.name()).append("\": ").append(new StringBuilder(25).append(parquetTypesString).append(" in case-insensitive mode").toString()).toString());
                }
                return MODULE$.clipParquetType((Type)parquetTypes.head(), f.dataType(), caseSensitive);
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> toParquet.convertField((StructField)f)), Seq$.MODULE$.canBuildFrom());
        }
        return seq;
    }

    public StructType expandUDT(StructType schema) {
        return (StructType)ParquetReadSupport$.expand$1((DataType)schema);
    }

    private static final DataType expand$1(DataType dataType) {
        ArrayType arrayType;
        DataType dataType2 = dataType;
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType2 = (ArrayType)dataType2;
            arrayType = arrayType2.copy(ParquetReadSupport$.expand$1(arrayType2.elementType()), arrayType2.copy$default$2());
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            arrayType = mapType.copy(ParquetReadSupport$.expand$1(mapType.keyType()), ParquetReadSupport$.expand$1(mapType.valueType()), mapType.copy$default$3());
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            StructField[] expandedFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).map((Function1 & Serializable & scala.Serializable)f -> {
                DataType x$1 = ParquetReadSupport$.expand$1(f.dataType());
                String x$2 = f.copy$default$1();
                boolean x$3 = f.copy$default$3();
                Metadata x$4 = f.copy$default$4();
                return f.copy(x$2, x$1, x$3, x$4);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
            arrayType = structType.copy(expandedFields);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            arrayType = userDefinedType.sqlType();
        } else {
            arrayType = dataType2;
        }
        return arrayType;
    }

    private ParquetReadSupport$() {
        MODULE$ = this;
        this.SPARK_ROW_REQUESTED_SCHEMA = "org.apache.spark.sql.parquet.row.requested_schema";
        this.SPARK_METADATA_KEY = "org.apache.spark.sql.parquet.row.metadata";
    }
}

