/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.vectorized;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.vectorized.MutableColumnarRow;
import org.apache.spark.sql.vectorized.ColumnVector;

@InterfaceStability.Evolving
public final class ColumnarBatch {
    private int numRows;
    private final ColumnVector[] columns;
    private final MutableColumnarRow row;

    public void close() {
        for (ColumnVector c : this.columns) {
            c.close();
        }
    }

    public Iterator<InternalRow> rowIterator() {
        final int maxRows = this.numRows;
        final MutableColumnarRow row = new MutableColumnarRow(this.columns);
        return new Iterator<InternalRow>(){
            int rowId = 0;

            @Override
            public boolean hasNext() {
                return this.rowId < maxRows;
            }

            @Override
            public InternalRow next() {
                if (this.rowId >= maxRows) {
                    throw new NoSuchElementException();
                }
                row.rowId = this.rowId++;
                return row;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    public int numCols() {
        return this.columns.length;
    }

    public int numRows() {
        return this.numRows;
    }

    public ColumnVector column(int ordinal) {
        return this.columns[ordinal];
    }

    public InternalRow getRow(int rowId) {
        assert (rowId >= 0 && rowId < this.numRows);
        this.row.rowId = rowId;
        return this.row;
    }

    public ColumnarBatch(ColumnVector[] columns) {
        this.columns = columns;
        this.row = new MutableColumnarRow(columns);
    }
}

