/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import com.univocity.parsers.csv.CsvParser;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.spark.input.PortableDataStream;
import org.apache.spark.input.StreamInputFormat;
import org.apache.spark.rdd.BinaryFileRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVInferSchema$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.execution.datasources.csv.UnivocityParser;
import org.apache.spark.sql.execution.datasources.csv.UnivocityParser$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class MultiLineCSVDataSource$
extends CSVDataSource {
    public static MultiLineCSVDataSource$ MODULE$;
    private final boolean isSplitable;

    static {
        new MultiLineCSVDataSource$();
    }

    @Override
    public boolean isSplitable() {
        return this.isSplitable;
    }

    @Override
    public Iterator<InternalRow> readFile(Configuration conf, PartitionedFile file, UnivocityParser parser, StructType requiredSchema, StructType dataSchema, boolean caseSensitive, boolean columnPruning) {
        return UnivocityParser$.MODULE$.parseStream(CodecStreams$.MODULE$.createInputStreamWithCloseResource(conf, new Path(new URI(file.filePath()))), parser.options().headerFlag(), parser, requiredSchema, (Function1<String[], BoxedUnit>)(Function1 & Serializable & scala.Serializable)header -> {
            MultiLineCSVDataSource$.checkHeader$1(header, columnPruning, requiredSchema, dataSchema, file, parser, caseSensitive);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public StructType infer(SparkSession sparkSession, Seq<FileStatus> inputPaths, CSVOptions parsedOptions) {
        StructType structType;
        RDD<PortableDataStream> csv = this.createBaseRdd(sparkSession, inputPaths, parsedOptions);
        Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])csv.flatMap((Function1 & Serializable & scala.Serializable)lines -> {
            Path path = new Path(lines.getPath());
            return UnivocityParser$.MODULE$.tokenizeStream(CodecStreams$.MODULE$.createInputStreamWithCloseResource(lines.getConfiguration(), path), false, new CsvParser(parsedOptions.asParserSettings()));
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).take(1))).headOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            String[] firstRow = (String[])some.value();
            boolean caseSensitive = sparkSession.sessionState().conf().caseSensitiveAnalysis();
            String[] header = this.makeSafeHeader(firstRow, caseSensitive, parsedOptions);
            RDD tokenRDD = csv.flatMap((Function1 & Serializable & scala.Serializable)lines -> UnivocityParser$.MODULE$.tokenizeStream(CodecStreams$.MODULE$.createInputStreamWithCloseResource(lines.getConfiguration(), new Path(lines.getPath())), parsedOptions.headerFlag(), new CsvParser(parsedOptions.asParserSettings())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
            RDD<String[]> sampled = CSVUtils$.MODULE$.sample((RDD<String[]>)tokenRDD, parsedOptions);
            structType = CSVInferSchema$.MODULE$.infer(sampled, header, parsedOptions);
        } else if (None$.MODULE$.equals(option)) {
            structType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$);
        } else {
            throw new MatchError((Object)option);
        }
        return structType;
    }

    private RDD<PortableDataStream> createBaseRdd(SparkSession sparkSession, Seq<FileStatus> inputPaths, CSVOptions options) {
        Seq paths = (Seq)inputPaths.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getPath(), Seq$.MODULE$.canBuildFrom());
        String name = paths.mkString(",");
        Job job = Job.getInstance((Configuration)sparkSession.sessionState().newHadoopConfWithOptions((Map<String, String>)options.parameters()));
        FileInputFormat.setInputPaths((Job)job, (Path[])((Path[])paths.toArray(ClassTag$.MODULE$.apply(Path.class))));
        Configuration conf = job.getConfiguration();
        BinaryFileRDD rdd = new BinaryFileRDD(sparkSession.sparkContext(), StreamInputFormat.class, String.class, PortableDataStream.class, conf, sparkSession.sparkContext().defaultMinPartitions());
        return RDD$.MODULE$.rddToPairRDDFunctions(rdd.setName(new StringBuilder(9).append("CSVFile: ").append(name).toString()), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(PortableDataStream.class), (Ordering)Ordering.String$.MODULE$).values();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final void checkHeader$1(String[] header, boolean columnPruning$2, StructType requiredSchema$2, StructType dataSchema$2, PartitionedFile file$2, UnivocityParser parser$3, boolean caseSensitive$3) {
        StructType schema = columnPruning$2 ? requiredSchema$2 : dataSchema$2;
        CSVDataSource$.MODULE$.checkHeaderColumnNames(schema, header, file$2.filePath(), parser$3.options().enforceSchema(), caseSensitive$3);
    }

    private MultiLineCSVDataSource$() {
        MODULE$ = this;
        this.isSplitable = false;
    }
}

