/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PartitioningAwareFileIndex;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Unit$;
import scala.collection.AbstractIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r]h\u0001B5k\u0001]D\u0001\u0002 \u0001\u0003\u0002\u0003\u0006I! \u0005\u000b\u0003\u0007\u0001!\u0011!Q\u0001\n\u0005\u0015\u0001BCA\u0019\u0001\t\u0005\t\u0015!\u0003\u00024!Q\u0011\u0011\n\u0001\u0003\u0002\u0003\u0006I!a\u0013\t\u0015\u0005}\u0003A!A!\u0002\u0013\t\t\u0007C\u0004\u0002h\u0001!\t!!\u001b\t\u0013\u0005]\u0004A1A\u0005B\u0005e\u0004\u0002CAC\u0001\u0001\u0006I!a\u001f\t\u0017\u0005\u001d\u0005\u00011AA\u0002\u0013%\u0011\u0011\u0012\u0005\f\u0003;\u0003\u0001\u0019!a\u0001\n\u0013\ty\nC\u0006\u0002,\u0002\u0001\r\u0011!Q!\n\u0005-\u0005bCA[\u0001\u0001\u0007\t\u0019!C\u0005\u0003oC1\"!1\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002D\"Y\u0011q\u0019\u0001A\u0002\u0003\u0005\u000b\u0015BA]\u0011-\tY\r\u0001a\u0001\u0002\u0004%I!!4\t\u0017\u0005U\u0007\u00011AA\u0002\u0013%\u0011q\u001b\u0005\f\u00037\u0004\u0001\u0019!A!B\u0013\ty\rC\u0004\u0002`\u0002!\t%!9\t\u000f\u0005\r\b\u0001\"\u0015\u0002\n\"9\u0011Q\u001d\u0001\u0005R\u0005]\u0006bBAt\u0001\u0011\u0005\u0013\u0011\u001e\u0005\b\u0003W\u0004A\u0011BAu\u0011\u001d\ti\u000f\u0001C!\u0003_DqA!\u0001\u0001\t\u0003\u0012\u0019\u0001C\u0004\u0003\f\u0001!\tA!\u0004\b\u000f\te!\u000e#\u0001\u0003\u001c\u00191\u0011N\u001bE\u0001\u0005;Aq!a\u001a\u001c\t\u0003\u0011\tD\u0002\u0004\u00034m!%Q\u0007\u0005\u000b\u0005\u0007j\"Q3A\u0005\u0002\t\u0015\u0003B\u0003B%;\tE\t\u0015!\u0003\u0003H!Q!1J\u000f\u0003\u0016\u0004%\tA!\u0012\t\u0015\t5SD!E!\u0002\u0013\u00119\u0005\u0003\u0006\u0003Pu\u0011)\u001a!C\u0001\u0005#B!B!\u0017\u001e\u0005#\u0005\u000b\u0011\u0002B*\u0011)\u0011Y&\bBK\u0002\u0013\u0005!\u0011\u000b\u0005\u000b\u0005;j\"\u0011#Q\u0001\n\tM\u0003bBA4;\u0011\u0005!q\f\u0005\n\u0005[j\u0012\u0011!C\u0001\u0005_B\u0011B!\u001f\u001e#\u0003%\tAa\u001f\t\u0013\tEU$%A\u0005\u0002\tm\u0004\"\u0003BJ;E\u0005I\u0011\u0001BK\u0011%\u0011I*HI\u0001\n\u0003\u0011)\nC\u0005\u0003\u001cv\t\t\u0011\"\u0011\u0003\u001e\"I!QV\u000f\u0002\u0002\u0013\u0005!q\u0016\u0005\n\u0005ck\u0012\u0011!C\u0001\u0005gC\u0011Ba.\u001e\u0003\u0003%\tE!/\t\u0013\t\u0005W$!A\u0005\u0002\t\r\u0007\"\u0003B\u0001;\u0005\u0005I\u0011\tB\u0002\u0011%\u00119-HA\u0001\n\u0003\u0012I\rC\u0005\u0002nv\t\t\u0011\"\u0011\u0003L\u001eI!qZ\u000e\u0002\u0002#%!\u0011\u001b\u0004\n\u0005gY\u0012\u0011!E\u0005\u0005'Dq!a\u001a6\t\u0003\u0011\t\u000fC\u0005\u0003HV\n\t\u0011\"\u0012\u0003J\"I!1]\u001b\u0002\u0002\u0013\u0005%Q\u001d\u0005\n\u0005_,\u0014\u0011!CA\u0005cD\u0011Ba@6\u0003\u0003%Ia!\u0001\u0007\r\r%1\u0004RB\u0006\u0011)\u0019ia\u000fBK\u0002\u0013\u00051q\u0002\u0005\u000b\u0007#Y$\u0011#Q\u0001\n\u0005\r\u0003B\u0003B.w\tU\r\u0011\"\u0001\u0003R!Q!QL\u001e\u0003\u0012\u0003\u0006IAa\u0015\t\u0015\rM1H!f\u0001\n\u0003\u0019)\u0002\u0003\u0006\u0004\u0018m\u0012\t\u0012)A\u0005\u0003cD!b!\u0007<\u0005+\u0007I\u0011AB\u000e\u0011)\u0019\u0019c\u000fB\tB\u0003%1Q\u0004\u0005\u000b\u0007KY$Q3A\u0005\u0002\tE\u0003BCB\u0014w\tE\t\u0015!\u0003\u0003T!Q1\u0011F\u001e\u0003\u0016\u0004%\tA!\u0015\t\u0015\r-2H!E!\u0002\u0013\u0011\u0019\u0006\u0003\u0006\u0004.m\u0012)\u001a!C\u0001\u0005#B!ba\f<\u0005#\u0005\u000b\u0011\u0002B*\u0011)\u0019\td\u000fBK\u0002\u0013\u000511\u0007\u0005\u000b\u0007oY$\u0011#Q\u0001\n\rU\u0002bBA4w\u0011\u00051\u0011\b\u0005\n\u0005[Z\u0014\u0011!C\u0001\u0007\u001bB\u0011B!\u001f<#\u0003%\taa\u0018\t\u0013\tE5(%A\u0005\u0002\tU\u0005\"\u0003BJwE\u0005I\u0011AB2\u0011%\u0011IjOI\u0001\n\u0003\u00199\u0007C\u0005\u0004lm\n\n\u0011\"\u0001\u0003\u0016\"I1QN\u001e\u0012\u0002\u0013\u0005!Q\u0013\u0005\n\u0007_Z\u0014\u0013!C\u0001\u0005+C\u0011b!\u001d<#\u0003%\taa\u001d\t\u0013\tm5(!A\u0005B\tu\u0005\"\u0003BWw\u0005\u0005I\u0011\u0001BX\u0011%\u0011\tlOA\u0001\n\u0003\u00199\bC\u0005\u00038n\n\t\u0011\"\u0011\u0003:\"I!\u0011Y\u001e\u0002\u0002\u0013\u000511\u0010\u0005\n\u0005\u0003Y\u0014\u0011!C!\u0005\u0007A\u0011Ba2<\u0003\u0003%\tE!3\t\u0013\u000558(!A\u0005B\r}t!CBB7\u0005\u0005\t\u0012BBC\r%\u0019IaGA\u0001\u0012\u0013\u00199\tC\u0004\u0002h}#\taa$\t\u0013\t\u001dw,!A\u0005F\t%\u0007\"\u0003Br?\u0006\u0005I\u0011QBI\u0011%\u0011yoXA\u0001\n\u0003\u001b\u0019\u000bC\u0005\u0003\u0000~\u000b\t\u0011\"\u0003\u0004\u0002!A1qV\u000e\u0005\u00029\u001c\t\fC\u0004\u0003\fm!Iaa7\t\u000f\r%8\u0004\"\u0001\u0004l\"I1\u0011_\u000e\u0012\u0002\u0013\u000511\u001f\u0002\u0012\u0013:lU-\\8ss\u001aKG.Z%oI\u0016D(BA6m\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u00055t\u0017!C3yK\u000e,H/[8o\u0015\ty\u0007/A\u0002tc2T!!\u001d:\u0002\u000bM\u0004\u0018M]6\u000b\u0005M$\u0018AB1qC\u000eDWMC\u0001v\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0010\u0005\u0002zu6\t!.\u0003\u0002|U\nQ\u0002+\u0019:uSRLwN\\5oO\u0006;\u0018M]3GS2,\u0017J\u001c3fq\u0006a1\u000f]1sWN+7o]5p]B\u0011ap`\u0007\u0002]&\u0019\u0011\u0011\u00018\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002%I|w\u000e\u001e)bi\"\u001c8\u000b]3dS\u001aLW\r\u001a\t\u0007\u0003\u000f\tY\"!\t\u000f\t\u0005%\u0011Q\u0003\b\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011q\u0002<\u0002\rq\u0012xn\u001c;?\u0013\t\t\u0019\"A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\u0018\u0005e\u0011a\u00029bG.\fw-\u001a\u0006\u0003\u0003'IA!!\b\u0002 \t\u00191+Z9\u000b\t\u0005]\u0011\u0011\u0004\t\u0005\u0003G\ti#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003\t17OC\u0002\u0002,I\fa\u0001[1e_>\u0004\u0018\u0002BA\u0018\u0003K\u0011A\u0001U1uQ\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0011\u0011\u0005U\u0012QHA\"\u0003\u0007rA!a\u000e\u0002:A!\u00111BA\r\u0013\u0011\tY$!\u0007\u0002\rA\u0013X\rZ3g\u0013\u0011\ty$!\u0011\u0003\u00075\u000b\u0007O\u0003\u0003\u0002<\u0005e\u0001\u0003BA\u001b\u0003\u000bJA!a\u0012\u0002B\t11\u000b\u001e:j]\u001e\f1#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006\u0004b!!\u0014\u0002P\u0005MSBAA\r\u0013\u0011\t\t&!\u0007\u0003\r=\u0003H/[8o!\u0011\t)&a\u0017\u000e\u0005\u0005]#bAA-]\u0006)A/\u001f9fg&!\u0011QLA,\u0005)\u0019FO];diRK\b/Z\u0001\u0010M&dWm\u0015;biV\u001c8)Y2iKB\u0019\u00110a\u0019\n\u0007\u0005\u0015$NA\bGS2,7\u000b^1ukN\u001c\u0015m\u00195f\u0003\u0019a\u0014N\\5u}Qa\u00111NA7\u0003_\n\t(a\u001d\u0002vA\u0011\u0011\u0010\u0001\u0005\u0006y\u001a\u0001\r! \u0005\b\u0003\u00071\u0001\u0019AA\u0003\u0011\u001d\t\tD\u0002a\u0001\u0003gAq!!\u0013\u0007\u0001\u0004\tY\u0005C\u0005\u0002`\u0019\u0001\n\u00111\u0001\u0002b\u0005I!o\\8u!\u0006$\bn]\u000b\u0003\u0003w\u0002b!! \u0002\u0004\u0006\u0005RBAA@\u0015\u0011\t\t)!\u0007\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001e\u0005}\u0014A\u0003:p_R\u0004\u0016\r\u001e5tA\u0005y1-Y2iK\u0012dU-\u00194GS2,7/\u0006\u0002\u0002\fBA\u0011QRAJ\u0003C\t9*\u0004\u0002\u0002\u0010*!\u0011\u0011SA@\u0003\u001diW\u000f^1cY\u0016LA!!&\u0002\u0010\niA*\u001b8lK\u0012D\u0015m\u001d5NCB\u0004B!a\t\u0002\u001a&!\u00111TA\u0013\u0005)1\u0015\u000e\\3Ti\u0006$Xo]\u0001\u0014G\u0006\u001c\u0007.\u001a3MK\u00064g)\u001b7fg~#S-\u001d\u000b\u0005\u0003C\u000b9\u000b\u0005\u0003\u0002N\u0005\r\u0016\u0002BAS\u00033\u0011A!\u00168ji\"I\u0011\u0011\u0016\u0006\u0002\u0002\u0003\u0007\u00111R\u0001\u0004q\u0012\n\u0014\u0001E2bG\",G\rT3bM\u001aKG.Z:!Q\rY\u0011q\u0016\t\u0005\u0003\u001b\n\t,\u0003\u0003\u00024\u0006e!\u0001\u0003<pY\u0006$\u0018\u000e\\3\u00029\r\f7\r[3e\u0019\u0016\fg\rR5s)>\u001c\u0005.\u001b7ee\u0016tg)\u001b7fgV\u0011\u0011\u0011\u0018\t\t\u0003k\ti$!\t\u0002<B1\u0011QJA_\u0003/KA!a0\u0002\u001a\t)\u0011I\u001d:bs\u0006\u00013-Y2iK\u0012dU-\u00194ESJ$vn\u00115jY\u0012\u0014XM\u001c$jY\u0016\u001cx\fJ3r)\u0011\t\t+!2\t\u0013\u0005%V\"!AA\u0002\u0005e\u0016!H2bG\",G\rT3bM\u0012K'\u000fV8DQ&dGM]3o\r&dWm\u001d\u0011)\u00079\ty+A\ndC\u000eDW\r\u001a)beRLG/[8o'B,7-\u0006\u0002\u0002PB\u0019\u00110!5\n\u0007\u0005M'NA\u0007QCJ$\u0018\u000e^5p]N\u0003XmY\u0001\u0018G\u0006\u001c\u0007.\u001a3QCJ$\u0018\u000e^5p]N\u0003XmY0%KF$B!!)\u0002Z\"I\u0011\u0011\u0016\t\u0002\u0002\u0003\u0007\u0011qZ\u0001\u0015G\u0006\u001c\u0007.\u001a3QCJ$\u0018\u000e^5p]N\u0003Xm\u0019\u0011)\u0007E\ty+A\u0007qCJ$\u0018\u000e^5p]N\u0003Xm\u0019\u000b\u0003\u0003\u001f\f\u0011\u0002\\3bM\u001aKG.Z:\u0002-1,\u0017M\u001a#jeR{7\t[5mIJ,gNR5mKN\fqA]3ge\u0016\u001c\b\u000e\u0006\u0002\u0002\"\u0006A!/\u001a4sKND\u0007'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003c\f9\u0010\u0005\u0003\u0002N\u0005M\u0018\u0002BA{\u00033\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002z^\u0001\r!a?\u0002\u000b=$\b.\u001a:\u0011\t\u00055\u0013Q`\u0005\u0005\u0003\u007f\fIBA\u0002B]f\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005\u000b\u0001B!!\u0014\u0003\b%!!\u0011BA\r\u0005\rIe\u000e^\u0001\u000eY&\u001cH\u000fT3bM\u001aKG.Z:\u0015\t\t=!Q\u0003\t\u0007\u0003\u001b\u0013\t\"a&\n\t\tM\u0011q\u0012\u0002\u000e\u0019&t7.\u001a3ICND7+\u001a;\t\u000f\t]\u0011\u00041\u0001\u0002\u0006\u0005)\u0001/\u0019;ig\u0006\t\u0012J\\'f[>\u0014\u0018PR5mK&sG-\u001a=\u0011\u0005e\\2#B\u000e\u0003 \t\u0015\u0002\u0003BA'\u0005CIAAa\t\u0002\u001a\t1\u0011I\\=SK\u001a\u0004BAa\n\u0003.5\u0011!\u0011\u0006\u0006\u0004\u0005W\u0001\u0018\u0001C5oi\u0016\u0014h.\u00197\n\t\t=\"\u0011\u0006\u0002\b\u0019><w-\u001b8h)\t\u0011YBA\rTKJL\u0017\r\\5{C\ndWM\u00117pG.dunY1uS>t7cB\u000f\u0003 \t]\"Q\b\t\u0005\u0003\u001b\u0012I$\u0003\u0003\u0003<\u0005e!a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003\u001b\u0012y$\u0003\u0003\u0003B\u0005e!\u0001D*fe&\fG.\u001b>bE2,\u0017!\u00028b[\u0016\u001cXC\u0001B$!\u0019\ti%!0\u0002D\u00051a.Y7fg\u0002\nQ\u0001[8tiN\fa\u0001[8tiN\u0004\u0013AB8gMN,G/\u0006\u0002\u0003TA!\u0011Q\nB+\u0013\u0011\u00119&!\u0007\u0003\t1{gnZ\u0001\b_\u001a47/\u001a;!\u0003\u0019aWM\\4uQ\u00069A.\u001a8hi\"\u0004CC\u0003B1\u0005K\u00129G!\u001b\u0003lA\u0019!1M\u000f\u000e\u0003mAqAa\u0011'\u0001\u0004\u00119\u0005C\u0004\u0003L\u0019\u0002\rAa\u0012\t\u000f\t=c\u00051\u0001\u0003T!9!1\f\u0014A\u0002\tM\u0013\u0001B2paf$\"B!\u0019\u0003r\tM$Q\u000fB<\u0011%\u0011\u0019e\nI\u0001\u0002\u0004\u00119\u0005C\u0005\u0003L\u001d\u0002\n\u00111\u0001\u0003H!I!qJ\u0014\u0011\u0002\u0003\u0007!1\u000b\u0005\n\u00057:\u0003\u0013!a\u0001\u0005'\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003~)\"!q\tB@W\t\u0011\t\t\u0005\u0003\u0003\u0004\n5UB\u0001BC\u0015\u0011\u00119I!#\u0002\u0013Ut7\r[3dW\u0016$'\u0002\u0002BF\u00033\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yI!\"\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u0013\u0016\u0005\u0005'\u0012y(\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011y\n\u0005\u0003\u0003\"\n-VB\u0001BR\u0015\u0011\u0011)Ka*\u0002\t1\fgn\u001a\u0006\u0003\u0005S\u000bAA[1wC&!\u0011q\tBR\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011)!\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005m(Q\u0017\u0005\n\u0003Ss\u0013\u0011!a\u0001\u0005\u000b\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005w\u0003b!! \u0003>\u0006m\u0018\u0002\u0002B`\u0003\u007f\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011\u001fBc\u0011%\tI\u000bMA\u0001\u0002\u0004\tY0\u0001\u0005u_N#(/\u001b8h)\t\u0011y\n\u0006\u0003\u0002r\n5\u0007\"CAUg\u0005\u0005\t\u0019AA~\u0003e\u0019VM]5bY&T\u0018M\u00197f\u00052|7m\u001b'pG\u0006$\u0018n\u001c8\u0011\u0007\t\rTgE\u00036\u0005+\u0014i\u0004\u0005\b\u0003X\nu'q\tB$\u0005'\u0012\u0019F!\u0019\u000e\u0005\te'\u0002\u0002Bn\u00033\tqA];oi&lW-\u0003\u0003\u0003`\ne'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiQ\u0011!\u0011[\u0001\u0006CB\u0004H.\u001f\u000b\u000b\u0005C\u00129O!;\u0003l\n5\bb\u0002B\"q\u0001\u0007!q\t\u0005\b\u0005\u0017B\u0004\u0019\u0001B$\u0011\u001d\u0011y\u0005\u000fa\u0001\u0005'BqAa\u00179\u0001\u0004\u0011\u0019&A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tM(1 \t\u0007\u0003\u001b\nyE!>\u0011\u0019\u00055#q\u001fB$\u0005\u000f\u0012\u0019Fa\u0015\n\t\te\u0018\u0011\u0004\u0002\u0007)V\u0004H.\u001a\u001b\t\u0013\tu\u0018(!AA\u0002\t\u0005\u0014a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019\u0019\u0001\u0005\u0003\u0003\"\u000e\u0015\u0011\u0002BB\u0004\u0005G\u0013aa\u00142kK\u000e$(AF*fe&\fG.\u001b>bE2,g)\u001b7f'R\fG/^:\u0014\u000fm\u0012yBa\u000e\u0003>\u0005!\u0001/\u0019;i+\t\t\u0019%A\u0003qCRD\u0007%A\u0003jg\u0012K'/\u0006\u0002\u0002r\u00061\u0011n\u001d#je\u0002\n\u0001C\u00197pG.\u0014V\r\u001d7jG\u0006$\u0018n\u001c8\u0016\u0005\ru\u0001\u0003BA'\u0007?IAa!\t\u0002\u001a\t)1\u000b[8si\u0006\t\"\r\\8dWJ+\u0007\u000f\\5dCRLwN\u001c\u0011\u0002\u0013\tdwnY6TSj,\u0017A\u00032m_\u000e\\7+\u001b>fA\u0005\u0001Rn\u001c3jM&\u001c\u0017\r^5p]RKW.Z\u0001\u0012[>$\u0017NZ5dCRLwN\u001c+j[\u0016\u0004\u0013AC1dG\u0016\u001c8\u000fV5nK\u0006Y\u0011mY2fgN$\u0016.\\3!\u00039\u0011Gn\\2l\u0019>\u001c\u0017\r^5p]N,\"a!\u000e\u0011\r\u00055\u0013Q\u0018B1\u0003=\u0011Gn\\2l\u0019>\u001c\u0017\r^5p]N\u0004CCEB\u001e\u0007{\u0019yd!\u0011\u0004D\r\u00153qIB%\u0007\u0017\u00022Aa\u0019<\u0011\u001d\u0019i\u0001\u0014a\u0001\u0003\u0007BqAa\u0017M\u0001\u0004\u0011\u0019\u0006C\u0004\u0004\u00141\u0003\r!!=\t\u000f\reA\n1\u0001\u0004\u001e!91Q\u0005'A\u0002\tM\u0003bBB\u0015\u0019\u0002\u0007!1\u000b\u0005\b\u0007[a\u0005\u0019\u0001B*\u0011\u001d\u0019\t\u0004\u0014a\u0001\u0007k!\"ca\u000f\u0004P\rE31KB+\u0007/\u001aIfa\u0017\u0004^!I1QB'\u0011\u0002\u0003\u0007\u00111\t\u0005\n\u00057j\u0005\u0013!a\u0001\u0005'B\u0011ba\u0005N!\u0003\u0005\r!!=\t\u0013\reQ\n%AA\u0002\ru\u0001\"CB\u0013\u001bB\u0005\t\u0019\u0001B*\u0011%\u0019I#\u0014I\u0001\u0002\u0004\u0011\u0019\u0006C\u0005\u0004.5\u0003\n\u00111\u0001\u0003T!I1\u0011G'\u0011\u0002\u0003\u00071QG\u000b\u0003\u0007CRC!a\u0011\u0003\u0000U\u00111Q\r\u0016\u0005\u0003c\u0014y(\u0006\u0002\u0004j)\"1Q\u0004B@\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU\nabY8qs\u0012\"WMZ1vYR$c'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%qU\u00111Q\u000f\u0016\u0005\u0007k\u0011y\b\u0006\u0003\u0002|\u000ee\u0004\"CAU1\u0006\u0005\t\u0019\u0001B\u0003)\u0011\t\tp! \t\u0013\u0005%&,!AA\u0002\u0005mH\u0003BAy\u0007\u0003C\u0011\"!+^\u0003\u0003\u0005\r!a?\u0002-M+'/[1mSj\f'\r\\3GS2,7\u000b^1ukN\u00042Aa\u0019`'\u0015y6\u0011\u0012B\u001f!Y\u00119na#\u0002D\tM\u0013\u0011_B\u000f\u0005'\u0012\u0019Fa\u0015\u00046\rm\u0012\u0002BBG\u00053\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c89)\t\u0019)\t\u0006\n\u0004<\rM5QSBL\u00073\u001bYj!(\u0004 \u000e\u0005\u0006bBB\u0007E\u0002\u0007\u00111\t\u0005\b\u00057\u0012\u0007\u0019\u0001B*\u0011\u001d\u0019\u0019B\u0019a\u0001\u0003cDqa!\u0007c\u0001\u0004\u0019i\u0002C\u0004\u0004&\t\u0004\rAa\u0015\t\u000f\r%\"\r1\u0001\u0003T!91Q\u00062A\u0002\tM\u0003bBB\u0019E\u0002\u00071Q\u0007\u000b\u0005\u0007K\u001bi\u000b\u0005\u0004\u0002N\u0005=3q\u0015\t\u0015\u0003\u001b\u001aI+a\u0011\u0003T\u0005E8Q\u0004B*\u0005'\u0012\u0019f!\u000e\n\t\r-\u0016\u0011\u0004\u0002\u0007)V\u0004H.\u001a\u001d\t\u0013\tu8-!AA\u0002\rm\u0012!\u00052vY.d\u0015n\u001d;MK\u00064g)\u001b7fgRQ11WB_\u0007\u007f\u001bym!7\u0011\r\u0005\u001d\u00111DB[!!\tiea.\u0002\"\rm\u0016\u0002BB]\u00033\u0011a\u0001V;qY\u0016\u0014\u0004CBA\u0004\u00037\t9\nC\u0004\u0003\u0018\u0015\u0004\r!!\u0002\t\u000f\r\u0005W\r1\u0001\u0004D\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\r\u001571Z\u0007\u0003\u0007\u000fTAa!3\u0002*\u0005!1m\u001c8g\u0013\u0011\u0019ima2\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001d\u0019\t.\u001aa\u0001\u0007'\faAZ5mi\u0016\u0014\b\u0003BA\u0012\u0007+LAaa6\u0002&\tQ\u0001+\u0019;i\r&dG/\u001a:\t\u000bq,\u0007\u0019A?\u0015\u0015\rm6Q\\Bp\u0007C\u001c\u0019\u000fC\u0004\u0004\u000e\u0019\u0004\r!!\t\t\u000f\r\u0005g\r1\u0001\u0004D\"91\u0011\u001b4A\u0002\rM\u0007bBBsM\u0002\u00071q]\u0001\u000bg\u0016\u001c8/[8o\u001fB$\b#BA'\u0003\u001fj\u0018aD:i_VdGMR5mi\u0016\u0014x*\u001e;\u0015\t\u0005E8Q\u001e\u0005\b\u0007_<\u0007\u0019AA\"\u0003!\u0001\u0018\r\u001e5OC6,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0004v*\"\u0011\u0011\rB@\u0001")
public class InMemoryFileIndex
extends PartitioningAwareFileIndex {
    private final SparkSession sparkSession;
    private final FileStatusCache fileStatusCache;
    private final Seq<Path> rootPaths;
    private volatile LinkedHashMap<Path, FileStatus> cachedLeafFiles;
    private volatile Map<Path, FileStatus[]> cachedLeafDirToChildrenFiles;
    private volatile PartitionSpec cachedPartitionSpec;

    public static FileStatusCache $lessinit$greater$default$5() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean shouldFilterOut(String string) {
        return InMemoryFileIndex$.MODULE$.shouldFilterOut(string);
    }

    @Override
    public Seq<Path> rootPaths() {
        return this.rootPaths;
    }

    private LinkedHashMap<Path, FileStatus> cachedLeafFiles() {
        return this.cachedLeafFiles;
    }

    private void cachedLeafFiles_$eq(LinkedHashMap<Path, FileStatus> x$1) {
        this.cachedLeafFiles = x$1;
    }

    private Map<Path, FileStatus[]> cachedLeafDirToChildrenFiles() {
        return this.cachedLeafDirToChildrenFiles;
    }

    private void cachedLeafDirToChildrenFiles_$eq(Map<Path, FileStatus[]> x$1) {
        this.cachedLeafDirToChildrenFiles = x$1;
    }

    private PartitionSpec cachedPartitionSpec() {
        return this.cachedPartitionSpec;
    }

    private void cachedPartitionSpec_$eq(PartitionSpec x$1) {
        this.cachedPartitionSpec = x$1;
    }

    @Override
    public PartitionSpec partitionSpec() {
        if (this.cachedPartitionSpec() == null) {
            this.cachedPartitionSpec_$eq(this.inferPartitioning());
        }
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Partition spec: ").append(this.cachedPartitionSpec()).toString());
        return this.cachedPartitionSpec();
    }

    @Override
    public LinkedHashMap<Path, FileStatus> leafFiles() {
        return this.cachedLeafFiles();
    }

    @Override
    public Map<Path, FileStatus[]> leafDirToChildrenFiles() {
        return this.cachedLeafDirToChildrenFiles();
    }

    @Override
    public void refresh() {
        this.fileStatusCache.invalidateAll();
        this.refresh0();
    }

    private void refresh0() {
        LinkedHashSet<FileStatus> files = this.listLeafFiles(this.rootPaths());
        this.cachedLeafFiles_$eq((LinkedHashMap<Path, FileStatus>)((LinkedHashMap)new LinkedHashMap().$plus$plus$eq((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getPath()), f), LinkedHashSet$.MODULE$.canBuildFrom()))));
        this.cachedLeafDirToChildrenFiles_$eq((Map<Path, FileStatus[]>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files.toArray(ClassTag$.MODULE$.apply(FileStatus.class)))).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath().getParent()));
        this.cachedPartitionSpec_$eq(null);
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof InMemoryFileIndex) {
            InMemoryFileIndex inMemoryFileIndex = (InMemoryFileIndex)object;
            Set set = this.rootPaths().toSet();
            Set set2 = inMemoryFileIndex.rootPaths().toSet();
            bl = !(set != null ? !set.equals(set2) : set2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.rootPaths().toSet().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public LinkedHashSet<FileStatus> listLeafFiles(Seq<Path> paths) {
        void var2_2;
        LinkedHashSet output = (LinkedHashSet)LinkedHashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer pathsToFetch = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        paths.foreach((Function1 & Serializable & scala.Serializable)path -> {
            ArrayBuffer arrayBuffer;
            Option<FileStatus[]> option = $this.fileStatusCache.getLeafFiles((Path)path);
            if (option instanceof Some) {
                Some some = (Some)option;
                FileStatus[] files = (FileStatus[])some.value();
                HiveCatalogMetrics$.MODULE$.incrementFileCacheHits(files.length);
                arrayBuffer = (AbstractIterable)output.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)));
            } else if (None$.MODULE$.equals(option)) {
                arrayBuffer = pathsToFetch.$plus$eq(path);
            } else {
                throw new MatchError(option);
            }
            return Unit$.MODULE$;
        });
        PathFilter filter = FileInputFormat.getInputPathFilter((JobConf)new JobConf(this.hadoopConf(), this.getClass()));
        Seq<Tuple2<Path, Seq<FileStatus>>> discovered = InMemoryFileIndex$.MODULE$.bulkListLeafFiles((Seq<Path>)pathsToFetch, this.hadoopConf(), filter, this.sparkSession);
        discovered.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path path = (Path)tuple2._1();
            Seq leafFiles = (Seq)tuple2._2();
            HiveCatalogMetrics$.MODULE$.incrementFilesDiscovered(leafFiles.size());
            $this.fileStatusCache.putLeafFiles(path, (FileStatus[])leafFiles.toArray(ClassTag$.MODULE$.apply(FileStatus.class)));
            LinkedHashSet linkedHashSet = (LinkedHashSet)output.$plus$plus$eq((TraversableOnce)leafFiles);
            return linkedHashSet;
        });
        return var2_2;
    }

    public InMemoryFileIndex(SparkSession sparkSession, Seq<Path> rootPathsSpecified, Map<String, String> parameters, Option<StructType> userSpecifiedSchema, FileStatusCache fileStatusCache) {
        this.sparkSession = sparkSession;
        this.fileStatusCache = fileStatusCache;
        super(sparkSession, parameters, userSpecifiedSchema, fileStatusCache);
        this.rootPaths = (Seq)rootPathsSpecified.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSink$.MODULE$.ancestorIsMetadataDirectory(x$1, this.hadoopConf())));
        this.refresh0();
    }

    public static class SerializableBlockLocation
    implements Product,
    scala.Serializable {
        private final String[] names;
        private final String[] hosts;
        private final long offset;
        private final long length;

        public String[] names() {
            return this.names;
        }

        public String[] hosts() {
            return this.hosts;
        }

        public long offset() {
            return this.offset;
        }

        public long length() {
            return this.length;
        }

        public SerializableBlockLocation copy(String[] names, String[] hosts, long offset, long length) {
            return new SerializableBlockLocation(names, hosts, offset, length);
        }

        public String[] copy$default$1() {
            return this.names();
        }

        public String[] copy$default$2() {
            return this.hosts();
        }

        public long copy$default$3() {
            return this.offset();
        }

        public long copy$default$4() {
            return this.length();
        }

        public String productPrefix() {
            return "SerializableBlockLocation";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.names();
                    break;
                }
                case 1: {
                    object = this.hosts();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.offset());
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToLong((long)this.length());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SerializableBlockLocation;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.names()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.hosts()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.offset()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.length()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SerializableBlockLocation)) return false;
            boolean bl = true;
            if (!bl) return false;
            SerializableBlockLocation serializableBlockLocation = (SerializableBlockLocation)x$1;
            if (this.names() != serializableBlockLocation.names()) return false;
            if (this.hosts() != serializableBlockLocation.hosts()) return false;
            if (this.offset() != serializableBlockLocation.offset()) return false;
            if (this.length() != serializableBlockLocation.length()) return false;
            if (!serializableBlockLocation.canEqual(this)) return false;
            return true;
        }

        public SerializableBlockLocation(String[] names, String[] hosts, long offset, long length) {
            this.names = names;
            this.hosts = hosts;
            this.offset = offset;
            this.length = length;
            Product.$init$((Product)this);
        }
    }

    public static class SerializableFileStatus
    implements Product,
    scala.Serializable {
        private final String path;
        private final long length;
        private final boolean isDir;
        private final short blockReplication;
        private final long blockSize;
        private final long modificationTime;
        private final long accessTime;
        private final SerializableBlockLocation[] blockLocations;

        public String path() {
            return this.path;
        }

        public long length() {
            return this.length;
        }

        public boolean isDir() {
            return this.isDir;
        }

        public short blockReplication() {
            return this.blockReplication;
        }

        public long blockSize() {
            return this.blockSize;
        }

        public long modificationTime() {
            return this.modificationTime;
        }

        public long accessTime() {
            return this.accessTime;
        }

        public SerializableBlockLocation[] blockLocations() {
            return this.blockLocations;
        }

        public SerializableFileStatus copy(String path, long length, boolean isDir, short blockReplication, long blockSize, long modificationTime, long accessTime, SerializableBlockLocation[] blockLocations) {
            return new SerializableFileStatus(path, length, isDir, blockReplication, blockSize, modificationTime, accessTime, blockLocations);
        }

        public String copy$default$1() {
            return this.path();
        }

        public long copy$default$2() {
            return this.length();
        }

        public boolean copy$default$3() {
            return this.isDir();
        }

        public short copy$default$4() {
            return this.blockReplication();
        }

        public long copy$default$5() {
            return this.blockSize();
        }

        public long copy$default$6() {
            return this.modificationTime();
        }

        public long copy$default$7() {
            return this.accessTime();
        }

        public SerializableBlockLocation[] copy$default$8() {
            return this.blockLocations();
        }

        public String productPrefix() {
            return "SerializableFileStatus";
        }

        public int productArity() {
            return 8;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.path();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.length());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.isDir());
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToShort((short)this.blockReplication());
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToLong((long)this.blockSize());
                    break;
                }
                case 5: {
                    object = BoxesRunTime.boxToLong((long)this.modificationTime());
                    break;
                }
                case 6: {
                    object = BoxesRunTime.boxToLong((long)this.accessTime());
                    break;
                }
                case 7: {
                    object = this.blockLocations();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SerializableFileStatus;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.length()));
            n = Statics.mix((int)n, (int)(this.isDir() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)this.blockReplication());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.blockSize()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.modificationTime()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.accessTime()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.blockLocations()));
            return Statics.finalizeHash((int)n, (int)8);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SerializableFileStatus)) return false;
            boolean bl = true;
            if (!bl) return false;
            SerializableFileStatus serializableFileStatus = (SerializableFileStatus)x$1;
            String string = this.path();
            String string2 = serializableFileStatus.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.length() != serializableFileStatus.length()) return false;
            if (this.isDir() != serializableFileStatus.isDir()) return false;
            if (this.blockReplication() != serializableFileStatus.blockReplication()) return false;
            if (this.blockSize() != serializableFileStatus.blockSize()) return false;
            if (this.modificationTime() != serializableFileStatus.modificationTime()) return false;
            if (this.accessTime() != serializableFileStatus.accessTime()) return false;
            if (this.blockLocations() != serializableFileStatus.blockLocations()) return false;
            if (!serializableFileStatus.canEqual(this)) return false;
            return true;
        }

        public SerializableFileStatus(String path, long length, boolean isDir, short blockReplication, long blockSize, long modificationTime, long accessTime, SerializableBlockLocation[] blockLocations) {
            this.path = path;
            this.length = length;
            this.isDir = isDir;
            this.blockReplication = blockReplication;
            this.blockSize = blockSize;
            this.modificationTime = modificationTime;
            this.accessTime = accessTime;
            this.blockLocations = blockLocations;
            Product.$init$((Product)this);
        }
    }
}

