/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.internal.SessionState;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.Numeric;
import scala.math.Ordered;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class CommandUtils$
implements Logging {
    public static CommandUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CommandUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void updateTableStats(SparkSession sparkSession, CatalogTable table) {
        block2: {
            if (!table.stats().nonEmpty()) break block2;
            SessionCatalog catalog = sparkSession.sessionState().catalog();
            if (sparkSession.sessionState().conf().autoSizeUpdateEnabled()) {
                CatalogTable newTable = catalog.getTableMetadata(table.identifier());
                BigInt newSize = this.calculateTotalSize(sparkSession, newTable);
                CatalogStatistics newStats = new CatalogStatistics(newSize, CatalogStatistics$.MODULE$.apply$default$2(), CatalogStatistics$.MODULE$.apply$default$3());
                catalog.alterTableStats(table.identifier(), (Option)new Some((Object)newStats));
            } else {
                catalog.alterTableStats(table.identifier(), (Option)None$.MODULE$);
            }
        }
    }

    public BigInt calculateTotalSize(SparkSession spark, CatalogTable catalogTable) {
        BigInt bigInt;
        SessionState sessionState = spark.sessionState();
        if (catalogTable.partitionColumnNames().isEmpty()) {
            bigInt = BigInt$.MODULE$.long2bigInt(this.calculateLocationSize(sessionState, catalogTable.identifier(), (Option<URI>)catalogTable.storage().locationUri()));
        } else {
            Seq partitions = sessionState.catalog().listPartitions(catalogTable.identifier(), sessionState.catalog().listPartitions$default$2());
            if (spark.sessionState().conf().parallelFileListingInStatsComputation()) {
                Seq paths = (Seq)partitions.map((Function1 & Serializable & scala.Serializable)x -> new Path((URI)x.storage().locationUri().get()), Seq$.MODULE$.canBuildFrom());
                String stagingDir = sessionState.conf().getConfString("hive.exec.stagingdir", ".hive-staging");
                PathFilter pathFilter = new PathFilter(stagingDir){
                    private final String stagingDir$1;

                    public boolean accept(Path path) {
                        return DataSourceUtils$.MODULE$.isDataPath(path) && !path.getName().startsWith(this.stagingDir$1);
                    }
                    {
                        this.stagingDir$1 = stagingDir$1;
                    }
                };
                Seq<Tuple2<Path, Seq<FileStatus>>> fileStatusSeq = InMemoryFileIndex$.MODULE$.bulkListLeafFiles((Seq<Path>)paths, sessionState.newHadoopConf(), pathFilter, spark);
                bigInt = BigInt$.MODULE$.long2bigInt(BoxesRunTime.unboxToLong((Object)((TraversableOnce)fileStatusSeq.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Seq)((TraversableLike)x$1._2()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.getLen()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            } else {
                bigInt = BigInt$.MODULE$.long2bigInt(BoxesRunTime.unboxToLong((Object)((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToLong((long)CommandUtils$.MODULE$.calculateLocationSize(sessionState, catalogTable.identifier(), (Option<URI>)p.storage().locationUri())), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            }
        }
        return bigInt;
    }

    public long calculateLocationSize(SessionState sessionState, TableIdentifier identifier, Option<URI> locationUri) {
        String stagingDir = sessionState.conf().getConfString("hive.exec.stagingdir", ".hive-staging");
        long startTime = System.nanoTime();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Starting to calculate the total file size under path ").append(locationUri).append(".").toString());
        long size = BoxesRunTime.unboxToLong((Object)locationUri.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToLong((long)CommandUtils$.$anonfun$calculateLocationSize$3(sessionState, identifier, stagingDir, p))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        long durationInMs = (System.nanoTime() - startTime) / 1000000L;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("It took ").append(durationInMs).append(" ms to calculate the total file size under path ").append(locationUri).append(".").toString());
        return size;
    }

    public Option<CatalogStatistics> compareAndGetNewStats(Option<CatalogStatistics> oldStats, BigInt newTotalSize, Option<BigInt> newRowCount) {
        None$ newStats;
        block2: {
            BigInt oldTotalSize = (BigInt)oldStats.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.sizeInBytes()).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.BigInt().apply(-1));
            BigInt oldRowCount = (BigInt)oldStats.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.rowCount()).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.BigInt().apply(-1));
            newStats = None$.MODULE$;
            if (newTotalSize.$greater$eq((Object)BigInt$.MODULE$.int2bigInt(0))) {
                BigInt bigInt = newTotalSize;
                BigInt bigInt2 = oldTotalSize;
                if (bigInt == null ? bigInt2 != null : !bigInt.equals(bigInt2)) {
                    newStats = new Some((Object)new CatalogStatistics(newTotalSize, CatalogStatistics$.MODULE$.apply$default$2(), CatalogStatistics$.MODULE$.apply$default$3()));
                }
            }
            if (!newRowCount.isDefined() || !((Ordered)newRowCount.get()).$greater$eq((Object)BigInt$.MODULE$.int2bigInt(0)) || BoxesRunTime.equals((Object)newRowCount.get(), (Object)oldRowCount)) break block2;
            newStats = newStats.isDefined() ? newStats.map((Function1 & Serializable & scala.Serializable)x$5 -> {
                Option x$1 = newRowCount;
                BigInt x$2 = x$5.copy$default$1();
                Map x$3 = x$5.copy$default$3();
                return x$5.copy(x$2, x$1, x$3);
            }) : new Some((Object)new CatalogStatistics(oldTotalSize, newRowCount, CatalogStatistics$.MODULE$.apply$default$3()));
        }
        return newStats;
    }

    public static final /* synthetic */ long $anonfun$calculateLocationSize$1(String stagingDir$2, Path path$1, FileSystem fs$1, FileStatus status) {
        return !status.getPath().getName().startsWith(stagingDir$2) && DataSourceUtils$.MODULE$.isDataPath(path$1) ? CommandUtils$.getPathSize$1(fs$1, status.getPath(), stagingDir$2) : 0L;
    }

    private static final long getPathSize$1(FileSystem fs, Path path, String stagingDir$2) {
        FileStatus fileStatus = fs.getFileStatus(path);
        long size = fileStatus.isDirectory() ? BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path))).map((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToLong((long)CommandUtils$.$anonfun$calculateLocationSize$1(stagingDir$2, path, fs, status)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) : fileStatus.getLen();
        return size;
    }

    public static final /* synthetic */ long $anonfun$calculateLocationSize$3(SessionState sessionState$2, TableIdentifier identifier$1, String stagingDir$2, URI p) {
        long l;
        Path path = new Path(p);
        try {
            FileSystem fs = path.getFileSystem(sessionState$2.newHadoopConf());
            l = CommandUtils$.getPathSize$1(fs, path, stagingDir$2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Failed to get the size of table ").append(identifier$1.table()).append(" in the ").append(new StringBuilder(21).append("database ").append(identifier$1.database()).append(" because of ").append(e.toString()).toString()).toString(), e);
            long l2 = 0L;
            l = l2;
        }
        return l;
    }

    private CommandUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

