/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.spark.sql.execution.vectorized.Dictionary;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.types.UTF8String;
import org.spark_project.guava.annotations.VisibleForTesting;

public abstract class WritableColumnVector
extends ColumnVector {
    protected Dictionary dictionary;
    protected WritableColumnVector dictionaryIds;
    protected int capacity;
    @VisibleForTesting
    protected int MAX_CAPACITY = ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH;
    protected int numNulls;
    protected boolean isConstant;
    protected static final int DEFAULT_ARRAY_LENGTH = 4;
    protected int elementsAppended;
    protected WritableColumnVector[] childColumns;

    public void reset() {
        if (this.isConstant) {
            return;
        }
        if (this.childColumns != null) {
            for (WritableColumnVector c : this.childColumns) {
                c.reset();
            }
        }
        this.elementsAppended = 0;
        if (this.numNulls > 0) {
            this.putNotNulls(0, this.capacity);
            this.numNulls = 0;
        }
    }

    @Override
    public void close() {
        if (this.childColumns != null) {
            for (int i = 0; i < this.childColumns.length; ++i) {
                this.childColumns[i].close();
                this.childColumns[i] = null;
            }
            this.childColumns = null;
        }
        if (this.dictionaryIds != null) {
            this.dictionaryIds.close();
            this.dictionaryIds = null;
        }
        this.dictionary = null;
    }

    public void reserve(int requiredCapacity) {
        if (requiredCapacity < 0) {
            this.throwUnsupportedException(requiredCapacity, null);
        } else if (requiredCapacity > this.capacity) {
            int newCapacity = (int)Math.min((long)this.MAX_CAPACITY, (long)requiredCapacity * 2L);
            if (requiredCapacity <= newCapacity) {
                try {
                    this.reserveInternal(newCapacity);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    this.throwUnsupportedException(requiredCapacity, outOfMemoryError);
                }
            } else {
                this.throwUnsupportedException(requiredCapacity, null);
            }
        }
    }

    private void throwUnsupportedException(int requiredCapacity, Throwable cause) {
        String message = "Cannot reserve additional contiguous bytes in the vectorized reader (" + (requiredCapacity >= 0 ? "requested " + requiredCapacity + " bytes" : "integer overflow") + "). As a workaround, you can reduce the vectorized reader batch size, or disable the vectorized reader. For parquet file format, refer to " + SQLConf.PARQUET_VECTORIZED_READER_BATCH_SIZE().key() + " (default " + SQLConf.PARQUET_VECTORIZED_READER_BATCH_SIZE().defaultValueString() + ") and " + SQLConf.PARQUET_VECTORIZED_READER_ENABLED().key() + "; for orc file format, refer to " + SQLConf.ORC_VECTORIZED_READER_BATCH_SIZE().key() + " (default " + SQLConf.ORC_VECTORIZED_READER_BATCH_SIZE().defaultValueString() + ") and " + SQLConf.ORC_VECTORIZED_READER_ENABLED().key() + ".";
        throw new RuntimeException(message, cause);
    }

    @Override
    public boolean hasNull() {
        return this.numNulls > 0;
    }

    @Override
    public int numNulls() {
        return this.numNulls;
    }

    public abstract int getDictId(int var1);

    public boolean hasDictionary() {
        return this.dictionary != null;
    }

    public WritableColumnVector getDictionaryIds() {
        return this.dictionaryIds;
    }

    public void setDictionary(Dictionary dictionary) {
        this.dictionary = dictionary;
    }

    public WritableColumnVector reserveDictionaryIds(int capacity) {
        if (this.dictionaryIds == null) {
            this.dictionaryIds = this.reserveNewColumn(capacity, DataTypes.IntegerType);
        } else {
            this.dictionaryIds.reset();
            this.dictionaryIds.reserve(capacity);
        }
        return this.dictionaryIds;
    }

    protected abstract void reserveInternal(int var1);

    public abstract void putNotNull(int var1);

    public abstract void putNull(int var1);

    public abstract void putNulls(int var1, int var2);

    public abstract void putNotNulls(int var1, int var2);

    public abstract void putBoolean(int var1, boolean var2);

    public abstract void putBooleans(int var1, int var2, boolean var3);

    public abstract void putByte(int var1, byte var2);

    public abstract void putBytes(int var1, int var2, byte var3);

    public abstract void putBytes(int var1, int var2, byte[] var3, int var4);

    public abstract void putShort(int var1, short var2);

    public abstract void putShorts(int var1, int var2, short var3);

    public abstract void putShorts(int var1, int var2, short[] var3, int var4);

    public abstract void putShorts(int var1, int var2, byte[] var3, int var4);

    public abstract void putInt(int var1, int var2);

    public abstract void putInts(int var1, int var2, int var3);

    public abstract void putInts(int var1, int var2, int[] var3, int var4);

    public abstract void putInts(int var1, int var2, byte[] var3, int var4);

    public abstract void putIntsLittleEndian(int var1, int var2, byte[] var3, int var4);

    public abstract void putLong(int var1, long var2);

    public abstract void putLongs(int var1, int var2, long var3);

    public abstract void putLongs(int var1, int var2, long[] var3, int var4);

    public abstract void putLongs(int var1, int var2, byte[] var3, int var4);

    public abstract void putLongsLittleEndian(int var1, int var2, byte[] var3, int var4);

    public abstract void putFloat(int var1, float var2);

    public abstract void putFloats(int var1, int var2, float var3);

    public abstract void putFloats(int var1, int var2, float[] var3, int var4);

    public abstract void putFloats(int var1, int var2, byte[] var3, int var4);

    public abstract void putDouble(int var1, double var2);

    public abstract void putDoubles(int var1, int var2, double var3);

    public abstract void putDoubles(int var1, int var2, double[] var3, int var4);

    public abstract void putDoubles(int var1, int var2, byte[] var3, int var4);

    public abstract void putArray(int var1, int var2, int var3);

    public abstract int putByteArray(int var1, byte[] var2, int var3, int var4);

    public final int putByteArray(int rowId, byte[] value) {
        return this.putByteArray(rowId, value, 0, value.length);
    }

    @Override
    public Decimal getDecimal(int rowId, int precision, int scale) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        if (precision <= Decimal.MAX_INT_DIGITS()) {
            return Decimal.createUnsafe((long)this.getInt(rowId), (int)precision, (int)scale);
        }
        if (precision <= Decimal.MAX_LONG_DIGITS()) {
            return Decimal.createUnsafe((long)this.getLong(rowId), (int)precision, (int)scale);
        }
        byte[] bytes = this.getBinary(rowId);
        BigInteger bigInteger = new BigInteger(bytes);
        BigDecimal javaDecimal = new BigDecimal(bigInteger, scale);
        return Decimal.apply((BigDecimal)javaDecimal, (int)precision, (int)scale);
    }

    public void putDecimal(int rowId, Decimal value, int precision) {
        if (precision <= Decimal.MAX_INT_DIGITS()) {
            this.putInt(rowId, (int)value.toUnscaledLong());
        } else if (precision <= Decimal.MAX_LONG_DIGITS()) {
            this.putLong(rowId, value.toUnscaledLong());
        } else {
            BigInteger bigInteger = value.toJavaBigDecimal().unscaledValue();
            this.putByteArray(rowId, bigInteger.toByteArray());
        }
    }

    @Override
    public UTF8String getUTF8String(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        if (this.dictionary == null) {
            return this.arrayData().getBytesAsUTF8String(this.getArrayOffset(rowId), this.getArrayLength(rowId));
        }
        byte[] bytes = this.dictionary.decodeToBinary(this.dictionaryIds.getDictId(rowId));
        return UTF8String.fromBytes((byte[])bytes);
    }

    protected abstract UTF8String getBytesAsUTF8String(int var1, int var2);

    @Override
    public byte[] getBinary(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        if (this.dictionary == null) {
            return this.arrayData().getBytes(this.getArrayOffset(rowId), this.getArrayLength(rowId));
        }
        return this.dictionary.decodeToBinary(this.dictionaryIds.getDictId(rowId));
    }

    public final int appendNull() {
        assert (!(this.dataType() instanceof StructType));
        this.reserve(this.elementsAppended + 1);
        this.putNull(this.elementsAppended);
        return this.elementsAppended++;
    }

    public final int appendNotNull() {
        this.reserve(this.elementsAppended + 1);
        this.putNotNull(this.elementsAppended);
        return this.elementsAppended++;
    }

    public final int appendNulls(int count) {
        assert (!(this.dataType() instanceof StructType));
        this.reserve(this.elementsAppended + count);
        int result = this.elementsAppended;
        this.putNulls(this.elementsAppended, count);
        this.elementsAppended += count;
        return result;
    }

    public final int appendNotNulls(int count) {
        assert (!(this.dataType() instanceof StructType));
        this.reserve(this.elementsAppended + count);
        int result = this.elementsAppended;
        this.putNotNulls(this.elementsAppended, count);
        this.elementsAppended += count;
        return result;
    }

    public final int appendBoolean(boolean v) {
        this.reserve(this.elementsAppended + 1);
        this.putBoolean(this.elementsAppended, v);
        return this.elementsAppended++;
    }

    public final int appendBooleans(int count, boolean v) {
        this.reserve(this.elementsAppended + count);
        int result = this.elementsAppended;
        this.putBooleans(this.elementsAppended, count, v);
        this.elementsAppended += count;
        return result;
    }

    public final int appendByte(byte v) {
        this.reserve(this.elementsAppended + 1);
        this.putByte(this.elementsAppended, v);
        return this.elementsAppended++;
    }

    public final int appendBytes(int count, byte v) {
        this.reserve(this.elementsAppended + count);
        int result = this.elementsAppended;
        this.putBytes(this.elementsAppended, count, v);
        this.elementsAppended += count;
        return result;
    }

    public final int appendBytes(int length, byte[] src, int offset) {
        this.reserve(this.elementsAppended + length);
        int result = this.elementsAppended;
        this.putBytes(this.elementsAppended, length, src, offset);
        this.elementsAppended += length;
        return result;
    }

    public final int appendShort(short v) {
        this.reserve(this.elementsAppended + 1);
        this.putShort(this.elementsAppended, v);
        return this.elementsAppended++;
    }

    public final int appendShorts(int count, short v) {
        this.reserve(this.elementsAppended + count);
        int result = this.elementsAppended;
        this.putShorts(this.elementsAppended, count, v);
        this.elementsAppended += count;
        return result;
    }

    public final int appendShorts(int length, short[] src, int offset) {
        this.reserve(this.elementsAppended + length);
        int result = this.elementsAppended;
        this.putShorts(this.elementsAppended, length, src, offset);
        this.elementsAppended += length;
        return result;
    }

    public final int appendInt(int v) {
        this.reserve(this.elementsAppended + 1);
        this.putInt(this.elementsAppended, v);
        return this.elementsAppended++;
    }

    public final int appendInts(int count, int v) {
        this.reserve(this.elementsAppended + count);
        int result = this.elementsAppended;
        this.putInts(this.elementsAppended, count, v);
        this.elementsAppended += count;
        return result;
    }

    public final int appendInts(int length, int[] src, int offset) {
        this.reserve(this.elementsAppended + length);
        int result = this.elementsAppended;
        this.putInts(this.elementsAppended, length, src, offset);
        this.elementsAppended += length;
        return result;
    }

    public final int appendLong(long v) {
        this.reserve(this.elementsAppended + 1);
        this.putLong(this.elementsAppended, v);
        return this.elementsAppended++;
    }

    public final int appendLongs(int count, long v) {
        this.reserve(this.elementsAppended + count);
        int result = this.elementsAppended;
        this.putLongs(this.elementsAppended, count, v);
        this.elementsAppended += count;
        return result;
    }

    public final int appendLongs(int length, long[] src, int offset) {
        this.reserve(this.elementsAppended + length);
        int result = this.elementsAppended;
        this.putLongs(this.elementsAppended, length, src, offset);
        this.elementsAppended += length;
        return result;
    }

    public final int appendFloat(float v) {
        this.reserve(this.elementsAppended + 1);
        this.putFloat(this.elementsAppended, v);
        return this.elementsAppended++;
    }

    public final int appendFloats(int count, float v) {
        this.reserve(this.elementsAppended + count);
        int result = this.elementsAppended;
        this.putFloats(this.elementsAppended, count, v);
        this.elementsAppended += count;
        return result;
    }

    public final int appendFloats(int length, float[] src, int offset) {
        this.reserve(this.elementsAppended + length);
        int result = this.elementsAppended;
        this.putFloats(this.elementsAppended, length, src, offset);
        this.elementsAppended += length;
        return result;
    }

    public final int appendDouble(double v) {
        this.reserve(this.elementsAppended + 1);
        this.putDouble(this.elementsAppended, v);
        return this.elementsAppended++;
    }

    public final int appendDoubles(int count, double v) {
        this.reserve(this.elementsAppended + count);
        int result = this.elementsAppended;
        this.putDoubles(this.elementsAppended, count, v);
        this.elementsAppended += count;
        return result;
    }

    public final int appendDoubles(int length, double[] src, int offset) {
        this.reserve(this.elementsAppended + length);
        int result = this.elementsAppended;
        this.putDoubles(this.elementsAppended, length, src, offset);
        this.elementsAppended += length;
        return result;
    }

    public final int appendByteArray(byte[] value, int offset, int length) {
        int copiedOffset = this.arrayData().appendBytes(length, value, offset);
        this.reserve(this.elementsAppended + 1);
        this.putArray(this.elementsAppended, copiedOffset, length);
        return this.elementsAppended++;
    }

    public final int appendArray(int length) {
        this.reserve(this.elementsAppended + 1);
        this.putArray(this.elementsAppended, this.arrayData().elementsAppended, length);
        return this.elementsAppended++;
    }

    public final int appendStruct(boolean isNull) {
        if (isNull) {
            this.appendNull();
            for (WritableColumnVector c : this.childColumns) {
                if (c.type instanceof StructType) {
                    c.appendStruct(true);
                    continue;
                }
                c.appendNull();
            }
        } else {
            this.appendNotNull();
        }
        return this.elementsAppended;
    }

    @Override
    public final ColumnarArray getArray(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return new ColumnarArray(this.arrayData(), this.getArrayOffset(rowId), this.getArrayLength(rowId));
    }

    @Override
    public final ColumnarMap getMap(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return new ColumnarMap(this.getChild(0), this.getChild(1), this.getArrayOffset(rowId), this.getArrayLength(rowId));
    }

    public WritableColumnVector arrayData() {
        return this.childColumns[0];
    }

    public abstract int getArrayLength(int var1);

    public abstract int getArrayOffset(int var1);

    @Override
    public WritableColumnVector getChild(int ordinal) {
        return this.childColumns[ordinal];
    }

    public final int getElementsAppended() {
        return this.elementsAppended;
    }

    public final void setIsConstant() {
        this.isConstant = true;
    }

    protected abstract WritableColumnVector reserveNewColumn(int var1, DataType var2);

    protected boolean isArray() {
        return this.type instanceof ArrayType || this.type instanceof BinaryType || this.type instanceof StringType || DecimalType.isByteArrayDecimalType((DataType)this.type);
    }

    protected WritableColumnVector(int capacity, DataType type) {
        super(type);
        this.capacity = capacity;
        if (this.isArray()) {
            DataType childType;
            int childCapacity = capacity;
            if (type instanceof ArrayType) {
                childType = ((ArrayType)type).elementType();
            } else {
                childType = DataTypes.ByteType;
                childCapacity *= 4;
            }
            this.childColumns = new WritableColumnVector[1];
            this.childColumns[0] = this.reserveNewColumn(childCapacity, childType);
        } else if (type instanceof StructType) {
            StructType st = (StructType)type;
            this.childColumns = new WritableColumnVector[st.fields().length];
            for (int i = 0; i < this.childColumns.length; ++i) {
                this.childColumns[i] = this.reserveNewColumn(capacity, st.fields()[i].dataType());
            }
        } else if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            this.childColumns = new WritableColumnVector[2];
            this.childColumns[0] = this.reserveNewColumn(capacity, mapType.keyType());
            this.childColumns[1] = this.reserveNewColumn(capacity, mapType.valueType());
        } else if (type instanceof CalendarIntervalType) {
            this.childColumns = new WritableColumnVector[2];
            this.childColumns[0] = this.reserveNewColumn(capacity, DataTypes.IntegerType);
            this.childColumns[1] = this.reserveNewColumn(capacity, DataTypes.LongType);
        } else {
            this.childColumns = null;
        }
    }
}

