/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.ui;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.AccumulableInfo;
import org.apache.spark.scheduler.JobResult;
import org.apache.spark.scheduler.JobSucceeded$;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerExecutorMetricsUpdate;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.TaskInfo;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlanInfo;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.execution.ui.LiveExecutionData;
import org.apache.spark.sql.execution.ui.LiveStageMetrics;
import org.apache.spark.sql.execution.ui.LiveTaskMetrics;
import org.apache.spark.sql.execution.ui.SQLExecutionUIData;
import org.apache.spark.sql.execution.ui.SQLPlanMetric;
import org.apache.spark.sql.execution.ui.SparkListenerDriverAccumUpdates;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionEnd;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.apache.spark.sql.execution.ui.SparkPlanGraph;
import org.apache.spark.sql.execution.ui.SparkPlanGraph$;
import org.apache.spark.sql.execution.ui.SparkPlanGraphCluster;
import org.apache.spark.sql.execution.ui.SparkPlanGraphClusterWrapper;
import org.apache.spark.sql.execution.ui.SparkPlanGraphNode;
import org.apache.spark.sql.execution.ui.SparkPlanGraphNodeWrapper;
import org.apache.spark.sql.execution.ui.SparkPlanGraphWrapper;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.status.ElementTrackingStore;
import org.apache.spark.status.KVUtils$;
import org.apache.spark.status.config$;
import org.apache.spark.util.kvstore.KVStoreView;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Uh\u0001B\u0001\u0003\u0001=\u0011AcU)M\u0003B\u00048\u000b^1ukNd\u0015n\u001d;f]\u0016\u0014(BA\u0002\u0005\u0003\t)\u0018N\u0003\u0002\u0006\r\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001A1\u0002CA\t\u0015\u001b\u0005\u0011\"BA\n\t\u0003%\u00198\r[3ek2,'/\u0003\u0002\u0016%\ti1\u000b]1sW2K7\u000f^3oKJ\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0005\u0002\u0011%tG/\u001a:oC2L!a\u0007\r\u0003\u000f1{wmZ5oO\"AQ\u0004\u0001B\u0001B\u0003%a$\u0001\u0003d_:4\u0007CA\u0010!\u001b\u0005A\u0011BA\u0011\t\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003\u001dYgo\u001d;pe\u0016\u0004\"!\n\u0015\u000e\u0003\u0019R!a\n\u0005\u0002\rM$\u0018\r^;t\u0013\tIcE\u0001\u000bFY\u0016lWM\u001c;Ue\u0006\u001c7.\u001b8h'R|'/\u001a\u0005\tW\u0001\u0011\t\u0011)A\u0005Y\u0005!A.\u001b<f!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u001d\u0011un\u001c7fC:DQa\r\u0001\u0005\u0002Q\na\u0001P5oSRtD\u0003B\u001b8qe\u0002\"A\u000e\u0001\u000e\u0003\tAQ!\b\u001aA\u0002yAQa\t\u001aA\u0002\u0011BQa\u000b\u001aA\u00021Bqa\u000f\u0001C\u0002\u0013%A(\u0001\nmSZ,W\u000b\u001d3bi\u0016\u0004VM]5pI:\u001bX#A\u001f\u0011\u00055r\u0014BA /\u0005\u0011auN\\4\t\r\u0005\u0003\u0001\u0015!\u0003>\u0003Ma\u0017N^3Va\u0012\fG/\u001a)fe&|GMT:!\u0011\u001d\u0019\u0005A1A\u0005\n\u0011\u000ba\u0002\\5wK\u0016CXmY;uS>t7/F\u0001F!\u00111U*P(\u000e\u0003\u001dS!\u0001S%\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002K\u0017\u0006!Q\u000f^5m\u0015\u0005a\u0015\u0001\u00026bm\u0006L!AT$\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u00027!&\u0011\u0011K\u0001\u0002\u0012\u0019&4X-\u0012=fGV$\u0018n\u001c8ECR\f\u0007BB*\u0001A\u0003%Q)A\bmSZ,W\t_3dkRLwN\\:!\u0011\u001d)\u0006A1A\u0005\nY\u000bAb\u001d;bO\u0016lU\r\u001e:jGN,\u0012a\u0016\t\u0005\r6C6\f\u0005\u0002.3&\u0011!L\f\u0002\u0004\u0013:$\bC\u0001\u001c]\u0013\ti&A\u0001\tMSZ,7\u000b^1hK6+GO]5dg\"1q\f\u0001Q\u0001\n]\u000bQb\u001d;bO\u0016lU\r\u001e:jGN\u0004\u0003BB1\u0001\t\u00031!-\u0001\u0006o_2Kg/\u001a#bi\u0006$\u0012\u0001\f\u0005\u0006I\u0002!\t%Z\u0001\u000b_:TuNY*uCJ$HC\u00014j!\tis-\u0003\u0002i]\t!QK\\5u\u0011\u0015Q7\r1\u0001l\u0003\u0015)g/\u001a8u!\t\tB.\u0003\u0002n%\t)2\u000b]1sW2K7\u000f^3oKJTuNY*uCJ$\b\"B8\u0001\t\u0003\u0002\u0018\u0001E8o'R\fw-Z*vE6LG\u000f^3e)\t1\u0017\u000fC\u0003k]\u0002\u0007!\u000f\u0005\u0002\u0012g&\u0011AO\u0005\u0002\u001c'B\f'o\u001b'jgR,g.\u001a:Ti\u0006<WmU;c[&$H/\u001a3\t\u000bY\u0004A\u0011I<\u0002\u0011=t'j\u001c2F]\u0012$\"A\u001a=\t\u000b),\b\u0019A=\u0011\u0005EQ\u0018BA>\u0013\u0005M\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe*{'-\u00128e\u0011\u0015i\b\u0001\"\u0011\u007f\u0003]yg.\u0012=fGV$xN]'fiJL7m]+qI\u0006$X\r\u0006\u0002g\u007f\"1!\u000e a\u0001\u0003\u0003\u00012!EA\u0002\u0013\r\t)A\u0005\u0002#'B\f'o\u001b'jgR,g.\u001a:Fq\u0016\u001cW\u000f^8s\u001b\u0016$(/[2t+B$\u0017\r^3\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f\u0005IqN\u001c+bg.,e\u000e\u001a\u000b\u0004M\u00065\u0001b\u00026\u0002\b\u0001\u0007\u0011q\u0002\t\u0004#\u0005E\u0011bAA\n%\t!2\u000b]1sW2K7\u000f^3oKJ$\u0016m]6F]\u0012Dq!a\u0006\u0001\t\u0003\tI\"\u0001\u000bmSZ,W\t_3dkRLwN\\'fiJL7m\u001d\u000b\u0005\u00037\ti\u0004E\u0003.\u0003;\t\t#C\u0002\u0002 9\u0012aa\u00149uS>t\u0007cBA\u0012\u0003ci\u0014q\u0007\b\u0005\u0003K\ti\u0003E\u0002\u0002(9j!!!\u000b\u000b\u0007\u0005-b\"\u0001\u0004=e>|GOP\u0005\u0004\u0003_q\u0013A\u0002)sK\u0012,g-\u0003\u0003\u00024\u0005U\"aA'ba*\u0019\u0011q\u0006\u0018\u0011\t\u0005\r\u0012\u0011H\u0005\u0005\u0003w\t)D\u0001\u0004TiJLgn\u001a\u0005\b\u0003\u007f\t)\u00021\u0001>\u0003-)\u00070Z2vi&|g.\u00133\t\u000f\u0005\r\u0003\u0001\"\u0003\u0002F\u0005\u0001\u0012mZ4sK\u001e\fG/Z'fiJL7m\u001d\u000b\u0005\u0003C\t9\u0005C\u0004\u0002J\u0005\u0005\u0003\u0019A(\u0002\t\u0015DXm\u0019\u0005\b\u0003\u001b\u0002A\u0011BA(\u0003I)\b\u000fZ1uKN#\u0018mZ3NKR\u0014\u0018nY:\u0015\u0017\u0019\f\t&!\u0016\u0002Z\u0005u\u0013\u0011\u0010\u0005\b\u0003'\nY\u00051\u0001Y\u0003\u001d\u0019H/Y4f\u0013\u0012Dq!a\u0016\u0002L\u0001\u0007\u0001,A\u0005biR,W\u000e\u001d;JI\"9\u00111LA&\u0001\u0004i\u0014A\u0002;bg.LE\r\u0003\u0005\u0002`\u0005-\u0003\u0019AA1\u00031\t7mY;n+B$\u0017\r^3t!\u0019\t\u0019'!\u001c\u0002t9!\u0011QMA5\u001d\u0011\t9#a\u001a\n\u0003=J1!a\u001b/\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001c\u0002r\t\u00191+Z9\u000b\u0007\u0005-d\u0006E\u0002\u0012\u0003kJ1!a\u001e\u0013\u0005=\t5mY;nk2\f'\r\\3J]\u001a|\u0007bBA>\u0003\u0017\u0002\r\u0001L\u0001\ngV\u001c7-Z3eK\u0012Dq!a \u0001\t\u0013\t\t)\u0001\tp]\u0016CXmY;uS>t7\u000b^1siR\u0019a-a!\t\u000f)\fi\b1\u0001\u0002\u0006B\u0019a'a\"\n\u0007\u0005%%A\u0001\u0010Ta\u0006\u00148\u000eT5ti\u0016tWM]*R\u0019\u0016CXmY;uS>t7\u000b^1si\"9\u0011Q\u0012\u0001\u0005\n\u0005=\u0015AD8o\u000bb,7-\u001e;j_:,e\u000e\u001a\u000b\u0004M\u0006E\u0005b\u00026\u0002\f\u0002\u0007\u00111\u0013\t\u0004m\u0005U\u0015bAAL\u0005\ta2\u000b]1sW2K7\u000f^3oKJ\u001c\u0016\u000bT#yK\u000e,H/[8o\u000b:$\u0007bBAN\u0001\u0011%\u0011QT\u0001\u0015_:$%/\u001b<fe\u0006\u001b7-^7Va\u0012\fG/Z:\u0015\u0007\u0019\fy\nC\u0004k\u00033\u0003\r!!)\u0011\u0007Y\n\u0019+C\u0002\u0002&\n\u0011qd\u00159be.d\u0015n\u001d;f]\u0016\u0014HI]5wKJ\f5mY;n+B$\u0017\r^3t\u0011\u001d\tI\u000b\u0001C!\u0003W\u000bAb\u001c8Pi\",'/\u0012<f]R$2AZAW\u0011\u001dQ\u0017q\u0015a\u0001\u0003_\u00032!EAY\u0013\r\t\u0019L\u0005\u0002\u0013'B\f'o\u001b'jgR,g.\u001a:Fm\u0016tG\u000fC\u0004\u00028\u0002!I!!/\u0002)\u001d,Go\u0014:De\u0016\fG/Z#yK\u000e,H/[8o)\ry\u00151\u0018\u0005\b\u0003\u007f\t)\f1\u0001>\u0011\u001d\ty\f\u0001C\u0005\u0003\u0003\fa!\u001e9eCR,G#\u00024\u0002D\u0006\u0015\u0007bBA%\u0003{\u0003\ra\u0014\u0005\n\u0003\u000f\fi\f%AA\u00021\nQAZ8sG\u0016Dq!a3\u0001\t\u0013\ti-\u0001\u0006jgN\u000bFj\u0015;bO\u0016$2\u0001LAh\u0011\u001d\t\u0019&!3A\u0002aCq!a5\u0001\t\u0013\t).A\tdY\u0016\fg.\u001e9Fq\u0016\u001cW\u000f^5p]N$2AZAl\u0011\u001d\tI.!5A\u0002u\nQaY8v]RD\u0011\"!8\u0001#\u0003%I!a8\u0002!U\u0004H-\u0019;fI\u0011,g-Y;mi\u0012\u0012TCAAqU\ra\u00131]\u0016\u0003\u0003K\u0004B!a:\u0002r6\u0011\u0011\u0011\u001e\u0006\u0005\u0003W\fi/A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u001e\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002t\u0006%(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class SQLAppStatusListener
extends SparkListener
implements Logging {
    private final SparkConf conf;
    private final ElementTrackingStore kvstore;
    private final boolean live;
    private final long liveUpdatePeriodNs;
    private final ConcurrentHashMap<Object, LiveExecutionData> liveExecutions;
    private final ConcurrentHashMap<Object, LiveStageMetrics> stageMetrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long liveUpdatePeriodNs() {
        return this.liveUpdatePeriodNs;
    }

    private ConcurrentHashMap<Object, LiveExecutionData> liveExecutions() {
        return this.liveExecutions;
    }

    private ConcurrentHashMap<Object, LiveStageMetrics> stageMetrics() {
        return this.stageMetrics;
    }

    public boolean noLiveData() {
        return this.liveExecutions().isEmpty() && this.stageMetrics().isEmpty();
    }

    public void onJobStart(SparkListenerJobStart event) {
        String executionIdString = event.properties().getProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
        if (executionIdString == null) {
            return;
        }
        long executionId = new StringOps(Predef$.MODULE$.augmentString(executionIdString)).toLong();
        int jobId = event.jobId();
        LiveExecutionData exec = this.getOrCreateExecution(executionId);
        List accumIds = ((TraversableOnce)((SeqLike)exec.metrics().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.accumulatorId()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$)).toList();
        event.stageIds().foreach((Function1 & Serializable & scala.Serializable)id -> SQLAppStatusListener.$anonfun$onJobStart$2(this, accumIds, BoxesRunTime.unboxToInt((Object)id)));
        exec.jobs_$eq((Map<Object, JobExecutionStatus>)exec.jobs().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)jobId)), (Object)JobExecutionStatus.RUNNING)));
        exec.stages_$eq((Set<Object>)((Set)exec.stages().$plus$plus((GenTraversableOnce)event.stageIds().toSet())));
        this.update(exec, true);
    }

    public void onStageSubmitted(SparkListenerStageSubmitted event) {
        if (!this.isSQLStage(event.stageInfo().stageId())) {
            return;
        }
        Option$.MODULE$.apply((Object)this.stageMetrics().get(BoxesRunTime.boxToInteger((int)event.stageInfo().stageId()))).foreach((Function1 & Serializable & scala.Serializable)metrics -> {
            SQLAppStatusListener.$anonfun$onStageSubmitted$1(event, metrics);
            return BoxedUnit.UNIT;
        });
    }

    public void onJobEnd(SparkListenerJobEnd event) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.liveExecutions().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)exec -> {
            SQLAppStatusListener.$anonfun$onJobEnd$1(this, event, exec);
            return BoxedUnit.UNIT;
        });
    }

    public void onExecutorMetricsUpdate(SparkListenerExecutorMetricsUpdate event) {
        event.accumUpdates().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SQLAppStatusListener.$anonfun$onExecutorMetricsUpdate$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void onTaskEnd(SparkListenerTaskEnd event) {
        if (!this.isSQLStage(event.stageId())) {
            return;
        }
        TaskInfo info = event.taskInfo();
        Seq accums = this.live && event.taskMetrics() != null ? (Seq)event.taskMetrics().externalAccums().flatMap((Function1 & Serializable & scala.Serializable)a -> {
            Iterable iterable;
            try {
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)a.toInfo((Option)new Some(a.value()), (Option)None$.MODULE$)));
            }
            catch (IllegalAccessError illegalAccessError) {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, ArrayBuffer$.MODULE$.canBuildFrom()) : info.accumulables();
        this.updateStageMetrics(event.stageId(), event.stageAttemptId(), info.taskId(), (Seq<AccumulableInfo>)accums, info.successful());
    }

    public Option<Map<Object, String>> liveExecutionMetrics(long executionId) {
        return Option$.MODULE$.apply((Object)this.liveExecutions().get(BoxesRunTime.boxToLong((long)executionId))).map((Function1 & Serializable & scala.Serializable)exec -> exec.metricsValues() != null ? exec.metricsValues() : this.aggregateMetrics((LiveExecutionData)((Object)exec)));
    }

    private Map<Object, String> aggregateMetrics(LiveExecutionData exec) {
        Seq metricIds = (Seq)((SeqLike)exec.metrics().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.accumulatorId()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$);
        Map metricTypes = ((TraversableOnce)exec.metrics().map((Function1 & Serializable & scala.Serializable)m -> new Tuple2((Object)BoxesRunTime.boxToLong((long)m.accumulatorId()), (Object)m.metricType()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq metrics2 = (Seq)((TraversableLike)((TraversableLike)exec.stages().toSeq().flatMap((Function1 & Serializable & scala.Serializable)stageId -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this.stageMetrics().get(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)stageId))))), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(x$3.taskMetrics().values()).asScala(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)metrics -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(metrics.ids())).zip((GenIterable)Predef$.MODULE$.wrapLongArray(metrics.values()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))), Seq$.MODULE$.canBuildFrom());
        Map<Object, String> aggregatedMetrics = (Map<Object, String>)((TraversableLike)((TraversableLike)metrics2.$plus$plus((GenTraversableOnce)exec.driverAccumUpdates().toSeq(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)SQLAppStatusListener.$anonfun$aggregateMetrics$6(metricIds, x0$2)))).groupBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4._1$mcJ$sp())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long id = tuple2._1$mcJ$sp();
            Seq values = (Seq)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)id)), (Object)SQLMetrics$.MODULE$.stringValue((String)metricTypes.apply((Object)BoxesRunTime.boxToLong((long)id)), (Seq<Object>)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5._2$mcJ$sp()), Seq$.MODULE$.canBuildFrom())).toSeq()));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        return exec.metricsValues() != null ? exec.metricsValues() : aggregatedMetrics;
    }

    private void updateStageMetrics(int stageId, int attemptId, long taskId, Seq<AccumulableInfo> accumUpdates, boolean succeeded) {
        Object object = new Object();
        try {
            Option$.MODULE$.apply((Object)this.stageMetrics().get(BoxesRunTime.boxToInteger((int)stageId))).foreach((Function1 & Serializable & scala.Serializable)metrics -> {
                if (metrics.attemptId() != attemptId || new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(metrics.accumulatorIds())).isEmpty()) {
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                LiveTaskMetrics oldTaskMetrics = metrics.taskMetrics().get(BoxesRunTime.boxToLong((long)taskId));
                if (oldTaskMetrics != null && oldTaskMetrics.succeeded()) {
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                Seq updates = (Seq)((SeqLike)accumUpdates.filter((Function1 & Serializable & scala.Serializable)acc -> BoxesRunTime.boxToBoolean((boolean)SQLAppStatusListener.$anonfun$updateStageMetrics$2(metrics, acc)))).sortBy((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.id()), (Ordering)Ordering.Long$.MODULE$);
                if (updates.isEmpty()) {
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
                long[] ids = new long[updates.size()];
                long[] values = new long[updates.size()];
                ((IterableLike)updates.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    SQLAppStatusListener.$anonfun$updateStageMetrics$4(ids, values, x0$4);
                    return BoxedUnit.UNIT;
                });
                return metrics.taskMetrics().put(BoxesRunTime.boxToLong((long)taskId), new LiveTaskMetrics(ids, values, succeeded));
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private void onExecutionStart(SparkListenerSQLExecutionStart event) {
        SparkListenerSQLExecutionStart sparkListenerSQLExecutionStart = event;
        if (sparkListenerSQLExecutionStart == null) {
            throw new MatchError((Object)sparkListenerSQLExecutionStart);
        }
        long executionId = sparkListenerSQLExecutionStart.executionId();
        String description = sparkListenerSQLExecutionStart.description();
        String details = sparkListenerSQLExecutionStart.details();
        String physicalPlanDescription = sparkListenerSQLExecutionStart.physicalPlanDescription();
        SparkPlanInfo sparkPlanInfo = sparkListenerSQLExecutionStart.sparkPlanInfo();
        long time = sparkListenerSQLExecutionStart.time();
        Tuple6 tuple6 = new Tuple6((Object)BoxesRunTime.boxToLong((long)executionId), (Object)description, (Object)details, (Object)physicalPlanDescription, (Object)sparkPlanInfo, (Object)BoxesRunTime.boxToLong((long)time));
        Tuple6 tuple62 = tuple6;
        long executionId2 = BoxesRunTime.unboxToLong((Object)tuple62._1());
        String description2 = (String)tuple62._2();
        String details2 = (String)tuple62._3();
        String physicalPlanDescription2 = (String)tuple62._4();
        SparkPlanInfo sparkPlanInfo2 = (SparkPlanInfo)tuple62._5();
        long time2 = BoxesRunTime.unboxToLong((Object)tuple62._6());
        SparkPlanGraph planGraph = SparkPlanGraph$.MODULE$.apply(sparkPlanInfo2);
        List sqlPlanMetrics = ((TraversableOnce)planGraph.allNodes().flatMap((Function1 & Serializable & scala.Serializable)node -> (Seq)node.metrics().map((Function1 & Serializable & scala.Serializable)metric -> new Tuple2((Object)BoxesRunTime.boxToLong((long)metric.accumulatorId()), metric), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).values().toList();
        SparkPlanGraphWrapper graphToStore = new SparkPlanGraphWrapper(executionId2, (Seq<SparkPlanGraphNodeWrapper>)SQLAppStatusListener.toStoredNodes$1(planGraph.nodes()), planGraph.edges());
        this.kvstore.write((Object)graphToStore);
        LiveExecutionData exec = this.getOrCreateExecution(executionId2);
        exec.description_$eq(description2);
        exec.details_$eq(details2);
        exec.physicalPlanDescription_$eq(physicalPlanDescription2);
        exec.metrics_$eq((Seq<SQLPlanMetric>)sqlPlanMetrics);
        exec.submissionTime_$eq(time2);
        this.update(exec, this.update$default$2());
    }

    private void onExecutionEnd(SparkListenerSQLExecutionEnd event) {
        SparkListenerSQLExecutionEnd sparkListenerSQLExecutionEnd = event;
        if (sparkListenerSQLExecutionEnd == null) {
            throw new MatchError((Object)sparkListenerSQLExecutionEnd);
        }
        long executionId = sparkListenerSQLExecutionEnd.executionId();
        long time = sparkListenerSQLExecutionEnd.time();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(executionId, time);
        Tuple2.mcJJ.sp sp3 = sp2;
        long executionId2 = sp3._1$mcJ$sp();
        long time2 = sp3._2$mcJ$sp();
        Option$.MODULE$.apply((Object)this.liveExecutions().get(BoxesRunTime.boxToLong((long)executionId2))).foreach((Function1 & Serializable & scala.Serializable)exec -> {
            SQLAppStatusListener.$anonfun$onExecutionEnd$1(this, time2, exec);
            return BoxedUnit.UNIT;
        });
    }

    private void onDriverAccumUpdates(SparkListenerDriverAccumUpdates event) {
        SparkListenerDriverAccumUpdates sparkListenerDriverAccumUpdates = event;
        if (sparkListenerDriverAccumUpdates == null) {
            throw new MatchError((Object)sparkListenerDriverAccumUpdates);
        }
        long executionId = sparkListenerDriverAccumUpdates.executionId();
        Seq<Tuple2<Object, Object>> accumUpdates = sparkListenerDriverAccumUpdates.accumUpdates();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)executionId), accumUpdates);
        Tuple2 tuple22 = tuple2;
        long executionId2 = tuple22._1$mcJ$sp();
        Seq accumUpdates2 = (Seq)tuple22._2();
        Option$.MODULE$.apply((Object)this.liveExecutions().get(BoxesRunTime.boxToLong((long)executionId2))).foreach((Function1 & Serializable & scala.Serializable)exec -> {
            SQLAppStatusListener.$anonfun$onDriverAccumUpdates$1(this, accumUpdates2, exec);
            return BoxedUnit.UNIT;
        });
    }

    public void onOtherEvent(SparkListenerEvent event) {
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof SparkListenerSQLExecutionStart) {
            SparkListenerSQLExecutionStart sparkListenerSQLExecutionStart = (SparkListenerSQLExecutionStart)sparkListenerEvent;
            this.onExecutionStart(sparkListenerSQLExecutionStart);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerSQLExecutionEnd) {
            SparkListenerSQLExecutionEnd sparkListenerSQLExecutionEnd = (SparkListenerSQLExecutionEnd)sparkListenerEvent;
            this.onExecutionEnd(sparkListenerSQLExecutionEnd);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerDriverAccumUpdates) {
            SparkListenerDriverAccumUpdates sparkListenerDriverAccumUpdates = (SparkListenerDriverAccumUpdates)sparkListenerEvent;
            this.onDriverAccumUpdates(sparkListenerDriverAccumUpdates);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private LiveExecutionData getOrCreateExecution(long executionId) {
        return this.liveExecutions().computeIfAbsent(BoxesRunTime.boxToLong((long)executionId), new Function<Object, LiveExecutionData>(null, executionId){
            private final long executionId$1;

            public <V> Function<V, LiveExecutionData> compose(Function<? super V, ? extends Object> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<Object, V> andThen(Function<? super LiveExecutionData, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public LiveExecutionData apply(long key) {
                return new LiveExecutionData(this.executionId$1);
            }
            {
                this.executionId$1 = executionId$1;
            }
        });
    }

    private void update(LiveExecutionData exec, boolean force) {
        block1: {
            long now;
            block2: {
                block0: {
                    now = System.nanoTime();
                    if (exec.endEvents() < exec.jobs().size() + 1) break block0;
                    exec.write(this.kvstore, now, exec.write$default$3());
                    this.liveExecutions().remove(BoxesRunTime.boxToLong((long)exec.executionId()));
                    break block1;
                }
                if (!force) break block2;
                exec.write(this.kvstore, now, exec.write$default$3());
                break block1;
            }
            if (this.liveUpdatePeriodNs() < 0L || now - exec.lastWriteTime() <= this.liveUpdatePeriodNs()) break block1;
            exec.write(this.kvstore, now, exec.write$default$3());
        }
    }

    private boolean update$default$2() {
        return false;
    }

    private boolean isSQLStage(int stageId) {
        return ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.liveExecutions().values()).asScala()).exists((Function1 & Serializable & scala.Serializable)exec -> BoxesRunTime.boxToBoolean((boolean)SQLAppStatusListener.$anonfun$isSQLStage$1(stageId, exec)));
    }

    private void cleanupExecutions(long count) {
        long countToDelete = count - (long)BoxesRunTime.unboxToInt((Object)this.conf.get(StaticSQLConf$.MODULE$.UI_RETAINED_EXECUTIONS()));
        if (countToDelete <= 0L) {
            return;
        }
        KVStoreView view = this.kvstore.view(SQLExecutionUIData.class).index("completionTime").first((Object)BoxesRunTime.boxToLong((long)0L));
        Seq toDelete = KVUtils$.MODULE$.viewToSeq(view, (int)countToDelete, (Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)SQLAppStatusListener.$anonfun$cleanupExecutions$1(x$11)));
        toDelete.foreach((Function1 & Serializable & scala.Serializable)e -> {
            SQLAppStatusListener.$anonfun$cleanupExecutions$2(this, e);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$3(SQLAppStatusListener $this, long now$1, LiveExecutionData exec) {
        exec.metricsValues_$eq($this.aggregateMetrics(exec));
        exec.write($this.kvstore, now$1, exec.write$default$3());
    }

    public static final /* synthetic */ LiveStageMetrics $anonfun$onJobStart$2(SQLAppStatusListener $this, List accumIds$1, int id) {
        return $this.stageMetrics().put(BoxesRunTime.boxToInteger((int)id), new LiveStageMetrics(id, 0, (long[])accumIds$1.toArray(ClassTag$.MODULE$.Long()), new ConcurrentHashMap<Object, LiveTaskMetrics>()));
    }

    public static final /* synthetic */ void $anonfun$onStageSubmitted$1(SparkListenerStageSubmitted event$1, LiveStageMetrics metrics) {
        metrics.taskMetrics().clear();
        metrics.attemptId_$eq(event$1.stageInfo().attemptNumber());
    }

    public static final /* synthetic */ void $anonfun$onJobEnd$1(SQLAppStatusListener $this, SparkListenerJobEnd event$2, LiveExecutionData exec) {
        block0: {
            if (!exec.jobs().contains((Object)BoxesRunTime.boxToInteger((int)event$2.jobId()))) break block0;
            JobResult jobResult = event$2.jobResult();
            JobExecutionStatus jobExecutionStatus = JobSucceeded$.MODULE$.equals(jobResult) ? JobExecutionStatus.SUCCEEDED : JobExecutionStatus.FAILED;
            JobExecutionStatus result = jobExecutionStatus;
            exec.jobs_$eq((Map<Object, JobExecutionStatus>)exec.jobs().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)event$2.jobId())), (Object)result)));
            exec.endEvents_$eq(exec.endEvents() + 1);
            $this.update(exec, $this.update$default$2());
        }
    }

    public static final /* synthetic */ void $anonfun$onExecutorMetricsUpdate$1(SQLAppStatusListener $this, Tuple4 x0$1) {
        Tuple4 tuple4 = x0$1;
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        long taskId = BoxesRunTime.unboxToLong((Object)tuple4._1());
        int stageId = BoxesRunTime.unboxToInt((Object)tuple4._2());
        int attemptId = BoxesRunTime.unboxToInt((Object)tuple4._3());
        Seq accumUpdates = (Seq)tuple4._4();
        $this.updateStageMetrics(stageId, attemptId, taskId, (Seq<AccumulableInfo>)accumUpdates, false);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$aggregateMetrics$6(Seq metricIds$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long id = tuple2._1$mcJ$sp();
        boolean bl = metricIds$1.contains((Object)BoxesRunTime.boxToLong((long)id));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$updateStageMetrics$2(LiveStageMetrics metrics$1, AccumulableInfo acc) {
        return acc.update().isDefined() && new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(metrics$1.accumulatorIds())).contains((Object)BoxesRunTime.boxToLong((long)acc.id()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$updateStageMetrics$4(long[] ids$1, long[] values$1, Tuple2 x0$4) {
        long l;
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        AccumulableInfo acc = (AccumulableInfo)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        ids$1[idx] = acc.id();
        Object object = acc.update().get();
        if (object instanceof String) {
            String string = (String)object;
            l = new StringOps(Predef$.MODULE$.augmentString(string)).toLong();
        } else {
            long l2;
            if (!(object instanceof Long)) throw new IllegalArgumentException(new StringBuilder(12).append("Unexpected: ").append(object).toString());
            l = l2 = BoxesRunTime.unboxToLong((Object)object);
        }
        values$1[idx] = l;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final Seq toStoredNodes$1(Seq nodes) {
        return (Seq)nodes.map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            SparkPlanGraphNodeWrapper sparkPlanGraphNodeWrapper;
            SparkPlanGraphNode sparkPlanGraphNode = x0$5;
            if (sparkPlanGraphNode instanceof SparkPlanGraphCluster) {
                SparkPlanGraphCluster sparkPlanGraphCluster = (SparkPlanGraphCluster)sparkPlanGraphNode;
                SparkPlanGraphClusterWrapper storedCluster = new SparkPlanGraphClusterWrapper(sparkPlanGraphCluster.id(), sparkPlanGraphCluster.name(), sparkPlanGraphCluster.desc(), (Seq<SparkPlanGraphNodeWrapper>)SQLAppStatusListener.toStoredNodes$1(sparkPlanGraphCluster.nodes()), sparkPlanGraphCluster.metrics());
                sparkPlanGraphNodeWrapper = new SparkPlanGraphNodeWrapper(null, storedCluster);
            } else {
                sparkPlanGraphNodeWrapper = new SparkPlanGraphNodeWrapper(sparkPlanGraphNode, null);
            }
            return sparkPlanGraphNodeWrapper;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$onExecutionEnd$1(SQLAppStatusListener $this, long time$1, LiveExecutionData exec) {
        exec.metricsValues_$eq($this.aggregateMetrics(exec));
        exec.completionTime_$eq((Option<Date>)new Some((Object)new Date(time$1)));
        exec.endEvents_$eq(exec.endEvents() + 1);
        $this.update(exec, $this.update$default$2());
        Set activeStages = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter($this.liveExecutions().values()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)other -> {
            LiveExecutionData liveExecutionData = other;
            LiveExecutionData liveExecutionData2 = exec;
            return (liveExecutionData == null ? liveExecutionData2 != null : !((Object)((Object)liveExecutionData)).equals((Object)liveExecutionData2)) ? other.stages() : Nil$.MODULE$;
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter($this.stageMetrics().keySet()).asScala()).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$9 -> !activeStages.contains((Object)BoxesRunTime.boxToInteger((int)x$9)))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> $this.stageMetrics().remove(x$1));
    }

    public static final /* synthetic */ void $anonfun$onDriverAccumUpdates$1(SQLAppStatusListener $this, Seq accumUpdates$2, LiveExecutionData exec) {
        exec.driverAccumUpdates_$eq((Map<Object, Object>)exec.driverAccumUpdates().$plus$plus((GenTraversableOnce)accumUpdates$2));
        $this.update(exec, $this.update$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$isSQLStage$1(int stageId$1, LiveExecutionData exec) {
        return exec.stages().contains((Object)BoxesRunTime.boxToInteger((int)stageId$1));
    }

    public static final /* synthetic */ boolean $anonfun$cleanupExecutions$1(SQLExecutionUIData x$11) {
        return x$11.completionTime().isDefined();
    }

    public static final /* synthetic */ void $anonfun$cleanupExecutions$2(SQLAppStatusListener $this, SQLExecutionUIData e) {
        $this.kvstore.delete(e.getClass(), (Object)BoxesRunTime.boxToLong((long)e.executionId()));
        $this.kvstore.delete(SparkPlanGraphWrapper.class, (Object)BoxesRunTime.boxToLong((long)e.executionId()));
    }

    public SQLAppStatusListener(SparkConf conf, ElementTrackingStore kvstore, boolean live) {
        this.conf = conf;
        this.kvstore = kvstore;
        this.live = live;
        Logging.$init$((Logging)this);
        this.liveUpdatePeriodNs = live ? BoxesRunTime.unboxToLong((Object)conf.get(config$.MODULE$.LIVE_ENTITY_UPDATE_PERIOD())) : -1L;
        this.liveExecutions = new ConcurrentHashMap();
        this.stageMetrics = new ConcurrentHashMap();
        kvstore.addTrigger(SQLExecutionUIData.class, (long)BoxesRunTime.unboxToInt((Object)conf.get(StaticSQLConf$.MODULE$.UI_RETAINED_EXECUTIONS())), (Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)count -> this.cleanupExecutions(count));
        kvstore.onFlush((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if ($this.live) break block0;
                long now = System.nanoTime();
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.liveExecutions().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)exec -> {
                    SQLAppStatusListener.$anonfun$new$3(this, now, exec);
                    return BoxedUnit.UNIT;
                });
            }
        });
    }
}

