/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Optional;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.CurrentBatchTimestamp;
import org.apache.spark.sql.catalyst.expressions.CurrentBatchTimestamp$;
import org.apache.spark.sql.catalyst.expressions.CurrentDate;
import org.apache.spark.sql.catalyst.expressions.CurrentTimestamp;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.WriteToDataSourceV2;
import org.apache.spark.sql.execution.streaming.BaseStreamingSink;
import org.apache.spark.sql.execution.streaming.BaseStreamingSource;
import org.apache.spark.sql.execution.streaming.CommitMetadata;
import org.apache.spark.sql.execution.streaming.FakeDataSourceV2$;
import org.apache.spark.sql.execution.streaming.IncrementalExecution;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.execution.streaming.MemoryStreamDataSource$;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution$;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.OffsetSeq;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata$;
import org.apache.spark.sql.execution.streaming.OneTimeExecutor;
import org.apache.spark.sql.execution.streaming.OneTimeTrigger$;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamExecution$;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation;
import org.apache.spark.sql.execution.streaming.StreamingRelation;
import org.apache.spark.sql.execution.streaming.StreamingRelationV2;
import org.apache.spark.sql.execution.streaming.TERMINATED$;
import org.apache.spark.sql.execution.streaming.TriggerExecutor;
import org.apache.spark.sql.execution.streaming.WatermarkTracker;
import org.apache.spark.sql.execution.streaming.WatermarkTracker$;
import org.apache.spark.sql.execution.streaming.sources.MicroBatchWriter;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.MicroBatchReadSupport;
import org.apache.spark.sql.sources.v2.StreamWriteSupport;
import org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader;
import org.apache.spark.sql.sources.v2.writer.streaming.StreamWriter;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.ProcessingTime;
import org.apache.spark.sql.streaming.StreamingQueryStatus;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\rd\u0001B\u0001\u0003\u0001=\u00111#T5de>\u0014\u0015\r^2i\u000bb,7-\u001e;j_:T!a\u0001\u0003\u0002\u0013M$(/Z1nS:<'BA\u0003\u0007\u0003%)\u00070Z2vi&|gN\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0011\u0011CE\u0007\u0002\u0005%\u00111C\u0001\u0002\u0010'R\u0014X-Y7Fq\u0016\u001cW\u000f^5p]\"IQ\u0003\u0001B\u0001B\u0003%aCG\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003/ai\u0011AB\u0005\u00033\u0019\u0011Ab\u00159be.\u001cVm]:j_:L!!\u0006\n\t\u0013q\u0001!\u0011!Q\u0001\nuQ\u0013\u0001\u00028b[\u0016\u0004\"AH\u0014\u000f\u0005})\u0003C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u000f\u0003\u0019a$o\\8u})\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\u00051\u0001K]3eK\u001aL!\u0001K\u0015\u0003\rM#(/\u001b8h\u0015\t13%\u0003\u0002\u001d%!AA\u0006\u0001B\u0001B\u0003%Q$\u0001\bdQ\u0016\u001c7\u000e]8j]R\u0014vn\u001c;\t\u00119\u0002!\u0011!Q\u0001\n=\nA\"\u00198bYfTX\r\u001a)mC:\u0004\"\u0001M\u001c\u000e\u0003ER!AM\u001a\u0002\u000f1|w-[2bY*\u0011A'N\u0001\u0006a2\fgn\u001d\u0006\u0003m\u0019\t\u0001bY1uC2L8\u000f^\u0005\u0003qE\u00121\u0002T8hS\u000e\fG\u000e\u00157b]\"I!\b\u0001B\u0001B\u0003%1HP\u0001\u0005g&t7\u000e\u0005\u0002\u0012y%\u0011QH\u0001\u0002\u0012\u0005\u0006\u001cXm\u0015;sK\u0006l\u0017N\\4TS:\\\u0017B\u0001\u001e\u0013\u0011%\u0001\u0005A!A!\u0002\u0013\te)A\u0004ue&<w-\u001a:\u0011\u0005\t#U\"A\"\u000b\u0005\r1\u0011BA#D\u0005\u001d!&/[4hKJL!\u0001\u0011\n\t\u0013!\u0003!\u0011!Q\u0001\n%{\u0015\u0001\u0004;sS\u001e<WM]\"m_\u000e\\\u0007C\u0001&N\u001b\u0005Y%B\u0001'\t\u0003\u0011)H/\u001b7\n\u00059[%!B\"m_\u000e\\\u0017B\u0001%\u0013\u0011%\t\u0006A!A!\u0002\u0013\u0011V+\u0001\u0006pkR\u0004X\u000f^'pI\u0016\u0004\"AQ*\n\u0005Q\u001b%AC(viB,H/T8eK&\u0011\u0011K\u0005\u0005\t/\u0002\u0011\t\u0011)A\u00051\u0006aQ\r\u001f;sC>\u0003H/[8ogB!a$W\u000f\u001e\u0013\tQ\u0016FA\u0002NCBD\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!X\u0001\u0017I\u0016dW\r^3DQ\u0016\u001c7\u000e]8j]R|en\u0015;paB\u0011alX\u0007\u0002G%\u0011\u0001m\t\u0002\b\u0005>|G.Z1o\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0003\u0019a\u0014N\\5u}QYA-\u001a4hQ&T7\u000e\\7o!\t\t\u0002\u0001C\u0003\u0016C\u0002\u0007a\u0003C\u0003\u001dC\u0002\u0007Q\u0004C\u0003-C\u0002\u0007Q\u0004C\u0003/C\u0002\u0007q\u0006C\u0003;C\u0002\u00071\bC\u0003AC\u0002\u0007\u0011\tC\u0003IC\u0002\u0007\u0011\nC\u0003RC\u0002\u0007!\u000bC\u0003XC\u0002\u0007\u0001\fC\u0003]C\u0002\u0007Q\fC\u0004q\u0001\u0001\u0007I\u0011C9\u0002\u000fM|WO]2fgV\t!\u000fE\u0002tqnt!\u0001\u001e<\u000f\u0005\u0001*\u0018\"\u0001\u0013\n\u0005]\u001c\u0013a\u00029bG.\fw-Z\u0005\u0003sj\u00141aU3r\u0015\t98\u0005\u0005\u0002\u0012y&\u0011QP\u0001\u0002\u0014\u0005\u0006\u001cXm\u0015;sK\u0006l\u0017N\\4T_V\u00148-\u001a\u0005\t\u007f\u0002\u0001\r\u0011\"\u0005\u0002\u0002\u0005Y1o\\;sG\u0016\u001cx\fJ3r)\u0011\t\u0019!!\u0003\u0011\u0007y\u000b)!C\u0002\u0002\b\r\u0012A!\u00168ji\"A\u00111\u0002@\u0002\u0002\u0003\u0007!/A\u0002yIEBq!a\u0004\u0001A\u0003&!/\u0001\u0005t_V\u00148-Z:!Q\u0011\ti!a\u0005\u0011\u0007y\u000b)\"C\u0002\u0002\u0018\r\u0012\u0001B^8mCRLG.\u001a\u0005\n\u00037\u0001!\u0019!C\u0005\u0003;\tQC]3bI\u0016\u0014Hk\u001c#bi\u0006\u001cv.\u001e:dK6\u000b\u0007/\u0006\u0002\u0002 AA\u0011\u0011EA\u0016\u0003[\t\t%\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003\u001diW\u000f^1cY\u0016T1!!\u000b$\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00045\u0006\r\u0002\u0003BA\u0018\u0003{i!!!\r\u000b\u0007\r\t\u0019D\u0003\u0003\u00026\u0005]\u0012A\u0002:fC\u0012,'O\u0003\u0003\u0002:\u0005m\u0012A\u0001<3\u0015\t\u0001h!\u0003\u0003\u0002@\u0005E\"\u0001E'jGJ|')\u0019;dQJ+\u0017\rZ3s!\u0019q\u00161IA$1&\u0019\u0011QI\u0012\u0003\rQ+\b\u000f\\33!\u0011\tI%a\u0013\u000e\u0005\u0005]\u0012\u0002BA'\u0003o\u0011A\u0002R1uCN{WO]2f-JB\u0001\"!\u0015\u0001A\u0003%\u0011qD\u0001\u0017e\u0016\fG-\u001a:U_\u0012\u000bG/Y*pkJ\u001cW-T1qA!I\u0011Q\u000b\u0001C\u0002\u0013%\u0011qK\u0001\u0010iJLwmZ3s\u000bb,7-\u001e;peV\u0011\u0011\u0011\f\n\t\u00037\ny&!\u001a\u0002l\u00191\u0011Q\f\u0001\u0001\u00033\u0012A\u0002\u0010:fM&tW-\\3oiz\u00022AXA1\u0013\r\t\u0019g\t\u0002\b!J|G-^2u!\rq\u0016qM\u0005\u0004\u0003S\u001a#\u0001D*fe&\fG.\u001b>bE2,\u0007cA\t\u0002n%\u0019\u0011q\u000e\u0002\u0003\u001fQ\u0013\u0018nZ4fe\u0016CXmY;u_JD\u0001\"a\u001d\u0001A\u0003%\u0011\u0011L\u0001\u0011iJLwmZ3s\u000bb,7-\u001e;pe\u0002B1\"a\u001e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002z\u0005\u0001r/\u0019;fe6\f'o\u001b+sC\u000e\\WM]\u000b\u0003\u0003w\u00022!EA?\u0013\r\tyH\u0001\u0002\u0011/\u0006$XM]7be.$&/Y2lKJD1\"a!\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0006\u0006!r/\u0019;fe6\f'o\u001b+sC\u000e\\WM]0%KF$B!a\u0001\u0002\b\"Q\u00111BAA\u0003\u0003\u0005\r!a\u001f\t\u0017\u0005-\u0005\u00011A\u0001B\u0003&\u00111P\u0001\u0012o\u0006$XM]7be.$&/Y2lKJ\u0004\u0003BCAH\u0001!\u0015\r\u0011\"\u0011\u0002\u0012\u0006YAn\\4jG\u0006d\u0007\u000b\\1o+\u0005y\u0003\"CAK\u0001\u0001\u0007I\u0011BAL\u0003eI7oQ;se\u0016tGOQ1uG\"\u001cuN\\:ueV\u001cG/\u001a3\u0016\u0003uC\u0011\"a'\u0001\u0001\u0004%I!!(\u0002;%\u001c8)\u001e:sK:$()\u0019;dQ\u000e{gn\u001d;sk\u000e$X\rZ0%KF$B!a\u0001\u0002 \"I\u00111BAM\u0003\u0003\u0005\r!\u0018\u0005\b\u0003G\u0003\u0001\u0015)\u0003^\u0003iI7oQ;se\u0016tGOQ1uG\"\u001cuN\\:ueV\u001cG/\u001a3!\u0011\u001d\t9\u000b\u0001C!\u0003S\u000bAa\u001d;paR\u0011\u00111\u0001\u0005\b\u0003[\u0003A\u0011CAX\u0003I\u0011XO\\!di&4\u0018\r^3e'R\u0014X-Y7\u0015\t\u0005\r\u0011\u0011\u0017\u0005\b\u0003g\u000bY\u000b1\u0001\u0017\u0003U\u0019\b/\u0019:l'\u0016\u001c8/[8o\r>\u00148\u000b\u001e:fC6Dq!a.\u0001\t\u0013\tI,\u0001\u000bq_B,H.\u0019;f'R\f'\u000f^(gMN,Go\u001d\u000b\u0005\u0003\u0007\tY\fC\u0004\u0002>\u0006U\u0006\u0019\u0001\f\u00021M\u0004\u0018M]6TKN\u001c\u0018n\u001c8U_J+hNQ1uG\",7\u000fC\u0004\u0002B\u0002!I!a&\u0002%%\u001ch*Z<ECR\f\u0017I^1jY\u0006\u0014G.\u001a\u0005\b\u0003\u000b\u0004A\u0011BAd\u0003I\u0019wN\\:ueV\u001cGOT3yi\n\u000bGo\u00195\u0015\u0007u\u000bI\rC\u0004\u0002L\u0006\r\u0007\u0019A/\u0002)9|G)\u0019;b\u0005\u0006$8\r[3t\u000b:\f'\r\\3e\u0011\u001d\ty\r\u0001C\u0005\u0003#\f\u0001B];o\u0005\u0006$8\r\u001b\u000b\u0005\u0003\u0007\t\u0019\u000eC\u0004\u0002V\u00065\u0007\u0019\u0001\f\u0002-M\u0004\u0018M]6TKN\u001c\u0018n\u001c8U_J+hNQ1uG\"D\u0001\"!7\u0001\t\u00031\u00111\\\u0001\u0013o&$\b\u000e\u0015:pOJ,7o\u001d'pG.,G-\u0006\u0003\u0002^\u0006\rH\u0003BAp\u0003k\u0004B!!9\u0002d2\u0001A\u0001CAs\u0003/\u0014\r!a:\u0003\u0003Q\u000bB!!;\u0002pB\u0019a,a;\n\u0007\u000558EA\u0004O_RD\u0017N\\4\u0011\u0007y\u000b\t0C\u0002\u0002t\u000e\u00121!\u00118z\u0011%\t90a6\u0005\u0002\u0004\tI0A\u0001g!\u0015q\u00161`Ap\u0013\r\tip\t\u0002\ty\tLh.Y7f}!9!\u0011\u0001\u0001\u0005\n\t\r\u0011A\u0002;p\u0015\u00064\u0018\r\u0006\u0003\u0003\u0006\te\u0001C\u0002B\u0004\u0005\u001f\u0011\u0019\"\u0004\u0002\u0003\n)\u0019AJa\u0003\u000b\u0005\t5\u0011\u0001\u00026bm\u0006LAA!\u0005\u0003\n\tAq\n\u001d;j_:\fG\u000e\u0005\u0003\u00020\tU\u0011\u0002\u0002B\f\u0003c\u0011aa\u00144gg\u0016$\b\u0002\u0003B\u000e\u0003\u007f\u0004\rA!\b\u0002\u0017M\u001c\u0017\r\\1PaRLwN\u001c\t\u0006=\n}!1C\u0005\u0004\u0005C\u0019#AB(qi&|g\u000eC\u0007\u0003&\u0001\u0001\n1!A\u0001\n\u0013\u00119CG\u0001\u0013gV\u0004XM\u001d\u0013ta\u0006\u00148nU3tg&|g.F\u0001\u0017\u00115\u0011Y\u0003\u0001I\u0001\u0004\u0003\u0005I\u0011\u0002B\u0017\u001f\u0006\u00112/\u001e9fe\u0012\"(/[4hKJ\u001cEn\\2l+\u0005I\u0005\"\u0004B\u0019\u0001A\u0005\u0019\u0011!A\u0005\n\tMR+\u0001\ttkB,'\u000fJ8viB,H/T8eKV\t!\u000bC\u0007\u00038\u0001\u0001\n1!A\u0001\n\u0013\u0011IDP\u0001\u000bgV\u0004XM\u001d\u0013tS:\\W#A\u001e\b\u000f\tu\"\u0001#\u0001\u0003@\u0005\u0019R*[2s_\n\u000bGo\u00195Fq\u0016\u001cW\u000f^5p]B\u0019\u0011C!\u0011\u0007\r\u0005\u0011\u0001\u0012\u0001B\"'\u0011\u0011\tE!\u0012\u0011\u0007y\u00139%C\u0002\u0003J\r\u0012a!\u00118z%\u00164\u0007b\u00022\u0003B\u0011\u0005!Q\n\u000b\u0003\u0005\u007fA!B!\u0015\u0003B\t\u0007I\u0011\u0001B*\u00031\u0011\u0015\tV\"I?&#ulS#Z+\t\u0011)\u0006\u0005\u0003\u0003X\tuSB\u0001B-\u0015\u0011\u0011YFa\u0003\u0002\t1\fgnZ\u0005\u0004Q\te\u0003\"\u0003B1\u0005\u0003\u0002\u000b\u0011\u0002B+\u00035\u0011\u0015\tV\"I?&#ulS#ZA\u0001")
public class MicroBatchExecution
extends StreamExecution {
    private LogicalPlan logicalPlan;
    private final LogicalPlan analyzedPlan;
    private final scala.collection.immutable.Map<String, String> extraOptions;
    private volatile Seq<BaseStreamingSource> sources;
    private final scala.collection.mutable.Map<MicroBatchReader, Tuple2<DataSourceV2, scala.collection.immutable.Map<String, String>>> org$apache$spark$sql$execution$streaming$MicroBatchExecution$$readerToDataSourceMap;
    private final Product triggerExecutor;
    private WatermarkTracker watermarkTracker;
    private boolean isCurrentBatchConstructed;
    private volatile boolean bitmap$0;

    public static String BATCH_ID_KEY() {
        return MicroBatchExecution$.MODULE$.BATCH_ID_KEY();
    }

    public /* synthetic */ SparkSession org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession() {
        return super.sparkSession();
    }

    private /* synthetic */ Clock super$triggerClock() {
        return super.triggerClock();
    }

    private /* synthetic */ OutputMode super$outputMode() {
        return super.outputMode();
    }

    private /* synthetic */ BaseStreamingSink super$sink() {
        return super.sink();
    }

    @Override
    public Seq<BaseStreamingSource> sources() {
        return this.sources;
    }

    public void sources_$eq(Seq<BaseStreamingSource> x$1) {
        this.sources = x$1;
    }

    public scala.collection.mutable.Map<MicroBatchReader, Tuple2<DataSourceV2, scala.collection.immutable.Map<String, String>>> org$apache$spark$sql$execution$streaming$MicroBatchExecution$$readerToDataSourceMap() {
        return this.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$readerToDataSourceMap;
    }

    private Product triggerExecutor() {
        return this.triggerExecutor;
    }

    private WatermarkTracker watermarkTracker() {
        return this.watermarkTracker;
    }

    private void watermarkTracker_$eq(WatermarkTracker x$1) {
        this.watermarkTracker = x$1;
    }

    private LogicalPlan logicalPlan$lzycompute() {
        MicroBatchExecution microBatchExecution = this;
        synchronized (microBatchExecution) {
            if (!this.bitmap$0) {
                Predef$.MODULE$.assert(this.queryExecutionThread() == Thread.currentThread(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("logicalPlan must be initialized in QueryExecutionThread ").append(new StringBuilder(27).append("but the current thread was ").append(Thread.currentThread()).toString()).toString());
                LongRef nextSourceId = LongRef.create((long)0L);
                scala.collection.mutable.Map toExecutionRelationMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                scala.collection.mutable.Map v2ToExecutionRelationMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                String[] disabledSources = super.sparkSession().sqlContext().conf().disabledV2StreamingMicroBatchReaders().split(",");
                LogicalPlan _logicalPlan = (LogicalPlan)this.analyzedPlan.transform((PartialFunction)new scala.Serializable(this, nextSourceId, toExecutionRelationMap, v2ToExecutionRelationMap, disabledSources){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MicroBatchExecution $outer;
                    private final LongRef nextSourceId$1;
                    private final scala.collection.mutable.Map toExecutionRelationMap$1;
                    private final scala.collection.mutable.Map v2ToExecutionRelationMap$1;
                    private final String[] disabledSources$1;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        boolean bl = false;
                        StreamingRelationV2 streamingRelationV2 = null;
                        A1 A1 = x1;
                        if (A1 instanceof StreamingRelation) {
                            StreamingRelation streamingRelation = (StreamingRelation)A1;
                            DataSource dataSourceV1 = streamingRelation.dataSource();
                            String sourceName = streamingRelation.sourceName();
                            Seq<Attribute> output = streamingRelation.output();
                            object = this.toExecutionRelationMap$1.getOrElseUpdate((Object)((Object)streamingRelation), (Function0 & Serializable & scala.Serializable)() -> {
                                String metadataPath = new StringBuilder(9).append($this.$outer.resolvedCheckpointRoot()).append("/sources/").append($this.nextSourceId$1.elem).toString();
                                Source source = dataSourceV1.createSource(metadataPath);
                                ++$this.nextSourceId$1.elem;
                                $this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Using Source [").append(source).append("] from DataSourceV1 named '").append(sourceName).append("' [").append(dataSourceV1).append("]").toString());
                                return new StreamingExecutionRelation(source, output, $this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession());
                            });
                            return (B1)object;
                        }
                        if (A1 instanceof StreamingRelationV2) {
                            bl = true;
                            streamingRelationV2 = (StreamingRelationV2)A1;
                            DataSourceV2 dataSourceV2 = streamingRelationV2.dataSource();
                            String sourceName = streamingRelationV2.sourceName();
                            scala.collection.immutable.Map<String, String> options = streamingRelationV2.extraOptions();
                            Seq<Attribute> output = streamingRelationV2.output();
                            if (dataSourceV2 instanceof MicroBatchReadSupport) {
                                MicroBatchReadSupport microBatchReadSupport = (MicroBatchReadSupport)dataSourceV2;
                                if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.disabledSources$1)).contains((Object)microBatchReadSupport.getClass().getCanonicalName())) {
                                    object = this.v2ToExecutionRelationMap$1.getOrElseUpdate((Object)((Object)streamingRelationV2), (Function0 & Serializable & scala.Serializable)() -> {
                                        String metadataPath = new StringBuilder(9).append($this.$outer.resolvedCheckpointRoot()).append("/sources/").append($this.nextSourceId$1.elem).toString();
                                        MicroBatchReader reader = microBatchReadSupport.createMicroBatchReader(Optional.empty(), metadataPath, new DataSourceOptions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)options).asJava()));
                                        ++$this.nextSourceId$1.elem;
                                        $this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$readerToDataSourceMap().update((Object)reader, (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)microBatchReadSupport), (Object)options));
                                        $this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Using MicroBatchReader [").append(reader).append("] from ").append(new StringBuilder(24).append("DataSourceV2 named '").append(sourceName).append("' [").append(microBatchReadSupport).append("]").toString()).toString());
                                        return new StreamingExecutionRelation(reader, output, $this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession());
                                    });
                                    return (B1)object;
                                }
                            }
                        }
                        if (bl) {
                            DataSourceV2 dataSourceV2 = streamingRelationV2.dataSource();
                            String sourceName = streamingRelationV2.sourceName();
                            Seq<Attribute> output = streamingRelationV2.output();
                            Option<StreamingRelation> v1Relation = streamingRelationV2.v1Relation();
                            object = this.v2ToExecutionRelationMap$1.getOrElseUpdate((Object)((Object)streamingRelationV2), (Function0 & Serializable & scala.Serializable)() -> {
                                String metadataPath = new StringBuilder(9).append($this.$outer.resolvedCheckpointRoot()).append("/sources/").append($this.nextSourceId$1.elem).toString();
                                if (v1Relation.isEmpty()) {
                                    throw new UnsupportedOperationException(new StringBuilder(52).append("Data source ").append(sourceName).append(" does not support microbatch processing.").toString());
                                }
                                Source source = ((StreamingRelation)((Object)((Object)v1Relation.get()))).dataSource().createSource(metadataPath);
                                ++$this.nextSourceId$1.elem;
                                $this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Using Source [").append(source).append("] from DataSourceV2 named '").append(sourceName).append("' [").append(dataSourceV2).append("]").toString());
                                return new StreamingExecutionRelation(source, output, $this.$outer.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession());
                            });
                            return (B1)object;
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(LogicalPlan x1) {
                        boolean bl = false;
                        StreamingRelationV2 streamingRelationV2 = null;
                        LogicalPlan logicalPlan2 = x1;
                        if (logicalPlan2 instanceof StreamingRelation) {
                            return true;
                        }
                        if (logicalPlan2 instanceof StreamingRelationV2) {
                            bl = true;
                            streamingRelationV2 = (StreamingRelationV2)logicalPlan2;
                            DataSourceV2 dataSourceV2 = streamingRelationV2.dataSource();
                            if (dataSourceV2 instanceof MicroBatchReadSupport) {
                                MicroBatchReadSupport microBatchReadSupport = (MicroBatchReadSupport)dataSourceV2;
                                if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.disabledSources$1)).contains((Object)microBatchReadSupport.getClass().getCanonicalName())) {
                                    return true;
                                }
                            }
                        }
                        if (!bl) return false;
                        return true;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.nextSourceId$1 = nextSourceId$1;
                        this.toExecutionRelationMap$1 = toExecutionRelationMap$1;
                        this.v2ToExecutionRelationMap$1 = v2ToExecutionRelationMap$1;
                        this.disabledSources$1 = disabledSources$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 org.apache.spark.sql.execution.datasources.DataSource java.lang.String scala.collection.Seq ), $anonfun$applyOrElse$3(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 java.lang.String scala.collection.immutable.Map scala.collection.Seq org.apache.spark.sql.sources.v2.MicroBatchReadSupport ), $anonfun$applyOrElse$5(org.apache.spark.sql.execution.streaming.MicroBatchExecution$$anonfun$1 org.apache.spark.sql.sources.v2.DataSourceV2 java.lang.String scala.collection.Seq scala.Option ), $anonfun$applyOrElse$2(org.apache.spark.sql.execution.datasources.DataSource java.lang.String org.apache.spark.sql.execution.streaming.Source ), $anonfun$applyOrElse$4(java.lang.String org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader org.apache.spark.sql.sources.v2.MicroBatchReadSupport ), $anonfun$applyOrElse$6(org.apache.spark.sql.sources.v2.DataSourceV2 java.lang.String org.apache.spark.sql.execution.streaming.Source )}, serializedLambda);
                    }
                });
                this.sources_$eq((Seq<BaseStreamingSource>)_logicalPlan.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 instanceof StreamingExecutionRelation) {
                            StreamingExecutionRelation streamingExecutionRelation = (StreamingExecutionRelation)A1;
                            object = streamingExecutionRelation.source();
                        } else {
                            object = function1.apply(x2);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x2) {
                        LogicalPlan logicalPlan2 = x2;
                        boolean bl = logicalPlan2 instanceof StreamingExecutionRelation;
                        return bl;
                    }
                }));
                this.uniqueSources_$eq((Seq<BaseStreamingSource>)((Seq)this.sources().distinct()));
                this.logicalPlan = _logicalPlan;
                this.bitmap$0 = true;
            }
        }
        return this.logicalPlan;
    }

    @Override
    public LogicalPlan logicalPlan() {
        return !this.bitmap$0 ? this.logicalPlan$lzycompute() : this.logicalPlan;
    }

    private boolean isCurrentBatchConstructed() {
        return this.isCurrentBatchConstructed;
    }

    private void isCurrentBatchConstructed_$eq(boolean x$1) {
        this.isCurrentBatchConstructed = x$1;
    }

    @Override
    public void stop() {
        this.state().set(TERMINATED$.MODULE$);
        if (this.queryExecutionThread().isAlive()) {
            super.sparkSession().sparkContext().cancelJobGroup(this.runId().toString());
            this.queryExecutionThread().interrupt();
            this.queryExecutionThread().join();
            super.sparkSession().sparkContext().cancelJobGroup(this.runId().toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Query ").append(this.prettyIdString()).append(" was stopped").toString());
    }

    @Override
    public void runActivatedStream(SparkSession sparkSessionForStream) {
        boolean noDataBatchesEnabled = sparkSessionForStream.sessionState().conf().streamingNoDataMicroBatchesEnabled();
        ((TriggerExecutor)this.triggerExecutor()).execute((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            if (this.isActive()) {
                BooleanRef currentBatchHasNewData = BooleanRef.create((boolean)false);
                this.startTrigger();
                this.reportTimeTaken("triggerExecution", (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    if (this.currentBatchId() < 0L) {
                        this.populateStartOffsets(sparkSessionForStream);
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Stream started from ").append(this.committedOffsets()).toString());
                    }
                    this.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$super$sparkSession().sparkContext().setJobDescription(this.getBatchDescriptionString());
                    if (!this.isCurrentBatchConstructed()) {
                        this.isCurrentBatchConstructed_$eq(this.constructNextBatch(noDataBatchesEnabled));
                    }
                    this.recordTriggerOffsets(this.committedOffsets(), this.availableOffsets());
                    currentBatchHasNewData$1.elem = this.isNewDataAvailable();
                    StreamingQueryStatus qual$1 = this.currentStatus();
                    boolean x$6 = this.isNewDataAvailable();
                    String x$7 = qual$1.copy$default$1();
                    boolean x$8 = qual$1.copy$default$3();
                    this.currentStatus_$eq(qual$1.copy(x$7, x$6, x$8));
                    if (this.isCurrentBatchConstructed()) {
                        if (currentBatchHasNewData$1.elem) {
                            this.updateStatusMessage("Processing new data");
                        } else {
                            this.updateStatusMessage("No new data but cleaning up state");
                        }
                        this.runBatch(sparkSessionForStream);
                    } else {
                        this.updateStatusMessage("Waiting for data to arrive");
                    }
                });
                this.finishTrigger(currentBatchHasNewData.elem);
                this.withProgressLocked((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.awaitProgressLockCondition().signalAll());
                if (this.isCurrentBatchConstructed()) {
                    this.currentBatchId_$eq(this.currentBatchId() + 1L);
                    this.isCurrentBatchConstructed_$eq(false);
                } else {
                    Thread.sleep(this.pollingDelayMs());
                }
            }
            this.updateStatusMessage("Waiting for next trigger");
            return this.isActive();
        });
    }

    private void populateStartOffsets(SparkSession sparkSessionToRunBatches) {
        Some some;
        Tuple2 tuple2;
        Option option = this.offsetLog().getLatest();
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Some some2;
            Tuple2 tuple22;
            long latestBatchId = tuple2._1$mcJ$sp();
            OffsetSeq nextOffsets = (OffsetSeq)tuple2._2();
            this.currentBatchId_$eq(latestBatchId);
            this.isCurrentBatchConstructed_$eq(true);
            this.availableOffsets_$eq(nextOffsets.toStreamProgress(this.sources()));
            if (latestBatchId != 0L) {
                OffsetSeq secondLatestBatchId = (OffsetSeq)this.offsetLog().get(latestBatchId - 1L).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(20).append("batch ").append(latestBatchId - 1L).append(" doesn't exist").toString());
                });
                this.committedOffsets_$eq(secondLatestBatchId.toStreamProgress(this.sources()));
            }
            nextOffsets.metadata().foreach((Function1 & Serializable & scala.Serializable)metadata -> {
                MicroBatchExecution.$anonfun$populateStartOffsets$2(this, sparkSessionToRunBatches, metadata);
                return BoxedUnit.UNIT;
            });
            Option option2 = this.commitLog().getLatest();
            if (option2 instanceof Some && (tuple22 = (Tuple2)(some2 = (Some)option2).value()) != null) {
                BoxedUnit boxedUnit;
                long latestCommittedBatchId = tuple22._1$mcJ$sp();
                CommitMetadata commitMetadata = (CommitMetadata)tuple22._2();
                if (latestBatchId == latestCommittedBatchId) {
                    this.availableOffsets().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        void var2_10;
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            BaseStreamingSource source = (BaseStreamingSource)tuple2._1();
                            Offset end = (Offset)tuple2._2();
                            if (source instanceof Source) {
                                Source source2 = (Source)source;
                                if (end != null) {
                                    Offset offset = end;
                                    Option<Offset> start = this.committedOffsets().get(source2);
                                    Dataset<Row> dataset = source2.getBatch(start, offset);
                                    return var2_10;
                                }
                            }
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return var2_10;
                    });
                    this.currentBatchId_$eq(latestCommittedBatchId + 1L);
                    this.isCurrentBatchConstructed_$eq(false);
                    this.committedOffsets_$eq(this.committedOffsets().$plus$plus((GenTraversableOnce<Tuple2<BaseStreamingSource, Offset>>)this.availableOffsets()));
                    this.watermarkTracker().setWatermark(package$.MODULE$.max(this.watermarkTracker().currentWatermark(), commitMetadata.nextBatchWatermarkMs()));
                    boxedUnit = BoxedUnit.UNIT;
                } else if (latestCommittedBatchId < latestBatchId - 1L) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Batch completion log latest batch id is ").append(new StringBuilder(24).append(latestCommittedBatchId).append(", which is not trailing ").toString()).append(new StringBuilder(15).append("batchid ").append(latestBatchId).append(" by one").toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (None$.MODULE$.equals(option2)) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "no commit log present");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option2);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Resuming at batch ").append(this.currentBatchId()).append(" with committed offsets ").append(new StringBuilder(23).append(this.committedOffsets()).append(" and available offsets ").append(this.availableOffsets()).toString()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting new streaming query.");
            this.currentBatchId_$eq(0L);
            this.watermarkTracker_$eq(WatermarkTracker$.MODULE$.apply(sparkSessionToRunBatches.conf()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    private boolean isNewDataAvailable() {
        return this.availableOffsets().exists((Function1<Tuple2<BaseStreamingSource, Offset>, Object>)(Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$isNewDataAvailable$1(this, x0$2)));
    }

    private boolean constructNextBatch(boolean noDataBatchesEnabled) {
        boolean bl;
        Object object = new Object();
        try {
            bl = BoxesRunTime.unboxToBoolean(this.withProgressLocked((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                if (this.isCurrentBatchConstructed()) {
                    throw new NonLocalReturnControl.mcZ.sp(object, true);
                }
                scala.collection.immutable.Map latestOffsets = ((TraversableOnce)this.uniqueSources().map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Tuple2 tuple2;
                    BaseStreamingSource baseStreamingSource = x0$3;
                    if (baseStreamingSource instanceof Source) {
                        Source source = (Source)baseStreamingSource;
                        this.updateStatusMessage(new StringBuilder(21).append("Getting offsets from ").append(source).toString());
                        tuple2 = (Tuple2)this.reportTimeTaken("getOffset", (Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)source, source.getOffset()));
                    } else if (baseStreamingSource instanceof MicroBatchReader) {
                        MicroBatchReader microBatchReader = (MicroBatchReader)baseStreamingSource;
                        this.updateStatusMessage(new StringBuilder(21).append("Getting offsets from ").append(microBatchReader).toString());
                        this.reportTimeTaken("setOffsetRange", (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> microBatchReader.setOffsetRange(this.toJava((Option<org.apache.spark.sql.sources.v2.reader.streaming.Offset>)this.availableOffsets().get(microBatchReader).map((Function1 & Serializable & scala.Serializable)off -> microBatchReader.deserializeOffset(off.json()))), Optional.empty()));
                        org.apache.spark.sql.sources.v2.reader.streaming.Offset currentOffset = (org.apache.spark.sql.sources.v2.reader.streaming.Offset)this.reportTimeTaken("getEndOffset", (Function0 & Serializable & scala.Serializable)() -> microBatchReader.getEndOffset());
                        tuple2 = new Tuple2((Object)microBatchReader, (Object)Option$.MODULE$.apply((Object)currentOffset));
                    } else {
                        throw new MatchError((Object)baseStreamingSource);
                    }
                    return tuple2;
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                this.availableOffsets_$eq(this.availableOffsets().$plus$plus((GenTraversableOnce<Tuple2<BaseStreamingSource, Offset>>)((MapLike)latestOffsets.filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$constructNextBatch$7(x0$4)))).mapValues((Function1 & Serializable & scala.Serializable)x$1 -> (Offset)x$1.get())));
                OffsetSeqMetadata qual$2 = this.offsetSeqMetadata();
                long x$9 = this.watermarkTracker().currentWatermark();
                long x$10 = this.super$triggerClock().getTimeMillis();
                scala.collection.immutable.Map<String, String> x$11 = qual$2.copy$default$3();
                this.offsetSeqMetadata_$eq(qual$2.copy(x$9, x$10, x$11));
                boolean lastExecutionRequiresAnotherBatch = noDataBatchesEnabled && Option$.MODULE$.apply((Object)this.lastExecution()).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.shouldRunAnotherBatch(this.offsetSeqMetadata())));
                boolean shouldConstructNextBatch = this.isNewDataAvailable() || lastExecutionRequiresAnotherBatch;
                this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("noDataBatchesEnabled = ").append(noDataBatchesEnabled).append(", ").append(new StringBuilder(38).append("lastExecutionRequiresAnotherBatch = ").append(lastExecutionRequiresAnotherBatch).append(", ").toString()).append(new StringBuilder(23).append("isNewDataAvailable = ").append(this.isNewDataAvailable()).append(", ").toString()).append(new StringBuilder(27).append("shouldConstructNextBatch = ").append(shouldConstructNextBatch).toString()).toString());
                if (shouldConstructNextBatch) {
                    this.updateStatusMessage("Writing offsets to log");
                    this.reportTimeTaken("walCommit", (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        block3: {
                            Predef$.MODULE$.assert(this.offsetLog().add(this.currentBatchId(), this.availableOffsets().toOffsetSeq(this.sources(), this.offsetSeqMetadata())), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Concurrent update to the log. Multiple streaming jobs detected for ").append(this.currentBatchId()).toString());
                            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Committed offsets for batch ").append(this.currentBatchId()).append(". ").append(new StringBuilder(9).append("Metadata ").append(this.offsetSeqMetadata().toString()).toString()).toString());
                            if (this.currentBatchId() != 0L) {
                                Option prevBatchOff = this.offsetLog().get(this.currentBatchId() - 1L);
                                if (prevBatchOff.isDefined()) {
                                    ((OffsetSeq)prevBatchOff.get()).toStreamProgress(this.sources()).foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                                        MicroBatchExecution.$anonfun$constructNextBatch$14(x0$5);
                                        return BoxedUnit.UNIT;
                                    });
                                } else {
                                    throw new IllegalStateException(new StringBuilder(20).append("batch ").append(this.currentBatchId() - 1L).append(" doesn't exist").toString());
                                }
                            }
                            if ((long)this.minLogEntriesToMaintain() >= this.currentBatchId()) break block3;
                            this.offsetLog().purge(this.currentBatchId() - (long)this.minLogEntriesToMaintain());
                            this.commitLog().purge(this.currentBatchId() - (long)this.minLogEntriesToMaintain());
                        }
                    });
                    this.noNewData_$eq(false);
                } else {
                    this.noNewData_$eq(true);
                    this.awaitProgressLockCondition().signalAll();
                }
                return shouldConstructNextBatch;
            }));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    private void runBatch(SparkSession sparkSessionToRunBatch) {
        LogicalPlan logicalPlan2;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Running batch ").append(this.currentBatchId()).toString());
        this.newData_$eq((scala.collection.immutable.Map<BaseStreamingSource, LogicalPlan>)((scala.collection.immutable.Map)this.reportTimeTaken("getBatch", (Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Map)this.availableOffsets().flatMap((Function1 & Serializable & scala.Serializable)x0$6 -> {
            org.apache.spark.sql.sources.v2.reader.streaming.Offset offset;
            Tuple2 tuple2 = x0$6;
            if (tuple2 != null) {
                BaseStreamingSource source = (BaseStreamingSource)tuple2._1();
                Offset available = (Offset)tuple2._2();
                if (source instanceof Source) {
                    Source source2 = (Source)source;
                    if (BoxesRunTime.unboxToBoolean((Object)this.committedOffsets().get(source2).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$runBatch$4(available, x$3))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true))) {
                        Option<Offset> current = this.committedOffsets().get(source2);
                        Dataset<Row> batch = source2.getBatch(current, available);
                        Predef$.MODULE$.assert(batch.isStreaming(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("DataFrame returned by getBatch from ").append(source2).append(" did not have isStreaming=true\n").append(String.valueOf(batch.queryExecution().logical())).toString());
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Retrieving data from ").append(source2).append(": ").append(current).append(" -> ").append(available).toString());
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source2), (Object)batch.logicalPlan())));
                    }
                }
            }
            if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            BaseStreamingSource reader = (BaseStreamingSource)tuple2._1();
            Offset available = (Offset)tuple2._2();
            if (!(reader instanceof MicroBatchReader)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            MicroBatchReader microBatchReader = (MicroBatchReader)reader;
            if (!BoxesRunTime.unboxToBoolean((Object)this.committedOffsets().get(microBatchReader).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$runBatch$8(available, x$4))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true))) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            Option current = this.committedOffsets().get(microBatchReader).map((Function1 & Serializable & scala.Serializable)off -> microBatchReader.deserializeOffset(off.json()));
            Offset offset2 = available;
            if (offset2 instanceof SerializedOffset) {
                SerializedOffset serializedOffset = (SerializedOffset)offset2;
                offset = microBatchReader.deserializeOffset(serializedOffset.json());
            } else {
                org.apache.spark.sql.sources.v2.reader.streaming.Offset offset3;
                if (!(offset2 instanceof org.apache.spark.sql.sources.v2.reader.streaming.Offset)) throw new MatchError((Object)offset2);
                offset = offset3 = (org.apache.spark.sql.sources.v2.reader.streaming.Offset)offset2;
            }
            org.apache.spark.sql.sources.v2.reader.streaming.Offset availableV2 = offset;
            microBatchReader.setOffsetRange(this.toJava((Option<org.apache.spark.sql.sources.v2.reader.streaming.Offset>)current), Optional.of(availableV2));
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Retrieving data from ").append(microBatchReader).append(": ").append(current).append(" -> ").append(availableV2).toString());
            MicroBatchReader microBatchReader2 = microBatchReader;
            Tuple2 tuple22 = microBatchReader2 instanceof MemoryStream ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MemoryStreamDataSource$.MODULE$), (Object)Predef$.MODULE$.Map().empty()) : (Tuple2)this.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$readerToDataSourceMap().getOrElse((Object)microBatchReader, (Function0 & Serializable & scala.Serializable)() -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)FakeDataSourceV2$.MODULE$), (Object)Predef$.MODULE$.Map().empty()));
            Tuple2 tuple23 = tuple22;
            if (tuple23 == null) throw new MatchError((Object)tuple23);
            DataSourceV2 source = (DataSourceV2)tuple23._1();
            scala.collection.immutable.Map options = (scala.collection.immutable.Map)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)source, (Object)options);
            Tuple2 tuple25 = tuple24;
            DataSourceV2 source3 = (DataSourceV2)tuple25._1();
            scala.collection.immutable.Map options2 = (scala.collection.immutable.Map)tuple25._2();
            return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)microBatchReader), (Object)new StreamingDataSourceV2Relation((Seq<AttributeReference>)microBatchReader.readSchema().toAttributes(), source3, (scala.collection.immutable.Map<String, String>)options2, microBatchReader))));
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()))));
        LogicalPlan newBatchesPlan = (LogicalPlan)this.logicalPlan().transform((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MicroBatchExecution $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof StreamingExecutionRelation) {
                    StreamingExecutionRelation streamingExecutionRelation = (StreamingExecutionRelation)A1;
                    BaseStreamingSource source = streamingExecutionRelation.source();
                    Seq<Attribute> output = streamingExecutionRelation.output();
                    object = this.$outer.newData().get((Object)source).map((Function1 & Serializable & scala.Serializable)dataPlan -> {
                        Predef$.MODULE$.assert(output.size() == dataPlan.output().size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Invalid batch: ").append(Utils$.MODULE$.truncatedString(output, ",")).append(" != ").append(String.valueOf(Utils$.MODULE$.truncatedString(dataPlan.output(), ","))).toString());
                        Seq aliases = (Seq)((TraversableLike)output.zip((GenIterable)dataPlan.output(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$7 -> {
                            Attribute from;
                            Tuple2 tuple2 = x0$7;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Attribute to = (Attribute)tuple2._1();
                            Attribute x$12 = from = (Attribute)tuple2._2();
                            String x$13 = to.name();
                            ExprId x$14 = to.exprId();
                            Some x$15 = new Some((Object)from.metadata());
                            Seq x$16 = Alias$.MODULE$.apply$default$4((Expression)x$12, x$13);
                            Alias alias = new Alias((Expression)x$12, x$13, x$14, x$16, (Option)x$15);
                            return alias;
                        }, Seq$.MODULE$.canBuildFrom());
                        return new Project(aliases, dataPlan);
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        Seq x$17 = output;
                        boolean x$18 = true;
                        Seq x$19 = LocalRelation$.MODULE$.apply$default$2();
                        return new LocalRelation(x$17, x$19, x$18);
                    });
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x3) {
                LogicalPlan logicalPlan2 = x3;
                boolean bl = logicalPlan2 instanceof StreamingExecutionRelation;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$7(scala.collection.Seq org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$10(scala.collection.Seq ), $anonfun$applyOrElse$8(scala.collection.Seq org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$9(scala.Tuple2 )}, serializedLambda);
            }
        });
        LogicalPlan newAttributePlan = newBatchesPlan.transformAllExpressions((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MicroBatchExecution $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x4;
                if (A1 instanceof CurrentTimestamp) {
                    CurrentTimestamp currentTimestamp = (CurrentTimestamp)A1;
                    object = new CurrentBatchTimestamp(this.$outer.offsetSeqMetadata().batchTimestampMs(), currentTimestamp.dataType(), CurrentBatchTimestamp$.MODULE$.apply$default$3());
                } else if (A1 instanceof CurrentDate) {
                    CurrentDate currentDate = (CurrentDate)A1;
                    object = new CurrentBatchTimestamp(this.$outer.offsetSeqMetadata().batchTimestampMs(), currentDate.dataType(), currentDate.timeZoneId());
                } else {
                    object = function1.apply(x4);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x4) {
                Expression expression = x4;
                boolean bl = expression instanceof CurrentTimestamp ? true : expression instanceof CurrentDate;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        BaseStreamingSink baseStreamingSink = super.sink();
        if (baseStreamingSink instanceof Sink) {
            logicalPlan2 = newAttributePlan;
        } else if (baseStreamingSink instanceof StreamWriteSupport) {
            StreamWriteSupport streamWriteSupport = (StreamWriteSupport)baseStreamingSink;
            StreamWriter writer = streamWriteSupport.createStreamWriter(String.valueOf(this.runId()), newAttributePlan.schema(), super.outputMode(), new DataSourceOptions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.extraOptions).asJava()));
            logicalPlan2 = new WriteToDataSourceV2(new MicroBatchWriter(this.currentBatchId(), writer), newAttributePlan);
        } else {
            throw new IllegalArgumentException(new StringBuilder(22).append("unknown sink type for ").append(super.sink()).toString());
        }
        LogicalPlan triggerLogicalPlan = logicalPlan2;
        sparkSessionToRunBatch.sparkContext().setLocalProperty(MicroBatchExecution$.MODULE$.BATCH_ID_KEY(), ((Object)BoxesRunTime.boxToLong((long)this.currentBatchId())).toString());
        sparkSessionToRunBatch.sparkContext().setLocalProperty(StreamExecution$.MODULE$.IS_CONTINUOUS_PROCESSING(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        this.reportTimeTaken("queryPlanning", (Function0 & Serializable & scala.Serializable)() -> {
            this.lastExecution_$eq(new IncrementalExecution(sparkSessionToRunBatch, triggerLogicalPlan, this.super$outputMode(), this.checkpointFile("state"), this.runId(), this.currentBatchId(), this.offsetSeqMetadata()));
            return this.lastExecution().executedPlan();
        });
        Dataset nextBatch = new Dataset(sparkSessionToRunBatch, this.lastExecution(), RowEncoder$.MODULE$.apply(this.lastExecution().analyzed().schema()));
        this.reportTimeTaken("addBatch", (Function0 & Serializable & scala.Serializable)() -> SQLExecution$.MODULE$.withNewExecutionId(sparkSessionToRunBatch, this.lastExecution(), (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            BaseStreamingSink baseStreamingSink = this.super$sink();
            if (baseStreamingSink instanceof Sink) {
                Sink sink = (Sink)baseStreamingSink;
                sink.addBatch(this.currentBatchId(), nextBatch);
                object = BoxedUnit.UNIT;
            } else if (baseStreamingSink instanceof StreamWriteSupport) {
                object = nextBatch.collect();
            } else {
                throw new MatchError((Object)baseStreamingSink);
            }
            return object;
        }));
        this.withProgressLocked((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.watermarkTracker().updateWatermark(this.lastExecution().executedPlan());
            this.commitLog().add(this.currentBatchId(), new CommitMetadata(this.watermarkTracker().currentWatermark()));
            this.committedOffsets_$eq(this.committedOffsets().$plus$plus((GenTraversableOnce<Tuple2<BaseStreamingSource, Offset>>)this.availableOffsets()));
        });
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Completed batch ").append(this.currentBatchId()).toString());
    }

    public <T> T withProgressLocked(Function0<T> f) {
        Object object;
        this.awaitProgressLock().lock();
        try {
            object = f.apply();
        }
        finally {
            this.awaitProgressLock().unlock();
        }
        return (T)object;
    }

    private Optional<org.apache.spark.sql.sources.v2.reader.streaming.Offset> toJava(Option<org.apache.spark.sql.sources.v2.reader.streaming.Offset> scalaOption) {
        return Optional.ofNullable(scalaOption.orNull(Predef$.MODULE$.$conforms()));
    }

    public static final /* synthetic */ void $anonfun$populateStartOffsets$2(MicroBatchExecution $this, SparkSession sparkSessionToRunBatches$1, OffsetSeqMetadata metadata) {
        OffsetSeqMetadata$.MODULE$.setSessionConf(metadata, sparkSessionToRunBatches$1.conf());
        $this.offsetSeqMetadata_$eq(OffsetSeqMetadata$.MODULE$.apply(metadata.batchWatermarkMs(), metadata.batchTimestampMs(), sparkSessionToRunBatches$1.conf()));
        $this.watermarkTracker_$eq(WatermarkTracker$.MODULE$.apply(sparkSessionToRunBatches$1.conf()));
        $this.watermarkTracker().setWatermark(metadata.batchWatermarkMs());
    }

    public static final /* synthetic */ boolean $anonfun$isNewDataAvailable$2(Offset available$1, Offset committed) {
        Offset offset = committed;
        Offset offset2 = available$1;
        return offset == null ? offset2 != null : !((Object)offset).equals(offset2);
    }

    public static final /* synthetic */ boolean $anonfun$isNewDataAvailable$1(MicroBatchExecution $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BaseStreamingSource source = (BaseStreamingSource)tuple2._1();
        Offset available = (Offset)tuple2._2();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)$this.committedOffsets().get(source).map((Function1 & Serializable & scala.Serializable)committed -> BoxesRunTime.boxToBoolean((boolean)MicroBatchExecution.$anonfun$isNewDataAvailable$2(available, committed))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$constructNextBatch$7(Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option o = (Option)tuple2._2();
        boolean bl = o.nonEmpty();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$constructNextBatch$14(Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 != null) {
            BaseStreamingSource src = (BaseStreamingSource)tuple2._1();
            Offset off = (Offset)tuple2._2();
            if (src instanceof Source) {
                Source source = (Source)src;
                source.commit(off);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            BaseStreamingSource reader = (BaseStreamingSource)tuple2._1();
            Offset off = (Offset)tuple2._2();
            if (reader instanceof MicroBatchReader) {
                MicroBatchReader microBatchReader = (MicroBatchReader)reader;
                microBatchReader.commit(microBatchReader.deserializeOffset(off.json()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        BaseStreamingSource src = (BaseStreamingSource)tuple2._1();
        throw new IllegalArgumentException(new StringBuilder(47).append("Unknown source is found at constructNextBatch: ").append(src).toString());
    }

    public static final /* synthetic */ boolean $anonfun$runBatch$4(Offset available$2, Offset x$3) {
        Offset offset = x$3;
        Offset offset2 = available$2;
        return offset == null ? offset2 != null : !((Object)offset).equals(offset2);
    }

    public static final /* synthetic */ boolean $anonfun$runBatch$8(Offset available$3, Offset x$4) {
        Offset offset = x$4;
        Offset offset2 = available$3;
        return offset == null ? offset2 != null : !((Object)offset).equals(offset2);
    }

    public MicroBatchExecution(SparkSession sparkSession, String name, String checkpointRoot, LogicalPlan analyzedPlan, BaseStreamingSink sink, Trigger trigger, Clock triggerClock, OutputMode outputMode, scala.collection.immutable.Map<String, String> extraOptions, boolean deleteCheckpointOnStop) {
        Product product;
        this.analyzedPlan = analyzedPlan;
        this.extraOptions = extraOptions;
        super(sparkSession, name, checkpointRoot, analyzedPlan, sink, trigger, triggerClock, outputMode, deleteCheckpointOnStop);
        this.sources = (Seq)Seq$.MODULE$.empty();
        this.org$apache$spark$sql$execution$streaming$MicroBatchExecution$$readerToDataSourceMap = Map$.MODULE$.empty();
        Trigger trigger2 = super.trigger();
        if (trigger2 instanceof ProcessingTime) {
            ProcessingTime processingTime = (ProcessingTime)trigger2;
            product = new ProcessingTimeExecutor(processingTime, super.triggerClock());
        } else if (OneTimeTrigger$.MODULE$.equals(trigger2)) {
            product = new OneTimeExecutor();
        } else {
            throw new IllegalStateException(new StringBuilder(25).append("Unknown type of trigger: ").append(super.trigger()).toString());
        }
        this.triggerExecutor = product;
        this.isCurrentBatchConstructed = false;
    }
}

