/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.streaming.LongOffset;
import org.apache.spark.sql.execution.streaming.LongOffset$;
import org.apache.spark.sql.execution.streaming.MemoryStream$;
import org.apache.spark.sql.execution.streaming.MemoryStreamBase;
import org.apache.spark.sql.execution.streaming.MemoryStreamInputPartition;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation;
import org.apache.spark.sql.sources.v2.reader.InputPartition;
import org.apache.spark.sql.sources.v2.reader.streaming.MicroBatchReader;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\r-s!B\u0001\u0003\u0011\u0003y\u0011\u0001D'f[>\u0014\u0018p\u0015;sK\u0006l'BA\u0002\u0005\u0003%\u0019HO]3b[&twM\u0003\u0002\u0006\r\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001\u0001\t\u0003!Ei\u0011A\u0001\u0004\u0006%\tA\ta\u0005\u0002\r\u001b\u0016lwN]=TiJ,\u0017-\\\n\u0004#QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u00167%\u0011AD\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006=E!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=Aq!I\tC\u0002\u0013E!%\u0001\bdkJ\u0014XM\u001c;CY>\u001c7.\u00133\u0016\u0003\r\u0002\"\u0001J\u0017\u000e\u0003\u0015R!AJ\u0014\u0002\r\u0005$x.\\5d\u0015\tA\u0013&\u0001\u0006d_:\u001cWO\u001d:f]RT!AK\u0016\u0002\tU$\u0018\u000e\u001c\u0006\u0002Y\u0005!!.\u0019<b\u0013\tqSEA\u0007Bi>l\u0017nY%oi\u0016<WM\u001d\u0005\u0007aE\u0001\u000b\u0011B\u0012\u0002\u001f\r,(O]3oi\ncwnY6JI\u0002BqAM\tC\u0002\u0013E!%\u0001\bnK6|'/_*ue\u0016\fW.\u00133\t\rQ\n\u0002\u0015!\u0003$\u0003=iW-\\8ssN#(/Z1n\u0013\u0012\u0004\u0003\"\u0002\u001c\u0012\t\u00039\u0014!B1qa2LXc\u0001\u001d\u0004\u0002Q)\u0011ha\u0001\u0004\nA!\u0001C\u000fB\u0000\r\u0011\u0011\"\u0001Q\u001e\u0016\u0005q\u00125C\u0002\u001e>\u0017Zc&\u0004E\u0002\u0011}\u0001K!a\u0010\u0002\u0003!5+Wn\u001c:z'R\u0014X-Y7CCN,\u0007CA!C\u0019\u0001!Qa\u0011\u001eC\u0002\u0011\u0013\u0011!Q\t\u0003\u000b\"\u0003\"!\u0006$\n\u0005\u001d3\"a\u0002(pi\"Lgn\u001a\t\u0003+%K!A\u0013\f\u0003\u0007\u0005s\u0017\u0010\u0005\u0002M)6\tQJ\u0003\u0002\u0004\u001d*\u0011q\nU\u0001\u0007e\u0016\fG-\u001a:\u000b\u0005E\u0013\u0016A\u0001<3\u0015\t\u0019f!A\u0004t_V\u00148-Z:\n\u0005Uk%\u0001E'jGJ|')\u0019;dQJ+\u0017\rZ3s!\t9&,D\u0001Y\u0015\tI\u0006\"\u0001\u0005j]R,'O\\1m\u0013\tY\u0006LA\u0004M_\u001e<\u0017N\\4\u0011\u0005Ui\u0016B\u00010\u0017\u0005\u001d\u0001&o\u001c3vGRD\u0001\u0002\u0019\u001e\u0003\u0016\u0004%\t!Y\u0001\u0003S\u0012,\u0012A\u0019\t\u0003+\rL!\u0001\u001a\f\u0003\u0007%sG\u000f\u0003\u0005gu\tE\t\u0015!\u0003c\u0003\rIG\r\t\u0005\tQj\u0012)\u001a!C\u0001S\u0006Q1/\u001d7D_:$X\r\u001f;\u0016\u0003)\u0004\"a\u001b7\u000e\u0003\u0019I!!\u001c\u0004\u0003\u0015M\u000bFjQ8oi\u0016DH\u000f\u0003\u0005pu\tE\t\u0015!\u0003k\u0003-\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\u0011\t\u0011ET$1!Q\u0001\fI\f!\"\u001a<jI\u0016t7-\u001a\u00134!\rY7\u000fQ\u0005\u0003i\u001a\u0011q!\u00128d_\u0012,'\u000fC\u0003\u001fu\u0011\u0005a\u000fF\u0002xun$\"\u0001_=\u0011\u0007AQ\u0004\tC\u0003rk\u0002\u000f!\u000fC\u0003ak\u0002\u0007!\rC\u0003ik\u0002\u0007!\u000eC\u0004~u\t\u0007I\u0011\u0003@\u0002\u00171|w-[2bYBc\u0017M\\\u000b\u0002\u007fB!\u0011\u0011AA\b\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011a\u00027pO&\u001c\u0017\r\u001c\u0006\u0005\u0003\u0013\tY!A\u0003qY\u0006t7OC\u0002\u0002\u000e\u0019\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003#\t\u0019AA\u0006M_\u001eL7-\u00197QY\u0006t\u0007bBA\u000bu\u0001\u0006Ia`\u0001\rY><\u0017nY1m!2\fg\u000e\t\u0005\n\u00033Q$\u0019!C\t\u00037\taa\\;uaV$XCAA\u000f!\u0019\ty\"a\f\u000269!\u0011\u0011EA\u0016\u001d\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014\u001d\u00051AH]8pizJ\u0011aF\u0005\u0004\u0003[1\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003c\t\u0019DA\u0002TKFT1!!\f\u0017!\u0011\t9$!\u0010\u000e\u0005\u0005e\"\u0002BA\u001e\u0003\u0017\t1\"\u001a=qe\u0016\u001c8/[8og&!\u0011qHA\u001d\u0005%\tE\u000f\u001e:jEV$X\r\u0003\u0005\u0002Di\u0002\u000b\u0011BA\u000f\u0003\u001dyW\u000f\u001e9vi\u0002B\u0011\"a\u0012;\u0005\u0004%\t\"!\u0013\u0002\u000f\t\fGo\u00195fgV\u0011\u00111\n\t\u0007\u0003\u001b\n9&a\u0017\u000e\u0005\u0005=#\u0002BA)\u0003'\nq!\\;uC\ndWMC\u0002\u0002VY\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI&a\u0014\u0003\u00151K7\u000f\u001e\"vM\u001a,'\u000fE\u0003\u0016\u0003;\n\t'C\u0002\u0002`Y\u0011Q!\u0011:sCf\u0004B!a\u000e\u0002d%!\u0011QMA\u001d\u0005%)fn]1gKJ{w\u000f\u0003\u0005\u0002ji\u0002\u000b\u0011BA&\u0003!\u0011\u0017\r^2iKN\u0004\u0003\u0006CA4\u0003[\ny(!!\u0011\t\u0005=\u00141P\u0007\u0003\u0003cR1\u0001KA:\u0015\u0011\t)(a\u001e\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002\u0002z\u0005)!.\u0019<bq&!\u0011QPA9\u0005%9U/\u0019:eK\u0012\u0014\u00150A\u0003wC2,X-\t\u0002\u0002\u0004\u0006!A\u000f[5t\u0011%\t9I\u000fa\u0001\n#\tI)A\u0007dkJ\u0014XM\u001c;PM\u001a\u001cX\r^\u000b\u0003\u0003\u0017\u00032\u0001EAG\u0013\r\tyI\u0001\u0002\u000b\u0019>twm\u00144gg\u0016$\b\"CAJu\u0001\u0007I\u0011CAK\u0003E\u0019WO\u001d:f]R|eMZ:fi~#S-\u001d\u000b\u0005\u0003/\u000bi\nE\u0002\u0016\u00033K1!a'\u0017\u0005\u0011)f.\u001b;\t\u0015\u0005}\u0015\u0011SA\u0001\u0002\u0004\tY)A\u0002yIEB\u0001\"a);A\u0003&\u00111R\u0001\u000fGV\u0014(/\u001a8u\u001f\u001a47/\u001a;!Q!\t\t+!\u001c\u0002\u0000\u0005\u0005\u0005\"CAUu\u0001\u0007I\u0011CAE\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\u0013\u00055&\b1A\u0005\u0012\u0005=\u0016aD:uCJ$xJ\u001a4tKR|F%Z9\u0015\t\u0005]\u0015\u0011\u0017\u0005\u000b\u0003?\u000bY+!AA\u0002\u0005-\u0005\u0002CA[u\u0001\u0006K!a#\u0002\u0019M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0011)\u0011\u0005M\u0016QNA@\u0003\u0003C\u0011\"a/;\u0001\u0004%I!!#\u0002\u0013\u0015tGm\u00144gg\u0016$\b\"CA`u\u0001\u0007I\u0011BAa\u00035)g\u000eZ(gMN,Go\u0018\u0013fcR!\u0011qSAb\u0011)\ty*!0\u0002\u0002\u0003\u0007\u00111\u0012\u0005\t\u0003\u000fT\u0004\u0015)\u0003\u0002\f\u0006QQM\u001c3PM\u001a\u001cX\r\u001e\u0011)\u0011\u0005\u0015\u0017QNA@\u0003\u0003C\u0011\"!4;\u0001\u0004%\t\"!#\u0002'1\f7\u000f^(gMN,GoQ8n[&$H/\u001a3\t\u0013\u0005E'\b1A\u0005\u0012\u0005M\u0017a\u00067bgR|eMZ:fi\u000e{W.\\5ui\u0016$w\fJ3r)\u0011\t9*!6\t\u0015\u0005}\u0015qZA\u0001\u0002\u0004\tY\t\u0003\u0005\u0002Zj\u0002\u000b\u0015BAF\u0003Qa\u0017m\u001d;PM\u001a\u001cX\r^\"p[6LG\u000f^3eA!B\u0011q[A7\u0003\u007f\n\t\tC\u0004\u0002`j\"\t!!9\u0002\u000f\u0005$G\rR1uCR!\u00111]Au!\r\u0001\u0012Q]\u0005\u0004\u0003O\u0014!AB(gMN,G\u000f\u0003\u0005\u0002l\u0006u\u0007\u0019AAw\u0003\u0011!\u0017\r^1\u0011\u000b\u0005}\u0011q\u001e!\n\t\u0005E\u00181\u0007\u0002\u0010)J\fg/\u001a:tC\ndWm\u00148dK\"9\u0011Q\u001f\u001e\u0005B\u0005]\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005e\b\u0003BA~\u0005\u0007qA!!@\u0002\u0000B\u0019\u00111\u0005\f\n\u0007\t\u0005a#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u000b\u00119A\u0001\u0004TiJLgn\u001a\u0006\u0004\u0005\u00031\u0002b\u0002B\u0006u\u0011\u0005#QB\u0001\u000fg\u0016$xJ\u001a4tKR\u0014\u0016M\\4f)\u0019\t9Ja\u0004\u0003 !A!\u0011\u0003B\u0005\u0001\u0004\u0011\u0019\"A\u0003ti\u0006\u0014H\u000f\u0005\u0004\u0003\u0016\t]!1D\u0007\u0002S%\u0019!\u0011D\u0015\u0003\u0011=\u0003H/[8oC2\u00042\u0001\u0014B\u000f\u0013\r\t9/\u0014\u0005\t\u0005C\u0011I\u00011\u0001\u0003\u0014\u0005\u0019QM\u001c3\t\u000f\t\u0015\"\b\"\u0011\u0003(\u0005\tB-Z:fe&\fG.\u001b>f\u001f\u001a47/\u001a;\u0015\t\tm!\u0011\u0006\u0005\t\u0005W\u0011\u0019\u00031\u0001\u0002z\u0006!!n]8o\u0011\u001d\u0011yC\u000fC!\u0005c\tabZ3u'R\f'\u000f^(gMN,G\u000f\u0006\u0002\u0003\u001c!9!Q\u0007\u001e\u0005B\tE\u0012\u0001D4fi\u0016sGm\u00144gg\u0016$\bb\u0002B\u001du\u0011\u0005#1H\u0001\u0014a2\fg.\u00138qkR\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003\u0005{\u0001bA!\u0006\u0003@\t\r\u0013b\u0001B!S\t!A*[:u!\u0019\u0011)Ea\u0012\u0003L5\ta*C\u0002\u0003J9\u0013a\"\u00138qkR\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0003N\t=SBAA\u0006\u0013\u0011\u0011\t&a\u0003\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\b\u0005+RD\u0011\u0002B,\u0003M9WM\\3sCR,G)\u001a2vON#(/\u001b8h)!\tIP!\u0017\u0003`\t\r\u0004\u0002\u0003B.\u0005'\u0002\rA!\u0018\u0002\tI|wo\u001d\t\u0007\u0003?\ty#!\u0019\t\u000f\t\u0005$1\u000ba\u0001E\u0006a1\u000f^1si>\u0013H-\u001b8bY\"9!Q\rB*\u0001\u0004\u0011\u0017AC3oI>\u0013H-\u001b8bY\"9!\u0011\u000e\u001e\u0005B\t-\u0014AB2p[6LG\u000f\u0006\u0003\u0002\u0018\n5\u0004\u0002\u0003B\u0011\u0005O\u0002\rAa\u0007\t\u000f\tE$\b\"\u0011\u0003t\u0005!1\u000f^8q)\t\t9\nC\u0004\u0003xi\"\tAa\u001d\u0002\u000bI,7/\u001a;\t\u0013\tm$(!A\u0005\u0002\tu\u0014\u0001B2paf,BAa \u0003\bR1!\u0011\u0011BG\u0005\u001f#BAa!\u0003\nB!\u0001C\u000fBC!\r\t%q\u0011\u0003\u0007\u0007\ne$\u0019\u0001#\t\u000fE\u0014I\bq\u0001\u0003\fB!1n\u001dBC\u0011!\u0001'\u0011\u0010I\u0001\u0002\u0004\u0011\u0007\u0002\u00035\u0003zA\u0005\t\u0019\u00016\t\u0013\tM%(%A\u0005\u0002\tU\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0005\u0005/\u0013Y+\u0006\u0002\u0003\u001a*\u001a!Ma',\u0005\tu\u0005\u0003\u0002BP\u0005Ok!A!)\u000b\t\t\r&QU\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001e\u0017\u0013\u0011\u0011IK!)\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0002\u0004D\u0005#\u0013\r\u0001\u0012\u0005\n\u0005_S\u0014\u0013!C\u0001\u0005c\u000babY8qs\u0012\"WMZ1vYR$#'\u0006\u0003\u00034\n]VC\u0001B[U\rQ'1\u0014\u0003\u0007\u0007\n5&\u0019\u0001#\t\u0013\tm&(!A\u0005B\tu\u0016!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003@B!!\u0011\u0019Bd\u001b\t\u0011\u0019MC\u0002\u0003F.\nA\u0001\\1oO&!!Q\u0001Bb\u0011!\u0011YMOA\u0001\n\u0003\t\u0017\u0001\u00049s_\u0012,8\r^!sSRL\b\"\u0003Bhu\u0005\u0005I\u0011\u0001Bi\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001\u0013Bj\u0011%\tyJ!4\u0002\u0002\u0003\u0007!\rC\u0005\u0003Xj\n\t\u0011\"\u0011\u0003Z\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\\B)!Q\u001cBp\u00116\u0011\u00111K\u0005\u0005\u0005C\f\u0019F\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\u0011)OOA\u0001\n\u0003\u00119/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011IOa<\u0011\u0007U\u0011Y/C\u0002\u0003nZ\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002 \n\r\u0018\u0011!a\u0001\u0011\"I!1\u001f\u001e\u0002\u0002\u0013\u0005#Q_\u0001\tQ\u0006\u001c\bnQ8eKR\t!\rC\u0005\u0003zj\n\t\u0011\"\u0011\u0003|\u00061Q-];bYN$BA!;\u0003~\"I\u0011q\u0014B|\u0003\u0003\u0005\r\u0001\u0013\t\u0004\u0003\u000e\u0005A!B\"6\u0005\u0004!\u0005\"CB\u0003k\u0005\u0005\t9AB\u0004\u0003))g/\u001b3f]\u000e,G%\r\t\u0005WN\u0014y\u0010C\u0003ik\u0001\u000f!\u000e\u0003\u00057#\u0005\u0005I\u0011QB\u0007+\u0011\u0019yaa\u0006\u0015\r\rE1QDB\u0010)\u0011\u0019\u0019b!\u0007\u0011\tAQ4Q\u0003\t\u0004\u0003\u000e]AAB\"\u0004\f\t\u0007A\tC\u0004r\u0007\u0017\u0001\u001daa\u0007\u0011\t-\u001c8Q\u0003\u0005\u0007A\u000e-\u0001\u0019\u00012\t\r!\u001cY\u00011\u0001k\u0011%\u0019\u0019#EA\u0001\n\u0003\u001b)#A\u0004v]\u0006\u0004\b\u000f\\=\u0016\t\r\u001d2Q\b\u000b\u0005\u0007S\u0019)\u0004E\u0003\u0016\u0007W\u0019y#C\u0002\u0004.Y\u0011aa\u00149uS>t\u0007#B\u000b\u00042\tT\u0017bAB\u001a-\t1A+\u001e9mKJB!ba\u000e\u0004\"\u0005\u0005\t\u0019AB\u001d\u0003\rAH\u0005\r\t\u0005!i\u001aY\u0004E\u0002B\u0007{!aaQB\u0011\u0005\u0004!\u0005\"CB!#\u0005\u0005I\u0011BB\"\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\r\u0015\u0003\u0003\u0002Ba\u0007\u000fJAa!\u0013\u0003D\n1qJ\u00196fGR\u0004")
public class MemoryStream<A>
extends MemoryStreamBase<A>
implements MicroBatchReader,
Logging,
Product,
scala.Serializable {
    private final int id;
    private final SQLContext sqlContext;
    private final LogicalPlan logicalPlan;
    private final Seq<Attribute> output;
    @GuardedBy(value="this")
    private final ListBuffer<UnsafeRow[]> batches;
    @GuardedBy(value="this")
    private LongOffset currentOffset;
    @GuardedBy(value="this")
    private LongOffset startOffset;
    @GuardedBy(value="this")
    private LongOffset endOffset;
    @GuardedBy(value="this")
    private LongOffset lastOffsetCommitted;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static <A> Option<Tuple2<Object, SQLContext>> unapply(MemoryStream<A> memoryStream) {
        return MemoryStream$.MODULE$.unapply(memoryStream);
    }

    public static <A> MemoryStream<A> apply(int n, SQLContext sQLContext, Encoder<A> encoder) {
        return MemoryStream$.MODULE$.apply(n, sQLContext, encoder);
    }

    public static <A> MemoryStream<A> apply(Encoder<A> encoder, SQLContext sQLContext) {
        return MemoryStream$.MODULE$.apply(encoder, sQLContext);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int id() {
        return this.id;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public LogicalPlan logicalPlan() {
        return this.logicalPlan;
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    public ListBuffer<UnsafeRow[]> batches() {
        return this.batches;
    }

    public LongOffset currentOffset() {
        return this.currentOffset;
    }

    public void currentOffset_$eq(LongOffset x$1) {
        this.currentOffset = x$1;
    }

    public LongOffset startOffset() {
        return this.startOffset;
    }

    public void startOffset_$eq(LongOffset x$1) {
        this.startOffset = x$1;
    }

    private LongOffset endOffset() {
        return this.endOffset;
    }

    private void endOffset_$eq(LongOffset x$1) {
        this.endOffset = x$1;
    }

    public LongOffset lastOffsetCommitted() {
        return this.lastOffsetCommitted;
    }

    public void lastOffsetCommitted_$eq(LongOffset x$1) {
        this.lastOffsetCommitted = x$1;
    }

    @Override
    public Offset addData(TraversableOnce<A> data) {
        LongOffset longOffset;
        Seq objects = data.toSeq();
        UnsafeRow[] rows = (UnsafeRow[])objects.iterator().map((Function1 & Serializable & scala.Serializable)d -> (UnsafeRow)this.encoder().toRow(d).copy()).toArray(ClassTag$.MODULE$.apply(UnsafeRow.class));
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("Adding: ").append(objects).toString());
        MemoryStream memoryStream = this;
        synchronized (memoryStream) {
            this.currentOffset_$eq(this.currentOffset().$plus(1L));
            this.batches().$plus$eq((Object)rows);
            longOffset = this.currentOffset();
        }
        return longOffset;
    }

    public String toString() {
        return new StringBuilder(14).append("MemoryStream[").append(Utils$.MODULE$.truncatedString(this.output(), ",")).append("]").toString();
    }

    @Override
    public synchronized void setOffsetRange(Optional<org.apache.spark.sql.sources.v2.reader.streaming.Offset> start, Optional<org.apache.spark.sql.sources.v2.reader.streaming.Offset> end) {
        this.startOffset_$eq((LongOffset)start.orElse(new LongOffset(-1L)));
        this.endOffset_$eq((LongOffset)end.orElse(this.currentOffset()));
    }

    @Override
    public org.apache.spark.sql.sources.v2.reader.streaming.Offset deserializeOffset(String json) {
        return new LongOffset(new StringOps(Predef$.MODULE$.augmentString(json)).toLong());
    }

    @Override
    public synchronized org.apache.spark.sql.sources.v2.reader.streaming.Offset getStartOffset() {
        return this.startOffset().offset() == -1L ? null : this.startOffset();
    }

    @Override
    public synchronized org.apache.spark.sql.sources.v2.reader.streaming.Offset getEndOffset() {
        return this.endOffset().offset() == -1L ? null : this.endOffset();
    }

    @Override
    public synchronized List<InputPartition<InternalRow>> planInputPartitions() {
        ListBuffer listBuffer;
        int startOrdinal = (int)this.startOffset().offset() + 1;
        int endOrdinal = (int)this.endOffset().offset() + 1;
        MemoryStream memoryStream = this;
        synchronized (memoryStream) {
            int sliceStart = startOrdinal - (int)this.lastOffsetCommitted().offset() - 1;
            int sliceEnd = endOrdinal - (int)this.lastOffsetCommitted().offset() - 1;
            Predef$.MODULE$.assert(sliceStart <= sliceEnd, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("sliceStart: ").append(sliceStart).append(" sliceEnd: ").append(sliceEnd).toString());
            listBuffer = (ListBuffer)this.batches().slice(sliceStart, sliceEnd);
        }
        ListBuffer newBlocks = listBuffer;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> this.generateDebugString((Seq<UnsafeRow>)((Seq)newBlocks.flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)))), startOrdinal, endOrdinal));
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)newBlocks.map((Function1 & Serializable & scala.Serializable)block -> new MemoryStreamInputPartition((UnsafeRow[])block), ListBuffer$.MODULE$.canBuildFrom())).asJava();
    }

    private String generateDebugString(Seq<UnsafeRow> rows, int startOrdinal, int endOrdinal) {
        ExpressionEncoder expressionEncoder = this.encoder().resolveAndBind(this.encoder().resolveAndBind$default$1(), this.encoder().resolveAndBind$default$2());
        Function1 & Serializable & scala.Serializable fromRow = (Function1 & Serializable & scala.Serializable)row -> expressionEncoder.fromRow(row);
        return new StringBuilder(18).append("MemoryBatch [").append(startOrdinal).append(", ").append(endOrdinal).append("]: ").append(String.valueOf(((TraversableOnce)rows.map((Function1 & Serializable & scala.Serializable)row -> fromRow.apply(row), Seq$.MODULE$.canBuildFrom())).mkString(", "))).toString();
    }

    @Override
    public synchronized void commit(org.apache.spark.sql.sources.v2.reader.streaming.Offset end) {
        Option<LongOffset> option = LongOffset$.MODULE$.convert(end);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw package$.MODULE$.error(new StringBuilder(97).append("MemoryStream.commit() received an offset (").append(end).append(") ").append("that did not originate with an instance of this class").toString());
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        LongOffset lo = (LongOffset)some.value();
        this.check$1(lo, end);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Override
    public void stop() {
    }

    public synchronized void reset() {
        this.batches().clear();
        this.startOffset_$eq(new LongOffset(-1L));
        this.endOffset_$eq(new LongOffset(-1L));
        this.currentOffset_$eq(new LongOffset(-1L));
        this.lastOffsetCommitted_$eq(new LongOffset(-1L));
    }

    public <A> MemoryStream<A> copy(int id, SQLContext sqlContext, Encoder<A> evidence$3) {
        return new MemoryStream<A>(id, sqlContext, evidence$3);
    }

    public <A> int copy$default$1() {
        return this.id();
    }

    public <A> SQLContext copy$default$2() {
        return this.sqlContext();
    }

    public String productPrefix() {
        return "MemoryStream";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.id());
                break;
            }
            case 1: {
                object = this.sqlContext();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MemoryStream;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.id());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.sqlContext()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MemoryStream)) return false;
        boolean bl = true;
        if (!bl) return false;
        MemoryStream memoryStream = (MemoryStream)x$1;
        if (this.id() != memoryStream.id()) return false;
        SQLContext sQLContext = this.sqlContext();
        SQLContext sQLContext2 = memoryStream.sqlContext();
        if (sQLContext == null) {
            if (sQLContext2 != null) {
                return false;
            }
        } else if (!sQLContext.equals(sQLContext2)) return false;
        if (!memoryStream.canEqual(this)) return false;
        return true;
    }

    private final void check$1(LongOffset newOffset, org.apache.spark.sql.sources.v2.reader.streaming.Offset end$1) {
        int offsetDiff = (int)(newOffset.offset() - this.lastOffsetCommitted().offset());
        if (offsetDiff < 0) {
            throw package$.MODULE$.error(new StringBuilder(45).append("Offsets committed out of order: ").append(this.lastOffsetCommitted()).append(" followed by ").append(end$1).toString());
        }
        this.batches().trimStart(offsetDiff);
        this.lastOffsetCommitted_$eq(newOffset);
    }

    public MemoryStream(int id, SQLContext sqlContext, Encoder<A> evidence$3) {
        this.id = id;
        this.sqlContext = sqlContext;
        super(sqlContext, evidence$3);
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.logicalPlan = new StreamingExecutionRelation(this, this.attributes(), sqlContext.sparkSession());
        this.output = this.logicalPlan().output();
        this.batches = new ListBuffer();
        this.currentOffset = new LongOffset(-1L);
        this.startOffset = new LongOffset(-1L);
        this.endOffset = new LongOffset(-1L);
        this.lastOffsetCommitted = new LongOffset(-1L);
    }
}

