/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.streaming.FileStreamOptions;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog$;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset$;
import org.apache.spark.sql.execution.streaming.MetadataLogFileIndex;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\reh\u0001B\u0001\u0003\u0001=\u0011\u0001CR5mKN#(/Z1n'>,(oY3\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\r\u001d!\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003mC:<'\"A\u000b\u0002\t)\fg/Y\u0005\u0003/I\u0011aa\u00142kK\u000e$\bCA\r\u001b\u001b\u0005\u0011\u0011BA\u000e\u0003\u0005\u0019\u0019v.\u001e:dKB\u0011Q\u0004I\u0007\u0002=)\u0011q\u0004C\u0001\tS:$XM\u001d8bY&\u0011\u0011E\b\u0002\b\u0019><w-\u001b8h\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013\u0001D:qCJ\\7+Z:tS>t\u0007CA\u0013'\u001b\u00051\u0011BA\u0014\u0007\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011!I\u0003A!A!\u0002\u0013Q\u0013\u0001\u00029bi\"\u0004\"a\u000b\u001b\u000f\u00051\u0012\u0004CA\u00171\u001b\u0005q#BA\u0018\u000f\u0003\u0019a$o\\8u})\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\u00051\u0001K]3eK\u001aL!!\u000e\u001c\u0003\rM#(/\u001b8h\u0015\t\u0019\u0004\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003+\u0003M1\u0017\u000e\\3G_Jl\u0017\r^\"mCN\u001ch*Y7f\u0011!Q\u0004A!b\u0001\n\u0003Z\u0014AB:dQ\u0016l\u0017-F\u0001=!\ti\u0004)D\u0001?\u0015\tyd!A\u0003usB,7/\u0003\u0002B}\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0011\r\u0003!\u0011!Q\u0001\nq\nqa]2iK6\f\u0007\u0005\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0003A\u0001\u0018M\u001d;ji&|gnQ8mk6t7\u000fE\u0002H\u0019*r!\u0001\u0013&\u000f\u00055J\u0015\"A\u0019\n\u0005-\u0003\u0014a\u00029bG.\fw-Z\u0005\u0003\u001b:\u00131aU3r\u0015\tY\u0005\u0007\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003+\u00031iW\r^1eCR\f\u0007+\u0019;i\u0011!\u0011\u0006A!A!\u0002\u0013\u0019\u0016aB8qi&|gn\u001d\t\u0005WQS#&\u0003\u0002Vm\t\u0019Q*\u00199\t\u000b]\u0003A\u0011\u0001-\u0002\rqJg.\u001b;?)!I&l\u0017/^=~\u0003\u0007CA\r\u0001\u0011\u0015\u0019c\u000b1\u0001%\u0011\u0015Ic\u000b1\u0001+\u0011\u0015Ad\u000b1\u0001+\u0011\u0015Qd\u000b1\u0001=\u0011\u0015)e\u000b1\u0001G\u0011\u0015\u0001f\u000b1\u0001+\u0011\u0015\u0011f\u000b1\u0001T\u0011\u001d\u0011\u0007A1A\u0005\n\r\fQb]8ve\u000e,w\n\u001d;j_:\u001cX#\u00013\u0011\u0005e)\u0017B\u00014\u0003\u0005E1\u0015\u000e\\3TiJ,\u0017-\\(qi&|gn\u001d\u0005\u0007Q\u0002\u0001\u000b\u0011\u00023\u0002\u001dM|WO]2f\u001fB$\u0018n\u001c8tA!9!\u000e\u0001b\u0001\n\u0013Y\u0017A\u00035bI>|\u0007oQ8oMV\tA\u000e\u0005\u0002ne6\taN\u0003\u0002pa\u0006!1m\u001c8g\u0015\t\t(\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003g:\u0014QbQ8oM&<WO]1uS>t\u0007BB;\u0001A\u0003%A.A\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\u0003bB<\u0001\u0005\u0004%I\u0001_\u0001\u0003MN,\u0012!\u001f\t\u0003url\u0011a\u001f\u0006\u0003oBL!!`>\u0003\u0015\u0019KG.Z*zgR,W\u000e\u0003\u0004\u0000\u0001\u0001\u0006I!_\u0001\u0004MN\u0004\u0003f\u0001@\u0002\u0004A!\u0011QAA\u0004\u001b\u0005\u0001\u0014bAA\u0005a\tIAO]1og&,g\u000e\u001e\u0005\n\u0003\u001b\u0001!\u0019!C\u0005\u0003\u001f\t\u0011#];bY&4\u0017.\u001a3CCN,\u0007+\u0019;i+\t\t\t\u0002E\u0002{\u0003'I1!!\u0006|\u0005\u0011\u0001\u0016\r\u001e5\t\u0011\u0005e\u0001\u0001)A\u0005\u0003#\t!#];bY&4\u0017.\u001a3CCN,\u0007+\u0019;iA!I\u0011Q\u0004\u0001C\u0002\u0013%\u0011qD\u0001\u001d_B$\u0018n\u001c8t/&$\b\u000eU1si&$\u0018n\u001c8CCN,\u0007+\u0019;i+\t\t\t\u0003\u0005\u0004\u0002$\u00055\"FK\u0007\u0003\u0003KQA!a\n\u0002*\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003W\u0001\u0014AC2pY2,7\r^5p]&\u0019Q+!\n\t\u0011\u0005E\u0002\u0001)A\u0005\u0003C\tQd\u001c9uS>t7oV5uQB\u000b'\u000f^5uS>t')Y:f!\u0006$\b\u000e\t\u0005\n\u0003k\u0001!\u0019!C\u0005\u0003o\t1\"\\3uC\u0012\fG/\u0019'pOV\u0011\u0011\u0011\b\t\u00043\u0005m\u0012bAA\u001f\u0005\t\u0019b)\u001b7f'R\u0014X-Y7T_V\u00148-\u001a'pO\"A\u0011\u0011\t\u0001!\u0002\u0013\tI$\u0001\u0007nKR\fG-\u0019;b\u0019><\u0007\u0005C\u0005\u0002F\u0001\u0001\r\u0011\"\u0003\u0002H\u0005AR.\u001a;bI\u0006$\u0018\rT8h\u0007V\u0014(/\u001a8u\u001f\u001a47/\u001a;\u0016\u0005\u0005%\u0003\u0003BA\u0003\u0003\u0017J1!!\u00141\u0005\u0011auN\\4\t\u0013\u0005E\u0003\u00011A\u0005\n\u0005M\u0013\u0001H7fi\u0006$\u0017\r^1M_\u001e\u001cUO\u001d:f]R|eMZ:fi~#S-\u001d\u000b\u0005\u0003+\nY\u0006\u0005\u0003\u0002\u0006\u0005]\u0013bAA-a\t!QK\\5u\u0011)\ti&a\u0014\u0002\u0002\u0003\u0007\u0011\u0011J\u0001\u0004q\u0012\n\u0004\u0002CA1\u0001\u0001\u0006K!!\u0013\u000235,G/\u00193bi\u0006dunZ\"veJ,g\u000e^(gMN,G\u000f\t\u0005\n\u0003K\u0002!\u0019!C\u0005\u0003O\n\u0001#\\1y\r&dWm\u001d)fe\n\u000bGo\u00195\u0016\u0005\u0005%\u0004CBA\u0003\u0003W\ny'C\u0002\u0002nA\u0012aa\u00149uS>t\u0007\u0003BA\u0003\u0003cJ1!a\u001d1\u0005\rIe\u000e\u001e\u0005\t\u0003o\u0002\u0001\u0015!\u0003\u0002j\u0005\tR.\u0019=GS2,7\u000fU3s\u0005\u0006$8\r\u001b\u0011\t\u0013\u0005m\u0004A1A\u0005\n\u0005u\u0014!\u00044jY\u0016\u001cvN\u001d;Pe\u0012,'/\u0006\u0002\u0002\u0000A1\u0011\u0011QAD\u0003\u0013j!!a!\u000b\u0007\u0005\u0015\u0005'\u0001\u0003nCRD\u0017\u0002BAE\u0003\u0007\u0013\u0001b\u0014:eKJLgn\u001a\u0005\t\u0003\u001b\u0003\u0001\u0015!\u0003\u0002\u0000\u0005qa-\u001b7f'>\u0014Ho\u0014:eKJ\u0004\u0003\"CAI\u0001\t\u0007I\u0011BA$\u00031i\u0017\r\u001f$jY\u0016\fu-Z't\u0011!\t)\n\u0001Q\u0001\n\u0005%\u0013!D7bq\u001aKG.Z!hK6\u001b\b\u0005C\u0005\u0002\u001a\u0002\u0011\r\u0011\"\u0003\u0002\u001c\u0006aa-\u001b7f\u001d\u0006lWm\u00148msV\u0011\u0011Q\u0014\t\u0005\u0003\u000b\ty*C\u0002\u0002\"B\u0012qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002&\u0002\u0001\u000b\u0011BAO\u000351\u0017\u000e\\3OC6,wJ\u001c7zA!I\u0011\u0011\u0016\u0001C\u0002\u0013\u0005\u00111V\u0001\ng\u0016,gNR5mKN,\"!!,\u0011\t\u0005=&1\u0019\b\u00043\u0005EvaBAZ\u0005!\u0005\u0011QW\u0001\u0011\r&dWm\u0015;sK\u0006l7k\\;sG\u0016\u00042!GA\\\r\u0019\t!\u0001#\u0001\u0002:N!\u0011qWA^!\u0011\t)!!0\n\u0007\u0005}\u0006G\u0001\u0004B]f\u0014VM\u001a\u0005\b/\u0006]F\u0011AAb)\t\t),B\u0004\u0002H\u0006]\u0006!!\u0013\u0003\u0013QKW.Z:uC6\u0004haBAf\u0003o\u0003\u0015Q\u001a\u0002\n\r&dW-\u00128uef\u001c\u0002\"!3\u0002<\u0006=\u0017Q\u001b\t\u0005\u0003\u000b\t\t.C\u0002\u0002TB\u0012AbU3sS\u0006d\u0017N_1cY\u0016\u0004B!!\u0002\u0002X&\u0019\u0011\u0011\u001c\u0019\u0003\u000fA\u0013x\u000eZ;di\"Q\u0011&!3\u0003\u0016\u0004%\t!!8\u0016\u0003)B!\"!9\u0002J\nE\t\u0015!\u0003+\u0003\u0015\u0001\u0018\r\u001e5!\u0011-\t)/!3\u0003\u0016\u0004%\t!a:\u0002\u0013QLW.Z:uC6\u0004XCAAu!\u0011\tY/!2\u000e\u0005\u0005]\u0006bCAx\u0003\u0013\u0014\t\u0012)A\u0005\u0003S\f!\u0002^5nKN$\u0018-\u001c9!\u0011-\t\u00190!3\u0003\u0016\u0004%\t!a\u0012\u0002\u000f\t\fGo\u00195JI\"Y\u0011q_Ae\u0005#\u0005\u000b\u0011BA%\u0003!\u0011\u0017\r^2i\u0013\u0012\u0004\u0003bB,\u0002J\u0012\u0005\u00111 \u000b\t\u0003{\fyP!\u0001\u0003\u0004A!\u00111^Ae\u0011\u0019I\u0013\u0011 a\u0001U!A\u0011Q]A}\u0001\u0004\tI\u000f\u0003\u0005\u0002t\u0006e\b\u0019AA%\u0011)\u00119!!3\u0002\u0002\u0013\u0005!\u0011B\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0002~\n-!Q\u0002B\b\u0011!I#Q\u0001I\u0001\u0002\u0004Q\u0003BCAs\u0005\u000b\u0001\n\u00111\u0001\u0002j\"Q\u00111\u001fB\u0003!\u0003\u0005\r!!\u0013\t\u0015\tM\u0011\u0011ZI\u0001\n\u0003\u0011)\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t]!f\u0001\u0016\u0003\u001a-\u0012!1\u0004\t\u0005\u0005;\u00119#\u0004\u0002\u0003 )!!\u0011\u0005B\u0012\u0003%)hn\u00195fG.,GMC\u0002\u0003&A\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011ICa\b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u0003.\u0005%\u0017\u0013!C\u0001\u0005_\tabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u00032)\"\u0011\u0011\u001eB\r\u0011)\u0011)$!3\u0012\u0002\u0013\u0005!qG\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011ID\u000b\u0003\u0002J\te\u0001B\u0003B\u001f\u0003\u0013\f\t\u0011\"\u0011\u0003@\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\u0011\u0011\u0007E\u0011\u0019%\u0003\u00026%!Q!qIAe\u0003\u0003%\tA!\u0013\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005=\u0004B\u0003B'\u0003\u0013\f\t\u0011\"\u0001\u0003P\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B)\u0005/\u0002B!!\u0002\u0003T%\u0019!Q\u000b\u0019\u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u0002^\t-\u0013\u0011!a\u0001\u0003_B!Ba\u0017\u0002J\u0006\u0005I\u0011\tB/\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B0!\u0019\u0011\tGa\u0019\u0003R5\u0011\u0011\u0011F\u0005\u0005\u0005K\nIC\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011)\u0011I'!3\u0002\u0002\u0013\u0005!1N\u0001\tG\u0006tW)];bYR!\u0011Q\u0014B7\u0011)\tiFa\u001a\u0002\u0002\u0003\u0007!\u0011\u000b\u0005\u000b\u0005c\nI-!A\u0005B\tM\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005=\u0004B\u0003B<\u0003\u0013\f\t\u0011\"\u0011\u0003z\u0005AAo\\*ue&tw\r\u0006\u0002\u0003B!Q!QPAe\u0003\u0003%\tEa \u0002\r\u0015\fX/\u00197t)\u0011\tiJ!!\t\u0015\u0005u#1PA\u0001\u0002\u0004\u0011\tf\u0002\u0006\u0003\u0006\u0006]\u0016\u0011!E\u0001\u0005\u000f\u000b\u0011BR5mK\u0016sGO]=\u0011\t\u0005-(\u0011\u0012\u0004\u000b\u0003\u0017\f9,!A\t\u0002\t-5C\u0002BE\u0005\u001b\u000by\rE\u0006\u0003\u0010\nU%&!;\u0002J\u0005uXB\u0001BI\u0015\r\u0011\u0019\nM\u0001\beVtG/[7f\u0013\u0011\u00119J!%\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007C\u0004X\u0005\u0013#\tAa'\u0015\u0005\t\u001d\u0005B\u0003B<\u0005\u0013\u000b\t\u0011\"\u0012\u0003z!Q!\u0011\u0015BE\u0003\u0003%\tIa)\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\u0005u(Q\u0015BT\u0005SCa!\u000bBP\u0001\u0004Q\u0003\u0002CAs\u0005?\u0003\r!!;\t\u0011\u0005M(q\u0014a\u0001\u0003\u0013B!B!,\u0003\n\u0006\u0005I\u0011\u0011BX\u0003\u001d)h.\u00199qYf$BA!-\u0003:B1\u0011QAA6\u0005g\u0003\u0012\"!\u0002\u00036*\nI/!\u0013\n\u0007\t]\u0006G\u0001\u0004UkBdWm\r\u0005\u000b\u0005w\u0013Y+!AA\u0002\u0005u\u0018a\u0001=%a!Q!q\u0018BE\u0003\u0003%IA!1\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002!\u00199!QYA\\\u0001\t\u001d'\u0001D*fK:4\u0015\u000e\\3t\u001b\u0006\u00048\u0003\u0002Bb\u0003wC1Ba3\u0003D\n\u0005\t\u0015!\u0003\u0002J\u0005AQ.\u0019=BO\u0016l5\u000fC\b\u0003P\n\rG\u0011!A\u0003\u0006\u0003\u0005\u000b\u0011BAO\u0003Q{'o\u001a\u0013ba\u0006\u001c\u0007.\u001a\u0013ta\u0006\u00148\u000eJ:rY\u0012*\u00070Z2vi&|g\u000eJ:ue\u0016\fW.\u001b8hI\u0019KG.Z*ue\u0016\fWnU8ve\u000e,GeU3f]\u001aKG.Z:NCB$CEZ5mK:\u000bW.Z(oYfDqa\u0016Bb\t\u0003\u0011\u0019\u000e\u0006\u0004\u0003V\n]'\u0011\u001c\t\u0005\u0003W\u0014\u0019\r\u0003\u0005\u0003L\nE\u0007\u0019AA%\u0011!\tIJ!5A\u0002\u0005u\u0005B\u0003Bo\u0005\u0007\u0014\r\u0011\"\u0003\u0003`\u0006\u0019Q.\u00199\u0016\u0005\t\u0005\bc\u0002Br\u0005ST\u0013\u0011^\u0007\u0003\u0005KT1Aa:\u0015\u0003\u0011)H/\u001b7\n\t\t-(Q\u001d\u0002\b\u0011\u0006\u001c\b.T1q\u0011%\u0011yOa1!\u0002\u0013\u0011\t/\u0001\u0003nCB\u0004\u0003B\u0003Bz\u0005\u0007\u0004\r\u0011\"\u0003\u0002h\u0006yA.\u0019;fgR$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0006\u0003x\n\r\u0007\u0019!C\u0005\u0005s\f1\u0003\\1uKN$H+[7fgR\fW\u000e]0%KF$B!!\u0016\u0003|\"Q\u0011Q\fB{\u0003\u0003\u0005\r!!;\t\u0013\t}(1\u0019Q!\n\u0005%\u0018\u0001\u00057bi\u0016\u001cH\u000fV5nKN$\u0018-\u001c9!\u0011)\u0019\u0019Aa1A\u0002\u0013%\u0011q]\u0001\u0013Y\u0006\u001cH\u000fU;sO\u0016$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0006\u0004\b\t\r\u0007\u0019!C\u0005\u0007\u0013\ta\u0003\\1tiB+(oZ3US6,7\u000f^1na~#S-\u001d\u000b\u0005\u0003+\u001aY\u0001\u0003\u0006\u0002^\r\u0015\u0011\u0011!a\u0001\u0003SD\u0011ba\u0004\u0003D\u0002\u0006K!!;\u0002'1\f7\u000f\u001e)ve\u001e,G+[7fgR\fW\u000e\u001d\u0011\t\u0011\rM!1\u0019C\u0005\u0007+\tAc\u001d;sSB\u0004\u0016\r\u001e5JM:+7-Z:tCJLH\u0003\u0002B!\u0007/Aa!KB\t\u0001\u0004Q\u0003\u0006BB\t\u00077\u0001B!!\u0002\u0004\u001e%\u00191q\u0004\u0019\u0003\r%tG.\u001b8f\u0011!\u0019\u0019Ca1\u0005\u0002\r\u0015\u0012aA1eIR1\u0011QKB\u0014\u0007SAa!KB\u0011\u0001\u0004Q\u0003\u0002CAs\u0007C\u0001\r!!;\t\u0011\r5\"1\u0019C\u0001\u0007_\t\u0011\"[:OK^4\u0015\u000e\\3\u0015\r\u0005u5\u0011GB\u001a\u0011\u0019I31\u0006a\u0001U!A\u0011Q]B\u0016\u0001\u0004\tI\u000f\u0003\u0005\u00048\t\rG\u0011\u0001B:\u0003\u0015\u0001XO]4f\u0011!\u0019YDa1\u0005\u0002\t%\u0013\u0001B:ju\u0016D\u0001ba\u0010\u0001A\u0003%\u0011QV\u0001\u000bg\u0016,gNR5mKN\u0004\u0003bBB\"\u0001\u0011%1QI\u0001\u000fM\u0016$8\r['bq>3gm]3u)\t\u00199\u0005E\u0002\u001a\u0007\u0013J1aa\u0013\u0003\u0005Y1\u0015\u000e\\3TiJ,\u0017-\\*pkJ\u001cWm\u00144gg\u0016$\bbBB(\u0001\u0011\u00051\u0011K\u0001\u0013o&$\bNQ1uG\"Lgn\u001a'pG.,G-\u0006\u0003\u0004T\reC\u0003BB+\u0007K\u0002Baa\u0016\u0004Z1\u0001A\u0001CB.\u0007\u001b\u0012\ra!\u0018\u0003\u0003Q\u000bBaa\u0018\u0003RA!\u0011QAB1\u0013\r\u0019\u0019\u0007\r\u0002\b\u001d>$\b.\u001b8h\u0011%\u00199g!\u0014\u0005\u0002\u0004\u0019I'\u0001\u0003gk:\u001c\u0007CBA\u0003\u0007W\u001a)&C\u0002\u0004nA\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b\u0007c\u0002A\u0011AA$\u0003A\u0019WO\u001d:f]RdunZ(gMN,G\u000fC\u0004\u0004v\u0001!\tea\u001e\u0002\u0011\u001d,GOQ1uG\"$ba!\u001f\u0004\u0016\u000e\u0005\u0006\u0003BB>\u0007\u001fsAa! \u0004\u000e:!1qPBF\u001d\u0011\u0019\ti!#\u000f\t\r\r5q\u0011\b\u0004[\r\u0015\u0015\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002L\r%!1\u0011SBJ\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002L\r!A1qSB:\u0001\u0004\u0019I*A\u0003ti\u0006\u0014H\u000f\u0005\u0004\u0002\u0006\u0005-41\u0014\t\u00043\ru\u0015bABP\u0005\t1qJ\u001a4tKRD\u0001ba)\u0004t\u0001\u000711T\u0001\u0004K:$\u0007BCBT\u0001\u0001\u0007I\u0011\u0001\u0004\u0004*\u0006\t2o\\;sG\u0016D\u0015m]'fi\u0006$\u0017\r^1\u0016\u0005\r-\u0006CBA\u0003\u0003W\ni\n\u0003\u0006\u00040\u0002\u0001\r\u0011\"\u0001\u0007\u0007c\u000bQc]8ve\u000e,\u0007*Y:NKR\fG-\u0019;b?\u0012*\u0017\u000f\u0006\u0003\u0002V\rM\u0006BCA/\u0007[\u000b\t\u00111\u0001\u0004,\"A1q\u0017\u0001!B\u0013\u0019Y+\u0001\nt_V\u00148-\u001a%bg6+G/\u00193bi\u0006\u0004\u0003\u0006BB[\u0007w\u0003B!!\u0002\u0004>&\u00191q\u0018\u0019\u0003\u0011Y|G.\u0019;jY\u0016Dqaa1\u0001\t\u0013\u0019)-\u0001\u0010bY24\u0015\u000e\\3t+NLgnZ%o\u001b\u0016lwN]=GS2,\u0017J\u001c3fqR\u00111q\u0019\t\u0005\u000f2\u001bI\rE\u0002{\u0007\u0017L1a!4|\u0005)1\u0015\u000e\\3Ti\u0006$Xo\u001d\u0005\b\u0007#\u0004A\u0011BBc\u0003\u0005\nG\u000e\u001c$jY\u0016\u001cXk]5oO6+G/\u00193bi\u0006dun\u001a$jY\u0016Le\u000eZ3y\u0011\u001d\u0019)\u000e\u0001C\u0005\u0007/\fQBZ3uG\"\fE\u000e\u001c$jY\u0016\u001cHCABm!\u00119Eja7\u0011\u000f\u0005\u00151Q\u001c\u0016\u0002J%\u00191q\u001c\u0019\u0003\rQ+\b\u000f\\33\u0011\u001d\u0019\u0019\u000f\u0001C!\u0007K\f\u0011bZ3u\u001f\u001a47/\u001a;\u0016\u0005\re\u0005b\u0002B<\u0001\u0011\u00053\u0011\u001e\u000b\u0002U!91Q\u001e\u0001\u0005B\r=\u0018AB2p[6LG\u000f\u0006\u0003\u0002V\rE\b\u0002CBR\u0007W\u0004\raa'\t\u000f\rU\b\u0001\"\u0011\u0004x\u0006!1\u000f^8q)\t\t)\u0006")
public class FileStreamSource
implements Source,
Logging {
    private final SparkSession sparkSession;
    private final String path;
    private final String fileFormatClassName;
    private final StructType schema;
    private final Seq<String> partitionColumns;
    private final Map<String, String> options;
    private final FileStreamOptions sourceOptions;
    private final Configuration hadoopConf;
    private final transient FileSystem fs;
    private final Path qualifiedBasePath;
    private final Map<String, String> optionsWithPartitionBasePath;
    private final FileStreamSourceLog metadataLog;
    private long metadataLogCurrentOffset;
    private final Option<Object> maxFilesPerBatch;
    private final Ordering<Object> fileSortOrder;
    private final long maxFileAgeMs;
    private final boolean fileNameOnly;
    private final SeenFilesMap seenFiles;
    private volatile Option<Object> sourceHasMetadata;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public StructType schema() {
        return this.schema;
    }

    private FileStreamOptions sourceOptions() {
        return this.sourceOptions;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private FileSystem fs() {
        return this.fs;
    }

    private Path qualifiedBasePath() {
        return this.qualifiedBasePath;
    }

    private Map<String, String> optionsWithPartitionBasePath() {
        return this.optionsWithPartitionBasePath;
    }

    private FileStreamSourceLog metadataLog() {
        return this.metadataLog;
    }

    private long metadataLogCurrentOffset() {
        return this.metadataLogCurrentOffset;
    }

    private void metadataLogCurrentOffset_$eq(long x$1) {
        this.metadataLogCurrentOffset = x$1;
    }

    private Option<Object> maxFilesPerBatch() {
        return this.maxFilesPerBatch;
    }

    private Ordering<Object> fileSortOrder() {
        return this.fileSortOrder;
    }

    private long maxFileAgeMs() {
        return this.maxFileAgeMs;
    }

    private boolean fileNameOnly() {
        return this.fileNameOnly;
    }

    public SeenFilesMap seenFiles() {
        return this.seenFiles;
    }

    private synchronized FileStreamSourceOffset fetchMaxOffset() {
        Seq newFiles = (Seq)this.fetchAllFiles().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSource.$anonfun$fetchMaxOffset$1(this, x0$1)));
        Seq batchFiles = this.maxFilesPerBatch().nonEmpty() ? (Seq)newFiles.take(BoxesRunTime.unboxToInt((Object)this.maxFilesPerBatch().get())) : newFiles;
        batchFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
            FileStreamSource.$anonfun$fetchMaxOffset$2(this, file);
            return BoxedUnit.UNIT;
        });
        int numPurged = this.seenFiles().purge();
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(177).append("\n         |Number of new files = ").append(newFiles.size()).append("\n         |Number of files selected for batch = ").append(batchFiles.size()).append("\n         |Number of seen files = ").append(this.seenFiles().size()).append("\n         |Number of files purged from tracking map = ").append(numPurged).append("\n       ").toString())).stripMargin());
        if (batchFiles.nonEmpty()) {
            this.metadataLogCurrentOffset_$eq(this.metadataLogCurrentOffset() + 1L);
            this.metadataLog().add(this.metadataLogCurrentOffset(), (FileEntry[])((TraversableOnce)batchFiles.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String p = (String)tuple2._1();
                long timestamp = tuple2._2$mcJ$sp();
                FileEntry fileEntry = new FileEntry(p, timestamp, this.metadataLogCurrentOffset());
                return fileEntry;
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FileEntry.class)));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Log offset set to ").append(this.metadataLogCurrentOffset()).append(" with ").append(batchFiles.size()).append(" new files").toString());
        }
        return new FileStreamSourceOffset(this.metadataLogCurrentOffset());
    }

    public synchronized <T> T withBatchingLocked(Function0<T> func) {
        return (T)func.apply();
    }

    public synchronized long currentLogOffset() {
        return this.metadataLogCurrentOffset();
    }

    @Override
    public Dataset<Row> getBatch(Option<Offset> start, Offset end) {
        long endOffset;
        long startOffset = BoxesRunTime.unboxToLong((Object)start.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)FileStreamSource.$anonfun$getBatch$1(x$2))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
        Predef$.MODULE$.assert(startOffset <= (endOffset = FileStreamSourceOffset$.MODULE$.apply(end).logOffset()));
        FileEntry[] files = (FileEntry[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.metadataLog().get((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(startOffset + 1L))), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)endOffset))))).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3._2())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileEntry.class)));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Processing ").append(files.length).append(" files from ").append(startOffset + 1L).append(":").append(endOffset).toString());
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Files are:\n\t").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).mkString("\n\t")).toString());
        SparkSession x$6 = this.sparkSession;
        Seq x$7 = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)f -> new Path(new URI(f.path())).toString(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        Some x$8 = new Some((Object)this.schema());
        Seq<String> x$9 = this.partitionColumns;
        String x$10 = this.fileFormatClassName;
        Map<String, String> x$11 = this.optionsWithPartitionBasePath();
        Option<BucketSpec> x$12 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$13 = DataSource$.MODULE$.apply$default$8();
        DataSource newDataSource = new DataSource(x$6, x$10, (Seq<String>)x$7, (Option<StructType>)x$8, x$9, x$12, x$11, x$13);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)LogicalRelation$.MODULE$.apply(newDataSource.resolveRelation(false), true));
    }

    public Option<Object> sourceHasMetadata() {
        return this.sourceHasMetadata;
    }

    public void sourceHasMetadata_$eq(Option<Object> x$1) {
        this.sourceHasMetadata = x$1;
    }

    private Seq<FileStatus> allFilesUsingInMemoryFileIndex() {
        Seq globbedPaths = SparkHadoopUtil$.MODULE$.get().globPathIfNecessary(this.fs(), this.qualifiedBasePath());
        InMemoryFileIndex fileIndex = new InMemoryFileIndex(this.sparkSession, (Seq<Path>)globbedPaths, this.options, (Option<StructType>)new Some((Object)new StructType()), InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5());
        return fileIndex.allFiles();
    }

    private Seq<FileStatus> allFilesUsingMetadataLogFileIndex() {
        return new MetadataLogFileIndex(this.sparkSession, this.qualifiedBasePath(), (Option<StructType>)None$.MODULE$).allFiles();
    }

    /*
     * Unable to fully structure code
     */
    private Seq<Tuple2<String, Object>> fetchAllFiles() {
        block13: {
            block12: {
                startTime = System.nanoTime();
                allFiles = null;
                var5_3 = false;
                var6_4 = null;
                var7_5 = this.sourceHasMetadata();
                if (!None$.MODULE$.equals(var7_5)) break block12;
                if (FileStreamSink$.MODULE$.hasMetadata((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.path}))), this.hadoopConf())) {
                    this.sourceHasMetadata_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                    allFiles = this.allFilesUsingMetadataLogFileIndex();
                    v0 = BoxedUnit.UNIT;
                } else {
                    allFiles = this.allFilesUsingInMemoryFileIndex();
                    if (allFiles.isEmpty()) {
                        v0 = BoxedUnit.UNIT;
                    } else if (FileStreamSink$.MODULE$.hasMetadata((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.path}))), this.hadoopConf())) {
                        this.sourceHasMetadata_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                        allFiles = this.allFilesUsingMetadataLogFileIndex();
                        v0 = BoxedUnit.UNIT;
                    } else {
                        this.sourceHasMetadata_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)));
                        v0 = BoxedUnit.UNIT;
                    }
                }
                var1_6 = v0;
                break block13;
            }
            if (!(var7_5 instanceof Some)) ** GOTO lbl-1000
            var5_3 = true;
            var6_4 = (Some)var7_5;
            var8_9 = BoxesRunTime.unboxToBoolean((Object)var6_4.value());
            if (var8_9) {
                allFiles = this.allFilesUsingMetadataLogFileIndex();
                var1_7 = BoxedUnit.UNIT;
            } else if (var5_3 && !(var9_10 = BoxesRunTime.unboxToBoolean((Object)var6_4.value()))) {
                allFiles = this.allFilesUsingInMemoryFileIndex();
                var1_8 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(var7_5);
            }
        }
        files = (Seq)((TraversableLike)allFiles.sortBy((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$fetchAllFiles$1$adapted(org.apache.hadoop.fs.FileStatus ), (Lorg/apache/hadoop/fs/FileStatus;)Ljava/lang/Object;)(), this.fileSortOrder())).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$fetchAllFiles$2(org.apache.hadoop.fs.FileStatus ), (Lorg/apache/hadoop/fs/FileStatus;)Lscala/Tuple2;)(), Seq$.MODULE$.canBuildFrom());
        endTime = System.nanoTime();
        listingTimeMs = ((double)endTime - (double)startTime) / (double)1000000;
        if (listingTimeMs > (double)2000) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fetchAllFiles$3(scala.collection.Seq double ), ()Ljava/lang/String;)((Seq)files, (double)listingTimeMs));
        } else {
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fetchAllFiles$4(scala.collection.Seq double ), ()Ljava/lang/String;)((Seq)files, (double)listingTimeMs));
        }
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fetchAllFiles$5(scala.collection.Seq ), ()Ljava/lang/String;)((Seq)files));
        return files;
    }

    @Override
    public Option<Offset> getOffset() {
        return new Some((Object)this.fetchMaxOffset()).filterNot((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSource.$anonfun$getOffset$1(x$5)));
    }

    public String toString() {
        return new StringBuilder(18).append("FileStreamSource[").append(this.qualifiedBasePath()).append("]").toString();
    }

    @Override
    public void commit(Offset end) {
    }

    @Override
    public void stop() {
    }

    public static final /* synthetic */ void $anonfun$new$2(FileStreamSource $this, FileEntry entry) {
        $this.seenFiles().add(entry.path(), entry.timestamp());
    }

    public static final /* synthetic */ boolean $anonfun$fetchMaxOffset$1(FileStreamSource $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String path = (String)tuple2._1();
        long timestamp = tuple2._2$mcJ$sp();
        boolean bl = $this.seenFiles().isNewFile(path, timestamp);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$fetchMaxOffset$2(FileStreamSource $this, Tuple2 file) {
        $this.seenFiles().add((String)file._1(), file._2$mcJ$sp());
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("New file: ").append(file).toString());
    }

    public static final /* synthetic */ long $anonfun$getBatch$1(Offset x$2) {
        return FileStreamSourceOffset$.MODULE$.apply(x$2).logOffset();
    }

    public static final /* synthetic */ Tuple2 $anonfun$fetchAllFiles$2(FileStatus status) {
        return new Tuple2((Object)status.getPath().toUri().toString(), (Object)BoxesRunTime.boxToLong((long)status.getModificationTime()));
    }

    public static final /* synthetic */ String $anonfun$fetchAllFiles$3(Seq files$2, double listingTimeMs$1) {
        return new StringBuilder(22).append("Listed ").append(files$2.size()).append(" file(s) in ").append(listingTimeMs$1).append(" ms").toString();
    }

    public static final /* synthetic */ String $anonfun$fetchAllFiles$4(Seq files$2, double listingTimeMs$1) {
        return new StringBuilder(22).append("Listed ").append(files$2.size()).append(" file(s) in ").append(listingTimeMs$1).append(" ms").toString();
    }

    public static final /* synthetic */ String $anonfun$fetchAllFiles$5(Seq files$2) {
        return new StringBuilder(12).append("Files are:\n\t").append(files$2.mkString("\n\t")).toString();
    }

    public static final /* synthetic */ boolean $anonfun$getOffset$1(FileStreamSourceOffset x$5) {
        return x$5.logOffset() == -1L;
    }

    public FileStreamSource(SparkSession sparkSession, String path, String fileFormatClassName, StructType schema, Seq<String> partitionColumns, String metadataPath, Map<String, String> options) {
        Ordering ordering;
        this.sparkSession = sparkSession;
        this.path = path;
        this.fileFormatClassName = fileFormatClassName;
        this.schema = schema;
        this.partitionColumns = partitionColumns;
        this.options = options;
        Source.$init$(this);
        Logging.$init$((Logging)this);
        this.sourceOptions = new FileStreamOptions(options);
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
        this.fs = new Path(path).getFileSystem(this.hadoopConf());
        this.qualifiedBasePath = this.fs().makeQualified(new Path(path));
        this.optionsWithPartitionBasePath = this.sourceOptions().optionMapWithoutPath().$plus$plus((GenTraversableOnce)(!SparkHadoopUtil$.MODULE$.get().isGlobPath(new Path(path)) && options.contains((Object)"path") ? Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"basePath"), (Object)path)})) : Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        this.metadataLog = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), sparkSession, metadataPath);
        this.metadataLogCurrentOffset = BoxesRunTime.unboxToLong((Object)this.metadataLog().getLatest().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1._1$mcJ$sp())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
        this.maxFilesPerBatch = this.sourceOptions().maxFilesPerTrigger();
        if (this.sourceOptions().latestFirst()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("'latestFirst' is true. New files will be processed first, which may affect the watermark\n          |value. In addition, 'maxFileAge' will be ignored.")).stripMargin());
            ordering = ((Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Long$.MODULE$)).reverse();
        } else {
            ordering = (Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Long$.MODULE$);
        }
        this.fileSortOrder = ordering;
        this.maxFileAgeMs = this.sourceOptions().latestFirst() && this.maxFilesPerBatch().isDefined() ? Long.MAX_VALUE : this.sourceOptions().maxFileAgeMs();
        this.fileNameOnly = this.sourceOptions().fileNameOnly();
        if (this.fileNameOnly()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "'fileNameOnly' is enabled. Make sure your file names are unique (e.g. using UUID), otherwise, files with the same name but under different paths will be considered the same and causes data lost.");
        }
        this.seenFiles = new SeenFilesMap(this.maxFileAgeMs(), this.fileNameOnly());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.metadataLog().allFiles())).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            FileStreamSource.$anonfun$new$2(this, entry);
            return BoxedUnit.UNIT;
        });
        this.seenFiles().purge();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("maxFilesPerBatch = ").append(this.maxFilesPerBatch()).append(", maxFileAgeMs = ").append(this.maxFileAgeMs()).toString());
        this.sourceHasMetadata = SparkHadoopUtil$.MODULE$.get().isGlobPath(new Path(path)) ? new Some((Object)BoxesRunTime.boxToBoolean((boolean)false)) : None$.MODULE$;
    }

    public static final /* synthetic */ Object $anonfun$fetchAllFiles$1$adapted(FileStatus x$4) {
        return BoxesRunTime.boxToLong((long)x$4.getModificationTime());
    }

    public static class FileEntry
    implements scala.Serializable,
    Product {
        private final String path;
        private final long timestamp;
        private final long batchId;

        public String path() {
            return this.path;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long batchId() {
            return this.batchId;
        }

        public FileEntry copy(String path, long timestamp, long batchId) {
            return new FileEntry(path, timestamp, batchId);
        }

        public String copy$default$1() {
            return this.path();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public long copy$default$3() {
            return this.batchId();
        }

        public String productPrefix() {
            return "FileEntry";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.path();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.timestamp());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.batchId());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FileEntry;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timestamp()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.batchId()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FileEntry)) return false;
            boolean bl = true;
            if (!bl) return false;
            FileEntry fileEntry = (FileEntry)x$1;
            String string = this.path();
            String string2 = fileEntry.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.timestamp() != fileEntry.timestamp()) return false;
            if (this.batchId() != fileEntry.batchId()) return false;
            if (!fileEntry.canEqual(this)) return false;
            return true;
        }

        public FileEntry(String path, long timestamp, long batchId) {
            this.path = path;
            this.timestamp = timestamp;
            this.batchId = batchId;
            Product.$init$((Product)this);
        }
    }

    public static class SeenFilesMap {
        private final long maxAgeMs;
        public final boolean org$apache$spark$sql$execution$streaming$FileStreamSource$SeenFilesMap$$fileNameOnly;
        private final HashMap<String, Object> map;
        private long latestTimestamp;
        private long lastPurgeTimestamp;

        private HashMap<String, Object> map() {
            return this.map;
        }

        private long latestTimestamp() {
            return this.latestTimestamp;
        }

        private void latestTimestamp_$eq(long x$1) {
            this.latestTimestamp = x$1;
        }

        private long lastPurgeTimestamp() {
            return this.lastPurgeTimestamp;
        }

        private void lastPurgeTimestamp_$eq(long x$1) {
            this.lastPurgeTimestamp = x$1;
        }

        private String stripPathIfNecessary(String path) {
            return this.org$apache$spark$sql$execution$streaming$FileStreamSource$SeenFilesMap$$fileNameOnly ? new Path(new URI(path)).getName() : path;
        }

        public void add(String path, long timestamp) {
            block0: {
                this.map().put(this.stripPathIfNecessary(path), BoxesRunTime.boxToLong((long)timestamp));
                if (timestamp <= this.latestTimestamp()) break block0;
                this.latestTimestamp_$eq(timestamp);
            }
        }

        public boolean isNewFile(String path, long timestamp) {
            return timestamp >= this.lastPurgeTimestamp() && !this.map().containsKey(this.stripPathIfNecessary(path));
        }

        /*
         * WARNING - void declaration
         */
        public int purge() {
            void var2_2;
            this.lastPurgeTimestamp_$eq(this.latestTimestamp() - this.maxAgeMs);
            java.util.Iterator<Map.Entry<String, Object>> iter = this.map().entrySet().iterator();
            int count = 0;
            while (iter.hasNext()) {
                Map.Entry<String, Object> entry = iter.next();
                if (BoxesRunTime.unboxToLong((Object)entry.getValue()) >= this.lastPurgeTimestamp()) continue;
                ++count;
                iter.remove();
            }
            return (int)var2_2;
        }

        public int size() {
            return this.map().size();
        }

        public SeenFilesMap(long maxAgeMs, boolean fileNameOnly) {
            this.maxAgeMs = maxAgeMs;
            this.org$apache$spark$sql$execution$streaming$FileStreamSource$SeenFilesMap$$fileNameOnly = fileNameOnly;
            Predef$.MODULE$.require(maxAgeMs >= 0L);
            this.map = new HashMap();
            this.latestTimestamp = 0L;
            this.lastPurgeTimestamp = 0L;
        }
    }
}

