/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.FileCommitProtocol$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormatWriter;
import org.apache.spark.sql.execution.datasources.FileFormatWriter$;
import org.apache.spark.sql.execution.datasources.WriteJobStatsTracker;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog$;
import org.apache.spark.sql.execution.streaming.ManifestFileCommitProtocol;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}t!B\u0001\u0003\u0011\u0003y\u0011A\u0004$jY\u0016\u001cFO]3b[NKgn\u001b\u0006\u0003\u0007\u0011\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u00151\u0011!C3yK\u000e,H/[8o\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001!\t\u0001\u0012#D\u0001\u0003\r\u0015\u0011\"\u0001#\u0001\u0014\u000591\u0015\u000e\\3TiJ,\u0017-\\*j].\u001c2!\u0005\u000b\u001b!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fMB\u00111DH\u0007\u00029)\u0011Q\u0004C\u0001\tS:$XM\u001d8bY&\u0011q\u0004\b\u0002\b\u0019><w-\u001b8h\u0011\u0015\t\u0013\u0003\"\u0001#\u0003\u0019a\u0014N\\5u}Q\tq\u0002C\u0004%#\t\u0007I\u0011A\u0013\u0002\u00175,G/\u00193bi\u0006$\u0015N]\u000b\u0002MA\u0011q\u0005L\u0007\u0002Q)\u0011\u0011FK\u0001\u0005Y\u0006twMC\u0001,\u0003\u0011Q\u0017M^1\n\u00055B#AB*ue&tw\r\u0003\u00040#\u0001\u0006IAJ\u0001\r[\u0016$\u0018\rZ1uC\u0012K'\u000f\t\u0005\u0006cE!\tAM\u0001\fQ\u0006\u001cX*\u001a;bI\u0006$\u0018\rF\u00024m-\u0003\"!\u0006\u001b\n\u0005U2\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006oA\u0002\r\u0001O\u0001\u0005a\u0006$\b\u000eE\u0002:\u0003\u0012s!AO \u000f\u0005mrT\"\u0001\u001f\u000b\u0005ur\u0011A\u0002\u001fs_>$h(C\u0001\u0018\u0013\t\u0001e#A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001b%aA*fc*\u0011\u0001I\u0006\t\u0003\u000b&s!AR$\u0011\u0005m2\u0012B\u0001%\u0017\u0003\u0019\u0001&/\u001a3fM&\u0011QF\u0013\u0006\u0003\u0011ZAQ\u0001\u0014\u0019A\u00025\u000b!\u0002[1e_>\u00048i\u001c8g!\tq5+D\u0001P\u0015\t\u0001\u0016+\u0001\u0003d_:4'B\u0001*\u000b\u0003\u0019A\u0017\rZ8pa&\u0011Ak\u0014\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000bY\u000bB\u0011A,\u00027\u0005t7-Z:u_JL5/T3uC\u0012\fG/\u0019#je\u0016\u001cGo\u001c:z)\r\u0019\u0004l\u0018\u0005\u0006oU\u0003\r!\u0017\t\u00035vk\u0011a\u0017\u0006\u00039F\u000b!AZ:\n\u0005y[&\u0001\u0002)bi\"DQ\u0001T+A\u000253AA\u0005\u0002\u0001CN!\u0001MY3\u001b!\t93-\u0003\u0002eQ\t1qJ\u00196fGR\u0004\"\u0001\u00054\n\u0005\u001d\u0014!\u0001B*j].D\u0001\"\u001b1\u0003\u0002\u0003\u0006IA[\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003W2l\u0011AB\u0005\u0003[\u001a\u0011Ab\u00159be.\u001cVm]:j_:D\u0001b\u000e1\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\ta\u0002\u0014\t\u0011)A\u0005c\u0006Qa-\u001b7f\r>\u0014X.\u0019;\u0011\u0005I,X\"A:\u000b\u0005Q$\u0011a\u00033bi\u0006\u001cx.\u001e:dKNL!A^:\u0003\u0015\u0019KG.\u001a$pe6\fG\u000f\u0003\u0005yA\n\u0005\t\u0015!\u00039\u0003Q\u0001\u0018M\u001d;ji&|gnQ8mk6tg*Y7fg\"A!\u0010\u0019B\u0001B\u0003%10A\u0004paRLwN\\:\u0011\t\u0015cH\tR\u0005\u0003{*\u00131!T1q\u0011\u0015\t\u0003\r\"\u0001\u0000)1\t\t!a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006!\t\u0001\u0002\rC\u0003j}\u0002\u0007!\u000eC\u00038}\u0002\u0007A\tC\u0003q}\u0002\u0007\u0011\u000fC\u0003y}\u0002\u0007\u0001\bC\u0003{}\u0002\u00071\u0010C\u0005\u0002\u0010\u0001\u0014\r\u0011\"\u0003\u0002\u0012\u0005A!-Y:f!\u0006$\b.F\u0001Z\u0011\u001d\t)\u0002\u0019Q\u0001\ne\u000b\u0011BY1tKB\u000bG\u000f\u001b\u0011\t\u0013\u0005e\u0001M1A\u0005\n\u0005E\u0011a\u00027pOB\u000bG\u000f\u001b\u0005\b\u0003;\u0001\u0007\u0015!\u0003Z\u0003!awn\u001a)bi\"\u0004\u0003\"CA\u0011A\n\u0007I\u0011BA\u0012\u0003\u001d1\u0017\u000e\\3M_\u001e,\"!!\n\u0011\u0007A\t9#C\u0002\u0002*\t\u0011\u0011CR5mKN#(/Z1n'&t7\u000eT8h\u0011!\ti\u0003\u0019Q\u0001\n\u0005\u0015\u0012\u0001\u00034jY\u0016dun\u001a\u0011\t\u00111\u0003'\u0019!C\u0005\u0003c)\u0012!\u0014\u0005\b\u0003k\u0001\u0007\u0015!\u0003N\u0003-A\u0017\rZ8pa\u000e{gN\u001a\u0011\t\u000f\u0005e\u0002\r\"\u0003\u0002<\u0005I\"-Y:jG^\u0013\u0018\u000e^3K_\n\u001cF/\u0019;t)J\f7m[3s+\t\ti\u0004E\u0002s\u0003\u007fI1!!\u0011t\u0005e\u0011\u0015m]5d/JLG/\u001a&pEN#\u0018\r^:Ue\u0006\u001c7.\u001a:\t\u000f\u0005\u0015\u0003\r\"\u0011\u0002H\u0005A\u0011\r\u001a3CCR\u001c\u0007\u000e\u0006\u0004\u0002J\u0005=\u0013\u0011\f\t\u0004+\u0005-\u0013bAA'-\t!QK\\5u\u0011!\t\t&a\u0011A\u0002\u0005M\u0013a\u00022bi\u000eD\u0017\n\u001a\t\u0004+\u0005U\u0013bAA,-\t!Aj\u001c8h\u0011!\tY&a\u0011A\u0002\u0005u\u0013\u0001\u00023bi\u0006\u0004B!a\u0018\u0002t9!\u0011\u0011MA9\u001d\u0011\t\u0019'a\u001c\u000f\t\u0005\u0015\u0014Q\u000e\b\u0005\u0003O\nYGD\u0002<\u0003SJ\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011B\u0001!\u0007\u0013\u0011\t)(a\u001e\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u0001!\u0007\u0011\u001d\tY\b\u0019C!\u0003{\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002\t\u0002")
public class FileStreamSink
implements Sink,
Logging {
    private final SparkSession sparkSession;
    private final String path;
    private final FileFormat fileFormat;
    private final Seq<String> partitionColumnNames;
    private final Map<String, String> options;
    private final Path basePath;
    private final Path logPath;
    private final FileStreamSinkLog fileLog;
    private final Configuration hadoopConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean ancestorIsMetadataDirectory(Path path, Configuration configuration) {
        return FileStreamSink$.MODULE$.ancestorIsMetadataDirectory(path, configuration);
    }

    public static boolean hasMetadata(Seq<String> seq, Configuration configuration) {
        return FileStreamSink$.MODULE$.hasMetadata(seq, configuration);
    }

    public static String metadataDir() {
        return FileStreamSink$.MODULE$.metadataDir();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Path basePath() {
        return this.basePath;
    }

    private Path logPath() {
        return this.logPath;
    }

    private FileStreamSinkLog fileLog() {
        return this.fileLog;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private BasicWriteJobStatsTracker basicWriteJobStatsTracker() {
        SerializableConfiguration serializableHadoopConf = new SerializableConfiguration(this.hadoopConf());
        return new BasicWriteJobStatsTracker(serializableHadoopConf, BasicWriteJobStatsTracker$.MODULE$.metrics());
    }

    @Override
    public void addBatch(long batchId, Dataset<Row> data) {
        if (batchId <= BoxesRunTime.unboxToLong((Object)this.fileLog().getLatest().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1._1$mcJ$sp())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L))) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Skipping already committed batch ").append(batchId).toString());
        } else {
            FileCommitProtocol committer = FileCommitProtocol$.MODULE$.instantiate(this.sparkSession.sessionState().conf().streamingFileCommitProtocolClass(), ((Object)BoxesRunTime.boxToLong((long)batchId)).toString(), this.path, FileCommitProtocol$.MODULE$.instantiate$default$4());
            FileCommitProtocol fileCommitProtocol = committer;
            if (fileCommitProtocol instanceof ManifestFileCommitProtocol) {
                ManifestFileCommitProtocol manifestFileCommitProtocol = (ManifestFileCommitProtocol)fileCommitProtocol;
                manifestFileCommitProtocol.setupManifestOptions(this.fileLog(), batchId);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Seq partitionColumns = (Seq)this.partitionColumnNames.map((Function1 & Serializable & scala.Serializable)col -> {
                Function2 nameEquality = data.sparkSession().sessionState().conf().resolver();
                return (Attribute)data.logicalPlan().output().find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FileStreamSink.$anonfun$addBatch$5(nameEquality, col, f))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new RuntimeException(new StringBuilder(38).append("Partition column ").append((String)col).append(" not found in schema ").append(data.schema()).toString());
                });
            }, Seq$.MODULE$.canBuildFrom());
            QueryExecution qe = data.queryExecution();
            FileFormatWriter$.MODULE$.write(this.sparkSession, qe.executedPlan(), this.fileFormat, committer, new FileFormatWriter.OutputSpec(this.path, (Map<Map<String, String>, String>)Predef$.MODULE$.Map().empty(), (Seq<Attribute>)qe.analyzed().output()), this.hadoopConf(), (Seq<Attribute>)partitionColumns, (Option<BucketSpec>)None$.MODULE$, (Seq<WriteJobStatsTracker>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BasicWriteJobStatsTracker[]{this.basicWriteJobStatsTracker()}))), this.options);
        }
    }

    public String toString() {
        return new StringBuilder(10).append("FileSink[").append(this.path).append("]").toString();
    }

    public static final /* synthetic */ boolean $anonfun$addBatch$5(Function2 nameEquality$1, String col$1, Attribute f) {
        return BoxesRunTime.unboxToBoolean((Object)nameEquality$1.apply((Object)f.name(), (Object)col$1));
    }

    public FileStreamSink(SparkSession sparkSession, String path, FileFormat fileFormat, Seq<String> partitionColumnNames, Map<String, String> options) {
        this.sparkSession = sparkSession;
        this.path = path;
        this.fileFormat = fileFormat;
        this.partitionColumnNames = partitionColumnNames;
        this.options = options;
        Logging.$init$((Logging)this);
        this.basePath = new Path(path);
        this.logPath = new Path(this.basePath(), FileStreamSink$.MODULE$.metadataDir());
        this.fileLog = new FileStreamSinkLog(FileStreamSinkLog$.MODULE$.VERSION(), sparkSession, this.logPath().toUri().toString());
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
    }
}

