/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.exchange;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.FutureAction;
import org.apache.spark.MapOutputStatistics;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.ShuffledRowRDD;
import org.apache.spark.sql.execution.exchange.ExchangeCoordinator$;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u0001=\u00111#\u0012=dQ\u0006tw-Z\"p_J$\u0017N\\1u_JT!a\u0001\u0003\u0002\u0011\u0015D8\r[1oO\u0016T!!\u0002\u0004\u0002\u0013\u0015DXmY;uS>t'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0005\u0002\u0011%tG/\u001a:oC2L!a\u0007\r\u0003\u000f1{wmZ5oO\"AQ\u0004\u0001B\u0001B\u0003%a$\u0001\u0012bIZL7o\u001c:z)\u0006\u0014x-\u001a;Q_N$8\u000b[;gM2,\u0017J\u001c9viNK'0\u001a\t\u0003#}I!\u0001\t\n\u0003\t1{gn\u001a\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u0005YR.\u001b8Ok6\u0004vn\u001d;TQV4g\r\\3QCJ$\u0018\u000e^5p]N\u00042!\u0005\u0013'\u0013\t)#C\u0001\u0004PaRLwN\u001c\t\u0003#\u001dJ!\u0001\u000b\n\u0003\u0007%sG\u000fC\u0003+\u0001\u0011\u00051&\u0001\u0004=S:LGO\u0010\u000b\u0004Y9z\u0003CA\u0017\u0001\u001b\u0005\u0011\u0001\"B\u000f*\u0001\u0004q\u0002b\u0002\u0012*!\u0003\u0005\ra\t\u0005\u0007c\u0001\u0001\u000b\u0011\u0002\u001a\u0002\u0013\u0015D8\r[1oO\u0016\u001c\bcA\u001a9u5\tAG\u0003\u00026m\u00059Q.\u001e;bE2,'BA\u001c\u0013\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003sQ\u00121\"\u0011:sCf\u0014UO\u001a4feB\u0011QfO\u0005\u0003y\t\u00111c\u00155vM\u001adW-\u0012=dQ\u0006tw-Z#yK\u000eD\u0001B\u0010\u0001\t\u0006\u0004&IaP\u0001\r]VlW\t_2iC:<Wm]\u000b\u0002M!A\u0011\t\u0001ECB\u0013%!)A\bq_N$8\u000b[;gM2,'\u000b\u0012#t+\u0005\u0019\u0005\u0003\u0002#Ju-k\u0011!\u0012\u0006\u0003\r\u001e\u000bA!\u001e;jY*\t\u0001*\u0001\u0003kCZ\f\u0017B\u0001&F\u0005\ri\u0015\r\u001d\t\u0003\u00196k\u0011\u0001B\u0005\u0003\u001d\u0012\u0011ab\u00155vM\u001adW\r\u001a*poJ#E\t\u0003\u0004Q\u0001\u0001\u0006K!U\u0001\nKN$\u0018.\\1uK\u0012\u0004\"!\u0005*\n\u0005M\u0013\"a\u0002\"p_2,\u0017M\u001c\u0015\u0003\u001fV\u0003\"!\u0005,\n\u0005]\u0013\"\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u000be\u0003A\u0011\u0001.\u0002!I,w-[:uKJ,\u0005p\u00195b]\u001e,GCA._!\t\tB,\u0003\u0002^%\t!QK\\5u\u0011\u0015\u0019\u0001\f1\u0001;Q\u0011A\u0006M[6\u0011\u0005\u0005DW\"\u00012\u000b\u0005\r$\u0017AC2p]\u000e,(O]3oi*\u0011QMZ\u0001\u000bC:tw\u000e^1uS>t'\"A4\u0002\u000b)\fg/\u0019=\n\u0005%\u0014'!C$vCJ$W\r\u001a\"z\u0003\u00151\u0018\r\\;fC\u0005a\u0017\u0001\u0002;iSNDQA\u001c\u0001\u0005\u0002=\f1\"[:FgRLW.\u0019;fIV\t\u0011\u000bC\u0003r\u0001\u0011\u0005!/A\u000ffgRLW.\u0019;f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019:u\u0013:$\u0017nY3t)\t\u0019h\u000fE\u0002\u0012i\u001aJ!!\u001e\n\u0003\u000b\u0005\u0013(/Y=\t\u000b]\u0004\b\u0019\u0001=\u0002'5\f\u0007oT;uaV$8\u000b^1uSN$\u0018nY:\u0011\u0007E!\u0018\u0010\u0005\u0002{w6\t\u0001\"\u0003\u0002}\u0011\t\u0019R*\u00199PkR\u0004X\u000f^*uCRL7\u000f^5dg\")a\u0010\u0001C\u0005\u007f\u00069Bm\\#ti&l\u0017\r^5p]&3g*Z2fgN\f'/\u001f\u000b\u00027\"\"Q\u0010\u00196l\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000f\ta\u0002]8tiNCWO\u001a4mKJ#E\tF\u0002L\u0003\u0013AaaAA\u0002\u0001\u0004Q\u0004bBA\u0007\u0001\u0011\u0005\u0013qB\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011\u0003\t\u0005\u0003'\t\tC\u0004\u0003\u0002\u0016\u0005u\u0001cAA\f%5\u0011\u0011\u0011\u0004\u0006\u0004\u00037q\u0011A\u0002\u001fs_>$h(C\u0002\u0002 I\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0012\u0003K\u0011aa\u0015;sS:<'bAA\u0010%\u001dI\u0011\u0011\u0006\u0002\u0002\u0002#\u0005\u00111F\u0001\u0014\u000bb\u001c\u0007.\u00198hK\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0004[\u00055b\u0001C\u0001\u0003\u0003\u0003E\t!a\f\u0014\u0007\u00055\u0002\u0003C\u0004+\u0003[!\t!a\r\u0015\u0005\u0005-\u0002BCA\u001c\u0003[\t\n\u0011\"\u0001\u0002:\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!a\u000f+\u0007\r\nid\u000b\u0002\u0002@A!\u0011\u0011IA%\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013!C;oG\",7m[3e\u0015\t)'#\u0003\u0003\u0002L\u0005\r#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ExchangeCoordinator
implements Logging {
    private int numExchanges;
    private Map<ShuffleExchangeExec, ShuffledRowRDD> postShuffleRDDs;
    private final long advisoryTargetPostShuffleInputSize;
    private final Option<Object> minNumPostShufflePartitions;
    private final ArrayBuffer<ShuffleExchangeExec> exchanges;
    private volatile boolean estimated;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Option<Object> $lessinit$greater$default$2() {
        return ExchangeCoordinator$.MODULE$.$lessinit$greater$default$2();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int numExchanges$lzycompute() {
        ExchangeCoordinator exchangeCoordinator = this;
        synchronized (exchangeCoordinator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.numExchanges = this.exchanges.size();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.numExchanges;
    }

    private int numExchanges() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.numExchanges$lzycompute() : this.numExchanges;
    }

    private Map<ShuffleExchangeExec, ShuffledRowRDD> postShuffleRDDs$lzycompute() {
        ExchangeCoordinator exchangeCoordinator = this;
        synchronized (exchangeCoordinator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.postShuffleRDDs = new HashMap<ShuffleExchangeExec, ShuffledRowRDD>(this.numExchanges());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.postShuffleRDDs;
    }

    private Map<ShuffleExchangeExec, ShuffledRowRDD> postShuffleRDDs() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.postShuffleRDDs$lzycompute() : this.postShuffleRDDs;
    }

    @GuardedBy(value="this")
    public void registerExchange(ShuffleExchangeExec exchange) {
        ExchangeCoordinator exchangeCoordinator = this;
        synchronized (exchangeCoordinator) {
            this.exchanges.$plus$eq((Object)exchange);
        }
    }

    public boolean isEstimated() {
        return this.estimated;
    }

    public int[] estimatePartitionStartIndices(MapOutputStatistics[] mapOutputStatistics) {
        long l;
        Option<Object> option = this.minNumPostShufflePartitions;
        if (option instanceof Some) {
            Some some = (Some)option;
            int numPartitions = BoxesRunTime.unboxToInt((Object)some.value());
            long totalPostShuffleInputSize = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapOutputStatistics)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)ExchangeCoordinator.$anonfun$estimatePartitionStartIndices$1(x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            long maxPostShuffleInputSize = package$.MODULE$.max((long)package$.MODULE$.ceil((double)totalPostShuffleInputSize / (double)numPartitions), 16L);
            l = package$.MODULE$.min(maxPostShuffleInputSize, this.advisoryTargetPostShuffleInputSize);
        } else if (None$.MODULE$.equals(option)) {
            l = this.advisoryTargetPostShuffleInputSize;
        } else {
            throw new MatchError(option);
        }
        long targetPostShuffleInputSize = l;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("advisoryTargetPostShuffleInputSize: ").append($this.advisoryTargetPostShuffleInputSize).append(", ").append(new StringBuilder(28).append("targetPostShuffleInputSize ").append(targetPostShuffleInputSize).append(".").toString()).toString());
        int[] distinctNumPreShufflePartitions = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapOutputStatistics)).map((Function1 & Serializable & scala.Serializable)stats -> BoxesRunTime.boxToInteger((int)ExchangeCoordinator.$anonfun$estimatePartitionStartIndices$3(stats)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).distinct();
        Predef$.MODULE$.assert(distinctNumPreShufflePartitions.length == 1, (Function0 & Serializable & scala.Serializable)() -> "There should be only one distinct value of the number pre-shuffle partitions among registered Exchange operator.");
        int numPreShufflePartitions = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(distinctNumPreShufflePartitions)).head());
        ArrayBuffer partitionStartIndices = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        partitionStartIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
        long postShuffleInputSize = 0L;
        for (int i = 0; i < numPreShufflePartitions; ++i) {
            long nextShuffleInputSize = 0L;
            for (int j = 0; j < mapOutputStatistics.length; ++j) {
                nextShuffleInputSize += mapOutputStatistics[j].bytesByPartitionId()[i];
            }
            if (i > 0 && postShuffleInputSize + nextShuffleInputSize > targetPostShuffleInputSize) {
                partitionStartIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                postShuffleInputSize = nextShuffleInputSize;
                continue;
            }
            postShuffleInputSize += nextShuffleInputSize;
        }
        return (int[])partitionStartIndices.toArray(ClassTag$.MODULE$.Int());
    }

    @GuardedBy(value="this")
    private synchronized void doEstimationIfNecessary() {
        block3: {
            if (this.estimated) break block3;
            Predef$.MODULE$.assert(this.exchanges.length() == this.numExchanges());
            HashMap<ShuffleExchangeExec, ShuffledRowRDD> newPostShuffleRDDs = new HashMap<ShuffleExchangeExec, ShuffledRowRDD>(this.numExchanges());
            ArrayBuffer shuffleDependencies = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            ArrayBuffer submittedStageFutures = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            for (int i = 0; i < this.numExchanges(); ++i) {
                ShuffleExchangeExec exchange = (ShuffleExchangeExec)this.exchanges.apply(i);
                ShuffleDependency<Object, InternalRow, InternalRow> shuffleDependency = exchange.prepareShuffleDependency();
                shuffleDependencies.$plus$eq(shuffleDependency);
                Object object = shuffleDependency.rdd().partitions().length != 0 ? submittedStageFutures.$plus$eq((Object)exchange.sqlContext().sparkContext().submitMapStage(shuffleDependency)) : BoxedUnit.UNIT;
            }
            MapOutputStatistics[] mapOutputStatistics = new MapOutputStatistics[submittedStageFutures.length()];
            for (int j = 0; j < submittedStageFutures.length(); ++j) {
                mapOutputStatistics[j] = (MapOutputStatistics)((FutureAction)submittedStageFutures.apply(j)).get();
            }
            Predef$.MODULE$.assert(mapOutputStatistics.length <= this.numExchanges());
            int[] partitionStartIndices = mapOutputStatistics.length == 0 ? (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()) : this.estimatePartitionStartIndices(mapOutputStatistics);
            for (int k = 0; k < this.numExchanges(); ++k) {
                ShuffleExchangeExec exchange = (ShuffleExchangeExec)this.exchanges.apply(k);
                ShuffledRowRDD rdd = exchange.preparePostShuffleRDD((ShuffleDependency<Object, InternalRow, InternalRow>)((ShuffleDependency)shuffleDependencies.apply(k)), (Option<int[]>)new Some((Object)partitionStartIndices));
                newPostShuffleRDDs.put(exchange, rdd);
            }
            Predef$.MODULE$.assert(this.postShuffleRDDs().isEmpty());
            Predef$.MODULE$.assert(newPostShuffleRDDs.size() == this.numExchanges());
            this.postShuffleRDDs().putAll(newPostShuffleRDDs);
            this.estimated = true;
        }
    }

    public ShuffledRowRDD postShuffleRDD(ShuffleExchangeExec exchange) {
        this.doEstimationIfNecessary();
        if (!this.postShuffleRDDs().containsKey(exchange)) {
            throw new IllegalStateException(new StringBuilder(49).append("The given ").append(exchange).append(" is not registered in this coordinator.").toString());
        }
        return this.postShuffleRDDs().get(exchange);
    }

    public String toString() {
        return new StringBuilder(49).append("coordinator[target post-shuffle partition size: ").append(this.advisoryTargetPostShuffleInputSize).append("]").toString();
    }

    public static final /* synthetic */ long $anonfun$estimatePartitionStartIndices$1(MapOutputStatistics x$1) {
        return BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$1.bytesByPartitionId())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ int $anonfun$estimatePartitionStartIndices$3(MapOutputStatistics stats) {
        return stats.bytesByPartitionId().length;
    }

    public ExchangeCoordinator(long advisoryTargetPostShuffleInputSize, Option<Object> minNumPostShufflePartitions) {
        this.advisoryTargetPostShuffleInputSize = advisoryTargetPostShuffleInputSize;
        this.minNumPostShufflePartitions = minNumPostShufflePartitions;
        Logging.$init$((Logging)this);
        this.exchanges = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.estimated = false;
    }
}

