/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0001\u0003\u0001E\u0011Q\u0004U1scV,G\u000fV8Ta\u0006\u00148nU2iK6\f7i\u001c8wKJ$XM\u001d\u0006\u0003\u0007\u0011\tq\u0001]1scV,GO\u0003\u0002\u0006\r\u0005YA-\u0019;bg>,(oY3t\u0015\t9\u0001\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\t\u0011e\u0001!\u0011!Q\u0001\ni\tA#Y:tk6,')\u001b8befL5o\u0015;sS:<\u0007CA\n\u001c\u0013\taBCA\u0004C_>dW-\u00198\t\u0011y\u0001!\u0011!Q\u0001\ni\ta#Y:tk6,\u0017J\u001c;:m%\u001bH+[7fgR\fW\u000e\u001d\u0005\u0006A\u0001!\t!I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\t\"S\u0005\u0005\u0002$\u00015\t!\u0001C\u0004\u001a?A\u0005\t\u0019\u0001\u000e\t\u000fyy\u0002\u0013!a\u00015!)\u0001\u0005\u0001C\u0001OQ\u0011!\u0005\u000b\u0005\u0006S\u0019\u0002\rAK\u0001\u0005G>tg\r\u0005\u0002,]5\tAF\u0003\u0002.\u0011\u0005A\u0011N\u001c;fe:\fG.\u0003\u00020Y\t91+\u0015'D_:4\u0007\"\u0002\u0011\u0001\t\u0003\tDC\u0001\u00123\u0011\u0015I\u0003\u00071\u00014!\t!\u0004(D\u00016\u0015\tIcG\u0003\u00028\u0019\u00051\u0001.\u00193p_BL!!O\u001b\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u0015Y\u0004\u0001\"\u0001=\u0003\u001d\u0019wN\u001c<feR$\"!P\"\u0011\u0005y\nU\"A \u000b\u0005\u0001C\u0011!\u0002;za\u0016\u001c\u0018B\u0001\"@\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006\tj\u0002\r!R\u0001\u000ea\u0006\u0014\u0018/^3u'\u000eDW-\\1\u0011\u0005\u0019SU\"A$\u000b\u0005!K\u0015AB:dQ\u0016l\u0017M\u0003\u0002\u0004\u0019%\u00111j\u0012\u0002\f\u001b\u0016\u001c8/Y4f)f\u0004X\rC\u0003<\u0001\u0011%Q\n\u0006\u0002>\u001d\")A\t\u0014a\u0001\u001fB\u0011a\tU\u0005\u0003#\u001e\u0013\u0011b\u0012:pkB$\u0016\u0010]3\t\u000bM\u0003A\u0011\u0001+\u0002\u0019\r|gN^3si\u001aKW\r\u001c3\u0015\u0005UC\u0006C\u0001 W\u0013\t9vH\u0001\u0005ECR\fG+\u001f9f\u0011\u0015I&\u000b1\u0001[\u0003-\u0001\u0018M]9vKR$\u0016\u0010]3\u0011\u0005\u0019[\u0016B\u0001/H\u0005\u0011!\u0016\u0010]3\t\u000by\u0003A\u0011B0\u0002+\r|gN^3siB\u0013\u0018.\\5uSZ,g)[3mIR\u0011Q\u000b\u0019\u0005\u0006Cv\u0003\rAY\u0001\u0006M&,G\u000e\u001a\t\u0003\r\u000eL!\u0001Z$\u0003\u001bA\u0013\u0018.\\5uSZ,G+\u001f9f\u0011\u00151\u0007\u0001\"\u0003h\u0003E\u0019wN\u001c<feR<%o\\;q\r&,G\u000e\u001a\u000b\u0003+\"DQ!Y3A\u0002=CQA\u001b\u0001\u0005\n-\fQ\"[:FY\u0016lWM\u001c;UsB,Gc\u0001\u000em]\")Q.\u001ba\u00015\u0006a!/\u001a9fCR,G\rV=qK\")q.\u001ba\u0001a\u0006Q\u0001/\u0019:f]Rt\u0015-\\3\u0011\u0005EDhB\u0001:w!\t\u0019H#D\u0001u\u0015\t)\b#\u0001\u0004=e>|GOP\u0005\u0003oR\ta\u0001\u0015:fI\u00164\u0017BA={\u0005\u0019\u0019FO]5oO*\u0011q\u000fF\u0004\by\n\t\t\u0011#\u0001~\u0003u\u0001\u0016M]9vKR$vn\u00159be.\u001c6\r[3nC\u000e{gN^3si\u0016\u0014\bCA\u0012\u007f\r\u001d\t!!!A\t\u0002}\u001c\"A \n\t\r\u0001rH\u0011AA\u0002)\u0005i\b\"CA\u0004}F\u0005I\u0011AA\u0005\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0002\u0016\u00045\u000551FAA\b!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005eA#\u0001\u0006b]:|G/\u0019;j_:LA!!\b\u0002\u0014\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005\u0005b0%A\u0005\u0002\u0005%\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#\u0007")
public class ParquetToSparkSchemaConverter {
    private final boolean assumeBinaryIsString;
    private final boolean assumeInt96IsTimestamp;

    public static boolean $lessinit$greater$default$2() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$1() {
        return ParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public StructType convert(MessageType parquetSchema) {
        return this.convert(parquetSchema.asGroupType());
    }

    private StructType convert(GroupType parquetSchema) {
        Buffer fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetSchema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> {
            StructField structField;
            Type.Repetition repetition = field.getRepetition();
            if (Type.Repetition.OPTIONAL.equals(repetition)) {
                structField = new StructField(field.getName(), this.convertField((Type)field), true, StructField$.MODULE$.apply$default$4());
            } else if (Type.Repetition.REQUIRED.equals(repetition)) {
                structField = new StructField(field.getName(), this.convertField((Type)field), false, StructField$.MODULE$.apply$default$4());
            } else if (Type.Repetition.REPEATED.equals(repetition)) {
                ArrayType arrayType = new ArrayType(this.convertField((Type)field), false);
                structField = new StructField(field.getName(), (DataType)arrayType, false, StructField$.MODULE$.apply$default$4());
            } else {
                throw new MatchError((Object)repetition);
            }
            return structField;
        }, Buffer$.MODULE$.canBuildFrom());
        return StructType$.MODULE$.apply((Seq)fields);
    }

    public DataType convertField(Type parquetType) {
        DataType dataType;
        Type type = parquetType;
        if (type instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            dataType = this.convertPrimitiveField(primitiveType);
        } else if (type instanceof GroupType) {
            GroupType groupType = (GroupType)type;
            dataType = this.convertGroupField(groupType.asGroupType());
        } else {
            throw new MatchError((Object)type);
        }
        return dataType;
    }

    /*
     * Unable to fully structure code
     */
    private DataType convertPrimitiveField(PrimitiveType field) {
        block36: {
            block42: {
                block44: {
                    block43: {
                        block41: {
                            block40: {
                                block39: {
                                    block38: {
                                        block37: {
                                            block35: {
                                                typeName = field.getPrimitiveTypeName();
                                                originalType = field.getOriginalType();
                                                var12_4 = typeName;
                                                if (!PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(var12_4)) break block35;
                                                var2_5 = BooleanType$.MODULE$;
                                                break block36;
                                            }
                                            if (!PrimitiveType.PrimitiveTypeName.FLOAT.equals(var12_4)) break block37;
                                            var2_5 = FloatType$.MODULE$;
                                            break block36;
                                        }
                                        if (!PrimitiveType.PrimitiveTypeName.DOUBLE.equals(var12_4)) break block38;
                                        var2_5 = DoubleType$.MODULE$;
                                        break block36;
                                    }
                                    if (!PrimitiveType.PrimitiveTypeName.INT32.equals(var12_4)) break block39;
                                    var13_6 = originalType;
                                    if (OriginalType.INT_8.equals(var13_6)) {
                                        var8_7 = ByteType$.MODULE$;
                                    } else if (OriginalType.INT_16.equals(var13_6)) {
                                        var8_7 = ShortType$.MODULE$;
                                    } else {
                                        var9_8 = OriginalType.INT_32.equals(var13_6) != false ? true : var13_6 == null;
                                        if (var9_8) {
                                            var8_7 = IntegerType$.MODULE$;
                                        } else if (OriginalType.DATE.equals(var13_6)) {
                                            var8_7 = DateType$.MODULE$;
                                        } else if (OriginalType.DECIMAL.equals(var13_6)) {
                                            var8_7 = ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_INT_DIGITS(), field, typeName);
                                        } else {
                                            if (OriginalType.UINT_8.equals(var13_6)) {
                                                throw ParquetToSparkSchemaConverter.typeNotSupported$1(typeName, originalType);
                                            }
                                            if (OriginalType.UINT_16.equals(var13_6)) {
                                                throw ParquetToSparkSchemaConverter.typeNotSupported$1(typeName, originalType);
                                            }
                                            if (OriginalType.UINT_32.equals(var13_6)) {
                                                throw ParquetToSparkSchemaConverter.typeNotSupported$1(typeName, originalType);
                                            }
                                            if (OriginalType.TIME_MILLIS.equals(var13_6)) {
                                                throw ParquetToSparkSchemaConverter.typeNotImplemented$1(typeName, originalType);
                                            }
                                            throw ParquetToSparkSchemaConverter.illegalType$1(typeName, originalType);
                                        }
                                    }
                                    var2_5 = var8_7;
                                    break block36;
                                }
                                if (!PrimitiveType.PrimitiveTypeName.INT64.equals(var12_4)) break block40;
                                var14_9 = originalType;
                                var7_10 = OriginalType.INT_64.equals(var14_9) != false ? true : var14_9 == null;
                                if (var7_10) {
                                    var6_11 = LongType$.MODULE$;
                                } else if (OriginalType.DECIMAL.equals(var14_9)) {
                                    var6_11 = ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_LONG_DIGITS(), field, typeName);
                                } else {
                                    if (OriginalType.UINT_64.equals(var14_9)) {
                                        throw ParquetToSparkSchemaConverter.typeNotSupported$1(typeName, originalType);
                                    }
                                    if (OriginalType.TIMESTAMP_MICROS.equals(var14_9)) {
                                        var6_11 = TimestampType$.MODULE$;
                                    } else if (OriginalType.TIMESTAMP_MILLIS.equals(var14_9)) {
                                        var6_11 = TimestampType$.MODULE$;
                                    } else {
                                        throw ParquetToSparkSchemaConverter.illegalType$1(typeName, originalType);
                                    }
                                }
                                var2_5 = var6_11;
                                break block36;
                            }
                            if (!PrimitiveType.PrimitiveTypeName.INT96.equals(var12_4)) break block41;
                            ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$convertPrimitiveField$2(org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter ), ()Z)((ParquetToSparkSchemaConverter)this), new StringBuilder(61).append("INT96 is not supported unless it's interpreted as timestamp. ").append(new StringBuilder(27).append("Please try to set ").append(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()).append(" to true.").toString()).toString());
                            var2_5 = TimestampType$.MODULE$;
                            break block36;
                        }
                        if (!PrimitiveType.PrimitiveTypeName.BINARY.equals(var12_4)) break block42;
                        var15_12 = false;
                        var16_13 = null;
                        var17_14 = originalType;
                        var5_15 = OriginalType.UTF8.equals(var17_14) != false ? true : (OriginalType.ENUM.equals(var17_14) != false ? true : OriginalType.JSON.equals(var17_14) != false);
                        if (!var5_15) break block43;
                        var4_16 = StringType$.MODULE$;
                        break block44;
                    }
                    if (var17_14 != null) ** GOTO lbl-1000
                    var15_12 = true;
                    var16_13 = var17_14;
                    if (this.assumeBinaryIsString) {
                        var4_16 = StringType$.MODULE$;
                    } else if (var15_12) {
                        var4_16 = BinaryType$.MODULE$;
                    } else if (OriginalType.BSON.equals(var17_14)) {
                        var4_16 = BinaryType$.MODULE$;
                    } else if (OriginalType.DECIMAL.equals(var17_14)) {
                        var4_16 = ParquetToSparkSchemaConverter.makeDecimalType$1(ParquetToSparkSchemaConverter.makeDecimalType$default$1$1(), field, typeName);
                    } else {
                        throw ParquetToSparkSchemaConverter.illegalType$1(typeName, originalType);
                    }
                }
                var2_5 = var4_16;
                break block36;
            }
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(var12_4)) {
                var18_17 = originalType;
                if (!OriginalType.DECIMAL.equals(var18_17)) {
                    if (OriginalType.INTERVAL.equals(var18_17)) {
                        throw ParquetToSparkSchemaConverter.typeNotImplemented$1(typeName, originalType);
                    }
                    throw ParquetToSparkSchemaConverter.illegalType$1(typeName, originalType);
                }
                var3_18 = ParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.maxPrecisionForBytes(field.getTypeLength()), field, typeName);
                var2_5 = var3_18;
            } else {
                throw ParquetToSparkSchemaConverter.illegalType$1(typeName, originalType);
            }
        }
        return var2_5;
    }

    private DataType convertGroupField(GroupType field) {
        return (DataType)Option$.MODULE$.apply((Object)field.getOriginalType()).fold((Function0 & Serializable & scala.Serializable)() -> this.convert(field), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ArrayType arrayType;
            OriginalType originalType = x0$1;
            if (OriginalType.LIST.equals(originalType)) {
                ArrayType arrayType2;
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> field.getFieldCount() == 1, new StringBuilder(18).append("Invalid list type ").append(field).toString());
                Type repeatedType = field.getType(0);
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> repeatedType.isRepetition(Type.Repetition.REPEATED), new StringBuilder(18).append("Invalid list type ").append(field).toString());
                if (this.isElementType(repeatedType, field.getName())) {
                    arrayType2 = new ArrayType(this.convertField(repeatedType), false);
                } else {
                    Type elementType = repeatedType.asGroupType().getType(0);
                    boolean optional = elementType.isRepetition(Type.Repetition.OPTIONAL);
                    arrayType2 = new ArrayType(this.convertField(elementType), optional);
                }
                arrayType = arrayType2;
            } else {
                boolean bl = OriginalType.MAP.equals(originalType) ? true : OriginalType.MAP_KEY_VALUE.equals(originalType);
                if (bl) {
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> field.getFieldCount() == 1 && !field.getType(0).isPrimitive(), new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                    GroupType keyValueType = field.getType(0).asGroupType();
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> keyValueType.isRepetition(Type.Repetition.REPEATED) && keyValueType.getFieldCount() == 2, new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                    Type keyType = keyValueType.getType(0);
                    ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> keyType.isPrimitive(), new StringBuilder(60).append("Map key type is expected to be a primitive type, but found: ").append(keyType).toString());
                    Type valueType = keyValueType.getType(1);
                    boolean valueOptional = valueType.isRepetition(Type.Repetition.OPTIONAL);
                    arrayType = new MapType(this.convertField(keyType), this.convertField(valueType), valueOptional);
                } else {
                    throw new AnalysisException(new StringBuilder(27).append("Unrecognized Parquet type: ").append(field).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
            }
            return arrayType;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isElementType(Type repeatedType, String parentName) {
        if (repeatedType.isPrimitive()) return true;
        if (repeatedType.asGroupType().getFieldCount() > 1) return true;
        String string = repeatedType.getName();
        String string2 = "array";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = repeatedType.getName();
        String string4 = new StringBuilder(6).append(parentName).append("_tuple").toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private static final String typeString$1(PrimitiveType.PrimitiveTypeName typeName$1, OriginalType originalType$1) {
        return originalType$1 == null ? String.valueOf(typeName$1) : new StringBuilder(3).append(typeName$1).append(" (").append(originalType$1).append(")").toString();
    }

    private static final Nothing$ typeNotSupported$1(PrimitiveType.PrimitiveTypeName typeName$1, OriginalType originalType$1) {
        throw new AnalysisException(new StringBuilder(28).append("Parquet type not supported: ").append(ParquetToSparkSchemaConverter.typeString$1(typeName$1, originalType$1)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private static final Nothing$ typeNotImplemented$1(PrimitiveType.PrimitiveTypeName typeName$1, OriginalType originalType$1) {
        throw new AnalysisException(new StringBuilder(32).append("Parquet type not yet supported: ").append(ParquetToSparkSchemaConverter.typeString$1(typeName$1, originalType$1)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private static final Nothing$ illegalType$1(PrimitiveType.PrimitiveTypeName typeName$1, OriginalType originalType$1) {
        throw new AnalysisException(new StringBuilder(22).append("Illegal Parquet type: ").append(ParquetToSparkSchemaConverter.typeString$1(typeName$1, originalType$1)).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private static final DecimalType makeDecimalType$1(int maxPrecision, PrimitiveType field$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        int precision = field$1.getDecimalMetadata().getPrecision();
        int scale = field$1.getDecimalMetadata().getScale();
        ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> maxPrecision == -1 || 1 <= precision && precision <= maxPrecision, new StringBuilder(55).append("Invalid decimal precision: ").append(typeName$1).append(" cannot store ").append(precision).append(" digits (max ").append(maxPrecision).append(")").toString());
        return new DecimalType(precision, scale);
    }

    private static final int makeDecimalType$default$1$1() {
        return -1;
    }

    public static final /* synthetic */ boolean $anonfun$convertPrimitiveField$2(ParquetToSparkSchemaConverter $this) {
        return $this.assumeInt96IsTimestamp;
    }

    public ParquetToSparkSchemaConverter(boolean assumeBinaryIsString, boolean assumeInt96IsTimestamp) {
        this.assumeBinaryIsString = assumeBinaryIsString;
        this.assumeInt96IsTimestamp = assumeInt96IsTimestamp;
    }

    public ParquetToSparkSchemaConverter(SQLConf conf) {
        this(conf.isParquetBinaryAsString(), conf.isParquetINT96AsTimestamp());
    }

    public ParquetToSparkSchemaConverter(Configuration conf) {
        this(new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key()))).toBoolean(), new StringOps(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()))).toBoolean());
    }
}

