/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptionsInRead$;
import org.apache.spark.sql.catalyst.json.JacksonGenerator;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y4Q!\u0001\u0002\u0001\u0005A\u0011\u0001CS:p]>+H\u000f];u/JLG/\u001a:\u000b\u0005\r!\u0011\u0001\u00026t_:T!!\u0002\u0004\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003\u000f!\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005%Q\u0011aA:rY*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xmE\u0002\u0001#U\u0001\"AE\n\u000e\u0003\u0011I!\u0001\u0006\u0003\u0003\u0019=+H\u000f];u/JLG/\u001a:\u0011\u0005YIR\"A\f\u000b\u0005aQ\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005i9\"a\u0002'pO\u001eLgn\u001a\u0005\t9\u0001\u0011\t\u0011)A\u0005=\u0005!\u0001/\u0019;i\u0007\u0001\u0001\"a\b\u0015\u000f\u0005\u00012\u0003CA\u0011%\u001b\u0005\u0011#BA\u0012\u001e\u0003\u0019a$o\\8u})\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\u00051\u0001K]3eK\u001aL!!\u000b\u0016\u0003\rM#(/\u001b8h\u0015\t9C\u0005\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003.\u0003\u001dy\u0007\u000f^5p]N\u0004\"A\f\u001a\u000e\u0003=R!a\u0001\u0019\u000b\u0005EB\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005Mz#a\u0003&T\u001f:{\u0005\u000f^5p]ND\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IAN\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007CA\u001c;\u001b\u0005A$BA\u001d\t\u0003\u0015!\u0018\u0010]3t\u0013\tY\u0004H\u0001\u0006TiJ,8\r\u001e+za\u0016D\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IAP\u0001\bG>tG/\u001a=u!\tyD)D\u0001A\u0015\t\t%)A\u0005nCB\u0014X\rZ;dK*\u00111\tD\u0001\u0007Q\u0006$wn\u001c9\n\u0005\u0015\u0003%A\u0005+bg.\fE\u000f^3naR\u001cuN\u001c;fqRDQa\u0012\u0001\u0005\u0002!\u000ba\u0001P5oSRtD#B%L\u00196s\u0005C\u0001&\u0001\u001b\u0005\u0011\u0001\"\u0002\u000fG\u0001\u0004q\u0002\"\u0002\u0017G\u0001\u0004i\u0003\"B\u001bG\u0001\u00041\u0004\"B\u001fG\u0001\u0004q\u0004b\u0002)\u0001\u0005\u0004%I!U\u0001\tK:\u001cw\u000eZ5oOV\t!\u000b\u0005\u0002T56\tAK\u0003\u0002V-\u000691\r[1sg\u0016$(BA,Y\u0003\rq\u0017n\u001c\u0006\u00023\u0006!!.\u0019<b\u0013\tYFKA\u0004DQ\u0006\u00148/\u001a;\t\ru\u0003\u0001\u0015!\u0003S\u0003%)gnY8eS:<\u0007\u0005C\u0004`\u0001\t\u0007I\u0011\u00021\u0002\r]\u0014\u0018\u000e^3s+\u0005\t\u0007C\u00012f\u001b\u0005\u0019'B\u00013Y\u0003\tIw.\u0003\u0002gG\n\u0011r*\u001e;qkR\u001cFO]3b[^\u0013\u0018\u000e^3s\u0011\u0019A\u0007\u0001)A\u0005C\u00069qO]5uKJ\u0004\u0003B\u00026\u0001A\u0003%1.A\u0002hK:\u0004\"A\f7\n\u00055|#\u0001\u0005&bG.\u001cxN\\$f]\u0016\u0014\u0018\r^8s\u0011\u0015y\u0007\u0001\"\u0011q\u0003\u00159(/\u001b;f)\t\tX\u000f\u0005\u0002sg6\tA%\u0003\u0002uI\t!QK\\5u\u0011\u00151h\u000e1\u0001x\u0003\r\u0011xn\u001e\t\u0003qfl\u0011\u0001M\u0005\u0003uB\u00121\"\u00138uKJt\u0017\r\u001c*po\")A\u0010\u0001C!{\u0006)1\r\\8tKR\t\u0011\u000f")
public class JsonOutputWriter
extends OutputWriter
implements Logging {
    private final String path;
    private final Charset encoding;
    private final OutputStreamWriter writer;
    private final JacksonGenerator gen;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Charset encoding() {
        return this.encoding;
    }

    private OutputStreamWriter writer() {
        return this.writer;
    }

    @Override
    public void write(InternalRow row) {
        this.gen.write(row);
        this.gen.writeLineEnding();
    }

    @Override
    public void close() {
        this.gen.close();
        this.writer().close();
    }

    public JsonOutputWriter(String path, JSONOptions options, StructType dataSchema, TaskAttemptContext context) {
        Charset charset;
        this.path = path;
        Logging.$init$((Logging)this);
        Option option = options.encoding();
        if (option instanceof Some) {
            Some some = (Some)option;
            String charsetName = (String)some.value();
            charset = Charset.forName(charsetName);
        } else if (None$.MODULE$.equals(option)) {
            charset = StandardCharsets.UTF_8;
        } else {
            throw new MatchError((Object)option);
        }
        this.encoding = charset;
        if (JSONOptionsInRead$.MODULE$.blacklist().contains((Object)this.encoding())) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(107).append("The JSON file (").append($this.path).append(") was written in the encoding ").append(this.encoding().displayName()).append(" which can be read back by Spark only if multiLine is enabled.").toString());
        }
        this.writer = CodecStreams$.MODULE$.createOutputStreamWriter((JobContext)context, new Path(path), this.encoding());
        this.gen = new JacksonGenerator((DataType)dataSchema, (Writer)this.writer(), options);
    }
}

