/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.json;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptionsInRead;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource;
import org.apache.spark.sql.execution.datasources.json.JsonDataSource$;
import org.apache.spark.sql.execution.datasources.json.JsonOutputWriter;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function1;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0001\u0003\u0001E\u0011aBS:p]\u001aKG.\u001a$pe6\fGO\u0003\u0002\u0004\t\u0005!!n]8o\u0015\t)a!A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003\u0011I!!\u0006\u0003\u0003'Q+\u0007\u0010\u001e\"bg\u0016$g)\u001b7f\r>\u0014X.\u0019;\u0011\u0005]QR\"\u0001\r\u000b\u0005eA\u0011aB:pkJ\u001cWm]\u0005\u00037a\u0011!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;fe\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011A\u0001\u0005\bE\u0001\u0011\r\u0011\"\u0011$\u0003%\u0019\bn\u001c:u\u001d\u0006lW-F\u0001%!\t)cF\u0004\u0002'YA\u0011qEK\u0007\u0002Q)\u0011\u0011\u0006E\u0001\u0007yI|w\u000e\u001e \u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0002\rA\u0013X\rZ3g\u0013\ty\u0003G\u0001\u0004TiJLgn\u001a\u0006\u0003[)BaA\r\u0001!\u0002\u0013!\u0013AC:i_J$h*Y7fA!)A\u0007\u0001C!k\u0005Y\u0011n]*qY&$\u0018M\u00197f)\u00111$\bQ#\u0011\u0005]BT\"\u0001\u0016\n\u0005eR#a\u0002\"p_2,\u0017M\u001c\u0005\u0006wM\u0002\r\u0001P\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003{yj\u0011\u0001C\u0005\u0003\u007f!\u0011Ab\u00159be.\u001cVm]:j_:DQ!Q\u001aA\u0002\t\u000bqa\u001c9uS>t7\u000f\u0005\u0003&\u0007\u0012\"\u0013B\u0001#1\u0005\ri\u0015\r\u001d\u0005\u0006\rN\u0002\raR\u0001\u0005a\u0006$\b\u000e\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006\u0011am\u001d\u0006\u0003\u00192\ta\u0001[1e_>\u0004\u0018B\u0001(J\u0005\u0011\u0001\u0016\r\u001e5\t\u000bA\u0003A\u0011I)\u0002\u0017%tg-\u001a:TG\",W.\u0019\u000b\u0005%ncV\fE\u00028'VK!\u0001\u0016\u0016\u0003\r=\u0003H/[8o!\t1\u0016,D\u0001X\u0015\tA\u0006\"A\u0003usB,7/\u0003\u0002[/\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000bmz\u0005\u0019\u0001\u001f\t\u000b\u0005{\u0005\u0019\u0001\"\t\u000by{\u0005\u0019A0\u0002\u000b\u0019LG.Z:\u0011\u0007\u0001,\u0007N\u0004\u0002bG:\u0011qEY\u0005\u0002W%\u0011AMK\u0001\ba\u0006\u001c7.Y4f\u0013\t1wMA\u0002TKFT!\u0001\u001a\u0016\u0011\u0005!K\u0017B\u00016J\u0005)1\u0015\u000e\\3Ti\u0006$Xo\u001d\u0005\u0006Y\u0002!\t%\\\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\u0006]F\u0014(p\u001f\t\u0003'=L!\u0001\u001d\u0003\u0003'=+H\u000f];u/JLG/\u001a:GC\u000e$xN]=\t\u000bmZ\u0007\u0019\u0001\u001f\t\u000bM\\\u0007\u0019\u0001;\u0002\u0007)|'\r\u0005\u0002vq6\taO\u0003\u0002x\u0017\u0006IQ.\u00199sK\u0012,8-Z\u0005\u0003sZ\u00141AS8c\u0011\u0015\t5\u000e1\u0001C\u0011\u0015a8\u000e1\u0001V\u0003)!\u0017\r^1TG\",W.\u0019\u0005\u0006}\u0002!\te`\u0001\fEVLG\u000e\u001a*fC\u0012,'\u000f\u0006\t\u0002\u0002\u0005}\u0011\u0011EA\u0012\u0003O\tY#a\u000e\u0002:A9q'a\u0001\u0002\b\u00055\u0011bAA\u0003U\tIa)\u001e8di&|g.\r\t\u0004'\u0005%\u0011bAA\u0006\t\ty\u0001+\u0019:uSRLwN\\3e\r&dW\rE\u0003a\u0003\u001f\t\u0019\"C\u0002\u0002\u0012\u001d\u0014\u0001\"\u0013;fe\u0006$xN\u001d\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u0004\u0005\u0002\u0011\r\fG/\u00197zgRLA!!\b\u0002\u0018\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0015YT\u00101\u0001=\u0011\u0015aX\u00101\u0001V\u0011\u0019\t)# a\u0001+\u0006y\u0001/\u0019:uSRLwN\\*dQ\u0016l\u0017\r\u0003\u0004\u0002*u\u0004\r!V\u0001\u000fe\u0016\fX/\u001b:fIN\u001b\u0007.Z7b\u0011\u001d\ti# a\u0001\u0003_\tqAZ5mi\u0016\u00148\u000f\u0005\u0003aK\u0006E\u0002cA\f\u00024%\u0019\u0011Q\u0007\r\u0003\r\u0019KG\u000e^3s\u0011\u0015\tU\u00101\u0001C\u0011\u001d\tY$ a\u0001\u0003{\t!\u0002[1e_>\u00048i\u001c8g!\u0011\ty$!\u0012\u000e\u0005\u0005\u0005#bAA\"\u0017\u0006!1m\u001c8g\u0013\u0011\t9%!\u0011\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001d\tY\u0005\u0001C!\u0003\u001b\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002I!9\u0011\u0011\u000b\u0001\u0005B\u0005M\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005U\u0003cA\u001c\u0002X%\u0019\u0011\u0011\f\u0016\u0003\u0007%sG\u000fC\u0004\u0002^\u0001!\t%a\u0018\u0002\r\u0015\fX/\u00197t)\r1\u0014\u0011\r\u0005\t\u0003G\nY\u00061\u0001\u0002f\u0005)q\u000e\u001e5feB\u0019q'a\u001a\n\u0007\u0005%$FA\u0002B]fDq!!\u001c\u0001\t\u0003\ny'A\btkB\u0004xN\u001d;ECR\fG+\u001f9f)\u00151\u0014\u0011OA>\u0011!\t\u0019(a\u001bA\u0002\u0005U\u0014\u0001\u00033bi\u0006$\u0016\u0010]3\u0011\u0007Y\u000b9(C\u0002\u0002z]\u0013\u0001\u0002R1uCRK\b/\u001a\u0005\b\u0003{\nY\u00071\u00017\u0003)I7OU3bIB\u000bG\u000f\u001b")
public class JsonFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    private final String shortName;

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        JSONOptionsInRead parsedOptions = new JSONOptionsInRead(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        JsonDataSource jsonDataSource = JsonDataSource$.MODULE$.apply((JSONOptions)parsedOptions);
        return jsonDataSource.isSplitable() && super.isSplitable(sparkSession, options, path);
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        JSONOptionsInRead parsedOptions = new JSONOptionsInRead(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        return JsonDataSource$.MODULE$.apply((JSONOptions)parsedOptions).inferSchema(sparkSession, files, (JSONOptions)parsedOptions);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        Configuration conf = job.getConfiguration();
        JSONOptions parsedOptions = new JSONOptions(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        parsedOptions.compressionCodec().foreach((Function1 & Serializable & scala.Serializable)codec -> {
            CompressionCodecs$.MODULE$.setCodecConfiguration(conf, codec);
            return BoxedUnit.UNIT;
        });
        return new OutputWriterFactory(null, parsedOptions){
            private final JSONOptions parsedOptions$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new JsonOutputWriter(path, this.parsedOptions$1, dataSchema, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(5).append(".json").append(CodecStreams$.MODULE$.getCompressionExtension((JobContext)context)).toString();
            }
            {
                this.parsedOptions$1 = parsedOptions$1;
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        JSONOptionsInRead parsedOptions = new JSONOptionsInRead(options, sparkSession.sessionState().conf().sessionLocalTimeZone(), sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)requiredSchema.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JsonFileFormat.$anonfun$buildReader$1(parsedOptions, x$1))));
        dataSchema.getFieldIndex(parsedOptions.columnNameOfCorruptRecord()).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)corruptFieldIndex -> {
            StructField f = dataSchema.apply(corruptFieldIndex);
            DataType dataType = f.dataType();
            StringType$ stringType$ = StringType$.MODULE$;
            if ((dataType != null ? !dataType.equals(stringType$) : stringType$ != null) || !f.nullable()) {
                throw new AnalysisException("The field for corrupt records must be string type and nullable", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        });
        if (requiredSchema.length() == 1) {
            String string = ((StructField)requiredSchema.head()).name();
            String string2 = parsedOptions.columnNameOfCorruptRecord();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new AnalysisException(new StringBuilder(554).append("Since Spark 2.3, the queries from raw JSON/CSV files are disallowed when the\nreferenced columns only include the internal corrupt record column\n").append("(named _corrupt_record by default). For example:\n").append("spark.read.schema(schema).json(file).filter($\"_corrupt_record\".isNotNull).count()\n").append("and spark.read.schema(schema).json(file).select(\"_corrupt_record\").show().\n").append("Instead, you can cache or save the parsed results and then send the same query.\n").append("For example, val df = spark.read.schema(schema).json(file).cache() and then\n").append("df.filter($\"_corrupt_record\".isNotNull).count().").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        return (Function1 & Serializable & scala.Serializable)file -> {
            JacksonParser parser = new JacksonParser((DataType)actualSchema, (JSONOptions)parsedOptions);
            return JsonDataSource$.MODULE$.apply((JSONOptions)parsedOptions).readFile(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), (PartitionedFile)file, parser, requiredSchema);
        };
    }

    public String toString() {
        return "JSON";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof JsonFileFormat;
    }

    @Override
    public boolean supportDataType(DataType dataType, boolean isReadPath) {
        boolean bl;
        DataType dataType2 = dataType;
        if (dataType2 instanceof AtomicType) {
            bl = true;
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            bl = structType.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)this.supportDataType(f.dataType(), isReadPath)));
        } else if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            DataType elementType = arrayType.elementType();
            bl = this.supportDataType(elementType, isReadPath);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            bl = this.supportDataType(keyType, isReadPath) && this.supportDataType(valueType, isReadPath);
        } else if (dataType2 instanceof UserDefinedType) {
            UserDefinedType userDefinedType = (UserDefinedType)dataType2;
            bl = this.supportDataType(userDefinedType.sqlType(), isReadPath);
        } else {
            bl = dataType2 instanceof NullType;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$buildReader$1(JSONOptionsInRead parsedOptions$2, StructField x$1) {
        String string = x$1.name();
        String string2 = parsedOptions$2.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public JsonFileFormat() {
        this.shortName = "json";
    }
}

