/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.FileNotFoundException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.TaskContext$;
import org.apache.spark.executor.OutputMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.BasicWriteTaskStats;
import org.apache.spark.sql.execution.datasources.WriteTaskStats;
import org.apache.spark.sql.execution.datasources.WriteTaskStatsTracker;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001\u001f\tQ\")Y:jG^\u0013\u0018\u000e^3UCN\\7\u000b^1ugR\u0013\u0018mY6fe*\u00111\u0001B\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u0006\r\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001A1\"\u0004\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/ai\u0011AA\u0005\u00033\t\u0011Qc\u0016:ji\u0016$\u0016m]6Ti\u0006$8\u000f\u0016:bG.,'\u000f\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\u0011\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002 9\t9Aj\\4hS:<\u0007\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005!1m\u001c8g\u0015\t9#\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003S\u0011\u0012QbQ8oM&<WO]1uS>t\u0007\"B\u0016\u0001\t\u0003a\u0013A\u0002\u001fj]&$h\b\u0006\u0002.]A\u0011q\u0003\u0001\u0005\u0006C)\u0002\rA\t\u0005\u0007a\u0001\u0001\u000b\u0015B\u0019\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t!\t\t\"'\u0003\u00024%\t\u0019\u0011J\u001c;\t\rU\u0002\u0001\u0015)\u00032\u0003!qW/\u001c$jY\u0016\u001c\bBB\u001c\u0001A\u0003&\u0011'\u0001\btk\nl\u0017\u000e\u001e;fI\u001aKG.Z:\t\re\u0002\u0001\u0015)\u0003;\u0003!qW/\u001c\"zi\u0016\u001c\bCA\t<\u0013\ta$C\u0001\u0003M_:<\u0007B\u0002 \u0001A\u0003&!(A\u0004ok6\u0014vn^:\t\r\u0001\u0003\u0001\u0015)\u0003B\u0003\u001d\u0019WO\u001d$jY\u0016\u00042!\u0005\"E\u0013\t\u0019%C\u0001\u0004PaRLwN\u001c\t\u0003\u000b2s!A\u0012&\u0011\u0005\u001d\u0013R\"\u0001%\u000b\u0005%s\u0011A\u0002\u001fs_>$h(\u0003\u0002L%\u00051\u0001K]3eK\u001aL!!\u0014(\u0003\rM#(/\u001b8h\u0015\tY%\u0003C\u0003Q\u0001\u0011%\u0011+A\u0006hKR4\u0015\u000e\\3TSj,GC\u0001*T!\r\t\"I\u000f\u0005\u0006)>\u0003\r\u0001R\u0001\tM&dW\rU1uQ\")a\u000b\u0001C!/\u0006aa.Z<QCJ$\u0018\u000e^5p]R\u0011\u0001l\u0017\t\u0003#eK!A\u0017\n\u0003\tUs\u0017\u000e\u001e\u0005\u00069V\u0003\r!X\u0001\u0010a\u0006\u0014H/\u001b;j_:4\u0016\r\\;fgB\u0011a,Y\u0007\u0002?*\u0011\u0001MB\u0001\tG\u0006$\u0018\r\\=ti&\u0011!m\u0018\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003e\u0001\u0011\u0005S-A\u0005oK^\u0014UoY6fiR\u0011\u0001L\u001a\u0005\u0006O\u000e\u0004\r!M\u0001\tEV\u001c7.\u001a;JI\")\u0011\u000e\u0001C!U\u00069a.Z<GS2,GC\u0001-l\u0011\u0015!\u0006\u000e1\u0001E\u0011\u0015i\u0007\u0001\"\u0003o\u0003=\u0019H/\u0019;DkJ\u0014XM\u001c;GS2,G#\u0001-\t\u000bA\u0004A\u0011I9\u0002\r9,wOU8x)\tA&\u000fC\u0003t_\u0002\u0007Q,A\u0002s_^DQ!\u001e\u0001\u0005BY\fQbZ3u\r&t\u0017\r\\*uCR\u001cH#A<\u0011\u0005]A\u0018BA=\u0003\u000599&/\u001b;f)\u0006\u001c8n\u0015;biN\u0004")
public class BasicWriteTaskStatsTracker
implements WriteTaskStatsTracker,
Logging {
    private final Configuration hadoopConf;
    private int numPartitions;
    private int numFiles;
    private int submittedFiles;
    private long numBytes;
    private long numRows;
    private Option<String> curFile;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Option<Object> getFileSize(String filePath) {
        Some some;
        Path path = new Path(filePath);
        FileSystem fs = path.getFileSystem(this.hadoopConf);
        try {
            some = new Some((Object)BoxesRunTime.boxToLong((long)fs.getFileStatus(path).getLen()));
        }
        catch (FileNotFoundException e) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("File ").append(path).append(" is not yet visible").toString(), e);
            some = None$.MODULE$;
        }
        return some;
    }

    @Override
    public void newPartition(InternalRow partitionValues) {
        ++this.numPartitions;
    }

    @Override
    public void newBucket(int bucketId) {
    }

    @Override
    public void newFile(String filePath) {
        this.statCurrentFile();
        this.curFile = new Some((Object)filePath);
        ++this.submittedFiles;
    }

    private void statCurrentFile() {
        this.curFile.foreach((Function1 & Serializable & scala.Serializable)path -> {
            BasicWriteTaskStatsTracker.$anonfun$statCurrentFile$1(this, path);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void newRow(InternalRow row) {
        ++this.numRows;
    }

    @Override
    public WriteTaskStats getFinalStats() {
        this.statCurrentFile();
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.taskMetrics().outputMetrics()).foreach((Function1 & Serializable & scala.Serializable)outputMetrics -> {
            BasicWriteTaskStatsTracker.$anonfun$getFinalStats$2(this, outputMetrics);
            return BoxedUnit.UNIT;
        });
        if (this.submittedFiles != this.numFiles) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(153).append("Expected ").append($this.submittedFiles).append(" files, but only saw ").append($this.numFiles).append(". ").append("This could be due to the output format not writing empty files, ").append("or files being not immediately visible in the filesystem.").toString());
        }
        return new BasicWriteTaskStats(this.numPartitions, this.numFiles, this.numBytes, this.numRows);
    }

    public static final /* synthetic */ void $anonfun$statCurrentFile$1(BasicWriteTaskStatsTracker $this, String path) {
        $this.getFileSize(path).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)len -> {
            $this.numBytes += len;
            ++$this.numFiles;
        });
        $this.curFile = None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$getFinalStats$2(BasicWriteTaskStatsTracker $this, OutputMetrics outputMetrics) {
        outputMetrics.setBytesWritten($this.numBytes);
        outputMetrics.setRecordsWritten($this.numRows);
    }

    public BasicWriteTaskStatsTracker(Configuration hadoopConf) {
        this.hadoopConf = hadoopConf;
        Logging.$init$((Logging)this);
        this.numPartitions = 0;
        this.numFiles = 0;
        this.submittedFiles = 0;
        this.numBytes = 0L;
        this.numRows = 0L;
        this.curFile = None$.MODULE$;
    }
}

