/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.AlterTableSerDePropertiesCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001B\u0001\u0003\u0001>\u0011\u0001%\u00117uKJ$\u0016M\u00197f'\u0016\u0014H)\u001a)s_B,'\u000f^5fg\u000e{W.\\1oI*\u00111\u0001B\u0001\bG>lW.\u00198e\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0005\u000e\u001fIA\u0011\u0011\u0003G\u0007\u0002%)\u00111\u0003F\u0001\bY><\u0017nY1m\u0015\t)b#A\u0003qY\u0006t7O\u0003\u0002\u0018\r\u0005A1-\u0019;bYf\u001cH/\u0003\u0002\u001a%\tYAj\\4jG\u0006d\u0007\u000b\\1o!\tYB$D\u0001\u0003\u0013\ti\"AA\bSk:t\u0017M\u00197f\u0007>lW.\u00198e!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u001d\u0001&o\u001c3vGR\u0004\"aH\u0013\n\u0005\u0019\u0002#\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u0015\u0001\u0005+\u0007I\u0011A\u0015\u0002\u0013Q\f'\r\\3OC6,W#\u0001\u0016\u0011\u0005-bS\"\u0001\f\n\u000552\"a\u0004+bE2,\u0017\nZ3oi&4\u0017.\u001a:\t\u0011=\u0002!\u0011#Q\u0001\n)\n!\u0002^1cY\u0016t\u0015-\\3!\u0011!\t\u0004A!f\u0001\n\u0003\u0011\u0014AD:fe\u0012,7\t\\1tg:\u000bW.Z\u000b\u0002gA\u0019q\u0004\u000e\u001c\n\u0005U\u0002#AB(qi&|g\u000e\u0005\u00028}9\u0011\u0001\b\u0010\t\u0003s\u0001j\u0011A\u000f\u0006\u0003w9\ta\u0001\u0010:p_Rt\u0014BA\u001f!\u0003\u0019\u0001&/\u001a3fM&\u0011q\b\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005u\u0002\u0003\u0002\u0003\"\u0001\u0005#\u0005\u000b\u0011B\u001a\u0002\u001fM,'\u000fZ3DY\u0006\u001c8OT1nK\u0002B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!R\u0001\u0010g\u0016\u0014H-\u001a)s_B,'\u000f^5fgV\ta\tE\u0002 i\u001d\u0003Ba\u000e%7m%\u0011\u0011\n\u0011\u0002\u0004\u001b\u0006\u0004\b\u0002C&\u0001\u0005#\u0005\u000b\u0011\u0002$\u0002!M,'\u000fZ3Qe>\u0004XM\u001d;jKN\u0004\u0003\u0002C'\u0001\u0005+\u0007I\u0011\u0001(\u0002\u0011A\f'\u000f^*qK\u000e,\u0012a\u0014\t\u0004?Q\u0002\u0006CA)c\u001d\t\u0011vL\u0004\u0002T;:\u0011A\u000b\u0018\b\u0003+ns!A\u0016.\u000f\u0005]KfBA\u001dY\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011qCB\u0005\u0003=Z\tqaY1uC2|w-\u0003\u0002aC\u0006a1)\u0019;bY><G+\u001f9fg*\u0011aLF\u0005\u0003G\u0012\u0014!\u0003V1cY\u0016\u0004\u0016M\u001d;ji&|gn\u00159fG*\u0011\u0001-\u0019\u0005\tM\u0002\u0011\t\u0012)A\u0005\u001f\u0006I\u0001/\u0019:u'B,7\r\t\u0005\u0006Q\u0002!\t![\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b)\\G.\u001c8\u0011\u0005m\u0001\u0001\"\u0002\u0015h\u0001\u0004Q\u0003\"B\u0019h\u0001\u0004\u0019\u0004\"\u0002#h\u0001\u00041\u0005\"B'h\u0001\u0004y\u0005\"\u00029\u0001\t\u0003\n\u0018a\u0001:v]R\u0011!o \t\u0004gb\\hB\u0001;w\u001d\tIT/C\u0001\"\u0013\t9\b%A\u0004qC\u000e\\\u0017mZ3\n\u0005eT(aA*fc*\u0011q\u000f\t\t\u0003yvl\u0011AB\u0005\u0003}\u001a\u00111AU8x\u0011\u001d\t\ta\u001ca\u0001\u0003\u0007\tAb\u001d9be.\u001cVm]:j_:\u00042\u0001`A\u0003\u0013\r\t9A\u0002\u0002\r'B\f'o[*fgNLwN\u001c\u0005\n\u0003\u0017\u0001\u0011\u0011!C\u0001\u0003\u001b\tAaY8qsRI!.a\u0004\u0002\u0012\u0005M\u0011Q\u0003\u0005\tQ\u0005%\u0001\u0013!a\u0001U!A\u0011'!\u0003\u0011\u0002\u0003\u00071\u0007\u0003\u0005E\u0003\u0013\u0001\n\u00111\u0001G\u0011!i\u0015\u0011\u0002I\u0001\u0002\u0004y\u0005\"CA\r\u0001E\u0005I\u0011AA\u000e\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\b+\u0007)\nyb\u000b\u0002\u0002\"A!\u00111EA\u0017\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012!C;oG\",7m[3e\u0015\r\tY\u0003I\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0018\u0003K\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t\u0019\u0004AI\u0001\n\u0003\t)$\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005]\"fA\u001a\u0002 !I\u00111\b\u0001\u0012\u0002\u0013\u0005\u0011QH\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\tyDK\u0002G\u0003?A\u0011\"a\u0011\u0001#\u0003%\t!!\u0012\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\t\u0016\u0004\u001f\u0006}\u0001\"CA&\u0001\u0005\u0005I\u0011IA'\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\n\t\u0005\u0003#\nY&\u0004\u0002\u0002T)!\u0011QKA,\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0013\u0001\u00026bm\u0006L1aPA*\u0011%\ty\u0006AA\u0001\n\u0003\t\t'\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002dA\u0019q$!\u001a\n\u0007\u0005\u001d\u0004EA\u0002J]RD\u0011\"a\u001b\u0001\u0003\u0003%\t!!\u001c\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qNA;!\ry\u0012\u0011O\u0005\u0004\u0003g\u0002#aA!os\"Q\u0011qOA5\u0003\u0003\u0005\r!a\u0019\u0002\u0007a$\u0013\u0007C\u0005\u0002|\u0001\t\t\u0011\"\u0011\u0002~\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0000A1\u0011\u0011QAD\u0003_j!!a!\u000b\u0007\u0005\u0015\u0005%\u0001\u0006d_2dWm\u0019;j_:LA!!#\u0002\u0004\nA\u0011\n^3sCR|'\u000fC\u0005\u0002\u000e\u0002\t\t\u0011\"\u0001\u0002\u0010\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0012\u0006]\u0005cA\u0010\u0002\u0014&\u0019\u0011Q\u0013\u0011\u0003\u000f\t{w\u000e\\3b]\"Q\u0011qOAF\u0003\u0003\u0005\r!a\u001c\t\u0013\u0005m\u0005!!A\u0005B\u0005u\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0012\u0006}\u0005BCA<\u00033\u000b\t\u00111\u0001\u0002p\u001dI\u00111\u0015\u0002\u0002\u0002#\u0005\u0011QU\u0001!\u00032$XM\u001d+bE2,7+\u001a:EKB\u0013x\u000e]3si&,7oQ8n[\u0006tG\rE\u0002\u001c\u0003O3\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011\u0011V\n\u0006\u0003O\u000bY\u000b\n\t\n\u0003[\u000b\u0019LK\u001aG\u001f*l!!a,\u000b\u0007\u0005E\u0006%A\u0004sk:$\u0018.\\3\n\t\u0005U\u0016q\u0016\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$\u0004b\u00025\u0002(\u0012\u0005\u0011\u0011\u0018\u000b\u0003\u0003KC!\"!0\u0002(\u0006\u0005IQIA`\u0003!!xn\u0015;sS:<GCAA(\u0011)\t\u0019-a*\u0002\u0002\u0013\u0005\u0015QY\u0001\u0006CB\u0004H.\u001f\u000b\nU\u0006\u001d\u0017\u0011ZAf\u0003\u001bDa\u0001KAa\u0001\u0004Q\u0003BB\u0019\u0002B\u0002\u00071\u0007\u0003\u0004E\u0003\u0003\u0004\rA\u0012\u0005\u0007\u001b\u0006\u0005\u0007\u0019A(\t\u0015\u0005E\u0017qUA\u0001\n\u0003\u000b\u0019.A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005U\u0017Q\u001c\t\u0005?Q\n9\u000eE\u0004 \u00033T3GR(\n\u0007\u0005m\u0007E\u0001\u0004UkBdW\r\u000e\u0005\n\u0003?\fy-!AA\u0002)\f1\u0001\u001f\u00131\u0011)\t\u0019/a*\u0002\u0002\u0013%\u0011Q]\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002hB!\u0011\u0011KAu\u0013\u0011\tY/a\u0015\u0003\r=\u0013'.Z2u\u0001")
public class AlterTableSerDePropertiesCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final TableIdentifier tableName;
    private final Option<String> serdeClassName;
    private final Option<Map<String, String>> serdeProperties;
    private final Option<Map<String, String>> partSpec;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<TableIdentifier, Option<String>, Option<Map<String, String>>, Option<Map<String, String>>>> unapply(AlterTableSerDePropertiesCommand alterTableSerDePropertiesCommand) {
        return AlterTableSerDePropertiesCommand$.MODULE$.unapply(alterTableSerDePropertiesCommand);
    }

    public static Function1<Tuple4<TableIdentifier, Option<String>, Option<Map<String, String>>, Option<Map<String, String>>>, AlterTableSerDePropertiesCommand> tupled() {
        return AlterTableSerDePropertiesCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Option<String>, Function1<Option<Map<String, String>>, Function1<Option<Map<String, String>>, AlterTableSerDePropertiesCommand>>>> curried() {
        return AlterTableSerDePropertiesCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableSerDePropertiesCommand alterTableSerDePropertiesCommand = this;
        synchronized (alterTableSerDePropertiesCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public Option<String> serdeClassName() {
        return this.serdeClassName;
    }

    public Option<Map<String, String>> serdeProperties() {
        return this.serdeProperties;
    }

    public Option<Map<String, String>> partSpec() {
        return this.partSpec;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable table = catalog.getTableMetadata(this.tableName());
        DDLUtils$.MODULE$.verifyAlterTableType(catalog, table, false);
        if (this.partSpec().isDefined() && DDLUtils$.MODULE$.isDatasourceTable(table)) {
            throw new AnalysisException("Operation not allowed: ALTER TABLE SET [SERDE | SERDEPROPERTIES] for a specific partition is not supported for tables created with the datasource API", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (this.serdeClassName().isDefined() && DDLUtils$.MODULE$.isDatasourceTable(table)) {
            throw new AnalysisException("Operation not allowed: ALTER TABLE SET SERDE is not supported for tables created with the datasource API", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (this.partSpec().isEmpty()) {
            Option x$67 = this.serdeClassName().orElse((Function0 & Serializable & scala.Serializable)() -> table.storage().serde());
            Map x$68 = table.storage().properties().$plus$plus((GenTraversableOnce)this.serdeProperties().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
            Option x$69 = table.withNewStorage$default$1();
            Option x$70 = table.withNewStorage$default$2();
            Option x$71 = table.withNewStorage$default$3();
            boolean x$72 = table.withNewStorage$default$4();
            CatalogTable newTable = table.withNewStorage(x$69, x$70, x$71, x$72, x$67, x$68);
            catalog.alterTable(newTable);
        } else {
            Map spec = (Map)this.partSpec().get();
            CatalogTablePartition part = catalog.getPartition(table.identifier(), spec);
            Option x$73 = this.serdeClassName().orElse((Function0 & Serializable & scala.Serializable)() -> part.storage().serde());
            Map x$74 = part.storage().properties().$plus$plus((GenTraversableOnce)this.serdeProperties().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
            Option x$75 = part.storage().copy$default$1();
            Option x$76 = part.storage().copy$default$2();
            Option x$77 = part.storage().copy$default$3();
            boolean x$78 = part.storage().copy$default$5();
            CatalogStorageFormat x$79 = part.storage().copy(x$75, x$76, x$77, x$73, x$78, x$74);
            Map x$80 = part.copy$default$1();
            Map x$81 = part.copy$default$3();
            long x$82 = part.copy$default$4();
            long x$83 = part.copy$default$5();
            Option x$84 = part.copy$default$6();
            CatalogTablePartition newPart = part.copy(x$80, x$79, x$81, x$82, x$83, x$84);
            catalog.alterPartitions(table.identifier(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{newPart})));
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public AlterTableSerDePropertiesCommand copy(TableIdentifier tableName, Option<String> serdeClassName, Option<Map<String, String>> serdeProperties, Option<Map<String, String>> partSpec) {
        return new AlterTableSerDePropertiesCommand(tableName, serdeClassName, serdeProperties, partSpec);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public Option<String> copy$default$2() {
        return this.serdeClassName();
    }

    public Option<Map<String, String>> copy$default$3() {
        return this.serdeProperties();
    }

    public Option<Map<String, String>> copy$default$4() {
        return this.partSpec();
    }

    public String productPrefix() {
        return "AlterTableSerDePropertiesCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.tableName();
                break;
            }
            case 1: {
                option = this.serdeClassName();
                break;
            }
            case 2: {
                option = this.serdeProperties();
                break;
            }
            case 3: {
                option = this.partSpec();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableSerDePropertiesCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableSerDePropertiesCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableSerDePropertiesCommand alterTableSerDePropertiesCommand = (AlterTableSerDePropertiesCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableSerDePropertiesCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Option<String> option = this.serdeClassName();
        Option<String> option2 = alterTableSerDePropertiesCommand.serdeClassName();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Map<String, String>> option3 = this.serdeProperties();
        Option<Map<String, String>> option4 = alterTableSerDePropertiesCommand.serdeProperties();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Map<String, String>> option5 = this.partSpec();
        Option<Map<String, String>> option6 = alterTableSerDePropertiesCommand.partSpec();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        if (!alterTableSerDePropertiesCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableSerDePropertiesCommand(TableIdentifier tableName, Option<String> serdeClassName, Option<Map<String, String>> serdeProperties, Option<Map<String, String>> partSpec) {
        this.tableName = tableName;
        this.serdeClassName = serdeClassName;
        this.serdeProperties = serdeProperties;
        this.partSpec = partSpec;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        Predef$.MODULE$.require(serdeClassName.isDefined() || serdeProperties.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "ALTER TABLE attempted to set neither serde class name nor serde properties");
    }
}

