/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.columnar.ByteBufferHelper$;
import org.apache.spark.sql.execution.columnar.ColumnType;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.compression.LongDelta$;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.LongType$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t\u0015qAB\u0001\u0003\u0011\u0003#\u0001#A\u0005M_:<G)\u001a7uC*\u00111\u0001B\u0001\fG>l\u0007O]3tg&|gN\u0003\u0002\u0006\r\u0005A1m\u001c7v[:\f'O\u0003\u0002\b\u0011\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u0013)\t1a]9m\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<\u0007CA\t\u0013\u001b\u0005\u0011aAB\n\u0003\u0011\u0003#ACA\u0005M_:<G)\u001a7uCN)!#F\u000e\u001fCA\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\u0004\"!\u0005\u000f\n\u0005u\u0011!!E\"p[B\u0014Xm]:j_:\u001c6\r[3nKB\u0011acH\u0005\u0003A]\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0017E%\u00111e\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006KI!\taJ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t\u0001\u0003C\u0003*%\u0011\u0005#&\u0001\u0004usB,\u0017\nZ\u000b\u0002WA\u0011a\u0003L\u0005\u0003[]\u00111!\u00138u\u0011\u0015y#\u0003\"\u00111\u0003\u001d!WmY8eKJ,\"!M\u001c\u0015\u0007I\u001aU\nE\u0002\u0012gUJ!\u0001\u000e\u0002\u0003\u000f\u0011+7m\u001c3feB\u0011ag\u000e\u0007\u0001\t\u0015AdF1\u0001:\u0005\u0005!\u0016C\u0001\u001e>!\t12(\u0003\u0002=/\t9aj\u001c;iS:<\u0007C\u0001 B\u001b\u0005y$B\u0001!\t\u0003\u0015!\u0018\u0010]3t\u0013\t\u0011uH\u0001\u0006Bi>l\u0017n\u0019+za\u0016DQ\u0001\u0012\u0018A\u0002\u0015\u000baAY;gM\u0016\u0014\bC\u0001$L\u001b\u00059%B\u0001%J\u0003\rq\u0017n\u001c\u0006\u0002\u0015\u0006!!.\u0019<b\u0013\tauI\u0001\u0006CsR,')\u001e4gKJDQA\u0014\u0018A\u0002=\u000b!bY8mk6tG+\u001f9f!\r\u0001\u0016+N\u0007\u0002\t%\u0011!\u000b\u0002\u0002\u0011\u001d\u0006$\u0018N^3D_2,XN\u001c+za\u0016DQ\u0001\u0016\n\u0005BU\u000bq!\u001a8d_\u0012,'/\u0006\u0002W7R\u0011q\u000b\u0018\t\u0004#aS\u0016BA-\u0003\u0005\u001d)enY8eKJ\u0004\"AN.\u0005\u000ba\u001a&\u0019A\u001d\t\u000b9\u001b\u0006\u0019A/\u0011\u0007A\u000b&\fC\u0003`%\u0011\u0005\u0003-\u0001\u0005tkB\u0004xN\u001d;t)\t\tG\r\u0005\u0002\u0017E&\u00111m\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015qe\f1\u0001fa\t1'\u000eE\u0002QO&L!\u0001\u001b\u0003\u0003\u0015\r{G.^7o)f\u0004X\r\u0005\u00027U\u0012I1\u000eZA\u0001\u0002\u0003\u0015\t\u0001\u001c\u0002\u0004?\u00122\u0014C\u0001\u001en!\t1b.\u0003\u0002p/\t\u0019\u0011I\\=\u0007\te\u0013\u0002!]\n\u0004aV\u0011\bcA\tYg:\u0011a\b^\u0005\u0003k~\n\u0001\u0002T8oORK\b/\u001a\u0005\u0006KA$\ta\u001e\u000b\u0002qB\u0011\u0011\u0010]\u0007\u0002%!91\u0010\u001da\u0001\n#Q\u0013aD0d_6\u0004(/Z:tK\u0012\u001c\u0016N_3\t\u000fu\u0004\b\u0019!C\t}\u0006\u0019rlY8naJ,7o]3e'&TXm\u0018\u0013fcR\u0019q0!\u0002\u0011\u0007Y\t\t!C\u0002\u0002\u0004]\u0011A!\u00168ji\"A\u0011q\u0001?\u0002\u0002\u0003\u00071&A\u0002yIEBq!a\u0003qA\u0003&1&\u0001\t`G>l\u0007O]3tg\u0016$7+\u001b>fA!A\u0011q\u00029A\u0002\u0013E!&A\t`k:\u001cw.\u001c9sKN\u001cX\rZ*ju\u0016D\u0011\"a\u0005q\u0001\u0004%\t\"!\u0006\u0002+}+hnY8naJ,7o]3e'&TXm\u0018\u0013fcR\u0019q0a\u0006\t\u0013\u0005\u001d\u0011\u0011CA\u0001\u0002\u0004Y\u0003bBA\u000ea\u0002\u0006KaK\u0001\u0013?Vt7m\\7qe\u0016\u001c8/\u001a3TSj,\u0007\u0005\u0003\u0004\u0002 A$\tEK\u0001\u000fG>l\u0007O]3tg\u0016$7+\u001b>f\u0011\u0019\t\u0019\u0003\u001dC!U\u0005\u0001RO\\2p[B\u0014Xm]:fINK'0\u001a\u0005\f\u0003O\u0001\b\u0019!a\u0001\n\u0013\tI#A\u0005qe\u00164h+\u00197vKV\u0011\u00111\u0006\t\u0004-\u00055\u0012bAA\u0018/\t!Aj\u001c8h\u0011-\t\u0019\u0004\u001da\u0001\u0002\u0004%I!!\u000e\u0002\u001bA\u0014XM\u001e,bYV,w\fJ3r)\ry\u0018q\u0007\u0005\u000b\u0003\u000f\t\t$!AA\u0002\u0005-\u0002bCA\u001ea\u0002\u0007\t\u0011)Q\u0005\u0003W\t!\u0002\u001d:fmZ\u000bG.^3!\u0011\u001d\ty\u0004\u001dC!\u0003\u0003\n!dZ1uQ\u0016\u00148i\\7qe\u0016\u001c8/\u001b2jY&$\u0018p\u0015;biN$Ra`A\"\u0003'B\u0001\"!\u0012\u0002>\u0001\u0007\u0011qI\u0001\u0004e><\b\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055\u0003\"\u0001\u0005dCR\fG._:u\u0013\u0011\t\t&a\u0013\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\b\u0003+\ni\u00041\u0001,\u0003\u001dy'\u000fZ5oC2Dq!!\u0017q\t\u0003\nY&\u0001\u0005d_6\u0004(/Z:t)\u0015)\u0015QLA1\u0011\u001d\ty&a\u0016A\u0002\u0015\u000bAA\u001a:p[\"9\u00111MA,\u0001\u0004)\u0015A\u0001;p\r\u0015!$\u0003AA4'\u0015\t)'FA5!\r\t2g\u001d\u0005\n\t\u0006\u0015$\u0011!Q\u0001\n\u0015C!BTA3\u0005\u0003\u0005\u000b\u0011BA8!\r\u0001\u0016k\u001d\u0005\bK\u0005\u0015D\u0011AA:)\u0019\t)(a\u001e\u0002zA\u0019\u00110!\u001a\t\r\u0011\u000b\t\b1\u0001F\u0011\u001dq\u0015\u0011\u000fa\u0001\u0003_BA\"! \u0002f\u0001\u0007\t\u0019!C\u0005\u0003S\tA\u0001\u001d:fm\"a\u0011\u0011QA3\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0004\u0006A\u0001O]3w?\u0012*\u0017\u000fF\u0002\u0000\u0003\u000bC!\"a\u0002\u0002\u0000\u0005\u0005\t\u0019AA\u0016\u00111\tI)!\u001aA\u0002\u0003\u0005\u000b\u0015BA\u0016\u0003\u0015\u0001(/\u001a<!\u0011!\ti)!\u001a\u0005B\u0005=\u0015a\u00025bg:+\u0007\u0010^\u000b\u0002C\"A\u00111SA3\t\u0003\n)*\u0001\u0003oKb$H#B@\u0002\u0018\u0006e\u0005\u0002CA#\u0003#\u0003\r!a\u0012\t\u000f\u0005U\u0013\u0011\u0013a\u0001W!A\u0011QTA3\t\u0003\ny*\u0001\u0006eK\u000e|W\u000e\u001d:fgN$Ra`AQ\u0003cC\u0001\"a)\u0002\u001c\u0002\u0007\u0011QU\u0001\rG>dW/\u001c8WK\u000e$xN\u001d\t\u0005\u0003O\u000bi+\u0004\u0002\u0002**\u0019\u00111\u0016\u0004\u0002\u0015Y,7\r^8sSj,G-\u0003\u0003\u00020\u0006%&\u0001F,sSR\f'\r\\3D_2,XN\u001c,fGR|'\u000fC\u0004\u00024\u0006m\u0005\u0019A\u0016\u0002\u0011\r\f\u0007/Y2jifD\u0011\"a.\u0013\u0003\u0003%\t%!/\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\f\u0005\u0003\u0002>\u0006\rWBAA`\u0015\r\t\t-S\u0001\u0005Y\u0006tw-\u0003\u0003\u0002F\u0006}&AB*ue&tw\r\u0003\u0005\u0002JJ\t\t\u0011\"\u0001+\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011%\tiMEA\u0001\n\u0003\ty-\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u00075\f\t\u000eC\u0005\u0002\b\u0005-\u0017\u0011!a\u0001W!I\u0011Q\u001b\n\u0002\u0002\u0013\u0005\u0013q[\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u001c\t\u0006\u00037\f\t/\\\u0007\u0003\u0003;T1!a8\u0018\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003G\fiN\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t9OEA\u0001\n\u0003\tI/\u0001\u0005dC:,\u0015/^1m)\r\t\u00171\u001e\u0005\n\u0003\u000f\t)/!AA\u00025D\u0011\"a<\u0013\u0003\u0003%\t%!=\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\u000b\u0005\n\u0003k\u0014\u0012\u0011!C!\u0003o\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003wC\u0011\"a?\u0013\u0003\u0003%I!!@\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u007f\u0004B!!0\u0003\u0002%!!1AA`\u0005\u0019y%M[3di\u0002")
public final class LongDelta {
    public static String toString() {
        return LongDelta$.MODULE$.toString();
    }

    public static int hashCode() {
        return LongDelta$.MODULE$.hashCode();
    }

    public static boolean canEqual(Object object) {
        return LongDelta$.MODULE$.canEqual(object);
    }

    public static Iterator<Object> productIterator() {
        return LongDelta$.MODULE$.productIterator();
    }

    public static Object productElement(int n) {
        return LongDelta$.MODULE$.productElement(n);
    }

    public static int productArity() {
        return LongDelta$.MODULE$.productArity();
    }

    public static String productPrefix() {
        return LongDelta$.MODULE$.productPrefix();
    }

    public static boolean supports(ColumnType<?> columnType) {
        return LongDelta$.MODULE$.supports(columnType);
    }

    public static <T extends AtomicType> org.apache.spark.sql.execution.columnar.compression.Encoder<T> encoder(NativeColumnType<T> nativeColumnType) {
        return LongDelta$.MODULE$.encoder(nativeColumnType);
    }

    public static <T extends AtomicType> org.apache.spark.sql.execution.columnar.compression.Decoder<T> decoder(ByteBuffer byteBuffer, NativeColumnType<T> nativeColumnType) {
        return LongDelta$.MODULE$.decoder(byteBuffer, nativeColumnType);
    }

    public static int typeId() {
        return LongDelta$.MODULE$.typeId();
    }

    public static class Decoder
    implements org.apache.spark.sql.execution.columnar.compression.Decoder<LongType$> {
        private final ByteBuffer buffer;
        private long prev;

        private long prev() {
            return this.prev;
        }

        private void prev_$eq(long x$1) {
            this.prev = x$1;
        }

        @Override
        public boolean hasNext() {
            return this.buffer.hasRemaining();
        }

        @Override
        public void next(InternalRow row, int ordinal) {
            byte delta = this.buffer.get();
            this.prev_$eq(delta > -128 ? this.prev() + (long)delta : ByteBufferHelper$.MODULE$.getLong(this.buffer));
            row.setLong(ordinal, this.prev());
        }

        @Override
        public void decompress(WritableColumnVector columnVector, int capacity) {
            long prevLocal = 0L;
            ByteBuffer nullsBuffer = this.buffer.duplicate().order(ByteOrder.nativeOrder());
            nullsBuffer.rewind();
            int nullCount = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
            int nextNullIndex = nullCount > 0 ? ByteBufferHelper$.MODULE$.getInt(nullsBuffer) : -1;
            int seenNulls = 0;
            for (int pos = 0; pos < capacity; ++pos) {
                if (pos != nextNullIndex) {
                    byte delta = this.buffer.get();
                    prevLocal = delta > -128 ? prevLocal + (long)delta : ByteBufferHelper$.MODULE$.getLong(this.buffer);
                    columnVector.putLong(pos, prevLocal);
                    continue;
                }
                if (++seenNulls < nullCount) {
                    nextNullIndex = ByteBufferHelper$.MODULE$.getInt(nullsBuffer);
                }
                columnVector.putNull(pos);
            }
        }

        public Decoder(ByteBuffer buffer, NativeColumnType<LongType$> columnType) {
            this.buffer = buffer;
        }
    }

    public static class Encoder
    implements org.apache.spark.sql.execution.columnar.compression.Encoder<LongType$> {
        private int _compressedSize;
        private int _uncompressedSize;
        private long prevValue;

        @Override
        public double compressionRatio() {
            return org.apache.spark.sql.execution.columnar.compression.Encoder.compressionRatio$(this);
        }

        public int _compressedSize() {
            return this._compressedSize;
        }

        public void _compressedSize_$eq(int x$1) {
            this._compressedSize = x$1;
        }

        public int _uncompressedSize() {
            return this._uncompressedSize;
        }

        public void _uncompressedSize_$eq(int x$1) {
            this._uncompressedSize = x$1;
        }

        @Override
        public int compressedSize() {
            return this._compressedSize();
        }

        @Override
        public int uncompressedSize() {
            return this._uncompressedSize();
        }

        private long prevValue() {
            return this.prevValue;
        }

        private void prevValue_$eq(long x$1) {
            this.prevValue = x$1;
        }

        @Override
        public void gatherCompressibilityStats(InternalRow row, int ordinal) {
            long value = row.getLong(ordinal);
            long delta = value - this.prevValue();
            this._compressedSize_$eq(this._compressedSize() + 1);
            if (this._uncompressedSize() == 0 || delta <= (long)-128 || delta > (long)127) {
                this._compressedSize_$eq(this._compressedSize() + LONG$.MODULE$.defaultSize());
            }
            this._uncompressedSize_$eq(this._uncompressedSize() + LONG$.MODULE$.defaultSize());
            this.prevValue_$eq(value);
        }

        @Override
        public ByteBuffer compress(ByteBuffer from, ByteBuffer to) {
            to.putInt(LongDelta$.MODULE$.typeId());
            if (from.hasRemaining()) {
                long prev = from.getLong();
                to.put((byte)-128);
                to.putLong(prev);
                while (from.hasRemaining()) {
                    ByteBuffer byteBuffer;
                    long current = from.getLong();
                    long delta = current - prev;
                    prev = current;
                    if ((long)-128 < delta && delta <= (long)127) {
                        byteBuffer = to.put((byte)delta);
                        continue;
                    }
                    to.put((byte)-128);
                    byteBuffer = to.putLong(current);
                }
            }
            return (ByteBuffer)to.rewind();
        }

        public Encoder() {
            org.apache.spark.sql.execution.columnar.compression.Encoder.$init$(this);
            this._compressedSize = 0;
            this._uncompressedSize = 0;
        }
    }
}

