/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.TypedColumn;
import org.apache.spark.sql.catalyst.analysis.MultiAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAlias$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedExtractValue;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction;
import org.apache.spark.sql.catalyst.analysis.UnresolvedStar;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.BitwiseAnd;
import org.apache.spark.sql.catalyst.expressions.BitwiseOr;
import org.apache.spark.sql.catalyst.expressions.BitwiseXor;
import org.apache.spark.sql.catalyst.expressions.CaseWhen;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Contains;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStructLike;
import org.apache.spark.sql.catalyst.expressions.Descending$;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.EndsWith;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Generator;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.IsNaN;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Like;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.NullOrdering;
import org.apache.spark.sql.catalyst.expressions.NullsFirst$;
import org.apache.spark.sql.catalyst.expressions.NullsLast$;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.RLike;
import org.apache.spark.sql.catalyst.expressions.Remainder;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.expressions.StartsWith;
import org.apache.spark.sql.catalyst.expressions.Substring;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.UnaryMinus;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.catalyst.util.package$;
import org.apache.spark.sql.execution.aggregate.TypedAggregateExpression;
import org.apache.spark.sql.expressions.Window$;
import org.apache.spark.sql.expressions.WindowSpec;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@InterfaceStability.Stable
@ScalaSignature(bytes="\u0006\u0001\r\u0015xAB\u0001\u0003\u0011\u0003\u0011!\"\u0001\u0004D_2,XN\u001c\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<\u0007CA\u0006\r\u001b\u0005\u0011aAB\u0007\u0003\u0011\u0003\u0011aB\u0001\u0004D_2,XN\\\n\u0003\u0019=\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0007\"\u0002\f\r\t\u0003A\u0012A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003)AQA\u0007\u0007\u0005\u0002m\tQ!\u00199qYf$2\u0001HBa!\tYQD\u0002\u0003\u000e\u0005\u0001q2cA\u000f\u0010?A\u0011\u0001eI\u0007\u0002C)\u0011!\u0005B\u0001\tS:$XM\u001d8bY&\u0011A%\t\u0002\b\u0019><w-\u001b8h\u0011!1SD!b\u0001\n\u00039\u0013\u0001B3yaJ,\u0012\u0001\u000b\t\u0003S9j\u0011A\u000b\u0006\u0003W1\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011QFA\u0001\tG\u0006$\u0018\r\\=ti&\u0011qF\u000b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\u0002C\u0019\u001e\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\u000b\u0015D\bO\u001d\u0011\t\u000bYiB\u0011A\u001a\u0015\u0005q!\u0004\"\u0002\u00143\u0001\u0004A\u0003\"\u0002\f\u001e\t\u00031DC\u0001\u000f8\u0011\u0015AT\u00071\u0001:\u0003\u0011q\u0017-\\3\u0011\u0005i\neBA\u001e@!\ta\u0014#D\u0001>\u0015\tqt#\u0001\u0004=e>|GOP\u0005\u0003\u0001F\ta\u0001\u0015:fI\u00164\u0017B\u0001\"D\u0005\u0019\u0019FO]5oO*\u0011\u0001)\u0005\u0005\u0006\u000bv!\tER\u0001\ti>\u001cFO]5oOR\t\u0011\bC\u0003I;\u0011\u0005\u0013*\u0001\u0004fcV\fGn\u001d\u000b\u0003\u00156\u0003\"\u0001E&\n\u00051\u000b\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u001d\u001e\u0003\raT\u0001\u0005i\"\fG\u000f\u0005\u0002\u0011!&\u0011\u0011+\u0005\u0002\u0004\u0003:L\b\"B*\u001e\t\u0003\"\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003U\u0003\"\u0001\u0005,\n\u0005]\u000b\"aA%oi\")\u0011,\bC\u00055\u0006Aq/\u001b;i\u000bb\u0004(\u000f\u0006\u0002\u001d7\")A\f\u0017a\u0001Q\u00059a.Z<FqB\u0014\bB\u00020\u001e\t\u0003\u0011q,A\u0003oC6,G-F\u0001a!\tI\u0013-\u0003\u0002cU\tya*Y7fI\u0016C\bO]3tg&|g\u000eC\u0003e;\u0011\u0005Q-\u0001\u0002bgV\u0011a\r\u001c\u000b\u0003OJ\u0004Ba\u00035PU&\u0011\u0011N\u0001\u0002\f)f\u0004X\rZ\"pYVlg\u000e\u0005\u0002lY2\u0001A!B7d\u0005\u0004q'!A+\u0012\u0005=|\u0005C\u0001\tq\u0013\t\t\u0018CA\u0004O_RD\u0017N\\4\t\u000fM\u001c\u0017\u0011!a\u0002i\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u0007-)(.\u0003\u0002w\u0005\t9QI\\2pI\u0016\u0014\b\"\u0002\u000e\u001e\t\u0003AHC\u0001\u000fz\u0011\u0015Qx\u000f1\u0001P\u0003))\u0007\u0010\u001e:bGRLwN\u001c\u0005\u0006yv!\t!`\u0001\rk:\f'/_0%[&tWo]\u000b\u00029!)q0\bC\u0001{\u0006YQO\\1ss~##-\u00198h\u0011\u001d\t\u0019!\bC\u0001\u0003\u000b\t\u0011\u0002J3rI\u0015\fH%Z9\u0015\u0007q\t9\u0001C\u0004\u0002\n\u0005\u0005\u0001\u0019A(\u0002\u000b=$\b.\u001a:\t\u000f\u00055Q\u0004\"\u0001\u0002\u0010\u00059Q-];bYR{Gc\u0001\u000f\u0002\u0012!9\u0011\u0011BA\u0006\u0001\u0004y\u0005bBA\u000b;\u0011\u0005\u0011qC\u0001\fI\u0015\fHEY1oO\u0012*\u0017\u000fF\u0002\u001d\u00033Aq!!\u0003\u0002\u0014\u0001\u0007q\nC\u0004\u0002\u001eu!\t!a\b\u0002\u0017\u0011\u0012\u0017M\\4%KF$S-\u001d\u000b\u00049\u0005\u0005\u0002bBA\u0005\u00037\u0001\ra\u0014\u0015\t\u00037\t)#a\u000b\u00020A\u0019\u0001#a\n\n\u0007\u0005%\u0012C\u0001\u0006eKB\u0014XmY1uK\u0012\f#!!\f\u0002{\u0005jT\b\t3pKN\u0004cn\u001c;!Q\u00064X\r\t;iK\u0002\u001a\u0018-\\3!aJ,7-\u001a3f]\u000e,\u0007%Y:!{ujD\u0006I;tK\u0002j\u0014%\u0010\u0011j]N$X-\u00193\"\u0005\u0005E\u0012!\u0002\u001a/a9\u0002\u0004bBA\u001b;\u0011\u0005\u0011qG\u0001\t]>$X)];bYR\u0019A$!\u000f\t\u000f\u0005%\u00111\u0007a\u0001\u001f\"9\u0011QH\u000f\u0005\u0002\u0005}\u0012\u0001\u0003\u0013he\u0016\fG/\u001a:\u0015\u0007q\t\t\u0005C\u0004\u0002\n\u0005m\u0002\u0019A(\t\u000f\u0005\u0015S\u0004\"\u0001\u0002H\u0005\u0011q\r\u001e\u000b\u00049\u0005%\u0003bBA\u0005\u0003\u0007\u0002\ra\u0014\u0005\b\u0003\u001bjB\u0011AA(\u0003\u0015!C.Z:t)\ra\u0012\u0011\u000b\u0005\b\u0003\u0013\tY\u00051\u0001P\u0011\u001d\t)&\bC\u0001\u0003/\n!\u0001\u001c;\u0015\u0007q\tI\u0006C\u0004\u0002\n\u0005M\u0003\u0019A(\t\u000f\u0005uS\u0004\"\u0001\u0002`\u0005AA\u0005\\3tg\u0012*\u0017\u000fF\u0002\u001d\u0003CBq!!\u0003\u0002\\\u0001\u0007q\nC\u0004\u0002fu!\t!a\u001a\u0002\u00071,\u0017\u000fF\u0002\u001d\u0003SBq!!\u0003\u0002d\u0001\u0007q\nC\u0004\u0002nu!\t!a\u001c\u0002\u0017\u0011:'/Z1uKJ$S-\u001d\u000b\u00049\u0005E\u0004bBA\u0005\u0003W\u0002\ra\u0014\u0005\b\u0003kjB\u0011AA<\u0003\r9W-\u001d\u000b\u00049\u0005e\u0004bBA\u0005\u0003g\u0002\ra\u0014\u0005\b\u0003{jB\u0011AA@\u0003A!C.Z:tI\u0015\fHe\u001a:fCR,'\u000fF\u0002\u001d\u0003\u0003Cq!!\u0003\u0002|\u0001\u0007q\nC\u0004\u0002\u0006v!\t!a\"\u0002\u0015\u0015\fh*\u001e7m'\u00064W\rF\u0002\u001d\u0003\u0013Cq!!\u0003\u0002\u0004\u0002\u0007q\nC\u0004\u0002\u000ev!\t!a$\u0002\t]DWM\u001c\u000b\u00069\u0005E\u0015Q\u0013\u0005\b\u0003'\u000bY\t1\u0001\u001d\u0003%\u0019wN\u001c3ji&|g\u000eC\u0004\u0002\u0018\u0006-\u0005\u0019A(\u0002\u000bY\fG.^3\t\u000f\u0005mU\u0004\"\u0001\u0002\u001e\u0006Iq\u000e\u001e5fe^L7/\u001a\u000b\u00049\u0005}\u0005bBAL\u00033\u0003\ra\u0014\u0005\b\u0003GkB\u0011AAS\u0003\u001d\u0011W\r^<fK:$R\u0001HAT\u0003WCq!!+\u0002\"\u0002\u0007q*\u0001\u0006m_^,'OQ8v]\u0012Dq!!,\u0002\"\u0002\u0007q*\u0001\u0006vaB,'OQ8v]\u0012Da!!-\u001e\t\u0003i\u0018!B5t\u001d\u0006t\u0005BBA[;\u0011\u0005Q0\u0001\u0004jg:+H\u000e\u001c\u0005\u0007\u0003skB\u0011A?\u0002\u0013%\u001chj\u001c;Ok2d\u0007bBA_;\u0011\u0005\u0011qX\u0001\tI\t\f'\u000f\n2beR\u0019A$!1\t\u000f\u0005%\u00111\u0018a\u0001\u001f\"9\u0011QY\u000f\u0005\u0002\u0005\u001d\u0017AA8s)\ra\u0012\u0011\u001a\u0005\b\u0003\u0013\t\u0019\r1\u0001\u001d\u0011\u001d\ti-\bC\u0001\u0003\u001f\f\u0001\u0002J1na\u0012\nW\u000e\u001d\u000b\u00049\u0005E\u0007bBA\u0005\u0003\u0017\u0004\ra\u0014\u0005\b\u0003+lB\u0011AAl\u0003\r\tg\u000e\u001a\u000b\u00049\u0005e\u0007bBA\u0005\u0003'\u0004\r\u0001\b\u0005\b\u0003;lB\u0011AAp\u0003\u0015!\u0003\u000f\\;t)\ra\u0012\u0011\u001d\u0005\b\u0003\u0013\tY\u000e1\u0001P\u0011\u001d\t)/\bC\u0001\u0003O\fA\u0001\u001d7vgR\u0019A$!;\t\u000f\u0005%\u00111\u001da\u0001\u001f\"9\u0011Q^\u000f\u0005\u0002\u0005=\u0018A\u0002\u0013nS:,8\u000fF\u0002\u001d\u0003cDq!!\u0003\u0002l\u0002\u0007q\nC\u0004\u0002vv!\t!a>\u0002\u000b5Lg.^:\u0015\u0007q\tI\u0010C\u0004\u0002\n\u0005M\b\u0019A(\t\u000f\u0005uX\u0004\"\u0001\u0002\u0000\u00061A\u0005^5nKN$2\u0001\bB\u0001\u0011\u001d\tI!a?A\u0002=CqA!\u0002\u001e\t\u0003\u00119!\u0001\u0005nk2$\u0018\u000e\u001d7z)\ra\"\u0011\u0002\u0005\b\u0003\u0013\u0011\u0019\u00011\u0001P\u0011\u001d\u0011i!\bC\u0001\u0005\u001f\tA\u0001\n3jmR\u0019AD!\u0005\t\u000f\u0005%!1\u0002a\u0001\u001f\"9!QC\u000f\u0005\u0002\t]\u0011A\u00023jm&$W\rF\u0002\u001d\u00053Aq!!\u0003\u0003\u0014\u0001\u0007q\nC\u0004\u0003\u001eu!\tAa\b\u0002\u0011\u0011\u0002XM]2f]R$2\u0001\bB\u0011\u0011\u001d\tIAa\u0007A\u0002=CqA!\n\u001e\t\u0003\u00119#A\u0002n_\u0012$2\u0001\bB\u0015\u0011\u001d\tIAa\tA\u0002=CqA!\f\u001e\t\u0003\u0011y#\u0001\u0003jg&tGc\u0001\u000f\u00032!A!1\u0007B\u0016\u0001\u0004\u0011)$\u0001\u0003mSN$\b\u0003\u0002\t\u00038=K1A!\u000f\u0012\u0005)a$/\u001a9fCR,GM\u0010\u0015\u0005\u0005W\u0011i\u0004\u0005\u0003\u0003@\t\u0015SB\u0001B!\u0015\r\u0011\u0019%E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B$\u0005\u0003\u0012qA^1sCJ<7\u000fC\u0004\u0003Lu!\tA!\u0014\u0002\u001d%\u001c\u0018J\\\"pY2,7\r^5p]R\u0019ADa\u0014\t\u0011\tE#\u0011\na\u0001\u0005'\naA^1mk\u0016\u001c\b\u0007\u0002B+\u0005G\u0002bAa\u0016\u0003^\t\u0005TB\u0001B-\u0015\r\u0011Y&E\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B0\u00053\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\u0004W\n\rDa\u0003B3\u0005\u001f\n\t\u0011!A\u0003\u00029\u00141a\u0018\u00133\u0011\u001d\u0011Y%\bC\u0001\u0005S\"2\u0001\bB6\u0011!\u0011\tFa\u001aA\u0002\t5\u0004\u0007\u0002B8\u0005\u007f\u0002bA!\u001d\u0003|\tuTB\u0001B:\u0015\u0011\u0011)Ha\u001e\u0002\t1\fgn\u001a\u0006\u0003\u0005s\nAA[1wC&!!q\fB:!\rY'q\u0010\u0003\f\u0005\u0003\u0013Y'!A\u0001\u0002\u000b\u0005aNA\u0002`IMBqA!\"\u001e\t\u0003\u00119)\u0001\u0003mS.,Gc\u0001\u000f\u0003\n\"9!1\u0012BB\u0001\u0004I\u0014a\u00027ji\u0016\u0014\u0018\r\u001c\u0005\b\u0005\u001fkB\u0011\u0001BI\u0003\u0015\u0011H.[6f)\ra\"1\u0013\u0005\b\u0005\u0017\u0013i\t1\u0001:\u0011\u001d\u00119*\bC\u0001\u00053\u000bqaZ3u\u0013R,W\u000eF\u0002\u001d\u00057CqA!(\u0003\u0016\u0002\u0007q*A\u0002lKfDqA!)\u001e\t\u0003\u0011\u0019+\u0001\u0005hKR4\u0015.\u001a7e)\ra\"Q\u0015\u0005\b\u0005O\u0013y\n1\u0001:\u0003%1\u0017.\u001a7e\u001d\u0006lW\rC\u0004\u0003,v!\tA!,\u0002\rM,(m\u001d;s)\u0015a\"q\u0016BZ\u0011\u001d\u0011\tL!+A\u0002q\t\u0001b\u001d;beR\u0004vn\u001d\u0005\b\u0005k\u0013I\u000b1\u0001\u001d\u0003\raWM\u001c\u0005\b\u0005WkB\u0011\u0001B])\u0015a\"1\u0018B_\u0011\u001d\u0011\tLa.A\u0002UCqA!.\u00038\u0002\u0007Q\u000bC\u0004\u0003Bv!\tAa1\u0002\u0011\r|g\u000e^1j]N$2\u0001\bBc\u0011\u001d\tIAa0A\u0002=CqA!3\u001e\t\u0003\u0011Y-\u0001\u0006ti\u0006\u0014Ho],ji\"$2\u0001\bBg\u0011\u001d\tIAa2A\u0002qAqA!3\u001e\t\u0003\u0011\t\u000eF\u0002\u001d\u0005'DqAa#\u0003P\u0002\u0007\u0011\bC\u0004\u0003Xv!\tA!7\u0002\u0011\u0015tGm],ji\"$2\u0001\bBn\u0011\u001d\tIA!6A\u0002qAqAa6\u001e\t\u0003\u0011y\u000eF\u0002\u001d\u0005CDqAa#\u0003^\u0002\u0007\u0011\bC\u0004\u0003fv!\tAa:\u0002\u000b\u0005d\u0017.Y:\u0015\u0007q\u0011I\u000fC\u0004\u0003f\n\r\b\u0019A\u001d\t\r\u0011lB\u0011\u0001Bw)\ra\"q\u001e\u0005\b\u0005K\u0014Y\u000f1\u0001:\u0011\u0019!W\u0004\"\u0001\u0003tR\u0019AD!>\t\u0011\t](\u0011\u001fa\u0001\u0005s\fq!\u00197jCN,7\u000fE\u0003\u0003|\u000e\u0015\u0011H\u0004\u0003\u0003~\u000e\u0005ab\u0001\u001f\u0003\u0000&\t!#C\u0002\u0004\u0004E\tq\u0001]1dW\u0006<W-\u0003\u0003\u0004\b\r%!aA*fc*\u001911A\t\t\r\u0011lB\u0011AB\u0007)\ra2q\u0002\u0005\t\u0005o\u001cY\u00011\u0001\u0004\u0012A!\u0001ca\u0005:\u0013\r\u0019)\"\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0007Iv!\ta!\u0007\u0015\u0007q\u0019Y\u0002\u0003\u0005\u0003f\u000e]\u0001\u0019AB\u000f!\r\u00012qD\u0005\u0004\u0007C\t\"AB*z[\n|G\u000e\u0003\u0004e;\u0011\u00051Q\u0005\u000b\u00069\r\u001d2\u0011\u0006\u0005\b\u0005K\u001c\u0019\u00031\u0001:\u0011!\u0019Yca\tA\u0002\r5\u0012\u0001C7fi\u0006$\u0017\r^1\u0011\t\r=2QG\u0007\u0003\u0007cQ1aa\r\u0003\u0003\u0015!\u0018\u0010]3t\u0013\u0011\u00199d!\r\u0003\u00115+G/\u00193bi\u0006Da\u0001O\u000f\u0005\u0002\rmBc\u0001\u000f\u0004>!9!Q]B\u001d\u0001\u0004I\u0004bBB!;\u0011\u000511I\u0001\u0005G\u0006\u001cH\u000fF\u0002\u001d\u0007\u000bB\u0001ba\u0012\u0004@\u0001\u00071\u0011J\u0001\u0003i>\u0004Baa\f\u0004L%!1QJB\u0019\u0005!!\u0015\r^1UsB,\u0007bBB!;\u0011\u00051\u0011\u000b\u000b\u00049\rM\u0003bBB$\u0007\u001f\u0002\r!\u000f\u0005\u0007\u0007/jB\u0011A?\u0002\t\u0011,7o\u0019\u0005\u0007\u00077jB\u0011A?\u0002!\u0011,7oY0ok2d7o\u00184jeN$\bBBB0;\u0011\u0005Q0A\beKN\u001cwL\\;mYN|F.Y:u\u0011\u0019\u0019\u0019'\bC\u0001{\u0006\u0019\u0011m]2\t\r\r\u001dT\u0004\"\u0001~\u0003=\t7oY0ok2d7o\u00184jeN$\bBBB6;\u0011\u0005Q0\u0001\bbg\u000e|f.\u001e7mg~c\u0017m\u001d;\t\u000f\r=T\u0004\"\u0001\u0004r\u00059Q\r\u001f9mC&tG\u0003BB:\u0007s\u00022\u0001EB;\u0013\r\u00199(\u0005\u0002\u0005+:LG\u000fC\u0004\u0004|\r5\u0004\u0019\u0001&\u0002\u0011\u0015DH/\u001a8eK\u0012Dqaa \u001e\t\u0003\u0019\t)A\u0005cSR<\u0018n]3P%R\u0019Ada!\t\u000f\u0005%1Q\u0010a\u0001\u001f\"91qQ\u000f\u0005\u0002\r%\u0015A\u00032ji^L7/Z!O\tR\u0019Ada#\t\u000f\u0005%1Q\u0011a\u0001\u001f\"91qR\u000f\u0005\u0002\rE\u0015A\u00032ji^L7/\u001a-P%R\u0019Ada%\t\u000f\u0005%1Q\u0012a\u0001\u001f\"91qS\u000f\u0005\u0002\re\u0015\u0001B8wKJ$2\u0001HBN\u0011!\u0019ij!&A\u0002\r}\u0015AB<j]\u0012|w\u000f\u0005\u0003\u0004\"\u000e\u0015VBABR\u0015\tY#!\u0003\u0003\u0004(\u000e\r&AC,j]\u0012|wo\u00159fG\"91qS\u000f\u0005\u0002\r-F#\u0001\u000f)\u0007u\u0019y\u000b\u0005\u0003\u00042\u000emf\u0002BBZ\u0007ok!a!.\u000b\u0007\t\rC!\u0003\u0003\u0004:\u000eU\u0016AE%oi\u0016\u0014h-Y2f'R\f'-\u001b7jifLAa!0\u0004@\n11\u000b^1cY\u0016TAa!/\u00046\"111Y\rA\u0002e\nqaY8m\u001d\u0006lW\r\u0003\u0004\u001b\u0019\u0011\u00051q\u0019\u000b\u00049\r%\u0007B\u0002\u0014\u0004F\u0002\u0007\u0001\u0006C\u0004\u0004N2!\taa4\u0002\u000fUt\u0017\r\u001d9msR!1\u0011[Bl!\u0011\u000121\u001b\u0015\n\u0007\rU\u0017C\u0001\u0004PaRLwN\u001c\u0005\b\u00073\u001cY\r1\u0001\u001d\u0003\r\u0019w\u000e\u001c\u0005\t\u0007;dA\u0011\u0001\u0002\u0004`\u0006iq-\u001a8fe\u0006$X-\u00117jCN$2!OBq\u0011\u001d\u0019\u0019oa7A\u0002!\n\u0011!\u001a")
public class Column
implements Logging {
    private final Expression expr;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Option<Expression> unapply(Column column) {
        return Column$.MODULE$.unapply(column);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Column isin(Object ... list) {
        return this.isin((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)list));
    }

    public Expression expr() {
        return this.expr;
    }

    public String toString() {
        return package$.MODULE$.toPrettySQL(this.expr());
    }

    public boolean equals(Object that) {
        boolean bl;
        Object object = that;
        if (object instanceof Column) {
            Column column = (Column)object;
            bl = column.expr().equals((Object)this.expr());
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.expr().hashCode();
    }

    private Column withExpr(Expression newExpr) {
        return new Column(newExpr);
    }

    public NamedExpression named() {
        AggregateExpression aggregateExpression;
        UnresolvedAlias unresolvedAlias;
        Expression expression = this.expr();
        if (expression instanceof UnresolvedAttribute) {
            UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)expression;
            unresolvedAlias = new UnresolvedAlias((Expression)unresolvedAttribute, UnresolvedAlias$.MODULE$.apply$default$2());
        } else if (expression instanceof UnresolvedExtractValue) {
            UnresolvedExtractValue unresolvedExtractValue = (UnresolvedExtractValue)expression;
            unresolvedAlias = new UnresolvedAlias((Expression)unresolvedExtractValue, UnresolvedAlias$.MODULE$.apply$default$2());
        } else if (expression instanceof NamedExpression) {
            NamedExpression namedExpression = (NamedExpression)expression;
            unresolvedAlias = namedExpression;
        } else if (expression instanceof Generator) {
            Generator generator = (Generator)expression;
            unresolvedAlias = new MultiAlias((Expression)generator, (Seq)Nil$.MODULE$);
        } else if (expression instanceof UnresolvedFunction) {
            UnresolvedFunction unresolvedFunction = (UnresolvedFunction)expression;
            unresolvedAlias = new UnresolvedAlias((Expression)unresolvedFunction, (Option)new Some((Function1 & Serializable & scala.Serializable)e -> Column$.MODULE$.generateAlias((Expression)e)));
        } else if (expression instanceof Cast) {
            NamedExpression namedExpression;
            Cast cast = (Cast)expression;
            Expression expression2 = (Expression)cast.transformUp((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Cast cast;
                    A1 A1 = x2;
                    Object object = A1 instanceof Cast && (cast = (Cast)A1).child() instanceof NamedExpression ? new UnresolvedAlias((Expression)cast, UnresolvedAlias$.MODULE$.apply$default$2()) : function1.apply(x2);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Expression x2) {
                    Cast cast;
                    Expression expression = x2;
                    boolean bl = expression instanceof Cast && (cast = (Cast)expression).child() instanceof NamedExpression;
                    return bl;
                }
            });
            if (expression2 instanceof NamedExpression) {
                NamedExpression namedExpression2;
                namedExpression = namedExpression2 = (NamedExpression)expression2;
            } else {
                Expression x$2 = this.expr();
                String x$3 = package$.MODULE$.toPrettySQL(this.expr());
                ExprId x$4 = Alias$.MODULE$.apply$default$3(x$2, x$3);
                Seq x$5 = Alias$.MODULE$.apply$default$4(x$2, x$3);
                Option x$6 = Alias$.MODULE$.apply$default$5(x$2, x$3);
                namedExpression = new Alias(x$2, x$3, x$4, x$5, x$6);
            }
            unresolvedAlias = namedExpression;
        } else if (expression instanceof AggregateExpression && (aggregateExpression = (AggregateExpression)expression).aggregateFunction() instanceof TypedAggregateExpression) {
            unresolvedAlias = new UnresolvedAlias((Expression)aggregateExpression, (Option)new Some((Function1 & Serializable & scala.Serializable)e -> Column$.MODULE$.generateAlias((Expression)e)));
        } else if (expression instanceof CreateNamedStructLike) {
            CreateNamedStructLike createNamedStructLike = (CreateNamedStructLike)expression;
            unresolvedAlias = new UnresolvedAlias((Expression)createNamedStructLike, UnresolvedAlias$.MODULE$.apply$default$2());
        } else if (expression != null) {
            Expression expression3;
            Expression x$7 = expression3 = expression;
            String x$8 = package$.MODULE$.toPrettySQL(expression3);
            ExprId x$9 = Alias$.MODULE$.apply$default$3(x$7, x$8);
            Seq x$10 = Alias$.MODULE$.apply$default$4(x$7, x$8);
            Option x$11 = Alias$.MODULE$.apply$default$5(x$7, x$8);
            unresolvedAlias = new Alias(x$7, x$8, x$9, x$10, x$11);
        } else {
            throw new MatchError((Object)expression);
        }
        return unresolvedAlias;
    }

    public <U> TypedColumn<Object, U> as(Encoder<U> evidence$1) {
        return new TypedColumn(this.expr(), org.apache.spark.sql.catalyst.encoders.package$.MODULE$.encoderFor(evidence$1));
    }

    public Column apply(Object extraction) {
        return this.withExpr((Expression)new UnresolvedExtractValue(this.expr(), functions$.MODULE$.lit(extraction).expr()));
    }

    public Column unary_$minus() {
        return this.withExpr((Expression)new UnaryMinus(this.expr()));
    }

    public Column unary_$bang() {
        return this.withExpr((Expression)new Not(this.expr()));
    }

    public Column $eq$eq$eq(Object other) {
        Expression right = functions$.MODULE$.lit(other).expr();
        Expression expression = this.expr();
        Expression expression2 = right;
        if (!(expression != null ? !expression.equals(expression2) : expression2 != null)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Constructing trivially true equals predicate, '").append(this.expr()).append(" = ").append(right).append("'. ").append("Perhaps you need to use aliases.").toString());
        }
        return this.withExpr((Expression)new EqualTo(this.expr(), right));
    }

    public Column equalTo(Object other) {
        return this.$eq$eq$eq(other);
    }

    public Column $eq$bang$eq(Object other) {
        return this.withExpr((Expression)new Not((Expression)new EqualTo(this.expr(), functions$.MODULE$.lit(other).expr())));
    }

    public Column $bang$eq$eq(Object other) {
        return this.$eq$bang$eq(other);
    }

    public Column notEqual(Object other) {
        return this.withExpr((Expression)new Not((Expression)new EqualTo(this.expr(), functions$.MODULE$.lit(other).expr())));
    }

    public Column $greater(Object other) {
        return this.withExpr((Expression)new GreaterThan(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column gt(Object other) {
        return this.$greater(other);
    }

    public Column $less(Object other) {
        return this.withExpr((Expression)new LessThan(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column lt(Object other) {
        return this.$less(other);
    }

    public Column $less$eq(Object other) {
        return this.withExpr((Expression)new LessThanOrEqual(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column leq(Object other) {
        return this.$less$eq(other);
    }

    public Column $greater$eq(Object other) {
        return this.withExpr((Expression)new GreaterThanOrEqual(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column geq(Object other) {
        return this.$greater$eq(other);
    }

    public Column $less$eq$greater(Object other) {
        Expression right = functions$.MODULE$.lit(other).expr();
        Expression expression = this.expr();
        Expression expression2 = right;
        if (!(expression != null ? !expression.equals(expression2) : expression2 != null)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Constructing trivially true equals predicate, '").append(this.expr()).append(" <=> ").append(right).append("'. ").append("Perhaps you need to use aliases.").toString());
        }
        return this.withExpr((Expression)new EqualNullSafe(this.expr(), right));
    }

    public Column eqNullSafe(Object other) {
        return this.$less$eq$greater(other);
    }

    public Column when(Column condition, Object value) {
        Seq branches;
        block5: {
            Option option;
            CaseWhen caseWhen;
            boolean bl;
            block4: {
                bl = false;
                caseWhen = null;
                Expression expression = this.expr();
                if (!(expression instanceof CaseWhen)) break block4;
                bl = true;
                caseWhen = (CaseWhen)expression;
                branches = caseWhen.branches();
                Option option2 = caseWhen.elseValue();
                if (None$.MODULE$.equals(option2)) break block5;
            }
            if (bl && (option = caseWhen.elseValue()) instanceof Some) {
                throw new IllegalArgumentException("when() cannot be applied once otherwise() is applied");
            }
            throw new IllegalArgumentException("when() can only be applied on a Column previously generated by when() function");
        }
        Column column = this.withExpr((Expression)new CaseWhen((Seq)branches.$colon$plus((Object)new Tuple2((Object)condition.expr(), (Object)functions$.MODULE$.lit(value).expr()), Seq$.MODULE$.canBuildFrom()), CaseWhen$.MODULE$.apply$default$2()));
        return column;
    }

    public Column otherwise(Object value) {
        Seq branches;
        block5: {
            Option option;
            CaseWhen caseWhen;
            boolean bl;
            block4: {
                bl = false;
                caseWhen = null;
                Expression expression = this.expr();
                if (!(expression instanceof CaseWhen)) break block4;
                bl = true;
                caseWhen = (CaseWhen)expression;
                branches = caseWhen.branches();
                Option option2 = caseWhen.elseValue();
                if (None$.MODULE$.equals(option2)) break block5;
            }
            if (bl && (option = caseWhen.elseValue()) instanceof Some) {
                throw new IllegalArgumentException("otherwise() can only be applied once on a Column previously generated by when()");
            }
            throw new IllegalArgumentException("otherwise() can only be applied on a Column previously generated by when()");
        }
        Column column = this.withExpr((Expression)new CaseWhen(branches, Option$.MODULE$.apply((Object)functions$.MODULE$.lit(value).expr())));
        return column;
    }

    public Column between(Object lowerBound, Object upperBound) {
        return this.$greater$eq(lowerBound).$amp$amp(this.$less$eq(upperBound));
    }

    public Column isNaN() {
        return this.withExpr((Expression)new IsNaN(this.expr()));
    }

    public Column isNull() {
        return this.withExpr((Expression)new IsNull(this.expr()));
    }

    public Column isNotNull() {
        return this.withExpr((Expression)new IsNotNull(this.expr()));
    }

    public Column $bar$bar(Object other) {
        return this.withExpr((Expression)new Or(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column or(Column other) {
        return this.$bar$bar(other);
    }

    public Column $amp$amp(Object other) {
        return this.withExpr((Expression)new And(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column and(Column other) {
        return this.$amp$amp(other);
    }

    public Column $plus(Object other) {
        return this.withExpr((Expression)new Add(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column plus(Object other) {
        return this.$plus(other);
    }

    public Column $minus(Object other) {
        return this.withExpr((Expression)new Subtract(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column minus(Object other) {
        return this.$minus(other);
    }

    public Column $times(Object other) {
        return this.withExpr((Expression)new Multiply(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column multiply(Object other) {
        return this.$times(other);
    }

    public Column $div(Object other) {
        return this.withExpr((Expression)new Divide(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column divide(Object other) {
        return this.$div(other);
    }

    public Column $percent(Object other) {
        return this.withExpr((Expression)new Remainder(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column mod(Object other) {
        return this.$percent(other);
    }

    public Column isin(Seq<Object> list) {
        return this.withExpr((Expression)new In(this.expr(), (Seq)list.map((Function1 & Serializable & scala.Serializable)x$1 -> functions$.MODULE$.lit(x$1).expr(), Seq$.MODULE$.canBuildFrom())));
    }

    public Column isInCollection(Iterable<?> values) {
        return this.isin((Seq<Object>)values.toSeq());
    }

    public Column isInCollection(java.lang.Iterable<?> values) {
        return this.isInCollection((Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(values).asScala());
    }

    public Column like(String literal) {
        return this.withExpr((Expression)new Like(this.expr(), functions$.MODULE$.lit(literal).expr()));
    }

    public Column rlike(String literal) {
        return this.withExpr((Expression)new RLike(this.expr(), functions$.MODULE$.lit(literal).expr()));
    }

    public Column getItem(Object key) {
        return this.withExpr((Expression)new UnresolvedExtractValue(this.expr(), (Expression)Literal$.MODULE$.apply(key)));
    }

    public Column getField(String fieldName) {
        return this.withExpr((Expression)new UnresolvedExtractValue(this.expr(), (Expression)Literal$.MODULE$.apply((Object)fieldName)));
    }

    public Column substr(Column startPos, Column len) {
        return this.withExpr((Expression)new Substring(this.expr(), startPos.expr(), len.expr()));
    }

    public Column substr(int startPos, int len) {
        return this.withExpr((Expression)new Substring(this.expr(), functions$.MODULE$.lit(BoxesRunTime.boxToInteger((int)startPos)).expr(), functions$.MODULE$.lit(BoxesRunTime.boxToInteger((int)len)).expr()));
    }

    public Column contains(Object other) {
        return this.withExpr((Expression)new Contains(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column startsWith(Column other) {
        return this.withExpr((Expression)new StartsWith(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column startsWith(String literal) {
        return this.startsWith(functions$.MODULE$.lit(literal));
    }

    public Column endsWith(Column other) {
        return this.withExpr((Expression)new EndsWith(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column endsWith(String literal) {
        return this.endsWith(functions$.MODULE$.lit(literal));
    }

    public Column alias(String alias) {
        return this.name(alias);
    }

    public Column as(String alias) {
        return this.name(alias);
    }

    public Column as(Seq<String> aliases) {
        return this.withExpr((Expression)new MultiAlias(this.expr(), aliases));
    }

    public Column as(String[] aliases) {
        return this.withExpr((Expression)new MultiAlias(this.expr(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])aliases)));
    }

    public Column as(Symbol alias) {
        return this.name(alias.name());
    }

    public Column as(String alias, Metadata metadata) {
        Expression x$12 = this.expr();
        String x$13 = alias;
        Some x$14 = new Some((Object)metadata);
        ExprId x$15 = Alias$.MODULE$.apply$default$3(x$12, x$13);
        Seq x$16 = Alias$.MODULE$.apply$default$4(x$12, x$13);
        return this.withExpr((Expression)new Alias(x$12, x$13, x$15, x$16, (Option)x$14));
    }

    public Column name(String alias) {
        Alias alias2;
        Expression expression = this.expr();
        if (expression instanceof NamedExpression) {
            NamedExpression namedExpression = (NamedExpression)expression;
            Expression x$17 = this.expr();
            String x$18 = alias;
            Some x$19 = new Some((Object)namedExpression.metadata());
            ExprId x$20 = Alias$.MODULE$.apply$default$3(x$17, x$18);
            Seq x$21 = Alias$.MODULE$.apply$default$4(x$17, x$18);
            alias2 = new Alias(x$17, x$18, x$20, x$21, (Option)x$19);
        } else {
            Expression x$22 = expression;
            String x$23 = alias;
            ExprId x$24 = Alias$.MODULE$.apply$default$3(x$22, x$23);
            Seq x$25 = Alias$.MODULE$.apply$default$4(x$22, x$23);
            Option x$26 = Alias$.MODULE$.apply$default$5(x$22, x$23);
            alias2 = new Alias(x$22, x$23, x$24, x$25, x$26);
        }
        return this.withExpr((Expression)alias2);
    }

    public Column cast(DataType to) {
        return this.withExpr((Expression)new Cast(this.expr(), to, Cast$.MODULE$.apply$default$3()));
    }

    public Column cast(String to) {
        return this.cast(CatalystSqlParser$.MODULE$.parseDataType(to));
    }

    public Column desc() {
        return this.withExpr((Expression)SortOrder$.MODULE$.apply(this.expr(), (SortDirection)Descending$.MODULE$, SortOrder$.MODULE$.apply$default$3()));
    }

    public Column desc_nulls_first() {
        return this.withExpr((Expression)new SortOrder(this.expr(), (SortDirection)Descending$.MODULE$, (NullOrdering)NullsFirst$.MODULE$, Predef$.MODULE$.Set().empty()));
    }

    public Column desc_nulls_last() {
        return this.withExpr((Expression)new SortOrder(this.expr(), (SortDirection)Descending$.MODULE$, (NullOrdering)NullsLast$.MODULE$, Predef$.MODULE$.Set().empty()));
    }

    public Column asc() {
        return this.withExpr((Expression)SortOrder$.MODULE$.apply(this.expr(), (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3()));
    }

    public Column asc_nulls_first() {
        return this.withExpr((Expression)new SortOrder(this.expr(), (SortDirection)Ascending$.MODULE$, (NullOrdering)NullsFirst$.MODULE$, Predef$.MODULE$.Set().empty()));
    }

    public Column asc_nulls_last() {
        return this.withExpr((Expression)new SortOrder(this.expr(), (SortDirection)Ascending$.MODULE$, (NullOrdering)NullsLast$.MODULE$, Predef$.MODULE$.Set().empty()));
    }

    public void explain(boolean extended) {
        if (extended) {
            Predef$.MODULE$.println((Object)this.expr());
        } else {
            Predef$.MODULE$.println((Object)this.expr().sql());
        }
    }

    public Column bitwiseOR(Object other) {
        return this.withExpr((Expression)new BitwiseOr(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column bitwiseAND(Object other) {
        return this.withExpr((Expression)new BitwiseAnd(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column bitwiseXOR(Object other) {
        return this.withExpr((Expression)new BitwiseXor(this.expr(), functions$.MODULE$.lit(other).expr()));
    }

    public Column over(WindowSpec window) {
        return window.withAggregate(this);
    }

    public Column over() {
        return this.over(Window$.MODULE$.spec());
    }

    public Column(Expression expr) {
        this.expr = expr;
        Logging.$init$((Logging)this);
    }

    public Column(String name) {
        UnresolvedStar unresolvedStar;
        String string = name;
        if ("*".equals(string)) {
            unresolvedStar = new UnresolvedStar((Option)None$.MODULE$);
        } else if (name.endsWith(".*")) {
            Seq parts = UnresolvedAttribute$.MODULE$.parseAttributeName(name.substring(0, name.length() - 2));
            unresolvedStar = new UnresolvedStar((Option)new Some((Object)parts));
        } else {
            unresolvedStar = UnresolvedAttribute$.MODULE$.quotedString(name);
        }
        this((Expression)unresolvedStar);
    }
}

