/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ConcurrentModificationException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog$;
import org.apache.spark.sql.execution.streaming.MetadataLog;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\t-b\u0001B\u0001\u0003\u0001=\u0011q\u0002\u0013#G'6+G/\u00193bi\u0006dun\u001a\u0006\u0003\u0007\u0011\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u00151\u0011!C3yK\u000e,H/[8o\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001+\t\u0001Rd\u0005\u0003\u0001#]\u0019\u0003C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\rE\u0002\u00193mi\u0011AA\u0005\u00035\t\u00111\"T3uC\u0012\fG/\u0019'pOB\u0011A$\b\u0007\u0001\t\u0015q\u0002A1\u0001 \u0005\u0005!\u0016C\u0001\u0011\u0012!\t\u0011\u0012%\u0003\u0002#'\t9aj\u001c;iS:<\u0007C\u0001\u0013(\u001b\u0005)#B\u0001\u0014\t\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0015&\u0005\u001daunZ4j]\u001eD\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IaK\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003Y5j\u0011AB\u0005\u0003]\u0019\u0011Ab\u00159be.\u001cVm]:j_:D\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!M\u0001\u0005a\u0006$\b\u000e\u0005\u00023k9\u0011!cM\u0005\u0003iM\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001c8\u0005\u0019\u0019FO]5oO*\u0011Ag\u0005\u0005\ts\u0001\u0011\u0019\u0011)A\u0006u\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\u0007mr4$D\u0001=\u0015\ti4#A\u0004sK\u001adWm\u0019;\n\u0005}b$\u0001C\"mCN\u001cH+Y4\t\u000b\u0005\u0003A\u0011\u0001\"\u0002\rqJg.\u001b;?)\r\u0019ei\u0012\u000b\u0003\t\u0016\u00032\u0001\u0007\u0001\u001c\u0011\u0015I\u0004\tq\u0001;\u0011\u0015Q\u0003\t1\u0001,\u0011\u0015\u0001\u0004\t1\u00012\u0011\u001dI\u0005A1A\u0005\f)\u000bqAZ8s[\u0006$8/F\u0001L%\ra\u0015c\u0015\u0004\u0005\u001b\u0002\u00011J\u0001\u0007=e\u00164\u0017N\\3nK:$h(\u0003\u0002J\u001f&\u0011\u0001+\u0015\u0002\u000e'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\u0005Ic\u0011A\u00026t_:$4\u000f\u0005\u0002U+6\t\u0011+\u0003\u0002W#\n9ai\u001c:nCR\u001c\bb\u0002-M\u0005\u0004%\t!W\u0001\u000bI\u0006$XMR8s[\u0006$X#\u0001.\u0011\u0005Q[\u0016B\u0001/R\u0005)!\u0015\r^3G_Jl\u0017\r\u001e\u0005\b=2\u0013\r\u0011\"\u0011`\u0003%!\u0018\u0010]3IS:$8/F\u0001a!\t!\u0016-\u0003\u0002c#\nIA+\u001f9f\u0011&tGo\u001d\u0005\u0007I\u0002\u0001\u000b\u0011B&\u0002\u0011\u0019|'/\\1ug\u0002BqA\u001a\u0001C\u0002\u0013-q-\u0001\u0005nC:Lg-Z:u+\u0005A\u0007cA\u001ej7%\u0011!\u000e\u0010\u0002\t\u001b\u0006t\u0017NZ3ti\"1A\u000e\u0001Q\u0001\n!\f\u0011\"\\1oS\u001a,7\u000f\u001e\u0011\t\u000f9\u0004!\u0019!C\u0001_\u0006aQ.\u001a;bI\u0006$\u0018\rU1uQV\t\u0001\u000f\u0005\u0002rm6\t!O\u0003\u0002ti\u0006\u0011am\u001d\u0006\u0003k*\ta\u0001[1e_>\u0004\u0018BA<s\u0005\u0011\u0001\u0016\r\u001e5\t\re\u0004\u0001\u0015!\u0003q\u00035iW\r^1eCR\f\u0007+\u0019;iA!91\u0010\u0001b\u0001\n#a\u0018a\u00034jY\u0016l\u0015M\\1hKJ,\u0012! \t\u00031yL!a \u0002\u0003+\rCWmY6q_&tGOR5mK6\u000bg.Y4fe\"9\u00111\u0001\u0001!\u0002\u0013i\u0018\u0001\u00044jY\u0016l\u0015M\\1hKJ\u0004\u0003\"CA\u0004\u0001\t\u0007I\u0011CA\u0005\u0003A\u0011\u0017\r^2i\r&dWm\u001d$jYR,'/\u0006\u0002\u0002\fI1\u0011QBA\n\u0003G1a!TA\b\u0001\u0005-\u0001\u0002CA\t\u0001\u0001\u0006I!a\u0003\u0002#\t\fGo\u00195GS2,7OR5mi\u0016\u0014\b\u0005\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\t1\fgn\u001a\u0006\u0003\u0003;\tAA[1wC&!\u0011\u0011EA\f\u0005\u0019y%M[3diB\u0019\u0011/!\n\n\u0007\u0005\u001d\"O\u0001\u0006QCRDg)\u001b7uKJDq!a\u000b\u0001\t#\ti#A\u0007cCR\u001c\u0007.\u00133U_B\u000bG\u000f\u001b\u000b\u0004a\u0006=\u0002\u0002CA\u0019\u0003S\u0001\r!a\r\u0002\u000f\t\fGo\u00195JIB\u0019!#!\u000e\n\u0007\u0005]2C\u0001\u0003M_:<\u0007bBA\u001e\u0001\u0011E\u0011QH\u0001\u000ea\u0006$\b\u000eV8CCR\u001c\u0007.\u00133\u0015\t\u0005M\u0012q\b\u0005\u0007a\u0005e\u0002\u0019\u00019\t\u000f\u0005\r\u0003\u0001\"\u0005\u0002F\u0005Y\u0011n\u001d\"bi\u000eDg)\u001b7f)\u0011\t9%!\u0014\u0011\u0007I\tI%C\u0002\u0002LM\u0011qAQ8pY\u0016\fg\u000e\u0003\u00041\u0003\u0003\u0002\r\u0001\u001d\u0005\b\u0003#\u0002A\u0011CA*\u0003%\u0019XM]5bY&TX\r\u0006\u0004\u0002V\u0005m\u0013q\f\t\u0004%\u0005]\u0013bAA-'\t!QK\\5u\u0011\u001d\ti&a\u0014A\u0002m\t\u0001\"\\3uC\u0012\fG/\u0019\u0005\t\u0003C\ny\u00051\u0001\u0002d\u0005\u0019q.\u001e;\u0011\t\u0005\u0015\u00141N\u0007\u0003\u0003ORA!!\u001b\u0002\u001c\u0005\u0011\u0011n\\\u0005\u0005\u0003[\n9G\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0002r\u0001!\t\"a\u001d\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u00047\u0005U\u0004\u0002CA<\u0003_\u0002\r!!\u001f\u0002\u0005%t\u0007\u0003BA3\u0003wJA!! \u0002h\tY\u0011J\u001c9viN#(/Z1n\u0011\u001d\t\t\t\u0001C!\u0003\u0007\u000b1!\u00193e)\u0019\t9%!\"\u0002\b\"A\u0011\u0011GA@\u0001\u0004\t\u0019\u0004C\u0004\u0002^\u0005}\u0004\u0019A\u000e\t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\u0006\u0001rO]5uK\n\u000bGo\u00195U_\u001aKG.\u001a\u000b\u0007\u0003+\ny)!%\t\u000f\u0005u\u0013\u0011\u0012a\u00017!1\u0001'!#A\u0002ADq!!&\u0001\t\u0003\n9*A\u0002hKR$B!!'\u0002 B!!#a'\u001c\u0013\r\tij\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005E\u00121\u0013a\u0001\u0003gAq!!&\u0001\t\u0003\n\u0019\u000b\u0006\u0004\u0002&\u0006E\u0016q\u0017\t\u0006%\u0005\u001d\u00161V\u0005\u0004\u0003S\u001b\"!B!se\u0006L\bC\u0002\n\u0002.\u0006M2$C\u0002\u00020N\u0011a\u0001V;qY\u0016\u0014\u0004\u0002CAZ\u0003C\u0003\r!!.\u0002\u000fM$\u0018M\u001d;JIB)!#a'\u00024!A\u0011\u0011XAQ\u0001\u0004\t),A\u0003f]\u0012LE\rC\u0004\u0002>\u0002!\t%a0\u0002\u0013\u001d,G\u000fT1uKN$HCAAa!\u0015\u0011\u00121TAV\u0011\u001d\t)\r\u0001C\u0001\u0003\u000f\fAcZ3u\u001fJ$WM]3e\u0005\u0006$8\r\u001b$jY\u0016\u001cHCAAe!\u0015\u0011\u0012qUAf!\r\t\u0018QZ\u0005\u0004\u0003\u001f\u0014(A\u0003$jY\u0016\u001cF/\u0019;vg\"9\u00111\u001b\u0001\u0005B\u0005U\u0017!\u00029ve\u001e,G\u0003BA+\u0003/D\u0001\"!7\u0002R\u0002\u0007\u00111G\u0001\u0011i\"\u0014Xm\u001d5pY\u0012\u0014\u0015\r^2i\u0013\u0012Dq!!8\u0001\t\u0003\ty.\u0001\u0006qkJ<W-\u00114uKJ$B!!\u0016\u0002b\"A\u0011\u0011\\An\u0001\u0004\t\u0019\u0004\u0003\u0005\u0002f\u0002!\tABAt\u00031\u0001\u0018M]:f-\u0016\u00148/[8o)\u0019\tI/a<\u0002tB\u0019!#a;\n\u0007\u000558CA\u0002J]RDq!!=\u0002d\u0002\u0007\u0011'\u0001\u0003uKb$\b\u0002CA{\u0003G\u0004\r!!;\u0002'5\f\u0007pU;qa>\u0014H/\u001a3WKJ\u001c\u0018n\u001c8\b\u000f\u0005e(\u0001#\u0001\u0002|\u0006y\u0001\n\u0012$T\u001b\u0016$\u0018\rZ1uC2{w\rE\u0002\u0019\u0003{4a!\u0001\u0002\t\u0002\u0005}8cAA\u007f#!9\u0011)!@\u0005\u0002\t\rACAA~\u0011!\u00119!!@\u0005\u0002\t%\u0011A\u0004<fe&4\u0017PQ1uG\"LEm\u001d\u000b\t\u0003+\u0012YAa\n\u0003*!A!Q\u0002B\u0003\u0001\u0004\u0011y!\u0001\u0005cCR\u001c\u0007.\u00133t!\u0019\u0011\tB!\t\u000249!!1\u0003B\u000f\u001d\u0011\u0011)Ba\u0007\u000e\u0005\t]!b\u0001B\r\u001d\u00051AH]8pizJ\u0011\u0001F\u0005\u0004\u0005?\u0019\u0012a\u00029bG.\fw-Z\u0005\u0005\u0005G\u0011)CA\u0002TKFT1Aa\b\u0014\u0011!\t\u0019L!\u0002A\u0002\u0005U\u0006\u0002CA]\u0005\u000b\u0001\r!!.")
public class HDFSMetadataLog<T>
implements MetadataLog<T>,
Logging {
    private final Formats formats;
    private final Manifest<T> manifest;
    private final Path metadataPath;
    private final CheckpointFileManager fileManager;
    private final PathFilter batchFilesFilter;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void verifyBatchIds(Seq<Object> seq, Option<Object> option, Option<Object> option2) {
        HDFSMetadataLog$.MODULE$.verifyBatchIds(seq, option, option2);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private Formats formats() {
        return this.formats;
    }

    private Manifest<T> manifest() {
        return this.manifest;
    }

    public Path metadataPath() {
        return this.metadataPath;
    }

    public CheckpointFileManager fileManager() {
        return this.fileManager;
    }

    public PathFilter batchFilesFilter() {
        return this.batchFilesFilter;
    }

    public Path batchIdToPath(long batchId) {
        return new Path(this.metadataPath(), ((Object)BoxesRunTime.boxToLong((long)batchId)).toString());
    }

    public long pathToBatchId(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
    }

    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public void serialize(T metadata, OutputStream out) {
        Serialization$.MODULE$.write(metadata, out, this.formats());
    }

    public T deserialize(InputStream in) {
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return (T)Serialization$.MODULE$.read((Reader)reader, this.formats(), this.manifest());
    }

    @Override
    public boolean add(long batchId, T metadata) {
        Predef$.MODULE$.require(metadata != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "'null' metadata cannot written to a metadata log";
            }
        });
        return BoxesRunTime.unboxToBoolean((Object)this.get(batchId).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(T x$1) {
                return false;
            }
        }).getOrElse((Function0)new Serializable(this, batchId, metadata){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;
            private final long batchId$1;
            private final Object metadata$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                this.$outer.org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$writeBatchToFile(this.metadata$1, this.$outer.batchIdToPath(this.batchId$1));
                return true;
            }
            {
                void var4_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batchId$1 = batchId$1;
                this.metadata$1 = var4_3;
            }
        }));
    }

    public void org$apache$spark$sql$execution$streaming$HDFSMetadataLog$$writeBatchToFile(T metadata, Path path) {
        CheckpointFileManager.CancellableFSDataOutputStream output2 = this.fileManager().createAtomic(path, false);
        try {
            this.serialize(metadata, (OutputStream)((Object)output2));
            output2.close();
            return;
        }
        catch (Throwable throwable) {
            output2.cancel();
            throw throwable;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            output2.cancel();
            throw new ConcurrentModificationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Multiple streaming queries are concurrently using ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})), fileAlreadyExistsException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Option<T> get(long batchId) {
        Some some;
        Path batchMetadataFile = this.batchIdToPath(batchId);
        if (!this.fileManager().exists(batchMetadataFile)) {
            this.logDebug((Function0<String>)new Serializable(this, batchMetadataFile){
                public static final long serialVersionUID = 0L;
                private final Path batchMetadataFile$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to find batch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.batchMetadataFile$1}));
                }
                {
                    this.batchMetadataFile$1 = batchMetadataFile$1;
                }
            });
            some = None$.MODULE$;
            return some;
        }
        FSDataInputStream input = this.fileManager().open(batchMetadataFile);
        try {
            some = new Some(this.deserialize((InputStream)input));
        }
        catch (IllegalStateException illegalStateException) {
            try {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to read log file ", ". ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{batchMetadataFile, illegalStateException.getMessage()})), illegalStateException);
            }
            catch (Throwable throwable) {
                void var4_3;
                IOUtils.closeQuietly((InputStream)var4_3);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        return some;
    }

    @Override
    public Tuple2<Object, T>[] get(Option<Object> startId, Option<Object> endId) {
        Predef$.MODULE$.assert(startId.isEmpty() || endId.isEmpty() || BoxesRunTime.unboxToLong((Object)startId.get()) <= BoxesRunTime.unboxToLong((Object)endId.get()));
        FileStatus[] files = this.fileManager().list(this.metadataPath(), this.batchFilesFilter());
        long[] batchIds = (long[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])files).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final long apply(FileStatus f) {
                return this.$outer.pathToBatchId(f.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).filter((Function1)new Serializable(this, startId, endId){
            public static final long serialVersionUID = 0L;
            private final Option startId$1;
            private final Option endId$1;

            public final boolean apply(long batchId) {
                return this.apply$mcZJ$sp(batchId);
            }

            public boolean apply$mcZJ$sp(long batchId) {
                return !(!this.endId$1.isEmpty() && batchId > BoxesRunTime.unboxToLong((Object)this.endId$1.get()) || !this.startId$1.isEmpty() && batchId < BoxesRunTime.unboxToLong((Object)this.startId$1.get()));
            }
            {
                void var3_3;
                this.startId$1 = startId$1;
                this.endId$1 = var3_3;
            }
        })).sorted((Ordering)Ordering.Long$.MODULE$);
        HDFSMetadataLog$.MODULE$.verifyBatchIds((Seq<Object>)Predef$.MODULE$.wrapLongArray(batchIds), startId, endId);
        return (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.longArrayOps(batchIds).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final Tuple2<Object, Option<T>> apply(long batchId) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), this.$outer.get(batchId));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Option<T>> x$2) {
                return ((Option)x$2._2()).isDefined();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, T> apply(Tuple2<Object, Option<T>> x0$1) {
                Tuple2<Object, Option<T>> tuple2 = x0$1;
                if (tuple2 != null) {
                    long batchId = tuple2._1$mcJ$sp();
                    Option metadataOption = (Option)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), metadataOption.get());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    @Override
    public Option<Tuple2<Object, T>> getLatest() {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Option option;
            Object object = new Object();
            try {
                long[] batchIds = (long[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HDFSMetadataLog $outer;

                    public final long apply(FileStatus f) {
                        return this.$outer.pathToBatchId(f.getPath());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sorted((Ordering)Ordering.Long$.MODULE$)).reverse();
                Predef$.MODULE$.longArrayOps(batchIds).foreach((Function1)new Serializable(this, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HDFSMetadataLog $outer;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(long batchId) {
                        this.apply$mcVJ$sp(batchId);
                    }

                    public void apply$mcVJ$sp(long batchId) {
                        Option<T> batch = this.$outer.get(batchId);
                        if (batch.isDefined()) {
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), batch.get())));
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                option = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                option = (Option)nonLocalReturnControl2.value();
            }
            return option;
        }
        throw nonLocalReturnControl2;
    }

    public FileStatus[] getOrderedBatchFiles() {
        return (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final long apply(FileStatus f) {
                return this.$outer.pathToBatchId(f.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Ordering)Ordering.Long$.MODULE$)).reverse();
    }

    @Override
    public void purge(long thresholdBatchId) {
        long[] batchIds = (long[])Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final long apply(FileStatus f) {
                return this.$outer.pathToBatchId(f.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        Predef$.MODULE$.longArrayOps(batchIds).withFilter((Function1)new Serializable(this, thresholdBatchId){
            public static final long serialVersionUID = 0L;
            private final long thresholdBatchId$1;

            public final boolean apply(long batchId) {
                return this.apply$mcZJ$sp(batchId);
            }

            public boolean apply$mcZJ$sp(long batchId) {
                return batchId < this.thresholdBatchId$1;
            }
            {
                this.thresholdBatchId$1 = thresholdBatchId$1;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final void apply(long batchId) {
                this.apply$mcVJ$sp(batchId);
            }

            public void apply$mcVJ$sp(long batchId) {
                Path path = this.$outer.batchIdToPath(batchId);
                this.$outer.fileManager().delete(path);
                this.$outer.logTrace((Function0<String>)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final Path path$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removed metadata log file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
                    }
                    {
                        this.path$1 = path$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void purgeAfter(long thresholdBatchId) {
        long[] batchIds = (long[])Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final long apply(FileStatus f) {
                return this.$outer.pathToBatchId(f.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        Predef$.MODULE$.longArrayOps(batchIds).withFilter((Function1)new Serializable(this, thresholdBatchId){
            public static final long serialVersionUID = 0L;
            private final long thresholdBatchId$2;

            public final boolean apply(long batchId) {
                return this.apply$mcZJ$sp(batchId);
            }

            public boolean apply$mcZJ$sp(long batchId) {
                return batchId > this.thresholdBatchId$2;
            }
            {
                this.thresholdBatchId$2 = thresholdBatchId$2;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HDFSMetadataLog $outer;

            public final void apply(long batchId) {
                this.apply$mcVJ$sp(batchId);
            }

            public void apply$mcVJ$sp(long batchId) {
                Path path = this.$outer.batchIdToPath(batchId);
                this.$outer.fileManager().delete(path);
                this.$outer.logTrace((Function0<String>)new Serializable(this, path){
                    public static final long serialVersionUID = 0L;
                    private final Path path$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removed metadata log file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$2}));
                    }
                    {
                        this.path$2 = path$2;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int parseVersion(String text, int maxSupportedVersion) {
        int version;
        if (text.length() <= 0 || StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(text), 0) != 'v') throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log file was malformed: failed to read correct log "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"version from ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{text}))).toString());
        try {
            version = new StringOps(Predef$.MODULE$.augmentString(text.substring(1, text.length()))).toInt();
            if (version <= 0) throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log file was malformed: failed to read correct log "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"version from ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{text}))).toString());
            if (version <= maxSupportedVersion) return version;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log file was malformed: failed to read correct log "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"version from ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{text}))).toString());
        }
        throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"UnsupportedLogVersion: maximum supported log version "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is v", ", but encountered v", ". The log file was produced "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxSupportedVersion), BoxesRunTime.boxToInteger((int)version)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"by a newer version of Spark and cannot be read by this version. Please upgrade."})).s((Seq)Nil$.MODULE$)).toString());
    }

    public HDFSMetadataLog(SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        Logging.class.$init$((Logging)this);
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        this.manifest = Predef$.MODULE$.Manifest().classType(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass());
        Class clazz = ((ClassTag)Predef$.MODULE$.implicitly(this.manifest())).runtimeClass();
        Class<Seq> clazz2 = Seq.class;
        Predef$.MODULE$.require(clazz != null ? !clazz.equals(clazz2) : clazz2 != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Should not create a log with type Seq, use Arrays instead - see SPARK-17372";
            }
        });
        this.metadataPath = new Path(path);
        this.fileManager = CheckpointFileManager$.MODULE$.create(this.metadataPath(), sparkSession.sessionState().newHadoopConf());
        if (!this.fileManager().exists(this.metadataPath())) {
            this.fileManager().mkdirs(this.metadataPath());
        }
        this.batchFilesFilter = new PathFilter(this){
            private final /* synthetic */ HDFSMetadataLog $outer;

            public boolean accept(Path path) {
                return this.$outer.isBatchFile(path);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

