/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import com.univocity.parsers.csv.CsvParser;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.spark.input.PortableDataStream;
import org.apache.spark.input.StreamInputFormat;
import org.apache.spark.rdd.BinaryFileRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVInferSchema$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.execution.datasources.csv.UnivocityParser;
import org.apache.spark.sql.execution.datasources.csv.UnivocityParser$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class MultiLineCSVDataSource$
extends CSVDataSource {
    public static final MultiLineCSVDataSource$ MODULE$;
    private final boolean isSplitable;

    static {
        new MultiLineCSVDataSource$();
    }

    @Override
    public boolean isSplitable() {
        return this.isSplitable;
    }

    @Override
    public Iterator<InternalRow> readFile(Configuration conf, PartitionedFile file, UnivocityParser parser, StructType requiredSchema, StructType dataSchema, boolean caseSensitive, boolean columnPruning) {
        return UnivocityParser$.MODULE$.parseStream(CodecStreams$.MODULE$.createInputStreamWithCloseResource(conf, new Path(new URI(file.filePath()))), parser.options().headerFlag(), parser, requiredSchema, (Function1<String[], BoxedUnit>)new Serializable(file, parser, requiredSchema, dataSchema, caseSensitive, columnPruning){
            public static final long serialVersionUID = 0L;
            private final PartitionedFile file$2;
            private final UnivocityParser parser$3;
            private final StructType requiredSchema$2;
            private final StructType dataSchema$2;
            private final boolean caseSensitive$3;
            private final boolean columnPruning$2;

            public final void apply(String[] header) {
                MultiLineCSVDataSource$.MODULE$.org$apache$spark$sql$execution$datasources$csv$MultiLineCSVDataSource$$checkHeader$1(header, this.file$2, this.parser$3, this.requiredSchema$2, this.dataSchema$2, this.caseSensitive$3, this.columnPruning$2);
            }
            {
                this.file$2 = file$2;
                this.parser$3 = parser$3;
                this.requiredSchema$2 = requiredSchema$2;
                this.dataSchema$2 = dataSchema$2;
                this.caseSensitive$3 = caseSensitive$3;
                this.columnPruning$2 = columnPruning$2;
            }
        });
    }

    @Override
    public StructType infer(SparkSession sparkSession, Seq<FileStatus> inputPaths, CSVOptions parsedOptions) {
        Option option;
        block4: {
            StructType structType;
            block3: {
                block2: {
                    RDD<PortableDataStream> csv = this.createBaseRdd(sparkSession, inputPaths, parsedOptions);
                    option = Predef$.MODULE$.refArrayOps((Object[])csv.flatMap((Function1)new Serializable(parsedOptions){
                        public static final long serialVersionUID = 0L;
                        private final CSVOptions parsedOptions$2;

                        public final Iterator<String[]> apply(PortableDataStream lines) {
                            Path path = new Path(lines.getPath());
                            return UnivocityParser$.MODULE$.tokenizeStream(CodecStreams$.MODULE$.createInputStreamWithCloseResource(lines.getConfiguration(), path), false, new CsvParser(this.parsedOptions$2.asParserSettings()));
                        }
                        {
                            this.parsedOptions$2 = parsedOptions$2;
                        }
                    }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).take(1)).headOption();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String[] firstRow = (String[])some.x();
                    boolean caseSensitive = sparkSession.sessionState().conf().caseSensitiveAnalysis();
                    String[] header = this.makeSafeHeader(firstRow, caseSensitive, parsedOptions);
                    RDD tokenRDD = csv.flatMap((Function1)new Serializable(parsedOptions){
                        public static final long serialVersionUID = 0L;
                        private final CSVOptions parsedOptions$2;

                        public final Iterator<String[]> apply(PortableDataStream lines) {
                            return UnivocityParser$.MODULE$.tokenizeStream(CodecStreams$.MODULE$.createInputStreamWithCloseResource(lines.getConfiguration(), new Path(lines.getPath())), this.parsedOptions$2.headerFlag(), new CsvParser(this.parsedOptions$2.asParserSettings()));
                        }
                        {
                            this.parsedOptions$2 = parsedOptions$2;
                        }
                    }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
                    RDD<String[]> sampled = CSVUtils$.MODULE$.sample((RDD<String[]>)tokenRDD, parsedOptions);
                    structType = CSVInferSchema$.MODULE$.infer(sampled, header, parsedOptions);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                structType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
            return structType;
        }
        throw new MatchError((Object)option);
    }

    private RDD<PortableDataStream> createBaseRdd(SparkSession sparkSession, Seq<FileStatus> inputPaths, CSVOptions options) {
        Seq paths = (Seq)inputPaths.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Path apply(FileStatus x$14) {
                return x$14.getPath();
            }
        }, Seq$.MODULE$.canBuildFrom());
        String name2 = paths.mkString(",");
        Job job = Job.getInstance((Configuration)sparkSession.sessionState().newHadoopConfWithOptions((Map<String, String>)options.parameters()));
        FileInputFormat.setInputPaths((Job)job, (Path[])((Path[])paths.toArray(ClassTag$.MODULE$.apply(Path.class))));
        Configuration conf = job.getConfiguration();
        BinaryFileRDD rdd2 = new BinaryFileRDD(sparkSession.sparkContext(), StreamInputFormat.class, String.class, PortableDataStream.class, conf, sparkSession.sparkContext().defaultMinPartitions());
        return RDD$.MODULE$.rddToPairRDDFunctions(rdd2.setName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CSVFile: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name2}))), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(PortableDataStream.class), (Ordering)Ordering.String$.MODULE$).values();
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final void org$apache$spark$sql$execution$datasources$csv$MultiLineCSVDataSource$$checkHeader$1(String[] header, PartitionedFile file$2, UnivocityParser parser$3, StructType requiredSchema$2, StructType dataSchema$2, boolean caseSensitive$3, boolean columnPruning$2) {
        StructType actualRequiredSchema = StructType$.MODULE$.apply((Seq)requiredSchema$2.filterNot((Function1)new Serializable(parser$3){
            public static final long serialVersionUID = 0L;
            private final UnivocityParser parser$3;

            public final boolean apply(StructField x$12) {
                String string = x$12.name();
                String string2 = this.parser$3.options().columnNameOfCorruptRecord();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.parser$3 = parser$3;
            }
        }));
        StructType actualDataSchema = StructType$.MODULE$.apply((Seq)dataSchema$2.filterNot((Function1)new Serializable(parser$3){
            public static final long serialVersionUID = 0L;
            private final UnivocityParser parser$3;

            public final boolean apply(StructField x$13) {
                String string = x$13.name();
                String string2 = this.parser$3.options().columnNameOfCorruptRecord();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.parser$3 = parser$3;
            }
        }));
        StructType schema2 = columnPruning$2 ? actualRequiredSchema : actualDataSchema;
        CSVDataSource$.MODULE$.checkHeaderColumnNames(schema2, header, file$2.filePath(), parser$3.options().enforceSchema(), caseSensitive$3);
    }

    private MultiLineCSVDataSource$() {
        MODULE$ = this;
        this.isSplitable = false;
    }
}

