/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.sql.execution.streaming.LongOffset;
import org.apache.spark.sql.execution.streaming.LongOffset$;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.RateSourceProvider$;
import org.apache.spark.sql.execution.streaming.RateStreamSource$;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.Source$class;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.apache.spark.util.SystemClock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\u0001\u0003\u0001=\u0011\u0001CU1uKN#(/Z1n'>,(oY3\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\r\u001d!\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003mC:<'\"A\u000b\u0002\t)\fg/Y\u0005\u0003/I\u0011aa\u00142kK\u000e$\bCA\r\u001b\u001b\u0005\u0011\u0011BA\u000e\u0003\u0005\u0019\u0019v.\u001e:dKB\u0011Q\u0004I\u0007\u0002=)\u0011q\u0004C\u0001\tS:$XM\u001d8bY&\u0011\u0011E\b\u0002\b\u0019><w-\u001b8h\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013AC:rY\u000e{g\u000e^3yiB\u0011QEJ\u0007\u0002\r%\u0011qE\u0002\u0002\u000b'Fc5i\u001c8uKb$\b\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\u00195,G/\u00193bi\u0006\u0004\u0016\r\u001e5\u0011\u0005-\ndB\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj\u0013A\u0002)sK\u0012,g-\u0003\u00023g\t11\u000b\u001e:j]\u001eT!\u0001M\u0017\t\u0011U\u0002!\u0011!Q\u0001\nY\nQB]8xgB+'oU3d_:$\u0007C\u0001\u00178\u0013\tATF\u0001\u0003M_:<\u0007\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\u0002#I\fW\u000e]+q)&lWmU3d_:$7\u000f\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003>\u00035qW/\u001c)beRLG/[8ogB\u0011AFP\u0005\u0003\u007f5\u00121!\u00138u\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0015AD;tK6\u000bg.^1m\u00072|7m\u001b\t\u0003Y\rK!\u0001R\u0017\u0003\u000f\t{w\u000e\\3b]\")a\t\u0001C\u0001\u000f\u00061A(\u001b8jiz\"r\u0001S%K\u00172ke\n\u0005\u0002\u001a\u0001!)1%\u0012a\u0001I!)\u0011&\u0012a\u0001U!)Q'\u0012a\u0001m!)!(\u0012a\u0001m!)A(\u0012a\u0001{!)\u0011)\u0012a\u0001\u0005\"9\u0001\u000b\u0001b\u0001\n\u0003\t\u0016!B2m_\u000e\\W#\u0001*\u0011\u0005M3V\"\u0001+\u000b\u0005UC\u0011\u0001B;uS2L!a\u0016+\u0003\u000b\rcwnY6\t\re\u0003\u0001\u0015!\u0003S\u0003\u0019\u0019Gn\\2lA!91\f\u0001b\u0001\n\u0013a\u0016AC7bqN+7m\u001c8egV\ta\u0007\u0003\u0004_\u0001\u0001\u0006IAN\u0001\f[\u0006D8+Z2p]\u0012\u001c\b\u0005C\u0004a\u0001\t\u0007I\u0011\u0002/\u0002\u0017M$\u0018M\u001d;US6,Wj\u001d\u0005\u0007E\u0002\u0001\u000b\u0011\u0002\u001c\u0002\u0019M$\u0018M\u001d;US6,Wj\u001d\u0011\t\u000f\u0011\u0004\u0001\u0019!C\u00059\u0006QA.Y:u)&lW-T:\t\u000f\u0019\u0004\u0001\u0019!C\u0005O\u0006qA.Y:u)&lW-T:`I\u0015\fHC\u00015l!\ta\u0013.\u0003\u0002k[\t!QK\\5u\u0011\u001daW-!AA\u0002Y\n1\u0001\u001f\u00132\u0011\u0019q\u0007\u0001)Q\u0005m\u0005YA.Y:u)&lW-T:!Q\ti\u0007\u000f\u0005\u0002-c&\u0011!/\f\u0002\tm>d\u0017\r^5mK\")A\u000f\u0001C!k\u000611o\u00195f[\u0006,\u0012A\u001e\t\u0003ojl\u0011\u0001\u001f\u0006\u0003s\u001a\tQ\u0001^=qKNL!a\u001f=\u0003\u0015M#(/^2u)f\u0004X\rC\u0003~\u0001\u0011\u0005c0A\u0005hKR|eMZ:fiV\tq\u0010E\u0003-\u0003\u0003\t)!C\u0002\u0002\u00045\u0012aa\u00149uS>t\u0007cA\r\u0002\b%\u0019\u0011\u0011\u0002\u0002\u0003\r=3gm]3u\u0011\u001d\ti\u0001\u0001C!\u0003\u001f\t\u0001bZ3u\u0005\u0006$8\r\u001b\u000b\u0007\u0003#\t)$!\u000f\u0011\t\u0005M\u0011q\u0006\b\u0005\u0003+\tYC\u0004\u0003\u0002\u0018\u0005%b\u0002BA\r\u0003OqA!a\u0007\u0002&9!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"9\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"C\u0002\u0002.\u0019\tq\u0001]1dW\u0006<W-\u0003\u0003\u00022\u0005M\"!\u0003#bi\u00064%/Y7f\u0015\r\tiC\u0002\u0005\b\u0003o\tY\u00011\u0001\u0000\u0003\u0015\u0019H/\u0019:u\u0011!\tY$a\u0003A\u0002\u0005\u0015\u0011aA3oI\"9\u0011q\b\u0001\u0005B\u0005\u0005\u0013\u0001B:u_B$\u0012\u0001\u001b\u0005\b\u0003\u000b\u0002A\u0011IA$\u0003!!xn\u0015;sS:<G#\u0001\u0016\b\u000f\u0005-#\u0001#\u0001\u0002N\u0005\u0001\"+\u0019;f'R\u0014X-Y7T_V\u00148-\u001a\t\u00043\u0005=cAB\u0001\u0003\u0011\u0003\t\tf\u0005\u0003\u0002P\u0005M\u0003c\u0001\u0017\u0002V%\u0019\u0011qK\u0017\u0003\r\u0005s\u0017PU3g\u0011\u001d1\u0015q\nC\u0001\u00037\"\"!!\u0014\t\u0011\u0005}\u0013q\nC\u0001\u0003C\nQB^1mk\u0016\fEoU3d_:$Gc\u0002\u001c\u0002d\u0005\u001d\u0014\u0011\u000e\u0005\b\u0003K\ni\u00061\u00017\u0003\u001d\u0019XmY8oINDa!NA/\u0001\u00041\u0004B\u0002\u001e\u0002^\u0001\u0007a\u0007")
public class RateStreamSource
implements Source,
Logging {
    public final SQLContext org$apache$spark$sql$execution$streaming$RateStreamSource$$sqlContext;
    public final String org$apache$spark$sql$execution$streaming$RateStreamSource$$metadataPath;
    private final long rowsPerSecond;
    private final long rampUpTimeSeconds;
    private final int numPartitions;
    private final Clock clock;
    private final long maxSeconds;
    private final long startTimeMs;
    private volatile long lastTimeMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static long valueAtSecond(long l, long l2, long l3) {
        return RateStreamSource$.MODULE$.valueAtSecond(l, l2, l3);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    @Override
    public void commit(Offset end) {
        Source$class.commit(this, end);
    }

    public Clock clock() {
        return this.clock;
    }

    private long maxSeconds() {
        return this.maxSeconds;
    }

    private long startTimeMs() {
        return this.startTimeMs;
    }

    private long lastTimeMs() {
        return this.lastTimeMs;
    }

    private void lastTimeMs_$eq(long x$1) {
        this.lastTimeMs = x$1;
    }

    @Override
    public StructType schema() {
        return RateSourceProvider$.MODULE$.SCHEMA();
    }

    @Override
    public Option<Offset> getOffset() {
        long now = this.clock().getTimeMillis();
        if (this.lastTimeMs() < now) {
            this.lastTimeMs_$eq(now);
        }
        return new Some((Object)new LongOffset(TimeUnit.MILLISECONDS.toSeconds(this.lastTimeMs() - this.startTimeMs())));
    }

    @Override
    public Dataset<Row> getBatch(Option<Offset> start2, Offset end) {
        long endSeconds;
        long startSeconds = BoxesRunTime.unboxToLong((Object)start2.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(Offset x$7) {
                return LongOffset$.MODULE$.convert(x$7).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(LongOffset x$8) {
                        return x$8.offset();
                    }
                });
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        Predef$.MODULE$.assert(startSeconds <= (endSeconds = BoxesRunTime.unboxToLong((Object)LongOffset$.MODULE$.convert(end).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LongOffset x$9) {
                return x$9.offset();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }))), (Function0)new Serializable(this, startSeconds, endSeconds){
            public static final long serialVersionUID = 0L;
            private final long startSeconds$1;
            private final long endSeconds$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"startSeconds(", ") > endSeconds(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.startSeconds$1), BoxesRunTime.boxToLong((long)this.endSeconds$1)}));
            }
            {
                this.startSeconds$1 = startSeconds$1;
                this.endSeconds$1 = endSeconds$1;
            }
        });
        if (endSeconds > this.maxSeconds()) {
            throw new ArithmeticException(new StringBuilder().append((Object)"Integer overflow. Max offset with ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " rowsPerSecond is ", ", but it's ", " now."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.rowsPerSecond), BoxesRunTime.boxToLong((long)this.maxSeconds()), BoxesRunTime.boxToLong((long)endSeconds)}))).toString());
        }
        if (this.lastTimeMs() < TimeUnit.SECONDS.toMillis(endSeconds) + this.startTimeMs()) {
            this.lastTimeMs_$eq(TimeUnit.SECONDS.toMillis(endSeconds) + this.startTimeMs());
        }
        long rangeStart = RateStreamSource$.MODULE$.valueAtSecond(startSeconds, this.rowsPerSecond, this.rampUpTimeSeconds);
        long rangeEnd = RateStreamSource$.MODULE$.valueAtSecond(endSeconds, this.rowsPerSecond, this.rampUpTimeSeconds);
        this.logDebug((Function0<String>)new Serializable(this, startSeconds, endSeconds, rangeStart, rangeEnd){
            public static final long serialVersionUID = 0L;
            private final long startSeconds$1;
            private final long endSeconds$1;
            private final long rangeStart$1;
            private final long rangeEnd$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"startSeconds: ", ", endSeconds: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.startSeconds$1), BoxesRunTime.boxToLong((long)this.endSeconds$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rangeStart: ", ", rangeEnd: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.rangeStart$1), BoxesRunTime.boxToLong((long)this.rangeEnd$1)}))).toString();
            }
            {
                this.startSeconds$1 = startSeconds$1;
                this.endSeconds$1 = endSeconds$1;
                this.rangeStart$1 = rangeStart$1;
                this.rangeEnd$1 = rangeEnd$1;
            }
        });
        if (rangeStart == rangeEnd) {
            return this.org$apache$spark$sql$execution$streaming$RateStreamSource$$sqlContext.internalCreateDataFrame((RDD<InternalRow>)this.org$apache$spark$sql$execution$streaming$RateStreamSource$$sqlContext.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(InternalRow.class)), this.schema(), true);
        }
        long localStartTimeMs = this.startTimeMs() + TimeUnit.SECONDS.toMillis(startSeconds);
        double relativeMsPerValue = (double)TimeUnit.SECONDS.toMillis(endSeconds - startSeconds) / (double)(rangeEnd - rangeStart);
        RDD rdd2 = this.org$apache$spark$sql$execution$streaming$RateStreamSource$$sqlContext.sparkContext().range(rangeStart, rangeEnd, 1L, this.numPartitions).map((Function1)new Serializable(this, rangeStart, localStartTimeMs, relativeMsPerValue){
            public static final long serialVersionUID = 0L;
            private final long rangeStart$1;
            private final long localStartTimeMs$1;
            private final double relativeMsPerValue$1;

            public final InternalRow apply(long v) {
                long relative = package$.MODULE$.round((double)(v - this.rangeStart$1) * this.relativeMsPerValue$1);
                return InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromMillis(relative + this.localStartTimeMs$1)), BoxesRunTime.boxToLong((long)v)}));
            }
            {
                this.rangeStart$1 = rangeStart$1;
                this.localStartTimeMs$1 = localStartTimeMs$1;
                this.relativeMsPerValue$1 = relativeMsPerValue$1;
            }
        }, ClassTag$.MODULE$.apply(InternalRow.class));
        return this.org$apache$spark$sql$execution$streaming$RateStreamSource$$sqlContext.internalCreateDataFrame((RDD<InternalRow>)rdd2, this.schema(), true);
    }

    @Override
    public void stop() {
    }

    public String toString() {
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RateSource[rowsPerSecond=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.rowsPerSecond)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rampUpTimeSeconds=", ", numPartitions=", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.rampUpTimeSeconds), BoxesRunTime.boxToInteger((int)this.numPartitions)}))).toString();
    }

    public RateStreamSource(SQLContext sqlContext, String metadataPath, long rowsPerSecond, long rampUpTimeSeconds, int numPartitions, boolean useManualClock) {
        this.org$apache$spark$sql$execution$streaming$RateStreamSource$$sqlContext = sqlContext;
        this.org$apache$spark$sql$execution$streaming$RateStreamSource$$metadataPath = metadataPath;
        this.rowsPerSecond = rowsPerSecond;
        this.rampUpTimeSeconds = rampUpTimeSeconds;
        this.numPartitions = numPartitions;
        Source$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.clock = useManualClock ? new ManualClock() : new SystemClock();
        this.maxSeconds = Long.MAX_VALUE / rowsPerSecond;
        if (rampUpTimeSeconds > this.maxSeconds()) {
            throw new ArithmeticException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Integer overflow. Max offset with ", " rowsPerSecond"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)rowsPerSecond)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" is ", ", but 'rampUpTimeSeconds' is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.maxSeconds()), BoxesRunTime.boxToLong((long)rampUpTimeSeconds)}))).toString());
        }
        HDFSMetadataLog<LongOffset> metadataLog = new HDFSMetadataLog<LongOffset>(this){

            public void serialize(LongOffset metadata, OutputStream out) {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
                writer.write(new StringBuilder().append((Object)"v").append((Object)BoxesRunTime.boxToInteger((int)RateSourceProvider$.MODULE$.VERSION())).append((Object)"\n").toString());
                writer.write(metadata.json());
                writer.flush();
            }

            public LongOffset deserialize(InputStream in) {
                String content = IOUtils.toString((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
                Predef$.MODULE$.assert(content.length() != 0);
                if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(content), 0) == 'v') {
                    int indexOfNewLine = content.indexOf("\n");
                    if (indexOfNewLine > 0) {
                        int version = this.parseVersion(content.substring(0, indexOfNewLine), RateSourceProvider$.MODULE$.VERSION());
                        return LongOffset$.MODULE$.apply(new SerializedOffset(content.substring(indexOfNewLine + 1)));
                    }
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log file was malformed: failed to detect the log file version line."})).s((Seq)Nil$.MODULE$));
                }
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log file was malformed: failed to detect the log file version line."})).s((Seq)Nil$.MODULE$));
            }
        };
        this.startTimeMs = ((LongOffset)metadataLog.get(0L).getOrElse((Function0)new Serializable(this, metadataLog){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RateStreamSource $outer;
            private final HDFSMetadataLog metadataLog$1;

            /*
             * WARNING - void declaration
             */
            public final LongOffset apply() {
                void var1_1;
                LongOffset offset = new LongOffset(this.$outer.clock().getTimeMillis());
                this.metadataLog$1.add(0L, offset);
                this.$outer.logInfo((Function0<String>)new Serializable(this, offset){
                    public static final long serialVersionUID = 0L;
                    private final LongOffset offset$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Start time: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.offset$1}));
                    }
                    {
                        this.offset$1 = offset$1;
                    }
                });
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.metadataLog$1 = metadataLog$1;
            }
        })).offset();
        this.lastTimeMs = this.startTimeMs();
    }
}

