/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.util.Map;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.Catalog;
import org.apache.spark.sql.catalog.Column;
import org.apache.spark.sql.catalog.Database;
import org.apache.spark.sql.catalog.Function;
import org.apache.spark.sql.catalog.Table;
import org.apache.spark.sql.catalyst.DefinedByConstructorParams;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.internal.CatalogImpl$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;

@ScalaSignature(bytes="\u0006\u0001\r-a\u0001B\u0001\u0003\u00015\u00111bQ1uC2|w-S7qY*\u00111\u0001B\u0001\tS:$XM\u001d8bY*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tqaY1uC2|w-\u0003\u0002\u0014!\t91)\u0019;bY><\u0007\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005]AR\"\u0001\u0003\n\u0005e!!\u0001D*qCJ\\7+Z:tS>t\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001e?A\u0011a\u0004A\u0007\u0002\u0005!)QC\u0007a\u0001-!)\u0011\u0005\u0001C\u0005E\u0005q1/Z:tS>t7)\u0019;bY><W#A\u0012\u0011\u0005\u0011BS\"A\u0013\u000b\u0005E1#BA\u0014\u0005\u0003!\u0019\u0017\r^1msN$\u0018BA\u0015&\u00059\u0019Vm]:j_:\u001c\u0015\r^1m_\u001eDQa\u000b\u0001\u0005\n1\nQC]3rk&\u0014X\rR1uC\n\f7/Z#ySN$8\u000f\u0006\u0002.gA\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t!QK\\5u\u0011\u0015!$\u00061\u00016\u0003\u0019!'MT1nKB\u0011a'\u000f\b\u0003]]J!\u0001O\u0018\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003q=BQ!\u0010\u0001\u0005\ny\n!C]3rk&\u0014X\rV1cY\u0016,\u00050[:ugR\u0019Qf\u0010!\t\u000bQb\u0004\u0019A\u001b\t\u000b\u0005c\u0004\u0019A\u001b\u0002\u0013Q\f'\r\\3OC6,\u0007\"B\"\u0001\t\u0003\"\u0015aD2veJ,g\u000e\u001e#bi\u0006\u0014\u0017m]3\u0016\u0003UBQA\u0012\u0001\u0005B\u001d\u000b!c]3u\u0007V\u0014(/\u001a8u\t\u0006$\u0018MY1tKR\u0011Q\u0006\u0013\u0005\u0006i\u0015\u0003\r!\u000e\u0015\u0004\u000b*\u0003\u0006c\u0001\u0018L\u001b&\u0011Aj\f\u0002\u0007i\"\u0014xn^:\u0011\u0005]q\u0015BA(\u0005\u0005E\te.\u00197zg&\u001cX\t_2faRLwN\\\u0011\u0002#\u00069B-\u0019;bE\u0006\u001cX\r\t3pKN\u0004cn\u001c;!KbL7\u000f\u001e\u0005\u0006'\u0002!\t\u0005V\u0001\u000eY&\u001cH\u000fR1uC\n\f7/Z:\u0015\u0003U\u00032a\u0006,Y\u0013\t9FAA\u0004ECR\f7/\u001a;\u0011\u0005=I\u0016B\u0001.\u0011\u0005!!\u0015\r^1cCN,\u0007\"\u0002/\u0001\t\u0013i\u0016\u0001D7bW\u0016$\u0015\r^1cCN,GC\u0001-_\u0011\u0015!4\f1\u00016\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0003)a\u0017n\u001d;UC\ndWm\u001d\u000b\u0002EB\u0019qCV2\u0011\u0005=!\u0017BA3\u0011\u0005\u0015!\u0016M\u00197f\u0011\u0015\u0001\u0007\u0001\"\u0011h)\t\u0011\u0007\u000eC\u00035M\u0002\u0007Q\u0007K\u0002g\u0015BCQa\u001b\u0001\u0005\n1\f\u0011\"\\1lKR\u000b'\r\\3\u0015\u0005\rl\u0007\"\u00028k\u0001\u0004y\u0017A\u0003;bE2,\u0017\nZ3oiB\u0011\u0001/]\u0007\u0002M%\u0011!O\n\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\")A\u000f\u0001C!k\u0006iA.[:u\rVt7\r^5p]N$\u0012A\u001e\t\u0004/Y;\bCA\by\u0013\tI\bC\u0001\u0005Gk:\u001cG/[8o\u0011\u0015!\b\u0001\"\u0011|)\t1H\u0010C\u00035u\u0002\u0007Q\u0007K\u0002{\u0015BCaa \u0001\u0005\n\u0005\u0005\u0011\u0001D7bW\u00164UO\\2uS>tGcA<\u0002\u0004!9\u0011Q\u0001@A\u0002\u0005\u001d\u0011!\u00034v]\u000eLE-\u001a8u!\r\u0001\u0018\u0011B\u0005\u0004\u0003\u00171#A\u0005$v]\u000e$\u0018n\u001c8JI\u0016tG/\u001b4jKJDq!a\u0004\u0001\t\u0003\n\t\"A\u0006mSN$8i\u001c7v[:\u001cH\u0003BA\n\u00037\u0001Ba\u0006,\u0002\u0016A\u0019q\"a\u0006\n\u0007\u0005e\u0001C\u0001\u0004D_2,XN\u001c\u0005\u0007\u0003\u00065\u0001\u0019A\u001b)\u000b\u00055!*a\b\"\u0005\u0005\u0005\u0012\u0001\u0006;bE2,\u0007\u0005Z8fg\u0002rw\u000e\u001e\u0011fq&\u001cH\u000fC\u0004\u0002\u0010\u0001!\t%!\n\u0015\r\u0005M\u0011qEA\u0015\u0011\u0019!\u00141\u0005a\u0001k!1\u0011)a\tA\u0002UBS!a\tK\u0003[\t#!a\f\u0002A\u0011\fG/\u00192bg\u0016\u0004sN\u001d\u0011uC\ndW\r\t3pKN\u0004cn\u001c;!KbL7\u000f\u001e\u0005\b\u0003\u001f\u0001A\u0011BA\u001a)\u0011\t\u0019\"!\u000e\t\u000f\u0005]\u0012\u0011\u0007a\u0001_\u0006yA/\u00192mK&#WM\u001c;jM&,'\u000fC\u0004\u0002<\u0001!\t%!\u0010\u0002\u0017\u001d,G\u000fR1uC\n\f7/\u001a\u000b\u00041\u0006}\u0002B\u0002\u001b\u0002:\u0001\u0007Q\u0007C\u0004\u0002D\u0001!\t%!\u0012\u0002\u0011\u001d,G\u000fV1cY\u0016$2aYA$\u0011\u0019\t\u0015\u0011\ta\u0001k!9\u00111\t\u0001\u0005B\u0005-C#B2\u0002N\u0005=\u0003B\u0002\u001b\u0002J\u0001\u0007Q\u0007\u0003\u0004B\u0003\u0013\u0002\r!\u000e\u0005\b\u0003'\u0002A\u0011IA+\u0003-9W\r\u001e$v]\u000e$\u0018n\u001c8\u0015\u0007]\f9\u0006C\u0004\u0002Z\u0005E\u0003\u0019A\u001b\u0002\u0019\u0019,hn\u0019;j_:t\u0015-\\3\t\u000f\u0005M\u0003\u0001\"\u0011\u0002^Q)q/a\u0018\u0002b!1A'a\u0017A\u0002UBq!!\u0017\u0002\\\u0001\u0007Q\u0007C\u0004\u0002f\u0001!\t%a\u001a\u0002\u001d\u0011\fG/\u00192bg\u0016,\u00050[:ugR!\u0011\u0011NA8!\rq\u00131N\u0005\u0004\u0003[z#a\u0002\"p_2,\u0017M\u001c\u0005\u0007i\u0005\r\u0004\u0019A\u001b\t\u000f\u0005M\u0004\u0001\"\u0011\u0002v\u0005YA/\u00192mK\u0016C\u0018n\u001d;t)\u0011\tI'a\u001e\t\r\u0005\u000b\t\b1\u00016\u0011\u001d\t\u0019\b\u0001C!\u0003w\"b!!\u001b\u0002~\u0005}\u0004B\u0002\u001b\u0002z\u0001\u0007Q\u0007\u0003\u0004B\u0003s\u0002\r!\u000e\u0005\b\u0003\u0007\u0003A\u0011IAC\u000391WO\\2uS>tW\t_5tiN$B!!\u001b\u0002\b\"9\u0011\u0011LAA\u0001\u0004)\u0004bBAB\u0001\u0011\u0005\u00131\u0012\u000b\u0007\u0003S\ni)a$\t\rQ\nI\t1\u00016\u0011\u001d\tI&!#A\u0002UBq!a%\u0001\t\u0003\n)*A\nde\u0016\fG/Z#yi\u0016\u0014h.\u00197UC\ndW\r\u0006\u0004\u0002\u0018\u0006m\u0016Q\u0018\t\u0005\u00033\u000b)L\u0004\u0003\u0002\u001c\u0006Ef\u0002BAO\u0003_sA!a(\u0002.:!\u0011\u0011UAV\u001d\u0011\t\u0019+!+\u000e\u0005\u0005\u0015&bAAT\u0019\u00051AH]8pizJ\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011bAAZ\t\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\\\u0003s\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u0005MF\u0001\u0003\u0004B\u0003#\u0003\r!\u000e\u0005\b\u0003\u007f\u000b\t\n1\u00016\u0003\u0011\u0001\u0018\r\u001e5)\t\u0005E\u00151\u0019\t\u0005\u0003\u000b\fY-\u0004\u0002\u0002H*\u0019\u0011\u0011\u001a\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002N\u0006\u001d'\u0001D#ya\u0016\u0014\u0018.\\3oi\u0006d\u0007bBAJ\u0001\u0011\u0005\u0013\u0011\u001b\u000b\t\u0003/\u000b\u0019.!6\u0002X\"1\u0011)a4A\u0002UBq!a0\u0002P\u0002\u0007Q\u0007C\u0004\u0002Z\u0006=\u0007\u0019A\u001b\u0002\rM|WO]2fQ\u0011\ty-a1\t\u000f\u0005M\u0005\u0001\"\u0011\u0002`RA\u0011qSAq\u0003G\f)\u000f\u0003\u0004B\u0003;\u0004\r!\u000e\u0005\b\u00033\fi\u000e1\u00016\u0011!\t9/!8A\u0002\u0005%\u0018aB8qi&|gn\u001d\t\u0007\u0003W\f)0N\u001b\u000e\u0005\u00055(\u0002BAx\u0003c\fA!\u001e;jY*\u0011\u00111_\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002x\u00065(aA'ba\"\"\u0011Q\\Ab\u0011\u001d\t\u0019\n\u0001C!\u0003{$\u0002\"a&\u0002\u0000\n\u0005!1\u0001\u0005\u0007\u0003\u0006m\b\u0019A\u001b\t\u000f\u0005e\u00171 a\u0001k!A\u0011q]A~\u0001\u0004\u0011)\u0001E\u00037\u0005\u000f)T'C\u0002\u0002xnBC!a?\u0002D\"9\u00111\u0013\u0001\u0005B\t5ACCAL\u0005\u001f\u0011\tBa\u0005\u0003$!1\u0011Ia\u0003A\u0002UBq!!7\u0003\f\u0001\u0007Q\u0007\u0003\u0005\u0003\u0016\t-\u0001\u0019\u0001B\f\u0003\u0019\u00198\r[3nCB!!\u0011\u0004B\u0010\u001b\t\u0011YBC\u0002\u0003\u001e\u0011\tQ\u0001^=qKNLAA!\t\u0003\u001c\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0011\u0005\u001d(1\u0002a\u0001\u0003SDCAa\u0003\u0002D\"9\u00111\u0013\u0001\u0005B\t%BCCAL\u0005W\u0011iCa\f\u00032!1\u0011Ia\nA\u0002UBq!!7\u0003(\u0001\u0007Q\u0007\u0003\u0005\u0003\u0016\t\u001d\u0002\u0019\u0001B\f\u0011!\t9Oa\nA\u0002\t\u0015\u0001\u0006\u0002B\u0014\u0003\u0007DqAa\u000e\u0001\t\u0003\u0012I$\u0001\u0007ee>\u0004H+Z7q-&,w\u000f\u0006\u0003\u0002j\tm\u0002b\u0002B\u001f\u0005k\u0001\r!N\u0001\tm&,wOT1nK\"9!\u0011\t\u0001\u0005B\t\r\u0013A\u00053s_B<En\u001c2bYR+W\u000e\u001d,jK^$B!!\u001b\u0003F!9!Q\bB \u0001\u0004)\u0004b\u0002B%\u0001\u0011\u0005#1J\u0001\tSN\u001c\u0015m\u00195fIR!\u0011\u0011\u000eB'\u0011\u0019\t%q\ta\u0001k!9!\u0011\u000b\u0001\u0005B\tM\u0013AC2bG\",G+\u00192mKR\u0019QF!\u0016\t\r\u0005\u0013y\u00051\u00016\u0011\u001d\u0011I\u0006\u0001C!\u00057\nA\"\u001e8dC\u000eDW\rV1cY\u0016$2!\fB/\u0011\u0019\t%q\u000ba\u0001k!9!\u0011\r\u0001\u0005B\t\r\u0014AC2mK\u0006\u00148)Y2iKR\tQ\u0006\u0003\u0005\u0003J\u0001!\t\u0002\u0002B4)\u0011\tIG!\u001b\t\u0011\t-$Q\ra\u0001\u0005[\nQ!\u001d(b[\u0016\u0004DAa\u001c\u0003vA!qC\u0016B9!\u0011\u0011\u0019H!\u001e\r\u0001\u0011a!q\u000fB5\u0003\u0003\u0005\tQ!\u0001\u0003z\t\u0019q\fJ\u0019\u0012\t\tm$\u0011\u0011\t\u0004]\tu\u0014b\u0001B@_\t9aj\u001c;iS:<\u0007c\u0001\u0018\u0003\u0004&\u0019!QQ\u0018\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003\n\u0002!\tEa#\u0002\u0019I,gM]3tQR\u000b'\r\\3\u0015\u00075\u0012i\t\u0003\u0004B\u0005\u000f\u0003\r!\u000e\u0005\b\u0005#\u0003A\u0011\tBJ\u00035\u0011XM\u001a:fg\"\u0014\u0015\u0010U1uQR\u0019QF!&\t\u000f\t]%q\u0012a\u0001k\u0005a!/Z:pkJ\u001cW\rU1uQ\u001eA!1\u0014\u0002\t\u0002\u0011\u0011i*A\u0006DCR\fGn\\4J[Bd\u0007c\u0001\u0010\u0003 \u001a9\u0011A\u0001E\u0001\t\t\u00056\u0003\u0002BP\u0005G\u00032A\fBS\u0013\r\u00119k\f\u0002\u0007\u0003:L(+\u001a4\t\u000fm\u0011y\n\"\u0001\u0003,R\u0011!Q\u0014\u0005\t\u0005_\u0013y\n\"\u0001\u00032\u0006YQ.Y6f\t\u0006$\u0018m]3u+\u0011\u0011\u0019La/\u0015\r\tU&\u0011`B\u0005)\u0011\u00119La2\u0011\t]1&\u0011\u0018\t\u0005\u0005g\u0012Y\f\u0002\u0005\u0003>\n5&\u0019\u0001B`\u0005\u0005!\u0016\u0003\u0002B>\u0005\u0003\u00042\u0001\u001dBb\u0013\r\u0011)M\n\u0002\u001b\t\u00164\u0017N\\3e\u0005f\u001cuN\\:ueV\u001cGo\u001c:QCJ\fWn\u001d\u0005\u000b\u0005\u0013\u0014i+!AA\u0004\t-\u0017AC3wS\u0012,gnY3%cA1!Q\u001aBw\u0005ssAAa4\u0003h:!!\u0011\u001bBr\u001d\u0011\u0011\u0019N!8\u000f\t\tU'\u0011\u001c\b\u0005\u0003G\u00139.C\u00011\u0013\r\u0011YnL\u0001\be\u00164G.Z2u\u0013\u0011\u0011yN!9\u0002\u000fI,h\u000e^5nK*\u0019!1\\\u0018\n\t\u0005M&Q\u001d\u0006\u0005\u0005?\u0014\t/\u0003\u0003\u0003j\n-\u0018\u0001C;oSZ,'o]3\u000b\t\u0005M&Q]\u0005\u0005\u0005_\u0014\tPA\u0004UsB,G+Y4\n\t\tM(Q\u001f\u0002\t)f\u0004X\rV1hg*!!q\u001fBq\u0003\r\t\u0007/\u001b\u0005\t\u0005w\u0014i\u000b1\u0001\u0003~\u0006!A-\u0019;b!\u0019\u0011ypa\u0001\u0003::!!Q[B\u0001\u0013\r\t\u0019lL\u0005\u0005\u0007\u000b\u00199AA\u0002TKFT1!a-0\u0011\u0019)\"Q\u0016a\u0001-\u0001")
public class CatalogImpl
extends Catalog {
    public final SparkSession org$apache$spark$sql$internal$CatalogImpl$$sparkSession;

    public static <T extends DefinedByConstructorParams> Dataset<T> makeDataset(Seq<T> seq, SparkSession sparkSession, TypeTags.TypeTag<T> typeTag) {
        return CatalogImpl$.MODULE$.makeDataset(seq, sparkSession, typeTag);
    }

    public SessionCatalog org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog() {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().catalog();
    }

    private void requireDatabaseExists(String dbName) {
        if (this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().databaseExists(dbName)) {
            return;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Database '", "' does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private void requireTableExists(String dbName, String tableName) {
        if (this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().tableExists(new TableIdentifier(tableName, (Option)new Some((Object)dbName)))) {
            return;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table '", "' does not exist in database '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, dbName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    @Override
    public String currentDatabase() {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().getCurrentDatabase();
    }

    @Override
    public void setCurrentDatabase(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().setCurrentDatabase(dbName);
    }

    @Override
    public Dataset<Database> listDatabases() {
        Seq databases = (Seq)this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().listDatabases().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogImpl $outer;

            public final Database apply(String dbName) {
                return this.$outer.org$apache$spark$sql$internal$CatalogImpl$$makeDatabase(dbName);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Database").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(databases, this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1(this)));
    }

    public Database org$apache$spark$sql$internal$CatalogImpl$$makeDatabase(String dbName) {
        CatalogDatabase metadata = this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().getDatabaseMetadata(dbName);
        return new Database(metadata.name(), metadata.description(), metadata.locationUri());
    }

    @Override
    public Dataset<Table> listTables() {
        return this.listTables(this.currentDatabase());
    }

    @Override
    public Dataset<Table> listTables(String dbName) throws AnalysisException {
        Seq tables = (Seq)this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().listTables(dbName).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogImpl $outer;

            public final Table apply(TableIdentifier tableIdent) {
                return this.$outer.org$apache$spark$sql$internal$CatalogImpl$$makeTable(tableIdent);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Table").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator2$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(tables, this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator2$1(this)));
    }

    public Table org$apache$spark$sql$internal$CatalogImpl$$makeTable(TableIdentifier tableIdent) {
        CatalogTable metadata = this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdent);
        boolean isTemp = this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().isTemporaryTable(tableIdent);
        return new Table(tableIdent.table(), (String)metadata.identifier().database().orNull(Predef$.MODULE$.$conforms()), (String)metadata.comment().orNull(Predef$.MODULE$.$conforms()), isTemp ? "TEMPORARY" : metadata.tableType().name(), isTemp);
    }

    @Override
    public Dataset<Function> listFunctions() {
        return this.listFunctions(this.currentDatabase());
    }

    @Override
    public Dataset<Function> listFunctions(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        Seq functions2 = (Seq)this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().listFunctions(dbName).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogImpl $outer;

            public final Function apply(Tuple2<FunctionIdentifier, String> x0$1) {
                Tuple2<FunctionIdentifier, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    FunctionIdentifier functIdent = (FunctionIdentifier)tuple2._1();
                    Function function = this.$outer.org$apache$spark$sql$internal$CatalogImpl$$makeFunction(functIdent);
                    return function;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Function").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator3$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(functions2, this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator3$1(this)));
    }

    public Function org$apache$spark$sql$internal$CatalogImpl$$makeFunction(FunctionIdentifier funcIdent) {
        ExpressionInfo metadata = this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().lookupFunctionInfo(funcIdent);
        return new Function(metadata.getName(), metadata.getDb(), null, metadata.getClassName(), metadata.getDb() == null);
    }

    @Override
    public Dataset<Column> listColumns(String tableName) throws AnalysisException {
        return this.listColumns(new TableIdentifier(tableName, (Option)None$.MODULE$));
    }

    @Override
    public Dataset<Column> listColumns(String dbName, String tableName) throws AnalysisException {
        this.requireTableExists(dbName, tableName);
        return this.listColumns(new TableIdentifier(tableName, (Option)new Some((Object)dbName)));
    }

    private Dataset<Column> listColumns(TableIdentifier tableIdentifier) {
        CatalogTable tableMetadata = this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdentifier);
        Set partitionColumnNames = tableMetadata.partitionColumnNames().toSet();
        Set bucketColumnNames = ((TraversableOnce)tableMetadata.bucketSpec().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(BucketSpec x$1) {
                return x$1.bucketColumnNames();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        })).toSet();
        Seq columns2 = (Seq)tableMetadata.schema().map((Function1)new Serializable(this, partitionColumnNames, bucketColumnNames){
            public static final long serialVersionUID = 0L;
            private final Set partitionColumnNames$1;
            private final Set bucketColumnNames$1;

            public final Column apply(StructField c) {
                return new Column(c.name(), (String)c.getComment().orNull(Predef$.MODULE$.$conforms()), c.dataType().catalogString(), c.nullable(), this.partitionColumnNames$1.contains((Object)c.name()), this.bucketColumnNames$1.contains((Object)c.name()));
            }
            {
                this.partitionColumnNames$1 = partitionColumnNames$1;
                this.bucketColumnNames$1 = bucketColumnNames$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Column").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator4$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(columns2, this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator4$1(this)));
    }

    @Override
    public Database getDatabase(String dbName) {
        return this.org$apache$spark$sql$internal$CatalogImpl$$makeDatabase(dbName);
    }

    @Override
    public Table getTable(String tableName) {
        return this.getTable(null, tableName);
    }

    @Override
    public Table getTable(String dbName, String tableName) {
        return this.org$apache$spark$sql$internal$CatalogImpl$$makeTable(new TableIdentifier(tableName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    public Function getFunction(String functionName) {
        return this.getFunction(null, functionName);
    }

    @Override
    public Function getFunction(String dbName, String functionName) {
        return this.org$apache$spark$sql$internal$CatalogImpl$$makeFunction(new FunctionIdentifier(functionName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    public boolean databaseExists(String dbName) {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().databaseExists(dbName);
    }

    @Override
    public boolean tableExists(String tableName) {
        return this.tableExists(null, tableName);
    }

    @Override
    public boolean tableExists(String dbName, String tableName) {
        TableIdentifier tableIdent = new TableIdentifier(tableName, Option$.MODULE$.apply((Object)dbName));
        return this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().isTemporaryTable(tableIdent) || this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().tableExists(tableIdent);
    }

    @Override
    public boolean functionExists(String functionName) {
        return this.functionExists(null, functionName);
    }

    @Override
    public boolean functionExists(String dbName, String functionName) {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().functionExists(new FunctionIdentifier(functionName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    @Experimental
    public Dataset<Row> createExternalTable(String tableName, String path) {
        String dataSourceName = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().conf().defaultDataSourceName();
        return this.createExternalTable(tableName, path, dataSourceName);
    }

    @Override
    @Experimental
    public Dataset<Row> createExternalTable(String tableName, String path, String source) {
        return this.createExternalTable(tableName, source, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)}))));
    }

    @Override
    @Experimental
    public Dataset<Row> createExternalTable(String tableName, String source, Map<String, String> options) {
        return this.createExternalTable(tableName, source, (scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()).toMap(Predef$.MODULE$.$conforms()));
    }

    @Override
    @Experimental
    public Dataset<Row> createExternalTable(String tableName, String source, scala.collection.immutable.Map<String, String> options) {
        return this.createExternalTable(tableName, source, new StructType(), options);
    }

    @Override
    @Experimental
    public Dataset<Row> createExternalTable(String tableName, String source, StructType schema, Map<String, String> options) {
        return this.createExternalTable(tableName, source, schema, (scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()).toMap(Predef$.MODULE$.$conforms()));
    }

    @Override
    @Experimental
    public Dataset<Row> createExternalTable(String tableName, String source, StructType schema, scala.collection.immutable.Map<String, String> options) {
        String string = source.toLowerCase();
        String string2 = "hive";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException("Cannot create hive serde table with createExternalTable API.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        TableIdentifier tableIdent = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        CatalogTable tableDesc = new CatalogTable(tableIdent, CatalogTableType$.MODULE$.EXTERNAL(), DataSource$.MODULE$.buildStorageFormatFromOptions(options), schema, (Option)new Some((Object)source), CatalogTable$.MODULE$.apply$default$6(), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17());
        CreateTable plan = new CreateTable(tableDesc, SaveMode.ErrorIfExists, (Option<LogicalPlan>)None$.MODULE$);
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().executePlan((LogicalPlan)plan).toRdd();
        return this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.table(tableIdent);
    }

    @Override
    public boolean dropTempView(String viewName) {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().catalog().getTempView(viewName).exists((Function1)new Serializable(this, viewName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogImpl $outer;
            private final String viewName$1;

            public final boolean apply(LogicalPlan tempView) {
                this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().uncacheQuery(Dataset$.MODULE$.ofRows(this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, tempView), this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().uncacheQuery$default$2());
                return this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().dropTempView(this.viewName$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.viewName$1 = viewName$1;
            }
        });
    }

    @Override
    public boolean dropGlobalTempView(String viewName) {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().catalog().getGlobalTempView(viewName).exists((Function1)new Serializable(this, viewName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogImpl $outer;
            private final String viewName$2;

            public final boolean apply(LogicalPlan viewDef) {
                this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().uncacheQuery(Dataset$.MODULE$.ofRows(this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, viewDef), this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().uncacheQuery$default$2());
                return this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().dropGlobalTempView(this.viewName$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.viewName$2 = viewName$2;
            }
        });
    }

    @Override
    public boolean isCached(String tableName) {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().lookupCachedData(this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.table(tableName)).nonEmpty();
    }

    @Override
    public void cacheTable(String tableName) {
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().cacheQuery(this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.table(tableName), (Option<String>)new Some((Object)tableName), this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().cacheQuery$default$3());
    }

    @Override
    public void uncacheTable(String tableName) {
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().uncacheQuery(this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.table(tableName), this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().uncacheQuery$default$2());
    }

    @Override
    public void clearCache() {
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().clearCache();
    }

    public boolean isCached(Dataset<?> qName) {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().lookupCachedData(qName).nonEmpty();
    }

    @Override
    public void refreshTable(String tableName) {
        TableIdentifier tableIdent = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().refreshTable(tableIdent);
        LogicalPlan logicalPlan2 = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().catalog().lookupRelation(tableIdent, this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sessionState().catalog().lookupRelation$default$2());
        boolean isCached = this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().lookupCachedData(logicalPlan2).nonEmpty();
        if (isCached) {
            Dataset<Row> df = Dataset$.MODULE$.ofRows(this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, logicalPlan2);
            this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().uncacheQuery(df, true);
            this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().cacheQuery(df, (Option<String>)new Some((Object)tableIdent.table()), this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().cacheQuery$default$3());
        }
    }

    @Override
    public void refreshByPath(String resourcePath) {
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession.sharedState().cacheManager().invalidateCachedPath(this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession, resourcePath);
    }

    public CatalogImpl(SparkSession sparkSession) {
        this.org$apache$spark$sql$internal$CatalogImpl$$sparkSession = sparkSession;
    }
}

