/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.streaming.FileStreamOptions;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog$;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset;
import org.apache.spark.sql.execution.streaming.FileStreamSourceOffset$;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.Source$class;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r}d\u0001B\u0001\u0003\u0001=\u0011\u0001CR5mKN#(/Z1n'>,(oY3\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\f\u001b!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0007'>,(oY3\u0011\u0005mqR\"\u0001\u000f\u000b\u0005uA\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005}a\"a\u0002'pO\u001eLgn\u001a\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005a1\u000f]1sWN+7o]5p]B\u00111\u0005J\u0007\u0002\r%\u0011QE\u0002\u0002\r'B\f'o[*fgNLwN\u001c\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u0005!\u0001/\u0019;i!\tICF\u0004\u0002\u0012U%\u00111FE\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,%!A\u0001\u0007\u0001B\u0001B\u0003%\u0001&A\ngS2,gi\u001c:nCR\u001cE.Y:t\u001d\u0006lW\r\u0003\u00053\u0001\t\u0015\r\u0011\"\u00114\u0003\u0019\u00198\r[3nCV\tA\u0007\u0005\u00026q5\taG\u0003\u00028\r\u0005)A/\u001f9fg&\u0011\u0011H\u000e\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002\u000fM\u001c\u0007.Z7bA!AQ\b\u0001B\u0001B\u0003%a(\u0001\tqCJ$\u0018\u000e^5p]\u000e{G.^7ogB\u0019qh\u0012\u0015\u000f\u0005\u0001+eBA!E\u001b\u0005\u0011%BA\"\u000f\u0003\u0019a$o\\8u}%\t1#\u0003\u0002G%\u00059\u0001/Y2lC\u001e,\u0017B\u0001%J\u0005\r\u0019V-\u001d\u0006\u0003\rJA\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\r[\u0016$\u0018\rZ1uCB\u000bG\u000f\u001b\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\u00069q\u000e\u001d;j_:\u001c\b\u0003B\u0015PQ!J!\u0001\u0015\u0018\u0003\u00075\u000b\u0007\u000fC\u0003S\u0001\u0011\u00051+\u0001\u0004=S:LGO\u0010\u000b\t)V3v\u000bW-[7B\u0011q\u0003\u0001\u0005\u0006CE\u0003\rA\t\u0005\u0006OE\u0003\r\u0001\u000b\u0005\u0006aE\u0003\r\u0001\u000b\u0005\u0006eE\u0003\r\u0001\u000e\u0005\u0006{E\u0003\rA\u0010\u0005\u0006\u0017F\u0003\r\u0001\u000b\u0005\u0006\u001bF\u0003\rA\u0014\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u00035\u0019x.\u001e:dK>\u0003H/[8ogV\tq\f\u0005\u0002\u0018A&\u0011\u0011M\u0001\u0002\u0012\r&dWm\u0015;sK\u0006lw\n\u001d;j_:\u001c\bBB2\u0001A\u0003%q,\u0001\bt_V\u00148-Z(qi&|gn\u001d\u0011\t\u000f\u0015\u0004!\u0019!C\u0005M\u0006\t\u0012/^1mS\u001aLW\r\u001a\"bg\u0016\u0004\u0016\r\u001e5\u0016\u0003\u001d\u0004\"\u0001[7\u000e\u0003%T!A[6\u0002\u0005\u0019\u001c(B\u00017\u000b\u0003\u0019A\u0017\rZ8pa&\u0011a.\u001b\u0002\u0005!\u0006$\b\u000e\u0003\u0004q\u0001\u0001\u0006IaZ\u0001\u0013cV\fG.\u001b4jK\u0012\u0014\u0015m]3QCRD\u0007\u0005C\u0004s\u0001\t\u0007I\u0011B:\u00029=\u0004H/[8og^KG\u000f\u001b)beRLG/[8o\u0005\u0006\u001cX\rU1uQV\tA\u000f\u0005\u0003vu\"BS\"\u0001<\u000b\u0005]D\u0018!C5n[V$\u0018M\u00197f\u0015\tI(#\u0001\u0006d_2dWm\u0019;j_:L!\u0001\u0015<\t\rq\u0004\u0001\u0015!\u0003u\u0003uy\u0007\u000f^5p]N<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]\n\u000b7/\u001a)bi\"\u0004\u0003b\u0002@\u0001\u0005\u0004%Ia`\u0001\f[\u0016$\u0018\rZ1uC2{w-\u0006\u0002\u0002\u0002A\u0019q#a\u0001\n\u0007\u0005\u0015!AA\nGS2,7\u000b\u001e:fC6\u001cv.\u001e:dK2{w\r\u0003\u0005\u0002\n\u0001\u0001\u000b\u0011BA\u0001\u00031iW\r^1eCR\fGj\\4!\u0011%\ti\u0001\u0001a\u0001\n\u0013\ty!\u0001\rnKR\fG-\u0019;b\u0019><7)\u001e:sK:$xJ\u001a4tKR,\"!!\u0005\u0011\u0007E\t\u0019\"C\u0002\u0002\u0016I\u0011A\u0001T8oO\"I\u0011\u0011\u0004\u0001A\u0002\u0013%\u00111D\u0001\u001d[\u0016$\u0018\rZ1uC2{wmQ;se\u0016tGo\u00144gg\u0016$x\fJ3r)\u0011\ti\"a\t\u0011\u0007E\ty\"C\u0002\u0002\"I\u0011A!\u00168ji\"Q\u0011QEA\f\u0003\u0003\u0005\r!!\u0005\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002*\u0001\u0001\u000b\u0015BA\t\u0003eiW\r^1eCR\fGj\\4DkJ\u0014XM\u001c;PM\u001a\u001cX\r\u001e\u0011\t\u0013\u00055\u0002A1A\u0005\n\u0005=\u0012\u0001E7bq\u001aKG.Z:QKJ\u0014\u0015\r^2i+\t\t\t\u0004E\u0003\u0012\u0003g\t9$C\u0002\u00026I\u0011aa\u00149uS>t\u0007cA\t\u0002:%\u0019\u00111\b\n\u0003\u0007%sG\u000f\u0003\u0005\u0002@\u0001\u0001\u000b\u0011BA\u0019\u0003Ei\u0017\r\u001f$jY\u0016\u001c\b+\u001a:CCR\u001c\u0007\u000e\t\u0005\n\u0003\u0007\u0002!\u0019!C\u0005\u0003\u000b\nQBZ5mKN{'\u000f^(sI\u0016\u0014XCAA$!\u0019\tI%a\u0014\u0002\u00125\u0011\u00111\n\u0006\u0004\u0003\u001b\u0012\u0012\u0001B7bi\"LA!!\u0015\u0002L\tAqJ\u001d3fe&tw\r\u0003\u0005\u0002V\u0001\u0001\u000b\u0011BA$\u000391\u0017\u000e\\3T_J$xJ\u001d3fe\u0002B\u0011\"!\u0017\u0001\u0005\u0004%\t!a\u0017\u0002\u0013M,WM\u001c$jY\u0016\u001cXCAA/!\u0011\tyFa!\u000f\u0007]\t\tgB\u0004\u0002d\tA\t!!\u001a\u0002!\u0019KG.Z*ue\u0016\fWnU8ve\u000e,\u0007cA\f\u0002h\u00191\u0011A\u0001E\u0001\u0003S\u001a2!a\u001a\u0011\u0011\u001d\u0011\u0016q\rC\u0001\u0003[\"\"!!\u001a\u0006\u000f\u0005E\u0014q\r\u0001\u0002\u0012\tIA+[7fgR\fW\u000e\u001d\u0004\b\u0003k\n9\u0007QA<\u0005%1\u0015\u000e\\3F]R\u0014\u0018pE\u0004\u0002tA\tI(a \u0011\u0007E\tY(C\u0002\u0002~I\u0011AbU3sS\u0006d\u0017N_1cY\u0016\u00042!EAA\u0013\r\t\u0019I\u0005\u0002\b!J|G-^2u\u0011)9\u00131\u000fBK\u0002\u0013\u0005\u0011qQ\u000b\u0002Q!Q\u00111RA:\u0005#\u0005\u000b\u0011\u0002\u0015\u0002\u000bA\fG\u000f\u001b\u0011\t\u0017\u0005=\u00151\u000fBK\u0002\u0013\u0005\u0011\u0011S\u0001\ni&lWm\u001d;b[B,\"!a%\u0011\t\u0005U\u0015qN\u0007\u0003\u0003OB1\"!'\u0002t\tE\t\u0015!\u0003\u0002\u0014\u0006QA/[7fgR\fW\u000e\u001d\u0011\t\u0017\u0005u\u00151\u000fBK\u0002\u0013\u0005\u0011qB\u0001\bE\u0006$8\r[%e\u0011-\t\t+a\u001d\u0003\u0012\u0003\u0006I!!\u0005\u0002\u0011\t\fGo\u00195JI\u0002BqAUA:\t\u0003\t)\u000b\u0006\u0005\u0002(\u0006%\u00161VAW!\u0011\t)*a\u001d\t\r\u001d\n\u0019\u000b1\u0001)\u0011!\ty)a)A\u0002\u0005M\u0005\u0002CAO\u0003G\u0003\r!!\u0005\t\u0015\u0005E\u00161OA\u0001\n\u0003\t\u0019,\u0001\u0003d_BLH\u0003CAT\u0003k\u000b9,!/\t\u0011\u001d\ny\u000b%AA\u0002!B!\"a$\u00020B\u0005\t\u0019AAJ\u0011)\ti*a,\u0011\u0002\u0003\u0007\u0011\u0011\u0003\u0005\u000b\u0003{\u000b\u0019(%A\u0005\u0002\u0005}\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0003T3\u0001KAbW\t\t)\r\u0005\u0003\u0002H\u0006EWBAAe\u0015\u0011\tY-!4\u0002\u0013Ut7\r[3dW\u0016$'bAAh%\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0017\u0011\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007BCAl\u0003g\n\n\u0011\"\u0001\u0002Z\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAnU\u0011\t\u0019*a1\t\u0015\u0005}\u00171OI\u0001\n\u0003\t\t/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\r(\u0006BA\t\u0003\u0007D!\"a:\u0002t\u0005\u0005I\u0011IAu\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u001e\t\u0005\u0003[\f90\u0004\u0002\u0002p*!\u0011\u0011_Az\u0003\u0011a\u0017M\\4\u000b\u0005\u0005U\u0018\u0001\u00026bm\u0006L1!LAx\u0011)\tY0a\u001d\u0002\u0002\u0013\u0005\u0011Q`\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003oA!B!\u0001\u0002t\u0005\u0005I\u0011\u0001B\u0002\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\u0002\u0003\fA\u0019\u0011Ca\u0002\n\u0007\t%!CA\u0002B]fD!\"!\n\u0002\u0000\u0006\u0005\t\u0019AA\u001c\u0011)\u0011y!a\u001d\u0002\u0002\u0013\u0005#\u0011C\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!1\u0003\t\u0007\u0005+\u00119B!\u0002\u000e\u0003aL1A!\u0007y\u0005!IE/\u001a:bi>\u0014\bB\u0003B\u000f\u0003g\n\t\u0011\"\u0001\u0003 \u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\"\t\u001d\u0002cA\t\u0003$%\u0019!Q\u0005\n\u0003\u000f\t{w\u000e\\3b]\"Q\u0011Q\u0005B\u000e\u0003\u0003\u0005\rA!\u0002\t\u0015\t-\u00121OA\u0001\n\u0003\u0012i#\u0001\u0005iCND7i\u001c3f)\t\t9\u0004\u0003\u0006\u00032\u0005M\u0014\u0011!C!\u0005g\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003WD!Ba\u000e\u0002t\u0005\u0005I\u0011\tB\u001d\u0003\u0019)\u0017/^1mgR!!\u0011\u0005B\u001e\u0011)\t)C!\u000e\u0002\u0002\u0003\u0007!QA\u0004\u000b\u0005\u007f\t9'!A\t\u0002\t\u0005\u0013!\u0003$jY\u0016,e\u000e\u001e:z!\u0011\t)Ja\u0011\u0007\u0015\u0005U\u0014qMA\u0001\u0012\u0003\u0011)e\u0005\u0004\u0003D\t\u001d\u0013\u0011\u0010\t\f\u0005\u0013\u0012y\u0005KAJ\u0003#\t9+\u0004\u0002\u0003L)\u0019!Q\n\n\u0002\u000fI,h\u000e^5nK&!!\u0011\u000bB&\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u0005\b%\n\rC\u0011\u0001B+)\t\u0011\t\u0005\u0003\u0006\u00032\t\r\u0013\u0011!C#\u0005gA!Ba\u0017\u0003D\u0005\u0005I\u0011\u0011B/\u0003\u0015\t\u0007\u000f\u001d7z)!\t9Ka\u0018\u0003b\t\r\u0004BB\u0014\u0003Z\u0001\u0007\u0001\u0006\u0003\u0005\u0002\u0010\ne\u0003\u0019AAJ\u0011!\tiJ!\u0017A\u0002\u0005E\u0001B\u0003B4\u0005\u0007\n\t\u0011\"!\u0003j\u00059QO\\1qa2LH\u0003\u0002B6\u0005g\u0002R!EA\u001a\u0005[\u0002\u0002\"\u0005B8Q\u0005M\u0015\u0011C\u0005\u0004\u0005c\u0012\"A\u0002+va2,7\u0007\u0003\u0006\u0003v\t\u0015\u0014\u0011!a\u0001\u0003O\u000b1\u0001\u001f\u00131\u0011)\u0011IHa\u0011\u0002\u0002\u0013%!1P\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003~A!\u0011Q\u001eB@\u0013\u0011\u0011\t)a<\u0003\r=\u0013'.Z2u\r\u001d\u0011))a\u001a\u0001\u0005\u000f\u0013AbU3f]\u001aKG.Z:NCB\u001c2Aa!\u0011\u0011-\u0011YIa!\u0003\u0002\u0003\u0006I!!\u0005\u0002\u00115\f\u00070Q4f\u001bNDqA\u0015BB\t\u0003\u0011y\t\u0006\u0003\u0003\u0012\nM\u0005\u0003BAK\u0005\u0007C\u0001Ba#\u0003\u000e\u0002\u0007\u0011\u0011\u0003\u0005\u000b\u0005/\u0013\u0019I1A\u0005\n\te\u0015aA7baV\u0011!1\u0014\t\b\u0005;\u0013\u0019\u000bKAJ\u001b\t\u0011yJ\u0003\u0003\u0003\"\u0006M\u0018\u0001B;uS2LAA!*\u0003 \n9\u0001*Y:i\u001b\u0006\u0004\b\"\u0003BU\u0005\u0007\u0003\u000b\u0011\u0002BN\u0003\u0011i\u0017\r\u001d\u0011\t\u0015\t5&1\u0011a\u0001\n\u0013\t\t*A\bmCR,7\u000f\u001e+j[\u0016\u001cH/Y7q\u0011)\u0011\tLa!A\u0002\u0013%!1W\u0001\u0014Y\u0006$Xm\u001d;US6,7\u000f^1na~#S-\u001d\u000b\u0005\u0003;\u0011)\f\u0003\u0006\u0002&\t=\u0016\u0011!a\u0001\u0003'C\u0011B!/\u0003\u0004\u0002\u0006K!a%\u0002!1\fG/Z:u)&lWm\u001d;b[B\u0004\u0003B\u0003B_\u0005\u0007\u0003\r\u0011\"\u0003\u0002\u0012\u0006\u0011B.Y:u!V\u0014x-\u001a+j[\u0016\u001cH/Y7q\u0011)\u0011\tMa!A\u0002\u0013%!1Y\u0001\u0017Y\u0006\u001cH\u000fU;sO\u0016$\u0016.\\3ti\u0006l\u0007o\u0018\u0013fcR!\u0011Q\u0004Bc\u0011)\t)Ca0\u0002\u0002\u0003\u0007\u00111\u0013\u0005\n\u0005\u0013\u0014\u0019\t)Q\u0005\u0003'\u000b1\u0003\\1tiB+(oZ3US6,7\u000f^1na\u0002B\u0001B!4\u0003\u0004\u0012\u0005!qZ\u0001\u0004C\u0012$GCBA\u000f\u0005#\u0014\u0019\u000e\u0003\u0004(\u0005\u0017\u0004\r\u0001\u000b\u0005\t\u0003\u001f\u0013Y\r1\u0001\u0002\u0014\"A!q\u001bBB\t\u0003\u0011I.A\u0005jg:+wOR5mKR1!\u0011\u0005Bn\u0005;Daa\nBk\u0001\u0004A\u0003\u0002CAH\u0005+\u0004\r!a%\t\u0011\t\u0005(1\u0011C\u0001\u0005[\tQ\u0001];sO\u0016D\u0001B!:\u0003\u0004\u0012\u0005\u0011Q`\u0001\u0005g&TX\r\u0003\u0005\u0003j\n\rE\u0011\u0001Bv\u0003)\tG\u000e\\#oiJLWm]\u000b\u0003\u0005[\u0004BaP$\u0003pB1\u0011C!=)\u0003'K1Aa=\u0013\u0005\u0019!V\u000f\u001d7fe!A!q\u001f\u0001!\u0002\u0013\ti&\u0001\u0006tK\u0016tg)\u001b7fg\u0002BqAa?\u0001\t\u0013\u0011i0\u0001\bgKR\u001c\u0007.T1y\u001f\u001a47/\u001a;\u0015\u0005\t}\bcA\f\u0004\u0002%\u001911\u0001\u0002\u0003-\u0019KG.Z*ue\u0016\fWnU8ve\u000e,wJ\u001a4tKRDqaa\u0002\u0001\t\u0003\u0019I!\u0001\nxSRD')\u0019;dQ&tw\rT8dW\u0016$W\u0003BB\u0006\u0007#!Ba!\u0004\u0004\u001eA!1qBB\t\u0019\u0001!\u0001ba\u0005\u0004\u0006\t\u00071Q\u0003\u0002\u0002)F!1q\u0003B\u0003!\r\t2\u0011D\u0005\u0004\u00077\u0011\"a\u0002(pi\"Lgn\u001a\u0005\n\u0007?\u0019)\u0001\"a\u0001\u0007C\tAAZ;oGB)\u0011ca\t\u0004\u000e%\u00191Q\u0005\n\u0003\u0011q\u0012\u0017P\\1nKzBqa!\u000b\u0001\t\u0003\ty!\u0001\tdkJ\u0014XM\u001c;M_\u001e|eMZ:fi\"91Q\u0006\u0001\u0005B\r=\u0012\u0001C4fi\n\u000bGo\u00195\u0015\r\rE2QJB-!\u0011\u0019\u0019da\u0012\u000f\t\rU2Q\t\b\u0005\u0007o\u0019\u0019E\u0004\u0003\u0004:\r\u0005c\u0002BB\u001e\u0007\u007fq1!QB\u001f\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011aIB\u0005\u0005\u0007\u0013\u001aYEA\u0005ECR\fgI]1nK*\u0011aI\u0002\u0005\t\u0007\u001f\u001aY\u00031\u0001\u0004R\u0005)1\u000f^1siB)\u0011#a\r\u0004TA\u0019qc!\u0016\n\u0007\r]#A\u0001\u0004PM\u001a\u001cX\r\u001e\u0005\t\u00077\u001aY\u00031\u0001\u0004T\u0005\u0019QM\u001c3\t\u000f\r}\u0003\u0001\"\u0003\u0004b\u0005ia-\u001a;dQ\u0006cGNR5mKN$\"aa\u0019\u0011\t}:5Q\r\t\u0007#\tE\b&!\u0005\t\u000f\r%\u0004\u0001\"\u0011\u0004l\u0005Iq-\u001a;PM\u001a\u001cX\r^\u000b\u0003\u0007#BqA!\r\u0001\t\u0003\u001ay\u0007F\u0001)\u0011\u001d\u0019\u0019\b\u0001C!\u0007k\naaY8n[&$H\u0003BA\u000f\u0007oB\u0001ba\u0017\u0004r\u0001\u000711\u000b\u0005\b\u0007w\u0002A\u0011IB?\u0003\u0011\u0019Ho\u001c9\u0015\u0005\u0005u\u0001")
public class FileStreamSource
implements Source,
Logging {
    private final SparkSession sparkSession;
    private final String fileFormatClassName;
    private final StructType schema;
    private final Seq<String> partitionColumns;
    private final Map<String, String> options;
    private final FileStreamOptions org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions;
    private final Path qualifiedBasePath;
    private final Map<String, String> optionsWithPartitionBasePath;
    private final FileStreamSourceLog metadataLog;
    private long org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset;
    private final Option<Object> org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch;
    private final Ordering<Object> fileSortOrder;
    private final SeenFilesMap seenFiles;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public StructType schema() {
        return this.schema;
    }

    public FileStreamOptions org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions;
    }

    private Path qualifiedBasePath() {
        return this.qualifiedBasePath;
    }

    private Map<String, String> optionsWithPartitionBasePath() {
        return this.optionsWithPartitionBasePath;
    }

    private FileStreamSourceLog metadataLog() {
        return this.metadataLog;
    }

    public long org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset;
    }

    private void org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset_$eq(long x$1) {
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset = x$1;
    }

    public Option<Object> org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch;
    }

    private Ordering<Object> fileSortOrder() {
        return this.fileSortOrder;
    }

    public SeenFilesMap seenFiles() {
        return this.seenFiles;
    }

    private synchronized FileStreamSourceOffset fetchMaxOffset() {
        Seq newFiles = (Seq)this.fetchAllFiles().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final boolean apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String path = (String)tuple2._1();
                    long timestamp = tuple2._2$mcJ$sp();
                    boolean bl = this.$outer.seenFiles().isNewFile(path, timestamp);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Seq batchFiles = this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch().nonEmpty() ? (Seq)newFiles.take(BoxesRunTime.unboxToInt((Object)this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch().get())) : newFiles;
        batchFiles.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final void apply(Tuple2<String, Object> file) {
                this.$outer.seenFiles().add((String)file._1(), file._2$mcJ$sp());
                this.$outer.logDebug((Function0<String>)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"New file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
                    }
                    {
                        this.file$1 = file$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        int numPurged = this.seenFiles().purge();
        this.logTrace((Function0<String>)new Serializable(this, newFiles, batchFiles, numPurged){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;
            private final Seq newFiles$1;
            private final Seq batchFiles$1;
            private final int numPurged$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |Number of new files = ", "\n         |Number of files selected for batch = ", "\n         |Number of seen files = ", "\n         |Number of files purged from tracking map = ", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.newFiles$1.size()), BoxesRunTime.boxToInteger((int)this.batchFiles$1.size()), BoxesRunTime.boxToInteger((int)this.$outer.seenFiles().size()), BoxesRunTime.boxToInteger((int)this.numPurged$1)})))).stripMargin();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newFiles$1 = newFiles$1;
                this.batchFiles$1 = batchFiles$1;
                this.numPurged$1 = numPurged$1;
            }
        });
        if (batchFiles.nonEmpty()) {
            this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset_$eq(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset() + 1L);
            this.metadataLog().add(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset(), (FileEntry[])((TraversableOnce)batchFiles.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileStreamSource $outer;

                public final FileEntry apply(Tuple2<String, Object> x0$2) {
                    Tuple2<String, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        String p = (String)tuple2._1();
                        long timestamp = tuple2._2$mcJ$sp();
                        FileEntry fileEntry = new FileEntry(p, timestamp, this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset());
                        return fileEntry;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FileEntry.class)));
            this.logInfo((Function0<String>)new Serializable(this, batchFiles){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileStreamSource $outer;
                private final Seq batchFiles$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log offset set to ", " with ", " new files"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset()), BoxesRunTime.boxToInteger((int)this.batchFiles$1.size())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.batchFiles$1 = batchFiles$1;
                }
            });
        }
        return new FileStreamSourceOffset(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset());
    }

    public synchronized <T> T withBatchingLocked(Function0<T> func) {
        return (T)func.apply();
    }

    public synchronized long currentLogOffset() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset();
    }

    @Override
    public Dataset<Row> getBatch(Option<Offset> start, Offset end) {
        long endOffset;
        long startOffset = BoxesRunTime.unboxToLong((Object)start.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Offset x$2) {
                return FileStreamSourceOffset$.MODULE$.apply(x$2).logOffset();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        Predef$.MODULE$.assert(startOffset <= (endOffset = FileStreamSourceOffset$.MODULE$.apply(end).logOffset()));
        FileEntry[] files = (FileEntry[])Predef$.MODULE$.refArrayOps((Object[])this.metadataLog().get((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(startOffset + 1L))), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)))).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<FileEntry> apply(Tuple2<Object, FileEntry[]> x$3) {
                return Predef$.MODULE$.refArrayOps((Object[])x$3._2());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileEntry.class)));
        this.logInfo((Function0<String>)new Serializable(this, startOffset, endOffset, files){
            public static final long serialVersionUID = 0L;
            private final long startOffset$1;
            private final long endOffset$1;
            private final FileEntry[] files$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing ", " files from ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$1.length), BoxesRunTime.boxToLong((long)(this.startOffset$1 + 1L)), BoxesRunTime.boxToLong((long)this.endOffset$1)}));
            }
            {
                this.startOffset$1 = startOffset$1;
                this.endOffset$1 = endOffset$1;
                this.files$1 = files$1;
            }
        });
        this.logTrace((Function0<String>)new Serializable(this, files){
            public static final long serialVersionUID = 0L;
            private final FileEntry[] files$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files are:\\n\\t"})).s((Seq)Nil$.MODULE$)).append((Object)Predef$.MODULE$.refArrayOps((Object[])this.files$1).mkString("\n\t")).toString();
            }
            {
                this.files$1 = files$1;
            }
        });
        SparkSession x$7 = this.sparkSession;
        Seq x$8 = (Seq)Predef$.MODULE$.refArrayOps((Object[])files).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileEntry x$4) {
                return x$4.path();
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        Some x$9 = new Some((Object)this.schema());
        Seq<String> x$10 = this.partitionColumns;
        String x$11 = this.fileFormatClassName;
        Map<String, String> x$12 = this.optionsWithPartitionBasePath();
        Option<BucketSpec> x$13 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$14 = DataSource$.MODULE$.apply$default$8();
        DataSource newDataSource = new DataSource(x$7, x$11, (Seq<String>)x$8, (Option<StructType>)x$9, x$10, x$13, x$12, x$14);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new LogicalRelation(newDataSource.resolveRelation(false), LogicalRelation$.MODULE$.apply$default$2(), LogicalRelation$.MODULE$.apply$default$3()));
    }

    private Seq<Tuple2<String, Object>> fetchAllFiles() {
        long startTime = System.nanoTime();
        Seq globbedPaths = SparkHadoopUtil$.MODULE$.get().globPathIfNecessary(this.qualifiedBasePath());
        InMemoryFileIndex catalog = new InMemoryFileIndex(this.sparkSession, (Seq<Path>)globbedPaths, this.options, (Option<StructType>)new Some((Object)new StructType()), InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5());
        Seq files = (Seq)((TraversableLike)catalog.allFiles().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(FileStatus x$5) {
                return x$5.getModificationTime();
            }
        }, this.fileSortOrder())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(FileStatus status) {
                return new Tuple2((Object)status.getPath().toUri().toString(), (Object)BoxesRunTime.boxToLong((long)status.getModificationTime()));
            }
        }, Seq$.MODULE$.canBuildFrom());
        long endTime = System.nanoTime();
        double listingTimeMs = ((double)endTime - (double)startTime) / (double)1000000;
        if (listingTimeMs > (double)2000) {
            this.logWarning((Function0<String>)new Serializable(this, files, listingTimeMs){
                public static final long serialVersionUID = 0L;
                private final Seq files$2;
                private final double listingTimeMs$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listed ", " file(s) in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$2.size()), BoxesRunTime.boxToDouble((double)this.listingTimeMs$1)}));
                }
                {
                    this.files$2 = files$2;
                    this.listingTimeMs$1 = listingTimeMs$1;
                }
            });
        } else {
            this.logTrace((Function0<String>)new Serializable(this, files, listingTimeMs){
                public static final long serialVersionUID = 0L;
                private final Seq files$2;
                private final double listingTimeMs$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listed ", " file(s) in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$2.size()), BoxesRunTime.boxToDouble((double)this.listingTimeMs$1)}));
                }
                {
                    this.files$2 = files$2;
                    this.listingTimeMs$1 = listingTimeMs$1;
                }
            });
        }
        this.logTrace((Function0<String>)new Serializable(this, files){
            public static final long serialVersionUID = 0L;
            private final Seq files$2;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files are:\\n\\t"})).s((Seq)Nil$.MODULE$)).append((Object)this.files$2.mkString("\n\t")).toString();
            }
            {
                this.files$2 = files$2;
            }
        });
        return files;
    }

    @Override
    public Option<Offset> getOffset() {
        return new Some((Object)this.fetchMaxOffset()).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStreamSourceOffset x$6) {
                return x$6.logOffset() == -1L;
            }
        });
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FileStreamSource[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.qualifiedBasePath()}));
    }

    @Override
    public void commit(Offset end) {
    }

    @Override
    public void stop() {
    }

    public FileStreamSource(SparkSession sparkSession, String path, String fileFormatClassName, StructType schema, Seq<String> partitionColumns, String metadataPath, Map<String, String> options) {
        Ordering ordering;
        this.sparkSession = sparkSession;
        this.fileFormatClassName = fileFormatClassName;
        this.schema = schema;
        this.partitionColumns = partitionColumns;
        this.options = options;
        Source$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions = new FileStreamOptions(options);
        FileSystem fs = new Path(path).getFileSystem(sparkSession.sessionState().newHadoopConf());
        this.qualifiedBasePath = fs.makeQualified(new Path(path));
        this.optionsWithPartitionBasePath = this.org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions().optionMapWithoutPath().$plus$plus((GenTraversableOnce)(!SparkHadoopUtil$.MODULE$.get().isGlobPath(new Path(path)) && options.contains((Object)"path") ? Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"basePath"), (Object)path)})) : Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        this.metadataLog = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), sparkSession, metadataPath);
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$metadataLogCurrentOffset = BoxesRunTime.unboxToLong((Object)this.metadataLog().getLatest().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Object, FileEntry[]> x$1) {
                return x$1._1$mcJ$sp();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch = this.org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions().maxFilesPerTrigger();
        if (this.org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions().latestFirst()) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("'latestFirst' is true. New files will be processed first.\n          |It may affect the watermark value")).stripMargin();
                }
            });
            ordering = ((Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Long$.MODULE$)).reverse();
        } else {
            ordering = (Ordering)Predef$.MODULE$.implicitly((Object)Ordering.Long$.MODULE$);
        }
        this.fileSortOrder = ordering;
        this.seenFiles = new SeenFilesMap(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions().maxFileAgeMs());
        Predef$.MODULE$.refArrayOps((Object[])this.metadataLog().allFiles()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final void apply(FileEntry entry2) {
                this.$outer.seenFiles().add(entry2.path(), entry2.timestamp());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.seenFiles().purge();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxFilesPerBatch = ", ", maxFileAge = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch(), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions().maxFileAgeMs())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static class FileEntry
    implements Serializable,
    Product {
        private final String path;
        private final long timestamp;
        private final long batchId;

        public String path() {
            return this.path;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long batchId() {
            return this.batchId;
        }

        public FileEntry copy(String path, long timestamp, long batchId) {
            return new FileEntry(path, timestamp, batchId);
        }

        public String copy$default$1() {
            return this.path();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public long copy$default$3() {
            return this.batchId();
        }

        public String productPrefix() {
            return "FileEntry";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.batchId());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.timestamp());
                    break;
                }
                case 0: {
                    object = this.path();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FileEntry;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timestamp()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.batchId()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FileEntry)) return false;
            boolean bl = true;
            if (!bl) return false;
            FileEntry fileEntry = (FileEntry)x$1;
            String string = this.path();
            String string2 = fileEntry.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.timestamp() != fileEntry.timestamp()) return false;
            if (this.batchId() != fileEntry.batchId()) return false;
            if (!fileEntry.canEqual(this)) return false;
            return true;
        }

        public FileEntry(String path, long timestamp, long batchId) {
            this.path = path;
            this.timestamp = timestamp;
            this.batchId = batchId;
            Product.class.$init$((Product)this);
        }
    }

    public static class SeenFilesMap {
        private final long maxAgeMs;
        private final HashMap<String, Object> map;
        private long latestTimestamp;
        private long lastPurgeTimestamp;

        private HashMap<String, Object> map() {
            return this.map;
        }

        private long latestTimestamp() {
            return this.latestTimestamp;
        }

        private void latestTimestamp_$eq(long x$1) {
            this.latestTimestamp = x$1;
        }

        private long lastPurgeTimestamp() {
            return this.lastPurgeTimestamp;
        }

        private void lastPurgeTimestamp_$eq(long x$1) {
            this.lastPurgeTimestamp = x$1;
        }

        public void add(String path, long timestamp) {
            this.map().put(path, BoxesRunTime.boxToLong((long)timestamp));
            if (timestamp > this.latestTimestamp()) {
                this.latestTimestamp_$eq(timestamp);
            }
        }

        public boolean isNewFile(String path, long timestamp) {
            return timestamp >= this.lastPurgeTimestamp() && !this.map().containsKey(path);
        }

        /*
         * WARNING - void declaration
         */
        public int purge() {
            void var2_2;
            this.lastPurgeTimestamp_$eq(this.latestTimestamp() - this.maxAgeMs);
            java.util.Iterator<Map.Entry<String, Object>> iter = this.map().entrySet().iterator();
            int count2 = 0;
            while (iter.hasNext()) {
                Map.Entry<String, Object> entry2 = iter.next();
                if (BoxesRunTime.unboxToLong((Object)entry2.getValue()) >= this.lastPurgeTimestamp()) continue;
                ++count2;
                iter.remove();
            }
            return (int)var2_2;
        }

        public int size() {
            return this.map().size();
        }

        public Seq<Tuple2<String, Object>> allEntries() {
            return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.map()).asScala()).toSeq();
        }

        public SeenFilesMap(long maxAgeMs) {
            this.maxAgeMs = maxAgeMs;
            Predef$.MODULE$.require(maxAgeMs >= 0L);
            this.map = new HashMap();
            this.latestTimestamp = 0L;
            this.lastPurgeTimestamp = 0L;
        }
    }
}

