/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.compat.RowGroupFilter;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.BadConfigurationException;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.ConfigurationUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.LongAccumulator;
import scala.Option;

public abstract class SpecificParquetRecordReaderBase<T>
extends RecordReader<Void, T> {
    protected Path file;
    protected MessageType fileSchema;
    protected MessageType requestedSchema;
    protected StructType sparkSchema;
    protected long totalRowCount;
    protected ParquetFileReader reader;

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        Option accu;
        ArrayList<BlockMetaData> blocks;
        ParquetMetadata footer;
        Configuration configuration = taskAttemptContext.getConfiguration();
        ParquetInputSplit split = (ParquetInputSplit)inputSplit;
        this.file = split.getPath();
        long[] rowGroupOffsets = split.getRowGroupOffsets();
        if (rowGroupOffsets == null) {
            footer = ParquetFileReader.readFooter((Configuration)configuration, (Path)this.file, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.range((long)split.getStart(), (long)split.getEnd()));
            MessageType fileSchema = footer.getFileMetaData().getSchema();
            FilterCompat.Filter filter2 = ParquetInputFormat.getFilter((Configuration)configuration);
            blocks = RowGroupFilter.filterRowGroups((FilterCompat.Filter)filter2, (List)footer.getBlocks(), (MessageType)fileSchema);
        } else {
            footer = ParquetFileReader.readFooter((Configuration)configuration, (Path)this.file, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
            HashSet<Long> offsets = new HashSet<Long>();
            for (long offset : rowGroupOffsets) {
                offsets.add(offset);
            }
            blocks = new ArrayList<BlockMetaData>();
            for (BlockMetaData block : footer.getBlocks()) {
                if (!offsets.contains(block.getStartingPos())) continue;
                blocks.add(block);
            }
            if (blocks.size() != rowGroupOffsets.length) {
                long[] foundRowGroupOffsets = new long[footer.getBlocks().size()];
                for (int i = 0; i < foundRowGroupOffsets.length; ++i) {
                    foundRowGroupOffsets[i] = ((BlockMetaData)footer.getBlocks().get(i)).getStartingPos();
                }
                throw new IllegalStateException("All the offsets listed in the split should be found in the file. expected: " + Arrays.toString(rowGroupOffsets) + " found: " + blocks + " out of: " + Arrays.toString(foundRowGroupOffsets) + " in range " + split.getStart() + ", " + split.getEnd());
            }
        }
        this.fileSchema = footer.getFileMetaData().getSchema();
        Map fileMetadata = footer.getFileMetaData().getKeyValueMetaData();
        ReadSupport<T> readSupport = SpecificParquetRecordReaderBase.getReadSupportInstance(this.getReadSupportClass(configuration));
        ReadSupport.ReadContext readContext = readSupport.init(new InitContext(taskAttemptContext.getConfiguration(), SpecificParquetRecordReaderBase.toSetMultiMap(fileMetadata), this.fileSchema));
        this.requestedSchema = readContext.getRequestedSchema();
        String sparkRequestedSchemaString = configuration.get(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA());
        this.sparkSchema = StructType$.MODULE$.fromString(sparkRequestedSchemaString);
        this.reader = new ParquetFileReader(configuration, this.file, blocks, this.requestedSchema.getColumns());
        for (BlockMetaData block : blocks) {
            this.totalRowCount += block.getRowCount();
        }
        TaskContext taskContext = TaskContext$.MODULE$.get();
        if (taskContext != null && (accu = taskContext.taskMetrics().lookForAccumulatorByName("numRowGroups")).isDefined()) {
            ((LongAccumulator)accu.get()).add((long)blocks.size());
        }
    }

    public static List<String> listDirectory(File path) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        if (path.isDirectory()) {
            for (File f : path.listFiles()) {
                result.addAll(SpecificParquetRecordReaderBase.listDirectory(f));
            }
        } else {
            char c = path.getName().charAt(0);
            if (c != '.' && c != '_') {
                result.add(path.getAbsolutePath());
            }
        }
        return result;
    }

    protected void initialize(String path, List<String> columns2) throws IOException {
        Configuration config2 = new Configuration();
        config2.set("spark.sql.parquet.binaryAsString", "false");
        config2.set("spark.sql.parquet.int96AsTimestamp", "false");
        config2.set("spark.sql.parquet.writeLegacyFormat", "false");
        this.file = new Path(path);
        long length = this.file.getFileSystem(config2).getFileStatus(this.file).getLen();
        ParquetMetadata footer = ParquetFileReader.readFooter((Configuration)config2, (Path)this.file, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.range((long)0L, (long)length));
        List blocks = footer.getBlocks();
        this.fileSchema = footer.getFileMetaData().getSchema();
        if (columns2 == null) {
            this.requestedSchema = this.fileSchema;
        } else {
            Types.MessageTypeBuilder builder2 = Types.buildMessage();
            for (String s : columns2) {
                if (!this.fileSchema.containsField(s)) {
                    throw new IOException("Can only project existing columns. Unknown field: " + s + " File schema:\n" + this.fileSchema);
                }
                builder2.addFields(new Type[]{this.fileSchema.getType(s)});
            }
            this.requestedSchema = builder2.named("spark_schema");
        }
        this.sparkSchema = new ParquetSchemaConverter(config2).convert(this.requestedSchema);
        this.reader = new ParquetFileReader(config2, this.file, blocks, this.requestedSchema.getColumns());
        for (BlockMetaData block : blocks) {
            this.totalRowCount += block.getRowCount();
        }
    }

    public Void getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    protected static IntIterator createRLEIterator(int maxLevel, BytesInput bytes, ColumnDescriptor descriptor) throws IOException {
        try {
            if (maxLevel == 0) {
                return new NullIntIterator();
            }
            return new RLEIntIterator(new RunLengthBitPackingHybridDecoder(BytesUtils.getWidthFromMaxInt((int)maxLevel), new ByteArrayInputStream(bytes.toByteArray())));
        }
        catch (IOException e) {
            throw new IOException("could not read levels in page for col " + descriptor, e);
        }
    }

    private static <K, V> Map<K, Set<V>> toSetMultiMap(Map<K, V> map2) {
        HashMap setMultiMap = new HashMap();
        for (Map.Entry<K, V> entry2 : map2.entrySet()) {
            HashSet<V> set = new HashSet<V>();
            set.add(entry2.getValue());
            setMultiMap.put(entry2.getKey(), Collections.unmodifiableSet(set));
        }
        return Collections.unmodifiableMap(setMultiMap);
    }

    private Class<? extends ReadSupport<T>> getReadSupportClass(Configuration configuration) {
        return ConfigurationUtil.getClassFromConfig((Configuration)configuration, (String)"parquet.read.support.class", ReadSupport.class);
    }

    private static <T> ReadSupport<T> getReadSupportInstance(Class<? extends ReadSupport<T>> readSupportClass) {
        try {
            return readSupportClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new BadConfigurationException("could not instantiate read support class", (Throwable)e);
        }
    }

    protected static final class NullIntIterator
    extends IntIterator {
        protected NullIntIterator() {
        }

        @Override
        int nextInt() throws IOException {
            return 0;
        }
    }

    protected static final class RLEIntIterator
    extends IntIterator {
        RunLengthBitPackingHybridDecoder delegate;

        public RLEIntIterator(RunLengthBitPackingHybridDecoder delegate) {
            this.delegate = delegate;
        }

        @Override
        int nextInt() throws IOException {
            return this.delegate.readInt();
        }
    }

    protected static final class ValuesReaderIntIterator
    extends IntIterator {
        ValuesReader delegate;

        public ValuesReaderIntIterator(ValuesReader delegate) {
            this.delegate = delegate;
        }

        @Override
        int nextInt() throws IOException {
            return this.delegate.readInteger();
        }
    }

    static abstract class IntIterator {
        IntIterator() {
        }

        abstract int nextInt() throws IOException;
    }
}

