/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand$class;
import org.apache.spark.sql.execution.command.TruncateTableCommand$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0001\u0003\u0001>\u0011A\u0003\u0016:v]\u000e\fG/\u001a+bE2,7i\\7nC:$'BA\u0002\u0005\u0003\u001d\u0019w.\\7b]\u0012T!!\u0002\u0004\u0002\u0013\u0015DXmY;uS>t'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011#\u0002\u0001\u00115y!\u0003CA\t\u0019\u001b\u0005\u0011\"BA\n\u0015\u0003\u001dawnZ5dC2T!!\u0006\f\u0002\u000bAd\u0017M\\:\u000b\u0005]1\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005e\u0011\"a\u0003'pO&\u001c\u0017\r\u001c)mC:\u0004\"a\u0007\u000f\u000e\u0003\tI!!\b\u0002\u0003\u001fI+hN\\1cY\u0016\u001cu.\\7b]\u0012\u0004\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002 K%\u0011a\u0005\t\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tQ\u0001\u0011)\u001a!C\u0001S\u0005IA/\u00192mK:\u000bW.Z\u000b\u0002UA\u00111\u0006L\u0007\u0002-%\u0011QF\u0006\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\"Aq\u0006\u0001B\tB\u0003%!&\u0001\u0006uC\ndWMT1nK\u0002B\u0001\"\r\u0001\u0003\u0016\u0004%\tAM\u0001\u000ea\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\u0016\u0003M\u00022a\b\u001b7\u0013\t)\u0004E\u0001\u0004PaRLwN\u001c\t\u0003o-s!\u0001\u000f%\u000f\u0005e2eB\u0001\u001eF\u001d\tYDI\u0004\u0002=\u0007:\u0011QH\u0011\b\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001:\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0018\r%\u0011qIF\u0001\bG\u0006$\u0018\r\\8h\u0013\tI%*\u0001\u0007DCR\fGn\\4UsB,7O\u0003\u0002H-%\u0011A*\u0014\u0002\u0013)\u0006\u0014G.\u001a)beRLG/[8o'B,7M\u0003\u0002J\u0015\"Aq\n\u0001B\tB\u0003%1'\u0001\bqCJ$\u0018\u000e^5p]N\u0003Xm\u0019\u0011\t\u000bE\u0003A\u0011\u0001*\u0002\rqJg.\u001b;?)\r\u0019F+\u0016\t\u00037\u0001AQ\u0001\u000b)A\u0002)BQ!\r)A\u0002MBQa\u0016\u0001\u0005Ba\u000b1A];o)\tIf\rE\u0002[?\nt!aW/\u000f\u0005yb\u0016\"A\u0011\n\u0005y\u0003\u0013a\u00029bG.\fw-Z\u0005\u0003A\u0006\u00141aU3r\u0015\tq\u0006\u0005\u0005\u0002dI6\ta!\u0003\u0002f\r\t\u0019!k\\<\t\u000b%1\u0006\u0019A4\u0011\u0005\rD\u0017BA5\u0007\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u001dY\u0007!!A\u0005\u00021\fAaY8qsR\u00191+\u001c8\t\u000f!R\u0007\u0013!a\u0001U!9\u0011G\u001bI\u0001\u0002\u0004\u0019\u0004b\u00029\u0001#\u0003%\t!]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005\u0011(F\u0001\u0016tW\u0005!\bCA;{\u001b\u00051(BA<y\u0003%)hn\u00195fG.,GM\u0003\u0002zA\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005m4(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9Q\u0010AI\u0001\n\u0003q\u0018AD2paf$C-\u001a4bk2$HEM\u000b\u0002\u007f*\u00121g\u001d\u0005\n\u0003\u0007\u0001\u0011\u0011!C!\u0003\u000b\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u0004!\u0011\tI!a\u0005\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\tA\u0001\\1oO*\u0011\u0011\u0011C\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0016\u0005-!AB*ue&tw\rC\u0005\u0002\u001a\u0001\t\t\u0011\"\u0001\u0002\u001c\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u0004\t\u0004?\u0005}\u0011bAA\u0011A\t\u0019\u0011J\u001c;\t\u0013\u0005\u0015\u0002!!A\u0005\u0002\u0005\u001d\u0012A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003S\ty\u0003E\u0002 \u0003WI1!!\f!\u0005\r\te.\u001f\u0005\u000b\u0003c\t\u0019#!AA\u0002\u0005u\u0011a\u0001=%c!I\u0011Q\u0007\u0001\u0002\u0002\u0013\u0005\u0013qG\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\b\t\u0007\u0003w\t\t%!\u000b\u000e\u0005\u0005u\"bAA A\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0013Q\b\u0002\t\u0013R,'/\u0019;pe\"I\u0011q\t\u0001\u0002\u0002\u0013\u0005\u0011\u0011J\u0001\tG\u0006tW)];bYR!\u00111JA)!\ry\u0012QJ\u0005\u0004\u0003\u001f\u0002#a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0003c\t)%!AA\u0002\u0005%\u0002\"CA+\u0001\u0005\u0005I\u0011IA,\u0003\u0019)\u0017/^1mgR!\u00111JA-\u0011)\t\t$a\u0015\u0002\u0002\u0003\u0007\u0011\u0011F\u0004\n\u0003;\u0012\u0011\u0011!E\u0001\u0003?\nA\u0003\u0016:v]\u000e\fG/\u001a+bE2,7i\\7nC:$\u0007cA\u000e\u0002b\u0019A\u0011AAA\u0001\u0012\u0003\t\u0019gE\u0003\u0002b\u0005\u0015D\u0005E\u0004\u0002h\u00055$fM*\u000e\u0005\u0005%$bAA6A\u00059!/\u001e8uS6,\u0017\u0002BA8\u0003S\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83\u0011\u001d\t\u0016\u0011\rC\u0001\u0003g\"\"!a\u0018\t\u0015\u0005]\u0014\u0011MA\u0001\n\u000b\nI(\u0001\u0005u_N#(/\u001b8h)\t\t9\u0001\u0003\u0006\u0002~\u0005\u0005\u0014\u0011!CA\u0003\u007f\nQ!\u00199qYf$RaUAA\u0003\u0007Ca\u0001KA>\u0001\u0004Q\u0003BB\u0019\u0002|\u0001\u00071\u0007\u0003\u0006\u0002\b\u0006\u0005\u0014\u0011!CA\u0003\u0013\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\f\u0006M\u0005\u0003B\u00105\u0003\u001b\u0003RaHAHUMJ1!!%!\u0005\u0019!V\u000f\u001d7fe!I\u0011QSAC\u0003\u0003\u0005\raU\u0001\u0004q\u0012\u0002\u0004BCAM\u0003C\n\t\u0011\"\u0003\u0002\u001c\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\n\u0005\u0003\u0002\n\u0005}\u0015\u0002BAQ\u0003\u0017\u0011aa\u00142kK\u000e$\b")
public class TruncateTableCommand
extends LogicalPlan
implements RunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final Option<Map<String, String>> partitionSpec;

    public static Option<Tuple2<TableIdentifier, Option<Map<String, String>>>> unapply(TruncateTableCommand truncateTableCommand) {
        return TruncateTableCommand$.MODULE$.unapply(truncateTableCommand);
    }

    public static Function1<Tuple2<TableIdentifier, Option<Map<String, String>>>, TruncateTableCommand> tupled() {
        return TruncateTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Option<Map<String, String>>, TruncateTableCommand>> curried() {
        return TruncateTableCommand$.MODULE$.curried();
    }

    @Override
    public Seq<Attribute> output() {
        return RunnableCommand$class.output(this);
    }

    @Override
    public Seq<LogicalPlan> children() {
        return RunnableCommand$class.children(this);
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public Option<Map<String, String>> partitionSpec() {
        return this.partitionSpec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<Row> run(SparkSession spark) {
        Boolean bl;
        SessionCatalog catalog = spark.sessionState().catalog();
        if (!catalog.tableExists(this.tableName())) throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table '", "' in TRUNCATE TABLE does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        if (catalog.isTemporaryTable(this.tableName())) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: TRUNCATE TABLE on temporary tables: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        CatalogTable table = catalog.getTableMetadata(this.tableName());
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.EXTERNAL();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: TRUNCATE TABLE on external tables: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        CatalogTableType catalogTableType3 = table.tableType();
        CatalogTableType catalogTableType4 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType3 != null ? !catalogTableType3.equals(catalogTableType4) : catalogTableType4 != null)) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: TRUNCATE TABLE on views: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        boolean isDatasourceTable = DDLUtils$.MODULE$.isDatasourceTable(table);
        if (isDatasourceTable && this.partitionSpec().isDefined()) {
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: TRUNCATE TABLE ... PARTITION is not supported "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for tables created using the data sources API: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (table.partitionColumnNames().isEmpty() && this.partitionSpec().isDefined()) {
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: TRUNCATE TABLE ... PARTITION is not supported "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for tables that are not partitioned: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        Seq locations = isDatasourceTable ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{table.storage().serdeProperties().get((Object)"path")})) : (table.partitionColumnNames().isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{table.storage().locationUri()})) : (Seq)catalog.listPartitions(this.tableName(), this.partitionSpec()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply(CatalogTablePartition x$1) {
                return x$1.storage().locationUri();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Configuration hadoopConf = spark.sessionState().newHadoopConf();
        locations.foreach((Function1)new Serializable(this, hadoopConf){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TruncateTableCommand $outer;
            private final Configuration hadoopConf$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object apply(Option<String> location) {
                Object object;
                if (!location.isDefined()) {
                    object = BoxedUnit.UNIT;
                    return object;
                }
                Path path = new Path((String)location.get());
                try {
                    FileSystem fs = path.getFileSystem(this.hadoopConf$1);
                    fs.delete(path, true);
                    object = BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(path));
                    return object;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to truncate table '", "' when removing data of the path: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.tableName(), path}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"because of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.toString()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hadoopConf$1 = hadoopConf$1;
            }
        });
        spark.sessionState().refreshTable(this.tableName().unquotedString());
        try {
            bl = BoxesRunTime.boxToBoolean((boolean)spark.sharedState().cacheManager().uncacheQuery(spark.table(this.tableName().quotedString()), spark.sharedState().cacheManager().uncacheQuery$default$2()));
            return (Seq)Seq$.MODULE$.empty();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception when attempting to uncache table '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName()})), e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            bl = boxedUnit;
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public TruncateTableCommand copy(TableIdentifier tableName, Option<Map<String, String>> partitionSpec2) {
        return new TruncateTableCommand(tableName, partitionSpec2);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public Option<Map<String, String>> copy$default$2() {
        return this.partitionSpec();
    }

    public String productPrefix() {
        return "TruncateTableCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        TableIdentifier tableIdentifier;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                tableIdentifier = this.partitionSpec();
                break;
            }
            case 0: {
                tableIdentifier = this.tableName();
            }
        }
        return tableIdentifier;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TruncateTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TruncateTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        TruncateTableCommand truncateTableCommand = (TruncateTableCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = truncateTableCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Option<Map<String, String>> option = this.partitionSpec();
        Option<Map<String, String>> option2 = truncateTableCommand.partitionSpec();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!truncateTableCommand.canEqual(this)) return false;
        return true;
    }

    public TruncateTableCommand(TableIdentifier tableName, Option<Map<String, String>> partitionSpec2) {
        this.tableName = tableName;
        this.partitionSpec = partitionSpec2;
        RunnableCommand$class.$init$(this);
    }
}

