/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.util.ArrayDeque;
import java.util.Iterator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.execution.AggregateProcessor;
import org.apache.spark.sql.execution.BoundOrdering;
import org.apache.spark.sql.execution.RowBuffer;
import org.apache.spark.sql.execution.WindowFunctionFrame;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y3Q!\u0001\u0002\u0003\u00051\u0011!d\u00157jI&twmV5oI><h)\u001e8di&|gN\u0012:b[\u0016T!a\u0001\u0003\u0002\u0013\u0015DXmY;uS>t'BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0003\u001d=i\u0011AA\u0005\u0003!\t\u00111cV5oI><h)\u001e8di&|gN\u0012:b[\u0016D\u0001B\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u0007i\u0006\u0014x-\u001a;\u0004\u0001A\u0011QCG\u0007\u0002-)\u0011q\u0003G\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u001a\t\u0005A1-\u0019;bYf\u001cH/\u0003\u0002\u001c-\tQQ*\u001e;bE2,'k\\<\t\u0011u\u0001!\u0011!Q\u0001\ny\t\u0011\u0002\u001d:pG\u0016\u001c8o\u001c:\u0011\u00059y\u0012B\u0001\u0011\u0003\u0005I\tum\u001a:fO\u0006$X\r\u0015:pG\u0016\u001c8o\u001c:\t\u0011\t\u0002!\u0011!Q\u0001\n\r\na\u0001\u001c2pk:$\u0007C\u0001\b%\u0013\t)#AA\u0007C_VtGm\u0014:eKJLgn\u001a\u0005\tO\u0001\u0011\t\u0011)A\u0005G\u00051QOY8v]\u0012DQ!\u000b\u0001\u0005\u0002)\na\u0001P5oSRtD#B\u0016-[9z\u0003C\u0001\b\u0001\u0011\u0015\u0011\u0002\u00061\u0001\u0015\u0011\u0015i\u0002\u00061\u0001\u001f\u0011\u0015\u0011\u0003\u00061\u0001$\u0011\u00159\u0003\u00061\u0001$\u0011\u0019\t\u0004\u0001)Q\u0005e\u0005)\u0011N\u001c9viB\u0011abM\u0005\u0003i\t\u0011\u0011BU8x\u0005V4g-\u001a:\t\rY\u0002\u0001\u0015)\u00038\u0003\u001dqW\r\u001f;S_^\u0004\"\u0001O\u001d\u000e\u0003aI!A\u000f\r\u0003\u0017%sG/\u001a:oC2\u0014vn\u001e\u0005\u0007y\u0001\u0001\u000b\u0011B\u001f\u0002\r\t,hMZ3s!\rq4iN\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0005kRLGNC\u0001C\u0003\u0011Q\u0017M^1\n\u0005\u0011{$AC!se\u0006LH)Z9vK\"1a\t\u0001Q!\n\u001d\u000ba\"\u001b8qkRD\u0015n\u001a5J]\u0012,\u0007\u0010\u0005\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015JA\u0002J]RDaA\u0014\u0001!B\u00139\u0015!D5oaV$Hj\\<J]\u0012,\u0007\u0010C\u0003Q\u0001\u0011\u0005\u0013+A\u0004qe\u0016\u0004\u0018M]3\u0015\u0005I+\u0006C\u0001%T\u0013\t!\u0016J\u0001\u0003V]&$\b\"\u0002,P\u0001\u0004\u0011\u0014\u0001\u0002:poNDQ\u0001\u0017\u0001\u0005Be\u000bQa\u001e:ji\u0016$2A\u0015.]\u0011\u0015Yv\u000b1\u0001H\u0003\u0015Ig\u000eZ3y\u0011\u0015iv\u000b1\u00018\u0003\u001d\u0019WO\u001d:f]R\u0004")
public final class SlidingWindowFunctionFrame
extends WindowFunctionFrame {
    private final MutableRow target;
    private final AggregateProcessor processor;
    private final BoundOrdering lbound;
    private final BoundOrdering ubound;
    private RowBuffer input;
    private InternalRow nextRow;
    private final ArrayDeque<InternalRow> buffer;
    private int inputHighIndex;
    private int inputLowIndex;

    @Override
    public void prepare(RowBuffer rows) {
        this.input = rows;
        this.nextRow = rows.next();
        this.inputHighIndex = 0;
        this.inputLowIndex = 0;
        this.buffer.clear();
    }

    @Override
    public void write(int index, InternalRow current) {
        boolean bufferUpdated;
        boolean bl = bufferUpdated = index == 0;
        while (this.nextRow != null && this.ubound.compare(this.nextRow, this.inputHighIndex, current, index) <= 0) {
            this.buffer.add(this.nextRow.copy());
            this.nextRow = this.input.next();
            ++this.inputHighIndex;
            bufferUpdated = true;
        }
        while (!this.buffer.isEmpty() && this.lbound.compare(this.buffer.peek(), this.inputLowIndex, current, index) < 0) {
            this.buffer.remove();
            ++this.inputLowIndex;
            bufferUpdated = true;
        }
        if (bufferUpdated) {
            this.processor.initialize(this.input.size());
            Iterator<InternalRow> iter = this.buffer.iterator();
            while (iter.hasNext()) {
                this.processor.update(iter.next());
            }
            this.processor.evaluate(this.target);
        }
    }

    public SlidingWindowFunctionFrame(MutableRow target, AggregateProcessor processor2, BoundOrdering lbound, BoundOrdering ubound) {
        this.target = target;
        this.processor = processor2;
        this.lbound = lbound;
        this.ubound = ubound;
        this.input = null;
        this.nextRow = null;
        this.buffer = new ArrayDeque();
        this.inputHighIndex = 0;
        this.inputLowIndex = 0;
    }
}

