/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.sql.Connection;
import java.sql.Statement;
import java.util.Properties;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.DataFrameWriter$$anonfun$org$apache$spark$sql$DataFrameWriter$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.BucketSpec;
import org.apache.spark.sql.execution.datasources.CreateTableUsingAsSelect;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\t}e\u0001B\u0001\u0003\u0005-\u0011q\u0002R1uC\u001a\u0013\u0018-\\3Xe&$XM\u001d\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\u000b\u0003\u0019m\u0019\"\u0001A\u0007\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g\u0011!!\u0002A!A!\u0002\u0013)\u0012A\u00013t!\r1r#G\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\b\t\u0006$\u0018m]3u!\tQ2\u0004\u0004\u0001\u0005\u000bq\u0001!\u0019A\u000f\u0003\u0003Q\u000b\"AH\u0011\u0011\u00059y\u0012B\u0001\u0011\u0010\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u0004\u0012\n\u0005\rz!aA!os\"1Q\u0005\u0001C\u0001\u0005\u0019\na\u0001P5oSRtDCA\u0014)!\r1\u0002!\u0007\u0005\u0006)\u0011\u0002\r!\u0006\u0005\bU\u0001\u0011\r\u0011\"\u0003,\u0003\t!g-F\u0001-!\ti\u0003G\u0004\u0002\u0017]%\u0011qFA\u0001\ba\u0006\u001c7.Y4f\u0013\t\t$GA\u0005ECR\fgI]1nK*\u0011qF\u0001\u0005\u0007i\u0001\u0001\u000b\u0011\u0002\u0017\u0002\u0007\u00114\u0007\u0005C\u00037\u0001\u0011\u0005q'\u0001\u0003n_\u0012,GCA\u00149\u0011\u0015IT\u00071\u0001;\u0003!\u0019\u0018M^3N_\u0012,\u0007C\u0001\f<\u0013\ta$A\u0001\u0005TCZ,Wj\u001c3f\u0011\u00151\u0004\u0001\"\u0001?)\t9s\bC\u0003:{\u0001\u0007\u0001\t\u0005\u0002B\t:\u0011aBQ\u0005\u0003\u0007>\ta\u0001\u0015:fI\u00164\u0017BA#G\u0005\u0019\u0019FO]5oO*\u00111i\u0004\u0005\u0006\u0011\u0002!\t!S\u0001\u0007M>\u0014X.\u0019;\u0015\u0005\u001dR\u0005\"B&H\u0001\u0004\u0001\u0015AB:pkJ\u001cW\rC\u0003N\u0001\u0011\u0005a*\u0001\u0004paRLwN\u001c\u000b\u0004O=\u000b\u0006\"\u0002)M\u0001\u0004\u0001\u0015aA6fs\")!\u000b\u0014a\u0001\u0001\u0006)a/\u00197vK\")Q\n\u0001C\u0001)R\u0019q%\u0016,\t\u000bA\u001b\u0006\u0019\u0001!\t\u000bI\u001b\u0006\u0019A,\u0011\u00059A\u0016BA-\u0010\u0005\u001d\u0011un\u001c7fC:DQ!\u0014\u0001\u0005\u0002m#2a\n/^\u0011\u0015\u0001&\f1\u0001A\u0011\u0015\u0011&\f1\u0001_!\tqq,\u0003\u0002a\u001f\t!Aj\u001c8h\u0011\u0015i\u0005\u0001\"\u0001c)\r93\r\u001a\u0005\u0006!\u0006\u0004\r\u0001\u0011\u0005\u0006%\u0006\u0004\r!\u001a\t\u0003\u001d\u0019L!aZ\b\u0003\r\u0011{WO\u00197f\u0011\u0015I\u0007\u0001\"\u0001k\u0003\u001dy\u0007\u000f^5p]N$\"aJ6\t\u000b%D\u0007\u0019\u00017\u0011\t5\u0004\b\tQ\u0007\u0002]*\u0011qnD\u0001\u000bG>dG.Z2uS>t\u0017BA9o\u0005\ri\u0015\r\u001d\u0005\u0006S\u0002!\ta\u001d\u000b\u0003OQDQ!\u001b:A\u0002U\u0004BA^>A\u00016\tqO\u0003\u0002ys\u0006!Q\u000f^5m\u0015\u0005Q\u0018\u0001\u00026bm\u0006L!!]<\t\u000bu\u0004A\u0011\u0001@\u0002\u0017A\f'\u000f^5uS>t')\u001f\u000b\u0003O}Dq!!\u0001}\u0001\u0004\t\u0019!\u0001\u0005d_2t\u0015-\\3t!\u0011q\u0011Q\u0001!\n\u0007\u0005\u001dqB\u0001\u0006=e\u0016\u0004X-\u0019;fIzB3\u0001`A\u0006!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\t\u001f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u0011q\u0002\u0002\bm\u0006\u0014\u0018M]4t\u0011\u001d\tI\u0002\u0001C\u0001\u00037\t\u0001BY;dW\u0016$()\u001f\u000b\bO\u0005u\u0011qEA\u0016\u0011!\ty\"a\u0006A\u0002\u0005\u0005\u0012A\u00038v[\n+8m[3ugB\u0019a\"a\t\n\u0007\u0005\u0015rBA\u0002J]RDq!!\u000b\u0002\u0018\u0001\u0007\u0001)A\u0004d_2t\u0015-\\3\t\u0011\u0005\u0005\u0011q\u0003a\u0001\u0003\u0007AC!a\u0006\u0002\f!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0012AB:peR\u0014\u0015\u0010F\u0003(\u0003k\t9\u0004C\u0004\u0002*\u0005=\u0002\u0019\u0001!\t\u0011\u0005\u0005\u0011q\u0006a\u0001\u0003\u0007AC!a\f\u0002\f!9\u0011Q\b\u0001\u0005\u0002\u0005}\u0012\u0001B:bm\u0016$B!!\u0011\u0002HA\u0019a\"a\u0011\n\u0007\u0005\u0015sB\u0001\u0003V]&$\bbBA%\u0003w\u0001\r\u0001Q\u0001\u0005a\u0006$\b\u000eC\u0004\u0002>\u0001!\t!!\u0014\u0015\u0005\u0005\u0005\u0003bBA)\u0001\u0011\u0005\u00111K\u0001\u000bS:\u001cXM\u001d;J]R|G\u0003BA!\u0003+Bq!a\u0016\u0002P\u0001\u0007\u0001)A\u0005uC\ndWMT1nK\"9\u0011\u0011\u000b\u0001\u0005\n\u0005mC\u0003BA!\u0003;B\u0001\"a\u0018\u0002Z\u0001\u0007\u0011\u0011M\u0001\u000bi\u0006\u0014G.Z%eK:$\b\u0003BA2\u0003Sj!!!\u001a\u000b\u0007\u0005\u001d$!\u0001\u0005dCR\fG._:u\u0013\u0011\tY'!\u001a\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJDq!a\u001c\u0001\t\u0013\t\t(A\to_Jl\u0017\r\\5{K\u0012\u0004\u0016M]\"pYN,\"!a\u001d\u0011\u000b9\t)(!\u001f\n\u0007\u0005]tB\u0001\u0004PaRLwN\u001c\t\u0006\u0003w\nI\t\u0011\b\u0005\u0003{\n9I\u0004\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\r\t\u0019IC\u0001\u0007yI|w\u000e\u001e \n\u0003AI!aL\b\n\t\u0005-\u0015Q\u0012\u0002\u0004'\u0016\f(BA\u0018\u0010\u0011\u001d\t\t\n\u0001C\u0005\u0003c\n\u0001D\\8s[\u0006d\u0017N_3e\u0005V\u001c7.\u001a;D_2t\u0015-\\3t\u0011\u001d\t)\n\u0001C\u0005\u0003c\naC\\8s[\u0006d\u0017N_3e'>\u0014HoQ8m\u001d\u0006lWm\u001d\u0005\b\u00033\u0003A\u0011BAN\u000359W\r\u001e\"vG.,Go\u00159fGV\u0011\u0011Q\u0014\t\u0006\u001d\u0005U\u0014q\u0014\t\u0005\u0003C\u000bY+\u0004\u0002\u0002$*!\u0011QUAT\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0007\u0005%&!A\u0005fq\u0016\u001cW\u000f^5p]&!\u0011QVAR\u0005)\u0011UoY6fiN\u0003Xm\u0019\u0005\b\u0003c\u0003A\u0011BAZ\u0003%qwN]7bY&TX\rF\u0003A\u0003k\u000bI\fC\u0004\u00028\u0006=\u0006\u0019\u0001!\u0002\u0015\r|G.^7o\u001d\u0006lW\rC\u0004\u0002<\u0006=\u0006\u0019\u0001!\u0002\u0015\r|G.^7o)f\u0004X\rC\u0004\u0002@\u0002!I!!1\u0002#\u0005\u001c8/\u001a:u\u001d>$()^2lKR,G\r\u0006\u0003\u0002B\u0005\r\u0007bBAc\u0003{\u0003\r\u0001Q\u0001\n_B,'/\u0019;j_:Dq!!3\u0001\t\u0013\tY-\u0001\u000bbgN,'\u000f\u001e(piB\u000b'\u000f^5uS>tW\r\u001a\u000b\u0005\u0003\u0003\ni\rC\u0004\u0002F\u0006\u001d\u0007\u0019\u0001!\t\u000f\u0005E\u0007\u0001\"\u0001\u0002T\u0006Y1/\u0019<f\u0003N$\u0016M\u00197f)\u0011\t\t%!6\t\u000f\u0005]\u0013q\u001aa\u0001\u0001\"9\u0011\u0011\u001b\u0001\u0005\n\u0005eG\u0003BA!\u00037D\u0001\"a\u0018\u0002X\u0002\u0007\u0011\u0011\r\u0005\b\u0003?\u0004A\u0011AAq\u0003\u0011QGMY2\u0015\u0011\u0005\u0005\u00131]At\u0003WDq!!:\u0002^\u0002\u0007\u0001)A\u0002ve2Dq!!;\u0002^\u0002\u0007\u0001)A\u0003uC\ndW\r\u0003\u0005\u0002n\u0006u\u0007\u0019AAx\u0003Q\u0019wN\u001c8fGRLwN\u001c)s_B,'\u000f^5fgB\u0019a/!=\n\u0007\u0005MxO\u0001\u0006Qe>\u0004XM\u001d;jKNDq!a>\u0001\t\u0003\tI0\u0001\u0003kg>tG\u0003BA!\u0003wDq!!\u0013\u0002v\u0002\u0007\u0001\tC\u0004\u0002\u0000\u0002!\tA!\u0001\u0002\u000fA\f'/];fiR!\u0011\u0011\tB\u0002\u0011\u001d\tI%!@A\u0002\u0001CqAa\u0002\u0001\t\u0003\u0011I!A\u0002pe\u000e$B!!\u0011\u0003\f!9\u0011\u0011\nB\u0003\u0001\u0004\u0001\u0005b\u0002B\b\u0001\u0011\u0005!\u0011C\u0001\u0005i\u0016DH\u000f\u0006\u0003\u0002B\tM\u0001bBA%\u0005\u001b\u0001\r\u0001\u0011\u0005\b\u0005/\u0001A\u0011\u0001B\r\u0003\r\u00197O\u001e\u000b\u0005\u0003\u0003\u0012Y\u0002C\u0004\u0002J\tU\u0001\u0019\u0001!\t\u0011-\u0003\u0001\u0019!C\u0005\u0005?)\u0012\u0001\u0011\u0005\n\u0005G\u0001\u0001\u0019!C\u0005\u0005K\t!b]8ve\u000e,w\fJ3r)\u0011\t\tEa\n\t\u0013\t%\"\u0011EA\u0001\u0002\u0004\u0001\u0015a\u0001=%c!9!Q\u0006\u0001!B\u0013\u0001\u0015aB:pkJ\u001cW\r\t\u0005\tm\u0001\u0001\r\u0011\"\u0003\u00032U\t!\bC\u0005\u00036\u0001\u0001\r\u0011\"\u0003\u00038\u0005AQn\u001c3f?\u0012*\u0017\u000f\u0006\u0003\u0002B\te\u0002\"\u0003B\u0015\u0005g\t\t\u00111\u0001;\u0011\u001d\u0011i\u0004\u0001Q!\ni\nQ!\\8eK\u0002B\u0011B!\u0011\u0001\u0001\u0004%IAa\u0011\u0002\u0019\u0015DHO]1PaRLwN\\:\u0016\u0005\t\u0015\u0003C\u0002B$\u0005\u001b\u0002\u0005)\u0004\u0002\u0003J)\u0019!1\n8\u0002\u000f5,H/\u00192mK&!!q\nB%\u0005\u001dA\u0015m\u001d5NCBD\u0011Ba\u0015\u0001\u0001\u0004%IA!\u0016\u0002!\u0015DHO]1PaRLwN\\:`I\u0015\fH\u0003BA!\u0005/B!B!\u000b\u0003R\u0005\u0005\t\u0019\u0001B#\u0011!\u0011Y\u0006\u0001Q!\n\t\u0015\u0013!D3yiJ\fw\n\u001d;j_:\u001c\b\u0005C\u0005\u0003`\u0001\u0001\r\u0011\"\u0003\u0002r\u0005\u0019\u0002/\u0019:uSRLwN\\5oO\u000e{G.^7og\"I!1\r\u0001A\u0002\u0013%!QM\u0001\u0018a\u0006\u0014H/\u001b;j_:LgnZ\"pYVlgn]0%KF$B!!\u0011\u0003h!Q!\u0011\u0006B1\u0003\u0003\u0005\r!a\u001d\t\u0011\t-\u0004\u0001)Q\u0005\u0003g\nA\u0003]1si&$\u0018n\u001c8j]\u001e\u001cu\u000e\\;n]N\u0004\u0003\"\u0003B8\u0001\u0001\u0007I\u0011BA9\u0003E\u0011WoY6fi\u000e{G.^7o\u001d\u0006lWm\u001d\u0005\n\u0005g\u0002\u0001\u0019!C\u0005\u0005k\nQCY;dW\u0016$8i\u001c7v[:t\u0015-\\3t?\u0012*\u0017\u000f\u0006\u0003\u0002B\t]\u0004B\u0003B\u0015\u0005c\n\t\u00111\u0001\u0002t!A!1\u0010\u0001!B\u0013\t\u0019(\u0001\nck\u000e\\W\r^\"pYVlgNT1nKN\u0004\u0003\"CA\u0010\u0001\u0001\u0007I\u0011\u0002B@+\t\u0011\t\tE\u0003\u000f\u0003k\n\t\u0003C\u0005\u0003\u0006\u0002\u0001\r\u0011\"\u0003\u0003\b\u0006qa.^7Ck\u000e\\W\r^:`I\u0015\fH\u0003BA!\u0005\u0013C!B!\u000b\u0003\u0004\u0006\u0005\t\u0019\u0001BA\u0011!\u0011i\t\u0001Q!\n\t\u0005\u0015a\u00038v[\n+8m[3ug\u0002B\u0011B!%\u0001\u0001\u0004%I!!\u001d\u0002\u001fM|'\u000f^\"pYVlgNT1nKND\u0011B!&\u0001\u0001\u0004%IAa&\u0002'M|'\u000f^\"pYVlgNT1nKN|F%Z9\u0015\t\u0005\u0005#\u0011\u0014\u0005\u000b\u0005S\u0011\u0019*!AA\u0002\u0005M\u0004\u0002\u0003BO\u0001\u0001\u0006K!a\u001d\u0002!M|'\u000f^\"pYVlgNT1nKN\u0004\u0003")
public final class DataFrameWriter<T> {
    private final Dataset<Row> org$apache$spark$sql$DataFrameWriter$$df;
    private String source;
    private SaveMode mode;
    private HashMap<String, String> extraOptions;
    private Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$partitioningColumns;
    private Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$bucketColumnNames;
    private Option<Object> numBuckets;
    private Option<Seq<String>> sortColumnNames;

    public DataFrameWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, String ... colNames) {
        return this.bucketBy(numBuckets, colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> sortBy(String colName, String ... colNames) {
        return this.sortBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public Dataset<Row> org$apache$spark$sql$DataFrameWriter$$df() {
        return this.org$apache$spark$sql$DataFrameWriter$$df;
    }

    public DataFrameWriter<T> mode(SaveMode saveMode) {
        this.mode_$eq(saveMode);
        return this;
    }

    public DataFrameWriter<T> mode(String saveMode) {
        block6: {
            SaveMode saveMode2;
            block3: {
                String string;
                block5: {
                    block4: {
                        block2: {
                            string = saveMode.toLowerCase();
                            if (!"overwrite".equals(string)) break block2;
                            saveMode2 = SaveMode.Overwrite;
                            break block3;
                        }
                        if (!"append".equals(string)) break block4;
                        saveMode2 = SaveMode.Append;
                        break block3;
                    }
                    if (!"ignore".equals(string)) break block5;
                    saveMode2 = SaveMode.Ignore;
                    break block3;
                }
                boolean bl = "error".equals(string) ? true : "default".equals(string);
                if (!bl) break block6;
                saveMode2 = SaveMode.ErrorIfExists;
            }
            this.mode_$eq(saveMode2);
            return this;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown save mode: ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{saveMode}))).append((Object)"Accepted save modes are 'overwrite', 'append', 'ignore', 'error'.").toString());
    }

    public DataFrameWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameWriter<T> option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameWriter<T> option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameWriter<T> option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameWriter<T> option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameWriter<T> options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataFrameWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public DataFrameWriter<T> partitionBy(Seq<String> colNames) {
        this.org$apache$spark$sql$DataFrameWriter$$partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, Seq<String> colNames) {
        this.numBuckets_$eq((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numBuckets)));
        String string = colName;
        this.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public DataFrameWriter<T> sortBy(String colName, Seq<String> colNames) {
        String string = colName;
        this.sortColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public void save(String path) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path));
        this.save();
    }

    public void save() {
        this.assertNotBucketed("save");
        SparkSession x$9 = this.org$apache$spark$sql$DataFrameWriter$$df().sparkSession();
        String x$10 = this.source();
        Seq x$11 = (Seq)this.org$apache$spark$sql$DataFrameWriter$$partitioningColumns().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nil$ apply() {
                return Nil$.MODULE$;
            }
        });
        Option<BucketSpec> x$12 = this.getBucketSpec();
        scala.collection.immutable.Map x$13 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        Seq<String> x$14 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$15 = DataSource$.MODULE$.apply$default$4();
        DataSource dataSource = new DataSource(x$9, x$10, x$14, x$15, (Seq<String>)x$11, x$12, (scala.collection.immutable.Map<String, String>)x$13);
        dataSource.write(this.mode(), this.org$apache$spark$sql$DataFrameWriter$$df());
    }

    public void insertInto(String tableName) {
        this.insertInto(this.org$apache$spark$sql$DataFrameWriter$$df().sparkSession().sessionState().sqlParser().parseTableIdentifier(tableName));
    }

    private void insertInto(TableIdentifier tableIdent) {
        this.assertNotBucketed("insertInto");
        if (this.org$apache$spark$sql$DataFrameWriter$$partitioningColumns().isDefined()) {
            throw new AnalysisException("insertInto() can't be used together with partitionBy(). Partition columns have already be defined for the table. It is not necessary to use partitionBy().", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = SaveMode.Overwrite;
        this.org$apache$spark$sql$DataFrameWriter$$df().sparkSession().sessionState().executePlan((LogicalPlan)new InsertIntoTable((LogicalPlan)new UnresolvedRelation(tableIdent, UnresolvedRelation$.MODULE$.apply$default$2()), Predef$.MODULE$.Map().empty(), this.org$apache$spark$sql$DataFrameWriter$$df().logicalPlan(), !(saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode2) : saveMode2 != null), false)).toRdd();
    }

    public Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$normalizedParCols() {
        return this.org$apache$spark$sql$DataFrameWriter$$partitioningColumns().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataFrameWriter $outer;

            public final Seq<String> apply(Seq<String> cols) {
                return (Seq)cols.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$org$apache$spark$sql$DataFrameWriter$$normalizedParCols$1 $outer;

                    public final String apply(String x$3) {
                        return this.$outer.org$apache$spark$sql$DataFrameWriter$$anonfun$$$outer().org$apache$spark$sql$DataFrameWriter$$normalize(x$3, "Partition");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ DataFrameWriter org$apache$spark$sql$DataFrameWriter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$normalizedBucketColNames() {
        return this.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataFrameWriter $outer;

            public final Seq<String> apply(Seq<String> cols) {
                return (Seq)cols.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$org$apache$spark$sql$DataFrameWriter$$normalizedBucketColNames$1 $outer;

                    public final String apply(String x$4) {
                        return this.$outer.org$apache$spark$sql$DataFrameWriter$$anonfun$$$outer().org$apache$spark$sql$DataFrameWriter$$normalize(x$4, "Bucketing");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ DataFrameWriter org$apache$spark$sql$DataFrameWriter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$normalizedSortColNames() {
        return this.sortColumnNames().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataFrameWriter $outer;

            public final Seq<String> apply(Seq<String> cols) {
                return (Seq)cols.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$org$apache$spark$sql$DataFrameWriter$$normalizedSortColNames$1 $outer;

                    public final String apply(String x$5) {
                        return this.$outer.org$apache$spark$sql$DataFrameWriter$$anonfun$$$outer().org$apache$spark$sql$DataFrameWriter$$normalize(x$5, "Sorting");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ DataFrameWriter org$apache$spark$sql$DataFrameWriter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private Option<BucketSpec> getBucketSpec() {
        if (this.sortColumnNames().isDefined()) {
            Predef$.MODULE$.require(this.numBuckets().isDefined(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "sortBy must be used together with bucketBy";
                }
            });
        }
        return this.numBuckets().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataFrameWriter $outer;

            public final BucketSpec apply(int n) {
                Predef$.MODULE$.require(n > 0 && n < 100000, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Bucket number must be greater than 0 and less than 100000.";
                    }
                });
                if (this.$outer.org$apache$spark$sql$DataFrameWriter$$normalizedParCols().nonEmpty() && ((TraversableOnce)((TraversableOnce)this.$outer.org$apache$spark$sql$DataFrameWriter$$normalizedBucketColNames().get()).toSet().intersect((GenSet)((TraversableOnce)this.$outer.org$apache$spark$sql$DataFrameWriter$$normalizedParCols().get()).toSet())).nonEmpty()) {
                    throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bucketBy columns '", "' should not be part of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.$outer.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames().get()).mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitionBy columns '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.$outer.org$apache$spark$sql$DataFrameWriter$$partitioningColumns().get()).mkString(", ")}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                return new BucketSpec(n, (Seq<String>)((Seq)this.$outer.org$apache$spark$sql$DataFrameWriter$$normalizedBucketColNames().get()), (Seq<String>)((Seq)this.$outer.org$apache$spark$sql$DataFrameWriter$$normalizedSortColNames().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nil$ apply() {
                        return Nil$.MODULE$;
                    }
                })));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public String org$apache$spark$sql$DataFrameWriter$$normalize(String columnName, String columnType) {
        Seq validColumnNames = (Seq)this.org$apache$spark$sql$DataFrameWriter$$df().logicalPlan().output().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Attribute x$6) {
                return x$6.name();
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (String)validColumnNames.find((Function1)new Serializable(this, columnName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataFrameWriter $outer;
            private final String columnName$1;

            public final boolean apply(String x$7) {
                return BoxesRunTime.unboxToBoolean((Object)this.$outer.org$apache$spark$sql$DataFrameWriter$$df().sparkSession().sessionState().analyzer().resolver().apply((Object)x$7, (Object)this.columnName$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnName$1 = columnName$1;
            }
        }).getOrElse((Function0)new Serializable(this, columnName, columnType, validColumnNames){
            public static final long serialVersionUID = 0L;
            private final String columnName$1;
            private final String columnType$1;
            private final Seq validColumnNames$1;

            public final Nothing$ apply() {
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " column ", " not found in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.columnType$1, this.columnName$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"existing columns (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.validColumnNames$1.mkString(", ")}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            {
                void var4_4;
                void var3_3;
                this.columnName$1 = columnName$1;
                this.columnType$1 = var3_3;
                this.validColumnNames$1 = var4_4;
            }
        });
    }

    private void assertNotBucketed(String operation) {
        if (this.numBuckets().isDefined() || this.sortColumnNames().isDefined()) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' does not support bucketing right now"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void assertNotPartitioned(String operation) {
        if (this.org$apache$spark$sql$DataFrameWriter$$partitioningColumns().isDefined()) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' does not support partitioning"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public void saveAsTable(String tableName) {
        this.saveAsTable(this.org$apache$spark$sql$DataFrameWriter$$df().sparkSession().sessionState().sqlParser().parseTableIdentifier(tableName));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void saveAsTable(TableIdentifier tableIdent) {
        boolean tableExists2 = this.org$apache$spark$sql$DataFrameWriter$$df().sparkSession().sessionState().catalog().tableExists(tableIdent);
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)tableExists2), (Object)this.mode());
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Ignore)).equals((Object)saveMode)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.ErrorIfExists)).equals((Object)saveMode)) {
                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdent})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        CreateTableUsingAsSelect cmd = new CreateTableUsingAsSelect(tableIdent, this.source(), (String[])this.org$apache$spark$sql$DataFrameWriter$$partitioningColumns().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply(Seq<String> x$8) {
                return (String[])x$8.toArray(ClassTag$.MODULE$.apply(String.class));
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String[] apply() {
                return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
            }
        }), this.getBucketSpec(), this.mode(), (scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.$conforms()), this.org$apache$spark$sql$DataFrameWriter$$df().logicalPlan());
        this.org$apache$spark$sql$DataFrameWriter$$df().sparkSession().sessionState().executePlan((LogicalPlan)cmd).toRdd();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void jdbc(String url, String table, Properties connectionProperties) {
        Object object;
        boolean tableExists2;
        Connection conn;
        Properties props;
        block10: {
            this.assertNotPartitioned("jdbc");
            this.assertNotBucketed("jdbc");
            props = new Properties();
            this.extraOptions().foreach((Function1)new Serializable(this, props){
                public static final long serialVersionUID = 0L;
                private final Properties props$1;

                public final Object apply(Tuple2<String, String> x0$1) {
                    Tuple2<String, String> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        Object object = this.props$1.put(key, value);
                        return object;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.props$1 = props$1;
                }
            });
            props.putAll((java.util.Map<?, ?>)connectionProperties);
            conn = (Connection)JdbcUtils$.MODULE$.createConnectionFactory(url, props).apply();
            tableExists2 = JdbcUtils$.MODULE$.tableExists(conn, url, table);
            SaveMode saveMode = this.mode();
            SaveMode saveMode2 = SaveMode.Ignore;
            if ((saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode2) : saveMode2 != null) || !tableExists2) break block10;
            {
                catch (Throwable throwable) {
                    void var5_5;
                    var5_5.close();
                    throw throwable;
                }
            }
            conn.close();
            return;
        }
        SaveMode saveMode = this.mode();
        SaveMode saveMode3 = SaveMode.ErrorIfExists;
        if (!(saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode3) : saveMode3 != null) && tableExists2) {
            throw package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table})));
        }
        SaveMode saveMode4 = this.mode();
        SaveMode saveMode5 = SaveMode.Overwrite;
        if (!(saveMode4 != null ? !((Object)((Object)saveMode4)).equals((Object)saveMode5) : saveMode5 != null) && tableExists2) {
            JdbcUtils$.MODULE$.dropTable(conn, table);
            tableExists2 = false;
        }
        if (tableExists2) {
            object = BoxedUnit.UNIT;
        } else {
            String schema = JdbcUtils$.MODULE$.schemaString(this.org$apache$spark$sql$DataFrameWriter$$df(), url);
            String sql = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CREATE TABLE ", " (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table, schema}));
            Statement statement = conn.createStatement();
            int n = statement.executeUpdate(sql);
            statement.close();
            object = BoxesRunTime.boxToInteger((int)n);
        }
        conn.close();
        JdbcUtils$.MODULE$.saveTable(this.org$apache$spark$sql$DataFrameWriter$$df(), url, table, props);
        return;
        catch (Throwable throwable) {
            void var12_12;
            var12_12.close();
            throw throwable;
        }
    }

    public void json(String path) {
        this.format("json").save(path);
    }

    public void parquet(String path) {
        this.format("parquet").save(path);
    }

    public void orc(String path) {
        this.format("orc").save(path);
    }

    public void text(String path) {
        this.format("text").save(path);
    }

    public void csv(String path) {
        this.format("csv").save(path);
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private void mode_$eq(SaveMode x$1) {
        this.mode = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(HashMap<String, String> x$1) {
        this.extraOptions = x$1;
    }

    public Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$partitioningColumns() {
        return this.org$apache$spark$sql$DataFrameWriter$$partitioningColumns;
    }

    private void org$apache$spark$sql$DataFrameWriter$$partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.org$apache$spark$sql$DataFrameWriter$$partitioningColumns = x$1;
    }

    public Option<Seq<String>> org$apache$spark$sql$DataFrameWriter$$bucketColumnNames() {
        return this.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames;
    }

    private void org$apache$spark$sql$DataFrameWriter$$bucketColumnNames_$eq(Option<Seq<String>> x$1) {
        this.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames = x$1;
    }

    private Option<Object> numBuckets() {
        return this.numBuckets;
    }

    private void numBuckets_$eq(Option<Object> x$1) {
        this.numBuckets = x$1;
    }

    private Option<Seq<String>> sortColumnNames() {
        return this.sortColumnNames;
    }

    private void sortColumnNames_$eq(Option<Seq<String>> x$1) {
        this.sortColumnNames = x$1;
    }

    public DataFrameWriter(Dataset<T> ds) {
        this.org$apache$spark$sql$DataFrameWriter$$df = ds.toDF();
        this.source = this.org$apache$spark$sql$DataFrameWriter$$df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.mode = SaveMode.ErrorIfExists;
        this.extraOptions = new HashMap();
        this.org$apache$spark$sql$DataFrameWriter$$partitioningColumns = None$.MODULE$;
        this.org$apache$spark$sql$DataFrameWriter$$bucketColumnNames = None$.MODULE$;
        this.numBuckets = None$.MODULE$;
        this.sortColumnNames = None$.MODULE$;
    }
}

