/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.util.Map;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.Catalog;
import org.apache.spark.sql.catalog.Column;
import org.apache.spark.sql.catalog.Database;
import org.apache.spark.sql.catalog.Function;
import org.apache.spark.sql.catalog.Table;
import org.apache.spark.sql.catalyst.DefinedByConstructorParams;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogColumn;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.execution.CacheManager;
import org.apache.spark.sql.execution.datasources.BucketSpec;
import org.apache.spark.sql.execution.datasources.CreateTableUsing;
import org.apache.spark.sql.internal.CatalogImpl$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;

@ScalaSignature(bytes="\u0006\u0001\t=d\u0001B\u0001\u0003\u00015\u00111bQ1uC2|w-S7qY*\u00111\u0001B\u0001\tS:$XM\u001d8bY*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tqaY1uC2|w-\u0003\u0002\u0014!\t91)\u0019;bY><\u0007\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005]AR\"\u0001\u0003\n\u0005e!!\u0001D*qCJ\\7+Z:tS>t\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001e?A\u0011a\u0004A\u0007\u0002\u0005!)QC\u0007a\u0001-!)\u0011\u0005\u0001C\u0005E\u0005q1/Z:tS>t7)\u0019;bY><W#A\u0012\u0011\u0005\u0011BS\"A\u0013\u000b\u0005E1#BA\u0014\u0005\u0003!\u0019\u0017\r^1msN$\u0018BA\u0015&\u00059\u0019Vm]:j_:\u001c\u0015\r^1m_\u001eDQa\u000b\u0001\u0005\n1\nQC]3rk&\u0014X\rR1uC\n\f7/Z#ySN$8\u000f\u0006\u0002.gA\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t!QK\\5u\u0011\u0015!$\u00061\u00016\u0003\u0019!'MT1nKB\u0011a'\u000f\b\u0003]]J!\u0001O\u0018\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003q=BQ!\u0010\u0001\u0005\ny\n!C]3rk&\u0014X\rV1cY\u0016,\u00050[:ugR\u0019Qf\u0010!\t\u000bQb\u0004\u0019A\u001b\t\u000b\u0005c\u0004\u0019A\u001b\u0002\u0013Q\f'\r\\3OC6,\u0007\"B\"\u0001\t\u0003\"\u0015aD2veJ,g\u000e\u001e#bi\u0006\u0014\u0017m]3\u0016\u0003UBQA\u0012\u0001\u0005B\u001d\u000b!c]3u\u0007V\u0014(/\u001a8u\t\u0006$\u0018MY1tKR\u0011Q\u0006\u0013\u0005\u0006i\u0015\u0003\r!\u000e\u0015\u0004\u000b*\u0003\u0006c\u0001\u0018L\u001b&\u0011Aj\f\u0002\u0007i\"\u0014xn^:\u0011\u0005]q\u0015BA(\u0005\u0005E\te.\u00197zg&\u001cX\t_2faRLwN\\\u0011\u0002#\u00069B-\u0019;bE\u0006\u001cX\r\t3pKN\u0004cn\u001c;!KbL7\u000f\u001e\u0005\u0006'\u0002!\t\u0005V\u0001\u000eY&\u001cH\u000fR1uC\n\f7/Z:\u0015\u0003U\u00032a\u0006,Y\u0013\t9FAA\u0004ECR\f7/\u001a;\u0011\u0005=I\u0016B\u0001.\u0011\u0005!!\u0015\r^1cCN,\u0007\"\u0002/\u0001\t\u0003j\u0016A\u00037jgR$\u0016M\u00197fgR\ta\fE\u0002\u0018-~\u0003\"a\u00041\n\u0005\u0005\u0004\"!\u0002+bE2,\u0007\"\u0002/\u0001\t\u0003\u001aGC\u00010e\u0011\u0015!$\r1\u00016Q\r\u0011'\n\u0015\u0005\u0006O\u0002!\t\u0005[\u0001\u000eY&\u001cHOR;oGRLwN\\:\u0015\u0003%\u00042a\u0006,k!\ty1.\u0003\u0002m!\tAa)\u001e8di&|g\u000eC\u0003h\u0001\u0011\u0005c\u000e\u0006\u0002j_\")A'\u001ca\u0001k!\u001aQN\u0013)\t\u000bI\u0004A\u0011I:\u0002\u00171L7\u000f^\"pYVlgn\u001d\u000b\u0003ib\u00042a\u0006,v!\tya/\u0003\u0002x!\t11i\u001c7v[:DQ!Q9A\u0002UB3!\u001d&{C\u0005Y\u0018\u0001\u0006;bE2,\u0007\u0005Z8fg\u0002rw\u000e\u001e\u0011fq&\u001cH\u000fC\u0003s\u0001\u0011\u0005S\u0010F\u0002u}~DQ\u0001\u000e?A\u0002UBQ!\u0011?A\u0002UBC\u0001 &\u0002\u0004\u0005\u0012\u0011QA\u0001!I\u0006$\u0018MY1tK\u0002z'\u000f\t;bE2,\u0007\u0005Z8fg\u0002rw\u000e\u001e\u0011fq&\u001cH\u000fC\u0004\u0002\n\u0001!\t%a\u0003\u0002'\r\u0014X-\u0019;f\u000bb$XM\u001d8bYR\u000b'\r\\3\u0015\r\u00055\u0011\u0011GA\u001a!\u0011\ty!a\u000b\u000f\t\u0005E\u0011q\u0005\b\u0005\u0003'\t)C\u0004\u0003\u0002\u0016\u0005\rb\u0002BA\f\u0003CqA!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;a\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0004\u0003S!\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003[\tyCA\u0005ECR\fgI]1nK*\u0019\u0011\u0011\u0006\u0003\t\r\u0005\u000b9\u00011\u00016\u0011\u001d\t)$a\u0002A\u0002U\nA\u0001]1uQ\"\"\u0011qAA\u001d!\u0011\tY$!\u0011\u000e\u0005\u0005u\"bAA \r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0013Q\b\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c\u0005\b\u0003\u0013\u0001A\u0011IA$)!\ti!!\u0013\u0002L\u00055\u0003BB!\u0002F\u0001\u0007Q\u0007C\u0004\u00026\u0005\u0015\u0003\u0019A\u001b\t\u000f\u0005=\u0013Q\ta\u0001k\u000511o\\;sG\u0016DC!!\u0012\u0002:!9\u0011\u0011\u0002\u0001\u0005B\u0005UC\u0003CA\u0007\u0003/\nI&a\u0017\t\r\u0005\u000b\u0019\u00061\u00016\u0011\u001d\ty%a\u0015A\u0002UB\u0001\"!\u0018\u0002T\u0001\u0007\u0011qL\u0001\b_B$\u0018n\u001c8t!\u0019\t\t'a\u001b6k5\u0011\u00111\r\u0006\u0005\u0003K\n9'\u0001\u0003vi&d'BAA5\u0003\u0011Q\u0017M^1\n\t\u00055\u00141\r\u0002\u0004\u001b\u0006\u0004\b\u0006BA*\u0003sAq!!\u0003\u0001\t\u0003\n\u0019\b\u0006\u0005\u0002\u000e\u0005U\u0014qOA=\u0011\u0019\t\u0015\u0011\u000fa\u0001k!9\u0011qJA9\u0001\u0004)\u0004\u0002CA/\u0003c\u0002\r!a\u001f\u0011\u000bY\ni(N\u001b\n\u0007\u000554\b\u000b\u0003\u0002r\u0005e\u0002bBA\u0005\u0001\u0011\u0005\u00131\u0011\u000b\u000b\u0003\u001b\t))a\"\u0002\n\u0006e\u0005BB!\u0002\u0002\u0002\u0007Q\u0007C\u0004\u0002P\u0005\u0005\u0005\u0019A\u001b\t\u0011\u0005-\u0015\u0011\u0011a\u0001\u0003\u001b\u000baa]2iK6\f\u0007\u0003BAH\u0003+k!!!%\u000b\u0007\u0005ME!A\u0003usB,7/\u0003\u0003\u0002\u0018\u0006E%AC*ueV\u001cG\u000fV=qK\"A\u0011QLAA\u0001\u0004\ty\u0006\u000b\u0003\u0002\u0002\u0006e\u0002bBA\u0005\u0001\u0011\u0005\u0013q\u0014\u000b\u000b\u0003\u001b\t\t+a)\u0002&\u0006\u001d\u0006BB!\u0002\u001e\u0002\u0007Q\u0007C\u0004\u0002P\u0005u\u0005\u0019A\u001b\t\u0011\u0005-\u0015Q\u0014a\u0001\u0003\u001bC\u0001\"!\u0018\u0002\u001e\u0002\u0007\u00111\u0010\u0015\u0005\u0003;\u000bI\u0004C\u0004\u0002.\u0002!\t%a,\u0002\u0019\u0011\u0014x\u000e\u001d+f[B4\u0016.Z<\u0015\u00075\n\t\fC\u0004\u00024\u0006-\u0006\u0019A\u001b\u0002\u0011YLWm\u001e(b[\u0016Dq!a.\u0001\t\u0003\nI,\u0001\u0005jg\u000e\u000b7\r[3e)\u0011\tY,!1\u0011\u00079\ni,C\u0002\u0002@>\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004B\u0003k\u0003\r!\u000e\u0005\b\u0003\u000b\u0004A\u0011IAd\u0003)\u0019\u0017m\u00195f)\u0006\u0014G.\u001a\u000b\u0004[\u0005%\u0007BB!\u0002D\u0002\u0007Q\u0007C\u0004\u0002N\u0002!\t%a4\u0002\u0019Ut7-Y2iKR\u000b'\r\\3\u0015\u00075\n\t\u000e\u0003\u0004B\u0003\u0017\u0004\r!\u000e\u0005\b\u0003+\u0004A\u0011IAl\u0003)\u0019G.Z1s\u0007\u0006\u001c\u0007.\u001a\u000b\u0002[!A\u0011q\u0017\u0001\u0005\u0012\u0011\tY\u000e\u0006\u0003\u0002<\u0006u\u0007\u0002CAp\u00033\u0004\r!!9\u0002\u000bEt\u0015-\\31\t\u0005\r\u0018\u0011\u001e\t\u0005/Y\u000b)\u000f\u0005\u0003\u0002h\u0006%H\u0002\u0001\u0003\r\u0003W\fi.!A\u0001\u0002\u000b\u0005\u0011Q\u001e\u0002\u0004?\u0012\n\u0014\u0003BAx\u0003k\u00042ALAy\u0013\r\t\u0019p\f\u0002\b\u001d>$\b.\u001b8h!\rq\u0013q_\u0005\u0004\u0003s|#aA!os\u001eA\u0011Q \u0002\t\u0002\u0011\ty0A\u0006DCR\fGn\\4J[Bd\u0007c\u0001\u0010\u0003\u0002\u00199\u0011A\u0001E\u0001\t\t\r1\u0003\u0002B\u0001\u0005\u000b\u00012A\fB\u0004\u0013\r\u0011Ia\f\u0002\u0007\u0003:L(+\u001a4\t\u000fm\u0011\t\u0001\"\u0001\u0003\u000eQ\u0011\u0011q \u0005\t\u0005#\u0011\t\u0001\"\u0001\u0003\u0014\u0005YQ.Y6f\t\u0006$\u0018m]3u+\u0011\u0011)B!\b\u0015\r\t]!Q\fB7)\u0011\u0011IBa\u000b\u0011\t]1&1\u0004\t\u0005\u0003O\u0014i\u0002\u0002\u0005\u0003 \t=!\u0019\u0001B\u0011\u0005\u0005!\u0016\u0003BAx\u0005G\u0001BA!\n\u0003(5\ta%C\u0002\u0003*\u0019\u0012!\u0004R3gS:,GMQ=D_:\u001cHO];di>\u0014\b+\u0019:b[ND!B!\f\u0003\u0010\u0005\u0005\t9\u0001B\u0018\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0005c\u0011\tFa\u0007\u000f\t\tM\"1\n\b\u0005\u0005k\u00119E\u0004\u0003\u00038\t\u0005c\u0002\u0002B\u001d\u0005{qA!!\u0007\u0003<%\t\u0001'C\u0002\u0003@=\nqA]3gY\u0016\u001cG/\u0003\u0003\u0003D\t\u0015\u0013a\u0002:v]RLW.\u001a\u0006\u0004\u0005\u007fy\u0013\u0002BA\u0015\u0005\u0013RAAa\u0011\u0003F%!!Q\nB(\u0003!)h.\u001b<feN,'\u0002BA\u0015\u0005\u0013JAAa\u0015\u0003V\t9A+\u001f9f)\u0006<\u0017\u0002\u0002B,\u00053\u0012\u0001\u0002V=qKR\u000bwm\u001d\u0006\u0005\u00057\u0012)%A\u0002ba&D\u0001Ba\u0018\u0003\u0010\u0001\u0007!\u0011M\u0001\u0005I\u0006$\u0018\r\u0005\u0004\u0003d\t\u001d$1\u0004\b\u0005\u0005s\u0011)'C\u0002\u0002*=JAA!\u001b\u0003l\t\u00191+Z9\u000b\u0007\u0005%r\u0006\u0003\u0004\u0016\u0005\u001f\u0001\rA\u0006")
public class CatalogImpl
extends Catalog {
    private final SparkSession sparkSession;

    public static <T extends DefinedByConstructorParams> Dataset<T> makeDataset(Seq<T> seq, SparkSession sparkSession, TypeTags.TypeTag<T> typeTag) {
        return CatalogImpl$.MODULE$.makeDataset(seq, sparkSession, typeTag);
    }

    public SessionCatalog org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog() {
        return this.sparkSession.sessionState().catalog();
    }

    private void requireDatabaseExists(String dbName) {
        if (this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().databaseExists(dbName)) {
            return;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Database '", "' does not exist."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
    }

    private void requireTableExists(String dbName, String tableName) {
        if (this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().tableExists(new TableIdentifier(tableName, (Option)new Some((Object)dbName)))) {
            return;
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Table '", "' does not exist in database '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableName, dbName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4());
    }

    @Override
    public String currentDatabase() {
        return this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().getCurrentDatabase();
    }

    @Override
    public void setCurrentDatabase(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().setCurrentDatabase(dbName);
    }

    @Override
    public Dataset<Database> listDatabases() {
        Seq databases = (Seq)this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().listDatabases().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogImpl $outer;

            public final Database apply(String dbName) {
                CatalogDatabase metadata = this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().getDatabaseMetadata(dbName);
                return new Database(metadata.name(), metadata.description(), metadata.locationUri());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Database").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(databases, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1(this)));
    }

    @Override
    public Dataset<Table> listTables() {
        return this.listTables(this.currentDatabase());
    }

    @Override
    public Dataset<Table> listTables(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        Seq tables = (Seq)this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().listTables(dbName).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogImpl $outer;

            public final Table apply(TableIdentifier tableIdent) {
                boolean isTemp = tableIdent.database().isEmpty();
                None$ metadata = isTemp ? None$.MODULE$ : new Some((Object)this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().getTableMetadata(tableIdent));
                return new Table(tableIdent.identifier(), (String)metadata.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<String> apply(CatalogTable x$1) {
                        return x$1.identifier().database();
                    }
                }).orNull(Predef$.MODULE$.$conforms()), (String)metadata.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Option<String> apply(CatalogTable x$2) {
                        return x$2.comment();
                    }
                }).orNull(Predef$.MODULE$.$conforms()), (String)metadata.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(CatalogTable x$3) {
                        return x$3.tableType().name();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "TEMPORARY";
                    }
                }), isTemp);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Table").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator2$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(tables, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator2$1(this)));
    }

    @Override
    public Dataset<Function> listFunctions() {
        return this.listFunctions(this.currentDatabase());
    }

    @Override
    public Dataset<Function> listFunctions(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        Seq functions2 = (Seq)this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().listFunctions(dbName).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CatalogImpl $outer;

            public final Function apply(FunctionIdentifier funcIdent) {
                ExpressionInfo metadata = this.$outer.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().lookupFunctionInfo(funcIdent);
                return new Function(funcIdent.identifier(), null, metadata.getClassName(), funcIdent.database().isEmpty());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Function").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator3$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(functions2, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator3$1(this)));
    }

    @Override
    public Dataset<Column> listColumns(String tableName) throws AnalysisException {
        return this.listColumns(this.currentDatabase(), tableName);
    }

    @Override
    public Dataset<Column> listColumns(String dbName, String tableName) throws AnalysisException {
        this.requireTableExists(dbName, tableName);
        CatalogTable tableMetadata = this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().getTableMetadata(new TableIdentifier(tableName, (Option)new Some((Object)dbName)));
        Set partitionColumnNames = tableMetadata.partitionColumnNames().toSet();
        Set bucketColumnNames = tableMetadata.bucketColumnNames().toSet();
        Seq columns2 = (Seq)tableMetadata.schema().map((Function1)new Serializable(this, partitionColumnNames, bucketColumnNames){
            public static final long serialVersionUID = 0L;
            private final Set partitionColumnNames$1;
            private final Set bucketColumnNames$1;

            public final Column apply(CatalogColumn c) {
                return new Column(c.name(), (String)c.comment().orNull(Predef$.MODULE$.$conforms()), c.dataType(), c.nullable(), this.partitionColumnNames$1.contains((Object)c.name()), this.bucketColumnNames$1.contains((Object)c.name()));
            }
            {
                this.partitionColumnNames$1 = partitionColumnNames$1;
                this.bucketColumnNames$1 = bucketColumnNames$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Column").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator4$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(columns2, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator4$1(this)));
    }

    @Override
    @Experimental
    public Dataset<Row> createExternalTable(String tableName, String path) {
        String dataSourceName = this.sparkSession.sessionState().conf().defaultDataSourceName();
        return this.createExternalTable(tableName, path, dataSourceName);
    }

    @Override
    @Experimental
    public Dataset<Row> createExternalTable(String tableName, String path, String source) {
        return this.createExternalTable(tableName, source, (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)}))));
    }

    @Override
    @Experimental
    public Dataset<Row> createExternalTable(String tableName, String source, Map<String, String> options) {
        return this.createExternalTable(tableName, source, (scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()).toMap(Predef$.MODULE$.$conforms()));
    }

    @Override
    @Experimental
    public Dataset<Row> createExternalTable(String tableName, String source, scala.collection.immutable.Map<String, String> options) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        CreateTableUsing cmd = new CreateTableUsing(tableIdent, (Option<StructType>)None$.MODULE$, source, false, options, (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), (Option<BucketSpec>)None$.MODULE$, false, false);
        this.sparkSession.executePlan(cmd).toRdd();
        return this.sparkSession.table(tableIdent);
    }

    @Override
    @Experimental
    public Dataset<Row> createExternalTable(String tableName, String source, StructType schema, Map<String, String> options) {
        return this.createExternalTable(tableName, source, schema, (scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()).toMap(Predef$.MODULE$.$conforms()));
    }

    @Override
    @Experimental
    public Dataset<Row> createExternalTable(String tableName, String source, StructType schema, scala.collection.immutable.Map<String, String> options) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        CreateTableUsing cmd = new CreateTableUsing(tableIdent, (Option<StructType>)new Some((Object)schema), source, false, options, (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), (Option<BucketSpec>)None$.MODULE$, false, false);
        this.sparkSession.executePlan(cmd).toRdd();
        return this.sparkSession.table(tableIdent);
    }

    @Override
    public void dropTempView(String viewName) {
        CacheManager qual$1 = this.sparkSession.cacheManager();
        Dataset<Row> x$4 = this.sparkSession.table(viewName);
        boolean x$5 = qual$1.tryUncacheQuery$default$2();
        qual$1.tryUncacheQuery(x$4, x$5);
        this.org$apache$spark$sql$internal$CatalogImpl$$sessionCatalog().dropTable(TableIdentifier$.MODULE$.apply(viewName), true);
    }

    @Override
    public boolean isCached(String tableName) {
        return this.sparkSession.cacheManager().lookupCachedData(this.sparkSession.table(tableName)).nonEmpty();
    }

    @Override
    public void cacheTable(String tableName) {
        CacheManager qual$2 = this.sparkSession.cacheManager();
        Dataset<Row> x$6 = this.sparkSession.table(tableName);
        Some x$7 = new Some((Object)tableName);
        StorageLevel x$8 = qual$2.cacheQuery$default$3();
        qual$2.cacheQuery(x$6, (Option<String>)x$7, x$8);
    }

    @Override
    public void uncacheTable(String tableName) {
        CacheManager qual$3 = this.sparkSession.cacheManager();
        Dataset<Row> x$9 = this.sparkSession.table(tableName);
        boolean x$10 = qual$3.uncacheQuery$default$2();
        qual$3.uncacheQuery(x$9, x$10);
    }

    @Override
    public void clearCache() {
        this.sparkSession.cacheManager().clearCache();
    }

    public boolean isCached(Dataset<?> qName) {
        return this.sparkSession.cacheManager().lookupCachedData(qName).nonEmpty();
    }

    public CatalogImpl(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
    }
}

