/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$class;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.CatalystReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.CatalystReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.CatalystSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.CatalystWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.CatalystWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.DefaultSource$;
import org.apache.spark.sql.execution.datasources.parquet.DefaultSource$FileTypes$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriterFactory;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRelation$;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tme!B\u0001\u0003\u0001!\u0001\"!\u0004#fM\u0006,H\u000e^*pkJ\u001cWM\u0003\u0002\u0004\t\u00059\u0001/\u0019:rk\u0016$(BA\u0003\u0007\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005\u001dA\u0011!C3yK\u000e,H/[8o\u0015\tI!\"A\u0002tc2T!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\n\u0007\u0001E92$I\u0014\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g!\tA\u0012$D\u0001\u0005\u0013\tQBA\u0001\u0006GS2,gi\u001c:nCR\u0004\"\u0001H\u0010\u000e\u0003uQ!A\b\u0005\u0002\u000fM|WO]2fg&\u0011\u0001%\b\u0002\u0013\t\u0006$\u0018mU8ve\u000e,'+Z4jgR,'\u000f\u0005\u0002#K5\t1E\u0003\u0002%\u0015\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002'G\t9Aj\\4hS:<\u0007C\u0001\n)\u0013\tI3C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003,\u0001\u0011\u0005Q&\u0001\u0004=S:LGOP\u0002\u0001)\u0005q\u0003CA\u0018\u0001\u001b\u0005\u0011\u0001\"B\u0019\u0001\t\u0003\u0012\u0014!C:i_J$h*Y7f)\u0005\u0019\u0004C\u0001\u001b8\u001d\t\u0011R'\u0003\u00027'\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\rM#(/\u001b8h\u0015\t14\u0003C\u0003<\u0001\u0011\u0005#'\u0001\u0005u_N#(/\u001b8h\u0011\u0015i\u0004\u0001\"\u0011?\u0003!A\u0017m\u001d5D_\u0012,G#A \u0011\u0005I\u0001\u0015BA!\u0014\u0005\rIe\u000e\u001e\u0005\u0006\u0007\u0002!\t\u0005R\u0001\u0007KF,\u0018\r\\:\u0015\u0005\u0015C\u0005C\u0001\nG\u0013\t95CA\u0004C_>dW-\u00198\t\u000b%\u0013\u0005\u0019\u0001&\u0002\u000b=$\b.\u001a:\u0011\u0005IY\u0015B\u0001'\u0014\u0005\r\te.\u001f\u0005\u0006\u001d\u0002!\teT\u0001\raJ,\u0007/\u0019:f/JLG/\u001a\u000b\u0006!NK6\r\u001b\t\u00031EK!A\u0015\u0003\u0003'=+H\u000f];u/JLG/\u001a:GC\u000e$xN]=\t\u000bQk\u0005\u0019A+\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005Y;V\"\u0001\u0005\n\u0005aC!\u0001D*qCJ\\7+Z:tS>t\u0007\"\u0002.N\u0001\u0004Y\u0016a\u00016pEB\u0011A,Y\u0007\u0002;*\u0011alX\u0001\n[\u0006\u0004(/\u001a3vG\u0016T!\u0001\u0019\u0007\u0002\r!\fGm\\8q\u0013\t\u0011WLA\u0002K_\nDQ\u0001Z'A\u0002\u0015\fqa\u001c9uS>t7\u000f\u0005\u00035MN\u001a\u0014BA4:\u0005\ri\u0015\r\u001d\u0005\u0006S6\u0003\rA[\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007CA6o\u001b\u0005a'BA7\t\u0003\u0015!\u0018\u0010]3t\u0013\tyGN\u0001\u0006TiJ,8\r\u001e+za\u0016DQ!\u001d\u0001\u0005\u0002I\f1\"\u001b8gKJ\u001c6\r[3nCR!1O^<z!\r\u0011BO[\u0005\u0003kN\u0011aa\u00149uS>t\u0007\"\u0002+q\u0001\u0004)\u0006\"\u0002=q\u0001\u0004)\u0017A\u00039be\u0006lW\r^3sg\")!\u0010\u001da\u0001w\u0006)a-\u001b7fgB)A0!\u0003\u0002\u00109\u0019Q0!\u0002\u000f\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\t\u0001L\u0001\u0007yI|w\u000e\u001e \n\u0003QI1!a\u0002\u0014\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0003\u0002\u000e\t\u00191+Z9\u000b\u0007\u0005\u001d1\u0003\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)bX\u0001\u0003MNLA!!\u0007\u0002\u0014\tQa)\u001b7f'R\fG/^:\u0007\r\u0005u\u0001\u0001QA\u0010\u0005%1\u0015\u000e\\3UsB,7o\u0005\u0004\u0002\u001cE\t\tc\n\t\u0004%\u0005\r\u0012bAA\u0013'\t9\u0001K]8ek\u000e$\bbCA\u0015\u00037\u0011)\u001a!C\u0001\u0003W\tA\u0001Z1uCV\t1\u0010\u0003\u0006\u00020\u0005m!\u0011#Q\u0001\nm\fQ\u0001Z1uC\u0002B1\"a\r\u0002\u001c\tU\r\u0011\"\u0001\u0002,\u0005AQ.\u001a;bI\u0006$\u0018\r\u0003\u0006\u00028\u0005m!\u0011#Q\u0001\nm\f\u0011\"\\3uC\u0012\fG/\u0019\u0011\t\u0017\u0005m\u00121\u0004BK\u0002\u0013\u0005\u00111F\u0001\u000fG>lWn\u001c8NKR\fG-\u0019;b\u0011)\ty$a\u0007\u0003\u0012\u0003\u0006Ia_\u0001\u0010G>lWn\u001c8NKR\fG-\u0019;bA!91&a\u0007\u0005\u0002\u0005\rC\u0003CA#\u0003\u0013\nY%!\u0014\u0011\t\u0005\u001d\u00131D\u0007\u0002\u0001!9\u0011\u0011FA!\u0001\u0004Y\bbBA\u001a\u0003\u0003\u0002\ra\u001f\u0005\b\u0003w\t\t\u00051\u0001|\u0011)\t\t&a\u0007\u0002\u0002\u0013\u0005\u00111K\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0002F\u0005U\u0013qKA-\u0011%\tI#a\u0014\u0011\u0002\u0003\u00071\u0010C\u0005\u00024\u0005=\u0003\u0013!a\u0001w\"I\u00111HA(!\u0003\u0005\ra\u001f\u0005\u000b\u0003;\nY\"%A\u0005\u0002\u0005}\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003CR3a_A2W\t\t)\u0007\u0005\u0003\u0002h\u0005ETBAA5\u0015\u0011\tY'!\u001c\u0002\u0013Ut7\r[3dW\u0016$'bAA8'\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0014\u0011\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007BCA<\u00037\t\n\u0011\"\u0001\u0002`\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004BCA>\u00037\t\n\u0011\"\u0001\u0002`\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0004BCA@\u00037\t\t\u0011\"\u0011\u0002\u0002\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a!\u0011\t\u0005\u0015\u0015qR\u0007\u0003\u0003\u000fSA!!#\u0002\f\u0006!A.\u00198h\u0015\t\ti)\u0001\u0003kCZ\f\u0017b\u0001\u001d\u0002\b\"Q\u00111SA\u000e\u0003\u0003%\t!!&\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003}B!\"!'\u0002\u001c\u0005\u0005I\u0011AAN\u00039\u0001(o\u001c3vGR,E.Z7f]R$2ASAO\u0011%\ty*a&\u0002\u0002\u0003\u0007q(A\u0002yIEB!\"a)\u0002\u001c\u0005\u0005I\u0011IAS\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAT!\u0015\tI+a,K\u001b\t\tYKC\u0002\u0002.N\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t,a+\u0003\u0011%#XM]1u_JD!\"!.\u0002\u001c\u0005\u0005I\u0011AA\\\u0003!\u0019\u0017M\\#rk\u0006dGcA#\u0002:\"I\u0011qTAZ\u0003\u0003\u0005\rA\u0013\u0005\t{\u0005m\u0011\u0011!C!}!I1(a\u0007\u0002\u0002\u0013\u0005\u0013q\u0018\u000b\u0003\u0003\u0007C\u0011bQA\u000e\u0003\u0003%\t%a1\u0015\u0007\u0015\u000b)\rC\u0005\u0002 \u0006\u0005\u0017\u0011!a\u0001\u0015\u001eI\u0011\u0011\u001a\u0001\u0002\u0002#\u0005\u00111Z\u0001\n\r&dW\rV=qKN\u0004B!a\u0012\u0002N\u001aI\u0011Q\u0004\u0001\u0002\u0002#\u0005\u0011qZ\n\u0006\u0003\u001b\f\tn\n\t\n\u0003'\fIn_>|\u0003\u000bj!!!6\u000b\u0007\u0005]7#A\u0004sk:$\u0018.\\3\n\t\u0005m\u0017Q\u001b\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004bB\u0016\u0002N\u0012\u0005\u0011q\u001c\u000b\u0003\u0003\u0017D\u0011bOAg\u0003\u0003%)%a0\t\u0015\u0005\u0015\u0018QZA\u0001\n\u0003\u000b9/A\u0003baBd\u0017\u0010\u0006\u0005\u0002F\u0005%\u00181^Aw\u0011\u001d\tI#a9A\u0002mDq!a\r\u0002d\u0002\u00071\u0010C\u0004\u0002<\u0005\r\b\u0019A>\t\u0015\u0005E\u0018QZA\u0001\n\u0003\u000b\u00190A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005U\u0018Q \t\u0005%Q\f9\u0010\u0005\u0004\u0013\u0003s\\8p_\u0005\u0004\u0003w\u001c\"A\u0002+va2,7\u0007\u0003\u0006\u0002\u0000\u0006=\u0018\u0011!a\u0001\u0003\u000b\n1\u0001\u001f\u00131\u0011\u001d\u0011\u0019\u0001\u0001C\u0005\u0005\u000b\t!b\u001d9mSR4\u0015\u000e\\3t)\u0011\t)Ea\u0002\t\u000f\t%!\u0011\u0001a\u0001w\u0006A\u0011\r\u001c7GS2,7\u000fC\u0004\u0003\u000e\u0001!IAa\u0004\u0002\u001b%\u001c8+^7nCJLh)\u001b7f)\r)%\u0011\u0003\u0005\t\u0005'\u0011Y\u00011\u0001\u0003\u0016\u0005!a-\u001b7f!\u0011\t\tBa\u0006\n\t\te\u00111\u0003\u0002\u0005!\u0006$\b\u000eC\u0004\u0003\u001e\u0001!\tEa\b\u0002\u0019M,\b\u000f]8si\n\u000bGo\u00195\u0015\u000b\u0015\u0013\tCa\t\t\rQ\u0013Y\u00021\u0001V\u0011\u001d\u0011)Ca\u0007A\u0002)\faa]2iK6\f\u0007\u0002\u0003B\u0015\u0001\u0011\u0005\u0003Ba\u000b\u0002=\t,\u0018\u000e\u001c3SK\u0006$WM],ji\"\u0004\u0016M\u001d;ji&|gNV1mk\u0016\u001cH\u0003\u0005B\u0017\u0005\u0013\u0012YE!\u0014\u0003R\tU#\u0011\rB2!\u001d\u0011\"q\u0006B\u001a\u0005sI1A!\r\u0014\u0005%1UO\\2uS>t\u0017\u0007E\u0002\u0019\u0005kI1Aa\u000e\u0005\u0005=\u0001\u0016M\u001d;ji&|g.\u001a3GS2,\u0007#\u0002?\u0003<\tu\u0012\u0002BAY\u0003\u001b\u0001BAa\u0010\u0003F5\u0011!\u0011\t\u0006\u0004\u0005\u0007B\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\t\t\u001d#\u0011\t\u0002\f\u0013:$XM\u001d8bYJ{w\u000f\u0003\u0004U\u0005O\u0001\r!\u0016\u0005\u0007S\n\u001d\u0002\u0019\u00016\t\u000f\t=#q\u0005a\u0001U\u0006y\u0001/\u0019:uSRLwN\\*dQ\u0016l\u0017\rC\u0004\u0003T\t\u001d\u0002\u0019\u00016\u0002\u001dI,\u0017/^5sK\u0012\u001c6\r[3nC\"A!q\u000bB\u0014\u0001\u0004\u0011I&A\u0004gS2$XM]:\u0011\u000bq\fIAa\u0017\u0011\u0007q\u0011i&C\u0002\u0003`u\u0011aAR5mi\u0016\u0014\bB\u00023\u0003(\u0001\u0007Q\r\u0003\u0005\u0003f\t\u001d\u0002\u0019\u0001B4\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0005\u0005S\u0012y'\u0004\u0002\u0003l)\u0019!QN0\u0002\t\r|gNZ\u0005\u0005\u0005c\u0012YGA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\b\u0005k\u0002A\u0011\tB<\u0003-\u0011W/\u001b7e%\u0016\fG-\u001a:\u0015!\t5\"\u0011\u0010B>\u0005{\u0012yH!!\u0003\u0004\n\u0015\u0005B\u0002+\u0003t\u0001\u0007Q\u000b\u0003\u0004j\u0005g\u0002\rA\u001b\u0005\b\u0005\u001f\u0012\u0019\b1\u0001k\u0011\u001d\u0011\u0019Fa\u001dA\u0002)D\u0001Ba\u0016\u0003t\u0001\u0007!\u0011\f\u0005\u0007I\nM\u0004\u0019A3\t\u0011\t\u0015$1\u000fa\u0001\u0005OBqA!#\u0001\t\u0003\u0012Y)A\u0006ck&dGm\u0016:ji\u0016\u0014Hc\u0002)\u0003\u000e\n]%\u0011\u0014\u0005\t\u0005\u001f\u00139\t1\u0001\u0003\u0012\u0006Q1/\u001d7D_:$X\r\u001f;\u0011\u0007Y\u0013\u0019*C\u0002\u0003\u0016\"\u0011!bU)M\u0007>tG/\u001a=u\u0011\u0019I'q\u0011a\u0001U\"1AMa\"A\u0002\u0015\u0004")
public class DefaultSource
implements FileFormat,
DataSourceRegister,
Logging,
Serializable {
    private volatile DefaultSource$FileTypes$ FileTypes$module;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DefaultSource$FileTypes$ FileTypes$lzycompute() {
        DefaultSource defaultSource = this;
        synchronized (defaultSource) {
            if (this.FileTypes$module != null) return this.FileTypes$module;
            this.FileTypes$module = new DefaultSource$FileTypes$(this);
            return this.FileTypes$module;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public Map<String, String> prepareRead(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return FileFormat$class.prepareRead(this, sparkSession, options, files);
    }

    @Override
    public String shortName() {
        return "parquet";
    }

    public String toString() {
        return "ParquetFormat";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof DefaultSource;
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, ParquetOutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using default output committer for Parquet: ").append((Object)ParquetOutputCommitter.class.getCanonicalName()).toString();
                }
            });
        } else {
            this.logInfo((Function0<String>)new Serializable(this, committerClass){
                public static final long serialVersionUID = 0L;
                private final Class committerClass$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Using user defined output committer for Parquet: ").append((Object)this.committerClass$1.getCanonicalName()).toString();
                }
                {
                    this.committerClass$1 = committerClass$1;
                }
            });
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, ParquetOutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, CatalystWriteSupport.class);
        StructType dataSchemaToWrite = (StructType)StructType$.MODULE$.removeMetadata(StructType$.MODULE$.metadataKeyForOptionalField(), (DataType)dataSchema);
        CatalystWriteSupport$.MODULE$.setSchema(dataSchemaToWrite, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)sparkSession.sessionState().conf().isParquetBinaryAsString())).toString());
        conf.set(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)sparkSession.sessionState().conf().isParquetINT96AsTimestamp())).toString());
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), ((Object)BoxesRunTime.boxToBoolean((boolean)sparkSession.sessionState().conf().writeLegacyParquetFormat())).toString());
        conf.set("parquet.compression", parquetOptions.compressionCodec());
        return new OutputWriterFactory(this){

            public OutputWriter newInstance(String path, Option<Object> bucketId, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, bucketId, context);
            }
        };
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> parameters, Seq<FileStatus> files) {
        Seq seq;
        boolean shouldMergeSchemas = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)ParquetRelation$.MODULE$.MERGE_SCHEMA()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
            }
        }).getOrElse((Function0)new Serializable(this, sparkSession){
            public static final long serialVersionUID = 0L;
            private final SparkSession sparkSession$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.sparkSession$1.conf().get(SQLConf$.MODULE$.PARQUET_SCHEMA_MERGING_ENABLED()));
            }
            {
                this.sparkSession$1 = sparkSession$1;
            }
        }));
        boolean mergeRespectSummaries = BoxesRunTime.unboxToBoolean((Object)sparkSession.conf().get(SQLConf$.MODULE$.PARQUET_SCHEMA_RESPECT_SUMMARIES()));
        FileTypes filesByType = this.splitFiles(files);
        if (shouldMergeSchemas) {
            Seq needMerged = mergeRespectSummaries ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : filesByType.data();
            seq = (Seq)((TraversableLike)needMerged.$plus$plus(filesByType.metadata(), Seq$.MODULE$.canBuildFrom())).$plus$plus(filesByType.commonMetadata(), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = Option$.MODULE$.option2Iterable(filesByType.commonMetadata().headOption().orElse((Function0)new Serializable(this, filesByType){
                public static final long serialVersionUID = 0L;
                private final FileTypes filesByType$1;

                public final Option<FileStatus> apply() {
                    return this.filesByType$1.metadata().headOption();
                }
                {
                    this.filesByType$1 = filesByType$1;
                }
            }).orElse((Function0)new Serializable(this, filesByType){
                public static final long serialVersionUID = 0L;
                private final FileTypes filesByType$1;

                public final Option<FileStatus> apply() {
                    return this.filesByType$1.data().headOption();
                }
                {
                    this.filesByType$1 = filesByType$1;
                }
            })).toSeq();
        }
        Seq filesToTouch = seq;
        return ParquetRelation$.MODULE$.mergeSchemasInParallel((Seq<FileStatus>)filesToTouch, sparkSession);
    }

    public DefaultSource$FileTypes$ FileTypes() {
        return this.FileTypes$module == null ? this.FileTypes$lzycompute() : this.FileTypes$module;
    }

    private FileTypes splitFiles(Seq<FileStatus> allFiles2) {
        FileStatus[] leaves = (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)allFiles2.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultSource $outer;

            public final boolean apply(FileStatus f) {
                return this.$outer.org$apache$spark$sql$execution$datasources$parquet$DefaultSource$$isSummaryFile(f.getPath()) || !f.getPath().getName().startsWith("_") && !f.getPath().getName().startsWith(".");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).toArray(ClassTag$.MODULE$.apply(FileStatus.class))).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$2) {
                return x$2.getPath().toString();
            }
        }, (Ordering)Ordering.String$.MODULE$);
        return new FileTypes(this, (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])leaves).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultSource $outer;

            public final boolean apply(FileStatus f) {
                return this.$outer.org$apache$spark$sql$execution$datasources$parquet$DefaultSource$$isSummaryFile(f.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])leaves).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$3) {
                String string = x$3.getPath().getName();
                String string2 = "_metadata";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        })), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])leaves).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$4) {
                String string = x$4.getPath().getName();
                String string2 = "_common_metadata";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
        })));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean org$apache$spark$sql$execution$datasources$parquet$DefaultSource$$isSummaryFile(Path file) {
        String string = file.getName();
        String string2 = "_common_metadata";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = file.getName();
        String string4 = "_metadata";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        SQLConf conf = sparkSession.sessionState().conf();
        return conf.parquetVectorizedReaderEnabled() && conf.wholeStageEnabled() && schema.length() <= conf.wholeStageMaxNumFields() && schema.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$5) {
                return x$5.dataType() instanceof AtomicType;
            }
        });
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return this.buildReader(sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", CatalystReadSupport.class.getName());
        hadoopConf.set(CatalystReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), CatalystSchemaConverter$.MODULE$.checkFieldNames(requiredSchema).json());
        hadoopConf.set(CatalystWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), CatalystSchemaConverter$.MODULE$.checkFieldNames(requiredSchema).json());
        StructType dataSchemaToWrite = (StructType)StructType$.MODULE$.removeMetadata(StructType$.MODULE$.metadataKeyForOptionalField(), (DataType)requiredSchema);
        CatalystWriteSupport$.MODULE$.setSchema(dataSchemaToWrite, hadoopConf);
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), BoxesRunTime.unboxToBoolean((Object)sparkSession.conf().get(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING())));
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), BoxesRunTime.unboxToBoolean((Object)sparkSession.conf().get(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP())));
        None$ pushed = new StringOps(Predef$.MODULE$.augmentString(sparkSession.conf().get(SQLConf$.MODULE$.PARQUET_FILTER_PUSHDOWN_ENABLED().key()))).toBoolean() ? ((TraversableOnce)filters.flatMap((Function1)new Serializable(this, requiredSchema){
            public static final long serialVersionUID = 0L;
            private final StructType requiredSchema$1;

            public final Iterable<FilterPredicate> apply(Filter x$6) {
                return Option$.MODULE$.option2Iterable(ParquetFilters$.MODULE$.createFilter(this.requiredSchema$1, x$6));
            }
            {
                this.requiredSchema$1 = requiredSchema$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).reduceOption((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FilterPredicate apply(FilterPredicate x$1, FilterPredicate x$2) {
                return FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2);
            }
        }) : None$.MODULE$;
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        boolean enableVectorizedReader = sparkSession.sessionState().conf().parquetVectorizedReaderEnabled() && resultSchema.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x$7) {
                return x$7.dataType() instanceof AtomicType;
            }
        });
        boolean returningBatch = this.supportBatch(sparkSession, resultSchema);
        return new Serializable(this, partitionSchema, requiredSchema, (Option)pushed, broadcastedHadoopConf, enableVectorizedReader, returningBatch){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DefaultSource $outer;
            public final StructType partitionSchema$1;
            private final StructType requiredSchema$1;
            private final Option pushed$1;
            private final Broadcast broadcastedHadoopConf$1;
            private final boolean enableVectorizedReader$1;
            private final boolean returningBatch$1;

            public final Iterator<InternalRow> apply(PartitionedFile file) {
                RecordReaderIterator<Object> recordReaderIterator;
                VectorizedParquetRecordReader vectorizedParquetRecordReader;
                Predef$.MODULE$.assert(file.partitionValues().numFields() == this.partitionSchema$1.size());
                FileSplit fileSplit = new FileSplit(new Path(new URI(file.filePath())), file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                ParquetInputSplit split = new ParquetInputSplit(fileSplit.getPath(), fileSplit.getStart(), fileSplit.getStart() + fileSplit.getLength(), fileSplit.getLength(), fileSplit.getLocations(), null);
                TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
                TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value(), attemptId);
                if (this.enableVectorizedReader$1) {
                    VectorizedParquetRecordReader vectorizedReader = new VectorizedParquetRecordReader();
                    vectorizedReader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                    this.$outer.logDebug((Function0<String>)new Serializable(this, file){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$buildReader$1 $outer;
                        private final PartitionedFile file$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Appending ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.partitionSchema$1, this.file$1.partitionValues()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.file$1 = file$1;
                        }
                    });
                    vectorizedReader.initBatch(this.partitionSchema$1, file.partitionValues());
                    if (this.returningBatch$1) {
                        vectorizedReader.enableReturningBatches();
                    }
                    vectorizedParquetRecordReader = vectorizedReader;
                } else {
                    ParquetRecordReader parquetRecordReader;
                    this.$outer.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Falling back to parquet-mr"})).s((Seq)Nil$.MODULE$);
                        }
                    });
                    Option option = this.pushed$1;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        FilterPredicate filter2 = (FilterPredicate)some.x();
                        parquetRecordReader = new ParquetRecordReader((ReadSupport)new CatalystReadSupport(), FilterCompat.get((FilterPredicate)filter2, null));
                    } else {
                        parquetRecordReader = new ParquetRecordReader((ReadSupport)new CatalystReadSupport());
                    }
                    ParquetRecordReader reader = parquetRecordReader;
                    reader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                    vectorizedParquetRecordReader = reader;
                }
                VectorizedParquetRecordReader parquetReader = vectorizedParquetRecordReader;
                RecordReaderIterator<Object> iter = new RecordReaderIterator<Object>(parquetReader);
                if (parquetReader instanceof VectorizedParquetRecordReader && this.enableVectorizedReader$1) {
                    recordReaderIterator = iter;
                } else {
                    Seq fullSchema = (Seq)this.requiredSchema$1.toAttributes().$plus$plus((GenTraversableOnce)this.partitionSchema$1.toAttributes(), Seq$.MODULE$.canBuildFrom());
                    JoinedRow joinedRow = new JoinedRow();
                    UnsafeProjection appendPartitionColumns = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                    recordReaderIterator = iter.map(new Serializable(this, joinedRow, appendPartitionColumns, file){
                        public static final long serialVersionUID = 0L;
                        private final JoinedRow joinedRow$1;
                        private final UnsafeProjection appendPartitionColumns$1;
                        private final PartitionedFile file$1;

                        public final UnsafeRow apply(InternalRow d) {
                            return this.appendPartitionColumns$1.apply((InternalRow)this.joinedRow$1.apply(d, this.file$1.partitionValues()));
                        }
                        {
                            this.joinedRow$1 = joinedRow$1;
                            this.appendPartitionColumns$1 = appendPartitionColumns$1;
                            this.file$1 = file$1;
                        }
                    });
                }
                return recordReaderIterator;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionSchema$1 = partitionSchema$1;
                this.requiredSchema$1 = requiredSchema$1;
                this.pushed$1 = pushed$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
                this.enableVectorizedReader$1 = enableVectorizedReader$1;
                this.returningBatch$1 = returningBatch$1;
            }
        };
    }

    @Override
    public OutputWriterFactory buildWriter(SQLContext sqlContext, StructType dataSchema, Map<String, String> options) {
        return new ParquetOutputWriterFactory(sqlContext.conf(), dataSchema, sqlContext.sparkContext().hadoopConfiguration(), options);
    }

    public DefaultSource() {
        FileFormat$class.$init$(this);
        Logging.class.$init$((Logging)this);
    }

    public class FileTypes
    implements Product,
    Serializable {
        private final Seq<FileStatus> data;
        private final Seq<FileStatus> metadata;
        private final Seq<FileStatus> commonMetadata;
        public final /* synthetic */ DefaultSource $outer;

        public Seq<FileStatus> data() {
            return this.data;
        }

        public Seq<FileStatus> metadata() {
            return this.metadata;
        }

        public Seq<FileStatus> commonMetadata() {
            return this.commonMetadata;
        }

        public FileTypes copy(Seq<FileStatus> data, Seq<FileStatus> metadata, Seq<FileStatus> commonMetadata) {
            return new FileTypes(this.org$apache$spark$sql$execution$datasources$parquet$DefaultSource$FileTypes$$$outer(), data, metadata, commonMetadata);
        }

        public Seq<FileStatus> copy$default$1() {
            return this.data();
        }

        public Seq<FileStatus> copy$default$2() {
            return this.metadata();
        }

        public Seq<FileStatus> copy$default$3() {
            return this.commonMetadata();
        }

        public String productPrefix() {
            return "FileTypes";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Seq<FileStatus> seq;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    seq = this.commonMetadata();
                    break;
                }
                case 1: {
                    seq = this.metadata();
                    break;
                }
                case 0: {
                    seq = this.data();
                }
            }
            return seq;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FileTypes;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FileTypes)) return false;
            if (((FileTypes)object).org$apache$spark$sql$execution$datasources$parquet$DefaultSource$FileTypes$$$outer() != this.org$apache$spark$sql$execution$datasources$parquet$DefaultSource$FileTypes$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            FileTypes fileTypes = (FileTypes)x$1;
            Seq<FileStatus> seq = this.data();
            Seq<FileStatus> seq2 = fileTypes.data();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<FileStatus> seq3 = this.metadata();
            Seq<FileStatus> seq4 = fileTypes.metadata();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            Seq<FileStatus> seq5 = this.commonMetadata();
            Seq<FileStatus> seq6 = fileTypes.commonMetadata();
            if (seq5 == null) {
                if (seq6 != null) {
                    return false;
                }
            } else if (!seq5.equals(seq6)) return false;
            if (!fileTypes.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ DefaultSource org$apache$spark$sql$execution$datasources$parquet$DefaultSource$FileTypes$$$outer() {
            return this.$outer;
        }

        public FileTypes(DefaultSource $outer, Seq<FileStatus> data, Seq<FileStatus> metadata, Seq<FileStatus> commonMetadata) {
            this.data = data;
            this.metadata = metadata;
            this.commonMetadata = commonMetadata;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

