/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.CompressionCodecs$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormat$class;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.csv.BulkCsvReader;
import org.apache.spark.sql.execution.datasources.csv.CSVInferSchema$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVOutputWriterFactory;
import org.apache.spark.sql.execution.datasources.csv.CSVRelation$;
import org.apache.spark.sql.execution.datasources.csv.DefaultSource$;
import org.apache.spark.sql.execution.datasources.csv.LineCsvReader;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0001\u0003\u0001E\u0011Q\u0002R3gCVdGoU8ve\u000e,'BA\u0002\u0005\u0003\r\u00197O\u001e\u0006\u0003\u000b\u0019\t1\u0002Z1uCN|WO]2fg*\u0011q\u0001C\u0001\nKb,7-\u001e;j_:T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\n\u00199A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\u0004\"!\u0007\u000e\u000e\u0003\u0011I!a\u0007\u0003\u0003\u0015\u0019KG.\u001a$pe6\fG\u000f\u0005\u0002\u001eA5\taD\u0003\u0002 \u0011\u000591o\\;sG\u0016\u001c\u0018BA\u0011\u001f\u0005I!\u0015\r^1T_V\u00148-\u001a*fO&\u001cH/\u001a:\t\u000b\r\u0002A\u0011\u0001\u0013\u0002\rqJg.\u001b;?)\u0005)\u0003C\u0001\u0014\u0001\u001b\u0005\u0011\u0001\"\u0002\u0015\u0001\t\u0003J\u0013!C:i_J$h*Y7f)\u0005Q\u0003CA\u0016/\u001d\t\u0019B&\u0003\u0002.)\u00051\u0001K]3eK\u001aL!a\f\u0019\u0003\rM#(/\u001b8h\u0015\tiC\u0003C\u00033\u0001\u0011\u0005\u0013&\u0001\u0005u_N#(/\u001b8h\u0011\u0015!\u0004\u0001\"\u00116\u0003!A\u0017m\u001d5D_\u0012,G#\u0001\u001c\u0011\u0005M9\u0014B\u0001\u001d\u0015\u0005\rIe\u000e\u001e\u0005\u0006u\u0001!\teO\u0001\u0007KF,\u0018\r\\:\u0015\u0005qz\u0004CA\n>\u0013\tqDCA\u0004C_>dW-\u00198\t\u000b\u0001K\u0004\u0019A!\u0002\u000b=$\b.\u001a:\u0011\u0005M\u0011\u0015BA\"\u0015\u0005\r\te.\u001f\u0005\u0006\u000b\u0002!\tER\u0001\fS:4WM]*dQ\u0016l\u0017\r\u0006\u0003H!Z[\u0006cA\nI\u0015&\u0011\u0011\n\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005-sU\"\u0001'\u000b\u00055C\u0011!\u0002;za\u0016\u001c\u0018BA(M\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006#\u0012\u0003\rAU\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003'Rk\u0011\u0001C\u0005\u0003+\"\u0011Ab\u00159be.\u001cVm]:j_:DQa\u0016#A\u0002a\u000bqa\u001c9uS>t7\u000f\u0005\u0003,3*R\u0013B\u0001.1\u0005\ri\u0015\r\u001d\u0005\u00069\u0012\u0003\r!X\u0001\u0006M&dWm\u001d\t\u0004=\u001aLgBA0e\u001d\t\u00017-D\u0001b\u0015\t\u0011\u0007#\u0001\u0004=e>|GOP\u0005\u0002+%\u0011Q\rF\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0007NA\u0002TKFT!!\u001a\u000b\u0011\u0005)|W\"A6\u000b\u00051l\u0017A\u00014t\u0015\tqG\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003a.\u0014!BR5mKN#\u0018\r^;t\u0011\u0015\u0011\b\u0001\"\u0011t\u00031\u0001(/\u001a9be\u0016<&/\u001b;f)\u001d!x\u000f_A\u0001\u0003\u0007\u0001\"!G;\n\u0005Y$!aE(viB,Ho\u0016:ji\u0016\u0014h)Y2u_JL\b\"B)r\u0001\u0004\u0011\u0006\"B=r\u0001\u0004Q\u0018a\u00016pEB\u00111P`\u0007\u0002y*\u0011Q0\\\u0001\n[\u0006\u0004(/\u001a3vG\u0016L!a ?\u0003\u0007){'\rC\u0003Xc\u0002\u0007\u0001\f\u0003\u0004\u0002\u0006E\u0004\rAS\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007bBA\u0005\u0001\u0011\u0005\u00131B\u0001\fEVLG\u000e\u001a*fC\u0012,'\u000f\u0006\t\u0002\u000e\u0005-\u0012QFA\u0018\u0003g\t9$a\u0011\u0002FA91#a\u0004\u0002\u0014\u0005e\u0011bAA\t)\tIa)\u001e8di&|g.\r\t\u00043\u0005U\u0011bAA\f\t\ty\u0001+\u0019:uSRLwN\\3e\r&dW\rE\u0003_\u00037\ty\"C\u0002\u0002\u001e!\u0014\u0001\"\u0013;fe\u0006$xN\u001d\t\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011Q\u0005\u0005\u0002\u0011\r\fG/\u00197zgRLA!!\u000b\u0002$\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0019\t\u0016q\u0001a\u0001%\"9\u0011QAA\u0004\u0001\u0004Q\u0005bBA\u0019\u0003\u000f\u0001\rAS\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\"9\u0011QGA\u0004\u0001\u0004Q\u0015A\u0004:fcVL'/\u001a3TG\",W.\u0019\u0005\t\u0003s\t9\u00011\u0001\u0002<\u00059a-\u001b7uKJ\u001c\b\u0003\u00020g\u0003{\u00012!HA \u0013\r\t\tE\b\u0002\u0007\r&dG/\u001a:\t\r]\u000b9\u00011\u0001Y\u0011!\t9%a\u0002A\u0002\u0005%\u0013A\u00035bI>|\u0007oQ8oMB!\u00111JA)\u001b\t\tiEC\u0002\u0002P5\fAaY8oM&!\u00111KA'\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"9\u0011q\u000b\u0001\u0005\n\u0005e\u0013a\u00022bg\u0016\u0014F\r\u001a\u000b\t\u00037\n9'!\u001b\u0002rA)\u0011QLA2U5\u0011\u0011q\f\u0006\u0004\u0003CR\u0011a\u0001:eI&!\u0011QMA0\u0005\r\u0011F\t\u0012\u0005\u0007#\u0006U\u0003\u0019\u0001*\t\u000f]\u000b)\u00061\u0001\u0002lA\u0019a%!\u001c\n\u0007\u0005=$A\u0001\u0006D'Z{\u0005\u000f^5p]ND\u0001\"a\u001d\u0002V\u0001\u0007\u0011QO\u0001\u000bS:\u0004X\u000f\u001e)bi\"\u001c\bc\u00010gU!9\u0011\u0011\u0010\u0001\u0005\n\u0005m\u0014\u0001\u0003;pW\u0016t'\u000b\u001a3\u0015\u0015\u0005u\u0014QQAD\u0003\u0013\u000bi\t\u0005\u0004\u0002^\u0005\r\u0014q\u0010\t\u0005'\u0005\u0005%&C\u0002\u0002\u0004R\u0011Q!\u0011:sCfDa!UA<\u0001\u0004\u0011\u0006bB,\u0002x\u0001\u0007\u00111\u000e\u0005\t\u0003\u0017\u000b9\b1\u0001\u0002\u0000\u00051\u0001.Z1eKJD\u0001\"a\u001d\u0002x\u0001\u0007\u0011Q\u000f\u0005\b\u0003#\u0003A\u0011BAJ\u000351\u0017N\u001c3GSJ\u001cH\u000fT5oKR)!&!&\u0002\u0018\"9q+a$A\u0002\u0005-\u0004\u0002CA1\u0003\u001f\u0003\r!a\u0017\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\u0006A!/Z1e)\u0016DH\u000f\u0006\u0005\u0002\\\u0005}\u0015\u0011UAR\u0011\u0019\t\u0016\u0011\u0014a\u0001%\"9q+!'A\u0002\u0005-\u0004bBAS\u00033\u0003\rAK\u0001\tY>\u001c\u0017\r^5p]\u0002")
public class DefaultSource
implements FileFormat,
DataSourceRegister {
    @Override
    public Map<String, String> prepareRead(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return FileFormat$class.prepareRead(this, sparkSession, options, files);
    }

    @Override
    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat$class.supportBatch(this, sparkSession, dataSchema);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat$class.buildReaderWithPartitionValues(this, sparkSession, dataSchema, partitionSchema, requiredSchema, filters, options, hadoopConf);
    }

    @Override
    public OutputWriterFactory buildWriter(SQLContext sqlContext, StructType dataSchema, Map<String, String> options) {
        return FileFormat$class.buildWriter(this, sqlContext, dataSchema, options);
    }

    @Override
    public String shortName() {
        return "csv";
    }

    public String toString() {
        return "CSV";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof DefaultSource;
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        StructType structType;
        CSVOptions csvOptions = new CSVOptions(options);
        Seq paths = (Seq)((TraversableLike)files.filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$1) {
                return x$1.getPath().getName().startsWith("_");
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$2) {
                return x$2.getPath().toString();
            }
        }, Seq$.MODULE$.canBuildFrom());
        RDD<String> rdd = this.baseRdd(sparkSession, csvOptions, (Seq<String>)paths);
        String firstLine = this.findFirstLine(csvOptions, rdd);
        String[] firstRow = new LineCsvReader(csvOptions).parseLine(firstLine);
        String[] header = csvOptions.headerFlag() ? (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])firstRow).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this, csvOptions){
            public static final long serialVersionUID = 0L;
            private final CSVOptions csvOptions$1;

            /*
             * Unable to fully structure code
             */
            public final String apply(Tuple2<String, Object> x0$1) {
                block2: {
                    var2_2 = x0$1;
                    if (var2_2 == null) break block2;
                    value = (String)var2_2._1();
                    index = var2_2._2$mcI$sp();
                    if (value == null || value.isEmpty()) ** GOTO lbl-1000
                    v0 = value;
                    var5_5 = this.csvOptions$1.nullValue();
                    if (!(v0 != null ? v0.equals(var5_5) == false : var5_5 != null)) lbl-1000:
                    // 2 sources

                    {
                        v1 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_c", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index)}));
                    } else {
                        v1 = value;
                    }
                    var6_6 = v1;
                    return var6_6;
                }
                throw new MatchError(var2_2);
            }
            {
                this.csvOptions$1 = csvOptions$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])firstRow).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x0$2) {
                Tuple2<String, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    int index = tuple2._2$mcI$sp();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_c", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index)}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        RDD<String[]> parsedRdd = this.tokenRdd(sparkSession, csvOptions, header, (Seq<String>)paths);
        if (csvOptions.inferSchemaFlag()) {
            structType = CSVInferSchema$.MODULE$.infer(parsedRdd, header, csvOptions);
        } else {
            StructField[] schemaFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])header).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final StructField apply(String fieldName) {
                    return new StructField(fieldName.toString(), (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
            structType = new StructType(schemaFields);
        }
        StructType schema = structType;
        return new Some((Object)schema);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        Configuration conf = job.getConfiguration();
        CSVOptions csvOptions = new CSVOptions(options);
        csvOptions.compressionCodec().foreach((Function1)new Serializable(this, conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final void apply(String codec) {
                CompressionCodecs$.MODULE$.setCodecConfiguration(this.conf$1, codec);
            }
            {
                this.conf$1 = conf$1;
            }
        });
        return new CSVOutputWriterFactory(csvOptions);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        CSVOptions csvOptions = new CSVOptions(options);
        String[] headers = (String[])Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$3) {
                return x$3.name();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return new Serializable(this, dataSchema, requiredSchema, csvOptions, headers, broadcastedHadoopConf){
            public static final long serialVersionUID = 0L;
            private final StructType dataSchema$1;
            private final StructType requiredSchema$1;
            public final CSVOptions csvOptions$2;
            private final String[] headers$1;
            private final Broadcast broadcastedHadoopConf$1;

            public final Iterator<InternalRow> apply(PartitionedFile file) {
                Configuration conf = ((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value();
                Iterator<B> lineIterator = new HadoopFileLinesReader(file, conf).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$buildReader$1 $outer;

                    public final String apply(Text line) {
                        return new String(line.getBytes(), 0, line.getLength(), this.$outer.csvOptions$2.charset());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                CSVRelation$.MODULE$.dropHeaderLine(file, lineIterator, this.csvOptions$2);
                BulkCsvReader tokenizedIterator = new BulkCsvReader(lineIterator, this.csvOptions$2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])this.headers$1));
                Function1<String[], Option<InternalRow>> parser = CSVRelation$.MODULE$.csvParser(this.dataSchema$1, this.requiredSchema$1.fieldNames(), this.csvOptions$2);
                return tokenizedIterator.flatMap(new Serializable(this, parser){
                    public static final long serialVersionUID = 0L;
                    private final Function1 parser$1;

                    public final Seq<InternalRow> apply(String[] x$4) {
                        return Option$.MODULE$.option2Iterable((Option)this.parser$1.apply((Object)x$4)).toSeq();
                    }
                    {
                        this.parser$1 = parser$1;
                    }
                });
            }
            {
                this.dataSchema$1 = dataSchema$1;
                this.requiredSchema$1 = requiredSchema$1;
                this.csvOptions$2 = csvOptions$2;
                this.headers$1 = headers$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
            }
        };
    }

    private RDD<String> baseRdd(SparkSession sparkSession, CSVOptions options, Seq<String> inputPaths) {
        return this.readText(sparkSession, options, inputPaths.mkString(","));
    }

    private RDD<String[]> tokenRdd(SparkSession sparkSession, CSVOptions options, String[] header, Seq<String> inputPaths) {
        RDD<String> rdd = this.baseRdd(sparkSession, options, inputPaths);
        String firstLine = options.headerFlag() ? this.findFirstLine(options, rdd) : null;
        return CSVRelation$.MODULE$.univocityTokenizer(rdd, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])header), firstLine, options);
    }

    private String findFirstLine(CSVOptions options, RDD<String> rdd) {
        String string;
        if (options.isCommentSet()) {
            String comment = ((Object)BoxesRunTime.boxToCharacter((char)options.comment())).toString();
            string = (String)rdd.filter((Function1)new Serializable(this, comment){
                public static final long serialVersionUID = 0L;
                private final String comment$1;

                public final boolean apply(String line) {
                    return new StringOps(Predef$.MODULE$.augmentString(line.trim())).nonEmpty() && !line.startsWith(this.comment$1);
                }
                {
                    this.comment$1 = comment$1;
                }
            }).first();
        } else {
            string = (String)rdd.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String line) {
                    return new StringOps(Predef$.MODULE$.augmentString(line.trim())).nonEmpty();
                }
            }).first();
        }
        return string;
    }

    private RDD<String> readText(SparkSession sparkSession, CSVOptions options, String location) {
        RDD rDD;
        Charset charset = Charset.forName(options.charset());
        Charset charset2 = StandardCharsets.UTF_8;
        if (!(charset != null ? !((Object)charset).equals(charset2) : charset2 != null)) {
            rDD = sparkSession.sparkContext().textFile(location, sparkSession.sparkContext().textFile$default$2());
        } else {
            String charset3 = options.charset();
            RDD qual$1 = sparkSession.sparkContext().hadoopFile(location, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(Text.class), ClassTag$.MODULE$.apply(TextInputFormat.class));
            Serializable x$6 = new Serializable(this, charset3){
                public static final long serialVersionUID = 0L;
                public final String charset$1;

                public final Iterator<String> apply(Iterator<Tuple2<LongWritable, Text>> x$5) {
                    return x$5.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$8 $outer;

                        public final String apply(Tuple2<LongWritable, Text> pair) {
                            return new String(((Text)pair._2()).getBytes(), 0, ((Text)pair._2()).getLength(), this.$outer.charset$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.charset$1 = charset$1;
                }
            };
            boolean x$7 = qual$1.mapPartitions$default$2();
            rDD = qual$1.mapPartitions((Function1)x$6, x$7, ClassTag$.MODULE$.apply(String.class));
        }
        return rDD;
    }

    public DefaultSource() {
        FileFormat$class.$init$(this);
    }
}

