/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.csv.BulkCsvReader;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVRelation$;
import org.apache.spark.sql.execution.datasources.csv.CSVTypeCast$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class CSVRelation$
implements Logging {
    public static final CSVRelation$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new CSVRelation$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public RDD<String[]> univocityTokenizer(RDD<String> file, Seq<String> header, String firstLine, CSVOptions params) {
        return file.mapPartitions((Function1)new Serializable(header, firstLine, params){
            public static final long serialVersionUID = 0L;
            private final Seq header$1;
            public final String firstLine$1;
            private final CSVOptions params$1;

            public final BulkCsvReader apply(Iterator<String> iter) {
                return new BulkCsvReader((Iterator<String>)(this.params$1.headerFlag() ? iter.filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.univocityTokenizer.1 $outer;

                    public final boolean apply(String x$1) {
                        String string = x$1;
                        String string2 = this.$outer.firstLine$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }) : iter), this.params$1, (Seq<String>)this.header$1);
            }
            {
                this.header$1 = header$1;
                this.firstLine$1 = firstLine$1;
                this.params$1 = params$1;
            }
        }, file.mapPartitions$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
    }

    public Function1<String[], Option<InternalRow>> csvParser(StructType schema, String[] requiredColumns, CSVOptions params) {
        StructField[] schemaFields = schema.fields();
        StructField[] requiredFields = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns).map((Function1)new Serializable(schema){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;

            public final StructField apply(String x$2) {
                return this.schema$1.apply(x$2);
            }
            {
                this.schema$1 = schema$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))).fields();
        StructField[] safeRequiredFields = params.dropMalformed() ? (StructField[])Predef$.MODULE$.refArrayOps((Object[])requiredFields).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schemaFields).filterNot((Function1)new Serializable(requiredFields){
            public static final long serialVersionUID = 0L;
            private final StructField[] requiredFields$1;

            public final boolean apply(StructField x$3) {
                return Predef$.MODULE$.refArrayOps((Object[])this.requiredFields$1).contains((Object)x$3);
            }
            {
                this.requiredFields$1 = requiredFields$1;
            }
        })), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))) : requiredFields;
        int[] safeRequiredIndices = new int[safeRequiredFields.length];
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schemaFields).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).filter((Function1)new Serializable(safeRequiredFields){
            public static final long serialVersionUID = 0L;
            private final StructField[] safeRequiredFields$1;

            public final boolean apply(Tuple2<StructField, Object> x0$1) {
                Tuple2<StructField, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    StructField field = (StructField)tuple2._1();
                    boolean bl = Predef$.MODULE$.refArrayOps((Object[])this.safeRequiredFields$1).contains((Object)field);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.safeRequiredFields$1 = safeRequiredFields$1;
            }
        })).foreach((Function1)new Serializable(safeRequiredFields, safeRequiredIndices){
            public static final long serialVersionUID = 0L;
            private final StructField[] safeRequiredFields$1;
            private final int[] safeRequiredIndices$1;

            public final void apply(Tuple2<StructField, Object> x0$2) {
                Tuple2<StructField, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    int index;
                    StructField field = (StructField)tuple2._1();
                    this.safeRequiredIndices$1[Predef$.MODULE$.refArrayOps((Object[])((Object[])this.safeRequiredFields$1)).indexOf((Object)field)] = index = tuple2._2$mcI$sp();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.safeRequiredFields$1 = safeRequiredFields$1;
                this.safeRequiredIndices$1 = safeRequiredIndices$1;
            }
        });
        int requiredSize = requiredFields.length;
        GenericMutableRow row = new GenericMutableRow(requiredSize);
        return new Serializable(params, schemaFields, safeRequiredIndices, requiredSize, row){
            public static final long serialVersionUID = 0L;
            public final CSVOptions params$2;
            private final StructField[] schemaFields$1;
            private final int[] safeRequiredIndices$1;
            private final int requiredSize$1;
            private final GenericMutableRow row$1;

            public final Option<InternalRow> apply(String[] tokens) {
                Throwable throwable2;
                block6: {
                    None$ none$;
                    if (this.params$2.dropMalformed() && this.schemaFields$1.length != tokens.length) {
                        CSVRelation$.MODULE$.logWarning((Function0<String>)new Serializable(this, tokens){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.csvParser.3 $outer;
                            private final String[] tokens$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dropping malformed line: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.tokens$1).mkString(((Object)BoxesRunTime.boxToCharacter((char)this.$outer.params$2.delimiter())).toString())}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.tokens$1 = tokens$1;
                            }
                        });
                        none$ = None$.MODULE$;
                    } else {
                        if (this.params$2.failFast() && this.schemaFields$1.length != tokens.length) {
                            throw new RuntimeException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Malformed line in FAILFAST mode: "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])tokens).mkString(((Object)BoxesRunTime.boxToCharacter((char)this.params$2.delimiter())).toString())}))).toString());
                        }
                        String[] indexSafeTokens = this.params$2.permissive() && this.schemaFields$1.length > tokens.length ? (String[])Predef$.MODULE$.refArrayOps((Object[])tokens).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[this.schemaFields$1.length - tokens.length]), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : (this.params$2.permissive() && this.schemaFields$1.length < tokens.length ? (String[])Predef$.MODULE$.refArrayOps((Object[])tokens).take(this.schemaFields$1.length) : tokens);
                        try {
                            int index = 0;
                            for (int subIndex = 0; subIndex < this.safeRequiredIndices$1.length; ++subIndex) {
                                index = this.safeRequiredIndices$1[subIndex];
                                StructField field = this.schemaFields$1[index];
                                Object value = CSVTypeCast$.MODULE$.castTo(indexSafeTokens[index], field.dataType(), field.nullable(), this.params$2);
                                if (subIndex >= this.requiredSize$1) continue;
                                this.row$1.update(subIndex, value);
                            }
                            none$ = new Some((Object)this.row$1);
                        }
                        catch (Throwable throwable2) {
                            None$ none$2;
                            Throwable throwable3 = throwable2;
                            Option option = NonFatal$.MODULE$.unapply(throwable3);
                            if (option.isEmpty() || !this.params$2.dropMalformed()) break block6;
                            CSVRelation$.MODULE$.logWarning((Function0<String>)new Serializable(this, tokens){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.csvParser.3 $outer;
                                private final String[] tokens$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Parse exception. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dropping malformed line: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.tokens$1).mkString(((Object)BoxesRunTime.boxToCharacter((char)this.$outer.params$2.delimiter())).toString())}))).toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.tokens$1 = tokens$1;
                                }
                            });
                            none$ = none$2 = None$.MODULE$;
                        }
                    }
                    return none$;
                }
                throw throwable2;
            }
            {
                this.params$2 = params$2;
                this.schemaFields$1 = schemaFields$1;
                this.safeRequiredIndices$1 = safeRequiredIndices$1;
                this.requiredSize$1 = requiredSize$1;
                this.row$1 = row$1;
            }
        };
    }

    public RDD<InternalRow> parseCsv(RDD<String[]> tokenizedRDD, StructType schema, String[] requiredColumns, CSVOptions options) {
        Function1<String[], Option<InternalRow>> parser = this.csvParser(schema, requiredColumns, options);
        return tokenizedRDD.flatMap((Function1)new Serializable(parser){
            public static final long serialVersionUID = 0L;
            private final Function1 parser$1;

            public final Seq<InternalRow> apply(String[] x$4) {
                return Option$.MODULE$.option2Iterable((Option)this.parser$1.apply((Object)x$4)).toSeq();
            }
            {
                this.parser$1 = parser$1;
            }
        }, ClassTag$.MODULE$.apply(InternalRow.class));
    }

    public void dropHeaderLine(PartitionedFile file, Iterator<String> lines, CSVOptions csvOptions) {
        if (csvOptions.headerFlag() && file.start() == 0L) {
            Iterator nonEmptyLines;
            Iterator iterator2;
            if (csvOptions.isCommentSet()) {
                String commentPrefix = ((Object)BoxesRunTime.boxToCharacter((char)csvOptions.comment())).toString();
                iterator2 = lines.dropWhile((Function1)new Serializable(commentPrefix){
                    public static final long serialVersionUID = 0L;
                    private final String commentPrefix$1;

                    public final boolean apply(String line) {
                        return line.trim().isEmpty() || line.trim().startsWith(this.commentPrefix$1);
                    }
                    {
                        this.commentPrefix$1 = commentPrefix$1;
                    }
                });
            } else {
                iterator2 = nonEmptyLines = lines.dropWhile((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$5) {
                        return x$5.trim().isEmpty();
                    }
                });
            }
            if (nonEmptyLines.hasNext()) {
                nonEmptyLines.drop(1);
            }
        }
    }

    private CSVRelation$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

