/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.BucketSpec;
import org.apache.spark.sql.execution.datasources.FileCatalog;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.reflect.ClassTag$;
import scala.util.Try$;

public final class HadoopFsRelation$
implements Logging,
Serializable {
    public static final HadoopFsRelation$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new HadoopFsRelation$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldFilterOut(String pathName) {
        String string = pathName;
        String string2 = "_SUCCESS";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = pathName;
        String string4 = "_temporary";
        if (string3 == null) {
            if (string4 == null) return true;
        } else if (string3.equals(string4)) return true;
        if (!pathName.startsWith(".")) return false;
        return true;
    }

    public FileStatus[] listLeafFiles(FileSystem fs, FileStatus status) {
        Tuple2 tuple2;
        block4: {
            FileStatus[] fileStatusArray;
            block3: {
                Tuple2 tuple22;
                block2: {
                    this.logInfo((Function0<String>)new Serializable(status){
                        public static final long serialVersionUID = 0L;
                        private final FileStatus status$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listing ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.status$1.getPath()}));
                        }
                        {
                            this.status$1 = status$1;
                        }
                    });
                    String name = status.getPath().getName().toLowerCase();
                    if (!this.shouldFilterOut(name)) break block2;
                    fileStatusArray = (FileStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileStatus.class));
                    break block3;
                }
                JobConf jobConf = new JobConf(fs.getConf(), this.getClass());
                PathFilter pathFilter = FileInputFormat.getInputPathFilter((JobConf)jobConf);
                tuple2 = Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(status.getPath())).partition((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileStatus x$4) {
                        return x$4.isDirectory();
                    }
                });
                if (tuple2 == null) break block4;
                FileStatus[] dirs = (FileStatus[])tuple2._1();
                FileStatus[] files = (FileStatus[])tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)dirs, (Object)files);
                FileStatus[] dirs2 = (FileStatus[])tuple23._1();
                FileStatus[] files2 = (FileStatus[])tuple23._2();
                FileStatus[] stats = (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])files2).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])dirs2).flatMap((Function1)new Serializable(fs){
                    public static final long serialVersionUID = 0L;
                    private final FileSystem fs$1;

                    public final ArrayOps<FileStatus> apply(FileStatus dir) {
                        return Predef$.MODULE$.refArrayOps((Object[])HadoopFsRelation$.MODULE$.listLeafFiles(this.fs$1, dir));
                    }
                    {
                        this.fs$1 = fs$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)));
                FileStatus[] statuses = pathFilter == null ? stats : (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])stats).filter((Function1)new Serializable(pathFilter){
                    public static final long serialVersionUID = 0L;
                    private final PathFilter pathFilter$1;

                    public final boolean apply(FileStatus f) {
                        return this.pathFilter$1.accept(f.getPath());
                    }
                    {
                        this.pathFilter$1 = pathFilter$1;
                    }
                });
                fileStatusArray = (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])statuses).filterNot((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileStatus status) {
                        return HadoopFsRelation$.MODULE$.shouldFilterOut(status.getPath().getName());
                    }
                })).map((Function1)new Serializable(fs){
                    public static final long serialVersionUID = 0L;
                    private final FileSystem fs$1;

                    public final LocatedFileStatus apply(FileStatus x0$1) {
                        LocatedFileStatus locatedFileStatus;
                        FileStatus fileStatus = x0$1;
                        LocatedFileStatus locatedFileStatus2 = fileStatus instanceof LocatedFileStatus ? (locatedFileStatus = (LocatedFileStatus)fileStatus) : new LocatedFileStatus(fileStatus, this.fs$1.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen()));
                        return locatedFileStatus2;
                    }
                    {
                        this.fs$1 = fs$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)));
            }
            return fileStatusArray;
        }
        throw new MatchError((Object)tuple2);
    }

    public LinkedHashSet<FileStatus> listLeafFilesInParallel(Seq<Path> paths, Configuration hadoopConf, SparkContext sparkContext) {
        this.logInfo((Function0<String>)new Serializable(paths){
            public static final long serialVersionUID = 0L;
            private final Seq paths$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listing leaf files and directories in parallel under: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.paths$1.mkString(", ")}));
            }
            {
                this.paths$1 = paths$1;
            }
        });
        SerializableConfiguration serializableConfiguration = new SerializableConfiguration(hadoopConf);
        Seq serializedPaths = (Seq)paths.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Path x$6) {
                return x$6.toString();
            }
        }, Seq$.MODULE$.canBuildFrom());
        HadoopFsRelation.FakeFileStatus[] fakeStatuses = (HadoopFsRelation.FakeFileStatus[])sparkContext.parallelize(serializedPaths, sparkContext.parallelize$default$2(), ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Path apply(String x$7) {
                return new Path(x$7);
            }
        }, ClassTag$.MODULE$.apply(Path.class)).flatMap((Function1)new Serializable(serializableConfiguration){
            public static final long serialVersionUID = 0L;
            private final SerializableConfiguration serializableConfiguration$1;

            public final ArrayOps<FileStatus> apply(Path path) {
                FileSystem fs = path.getFileSystem(this.serializableConfiguration$1.value());
                return Predef$.MODULE$.refArrayOps((Object[])Try$.MODULE$.apply((Function0)new Serializable(this, fs, path){
                    public static final long serialVersionUID = 0L;
                    private final FileSystem fs$2;
                    private final Path path$1;

                    public final FileStatus[] apply() {
                        return HadoopFsRelation$.MODULE$.listLeafFiles(this.fs$2, this.fs$2.getFileStatus(this.path$1));
                    }
                    {
                        this.fs$2 = fs$2;
                        this.path$1 = path$1;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FileStatus[] apply() {
                        return (FileStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileStatus.class));
                    }
                }));
            }
            {
                this.serializableConfiguration$1 = serializableConfiguration$1;
            }
        }, ClassTag$.MODULE$.apply(FileStatus.class)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final HadoopFsRelation.FakeFileStatus apply(FileStatus status) {
                HadoopFsRelation.FakeBlockLocation[] fakeBlockLocationArray;
                FileStatus fileStatus = status;
                if (fileStatus instanceof LocatedFileStatus) {
                    LocatedFileStatus locatedFileStatus = (LocatedFileStatus)fileStatus;
                    fakeBlockLocationArray = (HadoopFsRelation.FakeBlockLocation[])Predef$.MODULE$.refArrayOps((Object[])locatedFileStatus.getBlockLocations()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final HadoopFsRelation.FakeBlockLocation apply(BlockLocation loc) {
                            return new HadoopFsRelation.FakeBlockLocation(loc.getNames(), loc.getHosts(), loc.getOffset(), loc.getLength());
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(HadoopFsRelation.FakeBlockLocation.class)));
                } else {
                    fakeBlockLocationArray = (HadoopFsRelation.FakeBlockLocation[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(HadoopFsRelation.FakeBlockLocation.class));
                }
                HadoopFsRelation.FakeBlockLocation[] blockLocations = fakeBlockLocationArray;
                return new HadoopFsRelation.FakeFileStatus(status.getPath().toString(), status.getLen(), status.isDirectory(), status.getReplication(), status.getBlockSize(), status.getModificationTime(), status.getAccessTime(), blockLocations);
            }
        }, ClassTag$.MODULE$.apply(HadoopFsRelation.FakeFileStatus.class)).collect();
        LocatedFileStatus[] hadoopFakeStatuses = (LocatedFileStatus[])Predef$.MODULE$.refArrayOps((Object[])fakeStatuses).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LocatedFileStatus apply(HadoopFsRelation.FakeFileStatus f) {
                BlockLocation[] blockLocations = (BlockLocation[])Predef$.MODULE$.refArrayOps((Object[])f.blockLocations()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BlockLocation apply(HadoopFsRelation.FakeBlockLocation loc) {
                        return new BlockLocation(loc.names(), loc.hosts(), loc.offset(), loc.length());
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BlockLocation.class)));
                return new LocatedFileStatus(new FileStatus(f.length(), f.isDir(), (int)f.blockReplication(), f.blockSize(), f.modificationTime(), new Path(f.path())), blockLocations);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LocatedFileStatus.class)));
        return (LinkedHashSet)LinkedHashSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])((FileStatus[])hadoopFakeStatuses)));
    }

    public HadoopFsRelation apply(SparkSession sparkSession, FileCatalog location, StructType partitionSchema, StructType dataSchema, Option<BucketSpec> bucketSpec, FileFormat fileFormat, Map<String, String> options) {
        return new HadoopFsRelation(sparkSession, location, partitionSchema, dataSchema, bucketSpec, fileFormat, options);
    }

    public Option<Tuple7<SparkSession, FileCatalog, StructType, StructType, Option<BucketSpec>, FileFormat, Map<String, String>>> unapply(HadoopFsRelation x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.sparkSession(), (Object)x$0.location(), (Object)x$0.partitionSchema(), (Object)x$0.dataSchema(), x$0.bucketSpec(), (Object)x$0.fileFormat(), x$0.options()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private HadoopFsRelation$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

