/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.util.Properties;
import org.apache.spark.Partition;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.LogicalRDD;
import org.apache.spark.sql.execution.datasources.BucketSpec;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartitioningInfo;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation$;
import org.apache.spark.sql.execution.datasources.json.InferSchema$;
import org.apache.spark.sql.execution.datasources.json.JSONOptions;
import org.apache.spark.sql.execution.datasources.json.JacksonParser$;
import org.apache.spark.sql.execution.streaming.StreamingRelation$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tub\u0001B\u0001\u0003\u0001-\u0011q\u0002R1uC\u001a\u0013\u0018-\\3SK\u0006$WM\u001d\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u0018)\t9Aj\\4hS:<\u0007\u0002C\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005maR\"\u0001\u0002\n\u0005u\u0011!\u0001D*qCJ\\7+Z:tS>t\u0007BB\u0010\u0001\t\u0003\u0011\u0001%\u0001\u0004=S:LGO\u0010\u000b\u0003C\t\u0002\"a\u0007\u0001\t\u000beq\u0002\u0019\u0001\u000e\t\u000b\u0011\u0002A\u0011A\u0013\u0002\r\u0019|'/\\1u)\t\tc\u0005C\u0003(G\u0001\u0007\u0001&\u0001\u0004t_V\u00148-\u001a\t\u0003S1r!!\u0004\u0016\n\u0005-r\u0011A\u0002)sK\u0012,g-\u0003\u0002.]\t11\u000b\u001e:j]\u001eT!a\u000b\b\t\u000bA\u0002A\u0011A\u0019\u0002\rM\u001c\u0007.Z7b)\t\t#\u0007C\u00031_\u0001\u00071\u0007\u0005\u00025o5\tQG\u0003\u00027\u0005\u0005)A/\u001f9fg&\u0011\u0001(\u000e\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"\u0002\u001e\u0001\t\u0003Y\u0014AB8qi&|g\u000eF\u0002\"yyBQ!P\u001dA\u0002!\n1a[3z\u0011\u0015y\u0014\b1\u0001)\u0003\u00151\u0018\r\\;f\u0011\u0015Q\u0004\u0001\"\u0001B)\r\t#i\u0011\u0005\u0006{\u0001\u0003\r\u0001\u000b\u0005\u0006\u007f\u0001\u0003\r\u0001\u0012\t\u0003\u001b\u0015K!A\u0012\b\u0003\u000f\t{w\u000e\\3b]\")!\b\u0001C\u0001\u0011R\u0019\u0011%\u0013&\t\u000bu:\u0005\u0019\u0001\u0015\t\u000b}:\u0005\u0019A&\u0011\u00055a\u0015BA'\u000f\u0005\u0011auN\\4\t\u000bi\u0002A\u0011A(\u0015\u0007\u0005\u0002\u0016\u000bC\u0003>\u001d\u0002\u0007\u0001\u0006C\u0003@\u001d\u0002\u0007!\u000b\u0005\u0002\u000e'&\u0011AK\u0004\u0002\u0007\t>,(\r\\3\t\u000bY\u0003A\u0011A,\u0002\u000f=\u0004H/[8ogR\u0011\u0011\u0005\u0017\u0005\u0006-V\u0003\r!\u0017\t\u00055vC\u0003&D\u0001\\\u0015\taf\"\u0001\u0006d_2dWm\u0019;j_:L!AX.\u0003\u00075\u000b\u0007\u000fC\u0003W\u0001\u0011\u0005\u0001\r\u0006\u0002\"C\")ak\u0018a\u0001EB!1\r\u001b\u0015)\u001b\u0005!'BA3g\u0003\u0011)H/\u001b7\u000b\u0003\u001d\fAA[1wC&\u0011a\f\u001a\u0005\u0006U\u0002!\ta[\u0001\u0005Y>\fG\rF\u0001m!\ti\u0007O\u0004\u0002\u001c]&\u0011qNA\u0001\ba\u0006\u001c7.Y4f\u0013\t\t(OA\u0005ECR\fgI]1nK*\u0011qN\u0001\u0005\u0006U\u0002!\t\u0001\u001e\u000b\u0003YVDQA^:A\u0002!\nA\u0001]1uQ\")!\u000e\u0001C\u0001qR\u0011A.\u001f\u0005\u0006u^\u0004\ra_\u0001\u0006a\u0006$\bn\u001d\t\u0004\u001bqD\u0013BA?\u000f\u0005)a$/\u001a9fCR,GM\u0010\u0015\u0003o~\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000bq\u0011AC1o]>$\u0018\r^5p]&!\u0011\u0011BA\u0002\u0005\u001d1\u0018M]1sONDa!!\u0004\u0001\t\u0003Y\u0017AB:ue\u0016\fW\u000e\u000b\u0003\u0002\f\u0005E\u0001\u0003BA\n\u0003/i!!!\u0006\u000b\u0007\u0005\u0015A!\u0003\u0003\u0002\u001a\u0005U!\u0001D#ya\u0016\u0014\u0018.\\3oi\u0006d\u0007bBA\u0007\u0001\u0011\u0005\u0011Q\u0004\u000b\u0004Y\u0006}\u0001B\u0002<\u0002\u001c\u0001\u0007\u0001\u0006\u000b\u0003\u0002\u001c\u0005E\u0001bBA\u0013\u0001\u0011\u0005\u0011qE\u0001\u0005U\u0012\u00147\rF\u0004m\u0003S\ti#!\r\t\u000f\u0005-\u00121\u0005a\u0001Q\u0005\u0019QO\u001d7\t\u000f\u0005=\u00121\u0005a\u0001Q\u0005)A/\u00192mK\"A\u00111GA\u0012\u0001\u0004\t)$\u0001\u0006qe>\u0004XM\u001d;jKN\u00042aYA\u001c\u0013\r\tI\u0004\u001a\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBA\u0013\u0001\u0011\u0005\u0011Q\b\u000b\u0010Y\u0006}\u0012\u0011IA\"\u0003\u000f\nY%a\u0014\u0002Z!9\u00111FA\u001e\u0001\u0004A\u0003bBA\u0018\u0003w\u0001\r\u0001\u000b\u0005\b\u0003\u000b\nY\u00041\u0001)\u0003)\u0019w\u000e\\;n]:\u000bW.\u001a\u0005\b\u0003\u0013\nY\u00041\u0001L\u0003)awn^3s\u0005>,h\u000e\u001a\u0005\b\u0003\u001b\nY\u00041\u0001L\u0003))\b\u000f]3s\u0005>,h\u000e\u001a\u0005\t\u0003#\nY\u00041\u0001\u0002T\u0005ia.^7QCJ$\u0018\u000e^5p]N\u00042!DA+\u0013\r\t9F\u0004\u0002\u0004\u0013:$\b\u0002CA.\u0003w\u0001\r!!\u000e\u0002)\r|gN\\3di&|g\u000e\u0015:pa\u0016\u0014H/[3t\u0011\u001d\t)\u0003\u0001C\u0001\u0003?\"\u0012\u0002\\A1\u0003G\n)'a\u001c\t\u000f\u0005-\u0012Q\fa\u0001Q!9\u0011qFA/\u0001\u0004A\u0003\u0002CA4\u0003;\u0002\r!!\u001b\u0002\u0015A\u0014X\rZ5dCR,7\u000f\u0005\u0003\u000e\u0003WB\u0013bAA7\u001d\t)\u0011I\u001d:bs\"A\u00111LA/\u0001\u0004\t)\u0004C\u0004\u0002&\u0001!I!a\u001d\u0015\u00131\f)(a\u001e\u0002z\u0005\u001d\u0005bBA\u0016\u0003c\u0002\r\u0001\u000b\u0005\b\u0003_\t\t\b1\u0001)\u0011!\tY(!\u001dA\u0002\u0005u\u0014!\u00029beR\u001c\b#B\u0007\u0002l\u0005}\u0004\u0003BAA\u0003\u0007k\u0011\u0001B\u0005\u0004\u0003\u000b#!!\u0003)beRLG/[8o\u0011!\tY&!\u001dA\u0002\u0005U\u0002bBAF\u0001\u0011\u0005\u0011QR\u0001\u0005UN|g\u000eF\u0002m\u0003\u001fCaA_AE\u0001\u0004Y\bfAAE\u007f\"9\u00111\u0012\u0001\u0005\u0002\u0005UEc\u00017\u0002\u0018\"A\u0011\u0011TAJ\u0001\u0004\tY*A\u0004kg>t'\u000b\u0012#\u0011\u000b\u0005u\u0015Q\u0015\u0015\u000e\u0005\u0005}%bA4\u0002\"*\u0019\u00111\u0015\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002(\u0006}%a\u0002&bm\u0006\u0014F\t\u0012\u0005\b\u0003\u0017\u0003A\u0011AAV)\ra\u0017Q\u0016\u0005\t\u00033\u000bI\u000b1\u0001\u00020B)\u0011\u0011WA\\Q5\u0011\u00111\u0017\u0006\u0004\u0003k#\u0011a\u0001:eI&!\u0011\u0011XAZ\u0005\r\u0011F\t\u0012\u0005\b\u0003{\u0003A\u0011AA`\u0003\r\u00197O\u001e\u000b\u0004Y\u0006\u0005\u0007B\u0002>\u0002<\u0002\u00071\u0010K\u0002\u0002<~Dq!a2\u0001\t\u0003\tI-A\u0004qCJ\fX/\u001a;\u0015\u00071\fY\r\u0003\u0004{\u0003\u000b\u0004\ra\u001f\u0015\u0004\u0003\u000b|\bbBAi\u0001\u0011\u0005\u00111[\u0001\u0004_J\u001cGc\u00017\u0002V\"1a/a4A\u0002!Bq!a\f\u0001\t\u0003\tI\u000eF\u0002m\u00037Dq!!8\u0002X\u0002\u0007\u0001&A\u0005uC\ndWMT1nK\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005\r\u0018\u0001\u0002;fqR$B!!:\u0002lB!1$a:)\u0013\r\tIO\u0001\u0002\b\t\u0006$\u0018m]3u\u0011\u0019Q\u0018q\u001ca\u0001w\"\u001a\u0011q\\@\t\u0011\u001d\u0002\u0001\u0019!C\u0005\u0003c,\u0012\u0001\u000b\u0005\n\u0003k\u0004\u0001\u0019!C\u0005\u0003o\f!b]8ve\u000e,w\fJ3r)\u0011\tI0a@\u0011\u00075\tY0C\u0002\u0002~:\u0011A!\u00168ji\"I!\u0011AAz\u0003\u0003\u0005\r\u0001K\u0001\u0004q\u0012\n\u0004b\u0002B\u0003\u0001\u0001\u0006K\u0001K\u0001\bg>,(oY3!\u0011%\u0011I\u0001\u0001a\u0001\n\u0013\u0011Y!A\nvg\u0016\u00148\u000b]3dS\u001aLW\rZ*dQ\u0016l\u0017-\u0006\u0002\u0003\u000eA!QBa\u00044\u0013\r\u0011\tB\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\tU\u0001\u00011A\u0005\n\t]\u0011aF;tKJ\u001c\u0006/Z2jM&,GmU2iK6\fw\fJ3r)\u0011\tIP!\u0007\t\u0015\t\u0005!1CA\u0001\u0002\u0004\u0011i\u0001\u0003\u0005\u0003\u001e\u0001\u0001\u000b\u0015\u0002B\u0007\u0003Q)8/\u001a:Ta\u0016\u001c\u0017NZ5fIN\u001b\u0007.Z7bA!I!\u0011\u0005\u0001A\u0002\u0013%!1E\u0001\rKb$(/Y(qi&|gn]\u000b\u0003\u0005K\u0001bAa\n\u0003.!BSB\u0001B\u0015\u0015\r\u0011YcW\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0011yC!\u000b\u0003\u000f!\u000b7\u000f['ba\"I!1\u0007\u0001A\u0002\u0013%!QG\u0001\u0011Kb$(/Y(qi&|gn]0%KF$B!!?\u00038!Q!\u0011\u0001B\u0019\u0003\u0003\u0005\rA!\n\t\u0011\tm\u0002\u0001)Q\u0005\u0005K\tQ\"\u001a=ue\u0006|\u0005\u000f^5p]N\u0004\u0003")
public class DataFrameReader
implements Logging {
    public final SparkSession org$apache$spark$sql$DataFrameReader$$sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private HashMap<String, String> extraOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public Dataset<Row> load(String ... paths) {
        return this.load((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> json(String ... paths) {
        return this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> csv(String ... paths) {
        return this.csv((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> parquet(String ... paths) {
        return this.parquet((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<String> text(String ... paths) {
        return this.text((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public DataFrameReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameReader schema(StructType schema) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)schema));
        return this;
    }

    public DataFrameReader option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameReader option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameReader option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameReader option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameReader options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataFrameReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public Dataset<Row> load() {
        SparkSession x$1 = this.org$apache$spark$sql$DataFrameReader$$sparkSession;
        Option<StructType> x$2 = this.userSpecifiedSchema();
        String x$3 = this.source();
        scala.collection.immutable.Map x$4 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Seq<String> x$6 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        DataSource dataSource = new DataSource(x$1, x$3, x$5, x$2, x$6, x$7, (scala.collection.immutable.Map<String, String>)x$4);
        return Dataset$.MODULE$.ofRows(this.org$apache$spark$sql$DataFrameReader$$sparkSession, (LogicalPlan)new LogicalRelation(dataSource.resolveRelation(dataSource.resolveRelation$default$1()), LogicalRelation$.MODULE$.apply$default$2(), LogicalRelation$.MODULE$.apply$default$3()));
    }

    public Dataset<Row> load(String path) {
        return this.option("path", path).load();
    }

    public Dataset<Row> load(Seq<String> paths) {
        Dataset<Row> dataset;
        if (paths.isEmpty()) {
            dataset = this.org$apache$spark$sql$DataFrameReader$$sparkSession.emptyDataFrame();
        } else {
            SparkSession x$8 = this.org$apache$spark$sql$DataFrameReader$$sparkSession;
            Seq<String> x$9 = paths;
            Option<StructType> x$10 = this.userSpecifiedSchema();
            String x$11 = this.source();
            scala.collection.immutable.Map x$12 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
            Seq<String> x$13 = DataSource$.MODULE$.apply$default$5();
            Option<BucketSpec> x$14 = DataSource$.MODULE$.apply$default$6();
            DataSource qual$1 = new DataSource(x$8, x$11, x$9, x$10, x$13, x$14, (scala.collection.immutable.Map<String, String>)x$12);
            boolean x$15 = qual$1.resolveRelation$default$1();
            dataset = this.org$apache$spark$sql$DataFrameReader$$sparkSession.baseRelationToDataFrame(qual$1.resolveRelation(x$15));
        }
        return dataset;
    }

    @Experimental
    public Dataset<Row> stream() {
        SparkSession x$16 = this.org$apache$spark$sql$DataFrameReader$$sparkSession;
        Option<StructType> x$17 = this.userSpecifiedSchema();
        String x$18 = this.source();
        scala.collection.immutable.Map x$19 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        Seq<String> x$20 = DataSource$.MODULE$.apply$default$3();
        Seq<String> x$21 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$22 = DataSource$.MODULE$.apply$default$6();
        DataSource dataSource = new DataSource(x$16, x$18, x$20, x$17, x$21, x$22, (scala.collection.immutable.Map<String, String>)x$19);
        return Dataset$.MODULE$.ofRows(this.org$apache$spark$sql$DataFrameReader$$sparkSession, (LogicalPlan)StreamingRelation$.MODULE$.apply(dataSource));
    }

    @Experimental
    public Dataset<Row> stream(String path) {
        return this.option("path", path).stream();
    }

    public Dataset<Row> jdbc(String url, String table, Properties properties) {
        return this.jdbc(url, table, JDBCRelation$.MODULE$.columnPartition(null), properties);
    }

    public Dataset<Row> jdbc(String url, String table, String columnName, long lowerBound, long upperBound, int numPartitions, Properties connectionProperties) {
        JDBCPartitioningInfo partitioning = new JDBCPartitioningInfo(columnName, lowerBound, upperBound, numPartitions);
        Partition[] parts = JDBCRelation$.MODULE$.columnPartition(partitioning);
        return this.jdbc(url, table, parts, connectionProperties);
    }

    public Dataset<Row> jdbc(String url, String table, String[] predicates, Properties connectionProperties) {
        Partition[] parts = (Partition[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])predicates).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Partition apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String part = (String)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    JDBCPartition jDBCPartition = new JDBCPartition(part, i);
                    return jDBCPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Partition.class)));
        return this.jdbc(url, table, parts, connectionProperties);
    }

    private Dataset<Row> jdbc(String url, String table, Partition[] parts, Properties connectionProperties) {
        Properties props = new Properties();
        this.extraOptions().foreach((Function1)new Serializable(this, props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    Object object = this.props$1.put(key, value);
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.props$1 = props$1;
            }
        });
        props.putAll((java.util.Map<?, ?>)connectionProperties);
        JDBCRelation relation = new JDBCRelation(url, table, parts, props, this.org$apache$spark$sql$DataFrameReader$$sparkSession);
        return this.org$apache$spark$sql$DataFrameReader$$sparkSession.baseRelationToDataFrame(relation);
    }

    public Dataset<Row> json(Seq<String> paths) {
        return this.format("json").load(paths);
    }

    public Dataset<Row> json(JavaRDD<String> jsonRDD) {
        return this.json((RDD<String>)jsonRDD.rdd());
    }

    public Dataset<Row> json(RDD<String> jsonRDD) {
        JSONOptions parsedOptions = new JSONOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.$conforms()));
        String columnNameOfCorruptRecord = (String)parsedOptions.columnNameOfCorruptRecord().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DataFrameReader $outer;

            public final String apply() {
                return this.$outer.org$apache$spark$sql$DataFrameReader$$sparkSession.sessionState().conf().columnNameOfCorruptRecord();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        StructType schema = (StructType)this.userSpecifiedSchema().getOrElse((Function0)new Serializable(this, jsonRDD, parsedOptions, columnNameOfCorruptRecord){
            public static final long serialVersionUID = 0L;
            private final RDD jsonRDD$1;
            private final JSONOptions parsedOptions$1;
            private final String columnNameOfCorruptRecord$1;

            public final StructType apply() {
                return InferSchema$.MODULE$.infer((RDD<String>)this.jsonRDD$1, this.columnNameOfCorruptRecord$1, this.parsedOptions$1);
            }
            {
                this.jsonRDD$1 = jsonRDD$1;
                this.parsedOptions$1 = parsedOptions$1;
                this.columnNameOfCorruptRecord$1 = columnNameOfCorruptRecord$1;
            }
        });
        return Dataset$.MODULE$.ofRows(this.org$apache$spark$sql$DataFrameReader$$sparkSession, new LogicalRDD((Seq<Attribute>)schema.toAttributes(), JacksonParser$.MODULE$.parse(jsonRDD, schema, columnNameOfCorruptRecord, parsedOptions), this.org$apache$spark$sql$DataFrameReader$$sparkSession));
    }

    public Dataset<Row> csv(Seq<String> paths) {
        return this.format("csv").load(paths);
    }

    public Dataset<Row> parquet(Seq<String> paths) {
        return this.format("parquet").load(paths);
    }

    public Dataset<Row> orc(String path) {
        return this.format("orc").load(path);
    }

    public Dataset<Row> table(String tableName) {
        return Dataset$.MODULE$.ofRows(this.org$apache$spark$sql$DataFrameReader$$sparkSession, this.org$apache$spark$sql$DataFrameReader$$sparkSession.sessionState().catalog().lookupRelation(this.org$apache$spark$sql$DataFrameReader$$sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName), this.org$apache$spark$sql$DataFrameReader$$sparkSession.sessionState().catalog().lookupRelation$default$2()));
    }

    public Dataset<String> text(Seq<String> paths) {
        return this.format("text").load(paths).as(this.org$apache$spark$sql$DataFrameReader$$sparkSession.implicits().newStringEncoder());
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(HashMap<String, String> x$1) {
        this.extraOptions = x$1;
    }

    public DataFrameReader(SparkSession sparkSession) {
        this.org$apache$spark$sql$DataFrameReader$$sparkSession = sparkSession;
        Logging.class.$init$((Logging)this);
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = new HashMap();
    }
}

