/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.api.r;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Map;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.r.SerDe$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.api.r.SQLUtils;
import org.apache.spark.sql.api.r.SQLUtils$;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class SQLUtils$ {
    public static final SQLUtils$ MODULE$;

    static {
        new SQLUtils$();
    }

    public SQLContext createSQLContext(JavaSparkContext jsc) {
        return new SQLContext(jsc);
    }

    public JavaSparkContext getJavaSparkContext(SQLContext sqlCtx) {
        return new JavaSparkContext(sqlCtx.sparkContext());
    }

    public StructType createStructType(Seq<StructField> fields) {
        return StructType$.MODULE$.apply(fields);
    }

    public SQLUtils.RegexContext org$apache$spark$sql$api$r$SQLUtils$$RegexContext(StringContext sc) {
        return new SQLUtils.RegexContext(sc);
    }

    public DataType getSQLDataType(String dataType) {
        block22: {
            ByteType$ byteType$;
            block5: {
                String string;
                block19: {
                    block21: {
                        String valueType;
                        String keyType;
                        block20: {
                            block18: {
                                block17: {
                                    block16: {
                                        block15: {
                                            block14: {
                                                block13: {
                                                    block12: {
                                                        block11: {
                                                            block10: {
                                                                block9: {
                                                                    block8: {
                                                                        block7: {
                                                                            block6: {
                                                                                block4: {
                                                                                    string = dataType;
                                                                                    if (!"byte".equals(string)) break block4;
                                                                                    byteType$ = ByteType$.MODULE$;
                                                                                    break block5;
                                                                                }
                                                                                if (!"integer".equals(string)) break block6;
                                                                                byteType$ = IntegerType$.MODULE$;
                                                                                break block5;
                                                                            }
                                                                            if (!"float".equals(string)) break block7;
                                                                            byteType$ = FloatType$.MODULE$;
                                                                            break block5;
                                                                        }
                                                                        if (!"double".equals(string)) break block8;
                                                                        byteType$ = DoubleType$.MODULE$;
                                                                        break block5;
                                                                    }
                                                                    if (!"numeric".equals(string)) break block9;
                                                                    byteType$ = DoubleType$.MODULE$;
                                                                    break block5;
                                                                }
                                                                if (!"character".equals(string)) break block10;
                                                                byteType$ = StringType$.MODULE$;
                                                                break block5;
                                                            }
                                                            if (!"string".equals(string)) break block11;
                                                            byteType$ = StringType$.MODULE$;
                                                            break block5;
                                                        }
                                                        if (!"binary".equals(string)) break block12;
                                                        byteType$ = BinaryType$.MODULE$;
                                                        break block5;
                                                    }
                                                    if (!"raw".equals(string)) break block13;
                                                    byteType$ = BinaryType$.MODULE$;
                                                    break block5;
                                                }
                                                if (!"logical".equals(string)) break block14;
                                                byteType$ = BooleanType$.MODULE$;
                                                break block5;
                                            }
                                            if (!"boolean".equals(string)) break block15;
                                            byteType$ = BooleanType$.MODULE$;
                                            break block5;
                                        }
                                        if (!"timestamp".equals(string)) break block16;
                                        byteType$ = TimestampType$.MODULE$;
                                        break block5;
                                    }
                                    if (!"date".equals(string)) break block17;
                                    byteType$ = DateType$.MODULE$;
                                    break block5;
                                }
                                Option option = this.org$apache$spark$sql$api$r$SQLUtils$$RegexContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\Aarray<(.+)", ">\\Z"}))).r().unapplySeq((CharSequence)string);
                                if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block18;
                                String elemType = (String)((LinearSeqOptimized)option.get()).apply(0);
                                byteType$ = ArrayType$.MODULE$.apply(this.getSQLDataType(elemType));
                                break block5;
                            }
                            Option option = this.org$apache$spark$sql$api$r$SQLUtils$$RegexContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\Amap<(.+)", ",(.+)", ">\\Z"}))).r().unapplySeq((CharSequence)string);
                            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) break block19;
                            keyType = (String)((LinearSeqOptimized)option.get()).apply(0);
                            valueType = (String)((LinearSeqOptimized)option.get()).apply(1);
                            String string2 = keyType;
                            String string3 = "string";
                            if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block20;
                            String string4 = keyType;
                            String string5 = "character";
                            if (string4 != null ? !string4.equals(string5) : string5 != null) break block21;
                        }
                        byteType$ = MapType$.MODULE$.apply(this.getSQLDataType(keyType), this.getSQLDataType(valueType));
                        break block5;
                    }
                    throw new IllegalArgumentException("Key type of a map must be string or character");
                }
                Option option = this.org$apache$spark$sql$api$r$SQLUtils$$RegexContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\Astruct<(.+)", ">\\Z"}))).r().unapplySeq((CharSequence)string);
                if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block22;
                String fieldsStr = (String)((LinearSeqOptimized)option.get()).apply(0);
                if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(fieldsStr), fieldsStr.length() - 1) == ',') {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invaid type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})));
                }
                String[] fields = fieldsStr.split(",");
                StructField[] structFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])fields).map((Function1)new Serializable(dataType){
                    public static final long serialVersionUID = 0L;
                    private final String dataType$1;

                    public final StructField apply(String field) {
                        String string = field;
                        Option option = SQLUtils$.MODULE$.org$apache$spark$sql$api$r$SQLUtils$$RegexContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\A(.+)", ":(.+)", "\\Z"}))).r().unapplySeq((CharSequence)string);
                        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                            String fieldName = (String)((LinearSeqOptimized)option.get()).apply(0);
                            String fieldType = (String)((LinearSeqOptimized)option.get()).apply(1);
                            StructField structField = SQLUtils$.MODULE$.createStructField(fieldName, fieldType, true);
                            return structField;
                        }
                        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invaid type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dataType$1})));
                    }
                    {
                        this.dataType$1 = dataType$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
                byteType$ = this.createStructType((Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])structFields));
            }
            return byteType$;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invaid type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType})));
    }

    public StructField createStructField(String name, String dataType, boolean nullable) {
        DataType dtObj = this.getSQLDataType(dataType);
        return new StructField(name, dtObj, nullable, StructField$.MODULE$.apply$default$4());
    }

    public DataFrame createDF(RDD<byte[]> rdd2, StructType schema2, SQLContext sqlContext) {
        int num = Predef$.MODULE$.refArrayOps((Object[])schema2.fields()).size();
        RDD rowRDD = rdd2.map((Function1)new Serializable(schema2){
            public static final long serialVersionUID = 0L;
            private final StructType schema$1;

            public final Row apply(byte[] x$2) {
                return SQLUtils$.MODULE$.org$apache$spark$sql$api$r$SQLUtils$$bytesToRow(x$2, this.schema$1);
            }
            {
                this.schema$1 = schema$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        return sqlContext.createDataFrame((RDD<Row>)rowRDD, schema2);
    }

    public JavaRDD<byte[]> dfToRowRDD(DataFrame df) {
        return JavaRDD$.MODULE$.fromRDD(df.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final byte[] apply(Row r2) {
                return SQLUtils$.MODULE$.org$apache$spark$sql$api$r$SQLUtils$$rowToRBytes(r2);
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object org$apache$spark$sql$api$r$SQLUtils$$doConversion(Object data, DataType dataType) {
        Object object = data;
        if (!(object instanceof Double)) return data;
        Double d = (Double)object;
        DataType dataType2 = dataType;
        FloatType$ floatType$ = FloatType$.MODULE$;
        if (dataType2 != null) {
            if (!dataType2.equals(floatType$)) return data;
            return new Float(Predef$.MODULE$.Double2double(d));
        }
        if (floatType$ == null) return new Float(Predef$.MODULE$.Double2double(d));
        return data;
    }

    public Row org$apache$spark$sql$api$r$SQLUtils$$bytesToRow(byte[] bytes, StructType schema2) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bis);
        int num = SerDe$.MODULE$.readInt(dis);
        return Row$.MODULE$.fromSeq((Seq)((scala.collection.immutable.Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), num).map((Function1)new Serializable(schema2, dis){
            public static final long serialVersionUID = 0L;
            private final StructType schema$2;
            private final DataInputStream dis$1;

            public final Object apply(int i) {
                return SQLUtils$.MODULE$.org$apache$spark$sql$api$r$SQLUtils$$doConversion(SerDe$.MODULE$.readObject(this.dis$1), this.schema$2.fields()[i].dataType());
            }
            {
                this.schema$2 = schema$2;
                this.dis$1 = dis$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSeq());
    }

    public byte[] org$apache$spark$sql$api$r$SQLUtils$$rowToRBytes(Row row) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        Object[] cols = (Object[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.length()).map((Function1)new Serializable(row){
            public static final long serialVersionUID = 0L;
            private final Row row$1;

            public final Object apply(int x$3) {
                return this.row$1.apply(x$3);
            }
            {
                this.row$1 = row$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object());
        SerDe$.MODULE$.writeObject(dos, (Object)cols);
        return bos.toByteArray();
    }

    public Object[][] dfToCols(DataFrame df) {
        Row[] localDF = df.collect();
        int numCols = df.columns().length;
        int numRows = localDF.length;
        Object[][] colArray = new Object[numCols][];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numCols).foreach$mVc$sp((Function1)new Serializable(localDF, numRows, colArray){
            public static final long serialVersionUID = 0L;
            public final Row[] localDF$1;
            private final int numRows$1;
            public final Object[][] colArray$1;

            public final void apply(int colNo) {
                this.apply$mcVI$sp(colNo);
            }

            public void apply$mcVI$sp(int colNo) {
                this.colArray$1[colNo] = new Object[this.numRows$1];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numRows$1).foreach$mVc$sp((Function1)new Serializable(this, colNo){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.dfToCols.1 $outer;
                    private final int colNo$1;

                    public final void apply(int rowNo) {
                        this.apply$mcVI$sp(rowNo);
                    }

                    public void apply$mcVI$sp(int rowNo) {
                        this.$outer.colArray$1[this.colNo$1][rowNo] = this.$outer.localDF$1[rowNo].apply(this.colNo$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.colNo$1 = colNo$1;
                    }
                });
            }
            {
                this.localDF$1 = localDF$1;
                this.numRows$1 = numRows$1;
                this.colArray$1 = colArray$1;
            }
        });
        return colArray;
    }

    public SaveMode saveMode(String mode) {
        String string;
        block6: {
            SaveMode saveMode;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            string = mode;
                            if (!"append".equals(string)) break block2;
                            saveMode = SaveMode.Append;
                            break block3;
                        }
                        if (!"overwrite".equals(string)) break block4;
                        saveMode = SaveMode.Overwrite;
                        break block3;
                    }
                    if (!"error".equals(string)) break block5;
                    saveMode = SaveMode.ErrorIfExists;
                    break block3;
                }
                if (!"ignore".equals(string)) break block6;
                saveMode = SaveMode.Ignore;
            }
            return saveMode;
        }
        throw new MatchError((Object)string);
    }

    public DataFrame loadDF(SQLContext sqlContext, String source, Map<String, String> options2) {
        return sqlContext.read().format(source).options(options2).load();
    }

    public DataFrame loadDF(SQLContext sqlContext, String source, StructType schema2, Map<String, String> options2) {
        return sqlContext.read().format(source).schema(schema2).options(options2).load();
    }

    public Object readSqlObject(DataInputStream dis, char dataType) {
        Row row;
        char c = dataType;
        switch (c) {
            default: {
                row = null;
                break;
            }
            case 's': {
                Object[] fields = SerDe$.MODULE$.readList(dis);
                row = Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.wrapRefArray(fields));
            }
        }
        return row;
    }

    public boolean writeSqlObject(DataOutputStream dos, Object obj) {
        boolean bl;
        Object object = obj;
        if (object instanceof GenericRowWithSchema) {
            GenericRowWithSchema genericRowWithSchema = (GenericRowWithSchema)object;
            dos.writeByte(115);
            SerDe$.MODULE$.writeObject(dos, (Object)genericRowWithSchema.schema().fieldNames());
            SerDe$.MODULE$.writeObject(dos, (Object)genericRowWithSchema.values());
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private SQLUtils$() {
        MODULE$ = this;
        SerDe$.MODULE$.registerSqlSerDe(new Tuple2((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(DataInputStream dis, char dataType) {
                return SQLUtils$.MODULE$.readSqlObject(dis, dataType);
            }
        }, (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(DataOutputStream dos, Object obj) {
                return SQLUtils$.MODULE$.writeSqlObject(dos, obj);
            }
        }));
    }
}

