/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.Preconditions;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.ValuesType;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.BufferHolder;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.execution.datasources.parquet.CatalystRowConverter;
import org.apache.spark.sql.execution.datasources.parquet.CatalystSchemaConverter;
import org.apache.spark.sql.execution.datasources.parquet.SpecificParquetRecordReaderBase;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.UTF8String;

public class UnsafeRowParquetRecordReader
extends SpecificParquetRecordReaderBase<UnsafeRow> {
    private UnsafeRow[] rows = new UnsafeRow[64];
    private int batchIdx = 0;
    private int numBatched = 0;
    private UnsafeRowWriter[] rowWriters = null;
    private boolean containsVarLenFields;
    private int fixedSizeBytes;
    private ColumnReader[] columnReaders;
    private long rowsReturned;
    private long totalCountLoadedSoFar = 0L;
    private OriginalType[] originalTypes;
    private static final int DEFAULT_VAR_LEN_SIZE = 32;

    public boolean tryInitialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
        try {
            this.initialize(inputSplit, taskAttemptContext);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        super.initialize(inputSplit, taskAttemptContext);
        if (this.requestedSchema.getFieldCount() == 0) {
            throw new IOException("Empty request schema not supported.");
        }
        int numVarLenFields = 0;
        this.originalTypes = new OriginalType[this.requestedSchema.getFieldCount()];
        for (int i = 0; i < this.requestedSchema.getFieldCount(); ++i) {
            Type t = (Type)this.requestedSchema.getFields().get(i);
            if (!t.isPrimitive() || t.isRepetition(Type.Repetition.REPEATED)) {
                throw new IOException("Complex types not supported.");
            }
            PrimitiveType primitiveType = t.asPrimitiveType();
            this.originalTypes[i] = t.getOriginalType();
            if (this.originalTypes[i] != null && this.originalTypes[i] != OriginalType.DECIMAL && this.originalTypes[i] != OriginalType.UTF8 && this.originalTypes[i] != OriginalType.DATE) {
                throw new IOException("Unsupported type: " + t);
            }
            if (this.originalTypes[i] == OriginalType.DECIMAL && primitiveType.getDecimalMetadata().getPrecision() > CatalystSchemaConverter.MAX_PRECISION_FOR_INT64()) {
                throw new IOException("Decimal with high precision is not supported.");
            }
            if (primitiveType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT96) {
                throw new IOException("Int96 not supported.");
            }
            ColumnDescriptor fd = this.fileSchema.getColumnDescription((String[])this.requestedSchema.getPaths().get(i));
            if (!fd.equals(this.requestedSchema.getColumns().get(i))) {
                throw new IOException("Schema evolution not supported.");
            }
            if (primitiveType.getPrimitiveTypeName() != PrimitiveType.PrimitiveTypeName.BINARY) continue;
            ++numVarLenFields;
        }
        int rowByteSize = UnsafeRow.calculateBitSetWidthInBytes((int)this.requestedSchema.getFieldCount());
        this.fixedSizeBytes = rowByteSize += 8 * this.requestedSchema.getFieldCount();
        rowByteSize += numVarLenFields * 32;
        this.containsVarLenFields = numVarLenFields > 0;
        this.rowWriters = new UnsafeRowWriter[this.rows.length];
        for (int i = 0; i < this.rows.length; ++i) {
            this.rows[i] = new UnsafeRow();
            this.rowWriters[i] = new UnsafeRowWriter();
            BufferHolder holder = new BufferHolder(rowByteSize);
            this.rowWriters[i].initialize(this.rows[i], holder, this.requestedSchema.getFieldCount());
            this.rows[i].pointTo((Object)holder.buffer, (long)Platform.BYTE_ARRAY_OFFSET, this.requestedSchema.getFieldCount(), holder.buffer.length);
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.batchIdx >= this.numBatched && !this.loadBatch()) {
            return false;
        }
        ++this.batchIdx;
        return true;
    }

    public UnsafeRow getCurrentValue() throws IOException, InterruptedException {
        return this.rows[this.batchIdx - 1];
    }

    public float getProgress() throws IOException, InterruptedException {
        return (float)this.rowsReturned / (float)this.totalRowCount;
    }

    private boolean loadBatch() throws IOException {
        int i;
        if (this.rowsReturned >= this.totalRowCount) {
            return false;
        }
        this.checkEndOfRowGroup();
        int num = (int)Math.min((long)this.rows.length, this.totalCountLoadedSoFar - this.rowsReturned);
        this.rowsReturned += (long)num;
        if (this.containsVarLenFields) {
            for (i = 0; i < this.rowWriters.length; ++i) {
                this.rowWriters[i].holder().resetTo(this.fixedSizeBytes);
            }
        }
        for (i = 0; i < this.columnReaders.length; ++i) {
            switch (this.columnReaders[i].descriptor.getType()) {
                case BOOLEAN: {
                    this.decodeBooleanBatch(i, num);
                    break;
                }
                case INT32: {
                    if (this.originalTypes[i] == OriginalType.DECIMAL) {
                        this.decodeIntAsDecimalBatch(i, num);
                        break;
                    }
                    this.decodeIntBatch(i, num);
                    break;
                }
                case INT64: {
                    Preconditions.checkState((this.originalTypes[i] == null || this.originalTypes[i] == OriginalType.DECIMAL ? 1 : 0) != 0, (String)("Unexpected original type: " + this.originalTypes[i]));
                    this.decodeLongBatch(i, num);
                    break;
                }
                case FLOAT: {
                    this.decodeFloatBatch(i, num);
                    break;
                }
                case DOUBLE: {
                    this.decodeDoubleBatch(i, num);
                    break;
                }
                case BINARY: {
                    this.decodeBinaryBatch(i, num);
                    break;
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    Preconditions.checkState((this.originalTypes[i] == OriginalType.DECIMAL ? 1 : 0) != 0, (String)("Unexpected original type: " + this.originalTypes[i]));
                    this.decodeFixedLenArrayAsDecimalBatch(i, num);
                    break;
                }
                case INT96: {
                    throw new IOException("Unsupported " + this.columnReaders[i].descriptor.getType());
                }
            }
            this.numBatched = num;
            this.batchIdx = 0;
        }
        return true;
    }

    private void decodeBooleanBatch(int col, int num) throws IOException {
        for (int n = 0; n < num; ++n) {
            if (this.columnReaders[col].next()) {
                this.rows[n].setBoolean(col, this.columnReaders[col].nextBoolean());
                continue;
            }
            this.rows[n].setNullAt(col);
        }
    }

    private void decodeIntBatch(int col, int num) throws IOException {
        for (int n = 0; n < num; ++n) {
            if (this.columnReaders[col].next()) {
                this.rows[n].setInt(col, this.columnReaders[col].nextInt());
                continue;
            }
            this.rows[n].setNullAt(col);
        }
    }

    private void decodeIntAsDecimalBatch(int col, int num) throws IOException {
        for (int n = 0; n < num; ++n) {
            if (this.columnReaders[col].next()) {
                this.rows[n].setLong(col, (long)this.columnReaders[col].nextInt());
                continue;
            }
            this.rows[n].setNullAt(col);
        }
    }

    private void decodeLongBatch(int col, int num) throws IOException {
        for (int n = 0; n < num; ++n) {
            if (this.columnReaders[col].next()) {
                this.rows[n].setLong(col, this.columnReaders[col].nextLong());
                continue;
            }
            this.rows[n].setNullAt(col);
        }
    }

    private void decodeFloatBatch(int col, int num) throws IOException {
        for (int n = 0; n < num; ++n) {
            if (this.columnReaders[col].next()) {
                this.rows[n].setFloat(col, this.columnReaders[col].nextFloat());
                continue;
            }
            this.rows[n].setNullAt(col);
        }
    }

    private void decodeDoubleBatch(int col, int num) throws IOException {
        for (int n = 0; n < num; ++n) {
            if (this.columnReaders[col].next()) {
                this.rows[n].setDouble(col, this.columnReaders[col].nextDouble());
                continue;
            }
            this.rows[n].setNullAt(col);
        }
    }

    private void decodeBinaryBatch(int col, int num) throws IOException {
        for (int n = 0; n < num; ++n) {
            if (this.columnReaders[col].next()) {
                ByteBuffer bytes = this.columnReaders[col].nextBinary().toByteBuffer();
                int len = bytes.limit() - bytes.position();
                if (this.originalTypes[col] == OriginalType.UTF8) {
                    UTF8String str = UTF8String.fromBytes((byte[])bytes.array(), (int)bytes.position(), (int)len);
                    this.rowWriters[n].write(col, str);
                } else {
                    this.rowWriters[n].write(col, bytes.array(), bytes.position(), len);
                }
                this.rows[n].setNotNullAt(col);
                continue;
            }
            this.rows[n].setNullAt(col);
        }
    }

    private void decodeFixedLenArrayAsDecimalBatch(int col, int num) throws IOException {
        PrimitiveType type = ((Type)this.requestedSchema.getFields().get(col)).asPrimitiveType();
        int precision = type.getDecimalMetadata().getPrecision();
        int scale = type.getDecimalMetadata().getScale();
        Preconditions.checkState((precision <= CatalystSchemaConverter.MAX_PRECISION_FOR_INT64() ? 1 : 0) != 0, (String)"Unsupported precision.");
        for (int n = 0; n < num; ++n) {
            if (this.columnReaders[col].next()) {
                Binary v = this.columnReaders[col].nextBinary();
                long unscaled = CatalystRowConverter.binaryToUnscaledLong(v);
                this.rows[n].setDecimal(col, Decimal.apply((long)unscaled, (int)precision, (int)scale), precision);
                continue;
            }
            this.rows[n].setNullAt(col);
        }
    }

    private void checkEndOfRowGroup() throws IOException {
        if (this.rowsReturned != this.totalCountLoadedSoFar) {
            return;
        }
        PageReadStore pages = this.reader.readNextRowGroup();
        if (pages == null) {
            throw new IOException("expecting more rows but reached last block. Read " + this.rowsReturned + " out of " + this.totalRowCount);
        }
        List columns2 = this.requestedSchema.getColumns();
        this.columnReaders = new ColumnReader[columns2.size()];
        for (int i = 0; i < columns2.size(); ++i) {
            this.columnReaders[i] = new ColumnReader((ColumnDescriptor)columns2.get(i), pages.getPageReader((ColumnDescriptor)columns2.get(i)));
        }
        this.totalCountLoadedSoFar += pages.getRowCount();
    }

    private static final class ColumnReader {
        private long valuesRead;
        private long endOfPageValueCount;
        private final Dictionary dictionary;
        private boolean useDictionary;
        private final int maxDefLevel;
        private SpecificParquetRecordReaderBase.IntIterator repetitionLevelColumn;
        private SpecificParquetRecordReaderBase.IntIterator definitionLevelColumn;
        private ValuesReader dataColumn;
        private final long totalValueCount;
        private int pageValueCount;
        private final PageReader pageReader;
        private final ColumnDescriptor descriptor;

        public ColumnReader(ColumnDescriptor descriptor, PageReader pageReader) throws IOException {
            this.descriptor = descriptor;
            this.pageReader = pageReader;
            this.maxDefLevel = descriptor.getMaxDefinitionLevel();
            DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
            if (dictionaryPage != null) {
                try {
                    this.dictionary = dictionaryPage.getEncoding().initDictionary(descriptor, dictionaryPage);
                    this.useDictionary = true;
                }
                catch (IOException e) {
                    throw new IOException("could not decode the dictionary for " + descriptor, e);
                }
            } else {
                this.dictionary = null;
                this.useDictionary = false;
            }
            this.totalValueCount = pageReader.getTotalValueCount();
            if (this.totalValueCount == 0L) {
                throw new IOException("totalValueCount == 0");
            }
        }

        public boolean nextBoolean() {
            if (!this.useDictionary) {
                return this.dataColumn.readBoolean();
            }
            return this.dictionary.decodeToBoolean(this.dataColumn.readValueDictionaryId());
        }

        public int nextInt() {
            if (!this.useDictionary) {
                return this.dataColumn.readInteger();
            }
            return this.dictionary.decodeToInt(this.dataColumn.readValueDictionaryId());
        }

        public long nextLong() {
            if (!this.useDictionary) {
                return this.dataColumn.readLong();
            }
            return this.dictionary.decodeToLong(this.dataColumn.readValueDictionaryId());
        }

        public float nextFloat() {
            if (!this.useDictionary) {
                return this.dataColumn.readFloat();
            }
            return this.dictionary.decodeToFloat(this.dataColumn.readValueDictionaryId());
        }

        public double nextDouble() {
            if (!this.useDictionary) {
                return this.dataColumn.readDouble();
            }
            return this.dictionary.decodeToDouble(this.dataColumn.readValueDictionaryId());
        }

        public Binary nextBinary() {
            if (!this.useDictionary) {
                return this.dataColumn.readBytes();
            }
            return this.dictionary.decodeToBinary(this.dataColumn.readValueDictionaryId());
        }

        private boolean next() throws IOException {
            if (this.valuesRead >= this.endOfPageValueCount) {
                if (this.valuesRead >= this.totalValueCount) {
                    return false;
                }
                this.readPage();
            }
            ++this.valuesRead;
            return this.definitionLevelColumn.nextInt() == this.maxDefLevel;
        }

        private void readPage() throws IOException {
            DataPage page = this.pageReader.readPage();
            page.accept((DataPage.Visitor)new DataPage.Visitor<Void>(){

                public Void visit(DataPageV1 dataPageV1) {
                    try {
                        ColumnReader.this.readPageV1(dataPageV1);
                        return null;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public Void visit(DataPageV2 dataPageV2) {
                    try {
                        ColumnReader.this.readPageV2(dataPageV2);
                        return null;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        private void initDataReader(Encoding dataEncoding, byte[] bytes, int offset, int valueCount) throws IOException {
            this.pageValueCount = valueCount;
            this.endOfPageValueCount = this.valuesRead + (long)this.pageValueCount;
            if (dataEncoding.usesDictionary()) {
                if (this.dictionary == null) {
                    throw new IOException("could not read page in col " + this.descriptor + " as the dictionary was missing for encoding " + dataEncoding);
                }
                this.dataColumn = dataEncoding.getDictionaryBasedValuesReader(this.descriptor, ValuesType.VALUES, this.dictionary);
                this.useDictionary = true;
            } else {
                this.dataColumn = dataEncoding.getValuesReader(this.descriptor, ValuesType.VALUES);
                this.useDictionary = false;
            }
            try {
                this.dataColumn.initFromPage(this.pageValueCount, bytes, offset);
            }
            catch (IOException e) {
                throw new IOException("could not read page in col " + this.descriptor, e);
            }
        }

        private void readPageV1(DataPageV1 page) throws IOException {
            ValuesReader rlReader = page.getRlEncoding().getValuesReader(this.descriptor, ValuesType.REPETITION_LEVEL);
            ValuesReader dlReader = page.getDlEncoding().getValuesReader(this.descriptor, ValuesType.DEFINITION_LEVEL);
            this.repetitionLevelColumn = new SpecificParquetRecordReaderBase.ValuesReaderIntIterator(rlReader);
            this.definitionLevelColumn = new SpecificParquetRecordReaderBase.ValuesReaderIntIterator(dlReader);
            try {
                byte[] bytes = page.getBytes().toByteArray();
                rlReader.initFromPage(this.pageValueCount, bytes, 0);
                int next2 = rlReader.getNextOffset();
                dlReader.initFromPage(this.pageValueCount, bytes, next2);
                next2 = dlReader.getNextOffset();
                this.initDataReader(page.getValueEncoding(), bytes, next2, page.getValueCount());
            }
            catch (IOException e) {
                throw new IOException("could not read page " + page + " in col " + this.descriptor, e);
            }
        }

        private void readPageV2(DataPageV2 page) throws IOException {
            this.repetitionLevelColumn = SpecificParquetRecordReaderBase.createRLEIterator(this.descriptor.getMaxRepetitionLevel(), page.getRepetitionLevels(), this.descriptor);
            this.definitionLevelColumn = SpecificParquetRecordReaderBase.createRLEIterator(this.descriptor.getMaxDefinitionLevel(), page.getDefinitionLevels(), this.descriptor);
            try {
                this.initDataReader(page.getDataEncoding(), page.getData().toByteArray(), 0, page.getValueCount());
            }
            catch (IOException e) {
                throw new IOException("could not read page " + page + " in col " + this.descriptor, e);
            }
        }
    }
}

