/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.spark.Logging;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRDD;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRDD$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcDialects$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class JDBCRDD$
implements Logging,
Serializable {
    public static final JDBCRDD$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new JDBCRDD$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public DataType org$apache$spark$sql$execution$datasources$jdbc$JDBCRDD$$getCatalystType(int sqlType, int precision, int scale, boolean signed) {
        StringType$ answer;
        int n = sqlType;
        switch (n) {
            default: {
                StringType$ stringType$ = null;
                break;
            }
            case 12: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case -3: {
                StringType$ stringType$ = BinaryType$.MODULE$;
                break;
            }
            case -6: {
                StringType$ stringType$ = IntegerType$.MODULE$;
                break;
            }
            case 93: {
                StringType$ stringType$ = TimestampType$.MODULE$;
                break;
            }
            case 92: {
                StringType$ stringType$ = TimestampType$.MODULE$;
                break;
            }
            case 2002: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 2009: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 5: {
                StringType$ stringType$ = IntegerType$.MODULE$;
                break;
            }
            case -8: {
                StringType$ stringType$ = LongType$.MODULE$;
                break;
            }
            case 2006: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 7: {
                StringType$ stringType$ = DoubleType$.MODULE$;
                break;
            }
            case 1111: {
                StringType$ stringType$ = null;
                break;
            }
            case -9: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 2: {
                StringType$ stringType$;
                if (precision != 0 || scale != 0) {
                    stringType$ = DecimalType$.MODULE$.bounded(precision, scale);
                    break;
                }
                stringType$ = DecimalType$.MODULE$.SYSTEM_DEFAULT();
                break;
            }
            case 0: {
                StringType$ stringType$ = null;
                break;
            }
            case 2011: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case -15: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case -1: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case -4: {
                StringType$ stringType$ = BinaryType$.MODULE$;
                break;
            }
            case -16: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 2000: {
                StringType$ stringType$ = null;
                break;
            }
            case 4: {
                StringType$ stringType$;
                if (signed) {
                    stringType$ = IntegerType$.MODULE$;
                    break;
                }
                stringType$ = LongType$.MODULE$;
                break;
            }
            case 6: {
                StringType$ stringType$ = FloatType$.MODULE$;
                break;
            }
            case 8: {
                StringType$ stringType$ = DoubleType$.MODULE$;
                break;
            }
            case 2001: {
                StringType$ stringType$ = null;
                break;
            }
            case 3: {
                StringType$ stringType$;
                if (precision != 0 || scale != 0) {
                    stringType$ = DecimalType$.MODULE$.bounded(precision, scale);
                    break;
                }
                stringType$ = DecimalType$.MODULE$.SYSTEM_DEFAULT();
                break;
            }
            case 91: {
                StringType$ stringType$ = DateType$.MODULE$;
                break;
            }
            case 70: {
                StringType$ stringType$ = null;
                break;
            }
            case 2005: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 1: {
                StringType$ stringType$ = StringType$.MODULE$;
                break;
            }
            case 16: {
                StringType$ stringType$ = BooleanType$.MODULE$;
                break;
            }
            case 2004: {
                StringType$ stringType$ = BinaryType$.MODULE$;
                break;
            }
            case -7: {
                StringType$ stringType$ = BooleanType$.MODULE$;
                break;
            }
            case -2: {
                StringType$ stringType$ = BinaryType$.MODULE$;
                break;
            }
            case -5: {
                StringType$ stringType$;
                if (signed) {
                    stringType$ = LongType$.MODULE$;
                    break;
                }
                stringType$ = new DecimalType(20, 0);
                break;
            }
            case 2003: {
                StringType$ stringType$ = answer = null;
            }
        }
        if (answer == null) {
            throw new SQLException(new StringBuilder().append((Object)"Unsupported type ").append((Object)BoxesRunTime.boxToInteger((int)sqlType)).toString());
        }
        return answer;
    }

    public StructType resolveTable(String url, String table, Properties properties) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        Connection conn = (Connection)this.getConnector(properties.getProperty("driver"), url, properties).apply();
        try {
            StructType structType;
            ResultSet rs = conn.prepareStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT * FROM ", " WHERE 1=0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}))).executeQuery();
            try {
                ResultSetMetaData rsmd = rs.getMetaData();
                int ncols = rsmd.getColumnCount();
                StructField[] fields = new StructField[ncols];
                for (int i = 0; i < ncols; ++i) {
                    String columnName = rsmd.getColumnLabel(i + 1);
                    int dataType = rsmd.getColumnType(i + 1);
                    String typeName = rsmd.getColumnTypeName(i + 1);
                    int fieldSize = rsmd.getPrecision(i + 1);
                    int fieldScale = rsmd.getScale(i + 1);
                    boolean isSigned = rsmd.isSigned(i + 1);
                    boolean nullable = rsmd.isNullable(i + 1) != 0;
                    MetadataBuilder metadata = new MetadataBuilder().putString("name", columnName);
                    DataType columnType = (DataType)dialect.getCatalystType(dataType, typeName, fieldSize, metadata).getOrElse((Function0)new Serializable(dataType, fieldSize, fieldScale, isSigned){
                        public static final long serialVersionUID = 0L;
                        private final int dataType$1;
                        private final int fieldSize$1;
                        private final int fieldScale$1;
                        private final boolean isSigned$1;

                        public final DataType apply() {
                            return JDBCRDD$.MODULE$.org$apache$spark$sql$execution$datasources$jdbc$JDBCRDD$$getCatalystType(this.dataType$1, this.fieldSize$1, this.fieldScale$1, this.isSigned$1);
                        }
                        {
                            this.dataType$1 = dataType$1;
                            this.fieldSize$1 = fieldSize$1;
                            this.fieldScale$1 = fieldScale$1;
                            this.isSigned$1 = isSigned$1;
                        }
                    });
                    fields[i] = new StructField(columnName, columnType, nullable, metadata.build());
                }
                structType = new StructType(fields);
            }
            catch (Throwable throwable) {
                rs.close();
                throw throwable;
            }
            rs.close();
            return structType;
        }
        finally {
            conn.close();
        }
    }

    private StructType pruneSchema(StructType schema2, String[] columns2) {
        Map fieldMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])schema2.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, StructField> apply(StructField x) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)x.metadata().getString("name")), (Object)x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))));
        return new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])columns2).map((Function1)new Serializable(fieldMap){
            public static final long serialVersionUID = 0L;
            private final Map fieldMap$1;

            public final StructField apply(String name) {
                return (StructField)this.fieldMap$1.apply((Object)name);
            }
            {
                this.fieldMap$1 = fieldMap$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
    }

    public Function0<Connection> getConnector(String driver, String url, Properties properties) {
        return new Serializable(driver, url, properties){
            public static final long serialVersionUID = 0L;
            public final String driver$1;
            private final String url$1;
            private final Properties properties$1;

            public final Connection apply() {
                try {
                    if (this.driver$1 != null) {
                        DriverRegistry$.MODULE$.register(this.driver$1);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    JDBCRDD$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.getConnector.1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't find class ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.driver$1}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, classNotFoundException);
                }
                return DriverManager.getConnection(this.url$1, this.properties$1);
            }
            {
                this.driver$1 = driver$1;
                this.url$1 = url$1;
                this.properties$1 = properties$1;
            }
        };
    }

    public RDD<InternalRow> scanTable(SparkContext sc, StructType schema2, String driver, String url, Properties properties, String fqTable, String[] requiredColumns, Filter[] filters, Partition[] parts) {
        JdbcDialect dialect = JdbcDialects$.MODULE$.get(url);
        String[] quotedColumns = (String[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns).map((Function1)new Serializable(dialect){
            public static final long serialVersionUID = 0L;
            private final JdbcDialect dialect$1;

            public final String apply(String colName) {
                return this.dialect$1.quoteIdentifier(colName);
            }
            {
                this.dialect$1 = dialect$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return new JDBCRDD(sc, this.getConnector(driver, url, properties), this.pruneSchema(schema2, requiredColumns), fqTable, quotedColumns, filters, parts, url, properties);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private JDBCRDD$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

